/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.SB;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.RadiusData;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;

public class Dots
extends AtomShape {
    public EnvelopeCalculation ec;
    public boolean isSurface = false;
    static final float SURFACE_DISTANCE_FOR_CALCULATION = 10.0f;
    BS bsOn = new BS();
    private BS bsSelected;
    private BS bsIgnore;
    public static int MAX_LEVEL = 3;
    int thisAtom;
    float thisRadius;
    int thisArgb;
    RadiusData rdLast = new RadiusData(null, 0.0f, null, null);

    public void initShape() {
        super.initShape();
        this.translucentAllowed = false;
        this.ec = new EnvelopeCalculation().set((AtomDataServer)this.vwr, this.ac, this.mads);
    }

    public int getSize(int n) {
        return this.mads != null ? this.mads[n] * 2 : (this.bsOn.get(n) ? (int)Math.floor(this.ec.getRadius(n) * 2000.0f) : 0);
    }

    public void setProperty(String string, Object object, BS bS) {
        if ("init" == string) {
            this.initialize();
            return;
        }
        if ("translucency" == string && !this.translucentAllowed) {
            return;
        }
        if ("ignore" == string) {
            this.bsIgnore = (BS)object;
            return;
        }
        if ("select" == string) {
            this.bsSelected = (BS)object;
            return;
        }
        if ("radius" == string) {
            this.thisRadius = ((Float)object).floatValue();
            if (this.thisRadius > 16.0f) {
                this.thisRadius = 16.1f;
            }
            return;
        }
        if ("colorRGB" == string) {
            this.thisArgb = (Integer)object;
            return;
        }
        if ("atom" == string) {
            this.thisAtom = (Integer)object;
            if (this.thisAtom >= this.atoms.length) {
                return;
            }
            this.setShapeVisibility(this.atoms[this.thisAtom], true);
            this.ec.allocDotsConvexMaps(this.ac);
            return;
        }
        if ("dots" == string) {
            if (this.thisAtom >= this.atoms.length) {
                return;
            }
            this.isActive = true;
            this.ec.setFromBits(this.thisAtom, (BS)object);
            this.setShapeVisibility(this.atoms[this.thisAtom], true);
            if (this.mads == null) {
                this.ec.setMads(null);
                this.mads = new short[this.ac];
                for (int i = 0; i < this.ac; ++i) {
                    if (!this.atoms[i].isVisible(1 | this.vf)) continue;
                    try {
                        this.mads[i] = (short)(this.ec.getAppropriateRadius(i) * 1000.0f);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.ec.setMads(this.mads);
            }
            this.mads[this.thisAtom] = (short)(this.thisRadius * 1000.0f);
            if (this.colixes == null) {
                this.colixes = new short[this.ac];
                this.paletteIDs = new byte[this.ac];
            }
            this.colixes[this.thisAtom] = C.getColix((int)this.thisArgb);
            this.bsOn.set(this.thisAtom);
            return;
        }
        if ("refreshTrajectories" == string) {
            bS = (BS)((Object[])object)[1];
            M4 m4 = (M4)((Object[])object)[2];
            if (m4 == null) {
                return;
            }
            M3 m3 = new M3();
            m4.getRotationScale(m3);
            this.ec.reCalculate(bS, m3);
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[1];
            int n2 = ((int[])((Object[])object)[2])[2];
            BSUtil.deleteBits((BS)this.bsOn, (BS)bS);
            this.ec.deleteAtoms(n, n2);
        }
        this.setPropAS(string, object, bS);
    }

    void initialize() {
        this.bsSelected = null;
        this.bsIgnore = null;
        this.isActive = false;
        if (this.ec == null) {
            this.ec = new EnvelopeCalculation().set((AtomDataServer)this.vwr, this.ac, this.mads);
        }
    }

    protected void setSizeRD(RadiusData radiusData, BS bS) {
        BS[] bSArray;
        int n;
        int n2;
        boolean bl;
        float f;
        if (radiusData == null) {
            radiusData = new RadiusData(null, 0.0f, RadiusData.EnumType.ABSOLUTE, null);
        }
        if (this.bsSelected != null) {
            bS = this.bsSelected;
        }
        boolean bl2 = true;
        float f2 = Float.MAX_VALUE;
        this.isActive = true;
        switch (radiusData.factorType) {
            case OFFSET: {
                break;
            }
            case ABSOLUTE: {
                if (radiusData.value == 0.0f) {
                    bl2 = false;
                }
                f2 = radiusData.value;
            }
            default: {
                radiusData.valueExtended = this.vwr.getCurrentSolventProbeRadius();
            }
        }
        switch (radiusData.vdwType) {
            case ADPMIN: 
            case ADPMAX: 
            case HYDRO: 
            case TEMP: {
                f = f2;
                break;
            }
            case BONDING: {
                f = this.ms.getMaxVanderwaalsRadius() * 2.0f;
                break;
            }
            default: {
                f = this.ms.getMaxVanderwaalsRadius();
            }
        }
        boolean bl3 = bl = this.rdLast.value != radiusData.value || this.rdLast.valueExtended != radiusData.valueExtended || this.rdLast.factorType != radiusData.factorType || this.rdLast.vdwType != radiusData.vdwType || this.ec.getDotsConvexMax() == 0;
        if (bl2) {
            n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                if (!this.bsOn.get(n2)) {
                    this.bsOn.set(n2);
                    bl = true;
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
        } else {
            n2 = bS == null ? 1 : 0;
            int n3 = n = n2 != 0 ? this.ac - 1 : bS.nextSetBit(0);
            while (n3 >= 0) {
                this.bsOn.setBitTo(n3, false);
                n3 = n2 != 0 ? n3 - 1 : bS.nextSetBit(n3 + 1);
            }
        }
        n2 = this.ac;
        while (--n2 >= 0) {
            this.atoms[n2].setShapeVisibility(this.vf, this.bsOn.get(n2));
        }
        if (!bl2) {
            return;
        }
        if (bl) {
            this.mads = null;
            this.ec.newSet();
        }
        if ((bSArray = this.ec.getDotsConvexMaps()) != null) {
            n = this.ac;
            while (--n >= 0) {
                if (!this.bsOn.get(n)) continue;
                bSArray[n] = null;
            }
        }
        if (bSArray == null && (this.colixes == null || this.colixes.length != this.ac)) {
            this.colixes = new short[this.ac];
            this.paletteIDs = new byte[this.ac];
        }
        this.ec.calculate(radiusData, f, this.bsOn, this.bsIgnore, !this.vwr.getBoolean(603979830), this.vwr.getBoolean(603979829), this.isSurface, true);
        this.rdLast = radiusData;
    }

    public void setAtomClickability() {
        int n = this.ac;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if ((atom.shapeVisibilityFlags & this.vf) == 0 || this.ms.isAtomHidden(n)) continue;
            atom.setClickable(this.vf);
        }
    }

    public String getShapeState() {
        BS[] bSArray = this.ec.getDotsConvexMaps();
        if (bSArray == null || this.ec.getDotsConvexMax() == 0) {
            return "";
        }
        SB sB = new SB();
        Hashtable hashtable = new Hashtable();
        int n = this.vwr.ms.ac;
        String string = this.isSurface ? "geoSurface " : "dots ";
        for (int i = 0; i < n; ++i) {
            BS bS;
            if (!this.bsOn.get(i) || bSArray[i] == null) continue;
            if (this.bsColixSet != null && this.bsColixSet.get(i)) {
                BSUtil.setMapBitSet(hashtable, (int)i, (int)i, (String)Dots.getColorCommand((String)string, (byte)this.paletteIDs[i], (short)this.colixes[i], (boolean)this.translucentAllowed));
            }
            if ((bS = bSArray[i]).isEmpty()) continue;
            float f = this.ec.getAppropriateRadius(i);
            Dots.appendCmd((SB)sB, (String)(string + i + " radius " + f + " " + Escape.eBS((BS)bS)));
        }
        return sB.append(this.vwr.getCommands(hashtable, null, "select")).toString();
    }
}

