/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;

public class SimpleUnitCell {
    protected float[] notionalUnitcell;
    public M4 matrixCartesianToFractional;
    public M4 matrixFractionalToCartesian;
    public double volume;
    protected static final float toRadians = (float)Math.PI / 180;
    private int na;
    private int nb;
    private int nc;
    protected float a;
    protected float b;
    protected float c;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected double cosAlpha;
    protected double sinAlpha;
    protected double cosBeta;
    protected double sinBeta;
    protected double cosGamma;
    protected double sinGamma;
    protected double cA_;
    protected double cB_;
    protected double a_;
    protected double b_;
    protected double c_;
    protected int dimension;
    private P3 fractionalOrigin = new P3();
    protected M4 matrixCtoFANoOffset;
    protected M4 matrixFtoCNoOffset;
    public static final int INFO_DIMENSIONS = 6;
    public static final int INFO_GAMMA = 5;
    public static final int INFO_BETA = 4;
    public static final int INFO_ALPHA = 3;
    public static final int INFO_C = 2;
    public static final int INFO_B = 1;
    public static final int INFO_A = 0;

    public boolean isSupercell() {
        return this.na > 1 || this.nb > 1 || this.nc > 1;
    }

    public static boolean isValid(float[] fArray) {
        return fArray != null && (fArray[0] > 0.0f || fArray.length > 14 && !Float.isNaN(fArray[14]));
    }

    protected SimpleUnitCell() {
    }

    public static SimpleUnitCell newA(float[] fArray) {
        SimpleUnitCell simpleUnitCell = new SimpleUnitCell();
        simpleUnitCell.init(fArray);
        return simpleUnitCell;
    }

    protected void init(float[] fArray) {
        Object object;
        if (fArray == null) {
            fArray = new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f};
        }
        if (!SimpleUnitCell.isValid(fArray)) {
            return;
        }
        this.notionalUnitcell = AU.arrayCopyF(fArray, fArray.length);
        this.a = fArray[0];
        this.b = fArray[1];
        this.c = fArray[2];
        this.alpha = fArray[3];
        this.beta = fArray[4];
        this.gamma = fArray[5];
        this.na = Math.max(1, fArray.length >= 25 && !Float.isNaN(fArray[22]) ? (int)fArray[22] : 1);
        this.nb = Math.max(1, fArray.length >= 25 && !Float.isNaN(fArray[23]) ? (int)fArray[23] : 1);
        this.nc = Math.max(1, fArray.length >= 25 && !Float.isNaN(fArray[24]) ? (int)fArray[24] : 1);
        if (this.a <= 0.0f) {
            object = V3.new3(fArray[6], fArray[7], fArray[8]);
            V3 v3 = V3.new3(fArray[9], fArray[10], fArray[11]);
            V3 v32 = V3.new3(fArray[12], fArray[13], fArray[14]);
            this.setABC((V3)object, v3, v32);
            if (this.c < 0.0f) {
                float[] fArray2 = AU.arrayCopyF(fArray, -1);
                if (this.b < 0.0f) {
                    v3.set(0.0f, 0.0f, 1.0f);
                    v3.cross(v3, (T3)object);
                    if (v3.length() < 0.001f) {
                        v3.set(0.0f, 1.0f, 0.0f);
                    }
                    v3.normalize();
                    fArray2[9] = v3.x;
                    fArray2[10] = v3.y;
                    fArray2[11] = v3.z;
                }
                if (this.c < 0.0f) {
                    v32.cross((T3)object, v3);
                    v32.normalize();
                    fArray2[12] = v32.x;
                    fArray2[13] = v32.y;
                    fArray2[14] = v32.z;
                }
                fArray = fArray2;
            }
        }
        this.a *= (float)this.na;
        if (this.b <= 0.0f) {
            this.c = 1.0f;
            this.b = 1.0f;
            this.dimension = 1;
        } else if (this.c <= 0.0f) {
            this.c = 1.0f;
            this.b *= (float)this.nb;
            this.dimension = 2;
        } else {
            this.b *= (float)this.nb;
            this.c *= (float)this.nc;
            this.dimension = 3;
        }
        this.setCellParams();
        if (fArray.length > 21 && !Float.isNaN(fArray[21])) {
            object = new float[16];
            for (int i = 0; i < 16; ++i) {
                float f;
                switch (i % 4) {
                    case 0: {
                        f = this.na;
                        break;
                    }
                    case 1: {
                        f = this.nb;
                        break;
                    }
                    case 2: {
                        f = this.nc;
                        break;
                    }
                    default: {
                        f = 1.0f;
                    }
                }
                object[i] = fArray[6 + i] * f;
            }
            this.matrixCartesianToFractional = M4.newA16((float[])object);
            this.matrixCartesianToFractional.getTranslation(this.fractionalOrigin);
            this.matrixFractionalToCartesian = M4.newM4(this.matrixCartesianToFractional).invert();
            if (fArray[0] == 1.0f) {
                this.setParamsFromMatrix();
            }
        } else if (fArray.length > 14 && !Float.isNaN(fArray[14])) {
            this.matrixFractionalToCartesian = new M4();
            object = this.matrixFractionalToCartesian;
            ((M4)object).setColumn4(0, fArray[6] * (float)this.na, fArray[7] * (float)this.na, fArray[8] * (float)this.na, 0.0f);
            ((M4)object).setColumn4(1, fArray[9] * (float)this.nb, fArray[10] * (float)this.nb, fArray[11] * (float)this.nb, 0.0f);
            ((M4)object).setColumn4(2, fArray[12] * (float)this.nc, fArray[13] * (float)this.nc, fArray[14] * (float)this.nc, 0.0f);
            ((M4)object).setColumn4(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = M4.newM4(this.matrixFractionalToCartesian).invert();
        } else {
            this.matrixFractionalToCartesian = new M4();
            object = this.matrixFractionalToCartesian;
            ((M4)object).setColumn4(0, this.a, 0.0f, 0.0f, 0.0f);
            ((M4)object).setColumn4(1, (float)((double)this.b * this.cosGamma), (float)((double)this.b * this.sinGamma), 0.0f, 0.0f);
            ((M4)object).setColumn4(2, (float)((double)this.c * this.cosBeta), (float)((double)this.c * (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma), (float)(this.volume / ((double)(this.a * this.b) * this.sinGamma)), 0.0f);
            ((M4)object).setColumn4(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = M4.newM4(this.matrixFractionalToCartesian).invert();
        }
        this.matrixCtoFANoOffset = this.matrixCartesianToFractional;
        this.matrixFtoCNoOffset = this.matrixFractionalToCartesian;
    }

    private void setParamsFromMatrix() {
        V3 v3 = V3.new3(1.0f, 0.0f, 0.0f);
        V3 v32 = V3.new3(0.0f, 1.0f, 0.0f);
        V3 v33 = V3.new3(0.0f, 0.0f, 1.0f);
        this.matrixFractionalToCartesian.rotate(v3);
        this.matrixFractionalToCartesian.rotate(v32);
        this.matrixFractionalToCartesian.rotate(v33);
        this.setABC(v3, v32, v33);
        this.setCellParams();
    }

    private void setABC(V3 v3, V3 v32, V3 v33) {
        this.a = v3.length();
        this.b = v32.length();
        this.c = v33.length();
        if (this.a == 0.0f) {
            return;
        }
        if (this.b == 0.0f) {
            this.c = -1.0f;
            this.b = -1.0f;
        } else if (this.c == 0.0f) {
            this.c = -1.0f;
        }
        this.alpha = this.b < 0.0f || this.c < 0.0f ? 90.0f : v32.angle(v33) / ((float)Math.PI / 180);
        this.beta = this.c < 0.0f ? 90.0f : v3.angle(v33) / ((float)Math.PI / 180);
        this.gamma = this.b < 0.0f ? 90.0f : v3.angle(v32) / ((float)Math.PI / 180);
    }

    private void setCellParams() {
        this.cosAlpha = Math.cos((float)Math.PI / 180 * this.alpha);
        this.sinAlpha = Math.sin((float)Math.PI / 180 * this.alpha);
        this.cosBeta = Math.cos((float)Math.PI / 180 * this.beta);
        this.sinBeta = Math.sin((float)Math.PI / 180 * this.beta);
        this.cosGamma = Math.cos((float)Math.PI / 180 * this.gamma);
        this.sinGamma = Math.sin((float)Math.PI / 180 * this.gamma);
        double d = Math.sqrt(this.sinAlpha * this.sinAlpha + this.sinBeta * this.sinBeta + this.sinGamma * this.sinGamma + 2.0 * this.cosAlpha * this.cosBeta * this.cosGamma - 2.0);
        this.volume = (double)(this.a * this.b * this.c) * d;
        this.cA_ = (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma;
        this.cB_ = d / this.sinGamma;
        this.a_ = (double)(this.b * this.c) * this.sinAlpha / this.volume;
        this.b_ = (double)(this.a * this.c) * this.sinBeta / this.volume;
        this.c_ = (double)(this.a * this.b) * this.sinGamma / this.volume;
    }

    public T3 getFractionalOrigin() {
        return this.fractionalOrigin;
    }

    public P3 toSupercell(P3 p3) {
        p3.x /= (float)this.na;
        p3.y /= (float)this.nb;
        p3.z /= (float)this.nc;
        return p3;
    }

    public final void toCartesian(T3 t3, boolean bl) {
        if (this.matrixFractionalToCartesian != null) {
            (bl ? this.matrixFtoCNoOffset : this.matrixFractionalToCartesian).rotTrans(t3);
        }
    }

    public final void toFractional(T3 t3, boolean bl) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        (bl ? this.matrixCtoFANoOffset : this.matrixCartesianToFractional).rotTrans(t3);
    }

    public boolean isPolymer() {
        return this.dimension == 1;
    }

    public boolean isSlab() {
        return this.dimension == 2;
    }

    public final float[] getNotionalUnitCell() {
        return this.notionalUnitcell;
    }

    public final float[] getUnitCellAsArray(boolean bl) {
        float[] fArray;
        M4 m4 = this.matrixFractionalToCartesian;
        if (bl) {
            float[] fArray2 = new float[9];
            fArray2[0] = m4.m00;
            fArray2[1] = m4.m10;
            fArray2[2] = m4.m20;
            fArray2[3] = m4.m01;
            fArray2[4] = m4.m11;
            fArray2[5] = m4.m21;
            fArray2[6] = m4.m02;
            fArray2[7] = m4.m12;
            fArray = fArray2;
            fArray2[8] = m4.m22;
        } else {
            float[] fArray3 = new float[17];
            fArray3[0] = this.a;
            fArray3[1] = this.b;
            fArray3[2] = this.c;
            fArray3[3] = this.alpha;
            fArray3[4] = this.beta;
            fArray3[5] = this.gamma;
            fArray3[6] = m4.m00;
            fArray3[7] = m4.m10;
            fArray3[8] = m4.m20;
            fArray3[9] = m4.m01;
            fArray3[10] = m4.m11;
            fArray3[11] = m4.m21;
            fArray3[12] = m4.m02;
            fArray3[13] = m4.m12;
            fArray3[14] = m4.m22;
            fArray3[15] = this.dimension;
            fArray = fArray3;
            fArray3[16] = (float)this.volume;
        }
        return fArray;
    }

    public final float getInfo(int n) {
        switch (n) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.alpha;
            }
            case 4: {
                return this.beta;
            }
            case 5: {
                return this.gamma;
            }
            case 6: {
                return this.dimension;
            }
        }
        return Float.NaN;
    }

    public static void ijkToPoint3f(int n, P3 p3, int n2) {
        int n3 = n > 1000000000 ? 1000 : (n > 1000000 ? 100 : 10);
        int n4 = n3 * n3;
        p3.x = n / n4 % n3 + (n2 -= n2 >= 0 ? 5 * n3 / 10 : n2);
        p3.y = n % n4 / n3 + n2;
        p3.z = n % n3 + n2;
    }

    public static float getCellWeight(P3 p3) {
        float f = 1.0f;
        if (p3.x == 0.0f) {
            f /= 2.0f;
        }
        if (p3.y == 0.0f) {
            f /= 2.0f;
        }
        if (p3.z == 0.0f) {
            f /= 2.0f;
        }
        return f;
    }
}

