/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.java.BS;
import org.jmol.minimize.Minimizer;
import org.jmol.minimize.forcefield.CalculationsUFF;
import org.jmol.minimize.forcefield.FFParam;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.script.T;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolAsyncException;

public class ForceFieldUFF
extends ForceField {
    private static Lst<String[]> atomTypes;
    private static Map<Object, Object> ffParams;
    private BS bsAromatic;
    private static final int TOKEN_ELEMENT_ONLY = 0;
    private static final int TOKEN_ELEMENT_CHARGED = 1;
    private static final int TOKEN_ELEMENT_CONNECTED = 2;
    private static final int TOKEN_AROMATIC = 3;
    private static final int TOKEN_ELEMENT_SP = 4;
    private static final int TOKEN_ELEMENT_ALLYLIC = 6;
    private static final int PT_ELEMENT = 2;
    private static final int PT_CHARGE = 5;
    private static final int PT_CONNECT = 6;
    private static final T[][] tokenTypes;

    public ForceFieldUFF(Minimizer minimizer) {
        this.minimizer = minimizer;
        this.name = "UFF";
    }

    @Override
    public void clear() {
        this.bsAromatic = null;
    }

    @Override
    public boolean setModel(BS bS, int n) throws JmolAsyncException {
        this.setModelFields();
        Logger.info("minimize: setting atom types...");
        if (atomTypes == null && (atomTypes = this.getAtomTypes()) == null) {
            return false;
        }
        if (ffParams == null && (ffParams = this.getFFParameters()) == null) {
            return false;
        }
        this.setAtomTypes(bS, n);
        this.calc = new CalculationsUFF(this, ffParams, this.minAtoms, this.minBonds, this.minAngles, this.minTorsions, this.minPositions, this.minimizer.constraints);
        return this.calc.setupCalculations();
    }

    private void setAtomTypes(BS bS, int n) {
        int n2 = atomTypes.size();
        bS.clear(0);
        for (int i = 0; i < n2; ++i) {
            String[] stringArray = (String[])atomTypes.get(i);
            String string = stringArray[0];
            if (string == null) continue;
            BS bS2 = this.getSearch(string, n, bS);
            if (bS.get(0)) {
                bS.clear(0);
                continue;
            }
            if (bS2 == null) break;
            int n3 = this.minimizer.bsAtoms.nextSetBit(0);
            int n4 = 0;
            while (n3 < this.minimizer.atoms.length && n3 >= 0) {
                if (bS2.get(n3)) {
                    this.minAtoms[n4].sType = stringArray[1].intern();
                }
                n3 = this.minimizer.bsAtoms.nextSetBit(n3 + 1);
                ++n4;
            }
        }
    }

    private BS getSearch(String string, int n, BS bS) {
        Object object;
        T[] tArray = null;
        int n2 = string.length();
        tArray = tokenTypes[0];
        int n3 = string.charAt(n2 - 2) - 48;
        int n4 = 0;
        if (n3 >= 10) {
            n3 = 0;
        }
        boolean bl = false;
        if (string.charAt(1) == '#') {
            n4 = PT.parseInt(string.substring(2, n2 - 1));
        } else {
            object = string.substring(1, n3 > 0 ? n2 - 3 : n2 - 1);
            if (((String)object).equals(((String)object).toLowerCase())) {
                object = ((String)object).toUpperCase();
                bl = true;
            }
            n4 = Elements.elementNumberFromSymbol((String)object, false);
        }
        if (n4 > n) {
            return null;
        }
        if (!bS.get(n4)) {
            bS.set(0);
            return null;
        }
        switch (string.charAt(n2 - 3)) {
            case 'D': {
                tArray = tokenTypes[2];
                tArray[6].intValue = n3;
                break;
            }
            case '^': {
                tArray = tokenTypes[4 + (n3 - 1)];
                break;
            }
            case '+': {
                tArray = tokenTypes[1];
                tArray[5].intValue = n3;
                break;
            }
            case '-': {
                tArray = tokenTypes[1];
                tArray[5].intValue = -n3;
                break;
            }
            case 'A': {
                tArray = tokenTypes[6];
            }
        }
        tArray[2].intValue = n4;
        object = this.minimizer.vwr.evaluateExpression(tArray);
        if (!(object instanceof BS)) {
            return null;
        }
        BS bS2 = (BS)object;
        if (bl && bS2.cardinality() > 0) {
            if (this.bsAromatic == null) {
                this.bsAromatic = (BS)this.minimizer.vwr.evaluateExpression(tokenTypes[3]);
            }
            bS2.and(this.bsAromatic);
        }
        if (Logger.debugging && bS2.cardinality() > 0) {
            Logger.debug(string + " minimize atoms=" + bS2);
        }
        return bS2;
    }

    private Map<Object, Object> getFFParameters() {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        String string = "UFF.txt";
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = this.getBufferedReader(string);
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = PT.getTokens(string2);
                if (stringArray.length < 13) continue;
                if (Logger.debugging) {
                    Logger.debug(string2);
                }
                if (!string2.substring(0, 5).equals("param")) continue;
                FFParam fFParam = new FFParam();
                hashtable.put(stringArray[1], fFParam);
                fFParam.dVal = new double[11];
                fFParam.sVal = new String[1];
                fFParam.sVal[0] = stringArray[1];
                fFParam.dVal[0] = PT.parseFloat(stringArray[2]);
                fFParam.dVal[1] = (double)PT.parseFloat(stringArray[3]) * (Math.PI / 180);
                fFParam.dVal[2] = PT.parseFloat(stringArray[4]);
                fFParam.dVal[3] = PT.parseFloat(stringArray[5]);
                fFParam.dVal[4] = PT.parseFloat(stringArray[6]);
                fFParam.dVal[5] = PT.parseFloat(stringArray[7]);
                fFParam.dVal[6] = PT.parseFloat(stringArray[8]);
                fFParam.dVal[7] = PT.parseFloat(stringArray[9]);
                fFParam.dVal[8] = PT.parseFloat(stringArray[10]);
                fFParam.dVal[9] = PT.parseFloat(stringArray[11]);
                fFParam.dVal[10] = PT.parseFloat(stringArray[12]);
                fFParam.iVal = new int[1];
                int n = stringArray[1].length() > 2 ? (int)stringArray[1].charAt(2) : 49;
                switch (n) {
                    case 82: {
                        n = 50;
                        break;
                    }
                    default: {
                        n = 49;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                }
                fFParam.iVal[0] = n - 48;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception.toString() + " in getResource " + string);
            try {
                bufferedReader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
        Logger.info(hashtable.size() + " atom types read from " + string);
        return hashtable;
    }

    private Lst<String[]> getAtomTypes() throws JmolAsyncException {
        Lst<String[]> lst = new Lst<String[]>();
        String string = "UFF.txt";
        try {
            String string2;
            BufferedReader bufferedReader = this.getBufferedReader(string);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 4 || !string2.substring(0, 4).equals("atom")) continue;
                String[] stringArray = PT.getTokens(string2);
                String[] stringArray2 = new String[]{stringArray[1], stringArray[2]};
                lst.addLast(stringArray2);
            }
            bufferedReader.close();
        }
        catch (JmolAsyncException jmolAsyncException) {
            throw new JmolAsyncException(jmolAsyncException.getFileName());
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception.toString() + " in getResource " + string);
        }
        Logger.info(lst.size() + " UFF parameters read");
        return lst.size() > 0 ? lst : null;
    }

    static {
        tokenTypes = new T[][]{{T.tokenExpressionBegin, T.n(269484436, 1095763978), T.i(0), T.tokenExpressionEnd}, {T.tokenExpressionBegin, T.n(269484436, 1095763978), T.i(0), T.tokenAnd, T.n(269484436, 1632634891), T.i(0), T.tokenExpressionEnd}, {T.tokenExpressionBegin, T.n(269484436, 1095763978), T.i(0), T.tokenAnd, T.tokenConnected, T.tokenLeftParen, T.i(0), T.tokenRightParen, T.tokenExpressionEnd}, {T.tokenExpressionBegin, T.o(0x40000000, "flatring"), T.tokenExpressionEnd}, {T.tokenExpressionBegin, T.n(269484436, 1095763978), T.i(0), T.tokenAnd, T.tokenLeftParen, T.tokenConnected, T.tokenLeftParen, T.i(1), T.tokenComma, T.o(4, "triple"), T.tokenRightParen, T.tokenOr, T.tokenConnected, T.tokenLeftParen, T.i(2), T.tokenComma, T.o(4, "double"), T.tokenRightParen, T.tokenRightParen, T.tokenExpressionEnd}, {T.tokenExpressionBegin, T.n(269484436, 1095763978), T.i(0), T.tokenAnd, T.o(135266310, "connected"), T.tokenLeftParen, T.i(1), T.tokenComma, T.o(4, "double"), T.tokenRightParen, T.tokenExpressionEnd}, {T.tokenExpressionBegin, T.n(269484436, 1095763978), T.i(0), T.tokenAnd, T.tokenConnected, T.tokenLeftParen, T.i(3), T.tokenRightParen, T.tokenAnd, T.tokenConnected, T.tokenLeftParen, T.tokenConnected, T.tokenLeftParen, T.o(4, "double"), T.tokenRightParen, T.tokenRightParen, T.tokenExpressionEnd}};
    }
}

