/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class InputReader
extends AtomSetCollectionReader {
    protected int ac;
    protected Lst<Atom> vAtoms = new Lst();
    private Map<String, Integer> atomMap = new Hashtable<String, Integer>();
    private String[] tokens;
    private boolean isJmolZformat;
    private Lst<String[]> lineBuffer = new Lst();
    private Map<String, Float> symbolicMap = new Hashtable<String, Float>();
    private boolean isMopac;
    private boolean isHeader = true;
    private boolean firstLine = true;
    private final P3 pt0 = new P3();
    private final V3 v1 = new V3();
    private final V3 v2 = new V3();
    private final P4 plane1 = new P4();
    private final P4 plane2 = new P4();

    @Override
    protected boolean checkLine() throws Exception {
        if (this.firstLine) {
            this.firstLine = false;
            String[] stringArray = this.getTokens();
            if (stringArray.length == 3 && this.parseIntStr(stringArray[0]) > 0 && this.parseIntStr(stringArray[1]) > 0 && this.parseIntStr(stringArray[2]) > 0) {
                this.readConFile();
                this.continuing = false;
                return false;
            }
        }
        this.cleanLine();
        if (this.line.length() <= 2) {
            this.isHeader = false;
        }
        if (this.line.startsWith("#") || this.line.startsWith("*") || this.isMopac && this.isHeader) {
            if (this.line.startsWith("#ZMATRIX")) {
                this.isJmolZformat = this.line.toUpperCase().indexOf("GAUSSIAN") < 0 && !(this.isMopac = this.line.toUpperCase().indexOf("MOPAC") >= 0);
            }
            this.checkCurrentLineForScript();
            return true;
        }
        if (this.line.indexOf("#") >= 0) {
            this.line = this.line.substring(0, this.line.indexOf("#"));
        }
        if (this.line.indexOf(":") >= 0) {
            return true;
        }
        if (this.line.contains("$molecule")) {
            this.rd();
            return this.readBlock("$end");
        }
        if (this.line.startsWith("$")) {
            return true;
        }
        if (this.line.contains("%mem")) {
            this.discardLinesUntilBlank();
            this.discardLinesUntilBlank();
            this.rd();
            return this.readBlock(null);
        }
        if (this.line.contains("ATOMS cartesian")) {
            return this.readBlock("END");
        }
        if (this.line.contains("geometry units angstroms")) {
            return this.readBlock("end");
        }
        if (this.line.contains("&zmat")) {
            return this.readBlock("&");
        }
        if (this.line.contains("%coords")) {
            this.discardLinesUntilContains("coords");
            return this.readBlock("end");
        }
        if (this.line.contains("GEOM=PQS")) {
            return this.readBlock("BASIS");
        }
        if (this.line.contains("geometry={")) {
            this.readLines(2);
            return this.readBlock("}");
        }
        this.tokens = this.getTokens();
        if (this.tokens.length > 10) {
            return this.readVFI();
        }
        switch (this.tokens.length) {
            case 1: {
                this.lineBuffer.clear();
                break;
            }
            case 2: {
                if (this.parseIntStr(this.line) > 0 && this.parseInt() >= 0) {
                    this.readCFI();
                    this.continuing = false;
                    return false;
                }
                this.getSymbolic();
                return true;
            }
            case 10: {
                if (this.tokens[0].equals("0")) {
                    this.continuing = false;
                    return false;
                }
                if (this.tokens[1].indexOf(".") < 0) {
                    return true;
                }
                if (this.lineBuffer.size() <= 0 || ((String[])this.lineBuffer.get(this.lineBuffer.size() - 1)).length >= 8) break;
                this.lineBuffer.clear();
            }
        }
        this.lineBuffer.addLast(this.tokens);
        return true;
    }

    private void readConFile() throws Exception {
        this.rd();
        Hashtable<String, Atom> hashtable = new Hashtable<String, Atom>();
        Lst<String[]> lst = new Lst<String[]>();
        int n = 0;
        while (this.rd() != null && this.line.length() > 40) {
            ++n;
            String[] stringArray = this.getTokens();
            lst.addLast(stringArray);
            hashtable.put(stringArray[1], this.addAtomXYZSymName(stringArray, 2, stringArray[0], null));
        }
        for (int i = 0; i < n; ++i) {
            String[] stringArray = (String[])lst.get(i);
            Atom atom = (Atom)hashtable.get(stringArray[1]);
            for (int j = 6; j < stringArray.length; ++j) {
                this.asc.addBond(new Bond(atom.index, ((Atom)hashtable.get((Object)stringArray[j])).index, 1));
            }
        }
    }

    private void readCFI() throws Exception {
        Object object;
        this.tokens = this.getTokens();
        int n = (int)this.getValue(0);
        int n2 = (int)this.getValue(1);
        Hashtable<String, float[]> hashtable = new Hashtable<String, float[]>();
        for (int i = 0; i < n; ++i) {
            this.tokens = PT.getTokens(this.rd());
            if (this.tokens[1].equals("0")) continue;
            object = this.addAtomXYZSymName(this.tokens, 2, null, null);
            object.elementNumber = (short)this.getValue(1);
            hashtable.put(this.tokens[0], (float[])object);
        }
        float[] fArray = this.fillFloatArray(null, 0, new float[n2 * 2]);
        object = this.fillFloatArray(null, 0, new float[n2]);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            this.asc.addBond(new Bond(((Atom)hashtable.get((Object)new StringBuilder().append((String)"").append((int)((int)fArray[n3++])).toString())).index, ((Atom)hashtable.get((Object)new StringBuilder().append((String)"").append((int)((int)fArray[n3++])).toString())).index, (int)object[i]));
        }
    }

    private boolean readVFI() throws Exception {
        Object object;
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        Lst<String[]> lst = new Lst<String[]>();
        while (this.tokens != null && this.tokens.length > 0) {
            String[] stringArray;
            int n = this.tokens.length;
            while (--n >= 11) {
                lst.addLast(new String[]{this.tokens[3], this.tokens[n]});
            }
            String string = this.tokens[3];
            if (this.tokens[2].equals("0")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.tokens[4];
            } else if (this.tokens[1].equals("0")) {
                String[] stringArray3 = new String[3];
                stringArray3[0] = this.tokens[4];
                stringArray3[1] = this.tokens[2];
                stringArray = stringArray3;
                stringArray3[2] = this.tokens[5];
            } else if (this.tokens[0].equals("0")) {
                String[] stringArray4 = new String[5];
                stringArray4[0] = this.tokens[4];
                stringArray4[1] = this.tokens[2];
                stringArray4[2] = this.tokens[5];
                stringArray4[3] = this.tokens[1];
                stringArray = stringArray4;
                stringArray4[4] = this.tokens[7];
            } else {
                String[] stringArray5 = new String[7];
                stringArray5[0] = this.tokens[4];
                stringArray5[1] = this.tokens[2];
                stringArray5[2] = this.tokens[5];
                stringArray5[3] = this.tokens[1];
                stringArray5[4] = this.tokens[7];
                stringArray5[5] = this.tokens[0];
                stringArray = stringArray5;
                stringArray5[6] = this.tokens[9];
            }
            this.tokens = stringArray;
            object = this.getAtom();
            hashtable.put(string, (String[])object);
            this.tokens = PT.getTokens(this.rd());
        }
        int n = lst.size();
        while (--n >= 0) {
            object = (String[])lst.get(n);
            this.asc.addBond(new Bond(((Atom)hashtable.get((Object)object[0])).index, ((Atom)hashtable.get((Object)object[1])).index, 1));
        }
        this.continuing = false;
        return false;
    }

    private boolean readBlock(String string) throws Exception {
        this.lineBuffer.clear();
        while (this.rd() != null && this.cleanLine() != null && (string == null ? this.line.length() > 0 : this.line.indexOf(string) < 0)) {
            this.lineBuffer.addLast(this.getTokens());
        }
        this.continuing = false;
        return false;
    }

    private String cleanLine() {
        int n;
        int n2;
        this.line = this.line.replace(',', ' ');
        while ((n2 = this.line.indexOf(40)) >= 0 && (n = this.line.indexOf(40, n2)) >= 0) {
            this.line = this.line.substring(0, n2) + " " + this.line.substring(n + 1);
        }
        this.line = this.line.trim();
        return this.line;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        int n;
        for (int i = n = 0; i < this.lineBuffer.size(); ++i) {
            this.tokens = (String[])this.lineBuffer.get(i);
            if (this.tokens.length <= 0) continue;
            this.getAtom();
        }
        this.finalizeReaderASCR();
    }

    private void getSymbolic() {
        if (this.symbolicMap.containsKey(this.tokens[0])) {
            return;
        }
        float f = this.parseFloatStr(this.tokens[1]);
        this.symbolicMap.put(this.tokens[0], Float.valueOf(f));
        Logger.info("symbolic " + this.tokens[0] + " = " + f);
    }

    private Atom getAtom() throws Exception {
        Atom atom = new Atom();
        String string = this.tokens[0];
        int n = string.length();
        while (--n >= 0 && PT.isDigit(string.charAt(n))) {
        }
        if (++n == 0) {
            string = JmolAdapter.getElementSymbol(this.parseIntStr(string));
        }
        if (n == 0 || n == string.length()) {
            atom.atomName = string + (this.ac + 1);
        } else {
            atom.atomName = string;
            string = string.substring(0, n);
        }
        if (this.isMopac && n != this.tokens[0].length()) {
            string = this.tokens[0].substring(n) + string;
        }
        this.parseAtomTokens(atom, string);
        return atom;
    }

    private void parseAtomTokens(Atom atom, String string) throws Exception {
        int n;
        this.setElementAndIsotope(atom, string);
        if (this.tokens.length > 5 && this.tokens[1].indexOf(".") >= 0) {
            String[] stringArray;
            String[] stringArray2 = this.tokens;
            n = stringArray2.length;
            if (stringArray2[n - 3].equals("0")) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = stringArray2[0];
            } else if (stringArray2[n - 2].equals("0")) {
                String[] stringArray4 = new String[3];
                stringArray4[0] = stringArray2[0];
                stringArray4[1] = stringArray2[n - 3];
                stringArray = stringArray4;
                stringArray4[2] = stringArray2[1];
            } else if (stringArray2[n - 1].equals("0")) {
                String[] stringArray5 = new String[5];
                stringArray5[0] = stringArray2[0];
                stringArray5[1] = stringArray2[n - 3];
                stringArray5[2] = stringArray2[1];
                stringArray5[3] = stringArray2[n - 2];
                stringArray = stringArray5;
                stringArray5[4] = stringArray2[3];
            } else {
                String[] stringArray6 = new String[7];
                stringArray6[0] = stringArray2[0];
                stringArray6[1] = stringArray2[n - 3];
                stringArray6[2] = stringArray2[1];
                stringArray6[3] = stringArray2[n - 2];
                stringArray6[4] = stringArray2[3];
                stringArray6[5] = stringArray2[n - 1];
                stringArray = stringArray6;
                stringArray6[6] = stringArray2[5];
            }
            this.tokens = stringArray;
        }
        int n2 = this.getAtomIndex(1);
        n = 0;
        switch (this.tokens.length) {
            case 6: 
            case 8: {
                n = (int)this.getValue(this.tokens.length - 1);
                atom = this.getAtomGeneral(atom, n2, n);
                break;
            }
            case 5: {
                if (this.tokens[1].equals("0")) {
                    atom.set(this.getValue(2), this.getValue(3), this.getValue(4));
                    break;
                }
            }
            case 7: {
                atom = this.getAtomGeneral(atom, n2, 0);
                break;
            }
            case 4: {
                if (this.getAtomIndex(1) < 0) {
                    atom.set(this.getValue(1), this.getValue(2), this.getValue(3));
                    break;
                }
                n = (int)this.getValue(3);
            }
            case 3: {
                if (this.ac != 1 || (n2 = this.getAtomIndex(1)) != 0) {
                    atom = null;
                    break;
                }
                atom.set(this.getValue(2), 0.0f, 0.0f);
                break;
            }
            case 1: {
                if (this.ac != 0) {
                    atom = null;
                    break;
                }
                atom.set(0.0f, 0.0f, 0.0f);
                break;
            }
            default: {
                atom = null;
            }
        }
        if (atom == null) {
            throw new Exception("bad Z-Matrix line");
        }
        this.vAtoms.addLast(atom);
        this.atomMap.put(atom.atomName, this.ac++);
        if (string.startsWith("X") && JmolAdapter.getElementNumber(string) < 1) {
            Logger.info("#dummy atom ignored: atom " + this.ac + " - " + atom.atomName);
        } else {
            this.asc.addAtom(atom);
            this.setAtomCoord(atom);
            Logger.info(atom.atomName + " " + atom.x + " " + atom.y + " " + atom.z);
            if (n < 0 || this.isJmolZformat && n > 0) {
                this.asc.addBond(new Bond(atom.index, ((Atom)this.vAtoms.get((int)n2)).index, Math.abs(n)));
            }
        }
    }

    private Atom getAtomGeneral(Atom atom, int n, int n2) throws Exception {
        float f;
        int n3;
        int n4;
        if (this.tokens.length < 7 && this.ac != 2 || (n4 = this.getAtomIndex(3)) < 0 || (n3 = this.tokens.length < 7 ? -2 : this.getAtomIndex(5)) == -1) {
            return null;
        }
        float f2 = this.getValue(2);
        float f3 = this.getValue(4);
        float f4 = f = this.tokens.length < 7 ? Float.MAX_VALUE : this.getValue(6);
        if (this.tokens.length == 8 && !this.isJmolZformat && !this.isMopac && n2 == 1) {
            f2 = -Math.abs(f2);
        }
        atom = this.setAtom(atom, n, n4, n3, f2, f3, f);
        return atom;
    }

    private float getSymbolic(String string) {
        boolean bl = string.startsWith("-");
        Float f = this.symbolicMap.get(bl ? string.substring(1) : string);
        if (f == null) {
            return Float.NaN;
        }
        float f2 = f.floatValue();
        return bl ? -f2 : f2;
    }

    private float getValue(int n) throws Exception {
        float f = this.getSymbolic(this.tokens[n]);
        if (Float.isNaN(f) && Float.isNaN(f = this.parseFloatStr(this.tokens[n]))) {
            throw new Exception("Bad Z-matrix value: " + this.tokens[n]);
        }
        return f;
    }

    private int getAtomIndex(int n) {
        String string;
        if (n >= this.tokens.length || (string = this.tokens[n]).indexOf(".") >= 0 || !PT.isLetterOrDigit(string.charAt(0))) {
            return -1;
        }
        int n2 = this.parseIntStr(string);
        if (n2 <= 0 || string.length() != ("" + n2).length()) {
            Integer n3 = this.atomMap.get(string);
            if (n3 == null) {
                n = this.vAtoms.size();
                while (--n >= 0) {
                    Atom atom = (Atom)this.vAtoms.get(n);
                    if (!atom.atomName.startsWith(string) || atom.atomName.length() <= string.length() || !PT.isDigit(atom.atomName.charAt(string.length()))) continue;
                    n3 = this.atomMap.get(atom.atomName);
                    break;
                }
            }
            n2 = n3 == null ? -1 : n3;
        } else {
            --n2;
        }
        return n2;
    }

    protected Atom setAtom(Atom atom, int n, int n2, int n3, float f, float f2, float f3) {
        if (Float.isNaN(f2) || Float.isNaN(f3)) {
            return null;
        }
        this.pt0.setT((T3)this.vAtoms.get(n));
        this.v1.sub2((T3)this.vAtoms.get(n2), this.pt0);
        this.v1.normalize();
        if (f3 == Float.MAX_VALUE) {
            this.v2.set(0.0f, 0.0f, 1.0f);
            Quat.newVA(this.v2, f2).transform2(this.v1, this.v2);
        } else if (f >= 0.0f) {
            this.v2.sub2((T3)this.vAtoms.get(n3), this.pt0);
            this.v2.cross(this.v1, this.v2);
            Quat.newVA(this.v2, f2).transform2(this.v1, this.v2);
            Quat.newVA(this.v1, -f3).transform2(this.v2, this.v2);
        } else {
            Measure.getPlaneThroughPoint(this.setAtom(atom, n, n2, n3, -f, f2, 0.0f), this.v1, this.plane1);
            Measure.getPlaneThroughPoint(this.setAtom(atom, n, n3, n2, -f, f3, 0.0f), this.v1, this.plane2);
            Lst<Object> lst = Measure.getIntersectionPP(this.plane1, this.plane2);
            if (lst.size() == 0) {
                return null;
            }
            this.pt0.setT((P3)lst.get(0));
            f = (float)Math.sqrt(f * f - this.pt0.distanceSquared((T3)this.vAtoms.get(n))) * Math.signum(f2) * Math.signum(f3);
            this.v2.setT((V3)lst.get(1));
        }
        atom.scaleAdd2(f, this.v2, this.pt0);
        return atom;
    }
}

