/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.readers.quantum.GamessReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;

public class GamessUSReader
extends GamessReader {
    private boolean lowdenCharges;

    @Override
    protected void initializeReader() throws Exception {
        this.lowdenCharges = this.checkFilterKey("CHARGE=LOW");
        super.initializeReader();
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" $DATA")) {
            return this.readInputDeck();
        }
        if (this.line.indexOf("***************") >= 0) {
            Logger.info(this.rd());
        }
        if (this.line.indexOf("FINAL ENERGY IS") >= 0 || this.line.indexOf("TOTAL ENERGY = ") >= 0 || this.line.indexOf("FINAL RHF ENERGY IS") >= 0) {
            this.readEnergy();
        }
        if (this.line.indexOf("BASIS OPTIONS") >= 0) {
            this.readBasisInfo();
            return true;
        }
        if (this.line.indexOf("$CONTRL OPTIONS") >= 0) {
            this.readControlInfo();
            return true;
        }
        if (this.line.indexOf("ATOMIC BASIS SET") >= 0) {
            this.readGaussianBasis("SHELL TYPE", "TOTAL");
            return false;
        }
        boolean bl = this.line.indexOf("COORDINATES (BOHR)") >= 0;
        if (bl || this.line.indexOf("COORDINATES OF ALL ATOMS ARE (ANGS)") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.atomNames = new Lst();
            if (bl) {
                this.readAtomsInBohrCoordinates();
            } else {
                this.readAtomsInAngstromCoordinates();
            }
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("FREQUENCIES IN CM") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (this.line.indexOf("SUMMARY OF THE EFFECTIVE FRAGMENT") >= 0) {
            this.readEFPInBohrCoordinates();
            return false;
        }
        if (this.line.indexOf("  TOTAL MULLIKEN AND LOWDIN ATOMIC POPULATIONS") >= 0) {
            this.readPartialCharges();
            return false;
        }
        if (this.line.indexOf("ELECTROSTATIC MOMENTS") >= 0) {
            this.readDipoleMoment();
            return true;
        }
        if (this.line.indexOf("- ALPHA SET -") >= 0) {
            this.alphaBeta = "alpha";
        } else if (this.line.indexOf("- BETA SET -") >= 0) {
            this.alphaBeta = "beta";
        } else if (this.line.indexOf("  EIGENVECTORS") >= 0 || this.line.indexOf("  INITIAL GUESS ORBITALS") >= 0 || this.line.indexOf("  MCSCF OPTIMIZED ORBITALS") >= 0 || this.line.indexOf("  MCSCF NATURAL ORBITALS") >= 0 || this.line.indexOf("  MOLECULAR ORBITALS") >= 0 && this.line.indexOf("  MOLECULAR ORBITALS LOCALIZED BY THE POPULATION METHOD") < 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals(1);
            return false;
        }
        if (this.line.indexOf("EDMISTON-RUEDENBERG ENERGY LOCALIZED ORBITALS") >= 0 || this.line.indexOf("  THE PIPEK-MEZEY POPULATION LOCALIZED ORBITALS ARE") >= 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals(0);
            return false;
        }
        if (this.line.indexOf("  NATURAL ORBITALS IN ATOMIC ORBITAL BASIS") >= 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals(2);
            return false;
        }
        return this.checkNboLine();
    }

    private boolean readInputDeck() throws Exception {
        this.readLines(2);
        this.asc.newAtomSet();
        while (this.rd().indexOf("$END") < 0) {
            String[] stringArray = this.getTokens();
            this.addAtomXYZSymName((String[])stringArray, (int)2, (String)stringArray[0], null).elementNumber = (short)this.parseIntStr(stringArray[1]);
        }
        this.continuing = false;
        return false;
    }

    @Override
    protected void readMolecularOrbitals(int n) throws Exception {
        this.setCalculationType();
        super.readMolecularOrbitals(n);
    }

    protected void readEFPInBohrCoordinates() throws Exception {
        int n = this.asc.ac;
        this.discardLinesUntilContains("MULTIPOLE COORDINATES");
        this.rd();
        this.rd();
        while (this.rd() != null && this.line.length() >= 72) {
            String string = this.line.substring(1, 2);
            if (string.charAt(0) == 'Z') {
                string = this.line.substring(2, 3);
            } else if (this.parseFloatRange(this.line, 67, 73) == 0.0f) continue;
            float f = this.parseFloatRange(this.line, 8, 25);
            float f2 = this.parseFloatRange(this.line, 25, 40);
            float f3 = this.parseFloatRange(this.line, 40, 56);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) break;
            Atom atom = this.asc.addNewAtom();
            atom.atomName = string + ++n;
            this.setAtomCoordXYZ(atom, f * 0.5291772f, f2 * 0.5291772f, f3 * 0.5291772f);
            this.atomNames.addLast(string);
        }
    }

    @Override
    protected void readAtomsInBohrCoordinates() throws Exception {
        String string;
        this.rd();
        this.asc.newAtomSet();
        int n = 0;
        while (this.rd() != null && (string = this.parseTokenRange(this.line, 1, 11)) != null) {
            float f = this.parseFloatRange(this.line, 17, 37);
            float f2 = this.parseFloatRange(this.line, 37, 57);
            float f3 = this.parseFloatRange(this.line, 57, 77);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) break;
            Atom atom = this.asc.addNewAtom();
            atom.elementSymbol = GamessUSReader.getElementSymbol(this.parseIntRange(this.line, 11, 14));
            atom.atomName = atom.elementSymbol + ++n;
            this.setAtomCoordXYZ(atom, f * 0.5291772f, f2 * 0.5291772f, f3 * 0.5291772f);
            this.atomNames.addLast(string);
        }
    }

    private void readAtomsInAngstromCoordinates() throws Exception {
        Atom atom;
        float f;
        float f2;
        float f3;
        String string;
        this.rd();
        this.rd();
        this.asc.newAtomSet();
        int n = 0;
        while (this.rd() != null && (string = this.parseTokenRange(this.line, 1, 11)) != null) {
            f3 = this.parseFloatRange(this.line, 16, 31);
            f2 = this.parseFloatRange(this.line, 31, 46);
            f = this.parseFloatRange(this.line, 46, 61);
            if (Float.isNaN(f3) || Float.isNaN(f2) || Float.isNaN(f)) break;
            atom = this.asc.addNewAtom();
            this.setAtomCoordXYZ(atom, f3, f2, f);
            atom.elementSymbol = GamessUSReader.getElementSymbol(this.parseIntRange(this.line, 11, 14));
            atom.atomName = atom.elementSymbol + ++n;
            this.atomNames.addLast(string);
        }
        if (this.line.indexOf("COORDINATES OF FRAGMENT MULTIPOLE CENTERS (ANGS)") >= 0) {
            this.rd();
            this.rd();
            this.rd();
            while (this.rd() != null && (string = this.parseTokenRange(this.line, 1, 2)) != null) {
                if (this.parseTokenRange(this.line, 1, 2).equals("Z")) {
                    string = this.parseTokenRange(this.line, 2, 3);
                } else {
                    if (this.parseTokenRange(this.line, 1, 9).equals("FRAGNAME")) continue;
                    string = this.parseTokenRange(this.line, 1, 2);
                }
                f3 = this.parseFloatRange(this.line, 16, 31);
                f2 = this.parseFloatRange(this.line, 31, 46);
                f = this.parseFloatRange(this.line, 46, 61);
                if (Float.isNaN(f3) || Float.isNaN(f2) || Float.isNaN(f)) break;
                atom = this.asc.addNewAtom();
                atom.atomName = string + ++n;
                this.setAtomCoordXYZ(atom, f3, f2, f);
                this.atomNames.addLast(string);
            }
        }
    }

    @Override
    protected String fixShellTag(String string) {
        return string;
    }

    void readPartialCharges() throws Exception {
        String string;
        String[] stringArray = null;
        String string2 = string = this.lowdenCharges ? "LOW.POP." : "MULL.POP.";
        while (this.rd() != null && ("".equals(this.line.trim()) || this.line.indexOf("ATOM") >= 0)) {
            stringArray = this.getTokens();
        }
        int n = 0;
        while (++n < stringArray.length && !string.equals(stringArray[n])) {
        }
        if (++n >= stringArray.length || !"CHARGE".equals(stringArray[n++])) {
            return;
        }
        Atom[] atomArray = this.asc.atoms;
        int n2 = this.asc.getLastAtomSetAtomIndex();
        int n3 = this.asc.ac;
        for (int i = n2; i < n3 && this.rd() != null; ++i) {
            atomArray[i].partialCharge = this.parseFloatStr(PT.getTokens(this.prevline)[n]);
        }
    }

    void readDipoleMoment() throws Exception {
        String[] stringArray = null;
        this.rd();
        while (this.line != null && ("".equals(this.line.trim()) || this.line.indexOf("DX") < 0)) {
            this.rd();
        }
        stringArray = this.getTokens();
        if (stringArray.length != 5) {
            return;
        }
        if ("DX".equals(stringArray[0]) && "DY".equals(stringArray[1]) && "DZ".equals(stringArray[2])) {
            stringArray = PT.getTokens(this.rd());
            V3 v3 = V3.new3(this.parseFloatStr(stringArray[0]), this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]));
            Logger.info("Molecular dipole for model " + this.asc.atomSetCount + " = " + v3);
            this.asc.setCurrentModelInfo("dipole", v3);
        }
    }
}

