/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.T4;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

class UnitCell
extends SimpleUnitCell {
    private P3[] vertices;
    private final P3 cartesianOffset = new P3();
    private P3 fractionalOffset;
    private boolean allFractionalRelative;
    private P3 unitCellMultiplier;
    public Lst<String> moreInfo;
    public String name = "";
    private static final double twoP2 = 19.739208802178716;
    private static final V3[] unitVectors = new V3[]{JC.axisX, JC.axisY, JC.axisZ};

    UnitCell() {
    }

    static UnitCell newP(T3[] t3Array, boolean bl) {
        UnitCell unitCell = new UnitCell();
        float[] fArray = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, t3Array[1].x, t3Array[1].y, t3Array[1].z, t3Array[2].x, t3Array[2].y, t3Array[2].z, t3Array[3].x, t3Array[3].y, t3Array[3].z};
        unitCell.init(fArray);
        unitCell.allFractionalRelative = bl;
        unitCell.initUnitcellVertices();
        unitCell.setCartesianOffset(t3Array[0]);
        return unitCell;
    }

    public static UnitCell newA(float[] fArray, boolean bl) {
        UnitCell unitCell = new UnitCell();
        unitCell.init(fArray);
        unitCell.initUnitcellVertices();
        unitCell.allFractionalRelative = bl;
        return unitCell;
    }

    void initOrientation(M3 m3) {
        if (m3 == null) {
            return;
        }
        M4 m4 = new M4();
        m4.setToM3(m3);
        this.matrixFractionalToCartesian.mul2(m4, this.matrixFractionalToCartesian);
        this.matrixCartesianToFractional.setM4(this.matrixFractionalToCartesian).invert();
        this.initUnitcellVertices();
    }

    final void toUnitCell(P3 p3, P3 p32) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        if (p32 == null) {
            this.matrixCartesianToFractional.rotTrans(p3);
            this.unitize(p3);
            this.matrixFractionalToCartesian.rotTrans(p3);
        } else {
            this.matrixCtoFANoOffset.rotTrans(p3);
            this.unitize(p3);
            p3.add(p32);
            this.matrixFtoCNoOffset.rotTrans(p3);
        }
    }

    public void unitize(P3 p3) {
        switch (this.dimension) {
            case 3: {
                p3.z = UnitCell.toFractionalX(p3.z);
            }
            case 2: {
                p3.y = UnitCell.toFractionalX(p3.y);
            }
            case 1: {
                p3.x = UnitCell.toFractionalX(p3.x);
            }
        }
    }

    public void reset() {
        this.unitCellMultiplier = null;
        this.setOffset(P3.new3(0.0f, 0.0f, 0.0f));
    }

    void setOffset(T3 t3) {
        T4 t4;
        if (t3 == null) {
            return;
        }
        T4 t42 = t4 = t3 instanceof T4 ? (T4)t3 : null;
        if (t4 != null ? t4.w <= 0.0f : t3.x >= 100.0f || t3.y >= 100.0f) {
            P3 p3 = this.unitCellMultiplier = t3.z == 0.0f && t3.x == t3.y ? null : P3.newP(t3);
            if (t4 == null || t4.w == 0.0f) {
                return;
            }
        }
        if (this.hasOffset() || t3.lengthSquared() > 0.0f) {
            this.fractionalOffset = new P3();
            this.fractionalOffset.setT(t3);
        }
        this.matrixCartesianToFractional.m03 = -t3.x;
        this.matrixCartesianToFractional.m13 = -t3.y;
        this.matrixCartesianToFractional.m23 = -t3.z;
        this.cartesianOffset.setT(t3);
        this.matrixFractionalToCartesian.m03 = 0.0f;
        this.matrixFractionalToCartesian.m13 = 0.0f;
        this.matrixFractionalToCartesian.m23 = 0.0f;
        this.matrixFractionalToCartesian.rotTrans(this.cartesianOffset);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFANoOffset.setM4(this.matrixCartesianToFractional);
            this.matrixFtoCNoOffset.setM4(this.matrixFractionalToCartesian);
        }
    }

    private void setCartesianOffset(T3 t3) {
        this.cartesianOffset.setT(t3);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        boolean bl = this.hasOffset();
        this.fractionalOffset = new P3();
        this.fractionalOffset.setT(this.cartesianOffset);
        this.matrixCartesianToFractional.m03 = 0.0f;
        this.matrixCartesianToFractional.m13 = 0.0f;
        this.matrixCartesianToFractional.m23 = 0.0f;
        this.matrixCartesianToFractional.rotTrans(this.fractionalOffset);
        this.matrixCartesianToFractional.m03 = -this.fractionalOffset.x;
        this.matrixCartesianToFractional.m13 = -this.fractionalOffset.y;
        this.matrixCartesianToFractional.m23 = -this.fractionalOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFANoOffset.setM4(this.matrixCartesianToFractional);
            this.matrixFtoCNoOffset.setM4(this.matrixFractionalToCartesian);
        }
        if (!bl && this.fractionalOffset.lengthSquared() == 0.0f) {
            this.fractionalOffset = null;
        }
    }

    void setMinMaxLatticeParameters(P3i p3i, P3i p3i2) {
        if (p3i2.x <= p3i2.y && p3i2.y >= 555) {
            P3 p3 = new P3();
            UnitCell.ijkToPoint3f(p3i2.x, p3, 0);
            p3i.x = (int)p3.x;
            p3i.y = (int)p3.y;
            p3i.z = (int)p3.z;
            UnitCell.ijkToPoint3f(p3i2.y, p3, 1);
            p3i2.x = (int)p3.x;
            p3i2.y = (int)p3.y;
            p3i2.z = (int)p3.z;
        }
        switch (this.dimension) {
            case 1: {
                p3i.y = 0;
                p3i2.y = 1;
            }
            case 2: {
                p3i.z = 0;
                p3i2.z = 1;
            }
        }
    }

    final String dumpInfo(boolean bl) {
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + "\n" + Escape.eAP(this.getUnitCellVectors()) + "\nvolume=" + this.volume + (bl ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    P3[] getVertices() {
        return this.vertices;
    }

    P3 getCartesianOffset() {
        return this.cartesianOffset;
    }

    P3 getFractionalOffset() {
        return this.fractionalOffset;
    }

    Tensor getTensor(Viewer viewer, float[] fArray) {
        Tensor tensor = (Tensor)Interface.getUtil("Tensor", viewer, "file");
        if (fArray[0] == 0.0f && fArray[1] == 0.0f && fArray[2] == 0.0f) {
            float f = fArray[7];
            float[] fArray2 = new float[]{f, f, f};
            return tensor.setFromEigenVectors(unitVectors, fArray2, "iso", "Uiso=" + f, null);
        }
        tensor.parBorU = fArray;
        double[] dArray = new double[6];
        int n = (int)fArray[6];
        if (n == 12) {
            dArray[0] = (double)fArray[0] * 19.739208802178716;
            dArray[1] = (double)fArray[1] * 19.739208802178716;
            dArray[2] = (double)fArray[2] * 19.739208802178716;
            dArray[3] = (double)fArray[3] * 19.739208802178716 * 2.0;
            dArray[4] = (double)fArray[4] * 19.739208802178716 * 2.0;
            dArray[5] = (double)fArray[5] * 19.739208802178716 * 2.0;
            fArray[7] = (fArray[0] + fArray[1] + fArray[3]) / 3.0f;
        } else {
            boolean bl = n == 4 || n == 5 || n == 8 || n == 9;
            double d = 2 - n % 2;
            double d2 = n == 8 || n == 9 || n == 10 ? 19.739208802178716 : (n == 4 || n == 5 ? 0.25 : (n == 2 || n == 3 ? Math.log(2.0) : 1.0));
            double d3 = (double)fArray[0] * d2 * (bl ? this.a_ * this.a_ : 1.0);
            double d4 = (double)fArray[1] * d2 * (bl ? this.b_ * this.b_ : 1.0);
            double d5 = (double)fArray[2] * d2 * (bl ? this.c_ * this.c_ : 1.0);
            double d6 = (double)fArray[3] * d2 * (bl ? this.a_ * this.b_ : 1.0) * d;
            double d7 = (double)fArray[4] * d2 * (bl ? this.a_ * this.c_ : 1.0) * d;
            double d8 = (double)fArray[5] * d2 * (bl ? this.b_ * this.c_ : 1.0) * d;
            fArray[7] = (float)Math.pow(d3 / 19.739208802178716 / this.a_ / this.a_ * d4 / 19.739208802178716 / this.b_ / this.b_ * d5 / 19.739208802178716 / this.c_ / this.c_, 0.3333);
            dArray[0] = (double)(this.a * this.a) * d3 + (double)(this.b * this.b) * this.cosGamma * this.cosGamma * d4 + (double)(this.c * this.c) * this.cosBeta * this.cosBeta * d5 + (double)(this.a * this.b) * this.cosGamma * d6 + (double)(this.b * this.c) * this.cosGamma * this.cosBeta * d8 + (double)(this.a * this.c) * this.cosBeta * d7;
            dArray[1] = (double)(this.b * this.b) * this.sinGamma * this.sinGamma * d4 + (double)(this.c * this.c) * this.cA_ * this.cA_ * d5 + (double)(this.b * this.c) * this.cA_ * this.sinGamma * d8;
            dArray[2] = (double)(this.c * this.c) * this.cB_ * this.cB_ * d5;
            dArray[3] = (double)(2.0f * this.b * this.b) * this.cosGamma * this.sinGamma * d4 + (double)(2.0f * this.c * this.c) * this.cA_ * this.cosBeta * d5 + (double)(this.a * this.b) * this.sinGamma * d6 + (double)(this.b * this.c) * (this.cA_ * this.cosGamma + this.sinGamma * this.cosBeta) * d8 + (double)(this.a * this.c) * this.cA_ * d7;
            dArray[4] = (double)(2.0f * this.c * this.c) * this.cB_ * this.cosBeta * d5 + (double)(this.b * this.c) * this.cosGamma * d8 + (double)(this.a * this.c) * this.cB_ * d7;
            dArray[5] = (double)(2.0f * this.c * this.c) * this.cA_ * this.cB_ * d5 + (double)(this.b * this.c) * this.cB_ * this.sinGamma * d8;
        }
        return tensor.setFromThermalEquation(dArray, Escape.eAF(fArray));
    }

    P3[] getCanonicalCopy(float f, boolean bl) {
        P3[] p3Array = new P3[8];
        P3 p3 = null;
        P3 p32 = null;
        if (bl && this.unitCellMultiplier != null) {
            p3 = new P3();
            p32 = new P3();
            UnitCell.ijkToPoint3f((int)this.unitCellMultiplier.x, p3, 0);
            UnitCell.ijkToPoint3f((int)this.unitCellMultiplier.y, p32, 0);
            p32.sub(p3);
        }
        for (int i = 0; i < 8; ++i) {
            P3 p33 = p3Array[i] = P3.newP(BoxInfo.unitCubePoints[i]);
            if (p3 != null) {
                f *= this.unitCellMultiplier.z == 0.0f ? 1.0f : this.unitCellMultiplier.z;
                p3Array[i].add3(p3.x + p32.x * p33.x, p3.y + p32.y * p33.y, p3.z + p32.z * p33.z);
            }
            this.matrixFractionalToCartesian.rotTrans(p33);
            if (bl) continue;
            p33.sub(this.cartesianOffset);
        }
        return BoxInfo.getCanonicalCopy(p3Array, f);
    }

    private static float toFractionalX(float f) {
        if ((f = (float)((double)f - Math.floor(f))) > 0.9999f || f < 1.0E-4f) {
            f = 0.0f;
        }
        return f;
    }

    private void initUnitcellVertices() {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixCtoFANoOffset = M4.newM4(this.matrixCartesianToFractional);
        this.matrixFtoCNoOffset = M4.newM4(this.matrixFractionalToCartesian);
        this.vertices = new P3[8];
        int n = 8;
        while (--n >= 0) {
            this.vertices[n] = (P3)this.matrixFractionalToCartesian.rotTrans2(BoxInfo.unitCubePoints[n], new P3());
        }
    }

    public boolean checkDistance(P3 p3, P3 p32, float f, float f2, int n, int n2, int n3, P3 p33) {
        P3 p34 = P3.newP(p3);
        this.toCartesian(p34, true);
        for (int i = -n; i <= n; ++i) {
            for (int j = -n2; j <= n2; ++j) {
                for (int k = -n3; k <= n3; ++k) {
                    p33.set(p32.x + (float)i, p32.y + (float)j, p32.z + (float)k);
                    this.toCartesian(p33, true);
                    float f3 = p34.distance(p33);
                    if (!(f2 > 0.0f ? Math.abs(f3 - f) <= f2 : f3 <= f && f3 > 0.1f)) continue;
                    p33.set(i, j, k);
                    return true;
                }
            }
        }
        return false;
    }

    public P3 getUnitCellMultiplier() {
        return this.unitCellMultiplier;
    }

    public V3[] getUnitCellVectors() {
        M4 m4 = this.matrixFractionalToCartesian;
        return new V3[]{V3.newV(this.cartesianOffset), V3.new3(this.fix(m4.m00), this.fix(m4.m10), this.fix(m4.m20)), V3.new3(this.fix(m4.m01), this.fix(m4.m11), this.fix(m4.m21)), V3.new3(this.fix(m4.m02), this.fix(m4.m12), this.fix(m4.m22))};
    }

    private float fix(float f) {
        return Math.abs(f) < 0.001f ? 0.0f : f;
    }

    public boolean isSameAs(UnitCell unitCell) {
        if (unitCell.notionalUnitcell.length != this.notionalUnitcell.length) {
            return false;
        }
        int n = this.notionalUnitcell.length;
        while (--n >= 0) {
            if (this.notionalUnitcell[n] == unitCell.notionalUnitcell[n] || Float.isNaN(this.notionalUnitcell[n]) && Float.isNaN(unitCell.notionalUnitcell[n])) continue;
            return false;
        }
        return this.fractionalOffset == null ? !unitCell.hasOffset() : (unitCell.fractionalOffset == null ? !this.hasOffset() : this.fractionalOffset.distanceSquared(unitCell.fractionalOffset) == 0.0f);
    }

    public boolean hasOffset() {
        return this.fractionalOffset != null && this.fractionalOffset.lengthSquared() != 0.0f;
    }

    public String getState() {
        String string = "";
        if (this.fractionalOffset != null && this.fractionalOffset.lengthSquared() != 0.0f) {
            string = string + "  unitcell offset " + Escape.eP(this.fractionalOffset) + ";\n";
        }
        if (this.unitCellMultiplier != null) {
            string = string + "  unitcell range " + Escape.eP(this.unitCellMultiplier) + ";\n";
        }
        return string;
    }

    public Quat getQuaternionRotation(String string) {
        V3 v3 = V3.newVsub(this.vertices[4], this.vertices[0]);
        V3 v32 = V3.newVsub(this.vertices[2], this.vertices[0]);
        V3 v33 = V3.newVsub(this.vertices[1], this.vertices[0]);
        V3 v34 = new V3();
        V3 v35 = new V3();
        switch ("abc".indexOf(string)) {
            case 0: {
                v34.cross(v3, v33);
                v35.cross(v34, v3);
                break;
            }
            case 1: {
                v34.cross(v32, v3);
                v35.cross(v34, v32);
                break;
            }
            case 2: {
                v34.cross(v33, v32);
                v35.cross(v34, v33);
                break;
            }
            default: {
                return null;
            }
        }
        return Quat.getQuaternionFrame(null, v35, v34).inv();
    }
}

