/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolZipUtilities;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JmolAsyncException;
import org.jmol.viewer.Viewer;

public class JmolBinary {
    public FileManager fm;
    public Map<String, Object> pngjCache;
    public Map<String, byte[]> spardirCache;
    public static final String JPEG_CONTINUE_STRING = " #Jmol...\u0000";
    public static final String PMESH_BINARY_MAGIC_NUMBER = "PM\u0001\u0000";
    JmolZipUtilities jzu;

    public JmolBinary(FileManager fileManager) {
        this.fm = fileManager;
    }

    public String determineSurfaceTypeIs(InputStream inputStream) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = Rdr.getBufferedReader(new BufferedInputStream(inputStream), "ISO-8859-1");
        }
        catch (IOException iOException) {
            return null;
        }
        return this.determineSurfaceFileType(bufferedReader);
    }

    public static String getEmbeddedScript(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf("**** Jmol Embedded Script ****");
        if (n < 0) {
            return string;
        }
        int n2 = string.lastIndexOf("/*", n);
        int n3 = string.indexOf((string.charAt(n2 + 2) == '*' ? "*" : "") + "*/", n);
        if (n2 >= 0 && n3 >= n) {
            string = string.substring(n + "**** Jmol Embedded Script ****".length(), n3) + "\n";
        }
        while ((n2 = string.indexOf(JPEG_CONTINUE_STRING)) >= 0) {
            string = string.substring(0, n2) + string.substring(n2 + JPEG_CONTINUE_STRING.length() + 4);
        }
        if (Logger.debugging) {
            Logger.debug(string);
        }
        return string;
    }

    private JmolZipUtilities getJzu() {
        return this.jzu == null ? (this.jzu = (JmolZipUtilities)Interface.getOption("io.JmolUtil", this.fm.vwr, "file")) : this.jzu;
    }

    public byte[] getCachedPngjBytes(String string) {
        return string.indexOf(".png") < 0 ? null : this.getJzu().getCachedPngjBytes(this, string);
    }

    public boolean clearAndCachePngjFile(String[] stringArray) {
        this.pngjCache = new Hashtable<String, Object>();
        return stringArray == null || stringArray[0] == null ? false : this.getJzu().cachePngjFile(this, stringArray);
    }

    public void spardirPut(String string, byte[] byArray) {
        if (this.spardirCache == null) {
            this.spardirCache = new Hashtable<String, byte[]>();
        }
        this.spardirCache.put(string, byArray);
    }

    public void clearPngjCache(String string) {
        if (this.pngjCache == null || string != null && !this.pngjCache.containsKey(string)) {
            return;
        }
        this.pngjCache = null;
        Logger.info("PNGJ cache cleared");
    }

    public void recachePngjBytes(String string, byte[] byArray) {
        if (this.pngjCache == null || !this.pngjCache.containsKey(string)) {
            return;
        }
        this.pngjCache.put(string, byArray);
        Logger.info("PNGJ recaching " + string + " (" + byArray.length + ")");
    }

    public Object getAtomSetCollectionOrBufferedReaderFromZip(JmolAdapter jmolAdapter, InputStream inputStream, String string, String[] stringArray, Map<String, Object> map, boolean bl) {
        return this.getJzu().getAtomSetCollectionOrBufferedReaderFromZip(this.fm.vwr, jmolAdapter, inputStream, string, stringArray, map, 1, bl);
    }

    public String[] spartanFileList(String string, String string2) {
        return this.getJzu().spartanFileList(this.fm.vwr.getJzt(), string, string2);
    }

    public String determineSurfaceFileType(BufferedReader bufferedReader) {
        return this.getJzu().determineSurfaceFileType(bufferedReader);
    }

    public Object getImage(Viewer viewer, Object object, String string) {
        return this.getJzu().getImage(viewer, object, string);
    }

    public static void getFileReferences(String string, Lst<String> lst) {
        for (int i = 0; i < FileManager.scriptFilePrefixes.length; ++i) {
            String string2 = FileManager.scriptFilePrefixes[i];
            int n = -1;
            while ((n = string.indexOf(string2, n + 1)) >= 0) {
                String string3 = PT.getQuotedStringAt(string, n);
                if (string3.indexOf("::") >= 0) {
                    string3 = PT.split(string3, "::")[1];
                }
                lst.addLast(string3);
            }
        }
    }

    public static String getManifestScriptPath(String string) {
        String string2;
        if (string.indexOf("$SCRIPT_PATH$") >= 0) {
            return "";
        }
        String string3 = string2 = string.indexOf(10) >= 0 ? "\n" : "\r";
        if (string.indexOf(".spt") >= 0) {
            String[] stringArray = PT.split(string, string2);
            int n = stringArray.length;
            while (--n >= 0) {
                if (stringArray[n].indexOf(".spt") < 0) continue;
                return "|" + PT.trim(stringArray[n], "\r\n \t");
            }
        }
        return null;
    }

    public static BufferedReader getBufferedReaderForResource(Viewer viewer, Object object, String string, String string2) throws IOException {
        URL uRL = object.getClass().getResource(string2);
        if (uRL == null) {
            System.err.println("Couldn't find file: " + string + string2);
            throw new IOException();
        }
        if (!viewer.async) {
            return Rdr.getBufferedReader(new BufferedInputStream((InputStream)uRL.getContent()), null);
        }
        String string3 = string2 = uRL == null ? viewer.vwrOptions.get("codePath") + string + string2 : uRL.getFile();
        if (viewer.async) {
            Object object2 = viewer.fm.cacheGet(string2, false);
            if (object2 == null) {
                throw new JmolAsyncException(string2);
            }
            return Rdr.getBufferedReader(Rdr.getBIS((byte[])object2), null);
        }
        return (BufferedReader)viewer.fm.getBufferedReaderOrErrorMessageFromName(string2, new String[]{null, null}, false, true);
    }
}

