/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.AU;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.LineRenderer;
import org.jmol.g3d.Pixelator;
import org.jmol.util.Shader;

class CylinderRenderer {
    private final Graphics3D g3d;
    private final LineRenderer line3d;
    private final Shader shader;
    private short colixA;
    private short colixB;
    private int[] shadesA;
    private int[] shadesB;
    private int xA;
    private int yA;
    private int zA;
    private int dxB;
    private int dyB;
    private int dzB;
    private float xAf;
    private float yAf;
    private float zAf;
    private float dxBf;
    private float dyBf;
    private float dzBf;
    private boolean tEvenDiameter;
    private int diameter;
    private byte endcaps;
    private boolean tEndcapOpen;
    private int xEndcap;
    private int yEndcap;
    private int zEndcap;
    private int argbEndcap;
    private short colixEndcap;
    private int endcapShadeIndex;
    private float radius;
    private float radius2;
    private float cosTheta;
    private float cosPhi;
    private float sinPhi;
    private boolean clipped;
    private boolean drawBackside;
    private int rasterCount;
    private float[][] xyztRaster = new float[][]{new float[32], new float[32], new float[32], new float[32]};
    private int[][] xyzfRaster = new int[][]{new int[32], new int[32], new int[32], new int[32]};
    private float xTip;
    private float yTip;
    private float zTip;

    CylinderRenderer(Graphics3D graphics3D) {
        this.g3d = graphics3D;
        this.line3d = graphics3D.line3d;
        this.shader = graphics3D.shader;
    }

    void render(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        Graphics3D graphics3D = this.g3d;
        int n11 = n / 2 + 1;
        int n12 = graphics3D.clipCode3(n2 - n11, n3 - n11, n4 - n11);
        boolean bl = this.clipped = (n12 | (n10 = graphics3D.clipCode3(n2 + n11, n3 + n11, n4 + n11)) | (n9 = graphics3D.clipCode3(n5 - n11, n6 - n11, n7 - n11)) | (n8 = graphics3D.clipCode3(n5 + n11, n6 + n11, n7 + n11))) != 0;
        if ((n12 & n8 & n10 & n9) != 0) {
            return;
        }
        this.dxB = n5 - n2;
        this.dyB = n6 - n3;
        this.dzB = n7 - n4;
        if (n <= 1) {
            this.line3d.plotLineDelta(graphics3D.getColorArgbOrGray(s), graphics3D.getColorArgbOrGray(s2), n2, n3, n4, this.dxB, this.dyB, this.dzB, this.clipped);
            return;
        }
        this.drawBackside = this.clipped || by == 2 || by == 0;
        this.diameter = n;
        this.xA = n2;
        this.yA = n3;
        this.zA = n4;
        this.endcaps = by;
        this.colixA = s;
        this.shadesA = graphics3D.getShades(this.colixA);
        this.colixB = s2;
        this.shadesB = graphics3D.getShades(this.colixB);
        this.calcArgbEndcap(true, false);
        this.calcCosSin(this.dxB, this.dyB, this.dzB);
        this.calcPoints(3, false);
        this.interpolate(0, 1, this.xyzfRaster, this.xyztRaster);
        this.interpolate(1, 2, this.xyzfRaster, this.xyztRaster);
        int[][] nArray = this.xyzfRaster;
        if (by == 2 || by == 4) {
            this.renderFlatEndcap(true, false, nArray);
        }
        graphics3D.setZMargin(5);
        int n13 = graphics3D.width;
        int[] nArray2 = graphics3D.zbuf;
        int[] nArray3 = nArray[0];
        int[] nArray4 = nArray[1];
        int[] nArray5 = nArray[2];
        int[] nArray6 = nArray[3];
        Pixelator pixelator = graphics3D.pixel;
        int n14 = this.rasterCount;
        while (--n14 >= 0) {
            int n15 = nArray6[n14] >> 8;
            int n16 = n15 >> 1;
            int n17 = nArray3[n14];
            int n18 = nArray4[n14];
            int n19 = nArray5[n14];
            if (this.tEndcapOpen && this.argbEndcap != 0) {
                if (this.clipped) {
                    graphics3D.plotPixelClippedArgb(this.argbEndcap, this.xEndcap + n17, this.yEndcap + n18, this.zEndcap - n19 - 1, n13, nArray2, pixelator);
                    graphics3D.plotPixelClippedArgb(this.argbEndcap, this.xEndcap - n17, this.yEndcap - n18, this.zEndcap + n19 - 1, n13, nArray2, pixelator);
                } else {
                    graphics3D.plotPixelUnclipped(this.argbEndcap, this.xEndcap + n17, this.yEndcap + n18, this.zEndcap - n19 - 1, n13, nArray2, pixelator);
                    graphics3D.plotPixelUnclipped(this.argbEndcap, this.xEndcap - n17, this.yEndcap - n18, this.zEndcap + n19 - 1, n13, nArray2, pixelator);
                }
            }
            this.line3d.plotLineDeltaA(this.shadesA, this.shadesB, n15, this.xA + n17, this.yA + n18, this.zA - n19, this.dxB, this.dyB, this.dzB, this.clipped);
            if (!this.drawBackside) continue;
            this.line3d.plotLineDelta(this.shadesA[n16], this.shadesB[n16], this.xA - n17, this.yA - n18, this.zA + n19, this.dxB, this.dyB, this.dzB, this.clipped);
        }
        graphics3D.setZMargin(0);
        if (by == 3) {
            this.renderSphericalEndcaps();
        }
    }

    void renderBits(short s, short s2, byte by, int n, float f, float f2, float f3, float f4, float f5, float f6) {
        int n2;
        int n3;
        int n4;
        int n5 = n / 2 + 1;
        int n6 = Math.round(f);
        int n7 = Math.round(f2);
        int n8 = Math.round(f3);
        int n9 = Math.round(f4);
        int n10 = Math.round(f5);
        int n11 = Math.round(f6);
        Graphics3D graphics3D = this.g3d;
        int n12 = graphics3D.clipCode3(n6 - n5, n7 - n5, n8 - n5);
        boolean bl = this.clipped = (n12 | (n4 = graphics3D.clipCode3(n6 + n5, n7 + n5, n8 + n5)) | (n3 = graphics3D.clipCode3(n9 - n5, n10 - n5, n11 - n5)) | (n2 = graphics3D.clipCode3(n9 + n5, n10 + n5, n11 + n5))) != 0;
        if ((n12 & n2 & n4 & n3) != 0) {
            return;
        }
        this.dxBf = f4 - f;
        this.dyBf = f5 - f2;
        this.dzBf = f6 - f3;
        if (n == 0 || n == 1) {
            this.line3d.plotLineDelta(graphics3D.getColorArgbOrGray(s), graphics3D.getColorArgbOrGray(s2), (int)f, (int)f2, (int)f3, (int)this.dxBf, (int)this.dyBf, (int)this.dzBf, this.clipped);
            return;
        }
        if (n > 0) {
            this.diameter = n;
            this.xAf = f;
            this.yAf = f2;
            this.zAf = f3;
        }
        this.drawBackside = this.clipped || by == 2 || by == 0;
        this.xA = (int)this.xAf;
        this.yA = (int)this.yAf;
        this.zA = (int)this.zAf;
        this.dxB = (int)this.dxBf;
        this.dyB = (int)this.dyBf;
        this.dzB = (int)this.dzBf;
        this.colixA = s;
        this.shadesA = graphics3D.getShades(this.colixA);
        this.colixB = s2;
        this.shadesB = graphics3D.getShades(this.colixB);
        this.endcaps = by;
        this.calcArgbEndcap(true, true);
        int[][] nArray = this.xyzfRaster;
        if (n > 0) {
            this.generateBaseEllipsePrecisely(false);
        }
        if (by == 2) {
            this.renderFlatEndcap(true, true, nArray);
        }
        this.line3d.setLineBits(this.dxBf, this.dyBf);
        graphics3D.setZMargin(5);
        Pixelator pixelator = graphics3D.pixel;
        int n13 = graphics3D.width;
        int[] nArray2 = graphics3D.zbuf;
        int[] nArray3 = nArray[0];
        int[] nArray4 = nArray[1];
        int[] nArray5 = nArray[2];
        int[] nArray6 = nArray[3];
        int n14 = this.rasterCount;
        while (--n14 >= 0) {
            int n15 = nArray6[n14] >> 8;
            int n16 = n15 >> 1;
            int n17 = nArray3[n14];
            int n18 = nArray4[n14];
            int n19 = nArray5[n14];
            if (this.tEndcapOpen && this.argbEndcap != 0) {
                if (this.clipped) {
                    graphics3D.plotPixelClippedArgb(this.argbEndcap, this.xEndcap + n17, this.yEndcap + n18, this.zEndcap - n19 - 1, n13, nArray2, pixelator);
                    graphics3D.plotPixelClippedArgb(this.argbEndcap, this.xEndcap - n17, this.yEndcap - n18, this.zEndcap + n19 - 1, n13, nArray2, pixelator);
                } else {
                    graphics3D.plotPixelUnclipped(this.argbEndcap, this.xEndcap + n17, this.yEndcap + n18, this.zEndcap - n19 - 1, n13, nArray2, pixelator);
                    graphics3D.plotPixelUnclipped(this.argbEndcap, this.xEndcap - n17, this.yEndcap - n18, this.zEndcap + n19 - 1, n13, nArray2, pixelator);
                }
            }
            this.line3d.plotLineDeltaBits(this.shadesA, this.shadesB, n15, this.xA + n17, this.yA + n18, this.zA - n19, this.dxB, this.dyB, this.dzB, this.clipped);
            if (!this.drawBackside) continue;
            this.line3d.plotLineDelta(this.shadesA[n16], this.shadesB[n16], this.xA - n17, this.yA - n18, this.zA + n19, this.dxB, this.dyB, this.dzB, this.clipped);
        }
        graphics3D.setZMargin(0);
        if (by == 3) {
            this.renderSphericalEndcaps();
        }
        this.xAf += this.dxBf;
        this.yAf += this.dyBf;
        this.zAf += this.dzBf;
    }

    void renderCone(short s, byte by, int n, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, boolean bl2) {
        this.xAf = f;
        this.dxBf = f4 - this.xAf;
        this.yAf = f2;
        this.dyBf = f5 - this.yAf;
        this.zAf = f3;
        this.dzBf = f6 - this.zAf;
        this.xA = (int)Math.floor(this.xAf);
        this.yA = (int)Math.floor(this.yAf);
        this.zA = (int)Math.floor(this.zAf);
        this.dxB = (int)Math.floor(this.dxBf);
        this.dyB = (int)Math.floor(this.dyBf);
        this.dzB = (int)Math.floor(this.dzBf);
        this.xTip = f4;
        this.yTip = f5;
        this.zTip = f6;
        this.colixA = s;
        this.shadesA = this.g3d.getShades(s);
        int n2 = this.shader.getShadeIndex(this.dxB, this.dyB, -this.dzB);
        Graphics3D graphics3D = this.g3d;
        Pixelator pixelator = graphics3D.pixel;
        int n3 = graphics3D.width;
        int[] nArray = graphics3D.zbuf;
        graphics3D.plotPixelClippedArgb(this.shadesA[n2], (int)f4, (int)f5, (int)f6, n3, nArray, pixelator);
        this.diameter = n;
        if (n <= 1) {
            if (n == 1) {
                this.line3d.plotLineDelta(this.colixA, this.colixA, this.xA, this.yA, this.zA, this.dxB, this.dyB, this.dzB, this.clipped);
            }
            return;
        }
        this.endcaps = by;
        this.calcArgbEndcap(false, true);
        this.generateBaseEllipsePrecisely(bl2);
        if (!bl2 && this.endcaps == 2) {
            this.renderFlatEndcap(false, true, this.xyzfRaster);
        }
        graphics3D.setZMargin(5);
        float[] fArray = this.xyztRaster[0];
        float[] fArray2 = this.xyztRaster[1];
        float[] fArray3 = this.xyztRaster[2];
        int[] nArray2 = this.xyzfRaster[3];
        int[] nArray3 = this.shadesA;
        boolean bl3 = this.tEndcapOpen && this.argbEndcap != 0;
        int n4 = this.rasterCount;
        while (--n4 >= 0) {
            float f7 = fArray[n4];
            float f8 = fArray2[n4];
            float f9 = fArray3[n4];
            int n5 = nArray2[n4] >> 8;
            float f10 = this.xAf + f7;
            float f11 = this.yAf + f8;
            float f12 = this.zAf - f9;
            float f13 = this.xAf - f7;
            float f14 = this.yAf - f8;
            float f15 = this.zAf + f9;
            int n6 = nArray3[0];
            if (bl3) {
                graphics3D.plotPixelClippedArgb(this.argbEndcap, (int)f10, (int)f11, (int)f12, n3, nArray, pixelator);
                graphics3D.plotPixelClippedArgb(this.argbEndcap, (int)f13, (int)f14, (int)f15, n3, nArray, pixelator);
            }
            if (n6 == 0) continue;
            this.line3d.plotLineDeltaA(nArray3, nArray3, n5, (int)f10, (int)f11, (int)f12, (int)Math.ceil(this.xTip - f10), (int)Math.ceil(this.yTip - f11), (int)Math.ceil(this.zTip - f12), true);
            if (bl) {
                this.line3d.plotLineDeltaA(nArray3, nArray3, n5, (int)f10, (int)f11 + 1, (int)f12, (int)Math.ceil(this.xTip - f10), (int)Math.ceil(this.yTip - f11) + 1, (int)Math.ceil(this.zTip - f12), true);
                this.line3d.plotLineDeltaA(nArray3, nArray3, n5, (int)f10 + 1, (int)f11, (int)f12, (int)Math.ceil(this.xTip - f10) + 1, (int)Math.ceil(this.yTip - f11), (int)Math.ceil(this.zTip - f12), true);
            }
            if (bl2 || this.endcaps != 2 && this.dzB > 0) continue;
            this.line3d.plotLineDelta(n6, n6, (int)f13, (int)f14, (int)f15, (int)Math.ceil(this.xTip - f13), (int)Math.ceil(this.yTip - f14), (int)Math.ceil(this.zTip - f15), true);
        }
        graphics3D.setZMargin(0);
    }

    private void generateBaseEllipsePrecisely(boolean bl) {
        this.calcCosSin(this.dxBf, this.dyBf, this.dzBf);
        this.calcPoints(bl ? 2 : 3, true);
        this.interpolatePrecisely(0, 1, this.xyzfRaster, this.xyztRaster);
        if (!bl) {
            this.interpolatePrecisely(1, 2, this.xyzfRaster, this.xyztRaster);
        }
        int n = 3;
        while (--n >= 0) {
            int n2 = this.rasterCount;
            while (--n2 >= 0) {
                this.xyzfRaster[n][n2] = (int)Math.floor(this.xyztRaster[n][n2]);
            }
        }
    }

    private void calcPoints(int n, boolean bl) {
        this.calcRotatedPoint(0.0f, 0, bl, this.xyzfRaster, this.xyztRaster);
        this.calcRotatedPoint(0.5f, 1, bl, this.xyzfRaster, this.xyztRaster);
        this.rasterCount = n;
        if (this.rasterCount == 3) {
            this.calcRotatedPoint(1.0f, 2, bl, this.xyzfRaster, this.xyztRaster);
        }
    }

    private void calcCosSin(float f, float f2, float f3) {
        float f4 = f * f + f2 * f2;
        if (f4 == 0.0f) {
            this.cosTheta = 1.0f;
            this.cosPhi = 1.0f;
            this.sinPhi = 0.0f;
        } else {
            float f5 = (float)Math.sqrt(f4);
            float f6 = (float)Math.sqrt(f4 + f3 * f3);
            this.cosTheta = f3 / f6;
            this.cosPhi = f / f5;
            this.sinPhi = f2 / f5;
        }
    }

    private void calcRotatedPoint(float f, int n, boolean bl, int[][] nArray, float[][] fArray) {
        double d;
        double d2;
        double d3;
        fArray[3][n] = f;
        double d4 = (double)f * Math.PI;
        double d5 = Math.sin(d4) * (double)this.cosTheta;
        double d6 = (double)this.radius * (d5 * (double)this.cosPhi - (d3 = Math.cos(d4)) * (double)this.sinPhi);
        double d7 = (double)this.radius2 - (d6 * d6 + (d2 = (double)this.radius * (d5 * (double)this.sinPhi + d3 * (double)this.cosPhi)) * d2);
        double d8 = d = d7 > 0.0 ? Math.sqrt(d7) : 0.0;
        if (bl) {
            fArray[0][n] = (float)d6;
            fArray[1][n] = (float)d2;
            fArray[2][n] = (float)d;
        } else if (this.tEvenDiameter) {
            nArray[0][n] = (int)(d6 - 0.5);
            nArray[1][n] = (int)(d2 - 0.5);
            nArray[2][n] = (int)(d + 0.5);
        } else {
            nArray[0][n] = (int)d6;
            nArray[1][n] = (int)d2;
            nArray[2][n] = (int)(d + 0.5);
        }
        nArray[3][n] = this.shader.getShadeFp8((float)d6, (float)d2, (float)d);
    }

    private int allocRaster(boolean bl, int[][] nArray, float[][] fArray) {
        int n;
        if (this.rasterCount >= nArray[0].length) {
            while (this.rasterCount >= nArray[0].length) {
                n = 4;
                while (--n >= 0) {
                    nArray[n] = AU.doubleLengthI(nArray[n]);
                }
                fArray[3] = AU.doubleLengthF(fArray[3]);
            }
        }
        if (bl) {
            while (this.rasterCount >= fArray[0].length) {
                n = 3;
                while (--n >= 0) {
                    fArray[n] = AU.doubleLengthF(fArray[n]);
                }
            }
        }
        return this.rasterCount++;
    }

    private void interpolate(int n, int n2, int[][] nArray, float[][] fArray) {
        int n3;
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        int n4 = nArray2[n2] - nArray2[n];
        if (n4 < 0) {
            n4 = -n4;
        }
        if ((n3 = nArray3[n2] - nArray3[n]) < 0) {
            n3 = -n3;
        }
        if (n4 + n3 <= 1) {
            return;
        }
        int n5 = this.allocRaster(false, nArray, fArray);
        nArray2 = nArray[0];
        nArray3 = nArray[1];
        int[] nArray4 = nArray[3];
        float f = fArray[3][n];
        float f2 = fArray[3][n2];
        int n6 = 4;
        while (--n6 >= 0) {
            float f3 = (f + f2) / 2.0f;
            this.calcRotatedPoint(f3, n5, false, nArray, fArray);
            if (nArray2[n5] == nArray2[n] && nArray3[n5] == nArray3[n]) {
                nArray4[n] = nArray4[n] + nArray4[n5] >>> 1;
                f = f3;
                continue;
            }
            if (nArray2[n5] == nArray2[n2] && nArray3[n5] == nArray3[n2]) {
                nArray4[n2] = nArray4[n2] + nArray4[n5] >>> 1;
                f2 = f3;
                continue;
            }
            this.interpolate(n, n5, nArray, fArray);
            this.interpolate(n5, n2, nArray, fArray);
            return;
        }
        nArray2[n5] = nArray2[n];
        nArray3[n5] = nArray3[n2];
    }

    private void interpolatePrecisely(int n, int n2, int[][] nArray, float[][] fArray) {
        float f;
        float[] fArray2 = fArray[0];
        float[] fArray3 = fArray[1];
        int n3 = (int)Math.floor(fArray2[n2]) - (int)Math.floor(fArray2[n]);
        if (n3 < 0) {
            n3 = -n3;
        }
        if ((f = (float)((int)Math.floor(fArray3[n2]) - (int)Math.floor(fArray3[n]))) < 0.0f) {
            f = -f;
        }
        if ((float)n3 + f <= 1.0f) {
            return;
        }
        float[] fArray4 = fArray[3];
        float f2 = fArray4[n];
        float f3 = fArray4[n2];
        int n4 = this.allocRaster(true, nArray, fArray);
        fArray2 = fArray[0];
        fArray3 = fArray[1];
        fArray4 = fArray[3];
        int[] nArray2 = nArray[3];
        int n5 = 4;
        while (--n5 >= 0) {
            float f4 = (f2 + f3) / 2.0f;
            this.calcRotatedPoint(f4, n4, true, nArray, fArray);
            if ((int)Math.floor(fArray2[n4]) == (int)Math.floor(fArray2[n]) && (int)Math.floor(fArray3[n4]) == (int)Math.floor(fArray3[n])) {
                nArray2[n] = nArray2[n] + nArray2[n4] >>> 1;
                f2 = f4;
                continue;
            }
            if ((int)Math.floor(fArray2[n4]) == (int)Math.floor(fArray2[n2]) && (int)Math.floor(fArray3[n4]) == (int)Math.floor(fArray3[n2])) {
                nArray2[n2] = nArray2[n2] + nArray2[n4] >>> 1;
                f3 = f4;
                continue;
            }
            this.interpolatePrecisely(n, n4, nArray, fArray);
            this.interpolatePrecisely(n4, n2, nArray, fArray);
            return;
        }
        fArray2[n4] = fArray2[n];
        fArray3[n4] = fArray3[n2];
    }

    private void renderFlatEndcap(boolean bl, boolean bl2, int[][] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (bl2) {
            if (this.dzBf == 0.0f || !this.g3d.setC(this.colixEndcap)) {
                return;
            }
            float f = this.xAf;
            float f2 = this.yAf;
            float f3 = this.zAf;
            if (bl && this.dzBf < 0.0f) {
                f += this.dxBf;
                f2 += this.dyBf;
                f3 += this.dzBf;
            }
            n4 = (int)f;
            n3 = (int)f2;
            n2 = (int)f3;
        } else {
            if (this.dzB == 0 || !this.g3d.setC(this.colixEndcap)) {
                return;
            }
            n4 = this.xA;
            n3 = this.yA;
            n2 = this.zA;
            if (bl && this.dzB < 0) {
                if (this.endcaps == 4) {
                    return;
                }
                n4 += this.dxB;
                n3 += this.dyB;
                n2 += this.dzB;
            }
        }
        int n5 = nArray[1][0];
        int n6 = nArray[1][0];
        int n7 = 0;
        int n8 = 0;
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        int[] nArray4 = nArray[2];
        int n9 = this.rasterCount;
        while (--n9 > 0) {
            n = nArray3[n9];
            if (n < n5) {
                n5 = n;
                continue;
            }
            if (n > n6) {
                n6 = n;
                continue;
            }
            if ((n = -n) < n5) {
                n5 = n;
                continue;
            }
            if (n <= n6) continue;
            n6 = n;
        }
        for (n9 = n5; n9 <= n6; ++n9) {
            n = Integer.MAX_VALUE;
            int n10 = Integer.MIN_VALUE;
            int n11 = this.rasterCount;
            while (--n11 >= 0) {
                int n12;
                if (nArray3[n11] == n9) {
                    n12 = nArray2[n11];
                    if (n12 < n) {
                        n = n12;
                        n7 = nArray4[n11];
                    }
                    if (n12 > n10) {
                        n10 = n12;
                        n8 = nArray4[n11];
                    }
                }
                if (nArray3[n11] != -n9) continue;
                n12 = -nArray2[n11];
                if (n12 < n) {
                    n = n12;
                    n7 = -nArray4[n11];
                }
                if (n12 <= n10) continue;
                n10 = n12;
                n8 = -nArray4[n11];
            }
            n11 = n10 - n + 1;
            this.g3d.setColorNoisy(this.endcapShadeIndex);
            this.g3d.plotPixelsClippedRaster(n11, n4 + n, n3 + n9, n2 - n7 - 1, n2 - n8 - 1, null, null);
        }
    }

    private void renderSphericalEndcaps() {
        if (this.colixA != 0 && this.g3d.setC(this.colixA)) {
            this.g3d.fillSphereXYZ(this.diameter, this.xA, this.yA, this.zA + 1);
        }
        if (this.colixB != 0 && this.g3d.setC(this.colixB)) {
            this.g3d.fillSphereXYZ(this.diameter, this.xA + this.dxB, this.yA + this.dyB, this.zA + this.dzB + 1);
        }
    }

    private void calcArgbEndcap(boolean bl, boolean bl2) {
        int[] nArray;
        float f;
        float f2;
        this.tEvenDiameter = (this.diameter & 1) == 0;
        this.radius = (float)this.diameter / 2.0f;
        this.radius2 = this.radius * this.radius;
        this.tEndcapOpen = false;
        float f3 = f2 = bl2 ? this.dzBf : (float)this.dzB;
        if (this.endcaps == 3 || f2 == 0.0f) {
            return;
        }
        this.xEndcap = this.xA;
        this.yEndcap = this.yA;
        this.zEndcap = this.zA;
        float f4 = bl2 ? this.dxBf : (float)this.dxB;
        float f5 = f = bl2 ? this.dyBf : (float)this.dyB;
        if (f2 >= 0.0f || !bl) {
            this.endcapShadeIndex = this.shader.getShadeIndex(-f4, -f, f2);
            this.colixEndcap = this.colixA;
            nArray = this.shadesA;
        } else {
            this.endcapShadeIndex = this.shader.getShadeIndex(f4, f, -f2);
            this.colixEndcap = this.colixB;
            nArray = this.shadesB;
            this.xEndcap += this.dxB;
            this.yEndcap += this.dyB;
            this.zEndcap += this.dzB;
        }
        if (this.endcapShadeIndex > 56) {
            this.endcapShadeIndex = 56;
        }
        this.argbEndcap = nArray[this.endcapShadeIndex];
        this.tEndcapOpen = this.endcaps == 1;
    }
}

