/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import java.util.Map;
import javajs.J2SRequireImport;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.Quat;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Model;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;

@J2SRequireImport(value={Short.class, JC.class})
public class Group {
    public int groupIndex;
    public char group1;
    public Chain chain;
    public int firstAtomIndex = -1;
    public int leadAtomIndex = -1;
    public int lastAtomIndex;
    public int seqcode;
    public short groupID;
    int selectedIndex;
    private static final int SEQUENCE_NUMBER_FLAG = 128;
    private static final int INSERTION_CODE_MASK = 127;
    private static final int SEQUENCE_NUMBER_SHIFT = 8;
    public int shapeVisibilityFlags;
    private BS bsAdded;
    public static Map<String, Short> htGroup = new Hashtable<String, Short>();
    public static String standardGroupList;
    public static String[] group3Names;
    public static String[] specialAtomNames;

    public Group setGroup(Chain chain, String string, int n, int n2, int n3) {
        this.chain = chain;
        this.seqcode = n;
        this.firstAtomIndex = n2;
        this.lastAtomIndex = n3;
        if (string != null && string.length() > 0) {
            this.setGroupID(string);
        }
        return this;
    }

    protected void setGroupID(String string) {
    }

    public final void setShapeVisibility(int n, boolean bl) {
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= n) : (this.shapeVisibilityFlags &= ~n);
    }

    public String getGroup3() {
        return this.groupID < 1 ? "" : group3Names[this.groupID];
    }

    public char getGroup1() {
        return '?';
    }

    public int getBioPolymerLength() {
        return 0;
    }

    public int getMonomerIndex() {
        return -1;
    }

    public Group[] getGroups() {
        return null;
    }

    public Object getStructure() {
        return null;
    }

    public int getStrucNo() {
        return 0;
    }

    public STR getProteinStructureType() {
        return STR.NOT;
    }

    public STR getProteinStructureSubType() {
        return this.getProteinStructureType();
    }

    public int setProteinStructureType(STR sTR, int n) {
        return -1;
    }

    public boolean isProtein() {
        return false;
    }

    public boolean isNucleic() {
        return false;
    }

    public boolean isDna() {
        return false;
    }

    public boolean isRna() {
        return false;
    }

    public boolean isPurine() {
        return false;
    }

    public boolean isPyrimidine() {
        return false;
    }

    public boolean isCarbohydrate() {
        return false;
    }

    public final int getResno() {
        return this.seqcode == Integer.MIN_VALUE ? 0 : this.seqcode >> 8;
    }

    public static final int getSeqNumberFor(int n) {
        return Group.haveSequenceNumber(n) ? n >> 8 : Integer.MAX_VALUE;
    }

    public static final boolean haveSequenceNumber(int n) {
        return (n & 0x80) != 0;
    }

    public final String getSeqcodeString() {
        return Group.getSeqcodeStringFor(this.seqcode);
    }

    public static int getSeqcodeFor(int n, char c) {
        if (n == Integer.MIN_VALUE) {
            return n;
        }
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '?' || c == '*')) {
            if (c != ' ' && c != '\u0000') {
                Logger.warn("unrecognized insertionCode:" + c);
            }
            c = '\u0000';
        }
        return (n == Integer.MAX_VALUE ? 0 : n << 8 | 0x80) + c;
    }

    public static String getSeqcodeStringFor(int n) {
        if (n == Integer.MIN_VALUE) {
            return null;
        }
        return (n & 0x7F) == 0 ? "" + (n >> 8) : "" + (n >> 8) + '^' + (char)(n & 0x7F);
    }

    public char getInsertionCode() {
        if (this.seqcode == Integer.MIN_VALUE) {
            return '\u0000';
        }
        return (char)(this.seqcode & 0x7F);
    }

    public static int getInsertionCodeFor(int n) {
        return n & 0x7F;
    }

    public static char getInsertionCodeChar(int n) {
        return n == Integer.MIN_VALUE ? (char)'\u0000' : (char)(n & 0x7F);
    }

    public boolean isAdded(int n) {
        return this.bsAdded != null && this.bsAdded.get(n);
    }

    public void addAtoms(int n) {
        if (this.bsAdded == null) {
            this.bsAdded = new BS();
        }
        this.bsAdded.set(n);
    }

    public int selectAtoms(BS bS) {
        bS.setBits(this.firstAtomIndex, this.lastAtomIndex + 1);
        if (this.bsAdded != null) {
            bS.or(this.bsAdded);
        }
        return this.lastAtomIndex;
    }

    public boolean isSelected(BS bS) {
        int n = bS.nextSetBit(this.firstAtomIndex);
        return n >= 0 && n <= this.lastAtomIndex || this.bsAdded != null && this.bsAdded.intersects(bS);
    }

    boolean isHetero() {
        return this.chain.getAtom(this.firstAtomIndex).isHetero();
    }

    public String toString() {
        return "[" + this.getGroup3() + "-" + this.getSeqcodeString() + "]";
    }

    protected float scaleToScreen(int n, int n2) {
        return this.chain.model.ms.vwr.tm.scaleToScreen(n, n2);
    }

    protected boolean isCursorOnTopOf(Atom atom, int n, int n2, int n3, Atom atom2) {
        return this.chain.model.ms.isCursorOnTopOf(atom, n, n2, n3, atom2);
    }

    public Model getModel() {
        return this.chain.model;
    }

    public int getModelIndex() {
        return this.chain.model.modelIndex;
    }

    public int getSelectedMonomerCount() {
        return 0;
    }

    public int getSelectedMonomerIndex() {
        return -1;
    }

    public int getSelectedGroupIndex() {
        return this.selectedIndex;
    }

    public boolean isLeadAtom(int n) {
        return false;
    }

    public Atom getLeadAtomOr(Atom atom) {
        Atom atom2 = this.getLeadAtom();
        return atom2 == null ? atom : atom2;
    }

    public Atom getLeadAtom() {
        return null;
    }

    public Quat getQuaternion(char c) {
        return null;
    }

    public Quat getQuaternionFrame(Atom[] atomArray) {
        if (this.lastAtomIndex - this.firstAtomIndex < 3) {
            return null;
        }
        int n = this.firstAtomIndex;
        return Quat.getQuaternionFrame(atomArray[n], atomArray[++n], atomArray[++n]);
    }

    public void setStrucNo(int n) {
    }

    public Object getHelixData(int n, char c, int n2) {
        return Escape.escapeHelical(null, n, null, null, null);
    }

    public boolean isWithinStructure(STR sTR) {
        return false;
    }

    public String getProteinStructureTag() {
        return null;
    }

    public String getStructureId() {
        return "";
    }

    public int getBioPolymerIndexInModel() {
        return -1;
    }

    public boolean isCrossLinked(Group group) {
        return false;
    }

    public boolean getCrossLinkLead(Lst<Integer> lst) {
        return false;
    }

    public boolean isConnectedPrevious() {
        return false;
    }

    public Atom getNitrogenAtom() {
        return null;
    }

    public Atom getCarbonylOxygenAtom() {
        return null;
    }

    public void fixIndices(int n, BS bS) {
        this.firstAtomIndex -= n;
        this.leadAtomIndex -= n;
        this.lastAtomIndex -= n;
        if (this.bsAdded != null) {
            BSUtil.deleteBits(this.bsAdded, bS);
        }
    }

    public Map<String, Object> getGroupInfo(int n, P3 p3) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("groupIndex", n);
        hashtable.put("groupID", this.groupID);
        String string = this.getSeqcodeString();
        if (string != null) {
            hashtable.put("seqCode", string);
        }
        hashtable.put("_apt1", this.firstAtomIndex);
        hashtable.put("_apt2", this.lastAtomIndex);
        if (this.bsAdded != null) {
            hashtable.put("addedAtoms", this.bsAdded);
        }
        hashtable.put("atomInfo1", this.chain.model.ms.getAtomInfo(this.firstAtomIndex, null, p3));
        hashtable.put("atomInfo2", this.chain.model.ms.getAtomInfo(this.lastAtomIndex, null, p3));
        hashtable.put("visibilityFlags", this.shapeVisibilityFlags);
        return hashtable;
    }

    public void getMinZ(Atom[] atomArray, int[] nArray) {
        int n;
        nArray[0] = Integer.MAX_VALUE;
        for (n = this.firstAtomIndex; n <= this.lastAtomIndex; ++n) {
            this.checkMinZ(atomArray[n], nArray);
        }
        if (this.bsAdded != null) {
            n = this.bsAdded.nextSetBit(0);
            while (n >= 0) {
                this.checkMinZ(atomArray[n], nArray);
                n = this.bsAdded.nextSetBit(n + 1);
            }
        }
    }

    private void checkMinZ(Atom atom, int[] nArray) {
        int n = atom.sZ - atom.sD / 2 - 2;
        if (n < nArray[0]) {
            nArray[0] = Math.max(1, n);
        }
    }

    public float getGroupParameter(int n) {
        return Float.NaN;
    }

    public int getAtomIndex(String string, int n) {
        return -1;
    }

    public BS getBSSideChain() {
        return new BS();
    }

    static {
        group3Names = new String[128];
    }
}

