/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.JvxlXmlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class JvxlReader
extends JvxlXmlReader {
    JvxlReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2JXR(surfaceGenerator, bufferedReader);
        this.isXmlFile = false;
        this.JVXL_VERSION = "2.0";
    }

    @Override
    protected void readParameters() throws Exception {
        int n;
        this.jvxlFileHeaderBuffer = new SB().append(this.skipComments(false));
        if (this.line == null || this.line.length() == 0) {
            this.line = "Line 1";
        }
        this.jvxlFileHeaderBuffer.append(this.line).appendC('\n');
        if (this.rd() == null || this.line.length() == 0) {
            this.line = "Line 2";
        }
        this.jvxlFileHeaderBuffer.append(this.line).appendC('\n');
        this.jvxlFileHeaderBuffer.append(this.skipComments(false));
        String string = this.line;
        String[] stringArray = PT.getTokensAt(string, 0);
        this.isXLowToHigh = false;
        this.negativeAtomCount = true;
        this.ac = 0;
        if (stringArray[0] != "-0") {
            if (stringArray[0].charAt(0) == '+') {
                this.isXLowToHigh = true;
                this.ac = this.parseIntStr(stringArray[0].substring(1));
            } else {
                this.ac = -this.parseIntStr(stringArray[0]);
            }
        }
        if (this.ac == Integer.MIN_VALUE) {
            return;
        }
        this.volumetricOrigin.set(this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[3]));
        this.isAngstroms = VolumeFileReader.checkAtomLine(this.isXLowToHigh, this.isAngstroms, null, string, this.jvxlFileHeaderBuffer);
        if (!this.isAngstroms) {
            this.volumetricOrigin.scale(0.5291772f);
        }
        this.readVoxelVector(0);
        this.readVoxelVector(1);
        this.readVoxelVector(2);
        for (n = 0; n < this.ac; ++n) {
            this.jvxlFileHeaderBuffer.append(this.rd() + "\n");
        }
        this.skipComments(true);
        Logger.info("Reading extra JVXL information line: " + this.line);
        this.nSurfaces = this.parseIntStr(this.line);
        this.isJvxl = this.nSurfaces < 0;
        if (!this.isJvxl) {
            return;
        }
        this.nSurfaces = -this.nSurfaces;
        Logger.info("jvxl file surfaces: " + this.nSurfaces);
        n = this.parseInt();
        if (n == Integer.MIN_VALUE) {
            Logger.info("using default edge fraction base and range");
        } else {
            this.edgeFractionBase = n;
            this.edgeFractionRange = this.parseInt();
        }
        n = this.parseInt();
        if (n == Integer.MIN_VALUE) {
            Logger.info("using default color fraction base and range");
        } else {
            this.colorFractionBase = n;
            this.colorFractionRange = this.parseInt();
        }
        this.cJvxlEdgeNaN = (char)(this.edgeFractionBase + this.edgeFractionRange);
        this.jvxlData.vertexDataOnly = this.volumetricVectors[0].length() == 0.0f;
        this.vertexDataOnly = this.jvxlData.vertexDataOnly;
    }

    @Override
    protected String jvxlReadFractionData(String string, int n) {
        String string2 = "";
        try {
            while (string2.length() < n) {
                this.rd();
                string2 = string2 + JvxlCoder.jvxlDecompressString(this.line);
            }
        }
        catch (Exception exception) {
            Logger.error("Error reading " + string + " data " + exception);
            throw new NullPointerException();
        }
        return string2;
    }

    @Override
    protected void gotoData(int n, int n2) throws Exception {
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + n2 + " points each");
        }
        this.jvxlData.vertexDataOnly = n2 == 0;
        this.vertexDataOnly = this.jvxlData.vertexDataOnly;
        for (int i = 0; i < n; ++i) {
            this.jvxlReadDefinitionLine(true);
            Logger.info("JVXL skipping: jvxlSurfaceDataCount=" + this.surfaceDataCount + " jvxlEdgeDataCount=" + this.edgeDataCount + " jvxlDataIsColorMapped=" + this.jvxlDataIsColorMapped);
            this.jvxlSkipData(n2, true);
        }
        this.jvxlReadDefinitionLine(true);
    }

    private void jvxlReadDefinitionLine(boolean bl) throws Exception {
        boolean bl2;
        String string = this.skipComments(true);
        if (bl) {
            Logger.info("reading jvxl data set: " + string + this.line);
        }
        this.haveContourData = string.indexOf("+contourlines") >= 0;
        this.jvxlCutoff = this.parseFloatStr(this.line);
        Logger.info("JVXL read: cutoff " + this.jvxlCutoff);
        int n = this.parseInt();
        int n2 = this.parseInt();
        int n3 = this.parseInt();
        if (n3 == Integer.MIN_VALUE || n3 == -1) {
            n3 = 0;
        }
        if (n == -1) {
            try {
                this.params.thePlane = P4.new4(this.parseFloat(), this.parseFloat(), this.parseFloat(), this.parseFloat());
            }
            catch (Exception exception) {
                Logger.error("Error reading 4 floats for PLANE definition -- setting to 0 0 1 0  (z=0)");
                this.params.thePlane = P4.new4(0.0f, 0.0f, 1.0f, 0.0f);
            }
            Logger.info("JVXL read: plane " + this.params.thePlane);
            if (n2 == -1 && n3 < 0) {
                n3 = -n3;
            }
        } else {
            this.params.thePlane = null;
        }
        if (n < 0 && n2 != -1) {
            this.params.isContoured = n3 != 0;
            int n4 = this.parseInt();
            if (n4 == Integer.MIN_VALUE) {
                if (this.line.charAt(this.next[0]) == '[') {
                    this.params.contoursDiscrete = this.parseFloatArray(null, null, null);
                    this.jvxlData.contourValues = this.params.contoursDiscrete;
                    Logger.info("JVXL read: contourValues " + Escape.eAF(this.jvxlData.contourValues));
                    this.params.contourColixes = C.getColixArray(this.getQuotedStringNext());
                    this.jvxlData.contourColixes = this.params.contourColixes;
                    this.jvxlData.contourColors = C.getHexCodes(this.jvxlData.contourColixes);
                    Logger.info("JVXL read: contourColixes " + this.jvxlData.contourColors);
                    this.params.nContours = this.jvxlData.contourValues.length;
                }
            } else {
                if (n4 < 0) {
                    n4 = -1 - n4;
                    this.params.contourFromZero = false;
                }
                if (n4 != 0 && this.params.nContours == 0) {
                    this.params.nContours = n4;
                    Logger.info("JVXL read: contours " + this.params.nContours);
                }
            }
        } else {
            this.params.isContoured = false;
        }
        this.jvxlData.isJvxlPrecisionColor = n == -1 && n2 == -2 || n3 < 0;
        this.params.isBicolorMap = n > 0 && n2 < 0;
        this.jvxlDataIsColorMapped = n3 != 0;
        boolean bl3 = this.jvxlDataIs2dContour = this.jvxlDataIsColorMapped && this.params.isContoured;
        if (this.params.isBicolorMap || this.params.colorBySign) {
            this.jvxlCutoff = 0.0f;
        }
        int n5 = n < -1 ? -1 - n : (this.surfaceDataCount = n > 0 ? n : 0);
        if (n == -1) {
            this.edgeDataCount = 0;
        } else {
            int n6 = n2 < -1 ? -n2 : (this.edgeDataCount = n2 > 0 ? n2 : 0);
        }
        int n7 = this.params.isBicolorMap ? -n2 : (n3 < -1 ? -n3 : (this.colorDataCount = n3 > 0 ? n3 : 0));
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        float f = Float.NaN;
        float f2 = Float.NaN;
        float f3 = Float.NaN;
        float f4 = Float.NaN;
        boolean bl4 = bl2 = this.line.indexOf("insideOut") >= 0;
        if (this.jvxlDataIsColorMapped) {
            f = this.parseFloat();
            f2 = this.parseFloat();
            f3 = this.parseFloat();
            f4 = this.parseFloat();
        }
        this.jvxlSetColorRanges(f, f2, f3, f4, bl2);
    }

    @Override
    protected void readSurfaceData(boolean bl) throws Exception {
        boolean bl2 = this.thisInside = !this.params.isContoured;
        if (!this.readSurfaceDataXML()) {
            this.readSurfaceDataJXR();
        }
    }

    @Override
    protected void jvxlSkipData(int n, boolean bl) throws Exception {
        if (this.surfaceDataCount > 0) {
            this.jvxlSkipDataBlock(n, true);
        }
        if (this.edgeDataCount > 0) {
            this.jvxlSkipDataBlock(this.edgeDataCount, false);
        }
        if (this.jvxlDataIsColorMapped && bl) {
            this.jvxlSkipDataBlock(this.colorDataCount, false);
        }
    }

    private void jvxlSkipDataBlock(int n, boolean bl) throws Exception {
        for (int i = 0; i < n; i += bl ? this.countData(this.line) : JvxlCoder.jvxlDecompressString(this.line).length()) {
            this.rd();
        }
    }

    private int countData(String string) {
        int n = 0;
        int n2 = this.parseIntStr(string);
        while (n2 != Integer.MIN_VALUE) {
            n += n2;
            n2 = this.parseIntNext(string);
        }
        return n;
    }
}

