/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.java.BS;
import org.jmol.util.Logger;

public class MoldenReader
extends MopacSlaterReader {
    private boolean loadGeometries;
    private boolean loadVibrations;
    private boolean vibOnly;
    private boolean optOnly;
    private boolean doSort = true;
    private String orbitalType = "";
    private int modelAtomCount;
    private BS bsAtomOK = new BS();
    private BS bsBadIndex = new BS();
    private int[] nSPDF;
    private boolean haveEnergy = true;

    @Override
    protected void initializeReader() {
        this.vibOnly = this.checkFilterKey("VIBONLY");
        this.optOnly = this.checkFilterKey("OPTONLY");
        this.doSort = !this.checkFilterKey("NOSORT");
        this.loadGeometries = !this.vibOnly && this.desiredVibrationNumber < 0 && !this.checkFilterKey("NOOPT");
        boolean bl = this.loadVibrations = !this.optOnly && this.desiredModelNumber < 0 && !this.checkFilterKey("NOVIB");
        this.filter = this.checkFilterKey("ALPHA") ? "alpha" : (this.checkFilterKey("BETA") ? "beta" : this.getFilter("SYM="));
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (!this.line.contains("[")) {
            return true;
        }
        this.line = this.line.toUpperCase().trim();
        if (!this.line.startsWith("[")) {
            return true;
        }
        Logger.info(this.line);
        if (this.line.indexOf("[ATOMS]") == 0) {
            this.readAtoms();
            this.modelAtomCount = this.asc.atomSetAtomCounts[0];
            if (this.asc.atomSetCount == 1 && this.moData != null) {
                this.finalizeMOData(this.moData);
            }
            return false;
        }
        if (this.line.indexOf("[GTO]") == 0) {
            return this.readGaussianBasis();
        }
        if (this.line.indexOf("[STO]") == 0) {
            return this.readSlaterBasis();
        }
        if (this.line.indexOf("[MO]") == 0) {
            return !this.doReadMolecularOrbitals || this.readMolecularOrbitals();
        }
        if (this.line.indexOf("[FREQ]") == 0) {
            return !this.loadVibrations || this.readFreqsAndModes();
        }
        if (this.line.indexOf("[GEOCONV]") == 0) {
            return !this.loadGeometries || this.readGeometryOptimization();
        }
        if (this.checkOrbitalType(this.line)) {
            return true;
        }
        return !this.checkSymmetry();
    }

    private boolean checkSymmetry() throws Exception {
        if (this.line.startsWith("[SPACEGROUP]")) {
            this.setSpaceGroupName(this.rd());
            this.rd();
            return true;
        }
        if (this.line.startsWith("[OPERATORS]")) {
            while (this.rd() != null && this.line.indexOf("[") < 0) {
                if (this.line.length() <= 0) continue;
                Logger.info("adding operator " + this.line);
                this.setSymmetryOperator(this.line);
            }
            return true;
        }
        if (this.line.startsWith("[CELL]")) {
            this.rd();
            Logger.info("setting cell dimensions " + this.line);
            this.next[0] = 0;
            for (int i = 0; i < 6; ++i) {
                this.setUnitCellItem(i, this.parseFloat());
            }
            this.rd();
            return true;
        }
        if (this.line.startsWith("[CELLAXES]")) {
            float[] fArray = new float[9];
            this.fillFloatArray(null, 0, fArray);
            this.addPrimitiveLatticeVector(0, fArray, 0);
            this.addPrimitiveLatticeVector(1, fArray, 3);
            this.addPrimitiveLatticeVector(2, fArray, 6);
            return true;
        }
        return false;
    }

    @Override
    public void finalizeSubclassReader() throws Exception {
        if (!this.bsBadIndex.isEmpty()) {
            try {
                short s = 0;
                Atom[] atomArray = this.asc.atoms;
                int n = this.asc.ac;
                this.bsAtomOK.set(n);
                int n2 = this.shells.size();
                block2: for (int i = 0; i < n2; ++i) {
                    int n3 = ((int[])this.shells.get(i))[0];
                    if (n3 != Integer.MAX_VALUE) {
                        s = atomArray[n3].elementNumber;
                        continue;
                    }
                    int n4 = this.bsAtomOK.nextClearBit(0);
                    while (n4 >= 0) {
                        if (atomArray[n4].elementNumber == s) {
                            ((int[])this.shells.get((int)i))[0] = n4;
                            Logger.info("MoldenReader assigning shells starting with " + i + " for ** to atom " + (n4 + 1) + " z " + s);
                            while (++i < n2 && !this.bsBadIndex.get(i) && ((int[])this.shells.get(i))[0] == Integer.MAX_VALUE) {
                                ((int[])this.shells.get((int)i))[0] = n4;
                            }
                            --i;
                            this.bsAtomOK.set(n4);
                            continue block2;
                        }
                        n4 = this.bsAtomOK.nextClearBit(n4 + 1);
                    }
                }
            }
            catch (Exception exception) {
                Logger.error("Molden reader could not assign shells -- abandoning MOs");
                this.asc.setCurrentModelInfo("moData", null);
            }
        }
        this.finalizeReaderASCR();
    }

    private void readAtoms() throws Exception {
        float f;
        boolean bl;
        String string = PT.getTokens(this.line.replace(']', ' '))[1];
        boolean bl2 = string.indexOf("FRACTIONAL") >= 0;
        boolean bl3 = bl = !bl2 && string.indexOf("ANGS") < 0;
        if (bl && string.indexOf("AU") < 0) {
            Logger.error("Molden atom line does not indicate units ANGS, AU, or FRACTIONAL -- AU assumed: " + this.line);
        }
        this.setFractionalCoordinates(bl2);
        float f2 = f = bl ? 0.5291772f : 1.0f;
        while (this.rd() != null && this.line.indexOf(91) < 0) {
            String[] stringArray = this.getTokens();
            if (stringArray.length < 6) continue;
            Atom atom = this.setAtomCoordScaled(null, stringArray, 3, f);
            atom.atomName = stringArray[0];
            atom.elementNumber = (short)this.parseIntStr(stringArray[2]);
        }
    }

    boolean readSlaterBasis() throws Exception {
        while (this.rd() != null && this.line.indexOf("[") < 0) {
            String[] stringArray = this.getTokens();
            if (stringArray.length < 7) continue;
            this.addSlater(this.parseIntStr(stringArray[0]) - 1, this.parseIntStr(stringArray[1]), this.parseIntStr(stringArray[2]), this.parseIntStr(stringArray[3]), this.parseIntStr(stringArray[4]), this.parseFloatStr(stringArray[5]), this.parseFloatStr(stringArray[6]));
        }
        this.setSlaters(false, false);
        return false;
    }

    private boolean readGaussianBasis() throws Exception {
        Object object;
        this.shells = new Lst();
        Lst<float[]> lst = new Lst<float[]>();
        int n = 0;
        int n2 = 0;
        this.nCoef = 0;
        this.nSPDF = new int[12];
        this.discardLinesUntilNonBlank();
        while (this.line != null && (this.line = this.line.trim()).length() != 0 && this.line.charAt(0) != '[') {
            object = this.getTokens();
            n = this.parseIntStr((String)object[0]) - 1;
            if (n == Integer.MAX_VALUE) {
                this.bsBadIndex.set(this.shells.size());
            } else {
                this.bsAtomOK.set(n);
            }
            while (this.rd() != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) != '[') {
                object = this.getTokens();
                String string = object[0].toUpperCase();
                int n3 = BasisFunctionReader.getQuantumShellTagID(string);
                int n4 = this.parseIntStr((String)object[1]);
                int[] nArray = new int[4];
                int n5 = n3;
                this.nSPDF[n5] = this.nSPDF[n5] + 1;
                nArray[0] = n;
                nArray[1] = n3;
                nArray[2] = n2;
                nArray[3] = n4;
                int n6 = this.getDfCoefMaps()[n3].length;
                this.nCoef += n6;
                int n7 = n4;
                while (--n7 >= 0) {
                    String[] stringArray = PT.getTokens(this.rd());
                    int n8 = stringArray.length;
                    float[] fArray = new float[n8];
                    for (int i = 0; i < n8; ++i) {
                        fArray[i] = this.parseFloatStr(stringArray[i]);
                    }
                    lst.addLast(fArray);
                    ++n2;
                }
                this.shells.addLast(nArray);
            }
            if (this.line.length() > 0 && this.line.charAt(0) == '[') break;
            this.rd();
        }
        object = AU.newFloat2(n2);
        for (int i = 0; i < n2; ++i) {
            object[i] = (float[])lst.get(i);
        }
        this.moData.put("shells", this.shells);
        this.moData.put("gaussians", object);
        Logger.info(this.shells.size() + " slater shells read");
        Logger.info(((float[][])object).length + " gaussian primitives read");
        Logger.info(this.nCoef + " MO coefficients expected for orbital type " + this.orbitalType);
        this.asc.setCurrentModelInfo("moData", this.moData);
        return false;
    }

    private boolean readMolecularOrbitals() throws Exception {
        while (this.checkOrbitalType(this.rd())) {
        }
        this.fixOrbitalType();
        String[] stringArray = this.getMoTokens(this.line);
        while (stringArray != null && stringArray.length > 0 && stringArray[0].indexOf(91) < 0) {
            String string;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Lst<String> lst = new Lst<String>();
            float f = Float.NaN;
            float f2 = Float.NaN;
            String string2 = null;
            while (this.parseIntStr(string = stringArray[0]) == Integer.MIN_VALUE) {
                if (string.startsWith("Ene")) {
                    f = this.parseFloatStr(stringArray[1]);
                } else if (string.startsWith("Occup")) {
                    f2 = this.parseFloatStr(stringArray[1]);
                } else if (string.startsWith("Sym")) {
                    string2 = stringArray[1];
                } else if (string.startsWith("Spin")) {
                    this.alphaBeta = stringArray[1].toLowerCase();
                }
                stringArray = this.getMoTokens(null);
            }
            while (stringArray != null && stringArray.length > 0 && this.parseIntStr(stringArray[0]) != Integer.MIN_VALUE) {
                if (stringArray.length != 2) {
                    throw new Exception("invalid MO coefficient specification");
                }
                lst.addLast(stringArray[1]);
                stringArray = this.getMoTokens(null);
            }
            float[] fArray = new float[lst.size()];
            if (this.orbitalType.equals("") && fArray.length < this.nCoef) {
                Logger.info("too few orbital coefficients for 6D");
                this.checkOrbitalType("[5D]");
            }
            int n = lst.size();
            while (--n >= 0) {
                fArray[n] = this.parseFloatStr((String)lst.get(n));
            }
            String string3 = this.line;
            this.line = "" + string2;
            if (this.filterMO()) {
                hashtable.put("coefficients", fArray);
                if (Float.isNaN(f)) {
                    this.haveEnergy = false;
                } else {
                    hashtable.put("energy", Float.valueOf(f));
                }
                if (!Float.isNaN(f2)) {
                    hashtable.put("occupancy", Float.valueOf(f2));
                }
                if (string2 != null) {
                    hashtable.put("symmetry", string2);
                }
                if (this.alphaBeta.length() > 0) {
                    hashtable.put("type", this.alphaBeta);
                }
                this.setMO(hashtable);
                if (Logger.debugging) {
                    Logger.debug(fArray.length + " coefficients in MO " + this.orbitals.size());
                }
            }
            this.line = string3;
        }
        if (Logger.debugging) {
            Logger.debug("read " + this.orbitals.size() + " MOs");
        }
        this.setMOs("eV");
        if (this.haveEnergy && this.doSort) {
            this.sortMOs();
        }
        return false;
    }

    private void sortMOs() {
        Object[] objectArray = this.orbitals.toArray(new Object[this.orbitals.size()]);
        Arrays.sort(objectArray, new BasisFunctionReader.MOEnergySorter());
        this.orbitals.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            this.orbitals.addLast((Map)objectArray[i]);
        }
    }

    private String[] getMoTokens(String string) throws Exception {
        return string == null && (string = this.rd()) == null ? null : PT.getTokens(string.replace('=', ' '));
    }

    private boolean checkOrbitalType(String string) {
        if (string.length() > 3 && "5D 6D 7F 10 9G 15 11 21".indexOf(string.substring(1, 3)) >= 0) {
            if (this.orbitalType.indexOf(string) >= 0) {
                return true;
            }
            this.orbitalType = this.orbitalType + string;
            Logger.info("Orbital type set to " + this.orbitalType);
            this.fixOrbitalType();
            return true;
        }
        return false;
    }

    private void fixOrbitalType() {
        if (this.orbitalType.contains("5D")) {
            this.fixSlaterTypes(4, 3);
            this.fixSlaterTypes(6, 5);
            this.fixSlaterTypes(8, 7);
            this.fixSlaterTypes(10, 9);
        }
        if (this.orbitalType.contains("10F")) {
            this.fixSlaterTypes(5, 6);
            this.fixSlaterTypes(7, 8);
            this.fixSlaterTypes(9, 10);
        }
        if (this.orbitalType.contains("15G")) {
            this.fixSlaterTypes(7, 8);
            this.fixSlaterTypes(9, 10);
        }
    }

    private boolean readFreqsAndModes() throws Exception {
        Lst<String> lst = new Lst<String>();
        while (this.rd() != null && this.line.indexOf(91) < 0) {
            String string = this.getTokens()[0];
            lst.addLast(string);
        }
        int n = lst.size();
        this.skipTo("[FR-COORD]");
        if (!this.vibOnly) {
            this.readAtomSet("frequency base geometry", true, true);
        }
        this.skipTo("[FR-NORM-COORD]");
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            this.skipTo("vibration");
            this.doGetVibration(++this.vibrationNumber);
            if (bl) {
                this.asc.cloneLastAtomSet();
            }
            bl = true;
            this.asc.setAtomSetFrequency(null, null, "" + PT.dVal((String)lst.get(i)), null);
            int n2 = this.asc.getLastAtomSetAtomIndex();
            for (int j = 0; j < this.modelAtomCount; ++j) {
                String[] stringArray = PT.getTokens(this.rd());
                this.asc.addVibrationVector(j + n2, this.parseFloatStr(stringArray[0]) * 0.5291772f, this.parseFloatStr(stringArray[1]) * 0.5291772f, this.parseFloatStr(stringArray[2]) * 0.5291772f);
            }
        }
        return true;
    }

    private boolean readGeometryOptimization() throws Exception {
        int n;
        Lst<String> lst = new Lst<String>();
        this.rd();
        while (this.rd() != null && this.line.indexOf("force") < 0) {
            lst.addLast("" + PT.dVal(this.line.trim()));
        }
        this.skipTo("[GEOMETRIES] XYZ");
        int n2 = lst.size();
        this.modelNumber = n = this.optOnly || this.desiredModelNumber >= 0 ? 0 : 1;
        boolean bl = false;
        if (this.desiredModelNumber == 0 || this.desiredModelNumber == n2) {
            this.desiredModelNumber = n2;
        } else if (this.asc.atomSetCount > 0) {
            this.finalizeMOData(this.moData);
        }
        for (int i = 0; i < n2; ++i) {
            this.readLines(2);
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtomSet("Step " + (this.modelNumber - n) + "/" + n2 + ": " + (String)lst.get(i), false, !this.optOnly || bl);
                bl = true;
                continue;
            }
            this.readLines(this.modelAtomCount);
        }
        return true;
    }

    private void skipTo(String string) throws Exception {
        string = string.toUpperCase();
        if (this.line == null || !this.line.toUpperCase().contains(string)) {
            while (this.rd() != null && this.line.toUpperCase().indexOf(string) < 0) {
            }
        }
    }

    private void readAtomSet(String string, boolean bl, boolean bl2) throws Exception {
        if (bl2 && this.desiredModelNumber < 0) {
            this.asc.cloneFirstAtomSet(0);
        }
        float f = bl ? 0.5291772f : 1.0f;
        this.asc.setAtomSetName(string);
        if (this.asc.ac == 0) {
            while (this.rd() != null && this.line.indexOf(91) < 0) {
                String[] stringArray = this.getTokens();
                if (stringArray.length != 4) continue;
                this.setAtomCoordScaled(null, (String[])stringArray, (int)1, (float)f).atomName = stringArray[0];
            }
            this.modelAtomCount = this.asc.getLastAtomSetAtomCount();
            return;
        }
        Atom[] atomArray = this.asc.atoms;
        int n = this.asc.getLastAtomSetAtomIndex();
        for (int i = 0; i < this.modelAtomCount; ++i) {
            this.setAtomCoordScaled(atomArray[i + n], PT.getTokens(this.rd()), 1, f);
        }
    }
}

