/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import org.jmol.atomdata.RadiusData;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeCollection;

public class Backbone
extends BioShapeCollection {
    BS bsSelected;

    public void initShape() {
        super.initShape();
        this.madOn = 1;
        this.madHelixSheet = (short)1500;
        this.madTurnRandom = (short)500;
        this.madDnaRna = (short)2000;
        this.isActive = true;
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        if ("bitset" == string) {
            this.bsSelected = (BS)object;
            return;
        }
        this.setPropBSC(string, object, bS);
    }

    @Override
    public void setShapeSizeRD(int n, RadiusData radiusData, BS bS) {
        boolean bl;
        short s = (short)n;
        this.initialize();
        boolean bl2 = bl = this.bsSelected != null;
        if (bl) {
            bS = this.bsSelected;
        }
        int n2 = this.bioShapes.length;
        while (--n2 >= 0) {
            boolean bl3;
            BioShape bioShape = this.bioShapes[n2];
            if (bioShape.monomerCount == 0) continue;
            boolean bl4 = this.vwr.getBoolean(0x24000024);
            int[] nArray = bioShape.bioPolymer.getLeadAtomIndices();
            boolean bl5 = bl3 = s != 0;
            if (bioShape.bsSizeSet == null) {
                bioShape.bsSizeSet = new BS();
            }
            bioShape.isActive = true;
            int n3 = bioShape.monomerCount - 1;
            while (--n3 >= 0) {
                boolean bl6;
                int n4 = nArray[n3];
                int n5 = nArray[n3 + 1];
                boolean bl7 = bS.get(n4);
                boolean bl8 = bS.get(n5);
                if (!(bl7 && bl8 || bl && bl7) && (!bl4 || !bl7 && !bl8)) continue;
                bioShape.monomers[n3].setShapeVisibility(this.vf, bl3);
                Atom atom = this.ms.at[n4];
                if (radiusData != null) {
                    if (Float.isNaN(radiusData.values[n4]) || Float.isNaN(radiusData.values[n5])) continue;
                    s = (short)((radiusData.values[n4] + radiusData.values[n5]) * 1000.0f);
                    bl3 = s != 0;
                }
                Atom atom2 = this.ms.at[n5];
                boolean bl9 = bl6 = bioShape.mads[n3] != 0;
                if (bl6 != bl3) {
                    atom.addDisplayedBackbone(this.vf, bl3);
                    atom2.addDisplayedBackbone(this.vf, bl3);
                }
                bioShape.mads[n3] = s;
                bioShape.bsSizeSet.setBitTo(n3, bl3);
                bioShape.bsSizeDefault.setBitTo(n3, s == -1);
            }
        }
        if (bl) {
            this.bsSelected = null;
        }
    }

    @Override
    public void setAtomClickability() {
        if (this.bioShapes == null) {
            return;
        }
        int n = this.bioShapes.length;
        while (--n >= 0) {
            BioShape bioShape = this.bioShapes[n];
            int[] nArray = bioShape.bioPolymer.getLeadAtomIndices();
            int n2 = bioShape.monomerCount;
            while (--n2 >= 0) {
                Atom atom = this.ms.at[nArray[n2]];
                if (atom.nBackbonesDisplayed <= 0 || this.ms.isAtomHidden(n2)) continue;
                atom.setClickable(this.vf);
            }
        }
    }
}

