/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.CU;
import javajs.util.P4;
import javajs.util.T3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class Pmesh4Reader
extends PolygonFileReader {
    private int nPolygons;
    private String pmeshError;
    private String type;
    private int color;
    private float transparency;
    private int nX;
    private int nY;
    private String[] tokens = new String[0];
    private int iToken = 0;

    Pmesh4Reader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PFR(surfaceGenerator, bufferedReader);
        String string = (String)((Object[])surfaceGenerator.getReaderData())[0];
        if (string == null) {
            return;
        }
        this.params.fullyLit = true;
        this.type = "pmesh4";
        this.jvxlFileHeaderBuffer.append(this.type + " file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    @Override
    void getSurfaceData() throws Exception {
        this.rd();
        if (this.readVerticesAndPolygons()) {
            Logger.info((String)(this.type + " file contains " + this.nVertices + " 4D vertices and " + this.nPolygons + " polygons for " + this.nTriangles + " triangles"));
        } else {
            Logger.error((String)(this.params.fileName + ": " + (this.pmeshError == null ? "Error reading pmesh4 data " : this.pmeshError)));
        }
    }

    private boolean readVerticesAndPolygons() {
        try {
            this.readColor();
            this.nY = this.getInt();
            this.nX = this.getInt();
            this.readVertices();
            this.createMesh();
            return true;
        }
        catch (Exception exception) {
            if (this.pmeshError == null) {
                this.pmeshError = this.type + " ERROR: " + exception;
            }
            return false;
        }
    }

    private void readColor() throws Exception {
        this.color = CU.colorTriadToFFRGB((float)this.getFloat(), (float)this.getFloat(), (float)this.getFloat());
        this.transparency = this.getFloat();
    }

    private boolean readVertices() throws Exception {
        this.nVertices = this.nX * this.nY;
        this.iToken = Integer.MAX_VALUE;
        this.pmeshError = this.type + " ERROR: invalid vertex list";
        for (int i = 0; i < this.nVertices; ++i) {
            P4 p4 = P4.new4((float)this.getFloat(), (float)this.getFloat(), (float)this.getFloat(), (float)this.getFloat());
            if (Logger.debugging) {
                Logger.debug((String)(i + ": " + p4));
            }
            this.addVertexCopy((T3)p4, 0.0f, i, false);
            this.iToken = Integer.MAX_VALUE;
        }
        this.pmeshError = null;
        return true;
    }

    private void createMesh() {
        for (int i = 0; i < this.nX - 1; ++i) {
            for (int j = 0; j < this.nY - 1; ++j) {
                this.nTriangles += 2;
                this.addTriangleCheck(i * this.nY + j, (i + 1) * this.nY + j, (i + 1) * this.nY + j + 1, 3, 0, false, this.color);
                this.addTriangleCheck((i + 1) * this.nY + j + 1, i * this.nY + j + 1, i * this.nY + j, 3, 0, false, this.color);
            }
        }
    }

    private String nextToken() throws Exception {
        while (this.iToken >= this.tokens.length) {
            this.iToken = 0;
            this.rd();
            this.tokens = this.getTokens();
        }
        return this.tokens[this.iToken++];
    }

    private int getInt() throws Exception {
        return this.parseIntStr(this.nextToken());
    }

    private float getFloat() throws Exception {
        return this.parseFloatStr(this.nextToken());
    }
}

