/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.forcefield.Calculation;

class MMFFSBCalc
extends Calculation {
    MMFFSBCalc() {
    }

    void setData(Lst<Object[]> lst, MinAngle minAngle) {
        if (this.calcs.isLinear(minAngle.data[1])) {
            return;
        }
        double[] dArray = (double[])this.calcs.getParameter(minAngle.sbKey);
        double[] dArray2 = (double[])this.calcs.getParameterObj(minAngle);
        double[] dArray3 = (double[])this.calcs.getParameter(this.calcs.minBonds[minAngle.data[3]]);
        double[] dArray4 = (double[])this.calcs.getParameter(this.calcs.minBonds[minAngle.data[4]]);
        if (dArray == null || dArray2 == null || dArray3 == null || dArray4 == null) {
            return;
        }
        double d = dArray2[1];
        double d2 = dArray3[1];
        double d3 = dArray4[1];
        lst.addLast((Object)new Object[]{minAngle.data, new double[]{dArray[0], d, d2}, minAngle.sbKey});
        lst.addLast((Object)new Object[]{new int[]{minAngle.data[2], minAngle.data[1], minAngle.data[0]}, new double[]{dArray[1], d, d3}, minAngle.sbKey});
    }

    @Override
    double compute(Object[] objectArray) {
        this.key = (Integer)objectArray[2];
        this.getPointers(objectArray);
        double d = 2.5121 * this.dData[0];
        double d2 = this.dData[1];
        double d3 = this.dData[2];
        this.calcs.setPairVariables(this);
        this.calcs.setAngleVariables(this);
        double d4 = this.rab - d3;
        this.delta = this.theta * 57.29577951308232 - d2;
        this.energy = d * d4 * this.delta;
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(2, this));
        }
        if (this.calcs.gradients) {
            this.dE = d * d4;
            this.calcs.addForces(this, 3);
            this.calcs.setPairVariables(this);
            this.dE = d * this.delta;
            this.calcs.addForces(this, 2);
        }
        return this.energy;
    }
}

