/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.scriptext;

import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolNMRInterface;
import org.jmol.api.JmolPatternMatcher;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.VDW;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.ModelSet;
import org.jmol.script.JmolMathExtension;
import org.jmol.script.SV;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.ScriptParam;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class MathExt
implements JmolMathExtension {
    private Viewer vwr;
    private ScriptEval e;
    private JmolPatternMatcher pm;

    public JmolMathExtension init(Object object) {
        this.e = (ScriptEval)object;
        this.vwr = this.e.vwr;
        return this;
    }

    public boolean evaluate(ScriptMathProcessor scriptMathProcessor, T t, SV[] sVArray, int n) throws ScriptException {
        switch (n) {
            case 135266318: 
            case 135266819: 
            case 135266820: 
            case 135266821: 
            case 135266822: 
            case 135266826: {
                return this.evaluateMath(scriptMathProcessor, sVArray, n);
            }
            case 1276117504: 
            case 1276117507: 
            case 1276117508: 
            case 1276117511: 
            case 1276118017: 
            case 1276383249: 
            case 1276384259: {
                return this.evaluateList(scriptMathProcessor, t.intValue, sVArray);
            }
            case 135266306: 
            case 0x10100040: {
                return this.evaluateArray(scriptMathProcessor, sVArray, n == 0x10100040);
            }
            case 135266307: 
            case 135270418: {
                return this.evaluateQuaternion(scriptMathProcessor, sVArray, n);
            }
            case 1276118529: {
                return this.evaluateBin(scriptMathProcessor, sVArray);
            }
            case 135270423: {
                return this.evaluateCache(scriptMathProcessor, sVArray);
            }
            case 1276117514: 
            case 1276117515: {
                return this.evaluateRowCol(scriptMathProcessor, sVArray, n);
            }
            case 1766856708: {
                return this.evaluateColor(scriptMathProcessor, sVArray);
            }
            case 135270405: {
                return this.evaluateCompare(scriptMathProcessor, sVArray);
            }
            case 135266310: {
                return this.evaluateConnected(scriptMathProcessor, sVArray);
            }
            case 135402505: {
                return this.evaluateContact(scriptMathProcessor, sVArray);
            }
            case 135267329: {
                return this.evaluateCross(scriptMathProcessor, sVArray);
            }
            case 0x8101008: {
                return this.evaluateData(scriptMathProcessor, sVArray);
            }
            case 1276117505: 
            case 1276118018: {
                if (t.tok == 0x101000D1) {
                    return this.evaluateDot(scriptMathProcessor, sVArray, n, t.intValue);
                }
            }
            case 0x8100001: 
            case 1746538509: {
                return this.evaluateMeasure(scriptMathProcessor, sVArray, t.tok);
            }
            case 135271427: 
            case 1229984263: {
                return this.evaluateLoad(scriptMathProcessor, sVArray, n == 1229984263);
            }
            case 1276118531: {
                return this.evaluateFind(scriptMathProcessor, sVArray);
            }
            case 1288701959: 
            case 1826248716: {
                return this.evaluateFormat(scriptMathProcessor, t.intValue, sVArray, n == 1826248716);
            }
            case 135368713: {
                return this.evaluateUserFunction(scriptMathProcessor, (String)t.value, sVArray, t.intValue, t.tok == 0x101000D1);
            }
            case 1276121098: {
                return this.evaluateGetProperty(scriptMathProcessor, sVArray, t.tok == 0x101000D1);
            }
            case 137363467: {
                return this.evaluateHelix(scriptMathProcessor, sVArray);
            }
            case 135266319: 
            case 135267841: 
            case 135267842: {
                return this.evaluatePlane(scriptMathProcessor, sVArray, n);
            }
            case 135266829: 
            case 135270926: 
            case 135271429: 
            case 135287308: {
                return this.evaluateScript(scriptMathProcessor, sVArray, n);
            }
            case 1276117512: 
            case 1276118020: 
            case 1276118021: {
                return this.evaluateString(scriptMathProcessor, t.intValue, sVArray);
            }
            case 0x8100010: {
                return this.evaluatePoint(scriptMathProcessor, sVArray);
            }
            case 135304707: {
                return this.evaluatePrompt(scriptMathProcessor, sVArray);
            }
            case 135267332: {
                return this.evaluateRandom(scriptMathProcessor, sVArray);
            }
            case 1276116993: {
                return this.evaluateIn(scriptMathProcessor, sVArray);
            }
            case 1276121113: {
                return this.evaluateModulation(scriptMathProcessor, sVArray);
            }
            case 1276120578: {
                return this.evaluateReplace(scriptMathProcessor, sVArray);
            }
            case 135267335: 
            case 135267336: 
            case 1238369286: {
                return this.evaluateSubstructure(scriptMathProcessor, sVArray, n);
            }
            case 1276117011: 
            case 1276117012: {
                return this.evaluateSort(scriptMathProcessor, sVArray, n);
            }
            case 1297090050: {
                return this.evaluateSymop(scriptMathProcessor, sVArray, t.tok == 0x101000D1);
            }
            case 1276117016: {
                return this.evaluateTensor(scriptMathProcessor, sVArray);
            }
            case 135266325: {
                return this.evaluateWithin(scriptMathProcessor, sVArray);
            }
            case 135270422: {
                return this.evaluateWrite(scriptMathProcessor, sVArray);
            }
        }
        return false;
    }

    private boolean evaluateArray(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) {
        int n;
        int n2 = sVArray.length;
        if (bl && (n2 == 4 || n2 == 3)) {
            boolean bl2 = true;
            for (n = 0; n < n2 && bl2; ++n) {
                bl2 = sVArray[n].tok == 7 && sVArray[n].getList().size() == n2;
            }
            if (bl2) {
                float[] fArray = new float[n2 * n2];
                int n3 = 0;
                block1: for (int i = 0; i < n2 && bl2; ++i) {
                    Lst lst = sVArray[i].getList();
                    for (int j = 0; j < n2; ++j) {
                        float f = SV.fValue((T)((T)lst.get(j)));
                        if (Float.isNaN(f)) {
                            bl2 = false;
                            continue block1;
                        }
                        fArray[n3++] = f;
                    }
                }
                if (bl2) {
                    return n2 == 3 ? scriptMathProcessor.addXM3(M3.newA9((float[])fArray)) : scriptMathProcessor.addXM4(M4.newA16((float[])fArray));
                }
            }
        }
        SV[] sVArray2 = new SV[sVArray.length];
        n = sVArray2.length;
        while (--n >= 0) {
            sVArray2[n] = SV.newT((T)sVArray[n]);
        }
        return scriptMathProcessor.addXAV(sVArray2);
    }

    private boolean evaluateBin(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        float[] fArray;
        boolean bl;
        if (sVArray.length != 3) {
            return false;
        }
        SV sV = scriptMathProcessor.getX();
        boolean bl2 = bl = sV.tok == 13;
        if (!bl && sV.tok != 7) {
            return scriptMathProcessor.addX(sV);
        }
        float f = SV.fValue((T)sVArray[0]);
        float f2 = SV.fValue((T)sVArray[1]);
        float f3 = SV.fValue((T)sVArray[2]);
        if (bl) {
            fArray = (float[])sV.value;
        } else {
            Lst lst = sV.getList();
            fArray = new float[lst.size()];
            int n = lst.size();
            while (--n >= 0) {
                fArray[n] = SV.fValue((T)((T)lst.get(n)));
            }
        }
        int n = Math.max((int)Math.floor((f2 - f) / f3 + 0.01f), 1);
        int[] nArray = new int[n];
        for (float f4 : fArray) {
            int n2 = (int)Math.floor((f4 - f) / f3);
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= n) {
                n2 = n - 1;
            }
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
        }
        return scriptMathProcessor.addXAI(nArray);
    }

    private boolean evaluateCache(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length > 0) {
            return false;
        }
        return scriptMathProcessor.addXMap(this.vwr.fm.cacheList());
    }

    private boolean evaluateColor(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        Object object;
        boolean bl;
        ColorEncoder colorEncoder;
        String string = sVArray.length > 0 ? SV.sValue((T)sVArray[0]) : "";
        boolean bl2 = string.startsWith("$");
        if (sVArray.length == 2 && string.equalsIgnoreCase("TOHSL")) {
            return scriptMathProcessor.addXPt(CU.rgbToHSL((P3)P3.newP((T3)(sVArray[1].tok == 8 ? SV.ptValue((SV)sVArray[1]) : CU.colorPtFromString((String)sVArray[1].asString()))), (boolean)true));
        }
        if (sVArray.length == 2 && string.equalsIgnoreCase("TORGB")) {
            P3 p3 = P3.newP((T3)(sVArray[1].tok == 8 ? SV.ptValue((SV)sVArray[1]) : CU.colorPtFromString((String)sVArray[1].asString())));
            return scriptMathProcessor.addXPt(sVArray[1].tok == 8 ? CU.hslToRGB((P3)p3) : p3);
        }
        if (sVArray.length == 4 && (sVArray[3].tok == 0x10000D || sVArray[3].tok == 0x10000C)) {
            boolean bl3;
            P3 p3 = P3.newP((T3)(sVArray[0].tok == 8 ? SV.ptValue((SV)sVArray[0]) : CU.colorPtFromString((String)sVArray[0].asString())));
            P3 p32 = P3.newP((T3)(sVArray[1].tok == 8 ? SV.ptValue((SV)sVArray[1]) : CU.colorPtFromString((String)sVArray[1].asString())));
            boolean bl4 = bl3 = sVArray[3].tok == 0x10000D;
            if (bl3) {
                p3 = CU.rgbToHSL((P3)p3, (boolean)false);
                p32 = CU.rgbToHSL((P3)p32, (boolean)false);
            }
            SB sB = new SB();
            V3 v3 = V3.newVsub((T3)p32, (T3)p3);
            int n = sVArray[2].asInt();
            if (n < 2) {
                n = 20;
            }
            v3.scale(1.0f / (float)(n - 1));
            for (int i = 0; i < n; ++i) {
                sB.append(Escape.escapeColor((int)CU.colorPtToFFRGB((T3)(bl3 ? CU.hslToRGB((P3)p3) : p3))));
                p3.add((T3)v3);
            }
            return scriptMathProcessor.addXStr(sB.toString());
        }
        ColorEncoder colorEncoder2 = colorEncoder = bl2 ? null : this.vwr.cm.getColorEncoder(string);
        if (!bl2 && colorEncoder == null) {
            return scriptMathProcessor.addXStr("");
        }
        float f = sVArray.length > 1 ? SV.fValue((T)sVArray[1]) : Float.MAX_VALUE;
        Object object2 = sVArray.length > 2 ? SV.fValue((T)sVArray[2]) : Float.MAX_VALUE;
        float f2 = sVArray.length > 3 ? SV.fValue((T)sVArray[3]) : Float.MAX_VALUE;
        boolean bl5 = f2 != Float.MAX_VALUE || f != Float.MAX_VALUE && object2 == Float.MAX_VALUE;
        boolean bl6 = bl = object2 != Float.MAX_VALUE;
        if (!bl && string.length() == 0) {
            f2 = f;
            object = this.vwr.getCurrentColorRange();
            f = (float)object[0];
            object2 = object[1];
        }
        if (bl2) {
            object = string.substring(1);
            Object[] objectArray = new Object[]{object, null};
            if (!this.vwr.shm.getShapePropertyData(24, "colorEncoder", objectArray)) {
                return scriptMathProcessor.addXStr("");
            }
            colorEncoder = (ColorEncoder)objectArray[1];
        } else {
            colorEncoder.setRange(f, object2, f > object2);
        }
        object = colorEncoder.getColorKey();
        if (bl5) {
            return scriptMathProcessor.addXPt(CU.colorPtFromInt((int)colorEncoder.getArgb(object2 == Float.MAX_VALUE ? f : f2), null));
        }
        return scriptMathProcessor.addX(SV.getVariableMap((Map)object));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean evaluateCompare(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        if (sVArray.length < 2 || sVArray.length > 5) {
            return false;
        }
        String string = SV.sValue((T)sVArray[sVArray.length - 1]);
        boolean bl = string.equalsIgnoreCase("stddev");
        boolean bl2 = string.equalsIgnoreCase("ISOMER");
        boolean bl3 = string.equalsIgnoreCase("BONDS");
        boolean bl4 = !bl2 && sVArray.length > (bl ? 3 : 2);
        BS bS = sVArray[0].tok == 10 ? (BS)sVArray[0].value : null;
        BS bS2 = sVArray[1].tok == 10 ? (BS)sVArray[1].value : null;
        String string2 = bS == null ? SV.sValue((T)sVArray[0]) : "";
        String string3 = bS2 == null ? SV.sValue((T)sVArray[1]) : "";
        M4 m4 = new M4();
        float f = Float.NaN;
        if (bl4 && (bS == null || bS2 == null)) {
            return false;
        }
        if (bl3) {
            if (sVArray.length != 4) {
                return false;
            }
            string2 = SV.sValue((T)sVArray[2]);
            bl4 = string2.equalsIgnoreCase("SMILES");
            try {
                if (bl4) {
                    string2 = this.vwr.getSmiles(bS);
                }
            }
            catch (Exception exception) {
                this.e.evalError(exception.getMessage(), null);
            }
            float[] fArray = this.e.getSmilesExt().getFlexFitList(bS, bS2, string2, !bl4);
            return fArray == null ? scriptMathProcessor.addXStr("") : scriptMathProcessor.addXAF(fArray);
        }
        try {
            if (bl2) {
                boolean bl5;
                String string4;
                if (sVArray.length != 3) {
                    return false;
                }
                if (bS == null && bS2 == null) {
                    return scriptMathProcessor.addXStr(this.vwr.getSmilesMatcher().getRelationship(string2, string3).toUpperCase());
                }
                String string5 = bS == null ? this.vwr.getSmilesMatcher().getMolecularFormula(string2, false) : JmolMolecule.getMolecularFormula((Node[])this.vwr.ms.at, (BS)bS, (boolean)false, null, (boolean)false);
                String string6 = string4 = bS2 == null ? this.vwr.getSmilesMatcher().getMolecularFormula(string3, false) : JmolMolecule.getMolecularFormula((Node[])this.vwr.ms.at, (BS)bS2, (boolean)false, null, (boolean)false);
                if (!string5.equals(string4)) {
                    return scriptMathProcessor.addXStr("NONE");
                }
                if (bS != null) {
                    string2 = (String)this.e.getSmilesExt().getSmilesMatches("", null, bS, null, false, true);
                }
                if (bS2 == null) {
                    bl5 = this.vwr.getSmilesMatcher().areEqual(string3, string2) > 0;
                } else {
                    boolean bl6 = bl5 = ((BS)this.e.getSmilesExt().getSmilesMatches(string2, null, bS2, null, false, true)).nextSetBit(0) >= 0;
                }
                if (!bl5) {
                    String string7 = string2 + string3;
                    if (string7.indexOf("/") < 0 && string7.indexOf("\\") < 0 && string7.indexOf("@") < 0) return scriptMathProcessor.addXStr("CONSTITUTIONAL ISOMERS");
                    if (string2.indexOf("@") >= 0 && (bS2 != null || string3.indexOf("@") >= 0)) {
                        string2 = this.vwr.getSmilesMatcher().reverseChirality(string2);
                        if (bS2 == null) {
                            bl5 = this.vwr.getSmilesMatcher().areEqual(string2, string3) > 0;
                        } else {
                            boolean bl7 = bl5 = ((BS)this.e.getSmilesExt().getSmilesMatches(string2, null, bS2, null, false, true)).nextSetBit(0) >= 0;
                        }
                        if (bl5) {
                            return scriptMathProcessor.addXStr("ENANTIOMERS");
                        }
                    }
                    if (bS2 == null) {
                        bl5 = this.vwr.getSmilesMatcher().areEqual("/nostereo/" + string3, string2) > 0;
                    } else {
                        Object object = this.e.getSmilesExt().getSmilesMatches("/nostereo/" + string2, null, bS2, null, false, true);
                        boolean bl8 = bl5 = ((BS)object).nextSetBit(0) >= 0;
                    }
                    if (!bl5) return scriptMathProcessor.addXStr("CONSTITUTIONAL ISOMERS");
                    return scriptMathProcessor.addXStr("DIASTERIOMERS");
                }
                if (bS != null && bS2 != null) return scriptMathProcessor.addXStr((f = this.e.getSmilesExt().getSmilesCorrelation(bS, bS2, string2, null, null, null, null, false, false, (int[][])null, null, false, false)) < 0.2f ? "IDENTICAL" : "IDENTICAL or CONFORMATIONAL ISOMERS (RMSD=" + f + ")");
                return scriptMathProcessor.addXStr("IDENTICAL");
            }
            if (bl4) {
                boolean bl9;
                boolean bl10;
                Lst lst = new Lst();
                Lst lst2 = new Lst();
                string = SV.sValue((T)sVArray[2]);
                boolean bl11 = string.equalsIgnoreCase("MAP");
                bl4 = string.equalsIgnoreCase("SMILES");
                boolean bl12 = bl10 = bl11 || string.equalsIgnoreCase("SMARTS");
                if (bl4 || bl10) {
                    string = sVArray.length > 3 ? SV.sValue((T)sVArray[3]) : null;
                }
                boolean bl13 = "H".equals(string) || "allH".equals(string) || "bestH".equals(string);
                boolean bl14 = "all".equals(string) || "allH".equals(string);
                boolean bl15 = bl9 = "best".equals(string) || "bestH".equals(string);
                if (string == null || bl13 || bl14 || bl9) {
                    if (!bl11 && !bl4) return false;
                    string = "/noaromatic" + (bl14 || bl9 ? "/" : " nostereo/") + this.e.getSmilesExt().getSmilesMatches(bl13 ? "H" : "", null, bS, null, false, true);
                } else {
                    bl14 = true;
                }
                f = this.e.getSmilesExt().getSmilesCorrelation(bS, bS2, string, lst, lst2, m4, null, !bl4, bl11, (int[][])null, null, !bl14 && !bl9, bl9);
                if (!bl11) return bl || Float.isNaN(f) ? scriptMathProcessor.addXFloat(f) : scriptMathProcessor.addXM4(m4);
                int n = lst.size();
                if (n == 0) {
                    return scriptMathProcessor.addXStr("");
                }
                int n2 = lst2.size() / n;
                Lst lst3 = new Lst();
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    int[][] nArray = AU.newInt2((int)n);
                    lst3.addLast((Object)nArray);
                    int n4 = 0;
                    while (n4 < n) {
                        nArray[n4] = new int[]{((Atom)lst.get((int)n4)).i, ((Atom)lst2.get((int)n3)).i};
                        ++n4;
                        ++n3;
                    }
                }
                if (bl14) return scriptMathProcessor.addXList(lst3);
                return lst3.size() > 0 ? scriptMathProcessor.addXAII((int[][])lst3.get(0)) : scriptMathProcessor.addXStr("");
            }
            Lst lst = this.e.getPointVector((T)sVArray[0], 0);
            Lst lst4 = this.e.getPointVector((T)sVArray[1], 0);
            if (lst == null || lst4 == null) return bl || Float.isNaN(f) ? scriptMathProcessor.addXFloat(f) : scriptMathProcessor.addXM4(m4);
            Interface.getInterface((String)"javajs.util.Eigen", (Viewer)this.vwr, (String)"script");
            f = Measure.getTransformMatrix4((Lst)lst, (Lst)lst4, (M4)m4, null);
            return bl || Float.isNaN(f) ? scriptMathProcessor.addXFloat(f) : scriptMathProcessor.addXM4(m4);
        }
        catch (Exception exception) {
            this.e.evalError(exception.getMessage() == null ? exception.toString() : exception.getMessage(), null);
            return false;
        }
    }

    private boolean evaluateConnected(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length > 5) {
            return false;
        }
        float f = -2.1474836E9f;
        float f2 = 2.1474836E9f;
        float f3 = 0.0f;
        float f4 = Float.MAX_VALUE;
        int n = 65535;
        BS bS = null;
        BS bS2 = null;
        boolean bl = false;
        boolean bl2 = false;
        block5: for (int i = 0; i < sVArray.length; ++i) {
            SV sV = sVArray[i];
            switch (sV.tok) {
                case 10: {
                    bl2 = sV.value instanceof BondSet;
                    if (bl2 && bS != null) {
                        return false;
                    }
                    if (bS == null) {
                        bS = SV.bsSelectVar((SV)sV);
                        continue block5;
                    }
                    if (bS2 == null) {
                        bS2 = SV.bsSelectVar((SV)sV);
                        continue block5;
                    }
                    return false;
                }
                case 4: {
                    String string = SV.sValue((T)sV);
                    n = string.equalsIgnoreCase("hbond") ? 30720 : ScriptParam.getBondOrderFromString((String)string);
                    if (n != 131071) continue block5;
                    return false;
                }
                case 3: {
                    bl = true;
                }
                default: {
                    int n2 = sV.asInt();
                    float f5 = sV.asFloat();
                    if (f2 != 2.1474836E9f) {
                        return false;
                    }
                    if (f == -2.1474836E9f) {
                        f = Math.max(n2, 0);
                        f3 = f5;
                        continue block5;
                    }
                    f2 = n2;
                    f4 = f5;
                }
            }
        }
        if (f == -2.1474836E9f) {
            f = 1.0f;
            f2 = 100.0f;
            f3 = 0.1f;
            f4 = 1.0E8f;
        } else if (f2 == 2.1474836E9f) {
            f2 = f;
            f4 = f3;
            f3 = 0.1f;
        }
        if (bS == null) {
            bS = this.vwr.getAllAtoms();
        }
        if (bl && bS2 == null) {
            bS2 = bS;
        }
        if (bS2 != null) {
            BS bS3 = new BS();
            this.vwr.makeConnections(f3, f4, n, 1087373321, bS, bS2, bS3, bl2, false, 0.0f);
            return scriptMathProcessor.addX(SV.newV((int)10, (Object)BondSet.newBS((BS)bS3, (int[])this.vwr.ms.getAtomIndices(this.vwr.ms.getAtoms(1678770178, (Object)bS3)))));
        }
        return scriptMathProcessor.addXBs(this.vwr.ms.getAtomsConnected(f, f2, n, bS));
    }

    private boolean evaluateContact(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length < 1 || sVArray.length > 3) {
            return false;
        }
        int n = 0;
        float f = 100.0f;
        int n2 = sVArray[0].tok;
        switch (n2) {
            case 2: 
            case 3: {
                f = SV.fValue((T)sVArray[n++]);
                break;
            }
            case 10: {
                break;
            }
            default: {
                return false;
            }
        }
        if (n == sVArray.length || !(sVArray[n].value instanceof BS)) {
            return false;
        }
        BS bS = BSUtil.copy((BS)SV.bsSelectVar((SV)sVArray[n++]));
        BS bS2 = n < sVArray.length ? BSUtil.copy((BS)SV.bsSelectVar((SV)sVArray[n])) : null;
        RadiusData radiusData = new RadiusData(null, f > 10.0f ? f / 100.0f : f, f > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, VDW.AUTO);
        bS2 = this.setContactBitSets(bS, bS2, true, Float.NaN, radiusData, false);
        bS2.or(bS);
        return scriptMathProcessor.addXBs(bS2);
    }

    private boolean evaluateCross(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length != 2) {
            return false;
        }
        SV sV = sVArray[0];
        SV sV2 = sVArray[1];
        if (sV.tok != 8 || sV2.tok != 8) {
            return false;
        }
        V3 v3 = V3.newV((T3)((P3)sV.value));
        V3 v32 = V3.newV((T3)((P3)sV2.value));
        v3.cross((T3)v3, (T3)v32);
        return scriptMathProcessor.addXPt(P3.newP((T3)v3));
    }

    private boolean evaluateData(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        String string;
        if (sVArray.length != 1 && sVArray.length != 2 && sVArray.length != 4) {
            return false;
        }
        String string2 = SV.sValue((T)sVArray[0]);
        String string3 = string = sVArray.length == 2 ? SV.sValue((T)sVArray[1]) : "";
        if (sVArray.length == 4) {
            int n = sVArray[1].asInt();
            int n2 = sVArray[2].asInt();
            int n3 = sVArray[3].asInt();
            float[] fArray = Parser.parseFloatArrayFromMatchAndField((String)string2, null, (int)0, (int)0, null, (int)n, (int)n2, null, (int)n3);
            return scriptMathProcessor.addXStr(Escape.escapeFloatA((float[])fArray, (boolean)false));
        }
        if (string2.indexOf("data2d_") == 0) {
            float[][] fArray = this.vwr.getDataFloat2D(string2);
            if (fArray == null) {
                return scriptMathProcessor.addXStr("");
            }
            if (sVArray.length == 2 && sVArray[1].tok == 2) {
                int n = sVArray[1].intValue;
                if (n < 0) {
                    n += fArray.length;
                }
                if (n >= 0 && n < fArray.length) {
                    return scriptMathProcessor.addXStr(Escape.escapeFloatA((float[])fArray[n], (boolean)false));
                }
                return scriptMathProcessor.addXStr("");
            }
            return scriptMathProcessor.addXStr(Escape.escapeFloatAA((float[][])fArray, (boolean)false));
        }
        if (string2.indexOf("property_") == 0) {
            float[] fArray;
            float[] fArray2 = this.vwr.getDataFloat(string2);
            if (fArray2 == null) {
                return scriptMathProcessor.addXStr("");
            }
            float[] fArray3 = fArray = string.indexOf("property_") == 0 ? this.vwr.getDataFloat(string) : null;
            if (fArray != null) {
                fArray2 = AU.arrayCopyF((float[])fArray2, (int)-1);
                int n = Math.min(fArray2.length, fArray.length);
                while (--n >= 0) {
                    int n4 = n;
                    fArray2[n4] = fArray2[n4] + fArray[n];
                }
            }
            return scriptMathProcessor.addXStr(Escape.escapeFloatA((float[])fArray2, (boolean)false));
        }
        if (sVArray.length == 1) {
            Object[] objectArray = this.vwr.getData(string2);
            return scriptMathProcessor.addXStr(objectArray == null ? "" : "" + objectArray[1]);
        }
        return scriptMathProcessor.addXStr(this.vwr.getData(string2, string));
    }

    private boolean evaluateDot(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n, int n2) throws ScriptException {
        switch (sVArray.length) {
            case 1: {
                if (n == 1276117505) {
                    return false;
                }
            }
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        SV sV = scriptMathProcessor.getX();
        SV sV2 = sVArray[0];
        P3 p3 = sV2.tok == 7 ? null : scriptMathProcessor.ptValue(sV2, false);
        P4 p4 = scriptMathProcessor.planeValue((T)sV2);
        if (n == 1276118018) {
            int n3 = n2 & 0x1E0;
            boolean bl = n3 == 32 || n3 == 64;
            boolean bl2 = n3 == 480;
            switch (sV.tok) {
                case 10: {
                    BS bS = SV.bsSelectVar((SV)sV);
                    BS bS2 = null;
                    boolean bl3 = bl && sVArray.length == 2 && sVArray[1].asBoolean();
                    switch (sV2.tok) {
                        case 10: {
                            bS2 = sV2.tok == 10 ? SV.bsSelectVar((SV)sV2) : null;
                        }
                        case 8: {
                            Atom[] atomArray = this.vwr.ms.at;
                            if (bl3) {
                                float f = Float.NaN;
                                int n4 = Integer.MAX_VALUE;
                                int n5 = bS.nextSetBit(0);
                                while (n5 >= 0) {
                                    float f2;
                                    float f3 = f2 = bS2 == null ? atomArray[n5].distanceSquared((T3)p3) : ((Float)this.e.getBitsetProperty(bS2, n2, (P3)atomArray[n5], p4, sV.value, null, false, sV.index, false)).floatValue();
                                    if (!(n3 == 32 ? f2 >= f : f2 <= f)) {
                                        f = f2;
                                        n4 = n5;
                                    }
                                    n5 = bS.nextSetBit(n5 + 1);
                                }
                                return scriptMathProcessor.addXBs(n4 == Integer.MAX_VALUE ? new BS() : BSUtil.newAndSetBit((int)n4));
                            }
                            if (bl2) {
                                if (bS2 == null) {
                                    float[] fArray = new float[bS.cardinality()];
                                    int n6 = 0;
                                    int n7 = bS.nextSetBit(0);
                                    while (n7 >= 0) {
                                        fArray[n6] = atomArray[n7].distance((T3)p3);
                                        n7 = bS.nextSetBit(n7 + 1);
                                        ++n6;
                                    }
                                    return scriptMathProcessor.addXAF(fArray);
                                }
                                float[][] fArray = new float[bS.cardinality()][bS2.cardinality()];
                                int n8 = 0;
                                int n9 = bS.nextSetBit(0);
                                while (n9 >= 0) {
                                    int n10 = 0;
                                    int n11 = bS2.nextSetBit(0);
                                    while (n11 >= 0) {
                                        fArray[n8][n10] = atomArray[n9].distance((T3)atomArray[n11]);
                                        n11 = bS2.nextSetBit(n11 + 1);
                                        ++n10;
                                    }
                                    n9 = bS.nextSetBit(n9 + 1);
                                    ++n8;
                                }
                                return scriptMathProcessor.addXAFF(fArray);
                            }
                            if (bl) {
                                float[] fArray = new float[bS.cardinality()];
                                int n12 = bS.nextSetBit(0);
                                int n13 = 0;
                                while (n12 >= 0) {
                                    fArray[n13++] = ((Float)this.e.getBitsetProperty(bS2, n2, (P3)atomArray[n12], p4, sV.value, null, false, sV.index, false)).floatValue();
                                    n12 = bS.nextSetBit(n12 + 1);
                                }
                                return scriptMathProcessor.addXAF(fArray);
                            }
                            return scriptMathProcessor.addXObj(this.e.getBitsetProperty(bS, n2, p3, p4, sV.value, null, false, sV.index, false));
                        }
                    }
                }
            }
        }
        return scriptMathProcessor.addXFloat(this.getDistance(scriptMathProcessor, sV, sV2, n));
    }

    private boolean evaluateHelix(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        if (sVArray.length < 1 || sVArray.length > 5) {
            return false;
        }
        int n = sVArray.length > 2 ? 3 : 1;
        String string = n >= sVArray.length ? "array" : SV.sValue((T)sVArray[n]);
        int n2 = T.getTokFromName((String)string);
        if (sVArray.length > 2) {
            P3 p3 = scriptMathProcessor.ptValue(sVArray[0], true);
            P3 p32 = scriptMathProcessor.ptValue(sVArray[1], true);
            if (n2 == 0 || sVArray[2].tok != 9) {
                return false;
            }
            Quat quat = Quat.newP4((P4)((P4)sVArray[2].value));
            T3[] t3Array = Measure.computeHelicalAxis((P3)p3, (P3)p32, (Quat)quat);
            return t3Array == null ? false : scriptMathProcessor.addXObj(Escape.escapeHelical((String)string, (int)n2, (P3)p3, (P3)p32, (T3[])t3Array));
        }
        BS bS = sVArray[0].value instanceof BS ? (BS)sVArray[0].value : this.vwr.ms.getAtoms(1095761939, (Object)new Integer(sVArray[0].asInt()));
        switch (n2) {
            case 0x8100010: {
                return scriptMathProcessor.addXObj(this.getHelixData(bS, 0x8100010));
            }
            case 1073741854: {
                return scriptMathProcessor.addXObj(this.getHelixData(bS, 1073741854));
            }
            case 1666189314: {
                return scriptMathProcessor.addXObj(this.getHelixData(bS, 1666189314));
            }
            case 0x8100001: {
                return scriptMathProcessor.addXFloat(((Float)this.getHelixData(bS, 0x8100001)).floatValue());
            }
            case 135176: 
            case 1746538509: {
                return scriptMathProcessor.addXObj(this.getHelixData(bS, n2));
            }
            case 135266306: {
                String[] stringArray = (String[])this.getHelixData(bS, 1073742001);
                if (stringArray == null) {
                    return false;
                }
                return scriptMathProcessor.addXAS(stringArray);
            }
        }
        return false;
    }

    private Object getHelixData(BS bS, int n) {
        int n2 = bS.nextSetBit(0);
        return n2 < 0 ? "null" : this.vwr.ms.at[n2].group.getHelixData(n, this.vwr.getQuaternionFrame(), this.vwr.getInt(0x21000012));
    }

    private boolean evaluateFind(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        boolean bl;
        if (sVArray.length == 0) {
            return false;
        }
        SV sV = scriptMathProcessor.getX();
        String string = SV.sValue((T)sVArray[0]);
        String string2 = sVArray.length > 1 && sVArray[1].tok != 0x10000D && sVArray[1].tok != 0x10000C ? SV.sValue((T)sVArray[1]) : "";
        boolean bl2 = string.equalsIgnoreCase("SEQUENCE");
        boolean bl3 = string.equalsIgnoreCase("SMILES");
        boolean bl4 = string.equalsIgnoreCase("SMARTS");
        boolean bl5 = string.equalsIgnoreCase("CHEMICAL");
        boolean bl6 = string.equalsIgnoreCase("MF");
        boolean bl7 = string.equalsIgnoreCase("CELLFORMULA");
        boolean bl8 = sVArray[sVArray.length - 1].tok == 0x10000D;
        try {
            if (bl5) {
                String string3;
                String string4 = string3 = sV.tok == 10 ? this.vwr.getSmiles(SV.getBitSet((SV)sV, (boolean)false)) : SV.sValue((T)sV);
                String string5 = string3.length() == 0 ? "" : (string3 = this.vwr.getChemicalInfo(string3, sVArray.length > 1 ? T.getTokenFromName((String)string2.toLowerCase()) : null));
                if (string3.endsWith("\n")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if (string3.startsWith("InChI")) {
                    string3 = PT.rep((String)PT.rep((String)string3, (String)"InChI=", (String)""), (String)"InChIKey=", (String)"");
                }
                return scriptMathProcessor.addXStr(string3);
            }
            if (bl3 || bl4 || sV.tok == 10) {
                int n = bl3 || bl4 ? 2 : 1;
                BS bS = n < sVArray.length && sVArray[n].tok == 10 ? (BS)sVArray[n++].value : null;
                boolean bl9 = "bonds".equalsIgnoreCase(SV.sValue((T)sVArray[sVArray.length - 1]));
                boolean bl10 = bl9 || bl8;
                Object object = null;
                switch (sV.tok) {
                    case 4: {
                        String string6 = SV.sValue((T)sV);
                        if (bS != null) {
                            return false;
                        }
                        if (string2.equalsIgnoreCase("mf")) {
                            object = this.vwr.getSmilesMatcher().getMolecularFormula(string6, bl4);
                            break;
                        }
                        object = this.e.getSmilesExt().getSmilesMatches(string2, string6, null, null, bl4, !bl10);
                        break;
                    }
                    case 10: {
                        if (bl6 && string2.length() != 0) {
                            return scriptMathProcessor.addXBs(JmolMolecule.getBitSetForMF((Atom[])this.vwr.ms.at, (BS)((BS)sV.value), (String)string2));
                        }
                        if (bl6 || bl7) {
                            return scriptMathProcessor.addXStr(JmolMolecule.getMolecularFormula((Node[])this.vwr.ms.at, (BS)((BS)sV.value), (boolean)false, bl6 ? null : this.vwr.ms.getCellWeights((BS)sV.value), (boolean)bl8));
                        }
                        if (bl2) {
                            return scriptMathProcessor.addXStr(this.vwr.getSmilesOpt((BS)sV.value, -1, -1, false, true, bl10, bl10, false));
                        }
                        if (bl3 || bl4) {
                            string = string2;
                        }
                        BS bS2 = bS;
                        if (bl9) {
                            int[][] nArray = this.vwr.getSmilesMatcher().getCorrelationMaps(string, (Node[])this.vwr.ms.at, this.vwr.ms.ac, (BS)sV.value, !bl3, true);
                            object = nArray.length > 0 ? (Object)this.vwr.ms.getDihedralMap(nArray[0]) : new int[]{};
                            break;
                        }
                        object = this.e.getSmilesExt().getSmilesMatches(string, null, (BS)sV.value, bS2, !bl3, !bl10);
                    }
                }
                if (object == null) {
                    this.e.invArg();
                }
                return scriptMathProcessor.addXObj(object);
            }
        }
        catch (Exception exception) {
            this.e.evalError(exception.getMessage(), null);
        }
        boolean bl11 = string2.indexOf("v") >= 0;
        boolean bl12 = string2.indexOf("i") >= 0;
        boolean bl13 = string2.indexOf("m") >= 0;
        boolean bl14 = sV.tok == 7;
        boolean bl15 = bl = sVArray.length == 2;
        if (bl14 || bl) {
            JmolPatternMatcher jmolPatternMatcher = this.getPatternMatcher();
            Pattern pattern = null;
            try {
                pattern = jmolPatternMatcher.compile(string, bl12);
            }
            catch (Exception exception) {
                this.e.evalError(exception.toString(), null);
            }
            String[] stringArray = SV.strListValue((T)sV);
            if (Logger.debugging) {
                Logger.debug((String)("finding " + string));
            }
            BS bS = new BS();
            int n = 0;
            int n2 = 0;
            Matcher matcher = null;
            Lst lst = bl13 ? new Lst() : null;
            for (int i = 0; i < stringArray.length; ++i) {
                String string7 = stringArray[i];
                matcher = pattern.matcher(string7);
                boolean bl16 = matcher.find();
                if ((!bl13 || !bl16) && (bl13 || bl16 != !bl11)) continue;
                ++n2;
                n = i;
                bS.set(i);
                if (!bl13) continue;
                lst.addLast((Object)(bl11 ? string7.substring(0, matcher.start()) + string7.substring(matcher.end()) : matcher.group()));
            }
            if (!bl14) {
                return bl13 ? scriptMathProcessor.addXStr(lst.size() == 1 ? (String)lst.get(0) : "") : (bl11 ? scriptMathProcessor.addXBool(n2 == 1) : (bl13 ? scriptMathProcessor.addXStr(n2 == 0 ? "" : matcher.group()) : scriptMathProcessor.addXInt(n2 == 0 ? 0 : matcher.start() + 1)));
            }
            if (n2 == 1) {
                return scriptMathProcessor.addXStr(bl13 ? (String)lst.get(0) : stringArray[n]);
            }
            String[] stringArray2 = new String[n2];
            if (n2 > 0) {
                int n3 = stringArray.length;
                while (--n3 >= 0) {
                    if (!bS.get(n3)) continue;
                    String string8 = bl13 ? (String)lst.get(--n2) : stringArray[n3];
                    stringArray2[n2] = string8;
                }
            }
            return scriptMathProcessor.addXAS(stringArray2);
        }
        return scriptMathProcessor.addXInt(SV.sValue((T)sV).indexOf(string) + 1);
    }

    private boolean evaluateGetProperty(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        int n;
        Object object;
        int n2;
        int n3 = 0;
        int n4 = n2 = sVArray.length == 0 ? 0 : sVArray[0].tok;
        if (sVArray.length == 2 && (n2 == 7 || n2 == 6 || n2 == 14)) {
            return scriptMathProcessor.addXObj(this.vwr.extractProperty(sVArray[0].value, (Object)sVArray[1].value.toString(), -1));
        }
        String string = sVArray.length > 0 ? SV.sValue((T)sVArray[n3++]) : "";
        String string2 = string.toLowerCase();
        if (string2.indexOf("[select ") < 0) {
            string = string2;
        }
        boolean bl2 = false;
        if (string.equals("json") && sVArray.length > n3) {
            bl2 = true;
            string = SV.sValue((T)sVArray[n3++]);
        }
        if (string.startsWith("$")) {
            // empty if block
        }
        if (bl && !string.equalsIgnoreCase("bondInfo")) {
            string = "atomInfo." + string;
        }
        BS[] bSArray = "";
        if (string.equalsIgnoreCase("fileContents") && sVArray.length > 2) {
            object = SV.sValue((T)sVArray[1]);
            for (n = 2; n < sVArray.length; ++n) {
                object = (String)object + "|" + SV.sValue((T)sVArray[n]);
            }
            bSArray = object;
            n3 = sVArray.length;
        } else if (sVArray.length > n3) {
            switch (sVArray[n3].tok) {
                case 10: {
                    bSArray = SV.bsSelectVar((SV)sVArray[n3++]);
                    if (!string.equalsIgnoreCase("bondInfo") || sVArray.length <= n3 || sVArray[n3].tok != 10) break;
                    bSArray = new BS[]{(BS)bSArray, SV.bsSelectVar((SV)sVArray[n3])};
                    break;
                }
                case 4: {
                    if (!this.vwr.checkPropertyParameter(string)) break;
                    bSArray = sVArray[n3++].value;
                }
            }
        }
        if (bl) {
            object = scriptMathProcessor.getX();
            if (((SV)object).tok != 10) {
                return false;
            }
            n = SV.bsSelectVar((SV)object).nextSetBit(0);
            if (n < 0) {
                return scriptMathProcessor.addXStr("");
            }
            bSArray = BSUtil.newAndSetBit((int)n);
        }
        object = this.vwr.getProperty(null, string, (Object)bSArray);
        if (n3 < sVArray.length) {
            object = this.vwr.extractProperty(object, (Object)sVArray, n3);
        }
        if (bl && object instanceof Lst) {
            Object object2 = object = ((Lst)object).size() > 0 ? ((Lst)object).get(0) : "";
        }
        return scriptMathProcessor.addXObj(bl2 ? "{" + PT.toJSON((String)"value", (Object)object) + "}" : (SV.isVariableType((Object)object) ? object : Escape.toReadable((String)string, (Object)object)));
    }

    private boolean evaluateFormat(ScriptMathProcessor scriptMathProcessor, int n, SV[] sVArray, boolean bl) throws ScriptException {
        String string;
        SV sV = sVArray.length < 2 ? scriptMathProcessor.getX() : null;
        String string2 = string = sVArray.length == 0 ? "%U" : SV.sValue((T)sVArray[0]);
        if (sV == null) {
            int n2;
            int n3 = n2 = bl ? -1 : SV.getFormatType((String)string);
            if (n2 >= 0 && sVArray.length != 2) {
                return false;
            }
            if (n2 >= 0 || sVArray.length < 2 || sVArray[1].tok != 7) {
                return scriptMathProcessor.addXObj(SV.format((SV[])sVArray, (int)n2));
            }
            Lst lst = sVArray[1].getList();
            SV[] sVArray2 = new SV[]{sVArray[0], null};
            String[] stringArray = new String[lst.size()];
            int n4 = stringArray.length;
            while (--n4 >= 0) {
                sVArray2[1] = (SV)lst.get(n4);
                stringArray[n4] = SV.format((SV[])sVArray2, (int)n2).toString();
            }
            return scriptMathProcessor.addXAS(stringArray);
        }
        BS bS = SV.getBitSet((SV)sV, (boolean)true);
        boolean bl2 = T.tokAttr((int)n, (int)480);
        return scriptMathProcessor.addXObj(bS == null ? SV.sprintf((String)PT.formatCheck((String)string), (SV)sV) : this.e.getCmdExt().getBitsetIdent(bS, string, sV.value, true, sV.index, bl2));
    }

    private boolean evaluateList(ScriptMathProcessor scriptMathProcessor, int n, SV[] sVArray) throws ScriptException {
        boolean bl;
        int n2 = sVArray.length;
        SV sV = scriptMathProcessor.getX();
        boolean bl2 = sV.tok == 7;
        switch (n) {
            case 1276384259: {
                return n2 == 2 && scriptMathProcessor.addX(sV.pushPop(sVArray[1], sVArray[0])) || n2 == 1 && scriptMathProcessor.addX(sV.pushPop(sVArray[0], null));
            }
            case 1276383249: {
                return n2 == 1 && scriptMathProcessor.addX(sV.pushPop(null, sVArray[0])) || n2 == 0 && scriptMathProcessor.addX(sV.pushPop(null, null));
            }
            case 1276118017: {
                if (n2 == 1 || n2 == 2) break;
                return false;
            }
            case 1276118020: 
            case 1276118021: {
                break;
            }
            default: {
                if (n2 == 1) break;
                return false;
            }
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (n2 == 2) {
            boolean bl3;
            String string = SV.sValue((T)sVArray[0]);
            SV sV2 = sVArray[1];
            if (n == 1276118017) {
                stringArray = bl2 ? SV.strListValue((T)sV) : PT.split((String)SV.sValue((T)sV), (String)"\n");
                stringArray2 = sV2.tok == 7 ? SV.strListValue((T)sV2) : PT.split((String)SV.sValue((T)sV2), (String)"\n");
                n2 = Math.max(stringArray.length, stringArray2.length);
                stringArray3 = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray3[i] = (i >= stringArray.length ? "" : stringArray[i]) + string + (i >= stringArray2.length ? "" : stringArray2[i]);
                }
                return scriptMathProcessor.addXAS(stringArray3);
            }
            if (sV2.tok != 0x10000D) {
                return false;
            }
            Lst lst = sV.getList();
            boolean bl4 = bl3 = string.length() == 0;
            if (bl3) {
                string = ",";
            }
            if (n == 1276118020) {
                SV[] sVArray2 = new SV[lst.size()];
                int n3 = lst.size();
                while (--n3 >= 0) {
                    Lst lst2 = ((SV)lst.get(n3)).getList();
                    if (lst2 == null) {
                        sVArray2[n3] = (SV)lst.get(n3);
                        continue;
                    }
                    SB sB = new SB();
                    int n4 = lst2.size();
                    for (int i = 0; i < n4; ++i) {
                        if (i > 0) {
                            sB.append(string);
                        }
                        SV sV3 = (SV)lst2.get(i);
                        sB.append(bl3 && sV3.tok == 4 ? "\"" + PT.rep((String)((String)sV3.value), (String)"\"", (String)"\"\"") + "\"" : "" + sV3.asString());
                    }
                    sVArray2[n3] = SV.newS((String)sB.toString());
                }
                return scriptMathProcessor.addXAV(sVArray2);
            }
            Lst lst3 = new Lst();
            if (bl3) {
                string = "\u0000";
            }
            int[] nArray = new int[2];
            int n5 = lst.size();
            for (int i = 0; i < n5; ++i) {
                Object object;
                String string2 = ((SV)lst.get(i)).asString();
                if (bl3) {
                    nArray[1] = 0;
                    nArray[0] = 0;
                    int n6 = 0;
                    while (true) {
                        if ((object = PT.getCSVString((String)string2, (int[])nArray)) == null) {
                            if (nArray[1] == -1) {
                                string2 = string2 + (++i < n5 ? "\n" + ((SV)lst.get(i)).asString() : "\"");
                                nArray[1] = n6;
                                continue;
                            }
                            string2 = string2.substring(0, n6) + string2.substring(n6).replace(',', '\u0000');
                            break;
                        }
                        string2 = string2.substring(0, n6) + string2.substring(n6, nArray[0]).replace(',', '\u0000') + (String)object + string2.substring(nArray[1]);
                        nArray[1] = n6 = nArray[0] + ((String)object).length();
                    }
                }
                String[] stringArray4 = string2.split(string);
                object = new Lst();
                for (String string3 : stringArray4) {
                    if (string3.indexOf(".") < 0) {
                        try {
                            object.addLast((Object)SV.newI((int)Integer.parseInt(string3)));
                            continue;
                        }
                        catch (Exception exception) {
                        }
                    } else {
                        try {
                            object.addLast((Object)SV.getVariable((Object)Float.valueOf(Float.parseFloat(string3))));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    object.addLast((Object)SV.newS((String)string3));
                }
                lst3.addLast((Object)SV.getVariableList((Lst)object));
            }
            return scriptMathProcessor.addXObj((Object)SV.getVariableList((Lst)lst3));
        }
        SV sV4 = n2 == 0 ? SV.newV((int)0x100003, (Object)"all") : sVArray[0];
        boolean bl5 = bl = sV4.tok == 0x100003;
        if (!bl2 && sV.tok != 4) {
            return scriptMathProcessor.binaryOp(this.opTokenFor(n), sV, sV4);
        }
        boolean bl6 = SV.isScalar((SV)sV);
        boolean bl7 = SV.isScalar((SV)sV4);
        float[] fArray = null;
        float[] fArray2 = null;
        Lst lst = sV.getList();
        Lst lst4 = sV4.getList();
        if (bl2) {
            n2 = lst.size();
        } else if (bl6) {
            n2 = Integer.MAX_VALUE;
        } else {
            stringArray = PT.split((String)SV.sValue((T)sV), (String)"\n");
            n2 = stringArray.length;
            fArray = new float[n2];
            PT.parseFloatArrayData((String[])stringArray, (float[])fArray);
        }
        if (bl && n != 1276118020) {
            float f = 0.0f;
            if (bl2) {
                int n7 = n2;
                while (--n7 >= 0) {
                    f += SV.fValue((T)((T)lst.get(n7)));
                }
            } else if (!bl6) {
                int n8 = n2;
                while (--n8 >= 0) {
                    f += fArray[n8];
                }
            }
            return scriptMathProcessor.addXFloat(f);
        }
        if (n == 1276118020 && sV4.tok == 4) {
            SB sB = new SB();
            if (bl6) {
                sB.append(SV.sValue((T)sV));
            } else {
                String string = bl ? "" : sV4.value.toString();
                for (int i = 0; i < n2; ++i) {
                    sB.append(i > 0 ? string : "").append(SV.sValue((T)((T)lst.get(i))));
                }
            }
            return scriptMathProcessor.addXStr(sB.toString());
        }
        SV sV5 = null;
        if (bl7) {
            sV5 = sV4;
        } else if (sV4.tok == 7) {
            n2 = Math.min(n2, lst4.size());
        } else {
            stringArray2 = PT.split((String)SV.sValue((T)sV4), (String)"\n");
            fArray2 = new float[stringArray2.length];
            PT.parseFloatArrayData((String[])stringArray2, (float[])fArray2);
            n2 = Math.min(n2, fArray2.length);
        }
        T t = this.opTokenFor(n);
        SV[] sVArray3 = new SV[n2];
        if (bl2 && bl) {
            Lst lst5 = new Lst();
            return scriptMathProcessor.addXList(this.addAllLists((Lst<SV>)sV.getList(), (Lst<SV>)lst5));
        }
        SV sV6 = bl6 ? sV : null;
        for (int i = 0; i < n2; ++i) {
            SV sV7 = bl7 ? sV5 : (sV4.tok == 7 ? (SV)lst4.get(i) : (Float.isNaN(fArray2[i]) ? SV.getVariable((Object)SV.unescapePointOrBitsetAsVariable((Object)stringArray2[i])) : SV.newV((int)3, (Object)Float.valueOf(fArray2[i]))));
            if (!bl6) {
                sV6 = bl2 ? (SV)lst.get(i) : (Float.isNaN(fArray[i]) ? SV.getVariable((Object)SV.unescapePointOrBitsetAsVariable((Object)stringArray[i])) : SV.newV((int)3, (Object)Float.valueOf(fArray[i])));
            }
            if (n == 1276118020 && sV6.tok != 7) {
                Lst lst6 = new Lst();
                lst6.addLast((Object)sV6);
                sV6 = SV.getVariableList((Lst)lst6);
            }
            if (!scriptMathProcessor.binaryOp(t, sV6, sV7)) {
                return false;
            }
            sVArray3[i] = scriptMathProcessor.getX();
        }
        return scriptMathProcessor.addXAV(sVArray3);
    }

    private Lst<SV> addAllLists(Lst<SV> lst, Lst<SV> lst2) {
        int n = lst.size();
        for (int i = 0; i < n; ++i) {
            SV sV = (SV)lst.get(i);
            if (sV.tok == 7) {
                this.addAllLists((Lst<SV>)sV.getList(), lst2);
                continue;
            }
            lst2.addLast((Object)sV);
        }
        return lst2;
    }

    private boolean evaluateLoad(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        String string;
        int n = -1;
        boolean bl2 = false;
        boolean bl3 = this.vwr.async;
        switch (sVArray.length) {
            case 3: {
                bl3 = SV.bValue((T)sVArray[2]);
            }
            case 2: {
                n = sVArray[1].tok == 2 ? sVArray[1].asInt() : -1;
                bl2 = sVArray[1].tok == 0x10000D;
            }
            case 1: {
                string = SV.sValue((T)sVArray[0]);
                string = string.replace('\\', '/');
                break;
            }
            default: {
                return false;
            }
        }
        if (bl2) {
            return scriptMathProcessor.addXMap(this.vwr.fm.getFileAsMap(string));
        }
        boolean bl4 = string.startsWith("?");
        if (this.vwr.isJS && (bl4 || bl3)) {
            if (bl && bl4) {
                return scriptMathProcessor.addXStr("");
            }
            string = this.e.loadFileAsync("load()_", string, scriptMathProcessor.oPt, true);
        }
        return scriptMathProcessor.addXStr(bl ? this.vwr.fm.getFilePath(string, false, false) : this.vwr.getFileAsString4(string, n, false, false, true, "script"));
    }

    private boolean evaluateMath(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) {
        if (n == 135266318) {
            if (sVArray.length == 1 && sVArray[0].tok == 4) {
                return scriptMathProcessor.addXStr(new Date() + "\t" + SV.sValue((T)sVArray[0]));
            }
            return scriptMathProcessor.addXInt(((int)System.currentTimeMillis() & Integer.MAX_VALUE) - (sVArray.length == 0 ? 0 : sVArray[0].asInt()));
        }
        if (sVArray.length != 1) {
            return false;
        }
        if (n == 135266826) {
            if (sVArray[0].tok == 2) {
                return scriptMathProcessor.addXInt(Math.abs(sVArray[0].asInt()));
            }
            return scriptMathProcessor.addXFloat(Math.abs(sVArray[0].asFloat()));
        }
        double d = SV.fValue((T)sVArray[0]);
        switch (n) {
            case 135266819: {
                return scriptMathProcessor.addXFloat((float)(Math.acos(d) * 180.0 / Math.PI));
            }
            case 135266821: {
                return scriptMathProcessor.addXFloat((float)Math.cos(d * Math.PI / 180.0));
            }
            case 135266820: {
                return scriptMathProcessor.addXFloat((float)Math.sin(d * Math.PI / 180.0));
            }
            case 135266822: {
                return scriptMathProcessor.addXFloat((float)Math.sqrt(d));
            }
        }
        return false;
    }

    private boolean evaluateMeasure(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        int n2 = 0;
        switch (n) {
            case 1746538509: {
                Lst lst = new Lst();
                float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
                String string = null;
                String string2 = null;
                boolean bl = false;
                boolean bl2 = false;
                int n3 = 0;
                boolean bl3 = false;
                RadiusData radiusData = null;
                int n4 = 0;
                float f = Float.MAX_VALUE;
                boolean bl4 = false;
                boolean bl5 = false;
                block15: for (int i = 0; i < sVArray.length; ++i) {
                    switch (sVArray[i].tok) {
                        case 10: {
                            BS bS = (BS)sVArray[i].value;
                            if (bS.length() == 0) {
                                bl3 = true;
                            }
                            lst.addLast((Object)bS);
                            ++n2;
                            ++n4;
                            continue block15;
                        }
                        case 8: {
                            Point3fi point3fi = new Point3fi();
                            point3fi.setT((T3)((P3)sVArray[i].value));
                            lst.addLast((Object)point3fi);
                            ++n2;
                            continue block15;
                        }
                        case 2: 
                        case 3: {
                            fArray[n3++ % 2] = SV.fValue((T)sVArray[i]);
                            continue block15;
                        }
                        case 4: {
                            String string3 = SV.sValue((T)sVArray[i]);
                            if (string3.equalsIgnoreCase("vdw") || string3.equalsIgnoreCase("vanderwaals")) {
                                f = (float)(i + 1 < sVArray.length && sVArray[i + 1].tok == 2 ? sVArray[++i].asInt() : 100) / 100.0f;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("notConnected")) {
                                bl2 = true;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("connected")) {
                                bl = true;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("minArray")) {
                                bl4 = n4 >= 1;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("asArray")) {
                                bl5 = n4 >= 1;
                                continue block15;
                            }
                            if (PT.isOneOf((String)string3.toLowerCase(), (String)";nm;nanometers;pm;picometers;angstroms;ang;au;") || string3.endsWith("hz")) {
                                string2 = string3.toLowerCase();
                                continue block15;
                            }
                            string = n2 + ":" + string3;
                            continue block15;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (n2 < 2 || n2 > 4 || n3 > 2 || bl2 && bl) {
                    return false;
                }
                if (bl3) {
                    return scriptMathProcessor.addXStr("");
                }
                if (f != Float.MAX_VALUE && (n4 != 2 || n2 != 2)) {
                    return scriptMathProcessor.addXStr("");
                }
                radiusData = f == Float.MAX_VALUE ? new RadiusData(fArray, 0.0f, null, null) : new RadiusData(null, f, RadiusData.EnumType.FACTOR, VDW.AUTO);
                return scriptMathProcessor.addXObj(this.vwr.newMeasurementData(null, lst).set(0, null, radiusData, string, string2, null, bl, bl2, null, true, 0, (short)0, null).getMeasurements(bl5, bl4));
            }
            case 0x8100001: {
                n2 = sVArray.length;
                if (n2 == 3 || n2 == 4) break;
                return false;
            }
            default: {
                n2 = sVArray.length;
                if (n2 == 2) break;
                return false;
            }
        }
        P3[] p3Array = new P3[n2];
        for (int i = 0; i < n2; ++i) {
            p3Array[i] = scriptMathProcessor.ptValue(sVArray[i], true);
        }
        switch (n2) {
            case 2: {
                return scriptMathProcessor.addXFloat(p3Array[0].distance((T3)p3Array[1]));
            }
            case 3: {
                return scriptMathProcessor.addXFloat(Measure.computeAngleABC((T3)p3Array[0], (T3)p3Array[1], (T3)p3Array[2], (boolean)true));
            }
            case 4: {
                return scriptMathProcessor.addXFloat(Measure.computeTorsion((T3)p3Array[0], (T3)p3Array[1], (T3)p3Array[2], (T3)p3Array[3], (boolean)true));
            }
        }
        return false;
    }

    private boolean evaluateModulation(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        String string = "";
        float f = Float.NaN;
        P3 p3 = null;
        block0 : switch (sVArray.length) {
            case 0: {
                break;
            }
            case 1: {
                switch (sVArray[0].tok) {
                    case 8: {
                        p3 = (P3)sVArray[0].value;
                        break block0;
                    }
                    case 4: {
                        string = sVArray[0].asString();
                        break block0;
                    }
                }
                f = SV.fValue((T)sVArray[0]);
                break;
            }
            case 2: {
                string = SV.sValue((T)sVArray[0]);
                f = SV.fValue((T)sVArray[1]);
                break;
            }
            default: {
                return false;
            }
        }
        if (p3 == null && (double)f < 1000000.0) {
            p3 = P3.new3((float)f, (float)f, (float)f);
        }
        BS bS = SV.getBitSet((SV)scriptMathProcessor.getX(), (boolean)false);
        return scriptMathProcessor.addXList(this.vwr.ms.getModulationList(bS, (string + "D").toUpperCase().charAt(0), p3));
    }

    private boolean evaluatePlane(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        block33: {
            if (n == 135267841 && sVArray.length != 3 || n == 135267842 && sVArray.length != 2 && sVArray.length != 3 || sVArray.length == 0 || sVArray.length > 4) {
                return false;
            }
            switch (sVArray.length) {
                case 1: {
                    Object object;
                    if (sVArray[0].tok == 10 && (object = SV.getBitSet((SV)sVArray[0], (boolean)false)).cardinality() == 3) {
                        Lst lst = this.vwr.ms.getAtomPointVector(object);
                        return scriptMathProcessor.addXPt4(Measure.getPlaneThroughPoints((T3)((T3)lst.get(0)), (T3)((T3)lst.get(1)), (T3)((T3)lst.get(2)), (V3)new V3(), (V3)new V3(), (P4)new P4()));
                    }
                    object = Escape.uP((String)SV.sValue((T)sVArray[0]));
                    if (object instanceof P4) {
                        return scriptMathProcessor.addXPt4((P4)object);
                    }
                    return scriptMathProcessor.addXStr("" + object);
                }
                case 2: {
                    if (n == 135267842) {
                        if (sVArray[1].tok != 9) {
                            return false;
                        }
                        P3 p3 = new P3();
                        V3 v3 = new V3();
                        V3 v32 = new V3();
                        P4 p4 = (P4)sVArray[1].value;
                        if (sVArray[0].tok == 9) {
                            Lst lst = Measure.getIntersectionPP((P4)((P4)sVArray[0].value), (P4)p4);
                            if (lst == null) {
                                return scriptMathProcessor.addXStr("");
                            }
                            return scriptMathProcessor.addXList(lst);
                        }
                        P3 p32 = scriptMathProcessor.ptValue(sVArray[0], false);
                        if (p32 == null) {
                            return scriptMathProcessor.addXStr("");
                        }
                        return scriptMathProcessor.addXPt(Measure.getIntersection((P3)p32, null, (P4)p4, (P3)p3, (V3)v3, (V3)v32));
                    }
                }
                case 3: 
                case 4: {
                    switch (n) {
                        case 135267841: {
                            return scriptMathProcessor.addXPt4(this.e.getHklPlane(P3.new3((float)SV.fValue((T)sVArray[0]), (float)SV.fValue((T)sVArray[1]), (float)SV.fValue((T)sVArray[2]))));
                        }
                        case 135267842: {
                            P3 p3 = scriptMathProcessor.ptValue(sVArray[0], false);
                            P3 p33 = scriptMathProcessor.ptValue(sVArray[1], false);
                            if (p3 == null || p33 == null) {
                                return scriptMathProcessor.addXStr("");
                            }
                            V3 v3 = V3.newV((T3)p33);
                            v3.normalize();
                            if (sVArray[2].tok == 9) {
                                P3 p34 = new P3();
                                V3 v33 = new V3();
                                V3 v34 = new V3();
                                if ((p3 = Measure.getIntersection((P3)p3, (V3)v3, (P4)((P4)sVArray[2].value), (P3)p34, (V3)v33, (V3)v34)) == null) {
                                    return scriptMathProcessor.addXStr("");
                                }
                                return scriptMathProcessor.addXPt(p3);
                            }
                            P3 p35 = scriptMathProcessor.ptValue(sVArray[2], false);
                            if (p35 == null) {
                                return scriptMathProcessor.addXStr("");
                            }
                            V3 v35 = new V3();
                            Measure.projectOntoAxis((P3)p35, (P3)p3, (V3)v3, (V3)v35);
                            return scriptMathProcessor.addXPt(p35);
                        }
                    }
                    switch (sVArray[0].tok) {
                        case 2: 
                        case 3: {
                            if (sVArray.length == 3) {
                                float f = SV.fValue((T)sVArray[0]);
                                float f2 = SV.fValue((T)sVArray[1]);
                                float f3 = SV.fValue((T)sVArray[2]);
                                V3 v3 = V3.new3((float)0.0f, (float)0.0f, (float)1.0f);
                                P3 p3 = P3.new3((float)0.0f, (float)1.0f, (float)0.0f);
                                Quat quat = Quat.newVA((T3)p3, (float)f3);
                                quat.getMatrix().rotate((T3)v3);
                                p3.set(0.0f, 0.0f, 1.0f);
                                quat = Quat.newVA((T3)p3, (float)f2);
                                quat.getMatrix().rotate((T3)v3);
                                p3.setT((T3)v3);
                                p3.scale(f);
                                P4 p4 = new P4();
                                Measure.getPlaneThroughPoint((T3)p3, (V3)v3, (P4)p4);
                                return scriptMathProcessor.addXPt4(p4);
                            }
                            break block33;
                        }
                        case 8: 
                        case 10: {
                            P3 p3 = scriptMathProcessor.ptValue(sVArray[0], false);
                            P3 p36 = scriptMathProcessor.ptValue(sVArray[1], false);
                            if (p36 == null) {
                                return false;
                            }
                            P3 p37 = sVArray.length > 2 && (sVArray[2].tok == 10 || sVArray[2].tok == 8) ? scriptMathProcessor.ptValue(sVArray[2], false) : null;
                            V3 v3 = V3.newV((T3)p36);
                            if (p37 == null) {
                                P4 p4 = new P4();
                                if (sVArray.length == 2 || !sVArray[2].asBoolean()) {
                                    p37 = P3.newP((T3)p3);
                                    p37.add((T3)p36);
                                    p37.scale(0.5f);
                                    v3.sub((T3)p3);
                                    v3.normalize();
                                } else if (sVArray[2].tok == 0x10000D) {
                                    p37 = p3;
                                } else {
                                    v3.sub((T3)p3);
                                    p37 = new P3();
                                    p37.scaleAdd2(sVArray[2].asFloat(), (T3)v3, (T3)p3);
                                }
                                Measure.getPlaneThroughPoint((T3)p37, (V3)v3, (P4)p4);
                                return scriptMathProcessor.addXPt4(p4);
                            }
                            V3 v36 = new V3();
                            float f = Measure.getDirectedNormalThroughPoints((T3)p3, (T3)p36, (T3)p37, sVArray.length == 4 ? scriptMathProcessor.ptValue(sVArray[3], true) : null, (V3)v3, (V3)v36);
                            return scriptMathProcessor.addXPt4(P4.new4((float)v3.x, (float)v3.y, (float)v3.z, (float)f));
                        }
                    }
                }
            }
        }
        if (sVArray.length != 4) {
            return false;
        }
        float f = SV.fValue((T)sVArray[0]);
        float f4 = SV.fValue((T)sVArray[1]);
        float f5 = SV.fValue((T)sVArray[2]);
        float f6 = SV.fValue((T)sVArray[3]);
        return scriptMathProcessor.addXPt4(P4.new4((float)f, (float)f4, (float)f5, (float)f6));
    }

    private boolean evaluatePoint(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        switch (sVArray.length) {
            default: {
                return false;
            }
            case 1: {
                Object object;
                if (sVArray[0].tok == 3 || sVArray[0].tok == 2) {
                    return scriptMathProcessor.addXInt(sVArray[0].asInt());
                }
                String string = SV.sValue((T)sVArray[0]);
                if (sVArray[0].tok == 7) {
                    string = "{" + string + "}";
                }
                return (object = Escape.uP((String)string)) instanceof P3 ? scriptMathProcessor.addXPt((P3)object) : scriptMathProcessor.addXStr("" + object);
            }
            case 2: {
                P3 p3 = SV.ptValue((SV)sVArray[0]);
                if (p3 == null) {
                    return false;
                }
                if (sVArray[1].tok == 0x10000C) {
                    this.vwr.tm.unTransformPoint((T3)p3, (T3)p3);
                } else {
                    this.vwr.tm.transformPt3f((T3)p3, p3);
                }
                return scriptMathProcessor.addXPt(p3);
            }
            case 3: {
                return scriptMathProcessor.addXPt(P3.new3((float)sVArray[0].asFloat(), (float)sVArray[1].asFloat(), (float)sVArray[2].asFloat()));
            }
            case 4: 
        }
        return scriptMathProcessor.addXPt4(P4.new4((float)sVArray[0].asFloat(), (float)sVArray[1].asFloat(), (float)sVArray[2].asFloat(), (float)sVArray[3].asFloat()));
    }

    private boolean evaluatePrompt(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        boolean bl;
        if (sVArray.length != 1 && sVArray.length != 2 && sVArray.length != 3) {
            return false;
        }
        String string = SV.sValue((T)sVArray[0]);
        String[] stringArray = sVArray.length > 1 && sVArray[1].tok == 7 ? SV.strListValue((T)sVArray[1]) : null;
        boolean bl2 = bl = stringArray != null || sVArray.length == 1 || sVArray.length == 3 && sVArray[2].asBoolean();
        String string2 = stringArray != null ? null : (sVArray.length >= 2 ? SV.sValue((T)sVArray[1]) : "OK");
        String string3 = "" + this.vwr.prompt(string, string2, stringArray, bl);
        return bl && stringArray != null ? scriptMathProcessor.addXInt(Integer.parseInt(string3) + 1) : scriptMathProcessor.addXStr(string3);
    }

    private boolean evaluateQuaternion(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        Object object;
        P3 p3 = null;
        int n2 = sVArray.length;
        int n3 = Integer.MAX_VALUE;
        boolean bl = false;
        if (n == 135270418) {
            if (n2 > 1 && sVArray[n2 - 1].tok == 4 && ((String)sVArray[n2 - 1].value).equalsIgnoreCase("relative")) {
                --n2;
                bl = true;
            }
            if (n2 > 1 && sVArray[n2 - 1].tok == 2 && sVArray[0].tok == 10) {
                n3 = sVArray[n2 - 1].asInt();
                if (n3 <= 0) {
                    n3 = 0x7FFFFFFE;
                }
                --n2;
            }
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                if (n == 135270418 && (sVArray[0].tok == 7 && (sVArray[1].tok == 7 || sVArray[1].tok == 0x10000D) || sVArray[0].tok == 10 && (sVArray[1].tok == 2 || sVArray[1].tok == 10)) || (p3 = scriptMathProcessor.ptValue(sVArray[0], false)) != null && (n == 135270418 || sVArray[1].tok != 8)) break;
                return false;
            }
            case 3: {
                if (n != 135270418) {
                    return false;
                }
                if (sVArray[0].tok == 9) {
                    if (sVArray[2].tok == 8 || sVArray[2].tok == 10) break;
                    return false;
                }
                for (int i = 0; i < 3; ++i) {
                    if (sVArray[i].tok == 8 || sVArray[i].tok == 10) continue;
                    return false;
                }
                break;
            }
            default: {
                return false;
            }
        }
        Quat quat = null;
        Quat[] quatArray = null;
        P4 p4 = null;
        switch (n2) {
            case 0: {
                return scriptMathProcessor.addXPt4(Quat.newM((M3)this.vwr.tm.matrixRotate).toPoint4f());
            }
            default: {
                Object object2;
                if (n == 135270418 && sVArray[0].tok == 7) {
                    object = this.e.getQuaternionArray((Object)sVArray[0].getList(), 1073742001);
                    object2 = Quat.sphereMean((Quat[])object, null, (float)1.0E-4f);
                    quat = object2 instanceof Quat ? object2 : null;
                    break;
                }
                if (n == 135270418 && sVArray[0].tok == 10) {
                    quatArray = this.vwr.getAtomGroupQuaternions((BS)sVArray[0].value, n3);
                } else if (sVArray[0].tok == 11) {
                    quat = Quat.newM((M3)((M3)sVArray[0].value));
                } else if (sVArray[0].tok == 9) {
                    p4 = (P4)sVArray[0].value;
                } else {
                    object = SV.sValue((T)sVArray[0]);
                    object2 = Escape.uP((String)(((String)object).equalsIgnoreCase("best") ? this.vwr.getOrientationText(1073741863, null) : object));
                    if (!(object2 instanceof P4)) {
                        return false;
                    }
                    p4 = (P4)object2;
                }
                if (n != 135266307) break;
                quat = Quat.newVA((T3)P3.new3((float)p4.x, (float)p4.y, (float)p4.z), (float)p4.w);
                break;
            }
            case 2: {
                Object object2;
                if (n == 135270418) {
                    if (sVArray[0].tok == 7 && sVArray[1].tok == 7) {
                        object = this.e.getQuaternionArray((Object)sVArray[0].getList(), 1073742001);
                        object2 = this.e.getQuaternionArray((Object)sVArray[1].getList(), 1073742001);
                        quatArray = Quat.div((Quat[])object2, (Quat[])object, (int)n3, (boolean)bl);
                        break;
                    }
                    if (sVArray[0].tok == 7 && sVArray[1].tok == 0x10000D) {
                        Quat[] quatArray2 = this.e.getQuaternionArray((Object)sVArray[0].getList(), 1073742001);
                        float[] fArray = new float[1];
                        Quat.sphereMean((Quat[])quatArray2, (float[])fArray, (float)1.0E-4f);
                        return scriptMathProcessor.addXFloat(fArray[0]);
                    }
                    if (sVArray[0].tok == 10 && sVArray[1].tok == 10) {
                        object = this.vwr.getAtomGroupQuaternions((BS)sVArray[0].value, Integer.MAX_VALUE);
                        object2 = this.vwr.getAtomGroupQuaternions((BS)sVArray[1].value, Integer.MAX_VALUE);
                        quatArray = Quat.div((Quat[])object2, (Quat[])object, (int)n3, (boolean)bl);
                        break;
                    }
                }
                object = scriptMathProcessor.ptValue(sVArray[1], false);
                p4 = scriptMathProcessor.planeValue((T)sVArray[0]);
                if (object != null) {
                    quat = Quat.getQuaternionFrame((P3)P3.new3((float)0.0f, (float)0.0f, (float)0.0f), (T3)p3, (T3)object);
                    break;
                }
                quat = Quat.newVA((T3)p3, (float)SV.fValue((T)sVArray[1]));
                break;
            }
            case 3: {
                if (sVArray[0].tok == 9) {
                    P3 p32 = sVArray[2].tok == 8 ? (P3)sVArray[2].value : this.vwr.ms.getAtomSetCenter((BS)sVArray[2].value);
                    return scriptMathProcessor.addXStr(Escape.drawQuat((Quat)Quat.newP4((P4)((P4)sVArray[0].value)), (String)"q", (String)SV.sValue((T)sVArray[1]), (P3)p32, (float)1.0f));
                }
                Object object2 = new P3[3];
                for (int i = 0; i < 3; ++i) {
                    object2[i] = sVArray[i].tok == 8 ? (P3)sVArray[i].value : this.vwr.ms.getAtomSetCenter((BS)sVArray[i].value);
                }
                quat = Quat.getQuaternionFrame((P3)object2[0], (T3)object2[1], (T3)object2[2]);
                break;
            }
            case 4: {
                if (n == 135270418) {
                    p4 = P4.new4((float)SV.fValue((T)sVArray[1]), (float)SV.fValue((T)sVArray[2]), (float)SV.fValue((T)sVArray[3]), (float)SV.fValue((T)sVArray[0]));
                    break;
                }
                quat = Quat.newVA((T3)P3.new3((float)SV.fValue((T)sVArray[0]), (float)SV.fValue((T)sVArray[1]), (float)SV.fValue((T)sVArray[2])), (float)SV.fValue((T)sVArray[3]));
            }
        }
        if (quatArray != null) {
            if (n3 != Integer.MAX_VALUE) {
                object = new Lst();
                for (int i = 0; i < quatArray.length; ++i) {
                    object.addLast((Object)quatArray[i].toPoint4f());
                }
                return scriptMathProcessor.addXList((Lst)object);
            }
            quat = quatArray.length > 0 ? quatArray[0] : null;
        }
        return scriptMathProcessor.addXPt4((quat == null ? Quat.newP4((P4)p4) : quat).toPoint4f());
    }

    private boolean evaluateRandom(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length > 2) {
            return false;
        }
        float f = sVArray.length < 2 ? 0.0f : SV.fValue((T)sVArray[0]);
        float f2 = sVArray.length == 0 ? 1.0f : SV.fValue((T)sVArray[sVArray.length - 1]);
        return scriptMathProcessor.addXFloat((float)(Math.random() * (double)(f2 -= f)) + f);
    }

    private boolean evaluateRowCol(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        if (sVArray.length != 1) {
            return false;
        }
        int n2 = sVArray[0].asInt() - 1;
        SV sV = scriptMathProcessor.getX();
        switch (sV.tok) {
            case 11: {
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                M3 m3 = (M3)sV.value;
                switch (n) {
                    case 1276117515: {
                        float[] fArray = new float[3];
                        m3.getRow(n2, fArray);
                        return scriptMathProcessor.addXAF(fArray);
                    }
                }
                float[] fArray = new float[3];
                m3.getColumn(n2, fArray);
                return scriptMathProcessor.addXAF(fArray);
            }
            case 12: {
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                M4 m4 = (M4)sV.value;
                switch (n) {
                    case 1276117515: {
                        float[] fArray = new float[4];
                        m4.getRow(n2, fArray);
                        return scriptMathProcessor.addXAF(fArray);
                    }
                }
                float[] fArray = new float[4];
                m4.getColumn(n2, fArray);
                return scriptMathProcessor.addXAF(fArray);
            }
            case 7: {
                Lst lst = sV.getList();
                Lst lst2 = new Lst();
                int n3 = lst.size();
                for (int i = 0; i < n3; ++i) {
                    Lst lst3 = ((SV)lst.get(i)).getList();
                    if (lst3 == null) {
                        return scriptMathProcessor.addXStr("");
                    }
                    lst2.addLast((Object)(n2 < lst3.size() ? (SV)lst3.get(n2) : SV.newS((String)"")));
                }
                return scriptMathProcessor.addXList(lst2);
            }
        }
        return false;
    }

    private boolean evaluateIn(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        SV sV = scriptMathProcessor.getX();
        switch (sVArray.length) {
            case 1: {
                Lst lst = sVArray[0].getList();
                if (lst == null) break;
                int n = lst.size();
                for (int i = 0; i < n; ++i) {
                    if (!SV.areEqual((SV)sV, (SV)((SV)lst.get(i)))) continue;
                    return scriptMathProcessor.addXInt(i + 1);
                }
                break;
            }
            default: {
                for (int i = 0; i < sVArray.length; ++i) {
                    if (!SV.areEqual((SV)sV, (SV)sVArray[i])) continue;
                    return scriptMathProcessor.addXInt(i + 1);
                }
            }
        }
        return scriptMathProcessor.addXInt(0);
    }

    private boolean evaluateReplace(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        String string;
        String string2;
        boolean bl = false;
        switch (sVArray.length) {
            case 0: {
                bl = true;
                string2 = null;
                string = null;
                break;
            }
            case 3: {
                bl = SV.bValue((T)sVArray[2]);
            }
            case 2: {
                string = SV.sValue((T)sVArray[0]);
                string2 = SV.sValue((T)sVArray[1]);
                break;
            }
            default: {
                return false;
            }
        }
        SV sV = scriptMathProcessor.getX();
        if (sV.tok == 7) {
            String[] stringArray = SV.strListValue((T)sV);
            String[] stringArray2 = new String[stringArray.length];
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray2[n] = string == null ? PT.clean((String)stringArray[n]) : (bl ? PT.replaceAllCharacters((String)stringArray[n], (String)string, (String)string2) : PT.rep((String)stringArray[n], (String)string, (String)string2));
            }
            return scriptMathProcessor.addXAS(stringArray2);
        }
        String string3 = SV.sValue((T)sV);
        return scriptMathProcessor.addXStr(string == null ? PT.clean((String)string3) : (bl ? PT.replaceAllCharacters((String)string3, (String)string, (String)string2) : PT.rep((String)string3, (String)string, (String)string2)));
    }

    private boolean evaluateScript(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        if ((n == 135266829 || n == 135270926 || n == 135287308) && sVArray.length != 1 || sVArray.length == 0 || sVArray.length > 2) {
            return false;
        }
        String string = SV.sValue((T)sVArray[0]);
        SB sB = new SB();
        switch (n) {
            case 135266829: {
                return scriptMathProcessor.addXObj((Object)this.vwr.evaluateExpressionAsVariable((Object)string));
            }
            case 135271429: {
                String string2;
                String string3 = string2 = sVArray.length == 2 ? SV.sValue((T)sVArray[1]) : ".";
                if (!string2.equals(".")) {
                    sB.append(this.vwr.jsEval(string2 + "\u0001" + string));
                }
                if (!string2.equals(".") && !string2.equals("*")) break;
                this.e.runScriptBuffer(string, sB);
                break;
            }
            case 135270926: {
                this.e.runScriptBuffer("show " + string, sB);
                break;
            }
            case 135287308: {
                sB.append(this.vwr.jsEval(string));
            }
        }
        string = sB.toString();
        float f = PT.parseFloatStrict((String)string);
        return Float.isNaN(f) ? scriptMathProcessor.addXStr(string) : (string.indexOf(".") >= 0 ? scriptMathProcessor.addXFloat(f) : scriptMathProcessor.addXInt(PT.parseInt((String)string)));
    }

    private boolean evaluateSort(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        SV sV;
        if (sVArray.length > 1) {
            return false;
        }
        if (n == 1276117011) {
            int n2 = sVArray.length == 0 ? 0 : sVArray[0].asInt();
            return scriptMathProcessor.addX(scriptMathProcessor.getX().sortOrReverse(n2));
        }
        SV sV2 = scriptMathProcessor.getX();
        SV sV3 = sV = sVArray.length == 0 ? null : sVArray[0];
        if (sV2.tok == 4) {
            int n3;
            int n4 = 0;
            String string = SV.sValue((T)sV2);
            if (sV == null) {
                return scriptMathProcessor.addXInt(0);
            }
            String string2 = SV.sValue((T)sV);
            for (int i = 0; i < string.length() && (n3 = string.indexOf(string2, i)) >= 0; ++i) {
                ++n4;
                i = n3;
            }
            return scriptMathProcessor.addXInt(n4);
        }
        Lst lst = new Lst();
        SV sV4 = null;
        SV sV5 = null;
        Lst lst2 = SV.getVariable((Object)sV2.value).sortOrReverse(0).getList();
        if (lst2 == null) {
            return sV == null ? scriptMathProcessor.addXStr("") : scriptMathProcessor.addXInt(0);
        }
        int n5 = lst2.size();
        for (int i = 0; i <= n5; ++i) {
            SV sV6;
            SV sV7 = sV6 = i == n5 ? null : (SV)lst2.get(i);
            if (sV != null && sV6 != null && !SV.areEqual((SV)sV6, (SV)sV)) continue;
            if (SV.areEqual((SV)sV6, sV4)) {
                ++sV5.intValue;
                continue;
            }
            if (sV4 != null) {
                Lst lst3 = new Lst();
                lst3.addLast((Object)sV4);
                lst3.addLast((Object)sV5);
                lst.addLast((Object)SV.getVariableList((Lst)lst3));
            }
            sV5 = SV.newI((int)1);
            sV4 = sV6;
        }
        if (sV == null) {
            return scriptMathProcessor.addX(SV.getVariableList((Lst)lst));
        }
        if (lst.isEmpty()) {
            return scriptMathProcessor.addXInt(0);
        }
        return scriptMathProcessor.addX((SV)((SV)lst.get(0)).getList().get(1));
    }

    private boolean evaluateString(ScriptMathProcessor scriptMathProcessor, int n, SV[] sVArray) throws ScriptException {
        SV sV = scriptMathProcessor.getX();
        String string = sVArray.length > 0 ? SV.sValue((T)sVArray[0]) : (n == 1276117512 ? "" : "\n");
        switch (sVArray.length) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (sV.tok == 7) break;
                if (n == 1276118021) {
                    sV = SV.getVariable((Object)PT.split((String)PT.rep((String)((String)sV.value), (String)"\n\r", (String)"\n").replace('\r', '\n'), (String)"\n"));
                    break;
                }
            }
            default: {
                return false;
            }
        }
        if (sV.tok == 7 && n != 1276117512 && (n != 1276118021 || sVArray.length == 2)) {
            scriptMathProcessor.addX(sV);
            return this.evaluateList(scriptMathProcessor, n, sVArray);
        }
        String string2 = n == 1276118021 && sV.tok == 10 || n == 1276117512 && sV.tok == 7 ? null : SV.sValue((T)sV);
        switch (n) {
            case 1276118021: {
                if (sV.tok == 10) {
                    BS bS = SV.bsSelectVar((SV)sV);
                    string = "\n";
                    int n2 = this.vwr.ms.mc;
                    string2 = "";
                    for (int i = 0; i < n2; ++i) {
                        string2 = string2 + (i == 0 ? "" : "\n");
                        BS bS2 = this.vwr.getModelUndeletedAtomsBitSet(i);
                        bS2.and(bS);
                        string2 = string2 + Escape.eBS((BS)bS2);
                    }
                }
                return scriptMathProcessor.addXAS(PT.split((String)string2, (String)string));
            }
            case 1276118020: {
                if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '\n') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                return scriptMathProcessor.addXStr(PT.rep((String)string2, (String)"\n", (String)string));
            }
            case 1276117512: {
                if (string2 != null) {
                    return scriptMathProcessor.addXStr(PT.trim((String)string2, (String)string));
                }
                String[] stringArray = SV.strListValue((T)sV);
                int n3 = stringArray.length;
                while (--n3 >= 0) {
                    stringArray[n3] = PT.trim((String)stringArray[n3], (String)string);
                }
                return scriptMathProcessor.addXAS(stringArray);
            }
        }
        return scriptMathProcessor.addXStr("");
    }

    private boolean evaluateSubstructure(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        if (sVArray.length == 0) {
            return false;
        }
        BS bS = new BS();
        String string = SV.sValue((T)sVArray[0]);
        if (string.length() > 0) {
            try {
                BS bS2 = sVArray.length == 2 && sVArray[1].tok == 10 ? SV.bsSelectVar((SV)sVArray[1]) : null;
                bS = this.vwr.getSmilesMatcher().getSubstructureSet(string, (Node[])this.vwr.ms.at, this.vwr.ms.ac, bS2, n != 135267336, false);
            }
            catch (Exception exception) {
                this.e.evalError(exception.getMessage(), null);
            }
        }
        return scriptMathProcessor.addXBs(bS);
    }

    private boolean evaluateSymop(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        P3 p3;
        String string;
        SV sV;
        if (sVArray.length == 0) {
            return false;
        }
        SV sV2 = sV = bl ? scriptMathProcessor.getX() : null;
        if (sV != null && sV.tok != 10) {
            return false;
        }
        BS bS = sV != null ? (BS)sV.value : (sVArray.length > 2 && sVArray[1].tok == 10 ? (BS)sVArray[1].value : this.vwr.getAllAtoms());
        switch (sVArray[0].tok) {
            case 4: {
                string = SV.sValue((T)sVArray[0]);
                break;
            }
            case 12: {
                string = sVArray[0].escape();
                break;
            }
            default: {
                string = null;
            }
        }
        int n = string == null ? sVArray[0].asInt() : 0;
        P3 p32 = p3 = sVArray.length > 1 ? scriptMathProcessor.ptValue(sVArray[1], true) : null;
        if (sVArray.length == 2 && !Float.isNaN(p3.x)) {
            return scriptMathProcessor.addXObj(this.vwr.ms.getSymTemp(false).getSymmetryInfoAtom(this.vwr.ms, bS, string, n, p3, null, null, 0x8100010));
        }
        String string2 = (sVArray.length == 1 ? "" : SV.sValue((T)sVArray[sVArray.length - 1])).toLowerCase();
        int n2 = 135176;
        if (sVArray.length == 1 || string2.equalsIgnoreCase("matrix")) {
            n2 = 12;
        } else if (string2.equalsIgnoreCase("array") || string2.equalsIgnoreCase("list")) {
            n2 = 1073742001;
        } else if (string2.equalsIgnoreCase("description")) {
            n2 = 1826248716;
        } else if (string2.equalsIgnoreCase("xyz")) {
            n2 = 1073741982;
        } else if (string2.equalsIgnoreCase("translation")) {
            n2 = 1073742178;
        } else if (string2.equalsIgnoreCase("axis")) {
            n2 = 1073741854;
        } else if (string2.equalsIgnoreCase("plane")) {
            n2 = 135266319;
        } else if (string2.equalsIgnoreCase("angle")) {
            n2 = 0x8100001;
        } else if (string2.equalsIgnoreCase("axispoint")) {
            n2 = 0x8100010;
        } else if (string2.equalsIgnoreCase("center")) {
            n2 = 12289;
        }
        return scriptMathProcessor.addXObj(this.vwr.ms.getSymTemp(false).getSymmetryInfoAtom(this.vwr.ms, bS, string, n, p3, null, string2, n2));
    }

    private boolean evaluateTensor(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        if (sVArray.length > 2) {
            return false;
        }
        BS bS = SV.getBitSet((SV)scriptMathProcessor.getX(), (boolean)false);
        String string = sVArray.length == 0 ? null : SV.sValue((T)sVArray[0]).toLowerCase();
        JmolNMRInterface jmolNMRInterface = this.vwr.getNMRCalculation();
        if ("unique".equals(string)) {
            return scriptMathProcessor.addXBs(jmolNMRInterface.getUniqueTensorSet(bS));
        }
        String string2 = sVArray.length < 2 ? null : SV.sValue((T)sVArray[1]).toLowerCase();
        return scriptMathProcessor.addXList(jmolNMRInterface.getTensorInfo(string, string2, bS));
    }

    private boolean evaluateUserFunction(ScriptMathProcessor scriptMathProcessor, String string, SV[] sVArray, int n, boolean bl) throws ScriptException {
        SV sV = null;
        if (bl) {
            sV = scriptMathProcessor.getX();
            if (sV.tok != 10) {
                return false;
            }
        }
        scriptMathProcessor.wasX = false;
        Lst lst = new Lst();
        for (int i = 0; i < sVArray.length; ++i) {
            lst.addLast((Object)sVArray[i]);
        }
        if (bl) {
            return scriptMathProcessor.addXObj(this.e.getBitsetProperty(SV.bsSelectVar((SV)sV), n, null, null, sV.value, (Object)new Object[]{string, lst}, false, sV.index, false));
        }
        SV sV2 = this.e.getUserFunctionResult(string, lst, null);
        return sV2 == null ? false : scriptMathProcessor.addX(sV2);
    }

    private boolean evaluateWithin(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        BS bS;
        String string;
        boolean bl;
        if (sVArray.length < 1 || sVArray.length > 5) {
            return false;
        }
        int n = sVArray.length;
        float f = 0.0f;
        Object object = sVArray[0].value;
        String string2 = "" + object;
        int n2 = sVArray[0].tok;
        if (n2 == 4) {
            n2 = T.getTokFromName((String)string2);
        }
        boolean bl2 = bl = n2 == 1649412120;
        if (bl) {
            f = 100.0f;
            object = null;
        }
        ModelSet modelSet = this.vwr.ms;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl || n2 == 3 || n2 == 2;
        RadiusData radiusData = null;
        switch (n2) {
            case 0x100004: {
                return n == 3 && sVArray[1].value instanceof BS && sVArray[2].value instanceof BS && scriptMathProcessor.addXBs(this.vwr.getBranchBitSet(((BS)sVArray[2].value).nextSetBit(0), ((BS)sVArray[1].value).nextSetBit(0), true));
            }
            case 135267335: 
            case 135267336: 
            case 1238369286: {
                BS bS2 = null;
                boolean bl6 = true;
                switch (n) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        boolean bl7 = bl6 = sVArray[2].tok == 10;
                        if (!bl6) break;
                        bS2 = (BS)sVArray[2].value;
                        break;
                    }
                    default: {
                        bl6 = false;
                    }
                }
                if (!bl6) {
                    this.e.invArg();
                }
                return scriptMathProcessor.addXObj(this.e.getSmilesExt().getSmilesMatches(SV.sValue((T)sVArray[1]), null, bS2, null, n2 == 135267335, scriptMathProcessor.asBitSet));
            }
        }
        if (object instanceof String) {
            if (n2 == 0) {
                n2 = 1048614;
                if (n > 2) {
                    return false;
                }
                n = 2;
            }
        } else if (bl5) {
            if (!bl) {
                f = SV.fValue((T)sVArray[0]);
            }
            if (n < 2) {
                return false;
            }
            n2 = sVArray[1].tok;
            switch (n2) {
                case 0x10000C: 
                case 0x10000D: {
                    bl3 = sVArray[1].asBoolean();
                    n = 0;
                    break;
                }
                case 4: {
                    string = SV.sValue((T)sVArray[1]);
                    if (string.startsWith("$")) {
                        return scriptMathProcessor.addXBs(this.getAtomsNearSurface(f, string.substring(1)));
                    }
                    bl4 = string.equalsIgnoreCase("group");
                    bl = string.equalsIgnoreCase("vanderwaals");
                    if (bl) {
                        object = null;
                        n2 = 1649412120;
                        break;
                    }
                    n2 = 1087373318;
                }
            }
        } else {
            return false;
        }
        string = null;
        P4 p4 = null;
        block12 : switch (n) {
            case 1: {
                switch (n2) {
                    case 0x300020: 
                    case 137363467: 
                    case 1679429641: {
                        return scriptMathProcessor.addXBs(modelSet.getAtoms(n2, null));
                    }
                    case 1073741864: {
                        return scriptMathProcessor.addXBs(modelSet.getAtoms(n2, (Object)""));
                    }
                    case 1048614: {
                        return scriptMathProcessor.addXBs(modelSet.getAtoms(1087373320, (Object)string2));
                    }
                }
                return false;
            }
            case 2: {
                switch (n2) {
                    case 1048614: {
                        n2 = 1087373320;
                        break block12;
                    }
                    case 1073741864: 
                    case 1073741916: 
                    case 1073741925: 
                    case 1073742128: 
                    case 1073742189: 
                    case 1087373320: 
                    case 1087375361: 
                    case 1087375362: {
                        return scriptMathProcessor.addXBs(this.vwr.ms.getAtoms(n2, (Object)SV.sValue((T)sVArray[sVArray.length - 1])));
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 0x100005: 
                    case 0x10000C: 
                    case 0x10000D: 
                    case 135266319: 
                    case 135267841: 
                    case 1087373318: 
                    case 1649412120: {
                        break block12;
                    }
                    case 1087373320: {
                        string2 = SV.sValue((T)sVArray[2]);
                        break block12;
                    }
                }
                return false;
            }
        }
        n = sVArray.length - 1;
        if (sVArray[n].value instanceof P4) {
            p4 = (P4)sVArray[n].value;
        } else if (sVArray[n].value instanceof P3) {
            string = (P3)sVArray[n].value;
            if (SV.sValue((T)sVArray[1]).equalsIgnoreCase("hkl")) {
                p4 = this.e.getHklPlane((P3)string);
            }
        }
        if (n > 0 && p4 == null && string == null && !(sVArray[n].value instanceof BS)) {
            return false;
        }
        if (p4 != null) {
            return scriptMathProcessor.addXBs(modelSet.getAtomsNearPlane(f, p4));
        }
        if (string != null) {
            return scriptMathProcessor.addXBs(this.vwr.getAtomsNearPt(f, (P3)string));
        }
        BS bS3 = bS = sVArray[n].tok == 10 ? SV.bsSelectVar((SV)sVArray[n]) : null;
        if (n2 == 1087373320) {
            return scriptMathProcessor.addXBs(this.vwr.ms.getSequenceBits(string2, bS));
        }
        if (bS == null) {
            bS = new BS();
        }
        if (!bl5) {
            return scriptMathProcessor.addXBs(this.vwr.ms.getAtoms(n2, (Object)bS));
        }
        if (bl4) {
            return scriptMathProcessor.addXBs(this.vwr.getGroupsWithin((int)f, bS));
        }
        if (bl) {
            radiusData = new RadiusData(null, f > 10.0f ? f / 100.0f : f, f > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, VDW.AUTO);
        }
        return scriptMathProcessor.addXBs(this.vwr.ms.getAtomsWithinRadius(f, bS, bl3, radiusData));
    }

    private boolean evaluateWrite(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        switch (sVArray.length) {
            case 0: {
                return false;
            }
            case 1: {
                if (!sVArray[0].asString().toUpperCase().equals("PNGJ")) break;
                return scriptMathProcessor.addXMap(this.vwr.fm.getFileAsMap(null));
            }
        }
        return scriptMathProcessor.addXStr(this.e.getCmdExt().dispatch(135270422, true, (T[])sVArray));
    }

    private BS getAtomsNearSurface(float f, String string) {
        Object[] objectArray = new Object[]{string, null, null};
        if (this.e.getShapePropertyData(24, "getVertices", objectArray)) {
            return this.vwr.ms.getAtomsNearPts(f, (P3[])objectArray[1], (BS)objectArray[2]);
        }
        objectArray[1] = 0;
        objectArray[2] = -1;
        if (this.e.getShapePropertyData(22, "getCenter", objectArray)) {
            return this.vwr.getAtomsNearPt(f, (P3)objectArray[2]);
        }
        return new BS();
    }

    private float getDistance(ScriptMathProcessor scriptMathProcessor, SV sV, SV sV2, int n) throws ScriptException {
        P3 p3 = scriptMathProcessor.ptValue(sV, true);
        P4 p4 = scriptMathProcessor.planeValue((T)sV);
        P3 p32 = scriptMathProcessor.ptValue(sV2, true);
        P4 p42 = scriptMathProcessor.planeValue((T)sV2);
        if (n == 1276117505) {
            if (p4 != null && p42 != null) {
                return p4.x * p42.x + p4.y * p42.y + p4.z * p42.z + p4.w * p42.w;
            }
            if (p4 != null) {
                p3 = P3.new3((float)p4.x, (float)p4.y, (float)p4.z);
            }
            if (p42 != null) {
                p32 = P3.new3((float)p42.x, (float)p42.y, (float)p42.z);
            }
            return p3.x * p32.x + p3.y * p32.y + p3.z * p32.z;
        }
        if (p4 == null) {
            return p42 == null ? p32.distance((T3)p3) : Measure.distanceToPlane((P4)p42, (T3)p3);
        }
        return Measure.distanceToPlane((P4)p4, (T3)p32);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMinMax(Object object, int n) {
        double d;
        float[] fArray = null;
        Lst lst = null;
        int n2 = 0;
        if (PT.isAF((Object)object)) {
            fArray = (float[])object;
            n2 = fArray.length;
            if (n2 == 0) {
                return "NaN";
            }
        } else {
            if (!(object instanceof Lst) || (n2 = (lst = (Lst)object).size()) == 0) return "NaN";
            SV sV = (SV)lst.get(0);
            if (sV.tok == 4 && ((String)sV.value).startsWith("{")) {
                P3 p3 = SV.ptValue((SV)sV);
                if (p3 instanceof P3) {
                    return this.getMinMaxPoint(lst, n);
                }
                if (!(p3 instanceof P4)) return "NaN";
                return this.getMinMaxQuaternion((Lst<SV>)lst, n);
            }
        }
        switch (n) {
            case 32: {
                d = 3.4028234663852886E38;
                break;
            }
            case 64: {
                d = -3.4028234663852886E38;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        double d2 = 0.0;
        int n3 = 0;
        int n4 = n2;
        while (--n4 >= 0) {
            float f;
            float f2 = f = fArray == null ? SV.fValue((T)((T)lst.get(n4))) : fArray[n4];
            if (Float.isNaN(f)) continue;
            ++n3;
            switch (n) {
                case 160: 
                case 192: {
                    d2 += (double)f * (double)f;
                }
                case 96: 
                case 128: {
                    d += (double)f;
                    break;
                }
                case 32: {
                    if (!((double)f < d)) break;
                    d = f;
                    break;
                }
                case 64: {
                    if (!((double)f > d)) break;
                    d = f;
                }
            }
        }
        if (n3 == 0) return "NaN";
        switch (n) {
            case 96: {
                d /= (double)n3;
                return Float.valueOf((float)d);
            }
            case 192: {
                if (n3 == 1) return Float.valueOf((float)d);
                d = Math.sqrt((d2 - d * d / (double)n3) / (double)(n3 - 1));
                return Float.valueOf((float)d);
            }
            case 32: 
            case 64: 
            case 128: {
                return Float.valueOf((float)d);
            }
            case 160: {
                d = d2;
            }
        }
        return Float.valueOf((float)d);
    }

    private Object getMinMaxPoint(Object object, int n) {
        P3[] p3Array = null;
        Lst lst = null;
        int n2 = 0;
        if (object instanceof Quat[]) {
            p3Array = (P3[])object;
            n2 = p3Array.length;
        } else if (object instanceof Lst) {
            lst = (Lst)object;
            n2 = lst.size();
        }
        if (lst != null || p3Array != null) {
            P3 p3 = new P3();
            float[] fArray = new float[n2];
            boolean bl = true;
            block10: for (int i = 0; i < 3 && bl; ++i) {
                Object object2;
                block11: for (int j = 0; j < n2; ++j) {
                    P3 p32;
                    P3 p33 = p32 = p3Array == null ? SV.ptValue((SV)((SV)lst.get(j))) : p3Array[j];
                    if (p32 == null) {
                        bl = false;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            fArray[j] = p32.x;
                            continue block11;
                        }
                        case 1: {
                            fArray[j] = p32.y;
                            continue block11;
                        }
                        case 2: {
                            fArray[j] = p32.z;
                        }
                    }
                }
                if (!bl || !((object2 = this.getMinMax(fArray, n)) instanceof Float)) break;
                float f = ((Float)object2).floatValue();
                switch (i) {
                    case 0: {
                        p3.x = f;
                        continue block10;
                    }
                    case 1: {
                        p3.y = f;
                        continue block10;
                    }
                    case 2: {
                        p3.z = f;
                    }
                }
            }
            return p3;
        }
        return "NaN";
    }

    private Object getMinMaxQuaternion(Lst<SV> lst, int n) {
        block7: {
            switch (n) {
                case 32: 
                case 64: 
                case 128: 
                case 160: {
                    return "NaN";
                }
            }
            Quat[] quatArray = this.e.getQuaternionArray(lst, 1073742001);
            if (quatArray == null) break block7;
            float[] fArray = new float[1];
            Quat quat = Quat.sphereMean((Quat[])quatArray, (float[])fArray, (float)1.0E-4f);
            switch (n) {
                case 96: {
                    return quat;
                }
                case 192: {
                    return Float.valueOf(fArray[0]);
                }
            }
        }
        return "NaN";
    }

    private JmolPatternMatcher getPatternMatcher() {
        return this.pm == null ? (this.pm = (JmolPatternMatcher)Interface.getUtil((String)"PatternMatcher", (Viewer)this.e.vwr, (String)"script")) : this.pm;
    }

    private T opTokenFor(int n) {
        switch (n) {
            case 1276118017: 
            case 1276118020: {
                return T.tokenPlus;
            }
            case 1276117511: {
                return T.tokenMinus;
            }
            case 1276117507: {
                return T.tokenTimes;
            }
            case 1276117508: {
                return T.tokenMul3;
            }
            case 1276117504: {
                return T.tokenDivide;
            }
        }
        return null;
    }

    public BS setContactBitSets(BS bS, BS bS2, boolean bl, float f, RadiusData radiusData, boolean bl2) {
        int n;
        BS bS3;
        boolean bl3;
        if (bS2 == null) {
            bS2 = BSUtil.setAll((int)this.vwr.ms.ac);
            BSUtil.andNot((BS)bS2, (BS)this.vwr.slm.bsDeleted);
            bS2.andNot(bS);
            bl3 = false;
        } else {
            bS3 = BSUtil.copy((BS)bS);
            bS3.or(bS2);
            n = this.vwr.ms.getModelBS(bS3, false).cardinality();
            boolean bl4 = bl3 = n > 1;
            if (bl2 && n > 1 && !this.e.tQuiet) {
                this.e.showString(GT._((String)"Note: More than one model is involved in this contact!"));
            }
        }
        if (!bS.equals((Object)bS2)) {
            int n2 = n = !bl || bS.cardinality() < bS2.cardinality() ? 1 : 0;
            if (n != 0) {
                bS3 = this.vwr.ms.getAtomsWithinRadius(f, bS, bl3, (RadiusData)(Float.isNaN(f) ? radiusData : null));
                bS2.and(bS3);
            }
            if (bl) {
                bS3 = this.vwr.ms.getAtomsWithinRadius(f, bS2, bl3, (RadiusData)(Float.isNaN(f) ? radiusData : null));
                bS.and(bS3);
                if (n == 0) {
                    bS3 = this.vwr.ms.getAtomsWithinRadius(f, bS, bl3, (RadiusData)(Float.isNaN(f) ? radiusData : null));
                    bS2.and(bS3);
                }
                bS3 = BSUtil.copy((BS)bS2);
                bS3.and(bS);
                if (bS3.equals((Object)bS)) {
                    bS2.andNot(bS);
                } else if (bS3.equals((Object)bS2)) {
                    bS.andNot(bS2);
                }
            }
        }
        return bS2;
    }
}

