/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Dipole;
import org.jmol.shapespecial.Dipoles;
import org.jmol.util.C;

public class DipolesRenderer
extends ShapeRenderer {
    private float dipoleVectorScale;
    private final V3 offset = new V3();
    private final P3i[] screens = new P3i[6];
    private final P3[] points = new P3[6];
    private P3 cross0;
    private P3 cross1;
    private static final int cylinderBase = 0;
    private static final int cross = 1;
    private static final int crossEnd = 2;
    private static final int center = 3;
    private static final int arrowHeadBase = 4;
    private static final int arrowHeadTip = 5;
    private int diameter;
    private int headWidthPixels;
    private int crossWidthPixels;
    private float offsetSide;
    private short colixA;
    private short colixB;
    private boolean noCross;
    private static final float arrowHeadOffset = 0.9f;
    private static final float arrowHeadWidthFactor = 2.0f;
    private static final float crossOffset = 0.1f;
    private static final float crossWidth = 0.04f;

    public DipolesRenderer() {
        for (int i = 0; i < 6; ++i) {
            this.screens[i] = new P3i();
            this.points[i] = new P3();
        }
        this.cross0 = new P3();
        this.cross1 = new P3();
    }

    protected boolean render() {
        Dipoles dipoles = (Dipoles)this.shape;
        this.dipoleVectorScale = this.vwr.getFloat(0x2200000B);
        boolean bl = false;
        BS bS = this.vwr.ms.getVisibleSet(false);
        int n = dipoles.dipoleCount;
        while (--n >= 0) {
            Dipole dipole = dipoles.dipoles[n];
            if (dipole.visibilityFlags == 0 || dipole.atoms[0] != null && this.ms.isAtomHidden(dipole.atoms[0].i) || dipole.bsMolecule != null && !dipole.bsMolecule.intersects(bS) || !this.renderDipoleVector(dipole, bS)) continue;
            bl = true;
        }
        return bl;
    }

    private boolean renderDipoleVector(Dipole dipole, BS bS) {
        this.mad = dipole.mad;
        this.offsetSide = dipole.offsetSide;
        this.noCross = dipole.noCross;
        this.colixB = this.colixA = dipole.bond == null ? dipole.colix : C.getColixInherited((short)dipole.colix, (short)dipole.bond.colix);
        if (dipole.atoms[0] != null) {
            this.colixA = C.getColixInherited((short)this.colixA, (short)dipole.atoms[0].colixAtom);
            this.colixB = C.getColixInherited((short)this.colixB, (short)dipole.atoms[1].colixAtom);
        }
        if (this.colixA == 0) {
            this.colixA = (short)5;
        }
        if (this.colixB == 0) {
            this.colixB = (short)5;
        }
        if (this.dipoleVectorScale < 0.0f) {
            short s = this.colixA;
            this.colixA = this.colixB;
            this.colixB = s;
        }
        float f = dipole.offsetAngstroms / dipole.dipoleValue;
        if (dipole.lstDipoles == null) {
            return this.renderVector(dipole.vector, dipole.origin, dipole.center, f, false);
        }
        boolean bl = false;
        int n = dipole.lstDipoles.size();
        while (--n >= 0) {
            Object[] objectArray = (Object[])dipole.lstDipoles.get(n);
            V3 v3 = (V3)objectArray[0];
            P3 p3 = (P3)objectArray[1];
            BS bS2 = (BS)objectArray[2];
            if (!bS2.intersects(bS)) continue;
            bl = this.renderVector(v3, p3, null, dipole.offsetAngstroms, true);
        }
        return bl;
    }

    private boolean renderVector(V3 v3, P3 p3, P3 p32, float f, boolean bl) {
        int n;
        this.offset.setT((T3)v3);
        if (p32 == null) {
            if (bl) {
                this.offset.normalize();
                this.offset.scale(f);
            } else {
                this.offset.scale(f);
                if (this.dipoleVectorScale < 0.0f) {
                    this.offset.add((T3)v3);
                }
            }
            this.points[0].add2((T3)p3, (T3)this.offset);
        } else {
            this.offset.scale(-0.5f * this.dipoleVectorScale);
            this.points[0].add2((T3)p32, (T3)this.offset);
            if (f != 0.0f) {
                this.offset.setT((T3)v3);
                this.offset.scale(f);
                this.points[0].add((T3)this.offset);
            }
        }
        this.points[1].scaleAdd2(this.dipoleVectorScale * 0.1f, (T3)v3, (T3)this.points[0]);
        this.points[2].scaleAdd2(this.dipoleVectorScale * 0.14f, (T3)v3, (T3)this.points[0]);
        this.points[3].scaleAdd2(this.dipoleVectorScale / 2.0f, (T3)v3, (T3)this.points[0]);
        this.points[4].scaleAdd2(this.dipoleVectorScale * 0.9f, (T3)v3, (T3)this.points[0]);
        this.points[5].scaleAdd2(this.dipoleVectorScale, (T3)v3, (T3)this.points[0]);
        this.offset.setT((T3)this.points[3]);
        this.offset.cross((T3)this.offset, (T3)v3);
        if (this.offset.length() == 0.0f) {
            this.offset.set(this.points[3].x + 0.2345f, this.points[3].y + 0.1234f, this.points[3].z + 0.4321f);
            this.offset.cross((T3)this.offset, (T3)v3);
        }
        this.offset.scale(this.offsetSide / this.offset.length());
        for (n = 0; n < 6; ++n) {
            this.points[n].add((T3)this.offset);
        }
        for (n = 0; n < 6; ++n) {
            this.tm.transformPtScr((T3)this.points[n], this.screens[n]);
        }
        this.tm.transformPt3f((T3)this.points[1], this.cross0);
        this.tm.transformPt3f((T3)this.points[2], this.cross1);
        float f2 = this.vwr.tm.scaleToScreen(this.screens[3].z, (int)this.mad);
        this.diameter = (int)f2;
        this.headWidthPixels = (int)Math.floor(f2 * 2.0f);
        if (this.headWidthPixels < this.diameter + 5) {
            this.headWidthPixels = this.diameter + 5;
        }
        this.crossWidthPixels = this.headWidthPixels;
        this.colix = this.colixA;
        if (this.colix == this.colixB) {
            if (!this.g3d.setC(this.colix)) {
                return true;
            }
            this.g3d.fillCylinder((byte)1, this.diameter, this.screens[0], this.screens[4]);
            if (!this.noCross) {
                this.g3d.fillCylinderBits((byte)2, this.crossWidthPixels, this.cross0, this.cross1);
            }
            this.g3d.fillConeScreen((byte)2, this.headWidthPixels, this.screens[4], this.screens[5], false);
            return false;
        }
        boolean bl2 = false;
        if (this.g3d.setC(this.colix)) {
            this.g3d.fillCylinder((byte)1, this.diameter, this.screens[0], this.screens[3]);
            if (!this.noCross) {
                this.g3d.fillCylinderBits((byte)2, this.crossWidthPixels, this.cross0, this.cross1);
            }
        } else {
            bl2 = true;
        }
        this.colix = this.colixB;
        if (this.g3d.setC(this.colix)) {
            this.g3d.fillCylinder((byte)4, this.diameter, this.screens[3], this.screens[4]);
            this.g3d.fillConeScreen((byte)2, this.headWidthPixels, this.screens[4], this.screens[5], false);
        } else {
            bl2 = true;
        }
        return bl2;
    }
}

