/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelCollection;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Measure;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSet
extends ModelCollection {
    private boolean selectionHaloEnabled = false;
    private boolean echoShapeActive = false;
    protected String modelSetTypeName;
    protected final Atom[] closest = new Atom[1];
    private SymmetryInterface pointGroup;
    private final Matrix3f matTemp = new Matrix3f();
    private final Matrix3f matInv = new Matrix3f();
    private final Matrix4f mat4 = new Matrix4f();
    private final Matrix4f mat4t = new Matrix4f();
    private final Vector3f vTemp = new Vector3f();

    public ModelSet(Viewer viewer, String string) {
        this.viewer = viewer;
        this.modelSetName = string;
    }

    @Override
    protected void releaseModelSet() {
        this.models = null;
        this.closest[0] = null;
        super.releaseModelSet();
    }

    public void setSelectionHaloEnabled(boolean bl) {
        this.selectionHaloEnabled = bl;
    }

    public boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    public boolean getEchoStateActive() {
        return this.echoShapeActive;
    }

    public void setEchoStateActive(boolean bl) {
        this.echoShapeActive = bl;
    }

    public String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    public int getModelNumberIndex(int n, boolean bl, boolean bl2) {
        if (bl) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (this.modelNumbers[i] != n && (n >= 1000000 || this.modelNumbers[i] != 1000000 + n)) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.modelFileNumbers[i] != n) continue;
            if (bl2 && this.isTrajectory(i)) {
                this.setTrajectory(i);
            }
            return i;
        }
        return -1;
    }

    public String getTrajectoryInfo() {
        String string = "";
        if (this.trajectorySteps == null) {
            return "";
        }
        int n = this.modelCount;
        while (--n >= 0) {
            if (this.models[n].selectedTrajectory < 0) continue;
            string = " or " + this.getModelNumberDotted(this.models[n].selectedTrajectory) + string;
            n = this.models[n].trajectoryBaseIndex;
        }
        if (string.length() > 0) {
            string = "set trajectory {" + string.substring(4) + "}";
        }
        return string;
    }

    public BitSet getBitSetTrajectories() {
        if (this.trajectorySteps == null) {
            return null;
        }
        BitSet bitSet = new BitSet();
        int n = this.modelCount;
        while (--n >= 0) {
            if (this.models[n].selectedTrajectory < 0) continue;
            bitSet.set(this.models[n].selectedTrajectory);
            n = this.models[n].trajectoryBaseIndex;
        }
        return bitSet;
    }

    public void setTrajectory(BitSet bitSet) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bitSet.get(i)) continue;
            this.setTrajectory(i);
        }
    }

    public void setTrajectory(int n) {
        if (n < 0 || !this.isTrajectory(n)) {
            return;
        }
        if (this.atoms[this.models[n].firstAtomIndex].modelIndex == n) {
            return;
        }
        int n2 = this.models[n].trajectoryBaseIndex;
        this.models[n2].selectedTrajectory = n;
        this.setAtomPositions(n2, n, (Point3f[])this.trajectorySteps.get(n), this.vibrationSteps == null ? null : (Vector3f[])this.vibrationSteps.get(n), true);
        int n3 = this.viewer.getCurrentModelIndex();
        if (n3 >= 0 && n3 != n && this.models[n3].fileIndex == this.models[n].fileIndex) {
            this.viewer.setCurrentModelIndex(n, false);
        }
    }

    private void setAtomPositions(int n, int n2, Point3f[] point3fArray, Vector3f[] vector3fArray, boolean bl) {
        BitSet bitSet = new BitSet();
        Vector3f vector3f = new Vector3f();
        int n3 = this.models[n].firstAtomIndex;
        int n4 = n3 + this.getAtomCountInModel(n);
        int n5 = 0;
        for (int i = n3; i < n4 && n5 < point3fArray.length && point3fArray[n5] != null; ++i, ++n5) {
            if (bl) {
                this.atoms[i].setFractionalCoord(point3fArray[n5], true);
            } else {
                this.atoms[i].set(point3fArray[n5]);
            }
            this.atoms[i].modelIndex = (short)n2;
            if (this.vibrationSteps != null) {
                if (vector3fArray != null && vector3fArray[n5] != null) {
                    vector3f = vector3fArray[n5];
                }
                this.setVibrationVector(i, vector3f.x, vector3f.y, vector3f.z);
            }
            bitSet.set(i);
        }
        this.initializeBspf();
        this.validateBspf(n, false);
        this.recalculateLeadMidpointsAndWingVectors(n);
        this.shapeManager.refreshShapeTrajectories(n, bitSet, null);
        if (this.models[n].hasRasmolHBonds) {
            this.models[n].clearRasmolHydrogenBonds(null);
            this.models[n].getRasmolHydrogenBonds(bitSet, bitSet, null, false, Integer.MAX_VALUE, false, null);
        }
    }

    public Point3f[] getFrameOffsets(BitSet bitSet) {
        int n;
        if (bitSet == null) {
            return null;
        }
        Point3f[] point3fArray = new Point3f[this.modelCount];
        for (n = 0; n < this.modelCount; ++n) {
            point3fArray[n] = new Point3f();
        }
        n = 0;
        int n2 = 0;
        Point3f point3f = point3fArray[0];
        boolean bl = this.trajectorySteps != null && this.trajectorySteps.size() == this.modelCount;
        int n3 = bl ? this.modelCount : 1;
        block1: for (int i = 0; i < n3; ++i) {
            if (bl) {
                this.setTrajectory(i);
            }
            for (int j = 0; j <= this.atomCount; ++j) {
                if (j == this.atomCount || this.atoms[j].modelIndex != n) {
                    if (n2 > 0) {
                        point3f.scale(-1.0f / (float)n2);
                        if (n != 0) {
                            point3f.sub(point3fArray[0]);
                        }
                        n2 = 0;
                    }
                    if (j == this.atomCount) continue block1;
                    n = this.atoms[j].modelIndex;
                    point3f = point3fArray[n];
                }
                if (!bitSet.get(j)) continue;
                point3f.add(this.atoms[j]);
                ++n2;
            }
        }
        point3fArray[0].set(0.0f, 0.0f, 0.0f);
        return point3fArray;
    }

    @Override
    public BitSet getAtomBits(int n, Object object) {
        switch (n) {
            case 0x100022: {
                int n2 = (Integer)object;
                int n3 = this.getModelNumberIndex(n2, true, true);
                return n3 < 0 && n2 > 0 ? new BitSet() : this.viewer.getModelUndeletedAtomsBitSet(n3);
            }
        }
        return super.getAtomBits(n, object);
    }

    public String getAtomLabel(int n) {
        return (String)this.viewer.getShapeProperty(5, "label", n);
    }

    public int findNearestAtomIndex(int n, int n2, BitSet bitSet) {
        if (this.atomCount == 0) {
            return -1;
        }
        this.closest[0] = null;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        this.findNearestAtomIndex(n, n2, this.closest, bitSet);
        this.shapeManager.findNearestShapeAtomIndex(n, n2, this.closest, bitSet);
        int n3 = this.closest[0] == null ? -1 : this.closest[0].index;
        this.closest[0] = null;
        return n3;
    }

    public String calculateStructures(BitSet bitSet, boolean bl, boolean bl2, boolean bl3) {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = BitSetUtil.copyInvert(this.modelsOf(bitSet, bitSet2), this.modelCount);
        if (!bl3) {
            return this.calculateStructuresAllExcept(bitSet3, bl, true, bl2, false, false);
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (bitSet3.get(i)) continue;
            this.models[i].clearBioPolymers();
        }
        this.calculatePolymers(null, 0, 0, bitSet3);
        String string = this.calculateStructuresAllExcept(bitSet3, bl, true, bl2, true, false);
        this.viewer.resetBioshapes(bitSet2);
        this.setStructureIds();
        return string;
    }

    public String calculatePointGroup(BitSet bitSet) {
        return (String)this.calculatePointGroupForFirstModel(bitSet, false, false, false, null, 0, 0.0f);
    }

    public Map<String, Object> getPointGroupInfo(BitSet bitSet) {
        return (Map)this.calculatePointGroupForFirstModel(bitSet, false, false, true, null, 0, 0.0f);
    }

    public String getPointGroupAsString(BitSet bitSet, boolean bl, String string, int n, float f) {
        return (String)this.calculatePointGroupForFirstModel(bitSet, true, bl, false, string, n, f);
    }

    private Object calculatePointGroupForFirstModel(BitSet bitSet, boolean bl, boolean bl2, boolean bl3, String string, int n, float f) {
        Object object;
        int n2;
        int n3 = this.viewer.getCurrentModelIndex();
        int n4 = n2 = bitSet == null ? -1 : bitSet.nextSetBit(0);
        if (n3 < 0 && n2 >= 0) {
            n3 = this.atoms[n2].getModelIndex();
        }
        if (n3 < 0) {
            n3 = this.viewer.getVisibleFramesBitSet().nextSetBit(0);
            bitSet = null;
        }
        BitSet bitSet2 = this.viewer.getModelUndeletedAtomsBitSet(n3);
        if (bitSet != null) {
            bitSet2.and(bitSet);
        }
        if ((n2 = bitSet2.nextSetBit(0)) < 0) {
            bitSet2 = this.viewer.getModelUndeletedAtomsBitSet(n3);
            n2 = bitSet2.nextSetBit(0);
        }
        boolean bl4 = (object = this.viewer.getShapeProperty(18, "mad", n2)) != null && (Integer)object != 0 || this.viewer.isVibrationOn();
        SymmetryInterface symmetryInterface = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        this.pointGroup = symmetryInterface.setPointGroup(this.pointGroup, this.atoms, bitSet2, bl4, this.viewer.getPointGroupTolerance(0), this.viewer.getPointGroupTolerance(1));
        if (!bl && !bl3) {
            return this.pointGroup.getPointGroupName();
        }
        Object object2 = this.pointGroup.getPointGroupInfo(n3, bl2, bl3, string, n, f);
        if (bl3) {
            return object2;
        }
        return (this.modelCount > 1 ? "frame " + this.getModelNumberDotted(n3) + "; " : "") + object2;
    }

    private BitSet modelsOf(BitSet bitSet, BitSet bitSet2) {
        int n;
        BitSet bitSet3 = new BitSet(this.modelCount);
        boolean bl = bitSet == null;
        int n2 = n = bl ? this.atomCount - 1 : bitSet.nextSetBit(0);
        while (n2 >= 0) {
            int n3 = this.models[this.atoms[n2].modelIndex].trajectoryBaseIndex;
            if (!this.isJmolDataFrame(n3)) {
                bitSet3.set(n3);
                bitSet2.set(n2);
            }
            n2 = bl ? n2 - 1 : bitSet.nextSetBit(n2 + 1);
        }
        return bitSet3;
    }

    public String getDefaultStructure(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = this.modelsOf(bitSet, bitSet2);
        StringBuffer stringBuffer = new StringBuffer();
        int n = bitSet3.nextSetBit(0);
        while (n >= 0) {
            if (this.models[n].isBioModel && this.models[n].defaultStructure != null) {
                stringBuffer.append(this.models[n].defaultStructure);
            }
            n = bitSet3.nextSetBit(n + 1);
        }
        return stringBuffer.toString();
    }

    protected void assignAromaticBonds(boolean bl) {
        super.assignAromaticBonds(bl, null);
        if (bl) {
            this.shapeManager.setShapeSize(1, Integer.MIN_VALUE, null, this.bsAromatic);
        }
    }

    @Override
    public int[] makeConnections(float f, float f2, int n, int n2, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, boolean bl2, float f3) {
        if (n2 == 1073741852 && n != 2048) {
            String string = "connect ";
            if (f != 0.1f) {
                string = string + f + " ";
            }
            if (f2 != 1.0E8f) {
                string = string + f2 + " ";
            }
            this.addStateScript(string, bl ? bitSet : null, bl ? null : bitSet, bl ? null : bitSet2, " auto", false, true);
        }
        this.moleculeCount = 0;
        return super.makeConnections(f, f2, n, n2, bitSet, bitSet2, bitSet3, bl, bl2, f3);
    }

    public void setPdbConectBonding(int n, int n2, BitSet bitSet) {
        short s = this.viewer.getMadBond();
        for (int i = n2; i < this.modelCount; ++i) {
            int n3;
            List list = (List)this.getModelAuxiliaryInfo(i, "PDB_CONECT_bonds");
            if (list == null) continue;
            int n4 = list.size();
            this.setModelAuxiliaryInfo(i, "initialBondCount", n4);
            int[] nArray = (int[])this.getModelAuxiliaryInfo(i, "PDB_CONECT_firstAtom_count_max");
            int n5 = nArray[0] + n;
            int n6 = n5 + nArray[1];
            int n7 = nArray[2];
            int[] nArray2 = new int[n7 + 1];
            for (n3 = n5; n3 < n6; ++n3) {
                int n8 = this.atomSerials[n3];
                if (n8 <= 0) continue;
                nArray2[n8] = n3 + 1;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int[] nArray3 = (int[])list.get(n3);
                int n9 = nArray3[0];
                int n10 = nArray3[1];
                short s2 = (short)nArray3[2];
                if (n9 < 0 || n10 < 0 || n9 > n7 || n10 > n7) continue;
                int n11 = nArray2[n9] - 1;
                int n12 = nArray2[n10] - 1;
                if (n11 < 0 || n12 < 0) continue;
                if (bitSet != null) {
                    if (this.atoms[n11].isHetero()) {
                        bitSet.set(n11);
                    }
                    if (this.atoms[n12].isHetero()) {
                        bitSet.set(n12);
                    }
                }
                this.checkValencesAndBond(this.atoms[n11], this.atoms[n12], s2, s2 == 2048 ? (short)1 : s, null);
            }
        }
    }

    @Override
    public void deleteAllBonds() {
        this.moleculeCount = 0;
        int n = this.stateScripts.size();
        while (--n >= 0) {
            if (!((ModelCollection.StateScript)this.stateScripts.get(n)).isConnect()) continue;
            this.stateScripts.remove(n);
        }
        super.deleteAllBonds();
    }

    public String getDefinedState(StringBuffer stringBuffer, boolean bl) {
        String string;
        int n = this.stateScripts.size();
        if (n == 0) {
            return "";
        }
        boolean bl2 = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            ModelCollection.StateScript stateScript = (ModelCollection.StateScript)this.stateScripts.get(i);
            if (!stateScript.inDefinedStateBlock || (string = stateScript.toString()).length() <= 0) continue;
            stringBuffer2.append("  ").append(string).append("\n");
            bl2 = true;
        }
        if (!bl2) {
            return "";
        }
        string = "";
        if (bl && stringBuffer != null) {
            stringBuffer.append("  _setDefinedState;\n");
            string = "function _setDefinedState() {\n\n";
        }
        if (stringBuffer != null) {
            stringBuffer2.append("\n}\n\n");
        }
        return string + stringBuffer2.toString();
    }

    public String getState(StringBuffer stringBuffer, boolean bl, boolean bl2) {
        Object object;
        int n;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (bl && stringBuffer != null) {
            stringBuffer.append("  _setModelState;\n");
            stringBuffer2.append("function _setModelState() {\n");
        }
        if (bl) {
            n = this.stateScripts.size();
            for (int i = 0; i < n; ++i) {
                String string;
                ModelCollection.StateScript stateScript = (ModelCollection.StateScript)this.stateScripts.get(i);
                if (stateScript.inDefinedStateBlock || (string = stateScript.toString()).length() <= 0) continue;
                stringBuffer2.append("  ").append(string).append("\n");
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.bondCount; ++i) {
                if (this.models[this.bonds[i].atom1.modelIndex].isModelKit || !this.bonds[i].isHydrogen() && (this.bonds[i].order & 0x20000) == 0) continue;
                object = this.bonds[i];
                int n2 = ((Bond)object).atom1.index;
                if (((Bond)object).atom1.getGroup().isAdded(n2)) {
                    n2 = -1 - n2;
                }
                stringBuilder.append(n2).append('\t').append(((Bond)object).atom2.index).append('\t').append(((Bond)object).order & 0xFFFDFFFF).append('\t').append((float)((Bond)object).mad / 1000.0f).append('\t').append(((Bond)object).getEnergy()).append('\t').append(JmolEdge.getBondOrderNameFromOrder(((Bond)object).order)).append(";\n");
            }
            if (stringBuilder.length() > 0) {
                stringBuffer2.append("data \"connect_atoms\"\n").append((CharSequence)stringBuilder).append("end \"connect_atoms\";\n");
            }
            stringBuffer2.append("\n");
        }
        if (this.haveHiddenBonds) {
            Bond.BondSet bondSet = new Bond.BondSet();
            int n3 = this.bondCount;
            while (--n3 >= 0) {
                if (this.bonds[n3].mad == 0 || (this.bonds[n3].shapeVisibilityFlags & Bond.myVisibilityFlag) != 0) continue;
                bondSet.set(n3);
            }
            if (bondSet.isEmpty()) {
                this.haveHiddenBonds = false;
            } else {
                stringBuffer2.append("  hide ").append(Escape.escape(bondSet, false)).append(";\n");
            }
        }
        this.viewer.setModelVisibility();
        if (bl2) {
            stringBuffer2.append(this.getProteinStructureState(null, bl, false, 0));
        }
        this.viewer.getShapeState(stringBuffer2, bl);
        if (bl) {
            int n4;
            n = 0;
            for (n4 = 0; n4 < this.modelCount; ++n4) {
                if (!this.models[n4].isJmolDataFrame) continue;
                n = 1;
                break;
            }
            for (n4 = 0; n4 < this.modelCount; ++n4) {
                String string = (String)this.getModelAuxiliaryInfo(n4, "modelID");
                if (string != null && !string.equals(this.getModelAuxiliaryInfo(n4, "modelID0"))) {
                    stringBuffer2.append("  frame " + this.getModelNumberDotted(n4) + "; frame ID " + Escape.escape(string) + ";\n");
                }
                if ((object = this.frameTitles[n4]) != null && ((String)object).length() > 0) {
                    stringBuffer2.append("  frame " + this.getModelNumberDotted(n4) + "; frame title " + Escape.escape((String)object) + ";\n");
                }
                if (n != 0 && this.models[n4].orientation != null && !this.isTrajectorySubFrame(n4)) {
                    stringBuffer2.append("  frame " + this.getModelNumberDotted(n4) + "; " + this.models[n4].orientation.getMoveToText(false) + "\n");
                }
                if (this.models[n4].frameDelay == 0L || this.isTrajectorySubFrame(n4)) continue;
                stringBuffer2.append("  frame " + this.getModelNumberDotted(n4) + "; frame delay " + (float)this.models[n4].frameDelay / 1000.0f + "\n");
            }
            if (this.unitCells != null) {
                for (n4 = 0; n4 < this.modelCount; ++n4) {
                    SymmetryInterface symmetryInterface = this.getUnitCell(n4);
                    if (symmetryInterface == null) continue;
                    stringBuffer2.append("  frame ").append(this.getModelNumberDotted(n4));
                    object = symmetryInterface.getFractionalOffset();
                    if (object != null) {
                        stringBuffer2.append("; set unitcell ").append(Escape.escape((Tuple3f)object));
                    }
                    if ((object = symmetryInterface.getUnitCellMultiplier()) != null) {
                        stringBuffer2.append("; set unitcell ").append(Escape.escape((Tuple3f)object));
                    }
                    stringBuffer2.append(";\n");
                }
                if (this.viewer.getObjectMad(5) == 0) {
                    stringBuffer2.append("  unitcell OFF;\n");
                }
            }
            stringBuffer2.append("  set fontScaling " + this.viewer.getFontScaling() + ";\n");
            if (this.viewer.isModelKitMode()) {
                stringBuffer2.append("  set modelKitMode true;\n");
            }
        }
        if (stringBuffer != null) {
            stringBuffer2.append("\n}\n\n");
        }
        return stringBuffer2.toString();
    }

    private void includeAllRelatedFrames(BitSet bitSet) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (bitSet.get(i)) {
                int n;
                if (!this.isTrajectory(i) || bitSet.get(n = this.models[i].trajectoryBaseIndex)) continue;
                bitSet.set(n);
                this.includeAllRelatedFrames(bitSet);
                return;
            }
            if ((!this.isTrajectory(i) || !bitSet.get(this.models[i].trajectoryBaseIndex)) && (!this.isJmolDataFrame(i) || !bitSet.get(this.models[i].dataSourceFrame))) continue;
            bitSet.set(i);
        }
    }

    public BitSet deleteModels(BitSet bitSet) {
        int n;
        this.moleculeCount = 0;
        BitSet bitSet2 = this.getModelBitSet(bitSet, false);
        this.includeAllRelatedFrames(bitSet2);
        int n2 = 0;
        int n3 = BitSetUtil.cardinalityOf(bitSet2);
        if (n3 == 0) {
            return null;
        }
        int n4 = bitSet2.nextSetBit(0);
        while (n4 >= 0) {
            this.clearDataFrameReference(n4);
            n4 = bitSet2.nextSetBit(n4 + 1);
        }
        if (n3 == this.modelCount) {
            BitSet bitSet3 = this.getModelAtomBitSetIncludingDeleted(-1, true);
            this.viewer.zap(true, false, false);
            return bitSet3;
        }
        this.validateBspf(false);
        Model[] modelArray = new Model[this.modelCount - n3];
        Model[] modelArray2 = this.models;
        BitSet bitSet4 = new BitSet();
        int n5 = 0;
        for (n = 0; n < this.modelCount; ++n) {
            if (bitSet2.get(n)) {
                this.getAtomCountInModel(n);
                bitSet4.or(this.getModelAtomBitSetIncludingDeleted(n, false));
                continue;
            }
            this.models[n].modelIndex = n5;
            modelArray[n5++] = this.models[n];
        }
        this.models = modelArray;
        n = this.modelCount;
        BitSet bitSet5 = this.getBondsForSelectedAtoms(bitSet4, true);
        this.deleteBonds(bitSet5, true);
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            if (!bitSet2.get(i)) {
                ++n6;
                continue;
            }
            int n7 = modelArray2[i].atomCount;
            if (n7 == 0) continue;
            n2 += n7;
            BitSet bitSet6 = modelArray2[i].bsAtoms;
            int n8 = modelArray2[i].firstAtomIndex;
            BitSetUtil.deleteBits(this.bsSymmetry, bitSet6);
            this.deleteModel(n6, n8, n7, bitSet6, bitSet5);
            int n9 = n;
            while (--n9 > i) {
                modelArray2[n9].fixIndices(n6, n7, bitSet6);
            }
            this.viewer.deleteShapeAtoms(new Object[]{modelArray, this.atoms, new int[]{n6, n8, n7}}, bitSet6);
            --this.modelCount;
        }
        this.deleteModel(-1, 0, 0, null, null);
        return bitSet4;
    }

    @Override
    public void setAtomProperty(BitSet bitSet, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        switch (n) {
            case 1113200642: 
            case 1113200647: 
            case 1113200649: 
            case 1113200650: 
            case 1113200654: 
            case 1115297793: 
            case 1650071565: {
                if (f > 4.0f) {
                    f = 4.0f;
                }
            }
            case 1113200646: 
            case 1113200652: {
                RadiusData radiusData = null;
                int n3 = 0;
                if (fArray == null) {
                    if (f > 16.0f) {
                        f = 16.0f;
                    }
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    n3 = (int)(f * 2000.0f);
                } else {
                    radiusData = new RadiusData(fArray);
                }
                this.shapeManager.setShapeSize(JmolConstants.shapeTokenIndex(n), n3, radiusData, bitSet);
                return;
            }
        }
        super.setAtomProperty(bitSet, n, n2, f, string, fArray, stringArray);
    }

    public Object getFileData(int n) {
        if (n < 0) {
            return "";
        }
        Map<String, Object> map = (Map<String, Object>)this.getModelAuxiliaryInfo(n, "fileData");
        if (map != null) {
            return map;
        }
        if (!this.getModelAuxiliaryInfoBoolean(n, "isCIF")) {
            return this.getPDBHeader(n);
        }
        map = this.viewer.getCifData(n);
        this.setModelAuxiliaryInfo(n, "fileData", map);
        return map;
    }

    @Override
    public int calculateStruts(BitSet bitSet, BitSet bitSet2) {
        this.viewer.setModelVisibility();
        return super.calculateStruts(bitSet, bitSet2);
    }

    public BitSet addHydrogens(List<Atom> list, Point3f[] point3fArray) {
        int n = this.modelCount - 1;
        BitSet bitSet = new BitSet();
        if (this.isTrajectory(n) || this.models[n].getGroupCount() > 1) {
            return bitSet;
        }
        this.growAtomArrays(this.atomCount + point3fArray.length);
        RadiusData radiusData = this.viewer.getDefaultRadiusData();
        short s = this.getDefaultMadFromOrder(1);
        int n2 = 0;
        int n3 = this.models[n].atomCount + 1;
        while (n2 < list.size()) {
            Atom atom = list.get(n2);
            Atom atom2 = this.addAtom(n, atom.group, (short)1, "H" + n3, n3, n3, point3fArray[n2].x, point3fArray[n2].y, point3fArray[n2].z);
            atom2.setMadAtom(this.viewer, radiusData);
            bitSet.set(atom2.index);
            this.bondAtoms(atom, atom2, 1, s, null, 0.0f, false, false);
            ++n2;
            ++n3;
        }
        this.shapeManager.loadDefaultShapes(this);
        return bitSet;
    }

    public void setAtomCoordRelative(Tuple3f tuple3f, BitSet bitSet) {
        this.setAtomCoordRelative(bitSet, tuple3f.x, tuple3f.y, tuple3f.z);
        this.mat4.setIdentity();
        this.vTemp.set(tuple3f);
        this.mat4.setTranslation(this.vTemp);
        this.recalculatePositionDependentQuantities(bitSet, this.mat4);
    }

    @Override
    public void setAtomCoord(BitSet bitSet, int n, Object object) {
        super.setAtomCoord(bitSet, n, object);
        switch (n) {
            case 1112541202: 
            case 1112541203: 
            case 1112541204: 
            case 1146095630: {
                break;
            }
            default: {
                this.recalculatePositionDependentQuantities(bitSet, null);
            }
        }
    }

    public void invertSelected(Point3f point3f, Point4f point4f, int n, BitSet bitSet, BitSet bitSet2) {
        if (point3f != null) {
            int n2 = bitSet2.nextSetBit(0);
            while (n2 >= 0) {
                float f = (point3f.x - this.atoms[n2].x) * 2.0f;
                float f2 = (point3f.y - this.atoms[n2].y) * 2.0f;
                float f3 = (point3f.z - this.atoms[n2].z) * 2.0f;
                this.setAtomCoordRelative(n2, f, f2, f3);
                n2 = bitSet2.nextSetBit(n2 + 1);
            }
            return;
        }
        if (point4f != null) {
            Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
            vector3f.normalize();
            float f = (float)Math.sqrt(point4f.x * point4f.x + point4f.y * point4f.y + point4f.z * point4f.z);
            int n3 = bitSet2.nextSetBit(0);
            while (n3 >= 0) {
                float f4 = -Measure.distanceToPlane(point4f, f, (Point3f)this.atoms[n3]) * 2.0f;
                float f5 = vector3f.x * f4;
                float f6 = vector3f.y * f4;
                float f7 = vector3f.z * f4;
                this.setAtomCoordRelative(n3, f5, f6, f7);
                n3 = bitSet2.nextSetBit(n3 + 1);
            }
            return;
        }
        if (n >= 0) {
            Object object;
            Atom atom = this.atoms[n];
            Bond[] bondArray = atom.bonds;
            if (bondArray == null) {
                return;
            }
            BitSet bitSet3 = new BitSet();
            ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
            BitSet bitSet4 = this.viewer.getModelUndeletedAtomsBitSet(atom.modelIndex);
            for (int i = 0; i < bondArray.length; ++i) {
                object = bondArray[i].getOtherAtom(atom);
                if (bitSet.get(((Atom)object).index)) {
                    bitSet3.or(JmolMolecule.getBranchBitSet(this.atoms, ((Atom)object).index, bitSet4, null, n, true, true));
                    continue;
                }
                arrayList.add((Point3f)object);
            }
            if (arrayList.size() == 0) {
                return;
            }
            point3f = Measure.getCenterAndPoints(arrayList)[0];
            Vector3f vector3f = new Vector3f(atom);
            vector3f.sub(point3f);
            object = new Quaternion(vector3f, 180.0f);
            this.moveAtoms(null, ((Quaternion)object).getMatrix(), null, bitSet3, atom, true);
        }
    }

    public void moveAtoms(Matrix3f matrix3f, Matrix3f matrix3f2, Vector3f vector3f, BitSet bitSet, Point3f point3f, boolean bl) {
        if (matrix3f == null) {
            this.matTemp.set(matrix3f2);
        } else {
            this.matInv.set(matrix3f2);
            this.matInv.invert();
            this.ptTemp.set(0.0f, 0.0f, 0.0f);
            this.matTemp.mul(matrix3f, matrix3f2);
            this.matTemp.mul(this.matInv, this.matTemp);
        }
        if (bl) {
            this.vTemp.set(point3f);
            this.mat4.setIdentity();
            this.mat4.setTranslation(this.vTemp);
            this.mat4t.set(this.matTemp);
            this.mat4.mul(this.mat4t);
            this.mat4t.setIdentity();
            this.vTemp.scale(-1.0f);
            this.mat4t.setTranslation(this.vTemp);
            this.mat4.mul(this.mat4t);
        } else {
            this.mat4.set(this.matTemp);
        }
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            if (bl) {
                this.mat4.transform(this.atoms[n]);
            } else {
                this.ptTemp.add(this.atoms[n]);
                this.mat4.transform(this.atoms[n]);
                this.ptTemp.sub(this.atoms[n]);
            }
            this.taint(n, (byte)2);
            n = bitSet.nextSetBit(n + 1);
        }
        if (!bl) {
            this.ptTemp.scale(1.0f / (float)bitSet.cardinality());
            if (vector3f == null) {
                vector3f = new Vector3f();
            }
            vector3f.add(this.ptTemp);
        }
        if (vector3f != null) {
            n = bitSet.nextSetBit(0);
            while (n >= 0) {
                this.atoms[n].add(vector3f);
                n = bitSet.nextSetBit(n + 1);
            }
            this.mat4t.setIdentity();
            this.mat4t.setTranslation(vector3f);
            this.mat4.mul(this.mat4t, this.mat4);
        }
        this.recalculatePositionDependentQuantities(bitSet, this.mat4);
    }

    public void recalculatePositionDependentQuantities(BitSet bitSet, Matrix4f matrix4f) {
        if (this.getHaveStraightness()) {
            this.calculateStraightness();
        }
        this.recalculateLeadMidpointsAndWingVectors(-1);
        BitSet bitSet2 = this.getModelBitSet(bitSet, false);
        int n = bitSet2.nextSetBit(0);
        while (n >= 0) {
            this.shapeManager.refreshShapeTrajectories(n, bitSet, matrix4f);
            n = bitSet2.nextSetBit(n + 1);
        }
    }
}

