/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.export.___Exporter;
import org.jmol.modelset.Atom;

abstract class __RayTracerExporter
extends ___Exporter {
    protected boolean isSlabEnabled;
    protected int minScreenDimension;

    public __RayTracerExporter() {
        this.exportType = 2;
        this.lineWidthMad = (short)2;
    }

    protected void outputVertex(Point3f point3f, Point3f point3f2) {
        __RayTracerExporter.setTempVertex(point3f, point3f2, this.tempP1);
        this.viewer.transformPoint(this.tempP1, this.tempP1);
        this.output(this.tempP1);
    }

    protected abstract void outputCircle(int var1, int var2, int var3, float var4, short var5, boolean var6);

    protected abstract void outputCylinder(Point3f var1, Point3f var2, float var3, short var4, boolean var5);

    protected abstract void outputCylinderConical(Point3f var1, Point3f var2, float var3, float var4, short var5);

    protected abstract void outputEllipsoid(Point3f var1, float var2, double[] var3, short var4);

    protected abstract void outputSphere(float var1, float var2, float var3, float var4, short var5);

    protected abstract void outputTextPixel(int var1, int var2, int var3, int var4);

    protected abstract void outputTriangle(Point3f var1, Point3f var2, Point3f var3, short var4);

    protected abstract void outputCone(Point3f var1, Point3f var2, float var3, short var4, boolean var5);

    protected Point3f getScreenNormal(Point3f point3f, Vector3f vector3f, float f) {
        if (Float.isNaN(vector3f.x)) {
            this.tempP3.set(0.0f, 0.0f, 0.0f);
            return this.tempP3;
        }
        this.tempP1.set(point3f);
        this.tempP1.add(vector3f);
        this.viewer.transformPoint(point3f, this.tempP2);
        this.viewer.transformPoint(this.tempP1, this.tempP3);
        this.tempP3.sub(this.tempP2);
        this.tempP3.scale(f);
        return this.tempP3;
    }

    protected void outputHeader() {
        this.nBytes = 0;
        this.isSlabEnabled = this.viewer.getSlabEnabled();
        this.minScreenDimension = Math.min(this.screenWidth, this.screenHeight);
    }

    void drawAtom(Atom atom) {
        this.outputSphere(atom.screenX, atom.screenY, atom.screenZ, (float)atom.screenDiameter / 2.0f, atom.getColix());
    }

    void drawCircle(int n, int n2, int n3, int n4, short s, boolean bl) {
        float f = (float)n4 / 2.0f;
        this.outputCircle(n, n2, n3, f, s, bl);
    }

    boolean drawEllipse(Point3f point3f, Point3f point3f2, Point3f point3f3, short s, boolean bl) {
        return false;
    }

    void drawPixel(short s, int n, int n2, int n3, int n4) {
        this.outputSphere(n, n2, n3, 0.75f * (float)n4, s);
    }

    void drawTextPixel(int n, int n2, int n3, int n4) {
        this.outputTextPixel(n2, n3, n4, n);
    }

    void fillConeScreen(short s, byte by, int n, Point3f point3f, Point3f point3f2, boolean bl) {
        this.outputCone(point3f, point3f2, (float)n / 2.0f, s, bl);
    }

    void drawCylinder(Point3f point3f, Point3f point3f2, short s, short s2, byte by, int n, int n2) {
        if (s == s2) {
            this.fillConicalCylinder(point3f, point3f2, n, s, by);
        } else {
            this.tempV2.set(point3f2);
            this.tempV2.add(point3f);
            this.tempV2.scale(0.5f);
            this.tempP1.set(this.tempV2);
            this.fillConicalCylinder(point3f, this.tempP1, n, s, by);
            this.fillConicalCylinder(this.tempP1, point3f2, n, s2, by);
        }
        if (by != 3) {
            return;
        }
        float f = (float)this.viewer.scaleToScreen((int)point3f.z, n) / 2.0f;
        if (f <= 1.0f) {
            return;
        }
        this.outputSphere(point3f.x, point3f.y, point3f.z, f, s);
        f = (float)this.viewer.scaleToScreen((int)point3f2.z, n) / 2.0f;
        if (f <= 1.0f) {
            return;
        }
        this.outputSphere(point3f2.x, point3f2.y, point3f2.z, f, s2);
    }

    protected void fillConicalCylinder(Point3f point3f, Point3f point3f2, int n, short s, byte by) {
        float f = (float)this.viewer.scaleToScreen((int)point3f.z, n) / 2.0f;
        if (f == 0.0f) {
            return;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        if (point3f.distance(point3f2) == 0.0f) {
            this.outputSphere(point3f.x, point3f.y, point3f.z, f, s);
            return;
        }
        float f2 = (float)this.viewer.scaleToScreen((int)point3f2.z, n) / 2.0f;
        if (f2 == 0.0f) {
            return;
        }
        if (f2 < 1.0f) {
            f2 = 1.0f;
        }
        this.outputCylinderConical(point3f, point3f2, f, f2, s);
    }

    void fillCylinderScreenMad(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
        float f = (float)n / 2.0f;
        if (f == 0.0f) {
            return;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        if (point3f.distance(point3f2) == 0.0f) {
            this.outputSphere(point3f.x, point3f.y, point3f.z, f, s);
            return;
        }
        this.outputCylinder(point3f, point3f2, f, s, by == 2);
        if (by != 3 || f <= 1.0f) {
            return;
        }
        this.outputSphere(point3f.x, point3f.y, point3f.z, f, s);
        this.outputSphere(point3f2.x, point3f2.y, point3f2.z, f, s);
    }

    void fillCylinderScreen(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
        this.fillCylinderScreenMad(s, by, n, point3f, point3f2);
    }

    void fillSphere(short s, int n, Point3f point3f) {
        this.outputSphere(point3f.x, point3f.y, point3f.z, (float)n / 2.0f, s);
    }

    protected void fillTriangle(short s, Point3f point3f, Point3f point3f2, Point3f point3f3, boolean bl) {
        this.outputTriangle(point3f, point3f2, point3f3, s);
    }

    void fillEllipsoid(Point3f point3f, Point3f[] point3fArray, short s, int n, int n2, int n3, int n4, Matrix3f matrix3f, double[] dArray, Matrix4f matrix4f, Point3i[] point3iArray) {
        float f = (float)n4 / 2.0f;
        if (f == 0.0f) {
            return;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.outputEllipsoid(point3f, f, dArray, s);
    }
}

