/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.export.Exporter;
import jspecview.export.JDXCompressor;
import jspecview.source.FileReader;
import jspecview.util.TextFormat;

public class JDXExporter {
    private static final double FACTOR_DIVISOR = 1000000.0;

    static String export(Exporter.Type type, String path, JDXSpectrum spectrum, int startIndex, int endIndex) throws IOException {
        String data = JDXExporter.toStringAux(type, spectrum, startIndex, endIndex);
        if (path == null) {
            return data;
        }
        FileWriter writer = new FileWriter(path);
        writer.write(data);
        writer.close();
        return " (" + data.length() + " bytes)";
    }

    private static String toStringAux(Exporter.Type type, JDXSpectrum spectrum, int startIndex, int endIndex) {
        StringBuffer buffer = new StringBuffer();
        Coordinate[] newXYCoords = spectrum.getXYCoords();
        String tabDataSet = "";
        String tmpDataClass = "XYDATA";
        if (spectrum.isHZtoPPM()) {
            Coordinate[] xyCoords = newXYCoords;
            newXYCoords = new Coordinate[xyCoords.length];
            int i = 0;
            while (i < xyCoords.length) {
                newXYCoords[i] = xyCoords[i].copy();
                ++i;
            }
            Coordinate.applyScale(newXYCoords, spectrum.getObservedFreq(), 1.0);
        }
        double xCompFactor = spectrum.getXFactor();
        boolean isIntegerX = JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, 1.0, true);
        if (!isIntegerX && !JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, xCompFactor, true)) {
            xCompFactor = 1.0;
        }
        double minY = Coordinate.getMinY(newXYCoords, startIndex, endIndex);
        double maxY = Coordinate.getMaxY(newXYCoords, startIndex, endIndex);
        double yCompFactor = spectrum.getYFactor();
        switch (type) {
            case XY: {
                yCompFactor = 1.0;
                tmpDataClass = spectrum.isContinuous() ? "XYDATA" : "XYPOINTS";
                break;
            }
            case PAC: {
                yCompFactor = 1.0;
                break;
            }
            default: {
                boolean isIntegerY = JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, 1.0, false);
                if (isIntegerY || JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, yCompFactor, false)) break;
                yCompFactor = (maxY - minY) / 1000000.0;
            }
        }
        int step = 1;
        if (spectrum.isExportXAxisLeftToRight() != spectrum.getFirstX() < spectrum.getLastX()) {
            int t = startIndex;
            startIndex = endIndex;
            endIndex = t;
            step = -1;
        }
        switch (type) {
            case DIF: 
            case DIFDUP: {
                tabDataSet = JDXCompressor.compressDIF(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor, type == Exporter.Type.DIFDUP);
                break;
            }
            case FIX: {
                tabDataSet = JDXCompressor.compressFIX(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
                break;
            }
            case PAC: {
                tabDataSet = JDXCompressor.compressPAC(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
                break;
            }
            case SQZ: {
                tabDataSet = JDXCompressor.compressSQZ(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
                break;
            }
            case XY: {
                tabDataSet = JDXCompressor.getXYList(newXYCoords, startIndex, endIndex, step);
            }
        }
        int index = Arrays.binarySearch(FileReader.VAR_LIST_TABLE[0], tmpDataClass);
        String varList = FileReader.VAR_LIST_TABLE[1][index];
        buffer.append(JDXExporter.getHeaderString(spectrum, tmpDataClass, minY, maxY, xCompFactor, yCompFactor, startIndex, endIndex));
        buffer.append("##" + tmpDataClass + "= " + varList + TextFormat.newLine);
        buffer.append(tabDataSet);
        buffer.append("##END=");
        return buffer.toString();
    }

    private static String getHeaderString(JDXSpectrum spec, String tmpDataClass, double minY, double maxY, double tmpXFactor, double tmpYFactor, int startIndex, int endIndex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("##TITLE= ").append(spec.getTitle()).append(TextFormat.newLine);
        buffer.append("##JCAMP-DX= 5.01").append(TextFormat.newLine);
        buffer.append("##DATA TYPE= ").append(spec.getDataType()).append(TextFormat.newLine);
        buffer.append("##DATA CLASS= ").append(tmpDataClass).append(TextFormat.newLine);
        buffer.append("##ORIGIN= ").append(spec.getOrigin()).append(TextFormat.newLine);
        buffer.append("##OWNER= ").append(spec.getOwner()).append(TextFormat.newLine);
        String d = spec.getDate();
        String longdate = "";
        String currentTime = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSSS ZZZZ").format(Calendar.getInstance().getTime());
        longdate = spec.getLongDate().equals("") || d.length() != 8 ? String.valueOf(currentTime) + " $$ export date from JSpecView" : (d.length() == 8 ? String.valueOf(d.charAt(0) < '5' ? "20" : "19") + d + " " + spec.getTime() : spec.getLongDate());
        buffer.append("##LONGDATE= ").append(longdate).append(TextFormat.newLine);
        List<String[]> headerTable = spec.getHeaderTable();
        int i = 0;
        while (i < headerTable.size()) {
            String[] entry = headerTable.get(i);
            String label = entry[0];
            String dataSet = entry[1];
            String nl = dataSet.startsWith("<") && dataSet.contains("</") ? TextFormat.newLine : "";
            buffer.append(label).append("= ").append(nl).append(dataSet).append(TextFormat.newLine);
            ++i;
        }
        double observedFreq = spec.getObservedFreq();
        if (!spec.is1D()) {
            buffer.append("##NUM DIM= ").append(spec.numDim).append(TextFormat.newLine);
        }
        if (observedFreq != Double.MAX_VALUE) {
            buffer.append("##.OBSERVE FREQUENCY= ").append(observedFreq).append(TextFormat.newLine);
        }
        if (spec.observedNucl != "") {
            buffer.append("##.OBSERVE NUCLEUS= ").append(spec.observedNucl).append(TextFormat.newLine);
        }
        buffer.append("##XUNITS= ").append(spec.isHZtoPPM() ? "HZ" : spec.getXUnits()).append(TextFormat.newLine);
        buffer.append("##YUNITS= ").append(spec.getYUnits()).append(TextFormat.newLine);
        buffer.append("##XFACTOR= ").append(TextFormat.fixExponentInt(tmpXFactor)).append(TextFormat.newLine);
        buffer.append("##YFACTOR= ").append(TextFormat.fixExponentInt(tmpYFactor)).append(TextFormat.newLine);
        double f = spec.isHZtoPPM() ? observedFreq : 1.0;
        Coordinate[] xyCoords = spec.getXYCoords();
        buffer.append("##FIRSTX= ").append(TextFormat.fixExponentInt(xyCoords[startIndex].getXVal() * f)).append(TextFormat.newLine);
        buffer.append("##FIRSTY= ").append(TextFormat.fixExponentInt(xyCoords[startIndex].getYVal())).append(TextFormat.newLine);
        buffer.append("##LASTX= ").append(TextFormat.fixExponentInt(xyCoords[endIndex].getXVal() * f)).append(TextFormat.newLine);
        buffer.append("##NPOINTS= ").append(Math.abs(endIndex - startIndex) + 1).append(TextFormat.newLine);
        buffer.append("##MINY= ").append(TextFormat.fixExponentInt(minY)).append(TextFormat.newLine);
        buffer.append("##MAXY= ").append(TextFormat.fixExponentInt(maxY)).append(TextFormat.newLine);
        return buffer.toString();
    }

    private static boolean areIntegers(Coordinate[] xyCoords, int startIndex, int endIndex, double factor, boolean isX) {
        int i = startIndex;
        while (i <= endIndex) {
            double x = (isX ? xyCoords[i].getXVal() : xyCoords[i].getYVal()) / factor;
            if (TextFormat.isAlmostInteger(x)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

