/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVFileFilter;
import jspecview.common.JSVPanel;
import jspecview.common.ScriptToken;
import jspecview.export.AMLExporter;
import jspecview.export.CMLExporter;
import jspecview.export.JDXExporter;
import jspecview.export.SVGExporter;
import jspecview.util.FileManager;
import jspecview.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exporter {
    public static final String sourceLabel = "Source...";

    public static String exportTheSpectrum(Type mode, String path, JDXSpectrum spec, int startIndex, int endIndex) throws IOException {
        switch (mode) {
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                return JDXExporter.export(mode, path, spec, startIndex, endIndex);
            }
            case SVG: 
            case SVGI: {
                return new SVGExporter().exportAsSVG(path, spec, startIndex, endIndex, mode == Type.SVGI);
            }
            case CML: {
                return new CMLExporter().exportAsCML(path, spec, startIndex, endIndex);
            }
            case AML: {
                return new AMLExporter().exportAsAnIML(path, spec, startIndex, endIndex);
            }
        }
        return null;
    }

    public static String exportSpectra(JSVPanel selectedJSVPanel, JFrame frame, JFileChooser fc, String type, String recentFileName, String dirLastExported) {
        int numOfSpectra = selectedJSVPanel.getPanelData().getNumberOfGraphSets();
        if (numOfSpectra == 1 || type.equals("JPG") || type.equals("PNG")) {
            return Exporter.exportSpectrumOrImage(selectedJSVPanel, type, -1, fc, recentFileName, dirLastExported);
        }
        String[] items = new String[numOfSpectra];
        int i = 0;
        while (i < numOfSpectra) {
            items[i] = selectedJSVPanel.getSpectrumAt(i).getTitle();
            ++i;
        }
        final JDialog dialog = new JDialog(frame, "Choose Spectrum", true);
        dialog.setResizable(false);
        dialog.setSize(200, 100);
        Component panel = (Component)((Object)selectedJSVPanel);
        dialog.setLocation((panel.getLocation().x + panel.getSize().width) / 2, (panel.getLocation().y + panel.getSize().height) / 2);
        final JComboBox<String> cb = new JComboBox<String>(items);
        Dimension d = new Dimension(120, 25);
        cb.setPreferredSize(d);
        cb.setMaximumSize(d);
        cb.setMinimumSize(d);
        JPanel p = new JPanel(new FlowLayout());
        JButton button = new JButton("OK");
        p.add(cb);
        p.add(button);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)new JLabel("Choose Spectrum to export", 0), "North");
        dialog.getContentPane().add(p);
        String dir = dirLastExported;
        final String dl = dirLastExported;
        final String t = type;
        final String rfn = recentFileName;
        final JFileChooser f = fc;
        final JSVPanel jsvp = selectedJSVPanel;
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = cb.getSelectedIndex();
                dialog.dispose();
                Exporter.exportSpectrumOrImage(jsvp, t, index, f, rfn, dl);
            }
        });
        dialog.setVisible(true);
        return dir;
    }

    public static String exportCmd(JSVPanel jsvp, List<String> tokens, boolean forInkscape) {
        String ext;
        String mode = "XY";
        String fileName = null;
        switch (tokens.size()) {
            default: {
                return "EXPORT what?";
            }
            case 1: {
                fileName = TextFormat.trimQuotes(tokens.get(0));
                int pt = fileName.indexOf(".");
                if (pt >= 0) break;
                return "EXPORT mode?";
            }
            case 2: {
                mode = tokens.get(0).toUpperCase();
                fileName = TextFormat.trimQuotes(tokens.get(1));
            }
        }
        if ((ext = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase()).equals("JDX")) {
            if (mode == null) {
                mode = "XY";
            }
        } else if (Type.isExportMode(ext)) {
            mode = ext;
        } else if (Type.isExportMode(mode)) {
            fileName = String.valueOf(fileName) + "." + mode;
        }
        Type type = Type.getType(mode);
        if (forInkscape && type == Type.SVG) {
            type = Type.SVGI;
        }
        return Exporter.exportSpectrumOrImage(jsvp, type, -1, fileName);
    }

    private static String exportSpectrumOrImage(JSVPanel selectedJSVPanel, String mode, int index, JFileChooser fc, String recentFileName, String dirLastExported) {
        int option;
        int pt;
        String fname;
        Type imode = Type.getType(mode);
        JSVFileFilter filter = new JSVFileFilter();
        if (imode == Type.SOURCE && !FileManager.isURL(fname = selectedJSVPanel.getSpectrum().getFilePath())) {
            recentFileName = fname;
        }
        String name = (pt = recentFileName.lastIndexOf(".")) < 0 ? recentFileName : recentFileName.substring(0, pt);
        switch (imode) {
            case SOURCE: 
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                filter.addExtension("jdx");
                filter.addExtension("dx");
                filter.setDescription("JCAMP-DX Files");
                name = String.valueOf(name) + ".jdx";
                break;
            }
            case AML: {
                mode = "XML";
            }
            default: {
                filter.addExtension(mode);
                filter.setDescription(String.valueOf(mode) + " Files");
                name = String.valueOf(name) + "." + mode.toLowerCase();
            }
        }
        fc.setFileFilter(filter);
        fc.setSelectedFile(new File(name));
        int returnVal = fc.showSaveDialog((Component)((Object)selectedJSVPanel));
        if (returnVal != 0) {
            return dirLastExported;
        }
        File file = fc.getSelectedFile();
        String dir = file.getParent();
        if (file.exists() && (option = JOptionPane.showConfirmDialog((Component)((Object)selectedJSVPanel), "Overwrite " + file.getName() + "?", "Confirm Overwrite Existing File", 0, 3)) == 1) {
            return dir;
        }
        if (imode == Type.SOURCE) {
            Exporter.fileCopy(name, file);
        } else {
            Exporter.exportSpectrumOrImage(selectedJSVPanel, imode, index, file.getAbsolutePath());
        }
        return dir;
    }

    private static void fileCopy(String name, File file) {
        try {
            BufferedReader br = FileManager.getBufferedReaderFromName(name, null, null);
            FileWriter writer = new FileWriter(file.getAbsolutePath());
            String line = null;
            while ((line = br.readLine()) != null) {
                writer.write(line);
                writer.write(TextFormat.newLine);
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String exportSpectrumOrImage(JSVPanel jsvp, Type imode, int index, String path) {
        JDXSpectrum spec;
        if (index < 0) {
            index = 0;
            spec = jsvp.getSpectrum();
        } else {
            spec = jsvp.getSpectrumAt(index);
        }
        int startIndex = jsvp.getPanelData().getStartDataPointIndices()[index];
        int endIndex = jsvp.getPanelData().getEndDataPointIndices()[index];
        try {
            String msg;
            switch (imode) {
                case PNG: 
                case JPG: {
                    Image image = ((Component)((Object)jsvp)).createImage(jsvp.getWidth(), jsvp.getHeight());
                    ((Component)((Object)jsvp)).paint(image.getGraphics());
                    ImageIO.write((RenderedImage)((Object)image), imode == Type.PNG ? "png" : "jpg", new File(path));
                    msg = " OK";
                    break;
                }
                case SVG: 
                case SVGI: {
                    msg = new SVGExporter().exportAsSVG(path, spec.getXYCoords(), spec.getTitle(), startIndex, endIndex, spec.getXUnits(), spec.getYUnits(), spec.isContinuous(), spec.isIncreasing(), (Color)jsvp.getColor(ScriptToken.PLOTAREACOLOR), ((Component)((Object)jsvp)).getBackground(), (Color)jsvp.getPlotColor(0), (Color)jsvp.getColor(ScriptToken.GRIDCOLOR), (Color)jsvp.getColor(ScriptToken.TITLECOLOR), (Color)jsvp.getColor(ScriptToken.SCALECOLOR), (Color)jsvp.getColor(ScriptToken.UNITSCOLOR), imode == Type.SVGI);
                    break;
                }
                default: {
                    msg = Exporter.exportTheSpectrum(imode, path, spec, startIndex, endIndex);
                }
            }
            return "Exported " + imode.name() + ": " + path + msg;
        }
        catch (IOException ioe) {
            return "Error exporting " + path + ": " + ioe.getMessage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNK,
        SOURCE,
        DIF,
        FIX,
        SQZ,
        PAC,
        XY,
        DIFDUP,
        PNG,
        JPG,
        SVG,
        SVGI,
        CML,
        AML;


        public static Type getType(String type) {
            if ((type = type.toUpperCase()).equals(Exporter.sourceLabel)) {
                return SOURCE;
            }
            if (type.startsWith("XML")) {
                return AML;
            }
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type mode = typeArray[n2];
                if (mode.name().equals(type)) {
                    return mode;
                }
                ++n2;
            }
            return UNK;
        }

        public static boolean isExportMode(String ext) {
            return Type.getType(ext) != UNK;
        }
    }
}

