/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import jspecview.common.ScriptInterface;
import jspecview.util.Escape;
import jspecview.util.Logger;

public class JSVDropTargetListener
implements DropTargetListener {
    private ScriptInterface si;
    private boolean allowAppend;

    public JSVDropTargetListener(ScriptInterface si, boolean allowAppend) {
        this.si = si;
        this.allowAppend = allowAppend;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getSourceActions());
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent dtde) {
        Logger.debug("Drop detected...");
        Transferable t = dtde.getTransferable();
        boolean isAccepted = false;
        boolean doAppend = this.allowAppend && dtde.getDropTargetContext().getDropTarget().getComponent() != this.si;
        String prefix = doAppend ? "" : "close ALL;";
        String postfix = doAppend ? "" : "overlay ALL";
        String cmd = "LOAD APPEND ";
        String fileToLoad = null;
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            Object o = null;
            try {
                dtde.acceptDrop(3);
                o = t.getTransferData(DataFlavor.javaFileListFlavor);
                isAccepted = true;
            }
            catch (Exception e) {
                Logger.error("transfer failed");
            }
            if (o instanceof List) {
                List list = (List)o;
                dtde.getDropTargetContext().dropComplete(true);
                dtde = null;
                StringBuffer sb = new StringBuffer(prefix);
                int i = 0;
                while (i < list.size()) {
                    sb.append(String.valueOf(cmd) + Escape.escape(((File)list.get(i)).getAbsolutePath()) + ";");
                    ++i;
                }
                sb.append(postfix);
                cmd = sb.toString();
                Logger.info("Drop command = " + cmd);
                this.si.runScript(cmd);
                return;
            }
        }
        Logger.debug("browsing supported flavours to find something useful...");
        DataFlavor[] df = t.getTransferDataFlavors();
        if (df == null || df.length == 0) {
            return;
        }
        int i = 0;
        while (i < df.length) {
            DataFlavor flavor = df[i];
            Object o = null;
            Logger.info("df " + i + " flavor " + flavor);
            Logger.info("  class: " + flavor.getRepresentationClass().getName());
            Logger.info("  mime : " + flavor.getMimeType());
            if (flavor.getMimeType().startsWith("text/uri-list") && flavor.getRepresentationClass().getName().equals("java.lang.String")) {
                try {
                    o = null;
                    if (!isAccepted) {
                        dtde.acceptDrop(3);
                    }
                    isAccepted = true;
                    o = t.getTransferData(flavor);
                }
                catch (Exception e) {
                    Logger.error(null, e);
                }
                if (o instanceof String) {
                    dtde.getDropTargetContext().dropComplete(true);
                    if (Logger.debugging) {
                        Logger.debug("  String: " + o.toString());
                    }
                    fileToLoad = o.toString();
                    break;
                }
            } else if (flavor.getMimeType().equals("application/x-java-serialized-object; class=java.lang.String")) {
                try {
                    o = null;
                    if (!isAccepted) {
                        dtde.acceptDrop(3);
                    }
                    isAccepted = true;
                    o = t.getTransferData(df[i]);
                }
                catch (Exception e) {
                    Logger.error(null, e);
                }
                if (o instanceof String) {
                    String content = (String)o;
                    dtde.getDropTargetContext().dropComplete(true);
                    if (Logger.debugging) {
                        Logger.debug("  String: " + content);
                    }
                    if (content.startsWith("file:/")) {
                        fileToLoad = content;
                        break;
                    }
                }
            }
            ++i;
        }
        if (!isAccepted) {
            dtde.rejectDrop();
        }
        if (fileToLoad != null) {
            cmd = String.valueOf(prefix) + cmd + Escape.escape(fileToLoad) + "\";" + postfix;
            Logger.info("Drop command = " + cmd);
            this.si.runScript(cmd);
        }
    }
}

