/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import jspecview.common.JDXSpectrum;
import jspecview.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coordinate {
    private double xVal = 0.0;
    private double yVal = 0.0;
    private static DecimalFormat formatter = TextFormat.getDecimalFormat("0.########");

    public Coordinate() {
    }

    public Coordinate(double x, double y) {
        this.xVal = x;
        this.yVal = y;
    }

    public double getXVal() {
        return this.xVal;
    }

    public double getYVal() {
        return this.yVal;
    }

    public String getXString() {
        return formatter.format(this.xVal);
    }

    public String getYString() {
        return formatter.format(this.yVal);
    }

    public void setXVal(double val) {
        this.xVal = val;
    }

    public void setYVal(double val) {
        this.yVal = val;
    }

    public Coordinate copy() {
        return new Coordinate(this.xVal, this.yVal);
    }

    public boolean equals(Coordinate coord) {
        return coord.xVal == this.xVal && coord.yVal == this.yVal;
    }

    public String toString() {
        return "[" + this.xVal + ", " + this.yVal + "]";
    }

    public static boolean isYInRange(Coordinate[] xyCoords, double min, double max) {
        return Coordinate.getMinY(xyCoords) >= min && Coordinate.getMaxY(xyCoords) >= max;
    }

    public static Coordinate[] normalise(Coordinate[] xyCoords, double min, double max) {
        Coordinate[] newXYCoords = new Coordinate[xyCoords.length];
        double minY = Coordinate.getMinY(xyCoords);
        double maxY = Coordinate.getMaxY(xyCoords);
        double factor = (maxY - minY) / (max - min);
        int i = 0;
        while (i < xyCoords.length) {
            newXYCoords[i] = new Coordinate(xyCoords[i].getXVal(), (xyCoords[i].getYVal() - minY) / factor - min);
            ++i;
        }
        return newXYCoords;
    }

    public static Coordinate[] reverse(Coordinate[] x) {
        int n = x.length;
        int i = 0;
        while (i < n) {
            Coordinate v = x[i];
            x[i] = x[--n];
            x[n] = v;
            ++i;
        }
        return x;
    }

    public static Coordinate[] parseDSV(String dataPoints, double xFactor, double yFactor) {
        double xval = 0.0;
        double yval = 0.0;
        ArrayList<Coordinate> xyCoords = new ArrayList<Coordinate>(1024);
        String delim = " \t\n\r\f,;";
        StringTokenizer st = new StringTokenizer(dataPoints, delim);
        while (st.hasMoreTokens()) {
            String tmp1 = st.nextToken().trim();
            String tmp2 = st.nextToken().trim();
            xval = Double.parseDouble(tmp1);
            yval = Double.parseDouble(tmp2);
            Coordinate point = new Coordinate(xval * xFactor, yval * yFactor);
            xyCoords.add(point);
        }
        Coordinate[] coord = new Coordinate[xyCoords.size()];
        return xyCoords.toArray(coord);
    }

    public static double deltaX(double last, double first, int numPoints) {
        double test = (last - first) / (double)(numPoints - 1);
        return test;
    }

    public static void removeScale(Coordinate[] xyCoords, double xScale, double yScale) {
        Coordinate.applyScale(xyCoords, 1.0 / xScale, 1.0 / yScale);
    }

    public static void applyScale(Coordinate[] xyCoords, double xScale, double yScale) {
        if (xScale != 1.0 || yScale != 1.0) {
            int i = 0;
            while (i < xyCoords.length) {
                xyCoords[i].setXVal(xyCoords[i].getXVal() * xScale);
                xyCoords[i].setYVal(xyCoords[i].getYVal() * yScale);
                ++i;
            }
        }
    }

    public static void applyShiftReference(Coordinate[] xyCoords, int dataPointNum, double firstX, double lastX, double offset, double observedFreq, int shiftRefType) throws IndexOutOfBoundsException {
        if (dataPointNum > xyCoords.length || dataPointNum < 0) {
            return;
        }
        switch (shiftRefType) {
            case 0: {
                offset = xyCoords[xyCoords.length - dataPointNum].getXVal() - offset * observedFreq;
                break;
            }
            case 1: {
                offset = firstX - offset * observedFreq;
                break;
            }
            case 2: {
                offset = lastX + offset;
            }
        }
        int index = 0;
        while (index < xyCoords.length) {
            Coordinate coord = xyCoords[index];
            coord.setXVal(coord.getXVal() - offset);
            xyCoords[index] = coord;
            ++index;
        }
        firstX -= offset;
        lastX -= offset;
    }

    public static double getMinX(Coordinate[] coords, int start, int end) {
        double min = Double.MAX_VALUE;
        int index = start;
        while (index <= end) {
            double tmp = coords[index].getXVal();
            if (tmp < min) {
                min = tmp;
            }
            ++index;
        }
        return min;
    }

    public static double getMinX(Coordinate[] coords) {
        return Coordinate.getMinX(coords, 0, coords.length - 1);
    }

    public static double getMinX(List<JDXSpectrum> spectra, int[] startList, int[] endList) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < spectra.size()) {
            double tmp = Coordinate.getMinX(spectra.get(i).getXYCoords(), startList[i], endList[i]);
            if (tmp < min) {
                min = tmp;
            }
            ++i;
        }
        return min;
    }

    public static double getMinX(List<JDXSpectrum> spectra) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < spectra.size()) {
            double tmp = Coordinate.getMinX(spectra.get(i).getXYCoords());
            if (tmp < min) {
                min = tmp;
            }
            ++i;
        }
        return min;
    }

    public static double getMaxX(Coordinate[] coords, int start, int end) {
        double max = -1.7976931348623157E308;
        int index = start;
        while (index <= end) {
            double tmp = coords[index].getXVal();
            if (tmp > max) {
                max = tmp;
            }
            ++index;
        }
        return max;
    }

    public static double getMaxX(Coordinate[] coords) {
        return Coordinate.getMaxX(coords, 0, coords.length - 1);
    }

    public static double getMaxX(List<JDXSpectrum> spectra, int[] startList, int[] endList) {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < spectra.size()) {
            double tmp = Coordinate.getMaxX(spectra.get(i).getXYCoords(), startList[i], endList[i]);
            if (tmp > max) {
                max = tmp;
            }
            ++i;
        }
        return max;
    }

    public static double getMaxX(List<JDXSpectrum> spectra) {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < spectra.size()) {
            double tmp = Coordinate.getMaxX(spectra.get(i).getXYCoords());
            if (tmp > max) {
                max = tmp;
            }
            ++i;
        }
        return max;
    }

    public static double getMinY(Coordinate[] coords, int start, int end) {
        double min = Double.MAX_VALUE;
        int index = start;
        while (index <= end) {
            double tmp = coords[index].getYVal();
            if (tmp < min) {
                min = tmp;
            }
            ++index;
        }
        return min;
    }

    public static double getMinY(Coordinate[] coords) {
        return Coordinate.getMinY(coords, 0, coords.length - 1);
    }

    public static double getMinYUser(List<JDXSpectrum> spectra, int[] startList, int[] endList) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < spectra.size()) {
            double u = spectra.get(i).getUserYFactor();
            double tmp = Coordinate.getMinY(spectra.get(i).getXYCoords(), startList[i], endList[i]) * u;
            if (tmp < min) {
                min = tmp;
            }
            ++i;
        }
        return min;
    }

    public static double getMinYUser(List<JDXSpectrum> spectra) {
        double min = Double.MAX_VALUE;
        int i = spectra.size();
        while (--i >= 0) {
            double tmp = Coordinate.getMinY(spectra.get(i).getXYCoords()) * spectra.get(i).getUserYFactor();
            if (!(tmp < min)) continue;
            min = tmp;
        }
        return min;
    }

    public static double getMaxY(Coordinate[] coords, int start, int end) {
        double max = -1.7976931348623157E308;
        int index = start;
        while (index <= end) {
            double tmp = coords[index].getYVal();
            if (tmp > max) {
                max = tmp;
            }
            ++index;
        }
        return max;
    }

    public static double getMaxY(Coordinate[] coords) {
        return Coordinate.getMaxY(coords, 0, coords.length - 1);
    }

    public static double getMaxYUser(List<JDXSpectrum> spectra, int[] startList, int[] endList) {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < spectra.size()) {
            double u = spectra.get(i).getUserYFactor();
            double tmp = Coordinate.getMaxY(spectra.get(i).getXYCoords(), startList[i], endList[i]) * u;
            if (tmp > max) {
                max = tmp;
            }
            ++i;
        }
        return max;
    }

    public static double getMaxYUser(List<JDXSpectrum> spectra) {
        double max = -1.7976931348623157E308;
        int i = spectra.size();
        while (--i >= 0) {
            double tmp = Coordinate.getMaxY(spectra.get(i).getXYCoords()) * spectra.get(i).getUserYFactor();
            if (!(tmp > max)) continue;
            max = tmp;
        }
        return max;
    }

    public static double getYValueAt(Coordinate[] xyCoords, double xPt, Comparator<Coordinate> c) {
        Coordinate x = new Coordinate(xPt, 0.0);
        int i = Arrays.binarySearch(xyCoords, x, c);
        if (i < 0) {
            i = -1 - i;
        }
        if (i <= 0 || i >= xyCoords.length) {
            return Double.NaN;
        }
        double x1 = xyCoords[i].getXVal();
        double x0 = xyCoords[i - 1].getXVal();
        double y1 = xyCoords[i].getYVal();
        double y0 = xyCoords[i - 1].getYVal();
        if (x1 == x0) {
            return y1;
        }
        return y0 + (y1 - y0) / (x1 - x0) * (xPt - x0);
    }

    public static int intoRange(int i, int i0, int i1) {
        return Math.max(Math.min(i, i1), i0);
    }

    public static double intoRange(double x, double x0, double x1) {
        return Math.max(Math.min(x, x1), x0);
    }

    public static int getNearestIndexForX(Coordinate[] xyCoords, double x) {
        int pt = 0;
        int i = 0;
        while (i < xyCoords.length) {
            if (xyCoords[i].getXVal() > x) {
                return pt;
            }
            ++i;
        }
        return pt;
    }
}

