/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.api.AtomIndexIterator;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelCollection;
import org.jmol.viewer.Viewer;

public class AtomIteratorWithinModel
implements AtomIndexIterator {
    protected CubeIterator cubeIterator;
    protected Bspf bspf;
    private boolean threadSafe;
    private boolean hemisphereOnly;
    private boolean isZeroBased;
    protected int modelIndex = Integer.MAX_VALUE;
    private int atomIndex = -1;
    private int zeroBase;
    private float distanceSquared;
    private BitSet bsSelected;
    private boolean isGreaterOnly;
    private boolean checkGreater;
    private RadiusData radiusData;
    private float vdw1;
    private boolean isVdw;
    private Atom[] atoms;
    private Viewer viewer;
    private int iNext;

    AtomIteratorWithinModel() {
    }

    void initialize(Bspf bspf, BitSet bitSet, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.bspf = bspf;
        this.bsSelected = bitSet;
        this.isGreaterOnly = bl;
        this.isZeroBased = bl2;
        this.hemisphereOnly = bl3;
        this.threadSafe = bl4;
        this.cubeIterator = null;
    }

    public void set(ModelCollection modelCollection, int n, int n2, int n3, Point3f point3f, float f, RadiusData radiusData) {
        if (this.threadSafe) {
            n = -1 - n;
        }
        if (n != this.modelIndex || this.cubeIterator == null) {
            this.cubeIterator = this.bspf.getCubeIterator(n);
            this.modelIndex = n;
        }
        int n4 = this.zeroBase = this.isZeroBased ? n2 : 0;
        if (f == -2.1474836E9f) {
            return;
        }
        this.atomIndex = f < 0.0f ? -1 : n3;
        boolean bl = this.isVdw = radiusData != null;
        if (this.isVdw) {
            this.radiusData = radiusData;
            this.atoms = modelCollection.atoms;
            this.viewer = modelCollection.viewer;
            f = radiusData.factorType == RadiusData.EnumType.OFFSET ? 5.0f + radiusData.value : 5.0f * radiusData.value;
            this.vdw1 = this.atoms[n3].getVanderwaalsRadiusFloat(this.viewer, radiusData.vdwType);
        }
        this.checkGreater = this.isGreaterOnly && n3 != Integer.MAX_VALUE;
        this.set(point3f, f);
    }

    public void set(Point3f point3f, float f) {
        if (this.cubeIterator == null) {
            return;
        }
        this.cubeIterator.initialize(point3f, f, this.hemisphereOnly);
        this.distanceSquared = f * f;
    }

    public boolean hasNext() {
        if (this.atomIndex >= 0) {
            while (this.cubeIterator.hasMoreElements()) {
                Atom atom = (Atom)this.cubeIterator.nextElement();
                this.iNext = atom.index;
                if (this.iNext == this.atomIndex || this.checkGreater && this.iNext <= this.atomIndex || this.bsSelected != null && !this.bsSelected.get(this.iNext)) continue;
                return true;
            }
        } else if (this.cubeIterator.hasMoreElements()) {
            Atom atom = (Atom)this.cubeIterator.nextElement();
            this.iNext = atom.index;
            return true;
        }
        this.iNext = -1;
        return false;
    }

    public int next() {
        return this.iNext - this.zeroBase;
    }

    public float foundDistance2() {
        return this.cubeIterator == null ? -1.0f : this.cubeIterator.foundDistance2();
    }

    public void addAtoms(BitSet bitSet) {
        while (this.hasNext()) {
            float f;
            int n = this.next();
            if (n < 0) continue;
            if (this.isVdw) {
                f = this.atoms[n].getVanderwaalsRadiusFloat(this.viewer, this.radiusData.vdwType) + this.vdw1;
                switch (this.radiusData.factorType) {
                    case OFFSET: {
                        f += this.radiusData.value * 2.0f;
                        break;
                    }
                    case FACTOR: {
                        f *= this.radiusData.value;
                    }
                }
                f *= f;
            } else {
                f = this.distanceSquared;
            }
            if (!(this.foundDistance2() <= f)) continue;
            bitSet.set(n);
        }
    }

    public void release() {
        if (this.cubeIterator != null) {
            this.cubeIterator.release();
            this.cubeIterator = null;
        }
    }
}

