/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export.dialog;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.viewer.FileManager;

public class FilePreview
extends JPanel
implements PropertyChangeListener {
    JCheckBox active = null;
    JCheckBox append = null;
    JFileChooser chooser = null;
    private FPPanel display = null;

    public FilePreview(JFileChooser jFileChooser, JmolAdapter jmolAdapter, boolean bl, String string) {
        this.chooser = jFileChooser;
        Box box = Box.createVerticalBox();
        this.active = new JCheckBox(GT._("Preview"), false);
        this.active.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FilePreview.this.active.isSelected()) {
                    FilePreview.this.updatePreview(FilePreview.this.chooser.getSelectedFile());
                } else {
                    FilePreview.this.updatePreview(null);
                }
            }
        });
        box.add(this.active);
        this.display = new FPPanel(jmolAdapter, string);
        this.display.setPreferredSize(new Dimension(80, 80));
        this.display.setMinimumSize(new Dimension(50, 50));
        box.add(this.display);
        if (bl) {
            this.append = new JCheckBox(GT._("Append models"), false);
            box.add(this.append);
        }
        this.add(box);
        jFileChooser.setAccessory(this);
        jFileChooser.addPropertyChangeListener(this);
    }

    public boolean isAppendSelected() {
        if (this.append != null) {
            return this.append.isSelected();
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (this.active.isSelected() && "SelectedFileChangedProperty".equals(string = propertyChangeEvent.getPropertyName())) {
            this.updatePreview((File)propertyChangeEvent.getNewValue());
        }
    }

    void updatePreview(File file) {
        String string;
        if (file == null) {
            string = "zap";
        } else {
            String string2 = file.getAbsolutePath();
            String string3 = FileManager.getLocalUrl(file);
            if (string3 != null) {
                string2 = string3;
            }
            string = " \"" + string2 + "\"";
            string = string2.indexOf(".spt") >= 0 ? "script " + string : "zap;set zoomlarge false;load " + string + " 1;select protein or dna;cartoons only;color structure;";
        }
        this.display.getViewer().evalStringQuiet(string);
    }

    private static class FPPanel
    extends JPanel {
        JmolViewer viewer;
        final Dimension currentSize = new Dimension();

        FPPanel(JmolAdapter jmolAdapter, String string) {
            this.viewer = JmolViewer.allocateViewer(this, jmolAdapter, "", null, null, "#previewOnly " + string, null);
        }

        public JmolViewer getViewer() {
            return this.viewer;
        }

        public void paint(Graphics graphics) {
            this.getSize(this.currentSize);
            this.viewer.setScreenDimension(this.currentSize.width, this.currentSize.height);
            Rectangle rectangle = new Rectangle();
            graphics.getClipBounds(rectangle);
            this.viewer.renderScreenImage((Object)graphics, this.currentSize.width, this.currentSize.height);
        }
    }
}

