/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.export.MeshData;
import org.jmol.export.__CartesianExporter;
import org.jmol.export.image.ImageCreator;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.util.ColorUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.util.Quaternion;
import org.jmol.viewer.Viewer;

public class _ObjExporter
extends __CartesianExporter {
    private static final boolean debug = false;
    private boolean surfacesOnly = false;
    private boolean normalizeUV = true;
    private BufferedWriter mtlbw;
    private FileOutputStream mtlos;
    String objFileRootName;
    File mtlFile;
    private int nMtlBytes;
    Set<Short> textures = new HashSet<Short>();
    List<String> textureFiles;
    private int sphereNum = 1;
    private int cylinderNum = 1;
    private int ellipseNum = 1;
    private int circleNum = 1;
    private int ellipsoidNum = 1;
    private int coneNum = 1;
    private int triangleNum = 1;
    private int surfaceNum = 1;
    private int currentVertexOrigin = 1;
    private int currentNormalOrigin = 1;
    private int currentTextureOrigin = 1;
    private float pixelSize;
    private final Point3f ptTemp = new Point3f();

    public _ObjExporter() {
        this.debugPrint("_WavefrontObjExporter CTOR");
        this.commentChar = "# ";
    }

    protected void debugPrint(String string) {
    }

    protected void outputFace(int[] nArray, int[] nArray2, int n) {
    }

    protected void outputCircle(Point3f point3f, Point3f point3f2, float f, short s, boolean bl) {
        this.debugPrint("outputCircle");
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        if (bl) {
            this.outputCircle1(point3f, point3f2, s, f);
        }
    }

    protected void outputCone(Point3f point3f, Point3f point3f2, float f, short s) {
        this.debugPrint("outputCone");
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        this.outputCone1(point3f, point3f2, f, s);
    }

    protected boolean outputCylinder(Point3f point3f, Point3f point3f2, Point3f point3f3, short s, byte by, float f, Point3f point3f4, Point3f point3f5, boolean bl) {
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return true;
        }
        if (point3f4 != null) {
            if (by == 2) {
                this.outputEllipse1(point3f, point3f2, point3f4, point3f5, s);
                this.tempP3.set(point3f);
                this.tempP3.sub(point3f4);
                this.tempP3.add(point3f);
                this.outputEllipse1(point3f, point3f3, this.tempP3, point3f5, s);
            }
        } else if (by == 3) {
            this.outputSphere(point3f2, f * 1.01f, s, true);
            this.outputSphere(point3f3, f * 1.01f, s, true);
        } else if (by == 2) {
            this.outputCircle1(point3f2, point3f3, s, f);
            this.outputCircle1(point3f3, point3f2, s, f);
        }
        this.outputCylinder1(point3f, point3f2, point3f3, s, by, f, point3f4, point3f5);
        return true;
    }

    protected void outputEllipsoid(Point3f point3f, Point3f[] point3fArray, short s) {
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        AxisAngle4f axisAngle4f = Quaternion.getQuaternionFrame(point3f, point3fArray[1], point3fArray[3]).toAxisAngle4f();
        float f = point3fArray[1].distance(point3f);
        float f2 = point3fArray[3].distance(point3f);
        float f3 = point3fArray[5].distance(point3f);
        this.outputEllipsoid1(point3f, f, f2, f3, axisAngle4f, s);
    }

    protected void outputSphere(Point3f point3f, float f, short s, boolean bl) {
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        this.outputEllipsoid1(point3f, f, f, f, null, s);
    }

    protected void outputTextPixel(Point3f point3f, int n) {
        this.debugPrint("outputTextPixel");
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        short s = Graphics3D.getColix(n);
        this.outputSphere(point3f, this.pixelSize, s, true);
    }

    protected void outputTriangle(Point3f point3f, Point3f point3f2, Point3f point3f3, short s) {
        this.debugPrint("outputTriangle");
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        this.outputTriangle1(point3f, point3f2, point3f3, s);
    }

    protected void outputHeader() {
        this.debugPrint("outputHeader");
        this.output("# Created by Jmol " + Viewer.getJmolVersion() + "\n");
    }

    protected void output(Tuple3f tuple3f) {
        this.debugPrint("output");
    }

    protected void drawSurface(MeshSurface meshSurface, short s) {
        int n;
        if (Logger.debugging) {
            this.debugPrint("outputSurface");
            this.debugPrint("  nVertices=" + meshSurface.vertexCount);
            if (meshSurface.normals == null) {
                this.debugPrint("  no vertex normals");
            } else {
                this.debugPrint("  nNormals=" + meshSurface.vertexCount);
            }
            if (meshSurface.polygonColixes == null) {
                this.debugPrint("  no vertex colors");
            } else {
                this.debugPrint("  nColixes=" + meshSurface.vertexCount);
            }
            this.debugPrint("  number of triangles or quads=" + meshSurface.polygonCount);
            if (meshSurface.polygonColixes == null) {
                this.debugPrint("  no face colors");
            } else {
                this.debugPrint("  nPolygonColixes=" + meshSurface.polygonCount);
            }
            if (meshSurface.bsPolygons == null) {
                this.debugPrint("  all polygons used");
            } else {
                this.debugPrint("  number of polygons used=" + meshSurface.bsPolygons.cardinality());
            }
            this.debugPrint("  solid color=" + this.g3d.getColorArgbOrGray(s));
        }
        BitSet bitSet = meshSurface.bsPolygons;
        int n2 = meshSurface.polygonCount;
        if (meshSurface.normals != null) {
            meshSurface.normalCount = meshSurface.vertexCount;
        }
        boolean bl = bitSet == null;
        int[][] nArrayArray = new int[bl ? n2 : bitSet.cardinality()][];
        int n3 = n = bl ? n2 - 1 : bitSet.nextSetBit(0);
        int n4 = 0;
        while (n3 >= 0) {
            int[] nArray;
            int[] nArray2 = meshSurface.polygonIndexes[n3];
            int n5 = n4++;
            if (meshSurface.haveQuads) {
                nArray = nArray2;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = nArray2[0];
                nArray3[1] = nArray2[1];
                nArray = nArray3;
                nArray3[2] = nArray2[2];
            }
            nArrayArray[n5] = nArray;
            n3 = bl ? n3 - 1 : bitSet.nextSetBit(n3 + 1);
        }
        MeshSurface meshSurface2 = new MeshSurface(nArrayArray, meshSurface.vertices, meshSurface.vertexCount, meshSurface.normals, 0);
        meshSurface2.vertexColixes = meshSurface.vertexColixes;
        String string = "Surface" + this.surfaceNum++;
        boolean bl2 = s != 0;
        this.addTexture(s, bl2 ? null : string);
        Point point = null;
        if (bl2) {
            this.debugPrint("outputSurface: coloring solid");
            this.debugPrint("  Omitting texture map");
        } else {
            int n6 = nArrayArray.length;
            int n7 = (int)Math.ceil(Math.sqrt(n6));
            int n8 = n6 / n7;
            if (n6 % n7 != 0) {
                ++n8;
            }
            point = new Point(n7, n8);
            this.debugPrint("  width=" + n7 + " height=" + n8 + " size = " + n7 * n8);
            File file = this.createTextureFile(string, meshSurface2, point);
            if (file == null) {
                System.out.println("Error creating texture file: " + string);
                this.textureFiles.add("Error creating texture file: " + string);
                return;
            }
            String string2 = "";
            if (!file.exists()) {
                string2 = " [Does not exist]";
            } else if (file.length() == 0L) {
                string2 = " [Empty]";
            }
            this.textureFiles.add(file.length() + " (" + n7 + "x" + n8 + ") " + file.getPath() + string2);
            this.outputMtl(" map_Kd " + file.getName() + "\n");
            this.outputMtl(" map_Ka " + file.getName() + "\n");
        }
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        matrix4f.setTranslation(new Vector3f(meshSurface.offset));
        BitSet bitSet2 = new BitSet();
        this.addMesh(string, meshSurface2, matrix4f, null, s, point, bitSet2);
    }

    boolean initializeOutput(Viewer viewer, double d, Graphics3D graphics3D, Object object) {
        this.debugPrint("initializeOutput: + output");
        boolean bl = super.initializeOutput(viewer, d, graphics3D, object);
        if (!bl) {
            this.debugPrint("End initializeOutput (error in super):");
            return false;
        }
        this.pixelSize = 0.5f / this.scalePixelsPerAngstrom;
        int n = this.fileName.lastIndexOf(".");
        if (n < 0) {
            this.debugPrint("End initializeOutput (Error creating .mtl file):");
            return false;
        }
        this.objFileRootName = this.fileName.substring(0, n);
        try {
            String string = this.objFileRootName + ".mtl";
            this.mtlFile = new File(string);
            System.out.println("_WavefrontObjExporter writing to " + this.mtlFile.getAbsolutePath());
            this.mtlos = new FileOutputStream(this.mtlFile);
            this.mtlbw = new BufferedWriter(new OutputStreamWriter(this.mtlos));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.debugPrint("End initializeOutput (" + fileNotFoundException.getMessage() + "):");
            return false;
        }
        this.outputMtl("# Created by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("\nmtllib " + this.mtlFile.getName() + "\n");
        this.textureFiles = new ArrayList<String>();
        this.debugPrint("End initializeOutput:");
        return true;
    }

    String finalizeOutput() {
        this.debugPrint("finalizeOutput");
        String string = super.finalizeOutput();
        try {
            this.mtlbw.flush();
            this.mtlbw.close();
            this.mtlos = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            if (string.startsWith("OK")) {
                return "ERROR EXPORTING MTL FILE";
            }
            return string + " and ERROR EXPORTING MTL FILE";
        }
        string = string + ", " + this.nMtlBytes + " " + this.mtlFile.getPath();
        for (String string2 : this.textureFiles) {
            string = string + ", " + string2;
        }
        this.debugPrint(string);
        this.debugPrint("End finalizeOutput:");
        return string;
    }

    private void outputMtl(String string) {
        this.nMtlBytes += string.length();
        try {
            this.mtlbw.write(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getTextureName(short s) {
        return "k" + Escape.getHexColorFromRGB(this.g3d.getColorArgbOrGray(s));
    }

    private void outputCircle1(Point3f point3f, Point3f point3f2, short s, float f) {
        MeshSurface meshSurface = MeshData.getCircleData();
        Matrix4f matrix4f = new Matrix4f();
        this.addTexture(s, null);
        String string = "Circle" + this.circleNum++;
        matrix4f.set(this.getRotationMatrix(point3f, point3f2, f));
        matrix4f.m03 = point3f.x;
        matrix4f.m13 = point3f.y;
        matrix4f.m23 = point3f.z;
        matrix4f.m33 = 1.0f;
        this.addMesh(string, meshSurface, matrix4f, matrix4f, s, null, null);
    }

    private void outputCone1(Point3f point3f, Point3f point3f2, float f, short s) {
        MeshSurface meshSurface = MeshData.getConeData();
        Matrix4f matrix4f = new Matrix4f();
        this.addTexture(s, null);
        String string = "Cone" + this.coneNum++;
        matrix4f.set(this.getRotationMatrix(point3f, point3f2, f));
        matrix4f.m03 = point3f.x;
        matrix4f.m13 = point3f.y;
        matrix4f.m23 = point3f.z;
        matrix4f.m33 = 1.0f;
        this.addMesh(string, meshSurface, matrix4f, matrix4f, s, null, null);
    }

    private boolean outputEllipse1(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, short s) {
        MeshSurface meshSurface = MeshData.getCircleData();
        Matrix4f matrix4f = new Matrix4f();
        this.addTexture(s, null);
        String string = "Ellipse" + this.ellipseNum++;
        matrix4f.set(this.getRotationMatrix(point3f, point3f2, 1.0f, point3f3, point3f4));
        matrix4f.m03 = point3f2.x;
        matrix4f.m13 = point3f2.y;
        matrix4f.m23 = point3f2.z;
        matrix4f.m33 = 1.0f;
        this.addMesh(string, meshSurface, matrix4f, matrix4f, s, null, null);
        return true;
    }

    private File createTextureFile(String string, MeshSurface meshSurface, Point point) {
        short[] sArray;
        this.debugPrint("createTextureFile: " + string);
        short[] sArray2 = sArray = meshSurface.polygonColixes == null ? meshSurface.vertexColixes : meshSurface.polygonColixes;
        if (sArray == null || sArray.length == 0) {
            this.debugPrint("createTextureFile: Array problem");
            this.debugPrint("  colixes=" + sArray + " data=" + meshSurface);
            if (sArray != null) {
                this.debugPrint("  colixes.length=" + sArray.length);
            }
            return null;
        }
        int n = meshSurface.polygonIndexes.length;
        if (n <= 0) {
            this.debugPrint("createTextureFile: nFaces = 0");
            return null;
        }
        int n2 = point.x;
        int n3 = point.y;
        String string2 = "png";
        byte[][] byArray = string2.equals("tga") ? new byte[n3 * 3][n2 * 3 * 3] : (byte[][])null;
        BufferedImage bufferedImage = byArray == null ? new BufferedImage(n2 * 3, n3 * 3, 2) : null;
        int n4 = n3 - 1;
        int n5 = 0;
        Point3f point3f = new Point3f();
        for (int i = 0; i < meshSurface.polygonIndexes.length; ++i) {
            int n6;
            if (meshSurface.polygonColixes == null) {
                int[] nArray = meshSurface.polygonIndexes[i];
                point3f.set(0.0f, 0.0f, 0.0f);
                for (int n7 : nArray) {
                    point3f.add(ColorUtil.colorPointFromInt2(this.g3d.getColorArgbOrGray(sArray[n7])));
                }
                point3f.scale(1.0f / (float)nArray.length);
                n6 = ColorUtil.colorPtToInt(point3f);
            } else {
                n6 = this.g3d.getColorArgbOrGray(sArray[i]);
            }
            if (byArray == null) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        bufferedImage.setRGB(n5 * 3 + j, n4 * 3 + k, n6);
                    }
                }
            }
            if ((n5 = (n5 + 1) % n2) != 0) continue;
            --n4;
        }
        Object object = null;
        try {
            object = this.createImage(this.objFileRootName + "_" + string + "." + string2, string2, byArray == null ? bufferedImage : (Object)byArray, n2, n3);
            if (object instanceof String) {
                string = (String)object;
            }
            this.debugPrint("End createTextureFile: " + string);
            return new File(string);
        }
        catch (Exception exception) {
            this.debugPrint("End createTextureFile (" + exception.getMessage() + "):");
            return null;
        }
    }

    private Object createImage(String string, String string2, Object object, int n, int n2) throws Exception {
        if (object instanceof Image) {
            ImageCreator imageCreator = new ImageCreator();
            imageCreator.setViewer(this.viewer, this.privateKey);
            return imageCreator.createImage(string, string2, object, Integer.MIN_VALUE);
        }
        return string;
    }

    private void outputEllipsoid1(Point3f point3f, float f, float f2, float f3, AxisAngle4f axisAngle4f, short s) {
        String string;
        MeshSurface meshSurface = MeshData.getSphereData();
        this.addTexture(s, null);
        if (point3f instanceof Atom) {
            Atom atom = (Atom)point3f;
            string = atom.getAtomName().replaceAll("\\s", "") + "_Atom";
        } else {
            string = f == f2 && f == f3 ? "Sphere" + this.sphereNum++ : "Ellipsoid" + this.ellipsoidNum++;
        }
        this.setSphereMatrix(point3f, f, f2, f3, axisAngle4f, this.sphereMatrix);
        this.addMesh(string, meshSurface, this.sphereMatrix, this.sphereMatrix, s, null, null);
    }

    private void outputCylinder1(Point3f point3f, Point3f point3f2, Point3f point3f3, short s, byte by, float f, Point3f point3f4, Point3f point3f5) {
        MeshSurface meshSurface = MeshData.getCylinderData(false);
        Matrix4f matrix4f = new Matrix4f();
        this.addTexture(s, null);
        String string = "Cylinder" + this.cylinderNum++;
        int n = point3f4 != null && by == 0 ? 2 : 1;
        for (int i = 0; i < n; ++i) {
            if (point3f4 == null) {
                matrix4f.set(this.getRotationMatrix(point3f2, point3f3, f));
            } else {
                matrix4f.set(this.getRotationMatrix(point3f, point3f3, f, point3f4, point3f5));
            }
            matrix4f.m03 = point3f2.x;
            matrix4f.m13 = point3f2.y;
            matrix4f.m23 = point3f2.z;
            matrix4f.m33 = 1.0f;
        }
        this.addMesh(string, meshSurface, matrix4f, matrix4f, s, null, null);
    }

    private void outputTriangle1(Point3f point3f, Point3f point3f2, Point3f point3f3, short s) {
        MeshSurface meshSurface = MeshData.getTriangleData(point3f, point3f2, point3f3);
        Matrix4f matrix4f = new Matrix4f();
        this.addTexture(s, null);
        String string = "Triangle" + this.triangleNum++;
        matrix4f.setIdentity();
        this.addMesh(string, meshSurface, matrix4f, matrix4f, s, null, null);
    }

    private void addTexture(short s, String string) {
        Short s2 = new Short(s);
        if (string == null && this.textures.contains(s2)) {
            return;
        }
        this.textures.add(s2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nnewmtl " + (string == null ? this.getTextureName(s) : string) + "\n");
        stringBuffer.append(" Ns 163\n");
        stringBuffer.append(" Tr " + _ObjExporter.opacityFractionalFromColix(s) + "\n");
        stringBuffer.append(" Ni 0.001\n");
        stringBuffer.append(" illum 2\n");
        stringBuffer.append(" Ka 0.20 0.20 0.20\n");
        stringBuffer.append(" Kd " + this.rgbFractionalFromColix(s, ' ') + "\n");
        stringBuffer.append(" Ks 0.25 0.25 0.25\n");
        this.outputMtl(stringBuffer.toString());
    }

    private void addMesh(String string, MeshSurface meshSurface, Matrix4f matrix4f, Matrix4f matrix4f2, short s, Point point, BitSet bitSet) {
        int n;
        int n2;
        Object object;
        if (this.surfacesOnly && (string == null || !string.startsWith("Surface"))) {
            return;
        }
        this.output("\ng " + string + "\n");
        this.output("usemtl " + (point == null ? this.getTextureName(s) : string) + "\n");
        int[][] nArray = meshSurface.getFaces();
        int n3 = nArray.length;
        if (bitSet != null) {
            object = nArray;
            n2 = ((int[][])object).length;
            for (int i = 0; i < n2; ++i) {
                int[] nArray2;
                for (int arrayList : nArray2 = object[i]) {
                    bitSet.set(arrayList);
                }
            }
        }
        object = meshSurface.getVertices();
        n2 = meshSurface.vertexCount;
        int[] nArray3 = new int[n2];
        int n5 = this.getCoordinateMap((Tuple3f[])object, nArray3, bitSet);
        this.output("# Number of vertices: " + n5 + "\n");
        this.outputList((Tuple3f[])object, n2, matrix4f, "v ", bitSet);
        n2 = n5;
        Tuple3f[] tuple3fArray = meshSurface.normals;
        int n4 = meshSurface.normalCount;
        int[] nArray2 = null;
        ArrayList<String> arrayList = null;
        if (tuple3fArray != null) {
            arrayList = new ArrayList<String>();
            nArray2 = this.getNormalMap(tuple3fArray, n4, bitSet, arrayList);
            n4 = arrayList.size();
            this.output("# Number of normals: " + n4 + "\n");
            for (n = 0; n < n4; ++n) {
                this.output("vn " + (String)arrayList.get(n));
            }
        }
        if (point != null) {
            this.output("# Number of texture coordinates: " + n3 + "\n");
            n = point.x;
            int n6 = point.y;
            int n7 = 0;
            block3: for (int i = 0; i < n6; ++i) {
                float f = (float)i + 0.5f;
                if (this.normalizeUV) {
                    f /= (float)n6;
                }
                for (int j = 0; j < n; ++j) {
                    float f2 = (float)j + 0.5f;
                    if (this.normalizeUV) {
                        f2 /= (float)n;
                    }
                    this.output("vt " + f2 + " " + f + "\n");
                    if (++n7 == n3) continue block3;
                }
            }
            if (!this.normalizeUV) {
                this.output("vt 0.0 0.0\n");
                this.output("vt " + (float)n + " " + (float)n6 + "\n");
            }
        }
        this.output("# Number of faces: " + n3 + "\n");
        for (n = 0; n < n3; ++n) {
            if (point != null) {
                this.outputFace2(nArray[n], n, nArray3, nArray2);
                continue;
            }
            this.outputFace1(nArray[n], nArray3, nArray2);
        }
        if (point != null) {
            this.currentTextureOrigin += n3;
        }
        this.currentVertexOrigin += n2;
        this.currentNormalOrigin += n4;
    }

    private void outputList(Tuple3f[] tuple3fArray, int n, Matrix4f matrix4f, String string, BitSet bitSet) {
        for (int i = 0; i < n; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            this.ptTemp.set(tuple3fArray[i]);
            if (matrix4f != null) {
                matrix4f.transform(this.ptTemp);
            }
            this.output(string + this.ptTemp.x + " " + this.ptTemp.y + " " + this.ptTemp.z + "\n");
        }
    }

    private void outputFace1(int[] nArray, int[] nArray2, int[] nArray3) {
        this.output("f");
        for (int n : nArray) {
            this.output(" " + ((nArray2 == null ? n : nArray2[n]) + this.currentVertexOrigin) + "//" + ((nArray3 == null ? n : nArray3[n]) + this.currentNormalOrigin));
        }
        this.output("\n");
    }

    private void outputFace2(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        this.output("f");
        for (int n2 : nArray) {
            this.output(" " + ((nArray2 == null ? n2 : nArray2[n2]) + this.currentVertexOrigin) + "/" + (this.currentTextureOrigin + n) + "/" + ((nArray3 == null ? n2 : nArray3[n2]) + this.currentNormalOrigin));
        }
        this.output("\n");
    }
}

