/*
 * Decompiled with CFR 0.152.
 */
package naga;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;

public class NIOUtils {
    NIOUtils() {
    }

    public static void closeKeyAndChannelSilently(SelectionKey selectionKey, Channel channel) {
        NIOUtils.closeChannelSilently(channel);
        NIOUtils.cancelKeySilently(selectionKey);
    }

    public static ByteBuffer getByteBufferFromPacketSize(int n, int n2, boolean bl) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Payload size is less than 0.");
        }
        if (n != 4 && n2 >> n * 8 > 0) {
            throw new IllegalArgumentException("Payload size cannot be encoded into " + n + " byte(s).");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        for (int i = 0; i < n; ++i) {
            int n3 = bl ? n - 1 - i : i;
            byteBuffer.put((byte)(n2 >> 8 * n3 & 0xFF));
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static int getPacketSizeFromByteBuffer(ByteBuffer byteBuffer, boolean bl) {
        long l = 0L;
        if (bl) {
            byteBuffer.rewind();
            while (byteBuffer.hasRemaining()) {
                l <<= 8;
                l += (long)(byteBuffer.get() & 0xFF);
            }
        } else {
            byteBuffer.rewind();
            int n = 0;
            while (byteBuffer.hasRemaining()) {
                l += (long)((byteBuffer.get() & 0xFF) << n);
                n += 8;
            }
        }
        return (int)l;
    }

    public static void closeChannelSilently(Channel channel) {
        try {
            if (channel != null) {
                channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void cancelKeySilently(SelectionKey selectionKey) {
        try {
            if (selectionKey != null) {
                selectionKey.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

