/*
 * Decompiled with CFR 0.152.
 */
package jspecview.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jspecview.util.ArrayUtil;
import jspecview.util.Logger;

public class ZipUtil {
    public static boolean isZipFile(InputStream is) throws IOException {
        byte[] abMagic = new byte[4];
        is.mark(5);
        int countRead = is.read(abMagic, 0, 4);
        is.reset();
        return countRead == 4 && abMagic[0] == 80 && abMagic[1] == 75 && abMagic[2] == 3 && abMagic[3] == 4;
    }

    public static boolean isZipFile(byte[] bytes) throws Exception {
        return bytes.length > 4 && bytes[0] == 80 && bytes[1] == 75 && bytes[2] == 3 && bytes[3] == 4;
    }

    /*
     * Unable to fully structure code
     */
    public static Object getZipFileContents(InputStream is, String[] list, int listPtr) {
        ret = new StringBuffer();
        if (list == null || listPtr >= list.length) {
            return ZipUtil.getZipDirectoryAsStringAndClose(is);
        }
        fileName = list[listPtr];
        zis = new ZipInputStream(is);
        try {
            isAll = fileName.equals(".");
            if (!isAll && fileName.lastIndexOf("/") != fileName.length() - 1) ** GOTO lbl21
            while ((ze = zis.getNextEntry()) != null) {
                name = ze.getName();
                if (!isAll && !name.startsWith(fileName)) continue;
                ret.append(name).append('\n');
            }
            return ret.toString();
lbl-1000:
            // 1 sources

            {
                if (!fileName.equals(ze.getName())) continue;
                bytes = ZipUtil.getZipEntryAsBytes(zis);
                if (ZipUtil.isZipFile(bytes)) {
                    return ZipUtil.getZipFileContents(new BufferedInputStream(new ByteArrayInputStream(bytes)), list, ++listPtr);
                }
                return new String(bytes);
lbl21:
                // 2 sources

                ** while ((ze = zis.getNextEntry()) != null)
            }
lbl22:
            // 1 sources

        }
        catch (Exception var7_7) {
            // empty catch block
        }
        return "";
    }

    public static byte[] getZipFileContentsAsBytes(InputStream is, String[] list, int listPtr) {
        byte[] ret = new byte[]{};
        String fileName = list[listPtr];
        if (fileName.lastIndexOf("/") == fileName.length() - 1) {
            return ret;
        }
        ZipInputStream zis = new ZipInputStream(is);
        try {
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                if (!fileName.equals(ze.getName())) continue;
                byte[] bytes = ZipUtil.getZipEntryAsBytes(zis);
                if (ZipUtil.isZipFile(bytes) && list != null && ++listPtr < list.length) {
                    return ZipUtil.getZipFileContentsAsBytes(new BufferedInputStream(new ByteArrayInputStream(bytes)), list, listPtr);
                }
                return bytes;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static String getZipDirectoryAsStringAndClose(InputStream is) {
        StringBuffer sb = new StringBuffer();
        String[] s = new String[]{};
        try {
            s = ZipUtil.getZipDirectoryOrErrorAndClose(is, false);
            is.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
        int i = 0;
        while (i < s.length) {
            sb.append(s[i]).append('\n');
            ++i;
        }
        return sb.toString();
    }

    public static String[] getZipDirectoryAndClose(InputStream is, boolean addManifest) {
        String[] s = new String[]{};
        try {
            s = ZipUtil.getZipDirectoryOrErrorAndClose(is, addManifest);
            is.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
        return s;
    }

    private static String[] getZipDirectoryOrErrorAndClose(InputStream is, boolean addManifest) throws IOException {
        ZipEntry ze;
        ArrayList<String> v = new ArrayList<String>();
        ZipInputStream zis = new ZipInputStream(is);
        String manifest = null;
        while ((ze = zis.getNextEntry()) != null) {
            String fileName = ze.getName();
            if (addManifest && fileName.equals("JmolManifest")) {
                manifest = ZipUtil.getZipEntryAsString(zis);
                continue;
            }
            v.add(fileName);
        }
        zis.close();
        if (addManifest) {
            v.add(0, manifest == null ? "" : String.valueOf(manifest) + "\n############\n");
        }
        int len = v.size();
        String[] dirList = new String[len];
        int i = 0;
        while (i < len) {
            dirList[i] = (String)v.get(i);
            ++i;
        }
        return dirList;
    }

    public static String getZipEntryAsString(ZipInputStream zis) throws IOException {
        int len;
        StringBuffer sb = new StringBuffer();
        byte[] buf = new byte[1024];
        while (zis.available() == 1 && (len = zis.read(buf)) > 0) {
            sb.append(new String(buf, 0, len));
        }
        return sb.toString();
    }

    public static byte[] getZipEntryAsBytes(ZipInputStream zis) throws IOException {
        byte[] buf = new byte[1024];
        byte[] bytes = new byte[4096];
        int len = 0;
        int totalLen = 0;
        while (zis.available() == 1 && (len = zis.read(buf)) > 0) {
            if ((totalLen += len) >= bytes.length) {
                bytes = ArrayUtil.ensureLength(bytes, totalLen * 2);
            }
            System.arraycopy(buf, 0, bytes, totalLen - len, len);
        }
        buf = new byte[totalLen];
        System.arraycopy(bytes, 0, buf, 0, totalLen);
        return buf;
    }

    public static byte[] getStreamAsBytes(BufferedInputStream bis) throws IOException {
        byte[] buf = new byte[1024];
        byte[] bytes = new byte[4096];
        int len = 0;
        int totalLen = 0;
        while ((len = bis.read(buf)) > 0) {
            if ((totalLen += len) >= bytes.length) {
                bytes = ArrayUtil.ensureLength(bytes, totalLen * 2);
            }
            System.arraycopy(buf, 0, bytes, totalLen - len, len);
        }
        buf = new byte[totalLen];
        System.arraycopy(bytes, 0, buf, 0, totalLen);
        return buf;
    }
}

