/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import jspecview.common.Graph;
import jspecview.util.Parser;

public class PeakInfo {
    public static final PeakInfo nullPeakInfo = new PeakInfo();
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private String stringInfo;
    private String type;
    private String type2;
    private String index;
    private String file;
    private String title;
    private String model;
    private String atoms;
    public Graph spectrum;
    private String _match;

    public PeakInfo() {
    }

    public PeakInfo(String s) {
        this.stringInfo = s;
        this.type = Parser.getQuotedAttribute(s, "type");
        if (this.type == null) {
            this.type = "";
        }
        this.type = this.type.toUpperCase();
        int pt = this.type.indexOf(47);
        this.type2 = pt < 0 ? "" : PeakInfo.fixType(this.type.substring(this.type.indexOf(47) + 1));
        this.type = pt >= 0 ? String.valueOf(PeakInfo.fixType(this.type.substring(0, pt))) + "/" + this.type2 : PeakInfo.fixType(this.type);
        this.index = Parser.getQuotedAttribute(s, "index");
        this.file = Parser.getQuotedAttribute(s, "file");
        this.model = Parser.getQuotedAttribute(s, "model");
        boolean isBaseModel = s.contains("baseModel=\"\"");
        if (!isBaseModel) {
            this.atoms = Parser.getQuotedAttribute(s, "atoms");
        }
        this.title = Parser.getQuotedAttribute(s, "title");
        this._match = Parser.getQuotedAttribute(s, "_match");
        this.xMax = Parser.parseFloat(Parser.getQuotedAttribute(s, "xMax"));
        this.xMin = Parser.parseFloat(Parser.getQuotedAttribute(s, "xMin"));
        this.yMax = Parser.parseFloat(Parser.getQuotedAttribute(s, "yMax"));
        this.yMin = Parser.parseFloat(Parser.getQuotedAttribute(s, "yMin"));
    }

    public boolean isClearAll() {
        return this.spectrum == null;
    }

    public String getType() {
        return this.type;
    }

    public String getAtoms() {
        return this.atoms;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getX() {
        return (this.xMax + this.xMin) / 2.0;
    }

    public String getMatch() {
        return this._match;
    }

    private static String fixType(String type) {
        return type.equals("HNMR") ? "1HNMR" : (type.equals("CNMR") ? "13CNMR" : type);
    }

    public String toString() {
        return this.stringInfo;
    }

    public String getIndex() {
        return this.index;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean checkFileIndex(String filePath, String sIndex) {
        return sIndex.equals(this.index) && filePath.equals(this.file);
    }

    public boolean checkTypeModel(String type, String model) {
        return this.checkType(type) && this.checkModel(model);
    }

    private boolean checkModel(String model) {
        return model != null && model.equals(this.model);
    }

    private boolean checkType(String type) {
        return type.endsWith(this.type);
    }

    public boolean checkTypeMatch(PeakInfo pi) {
        return this.checkType(pi.type) && (this.checkModel(pi._match) || this.title.toUpperCase().indexOf(pi._match) >= 0);
    }

    public String getModel() {
        return this.model;
    }

    public String getFilePath() {
        return this.file;
    }

    public boolean autoSelectOnLoad() {
        return this.type.startsWith("GC");
    }
}

