/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.ArrayList;
import java.util.List;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVContainer;
import jspecview.common.JSVDialog;
import jspecview.common.JSVPanel;
import jspecview.common.ScriptToken;
import jspecview.source.JDXSource;
import jspecview.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSVSpecNode {
    public Object treeNode;
    public JDXSource source;
    public String fileName;
    public JSVContainer frame;
    public JSVPanel jsvp;
    public String id;
    public JSVDialog legend;

    public void setTreeNode(Object node) {
        this.treeNode = node;
    }

    public Object getTreeNode() {
        return this.treeNode;
    }

    public void dispose() {
        this.source.dispose();
        this.jsvp.dispose();
        this.source = null;
        this.jsvp = null;
        this.legend = null;
    }

    public JDXSpectrum getSpectrum() {
        return this.jsvp.getSpectrum();
    }

    public JSVDialog setLegend(JSVDialog legend) {
        if (this.legend != null) {
            this.legend.dispose();
        }
        this.legend = legend;
        return legend;
    }

    public JSVSpecNode(String id, String fileName, JDXSource source, JSVContainer frame, JSVPanel jsvp) {
        this.id = id;
        this.source = source;
        this.fileName = fileName;
        this.frame = frame;
        this.jsvp = jsvp;
        if (jsvp != null) {
            jsvp.getSpectrumAt(0).setId(id);
        }
    }

    public String toString() {
        return String.valueOf(this.id == null ? "" : String.valueOf(this.id) + ": ") + (this.frame == null ? this.fileName : this.frame.getTitle());
    }

    public static JDXSource findSourceByNameOrId(String id, List<JSVSpecNode> specNodes) {
        JSVSpecNode node;
        int i = specNodes.size();
        while (--i >= 0) {
            node = specNodes.get(i);
            if (!id.equals(node.id) && !id.equalsIgnoreCase(node.source.getFilePath())) continue;
            return node.source;
        }
        i = specNodes.size();
        while (--i >= 0) {
            node = specNodes.get(i);
            if (!id.equals(node.fileName)) continue;
            return node.source;
        }
        return null;
    }

    public static JSVSpecNode findNodeById(String id, List<JSVSpecNode> specNodes) {
        int i = specNodes.size();
        while (--i >= 0) {
            if (!id.equals(specNodes.get((int)i).id)) continue;
            return specNodes.get(i);
        }
        return null;
    }

    public static JDXSpectrum findSpectrumById(String id, List<JSVSpecNode> specNodes) {
        int i = specNodes.size();
        while (--i >= 0) {
            if (!id.equals(specNodes.get((int)i).id)) continue;
            return specNodes.get((int)i).jsvp.getSpectrumAt(0);
        }
        return null;
    }

    public static JSVSpecNode findNode(JSVPanel jsvp, List<JSVSpecNode> specNodes) {
        int i = specNodes.size();
        while (--i >= 0) {
            if (specNodes.get((int)i).jsvp != jsvp) continue;
            return specNodes.get(i);
        }
        return null;
    }

    public static JSVSpecNode findNode(Object frame, List<JSVSpecNode> specNodes) {
        int i = specNodes.size();
        while (--i >= 0) {
            if (specNodes.get((int)i).frame != frame) continue;
            return specNodes.get(i);
        }
        return null;
    }

    public static String fillSpecList(List<JSVSpecNode> specNodes, String value, List<JDXSpectrum> speclist, JSVPanel selectedPanel, String prefix) {
        List<String> list;
        List<String> list0 = null;
        boolean isNone = value.equalsIgnoreCase("NONE");
        if (isNone || value.equalsIgnoreCase("all")) {
            value = "*";
        }
        if ((value = TextFormat.simpleReplace(value, "*", " * ")).equals(" * ")) {
            list = ScriptToken.getTokens(JSVSpecNode.getSpectrumListAsString(specNodes));
        } else if (value.startsWith("\"")) {
            list = ScriptToken.getTokens(value);
        } else {
            value = TextFormat.simpleReplace(value, "-", " - ");
            list = ScriptToken.getTokens(value);
            list0 = ScriptToken.getTokens(JSVSpecNode.getSpectrumListAsString(specNodes));
            if (list0.size() == 0) {
                return null;
            }
        }
        String id0 = selectedPanel == null ? prefix : JSVSpecNode.findNode((JSVPanel)selectedPanel, specNodes).id;
        id0 = id0.substring(0, id0.indexOf(".") + 1);
        StringBuffer sb = new StringBuffer();
        int n = list.size();
        String idLast = null;
        int i = 0;
        while (i < n) {
            String id = list.get(i);
            double userYFactor = 1.0;
            if (i + 1 < n && list.get(i + 1).equals("*")) {
                i += 2;
                try {
                    userYFactor = Double.parseDouble(list.get(i));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (id.equals("-")) {
                if (idLast == null) {
                    idLast = list0.get(0);
                }
                String string = id = i + 1 == n ? list0.get(list0.size() - 1) : list.get(++i);
                if (!id.contains(".")) {
                    id = String.valueOf(id0) + id;
                }
                int pt = 0;
                while (pt < list0.size() && !list0.get(pt).equals(idLast)) {
                    ++pt;
                }
                ++pt;
                while (pt < list0.size() && !idLast.equals(id)) {
                    idLast = list0.get(pt++);
                    speclist.add(JSVSpecNode.findSpectrumById(idLast, specNodes));
                    sb.append(",").append(idLast);
                }
            } else {
                JDXSpectrum spec;
                if (!id.contains(".")) {
                    id = String.valueOf(id0) + id;
                }
                if ((spec = JSVSpecNode.findSpectrumById(id, specNodes)) != null) {
                    idLast = id;
                    spec.setUserYFactor(userYFactor);
                    speclist.add(spec);
                    sb.append(",").append(id);
                }
            }
            ++i;
        }
        return isNone ? "NONE" : (sb.length() > 0 ? sb.toString().substring(1) : null);
    }

    public static String getSpectrumListAsString(List<JSVSpecNode> specNodes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < specNodes.size()) {
            sb.append(" ").append(specNodes.get((int)i).id);
            ++i;
        }
        return sb.toString().trim();
    }

    public static List<JDXSpectrum> getSpecList(List<JSVSpecNode> specNodes) {
        if (specNodes == null || specNodes.size() == 0) {
            return null;
        }
        ArrayList<JDXSpectrum> specList = new ArrayList<JDXSpectrum>();
        int i = 0;
        while (i < specNodes.size()) {
            specList.add(specNodes.get(i).getSpectrum());
            ++i;
        }
        return specList;
    }

    public static boolean isOpen(List<JSVSpecNode> specNodes, String filePath) {
        if (filePath != null) {
            int i = specNodes.size();
            while (--i >= 0) {
                if (!filePath.equals(specNodes.get((int)i).source.getFilePath())) continue;
                return true;
            }
        }
        return false;
    }

    public static int getNodeIndex(List<JSVSpecNode> specNodes, JSVSpecNode node) {
        int i = specNodes.size();
        while (--i >= 0) {
            if (node != specNodes.get(i)) continue;
            return i;
        }
        return -1;
    }
}

