/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import jspecview.common.ScriptInterface;

public class CommandHistory {
    private ScriptInterface scripter;
    private JTextField input;
    private List<String> cmdList = new ArrayList<String>();
    private int cmdPt = -1;
    private int cmdOffset = 0;

    public CommandHistory(ScriptInterface scriptInterface, JTextField commandInput) {
        this.scripter = scriptInterface;
        this.input = commandInput;
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case 27: {
                this.input.setText("");
                return;
            }
            case 10: {
                String cmd = this.input.getText();
                this.addCommand(cmd);
                this.scripter.runScript(cmd);
                this.input.setText("");
                this.input.requestFocusInWindow();
                return;
            }
            case 38: 
            case 40: {
                String s = this.recallCommand(keyCode == 38);
                if (s == null) break;
                this.input.setText(s);
            }
        }
    }

    private synchronized String recallCommand(boolean isPrevious) {
        int n;
        this.cmdOffset = 0;
        if (isPrevious) {
            if (this.cmdPt < 0 || this.cmdPt == this.cmdList.size()) {
                return "";
            }
            this.cmdOffset = -1;
        } else {
            if (this.cmdPt <= 0) {
                return "";
            }
            if (--this.cmdPt < 0) {
                this.cmdPt = 0;
            }
        }
        if (isPrevious) {
            int n2 = this.cmdPt;
            n = n2;
            this.cmdPt = n2 + 1;
        } else {
            n = this.cmdPt;
        }
        String cmd = this.cmdList.get(n);
        return cmd;
    }

    private void addCommand(String cmd) {
        this.cmdPt += this.cmdOffset;
        this.cmdOffset = 0;
        if (this.cmdPt < 0) {
            this.cmdPt = 0;
        }
        if (this.cmdPt < this.cmdList.size() && this.cmdList.get(this.cmdPt).equals(cmd)) {
            return;
        }
        this.cmdList.add(this.cmdPt, cmd);
    }

    void dumpList() {
        int i = 0;
        while (i < this.cmdList.size()) {
            System.out.println(String.valueOf(i == this.cmdPt ? ">" : "") + i + "\t" + this.cmdList.get(i));
            ++i;
        }
        System.out.println("");
    }
}

