/*
 * Decompiled with CFR 0.152.
 */
package jspecview.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;

public class SimpleXmlReader {
    private XmlEvent thisEvent = new XmlEvent(0);
    private Buffer buffer;
    public static final int TAG_NONE = 0;
    public static final int START_ELEMENT = 1;
    public static final int END_ELEMENT = 2;
    public static final int START_END_ELEMENT = 3;
    public static final int CHARACTERS = 4;
    public static final int COMMENT = 6;
    public static final int EOF = 8;

    public SimpleXmlReader(BufferedReader br) {
        this.buffer = new Buffer(br);
    }

    public String getBufferData() {
        return this.buffer == null ? null : this.buffer.data.substring(0, this.buffer.ptr);
    }

    public String thisValue() throws IOException {
        return this.buffer.nextEvent().toString().trim();
    }

    public String qualifiedValue() throws IOException {
        this.buffer.nextTag();
        String value = this.buffer.nextEvent().toString().trim();
        this.buffer.nextTag();
        return value;
    }

    public int peek() throws IOException {
        this.thisEvent = this.buffer.peek();
        return this.thisEvent.getEventType();
    }

    public boolean hasNext() {
        return this.buffer.hasNext();
    }

    public void nextTag() throws IOException {
        while ((this.thisEvent = this.buffer.nextTag()).eventType == 6) {
        }
    }

    public int nextEvent() throws IOException {
        this.thisEvent = this.buffer.nextEvent();
        return this.thisEvent.getEventType();
    }

    public void nextStartTag() throws IOException {
        this.thisEvent = this.buffer.nextTag();
        while (!this.thisEvent.isStartElement()) {
            this.thisEvent = this.buffer.nextTag();
        }
    }

    public String getTagName() {
        return this.thisEvent.getTagName();
    }

    public int getTagType() {
        return this.thisEvent.getTagType();
    }

    public String getEndTag() {
        return this.thisEvent.getTagName();
    }

    public String nextValue() throws IOException {
        this.buffer.nextTag();
        return this.buffer.nextEvent().toString().trim();
    }

    public String getAttributeList() {
        return this.thisEvent.toString().toLowerCase();
    }

    public String getAttrValueLC(String key) {
        return this.getAttrValue(key).toLowerCase();
    }

    public String getAttrValue(String name) {
        String a = this.thisEvent.getAttributeByName(name);
        return a == null ? "" : a;
    }

    public String getCharacters() throws IOException {
        StringBuffer sb = new StringBuffer();
        this.thisEvent = this.buffer.peek();
        int eventType = this.thisEvent.getEventType();
        while (eventType != 4) {
            this.thisEvent = this.buffer.nextEvent();
        }
        while (eventType == 4) {
            this.thisEvent = this.buffer.nextEvent();
            eventType = this.thisEvent.getEventType();
            if (eventType != 4) continue;
            sb.append(this.thisEvent.toString());
        }
        return sb.toString();
    }

    public boolean requiresEndTag() {
        int tagType = this.thisEvent.getTagType();
        return tagType != 3 && tagType != 6;
    }

    private class Buffer
    extends DataString {
        Buffer(BufferedReader br) {
            this.reader = br;
        }

        boolean hasNext() {
            if (this.ptr == this.ptEnd) {
                try {
                    this.readLine();
                }
                catch (IOException e) {
                    return false;
                }
            }
            return this.ptr < this.ptEnd;
        }

        public boolean readLine() throws IOException {
            String s = this.reader.readLine();
            if (s == null) {
                return false;
            }
            this.data.append(String.valueOf(s) + "\n");
            this.ptEnd = this.data.length();
            return true;
        }

        XmlEvent peek() throws IOException {
            if (this.ptEnd - this.ptr < 2) {
                try {
                    this.readLine();
                }
                catch (IOException e) {
                    return new XmlEvent(8);
                }
            }
            int pt0 = this.ptr;
            XmlEvent e = new XmlEvent(this);
            this.ptr = pt0;
            return e;
        }

        XmlEvent nextTag() throws IOException {
            this.flush();
            this.skipTo('<', false);
            XmlEvent e = new XmlEvent(this);
            return e;
        }

        XmlEvent nextEvent() throws IOException {
            this.flush();
            return new XmlEvent(this);
        }
    }

    private class DataString {
        StringBuffer data;
        protected BufferedReader reader;
        int ptr;
        int ptEnd;

        DataString() {
            this.data = new StringBuffer();
        }

        DataString(StringBuffer data) {
            this.data = data;
            this.ptEnd = data.length();
        }

        int getNCharactersRemaining() {
            return this.ptEnd - this.ptr;
        }

        protected void flush() {
            if (this.data.length() < 1000 || this.ptEnd - this.ptr > 100) {
                return;
            }
            this.data = new StringBuffer(this.data.substring(this.ptr));
            this.ptr = 0;
            this.ptEnd = this.data.length();
        }

        String substring(int i, int j) {
            return this.data.substring(i, j);
        }

        int skipOver(char c, boolean inQuotes) throws IOException {
            if (this.skipTo(c, inQuotes) > 0 && this.ptr != this.ptEnd) {
                ++this.ptr;
            }
            return this.ptr;
        }

        int skipTo(char toWhat, boolean inQuotes) throws IOException {
            char ch;
            if (this.data == null) {
                return -1;
            }
            if (this.ptr == this.ptEnd) {
                if (this.reader == null) {
                    return -1;
                }
                this.readLine();
            }
            int ptEnd1 = this.ptEnd - 1;
            while (this.ptr < this.ptEnd && (ch = this.data.charAt(this.ptr)) != toWhat) {
                if (inQuotes && ch == '\\' && this.ptr < ptEnd1) {
                    ch = this.data.charAt(this.ptr + 1);
                    if (ch == '\"' || ch == '\\') {
                        ++this.ptr;
                    }
                } else if (ch == '\"') {
                    ++this.ptr;
                    if (this.skipTo('\"', true) < 0) {
                        return -1;
                    }
                }
                if (++this.ptr != this.ptEnd) continue;
                if (this.reader == null) {
                    return -1;
                }
                this.readLine();
            }
            return this.ptr;
        }

        public boolean readLine() throws IOException {
            return false;
        }
    }

    class Tag {
        int tagType;
        String name;
        String text;
        private Hashtable<String, String> attributes;

        Tag() {
        }

        Tag(String fulltag) {
            this.text = fulltag;
            this.tagType = fulltag.startsWith("<!--") ? 6 : (fulltag.charAt(1) == '/' ? 2 : (fulltag.charAt(fulltag.length() - 2) == '/' ? 3 : 1));
        }

        String getName() {
            if (this.name != null) {
                return this.name;
            }
            int ptTemp = this.tagType == 2 ? 2 : 1;
            int n = this.text.length() - (this.tagType == 3 ? 2 : 1);
            while (ptTemp < n && Character.isWhitespace(this.text.charAt(ptTemp))) {
                ++ptTemp;
            }
            int pt0 = ptTemp;
            while (ptTemp < n && !Character.isWhitespace(this.text.charAt(ptTemp))) {
                ++ptTemp;
            }
            this.name = this.text.substring(pt0, ptTemp).toLowerCase().trim();
            return this.name;
        }

        String getAttributeByName(String attrName) {
            if (this.attributes == null) {
                this.getAttributes();
            }
            return this.attributes.get(attrName.toLowerCase());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void getAttributes() {
            this.attributes = new Hashtable();
            DataString d = new DataString(new StringBuffer(this.text));
            try {
                if (d.skipTo(' ', false) < 0) {
                    return;
                }
                while (true) {
                    int pt0 = ++d.ptr;
                    if (d.ptr < 0) {
                        return;
                    }
                    if (d.skipTo('=', false) < 0) {
                        return;
                    }
                    String name = d.substring(pt0, d.ptr).trim().toLowerCase();
                    d.skipTo('\"', false);
                    pt0 = ++d.ptr;
                    d.skipTo('\"', true);
                    String attr = d.substring(pt0, d.ptr);
                    this.attributes.put(name, attr);
                    int pt1 = name.indexOf(":");
                    if (pt1 < 0) continue;
                    name = name.substring(pt1).trim();
                    this.attributes.put(name, attr);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class XmlEvent {
        private int eventType = 0;
        private int ptr = 0;
        private Tag tag;
        private String data;

        public String toString() {
            return this.data != null ? this.data : (this.tag != null ? this.tag.text : null);
        }

        XmlEvent(int eventType) {
            this.eventType = eventType;
        }

        XmlEvent(Buffer b) throws IOException {
            this.ptr = b.ptr;
            int n = b.getNCharactersRemaining();
            int n2 = n == 0 ? 8 : (n == 1 || b.data.charAt(b.ptr) != '<' ? 4 : (this.eventType = b.data.charAt(b.ptr + 1) != '/' ? 1 : 2));
            if (this.eventType == 8) {
                return;
            }
            if (this.eventType == 4) {
                b.skipTo('<', false);
                this.data = b.data.toString().substring(this.ptr, b.ptr);
            } else {
                b.skipOver('>', false);
                String s = b.data.substring(this.ptr, b.ptr);
                if (s.startsWith("<!--")) {
                    this.eventType = 6;
                }
                this.tag = new Tag(s);
            }
        }

        public int getEventType() {
            return this.eventType;
        }

        boolean isStartElement() {
            return (this.eventType & 1) != 0;
        }

        public String getTagName() {
            return this.tag == null ? null : this.tag.getName();
        }

        public int getTagType() {
            return this.tag == null ? 0 : this.tag.tagType;
        }

        public String getAttributeByName(String name) {
            return this.tag == null ? null : this.tag.getAttributeByName(name);
        }
    }
}

