/*
 * Decompiled with CFR 0.152.
 */
package jspecview.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import jspecview.util.Logger;
import jspecview.util.MonitorInputStream;
import jspecview.util.TextFormat;
import jspecview.util.ZipFileSequentialReader;
import jspecview.util.ZipUtil;

public class FileManager {
    private URL appletDocumentBase;
    private String openErrorMessage;
    private static final String[] urlPrefixes = new String[]{"http:", "https:", "ftp:", "file:"};

    public FileManager(URL appletDocumentBase) {
        this.appletDocumentBase = appletDocumentBase;
    }

    public String getFileAsString(String name) throws IOException {
        String line;
        if (name == null) {
            throw new IOException("name is null");
        }
        BufferedReader br = FileManager.getBufferedReaderFromName(name, this.appletDocumentBase, null);
        StringBuffer sb = new StringBuffer(8192);
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        br.close();
        return sb.toString();
    }

    public static BufferedReader getBufferedReaderForInputStream(InputStream in) throws IOException {
        return new BufferedReader(new InputStreamReader(in));
    }

    public static BufferedReader getBufferedReaderForString(String data) {
        return data == null ? null : new BufferedReader(new StringReader(data));
    }

    public static BufferedReader getBufferedReaderFromName(String name, URL appletDocumentBase, String startCode) throws MalformedURLException, IOException {
        if (name == null) {
            throw new IOException("Cannot find " + name);
        }
        String path = FileManager.classifyName(name, appletDocumentBase);
        return FileManager.getUnzippedBufferedReaderFromName(path, appletDocumentBase, startCode);
    }

    public static String classifyName(String name, URL appletDocumentBase) throws MalformedURLException {
        if (appletDocumentBase != null) {
            if (name.indexOf(":\\") == 1 || name.indexOf(":/") == 1) {
                name = "file:///" + name;
            }
            URL url = new URL(appletDocumentBase, name);
            return url.toString();
        }
        if (FileManager.isURL(name)) {
            URL url = new URL(name);
            return url.toString();
        }
        File file = new File(name);
        return file.getAbsolutePath();
    }

    public static boolean isURL(String name) {
        String[] stringArray = urlPrefixes;
        int n = urlPrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (name.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static BufferedReader getUnzippedBufferedReaderFromName(String name, URL appletDocumentBase, String startCode) throws IOException {
        InputStream in;
        BufferedInputStream bis;
        String[] subFileList = null;
        if (name.indexOf("|") >= 0 && (subFileList = TextFormat.split(name, "|")) != null && subFileList.length > 0) {
            name = subFileList[0];
        }
        if (FileManager.isGzip(bis = new BufferedInputStream(in = FileManager.getInputStream(name, true, appletDocumentBase), 8192))) {
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(bis)));
        }
        if (ZipUtil.isZipFile(bis)) {
            return new ZipFileSequentialReader(bis, subFileList, startCode);
        }
        return new BufferedReader(new InputStreamReader(bis));
    }

    private static boolean isGzip(InputStream is) throws IOException {
        byte[] abMagic = new byte[4];
        is.mark(5);
        int countRead = is.read(abMagic, 0, 4);
        is.reset();
        return countRead == 4 && abMagic[0] == 31 && abMagic[1] == -117;
    }

    public static InputStream getInputStream(String name, boolean showMsg, URL appletDocumentBase) throws IOException, MalformedURLException {
        InputStream in;
        int length;
        boolean isApplet;
        int iurlPrefix = urlPrefixes.length;
        while (--iurlPrefix >= 0) {
            if (name.startsWith(urlPrefixes[iurlPrefix])) break;
        }
        boolean isURL = iurlPrefix >= 0;
        boolean bl = isApplet = appletDocumentBase != null;
        if (isApplet || isURL) {
            URL url = isApplet ? new URL(appletDocumentBase, name) : new URL(name);
            name = url.toString();
            if (showMsg) {
                Logger.info("FileManager opening URL " + url.toString());
            }
            URLConnection conn = url.openConnection();
            length = conn.getContentLength();
            in = conn.getInputStream();
        } else {
            if (showMsg) {
                Logger.info("FileManager opening file " + name);
            }
            File file = new File(name);
            length = (int)file.length();
            in = new FileInputStream(file);
        }
        return new MonitorInputStream(in, length);
    }

    public URL getResource(Object object, String fileName, boolean flagError) {
        URL url = null;
        try {
            url = object.getClass().getResource("resources/" + fileName);
            if (url == null && flagError) {
                this.openErrorMessage = "Couldn't find file: " + fileName;
            }
        }
        catch (Exception e) {
            this.openErrorMessage = "Exception " + e.getMessage() + " in getResource " + fileName;
        }
        return url;
    }

    public String getResourceString(Object object, String name, boolean flagError) {
        URL url = this.getResource(object, name, flagError);
        if (url == null) {
            this.openErrorMessage = "Error loading resource " + name;
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)url.getContent()));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
        }
        catch (Exception e) {
            this.openErrorMessage = e.getMessage();
        }
        String str = sb.toString();
        return str;
    }

    public String getErrorMessage() {
        return this.openErrorMessage;
    }

    public static String getJmolFilePath(String filePath, URL appletDocumentBase) {
        try {
            filePath = FileManager.classifyName(filePath, appletDocumentBase);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return appletDocumentBase == null ? filePath.replace('\\', '/') : filePath;
    }

    public static String getName(String file) {
        try {
            if (FileManager.isURL(file)) {
                String name = new URL(file).getFile();
                return name.substring(name.lastIndexOf(47) + 1);
            }
            return new File(file).getName();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

