/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.List;
import jspecview.common.Coordinate;
import jspecview.common.Graph;
import jspecview.common.JDXSpectrum;
import jspecview.common.ScaleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiScaleData
extends ScaleData {
    public int[] startDataPointIndices;
    public int[] endDataPointIndices;
    public int[] numOfPointsList;
    public double minY2D;
    public double maxY2D;

    public MultiScaleData(MultiScaleData data) {
        super(data);
        this.startDataPointIndices = data.startDataPointIndices;
        this.endDataPointIndices = data.endDataPointIndices;
        this.numOfPointsList = data.numOfPointsList;
        this.minY2D = data.minY2D;
        this.maxY2D = data.maxY2D;
    }

    public MultiScaleData(List<JDXSpectrum> spectra, double yPt1, double yPt2, int[] startList, int[] endList, int initNumXDivisions, int initNumYDivisions, boolean isContinuous) {
        super(Coordinate.getMinX(spectra, startList, endList), Coordinate.getMaxX(spectra, startList, endList), Coordinate.getMinYUser(spectra, startList, endList), Coordinate.getMaxYUser(spectra, startList, endList));
        this.startDataPointIndices = startList;
        this.endDataPointIndices = endList;
        this.numOfPointsList = new int[startList.length];
        int j = 0;
        while (j < startList.length) {
            this.numOfPointsList[j] = endList[j] - startList[j] + 1;
            ++j;
        }
        this.init(yPt1, yPt2, initNumXDivisions, initNumYDivisions, isContinuous);
    }

    public MultiScaleData(List<JDXSpectrum> spectra, double yPt1, double yPt2, int initNumXDivisions, int initNumYDivisions, boolean isContinuous) {
        super(Coordinate.getMinX(spectra), Coordinate.getMaxX(spectra), Coordinate.getMinYUser(spectra), Coordinate.getMaxYUser(spectra));
        int n = spectra.get(0).getXYCoords().length - 1;
        this.startDataPointIndices = new int[1];
        this.endDataPointIndices = new int[]{n - 1};
        this.numOfPointsList = new int[]{n};
        this.init(yPt1, yPt2, initNumXDivisions, initNumYDivisions, isContinuous);
    }

    private void init(double yPt1, double yPt2, int initNumXDivisions, int initNumYDivisions, boolean isContinuous) {
        if (yPt1 != yPt2) {
            this.minY = yPt1;
            this.maxY = yPt2;
            if (this.minY > this.maxY) {
                double t = this.minY;
                this.minY = this.maxY;
                this.maxY = t;
            }
        }
        this.setScale(initNumXDivisions, initNumYDivisions, isContinuous);
    }

    public boolean setDataPointIndices(List<JDXSpectrum> graphsTemp, double initX, double finalX, int minPoints, int[] startIndices, int[] endIndices, boolean useRange) {
        int nSpectraOK = 0;
        int nSpectra = graphsTemp.size();
        int i = 0;
        while (i < nSpectra) {
            int iEnd;
            Coordinate[] xyCoords = graphsTemp.get(i).getXYCoords();
            int iStart = useRange ? this.startDataPointIndices[i] : 0;
            int n = iEnd = useRange ? this.endDataPointIndices[i] : xyCoords.length - 1;
            if (MultiScaleData.setXRange(i, xyCoords, initX, finalX, iStart, iEnd, startIndices, endIndices) >= minPoints) {
                ++nSpectraOK;
            }
            ++i;
        }
        return nSpectraOK == nSpectra;
    }

    private static int setXRange(int i, Coordinate[] xyCoords, double initX, double finalX, int iStart, int iEnd, int[] startIndices, int[] endIndices) {
        double x;
        int index = 0;
        int ptCount = 0;
        index = iStart;
        while (index <= iEnd) {
            x = xyCoords[index].getXVal();
            if (x >= initX) {
                startIndices[i] = index;
                break;
            }
            ++index;
        }
        while (index <= iEnd) {
            x = xyCoords[index].getXVal();
            ++ptCount;
            if (x >= finalX) break;
            ++index;
        }
        endIndices[i] = index - 1;
        return ptCount;
    }

    public void setXRange(Graph graph) {
        int n = graph.getXYCoords().length - 1;
        this.startDataPointIndices[0] = 0;
        this.endDataPointIndices[0] = n;
        MultiScaleData.setXRange(0, graph.getXYCoords(), this.minX, this.maxX, 0, n, this.startDataPointIndices, this.endDataPointIndices);
    }

    public void setXRange(double x1, double x2, int initNumXDivisions) {
        this.minX = x1;
        this.maxX = x2;
        this.setXScale(initNumXDivisions);
    }

    public boolean isYZeroOnScale() {
        return this.minYOnScale < 0.0 && this.maxYOnScale > 0.0;
    }

    public void setMinMaxY2D(List<JDXSpectrum> subspectra) {
        this.minY2D = Double.MAX_VALUE;
        this.maxY2D = -1.7976931348623157E308;
        int i = subspectra.size();
        while (--i >= 0) {
            double d = subspectra.get(i).getY2D();
            if (d < this.minY2D) {
                this.minY2D = d;
                continue;
            }
            if (!(d > this.maxY2D)) continue;
            this.maxY2D = d;
        }
    }
}

