/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.PanelData;
import jspecview.common.ScriptInterface;
import jspecview.common.ScriptToken;
import jspecview.util.Parser;

public class JSVPanelPopupMenu
extends JPopupMenu {
    protected boolean isApplet;
    private static final long serialVersionUID = 1L;
    private ScriptInterface scripter;
    public JMenuItem nextMenuItem = new JMenuItem();
    public JMenuItem previousMenuItem = new JMenuItem();
    public JMenuItem clearMenuItem = new JMenuItem();
    public JMenuItem resetMenuItem = new JMenuItem();
    public JMenuItem properties = new JMenuItem();
    protected JMenuItem userZoomMenuItem = new JMenuItem();
    protected JMenuItem scriptMenuItem = new JMenuItem();
    public JMenuItem overlayMenuItem = new JMenuItem();
    public JMenuItem overlayAllMenuItem = new JMenuItem();
    public JMenuItem overlayNoneMenuItem = new JMenuItem();
    public JMenuItem overlayStackOffsetMenuItem = new JMenuItem();
    public JMenuItem integrateMenuItem = new JCheckBoxMenuItem();
    public JMenuItem transAbsMenuItem = new JMenuItem();
    public JMenuItem solColMenuItem = new JMenuItem();
    public JCheckBoxMenuItem gridCheckBoxMenuItem = new JCheckBoxMenuItem();
    public JCheckBoxMenuItem coordsCheckBoxMenuItem = new JCheckBoxMenuItem();
    public JCheckBoxMenuItem reversePlotCheckBoxMenuItem = new JCheckBoxMenuItem();
    protected JMenu appletSaveAsJDXMenu;
    protected JMenu appletExportAsMenu;
    protected JMenuItem appletAdvancedMenuItem;
    protected JMenu appletCompoundMenu;
    public JMenuItem overlayKeyMenuItem = new JMenuItem();
    private String recentZoom;
    private String recentScript;
    protected String recentOverlay = "1.1,1.2";
    protected String recentStackPercent = "5";
    private PanelData pd;
    private int thisX;
    private int thisY;
    private JSVPanel thisJsvp;

    public void dispose() {
        this.pd = null;
        this.scripter = null;
    }

    public JSVPanelPopupMenu(ScriptInterface scripter) {
        this.scripter = scripter;
        this.jbInit();
    }

    protected void jbInit() {
        final ScriptInterface scripter = this.scripter;
        this.nextMenuItem.setText("Next View");
        this.nextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.getPanelData().nextView();
                JSVPanelPopupMenu.this.reboot();
            }
        });
        this.previousMenuItem.setText("Previous View");
        this.previousMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.getPanelData().previousView();
                JSVPanelPopupMenu.this.reboot();
            }
        });
        this.clearMenuItem.setText("Clear Views");
        this.clearMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.getPanelData().clearViews();
            }
        });
        this.resetMenuItem.setText("Reset View");
        this.resetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.getPanelData().resetView();
            }
        });
        this.overlayMenuItem.setText("Overlay Selected");
        this.overlayMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVPanelPopupMenu.this.overlay(-1);
            }
        });
        this.overlayAllMenuItem.setText("Overlay All");
        this.overlayAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVPanelPopupMenu.this.overlay(1);
            }
        });
        this.overlayNoneMenuItem.setText("Overlay None");
        this.overlayNoneMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVPanelPopupMenu.this.overlay(0);
            }
        });
        this.overlayStackOffsetMenuItem.setText("Overlay Offset...");
        this.overlayStackOffsetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVPanelPopupMenu.this.overlay(99);
            }
        });
        this.scriptMenuItem.setText("Script...");
        this.scriptMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVPanelPopupMenu.this.script();
            }
        });
        this.userZoomMenuItem.setText("Set Zoom...");
        this.userZoomMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVPanelPopupMenu.this.userZoom();
            }
        });
        this.properties.setActionCommand("Properties");
        this.properties.setText("Properties");
        this.properties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scripter.showProperties();
            }
        });
        this.gridCheckBoxMenuItem.setText("Show Grid");
        this.gridCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JSVPanelPopupMenu.runScript(scripter, "GRIDON " + (e.getStateChange() == 1));
                JSVPanelPopupMenu.this.reboot();
            }
        });
        this.coordsCheckBoxMenuItem.setText("Show Coordinates");
        this.coordsCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JSVPanelPopupMenu.runScript(scripter, "COORDINATESON " + (e.getStateChange() == 1));
                JSVPanelPopupMenu.this.reboot();
            }
        });
        this.reversePlotCheckBoxMenuItem.setText("Reverse Plot");
        this.reversePlotCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JSVPanelPopupMenu.runScript(scripter, "REVERSEPLOT " + (e.getStateChange() == 1));
                JSVPanelPopupMenu.this.reboot();
            }
        });
        this.setMenu();
    }

    protected void setMenu() {
        this.add(this.gridCheckBoxMenuItem);
        this.add(this.coordsCheckBoxMenuItem);
        this.add(this.reversePlotCheckBoxMenuItem);
        this.addSeparator();
        this.add(this.nextMenuItem);
        this.add(this.previousMenuItem);
        this.add(this.clearMenuItem);
        this.add(this.resetMenuItem);
        this.add(this.userZoomMenuItem);
        this.addSeparator();
        this.add(this.overlayMenuItem);
        this.add(this.scriptMenuItem);
        this.addSeparator();
        this.add(this.properties);
    }

    protected void reboot() {
        if (this.thisJsvp == null) {
            return;
        }
        this.thisJsvp.repaint();
        this.show((Container)((Object)this.thisJsvp), this.thisX, this.thisY);
    }

    public void userZoom() {
        String zoom = (String)JOptionPane.showInputDialog(null, "Enter zoom range", "Zoom", -1, null, null, this.recentZoom == null ? "" : this.recentZoom);
        if (zoom == null) {
            return;
        }
        this.recentZoom = zoom;
        JSVPanelPopupMenu.runScript(this.scripter, "zoom " + zoom);
    }

    public void script() {
        String script = (String)JOptionPane.showInputDialog(null, "Enter a JSpecView script", "Script", -1, null, null, this.recentScript == null ? "" : this.recentScript);
        if (script == null) {
            return;
        }
        this.recentScript = script;
        JSVPanelPopupMenu.runScript(this.scripter, script);
    }

    public static void setMenuItem(JMenuItem item, char c, String text, int accel, int mask, EventListener el) {
        if (c != '\u0000') {
            item.setMnemonic(c);
        }
        item.setText(text);
        if (accel > 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(accel, mask, false));
        }
        if (el instanceof ActionListener) {
            item.addActionListener((ActionListener)el);
        } else if (el instanceof ItemListener) {
            item.addItemListener((ItemListener)el);
        }
    }

    public void setProcessingMenu(JMenu menu) {
        final ScriptInterface scripter = this.scripter;
        JSVPanelPopupMenu.setMenuItem(this.integrateMenuItem, 'I', "Integrate HNMR", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVPanelPopupMenu.runScript(scripter, "INTEGRATE TOGGLE");
            }
        });
        JSVPanelPopupMenu.setMenuItem(this.transAbsMenuItem, '\u0000', "Transmittance/Absorbance", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVPanelPopupMenu.runScript(scripter, "IRMODE IMPLIED");
            }
        });
        JSVPanelPopupMenu.setMenuItem(this.solColMenuItem, '\u0000', "Predicted Solution Colour", 0, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVPanelPopupMenu.runScript(scripter, "GETSOLUTIONCOLOR");
            }
        });
        menu.add(this.integrateMenuItem);
        menu.add(this.transAbsMenuItem);
        menu.add(this.solColMenuItem);
    }

    protected static void runScript(ScriptInterface scripter, String cmd) {
        if (scripter == null) {
            System.out.println("scripter was null for " + cmd);
        } else {
            scripter.runScript(cmd);
        }
    }

    public void overlay(int n) {
        switch (n) {
            case 99: {
                String offset = (String)JOptionPane.showInputDialog(null, "Enter a vertical offset in percent for stacked plots", "Overlay", -1, null, null, this.recentStackPercent);
                if (offset == null || Float.isNaN(Parser.parseFloat(offset))) {
                    return;
                }
                this.recentStackPercent = offset;
                JSVPanelPopupMenu.runScript(this.scripter, (Object)((Object)ScriptToken.STACKOFFSETY) + " " + offset);
                break;
            }
            case 0: {
                JSVPanelPopupMenu.runScript(this.scripter, "overlay NONE");
                break;
            }
            case 1: {
                JSVPanelPopupMenu.runScript(this.scripter, "overlay ALL");
                break;
            }
            default: {
                String script = (String)JOptionPane.showInputDialog(null, "Enter a list of Spectrum IDs separated by commas", "Overlay", -1, null, null, this.recentOverlay);
                if (script == null) {
                    return;
                }
                this.recentOverlay = script;
                JSVPanelPopupMenu.runScript(this.scripter, "overlay " + script);
            }
        }
    }

    public void show(JSVPanel jsvp, int x, int y) {
        this.setEnables(jsvp);
        this.thisX = x;
        this.thisY = y;
        this.thisJsvp = jsvp;
        super.show((Container)((Object)jsvp), x, y);
    }

    public void setEnables(JSVPanel jsvp) {
        this.pd = jsvp.getPanelData();
        JDXSpectrum spec0 = jsvp.getSpectrumAt(0);
        this.setSelected(this.gridCheckBoxMenuItem, this.pd.getBoolean(ScriptToken.GRIDON));
        this.setSelected(this.coordsCheckBoxMenuItem, this.pd.getBoolean(ScriptToken.COORDINATESON));
        this.setSelected(this.reversePlotCheckBoxMenuItem, this.pd.getBoolean(ScriptToken.REVERSEPLOT));
        boolean isOverlaid = this.pd.isOverlaid();
        boolean isSingle = this.pd.getNumberOfSpectraTotal() == 1;
        this.integrateMenuItem.setEnabled(isSingle && spec0.canIntegrate() || spec0.hasIntegral());
        this.solColMenuItem.setEnabled(isSingle && spec0.canShowSolutionColor());
        this.transAbsMenuItem.setEnabled(isSingle && spec0.canConvertTransAbs());
        this.overlayKeyMenuItem.setEnabled(isOverlaid && this.pd.getNumberOfGraphSets() == 1);
        if (this.appletSaveAsJDXMenu != null) {
            this.appletSaveAsJDXMenu.setEnabled(spec0.canSaveAsJDX());
        }
        if (this.appletExportAsMenu != null) {
            this.appletExportAsMenu.setEnabled(true);
        }
        if (this.appletAdvancedMenuItem != null) {
            this.appletAdvancedMenuItem.setEnabled(!isOverlaid);
        }
        if (this.appletCompoundMenu != null) {
            this.appletCompoundMenu.setEnabled(this.appletCompoundMenu.isEnabled() && this.appletCompoundMenu.getItemCount() > 3);
        }
    }

    private void setSelected(JCheckBoxMenuItem item, boolean TF) {
        item.setEnabled(false);
        item.setSelected(TF);
        item.setEnabled(true);
    }

    static void addMenuItem(JMenu m, String key, ActionListener actionListener) {
        JMenuItem jmi = new JMenuItem();
        jmi.setMnemonic(key.charAt(0));
        jmi.setText(key);
        jmi.addActionListener(actionListener);
        m.add(jmi);
    }

    public static void setMenus(JMenu saveAsMenu, JMenu saveAsJDXMenu, JMenu exportAsMenu, ActionListener actionListener) {
        saveAsMenu.setText("Save As");
        JSVPanelPopupMenu.addMenuItem(saveAsMenu, "Source...", actionListener);
        saveAsJDXMenu.setText("JDX");
        JSVPanelPopupMenu.addMenuItem(saveAsJDXMenu, "XY", actionListener);
        JSVPanelPopupMenu.addMenuItem(saveAsJDXMenu, "DIF", actionListener);
        JSVPanelPopupMenu.addMenuItem(saveAsJDXMenu, "DIFDUP", actionListener);
        JSVPanelPopupMenu.addMenuItem(saveAsJDXMenu, "FIX", actionListener);
        JSVPanelPopupMenu.addMenuItem(saveAsJDXMenu, "PAC", actionListener);
        JSVPanelPopupMenu.addMenuItem(saveAsJDXMenu, "SQZ", actionListener);
        saveAsMenu.add(saveAsJDXMenu);
        JSVPanelPopupMenu.addMenuItem(saveAsMenu, "CML", actionListener);
        JSVPanelPopupMenu.addMenuItem(saveAsMenu, "XML (AnIML)", actionListener);
        if (exportAsMenu != null) {
            exportAsMenu.setText("Export As");
            JSVPanelPopupMenu.addMenuItem(exportAsMenu, "JPG", actionListener);
            JSVPanelPopupMenu.addMenuItem(exportAsMenu, "PNG", actionListener);
            JSVPanelPopupMenu.addMenuItem(exportAsMenu, "SVG", actionListener);
        }
    }
}

