/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import jspecview.application.MDIDesktopManager;
import jspecview.application.MainFrame;
import jspecview.application.WindowMenu;
import jspecview.common.JSVFrame;

public class ScrollableDesktopPane
extends JDesktopPane {
    private int style = 0;
    public static final int STYLE_STACK = 0;
    public static final int STYLE_CASCADE = 1;
    public static final int STYLE_TILE = 2;
    private static final long serialVersionUID = 1L;
    private static int FRAME_OFFSET = 20;
    private MDIDesktopManager manager = new MDIDesktopManager(this);

    public int getStyle() {
        return this.style;
    }

    public ScrollableDesktopPane() {
        this.setDesktopManager(this.manager);
        this.setDragMode(1);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.checkDesktopSize();
    }

    public Component add(JInternalFrame frame) {
        Component retval = super.add(frame);
        this.checkDesktopSize();
        if (frame.isResizable()) {
            int w = this.getWidth() - this.getWidth() / 3;
            int h = this.getHeight() - this.getHeight() / 3;
            if ((double)w < frame.getMinimumSize().getWidth()) {
                w = (int)frame.getMinimumSize().getWidth();
            }
            if ((double)h < frame.getMinimumSize().getHeight()) {
                h = (int)frame.getMinimumSize().getHeight();
            }
            frame.setSize(w, h);
        }
        this.moveToFront(frame);
        frame.setVisible(true);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            frame.toBack();
        }
        return retval;
    }

    public void remove(Component c) {
        super.remove(c);
        this.checkDesktopSize();
    }

    public void stackFrames() {
        this.manager.setNormalSize();
        this.setMyStyle(0);
        JInternalFrame[] allFrames = this.getAllFrames();
        int i = allFrames.length - 1;
        while (i >= 0) {
            try {
                allFrames[i].setEnabled(false);
                allFrames[i].setMaximum(false);
                allFrames[i].setMaximum(true);
                allFrames[i].setEnabled(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            --i;
        }
    }

    void setMyStyle(int style) {
        this.style = style;
    }

    public void cascadeFrames() {
        this.setAllEnabled(true);
        this.manager.setNormalSize();
        this.setMyStyle(1);
        int x = 0;
        int y = 0;
        JInternalFrame[] allFrames = this.getAllFrames();
        int frameHeight = this.getBounds().height - 5 - allFrames.length * FRAME_OFFSET;
        if (frameHeight < 100) {
            frameHeight = 100;
        }
        int frameWidth = this.getBounds().width - 5 - allFrames.length * FRAME_OFFSET;
        int i = allFrames.length - 1;
        while (i >= 0) {
            allFrames[i].setSize(frameWidth, frameHeight);
            allFrames[i].setLocation(x, y);
            x += FRAME_OFFSET;
            y += FRAME_OFFSET;
            --i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void tileFrames() {
        block6: {
            this.setAllEnabled(true);
            this.manager.setNormalSize();
            this.setMyStyle(2);
            scrollPane = this.manager.getScrollPane();
            viewP = scrollPane != null ? scrollPane.getViewport().getViewRect() : this.getBounds();
            totalNonIconFrames = 0;
            frames = this.getAllFrames();
            i = 0;
            while (i < frames.length) {
                if (!frames[i].isIcon()) {
                    ++totalNonIconFrames;
                }
                ++i;
            }
            curCol = 0;
            curRow = 0;
            i = 0;
            if (totalNonIconFrames <= 0) break block6;
            numCols = (int)Math.sqrt(totalNonIconFrames);
            frameWidth = viewP.width / numCols;
            curCol = 0;
            while (curCol < numCols) {
                numRows = totalNonIconFrames / numCols;
                remainder = totalNonIconFrames % numCols;
                if (numCols - curCol <= remainder) {
                    ++numRows;
                }
                frameHeight = viewP.height / numRows;
                curRow = 0;
                ** GOTO lbl35
                {
                    ++i;
                    do {
                        if (frames[i].isIcon()) continue block2;
                        frames[i].setBounds(curCol * frameWidth, curRow * frameHeight, frameWidth, frameHeight);
                        ++i;
                        ++curRow;
lbl35:
                        // 2 sources

                    } while (curRow < numRows);
                }
                ++curCol;
            }
        }
    }

    public void setAllEnabled(boolean isEnabled) {
        JInternalFrame[] frames = this.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            MainFrame.getPanel0((JSVFrame)frames[i]).setEnabled(isEnabled);
            ++i;
        }
    }

    public void setAllSize(Dimension d) {
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
        this.setMyStyle(0);
    }

    public void setAllSize(int width, int height) {
        this.setAllSize(new Dimension(width, height));
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.manager.resizeDesktop();
        }
    }

    public void setWindowMenu(WindowMenu windowMenu) {
    }
}

