/*
 * Decompiled with CFR 0.152.
 */
package jspecview.applet;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jspecview.applet.JSVAppletPrivate;
import jspecview.common.JSVPanelPopupMenu;
import jspecview.common.JSVSpecNode;
import jspecview.source.JDXSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSVAppletPopupMenu
extends JSVPanelPopupMenu {
    private JSVAppletPrivate applet;
    private ActionListener exportActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JSVAppletPopupMenu.this.applet.exportSpectrumViaMenu(e.getActionCommand());
        }
    };
    private static final long serialVersionUID = 1L;
    private JMenu aboutMenu = new JMenu();
    private JMenu fileMenu = new JMenu();
    private JMenuItem printMenuItem = new JMenuItem();
    private JMenu saveAsMenu = new JMenu();
    private JMenu viewMenu = new JMenu();
    private JMenu zoomMenu = new JMenu();
    private JMenuItem versionMenuItem = new JMenuItem();
    private JMenuItem headerMenuItem = new JMenuItem();
    JCheckBoxMenuItem windowMenuItem = new JCheckBoxMenuItem();

    JSVAppletPopupMenu(JSVAppletPrivate applet, boolean allowMenu, boolean enableZoom) {
        super(applet);
        this.isApplet = true;
        this.applet = applet;
        this.recentOverlay = "none";
        super.jbInit();
        if (!allowMenu) {
            this.viewMenu.setEnabled(false);
            this.fileMenu.setEnabled(false);
            this.appletExportAsMenu.setEnabled(false);
            this.saveAsMenu.setEnabled(false);
        }
        this.zoomMenu.setEnabled(enableZoom);
    }

    @Override
    protected void jbInit() {
    }

    @Override
    protected void setMenu() {
        this.aboutMenu.setText("About");
        this.fileMenu.setText("File");
        this.printMenuItem.setActionCommand("Print");
        this.printMenuItem.setText("Print...");
        this.printMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVAppletPopupMenu.this.applet.print();
            }
        });
        this.viewMenu.setText("View");
        this.zoomMenu.setText("Zoom");
        this.headerMenuItem.setText("Show Header...");
        this.headerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVAppletPopupMenu.this.applet.showHeader();
            }
        });
        this.windowMenuItem.setText("Window");
        this.windowMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JSVAppletPopupMenu.this.applet.newWindow(e.getStateChange() == 1);
            }
        });
        this.overlayKeyMenuItem.setEnabled(false);
        this.overlayKeyMenuItem.setText("Show Overlay Key...");
        this.overlayKeyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSVAppletPopupMenu.this.overlayKeyMenuItem_actionPerformed();
            }
        });
        this.appletCompoundMenu = new JMenu();
        this.appletCompoundMenu.setEnabled(false);
        this.appletCompoundMenu.setText("Blocks");
        this.versionMenuItem.setText("<html><h3>" + this.applet.getJsvApplet().getAppletInfo() + "</h3></html>");
        this.add(this.fileMenu);
        this.add(this.viewMenu);
        this.add(this.zoomMenu);
        this.add(this.appletCompoundMenu);
        this.addSeparator();
        this.add(this.scriptMenuItem);
        if (this.applet.isPro()) {
            this.appletAdvancedMenuItem = new JMenuItem();
            this.appletAdvancedMenuItem.setText("Advanced...");
            this.appletAdvancedMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JSVAppletPopupMenu.this.applet.doAdvanced(JSVAppletPopupMenu.this.applet.getSource().getFilePath());
                }
            });
            this.add(this.appletAdvancedMenuItem);
        }
        this.addSeparator();
        this.add(this.aboutMenu);
        this.fileMenu.add(this.saveAsMenu);
        if (this.applet.isSigned()) {
            this.appletExportAsMenu = new JMenu();
            this.fileMenu.add(this.appletExportAsMenu);
        }
        this.appletSaveAsJDXMenu = new JMenu();
        JSVPanelPopupMenu.setMenus(this.saveAsMenu, this.appletSaveAsJDXMenu, this.appletExportAsMenu, this.exportActionListener);
        this.fileMenu.add(this.printMenuItem);
        this.viewMenu.add(this.gridCheckBoxMenuItem);
        this.viewMenu.add(this.coordsCheckBoxMenuItem);
        this.viewMenu.add(this.reversePlotCheckBoxMenuItem);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.headerMenuItem);
        this.viewMenu.add(this.overlayKeyMenuItem);
        this.viewMenu.addSeparator();
        this.setProcessingMenu(this.viewMenu);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.windowMenuItem);
        this.zoomMenu.add(this.nextMenuItem);
        this.zoomMenu.add(this.previousMenuItem);
        this.zoomMenu.add(this.resetMenuItem);
        this.zoomMenu.add(this.clearMenuItem);
        this.zoomMenu.add(this.userZoomMenuItem);
        this.aboutMenu.add(this.versionMenuItem);
    }

    protected void overlayKeyMenuItem_actionPerformed() {
        this.overlayKeyMenuItem.setSelected(!this.overlayKeyMenuItem.isSelected());
        boolean visible = this.overlayKeyMenuItem.isSelected();
        this.applet.showOverlayKey(visible);
    }

    public void setCompoundMenu(JDXSource currentSource, int currentSpectrumIndex, List<JSVSpecNode> specNodes, boolean allowSelection, ActionListener compoundMenuSelectionListener, ActionListener compoundMenuChooseListener) {
        this.appletCompoundMenu.removeAll();
        if (!allowSelection) {
            return;
        }
        this.appletCompoundMenu.add(this.overlayAllMenuItem);
        this.appletCompoundMenu.add(this.overlayNoneMenuItem);
        this.appletCompoundMenu.add(this.overlayMenuItem);
        this.appletCompoundMenu.add(this.overlayStackOffsetMenuItem);
        if (specNodes.size() <= 20) {
            if (currentSource.isCompoundSource) {
                int i = 0;
                while (i < specNodes.size()) {
                    JCheckBoxMenuItem mi = new JCheckBoxMenuItem(String.valueOf(i + 1) + "- " + specNodes.get(i).getSpectrum().getTitleLabel());
                    mi.setSelected(i == currentSpectrumIndex);
                    mi.addActionListener(compoundMenuSelectionListener);
                    mi.setActionCommand("" + i);
                    this.appletCompoundMenu.add(mi);
                    ++i;
                }
                this.appletCompoundMenu.setText("Spectra");
            }
            this.add((Component)this.appletCompoundMenu, 3);
            this.appletCompoundMenu.setEnabled(true);
        } else {
            JMenuItem compoundMi = new JMenuItem("Choose Spectrum");
            compoundMi.addActionListener(compoundMenuChooseListener);
        }
    }
}

