/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import org.jmol.script.ScriptVariable;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.util.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Escape {
    private static final String escapable = "\\\\\tt\rr\nn\"\"";

    public static String escapeColor(int n) {
        return "[x" + Escape.getHexColorFromRGB(n) + "]";
    }

    public static String getHexColorFromRGB(int n) {
        if (n == 0) {
            return null;
        }
        String string = "00" + Integer.toHexString(n >> 16 & 0xFF);
        string = string.substring(string.length() - 2);
        String string2 = "00" + Integer.toHexString(n >> 8 & 0xFF);
        string2 = string2.substring(string2.length() - 2);
        String string3 = "00" + Integer.toHexString(n & 0xFF);
        string3 = string3.substring(string3.length() - 2);
        return string + string2 + string3;
    }

    public static String escape(Tuple3f tuple3f) {
        if (tuple3f == null) {
            return "null";
        }
        return "{" + tuple3f.x + " " + tuple3f.y + " " + tuple3f.z + "}";
    }

    public static String escape(Object object) {
        if (object instanceof String) {
            return Escape.escape((String)object);
        }
        if (object instanceof List) {
            return Escape.escape((ArrayList)object);
        }
        if (object instanceof BitSet) {
            return Escape.escape((BitSet)object, true);
        }
        if (object instanceof Matrix3f) {
            return TextFormat.simpleReplace(((Matrix3f)object).toString(), "\t", ",\t");
        }
        if (object instanceof Matrix4f) {
            return TextFormat.simpleReplace(((Matrix4f)object).toString(), "\t", ",\t");
        }
        if (object instanceof Tuple3f) {
            return Escape.escape((Tuple3f)object);
        }
        if (object instanceof Point4f) {
            Point4f point4f = (Point4f)object;
            return "{" + point4f.x + " " + point4f.y + " " + point4f.z + " " + point4f.w + "}";
        }
        if (object instanceof AxisAngle4f) {
            AxisAngle4f axisAngle4f = (AxisAngle4f)object;
            return "{" + axisAngle4f.x + " " + axisAngle4f.y + " " + axisAngle4f.z + " " + (float)((double)axisAngle4f.angle * 180.0 / Math.PI) + "}";
        }
        if (object instanceof String[]) {
            return Escape.escape((String[])object, true);
        }
        if (object instanceof int[] || object instanceof int[][] || object instanceof float[] || object instanceof double[] || object instanceof float[][] || object instanceof float[][][]) {
            return Escape.toJSON(null, object);
        }
        if (object instanceof Point3f[]) {
            return Escape.escapeArray(object);
        }
        if (object instanceof Map) {
            return Escape.escape((Map)object);
        }
        return object == null ? "null" : object.toString();
    }

    public static String escape(String string) {
        int n;
        if (string == null) {
            return "\"\"";
        }
        boolean bl = false;
        for (n = 0; n < escapable.length(); n += 2) {
            if (string.indexOf(escapable.charAt(n)) < 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            while (n < escapable.length()) {
                int n2 = -1;
                char c = escapable.charAt(n++);
                char c2 = escapable.charAt(n++);
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                while ((n2 = string.indexOf(c, n2 + 1)) >= 0) {
                    stringBuffer.append(string.substring(n3, n2)).append('\\').append(c2);
                    n3 = n2 + 1;
                }
                stringBuffer.append(string.substring(n3, string.length()));
                string = stringBuffer.toString();
            }
        }
        n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) <= '\u007f') continue;
            string = string.substring(0, n) + Escape.unicode(string.charAt(n)) + string.substring(n + 1);
        }
        return "\"" + string + "\"";
    }

    private static String unicode(char c) {
        String string = "0000" + Integer.toHexString(c);
        return "\\u" + string.substring(string.length() - 4);
    }

    public static String escape(ArrayList<ScriptVariable> arrayList) {
        if (arrayList == null) {
            return Escape.escape("");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Escape.escapeNice(arrayList.get(i).asString()));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String escape(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        String string = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = entry.getKey();
            stringBuilder.append(string).append(Escape.escape(string2)).append(':');
            Object object = entry.getValue();
            if (!(object instanceof ScriptVariable)) {
                object = ScriptVariable.getVariable(object);
            }
            stringBuilder.append(((ScriptVariable)object).escape());
            string = ",";
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public static String escape(float[] fArray, boolean bl) {
        if (bl) {
            return Escape.toJSON(null, fArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(fArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String escape(float[][] fArray, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = bl ? ";\n" : "\n";
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            if (i > 0) {
                stringBuilder.append(string);
            }
            for (int j = 0; j < fArray[i].length; ++j) {
                stringBuilder.append(fArray[i][j]).append('\t');
            }
        }
        return stringBuilder.toString();
    }

    public static String escape(float[][][] fArray, boolean bl) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string = bl ? ";\n" : "\n";
        if (fArray[0] == null || fArray[0][0] == null) {
            return "0 0 0" + string;
        }
        stringBuilder.append(fArray.length).append(" ").append(fArray[0].length).append(" ").append(fArray[0][0].length);
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            stringBuilder.append(string);
            for (int j = 0; j < fArray[i].length; ++j) {
                if (fArray[i][j] == null) continue;
                stringBuilder.append(string);
                for (int k = 0; k < fArray[i][j].length; ++k) {
                    stringBuilder.append(fArray[i][j][k]).append('\t');
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String escape(String[] stringArray, boolean bl) {
        if (stringArray == null) {
            return Escape.escape("");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(bl ? Escape.escapeNice(stringArray[i]) : Escape.escape(stringArray[i]));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String escapeArray(Object object) {
        if (object == null) {
            return Escape.escape("");
        }
        if (object instanceof Float) {
            return "" + object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        if (object instanceof double[]) {
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(dArray[i]);
            }
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            for (int i = 0; i < fArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(fArray[i]);
            }
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(nArray[i]);
            }
        } else if (object instanceof Point3f[]) {
            Point3f[] point3fArray = (Point3f[])object;
            stringBuilder = new StringBuilder("[");
            for (int i = 0; i < point3fArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(Escape.escape(point3fArray[i]));
            }
            return stringBuilder.append("]").toString();
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String escapeNice(String string) {
        if (string == null) {
            return "null";
        }
        float f = Parser.parseFloatStrict(string);
        return Float.isNaN(f) ? Escape.escape(string) : string;
    }

    public static Object unescapePointOrBitsetOrMatrixOrArray(String string) {
        if (string.charAt(0) == '{') {
            return Escape.unescapePoint(string);
        }
        if ((Escape.isStringArray(string) || string.startsWith("[{") && string.indexOf("[{") == string.lastIndexOf("[{")) && string.indexOf(44) < 0 && string.indexOf(46) < 0 && string.indexOf(45) < 0) {
            return Escape.unescapeBitset(string);
        }
        if (string.startsWith("[[")) {
            return Escape.unescapeMatrix(string);
        }
        return string;
    }

    public static boolean isStringArray(String string) {
        return string.startsWith("({") && string.lastIndexOf("({") == 0 && string.indexOf("})") == string.length() - 2;
    }

    public static Object unescapePoint(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.replace('\n', ' ').trim();
        if (string2.charAt(0) != '{' || string2.charAt(string2.length() - 1) != '}') {
            return string;
        }
        float[] fArray = new float[5];
        string2 = string2.substring(1, string2.length() - 1);
        int[] nArray = new int[1];
        for (n = 0; n < 5; ++n) {
            fArray[n] = Parser.parseFloat(string2, nArray);
            if (!Float.isNaN(fArray[n])) continue;
            if (nArray[0] >= string2.length() || string2.charAt(nArray[0]) != ',') break;
            nArray[0] = nArray[0] + 1;
            --n;
        }
        if (n == 3) {
            return new Point3f(fArray[0], fArray[1], fArray[2]);
        }
        if (n == 4) {
            return new Point4f(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        return string;
    }

    public static BitSet unescapeBitset(String string) {
        char c;
        int n;
        if (string == null || (n = (string = string.trim()).length()) < 4 || string.equalsIgnoreCase("({null})") || (c = string.charAt(0)) != '(' && c != '[' || string.charAt(n - 1) != (c == '(' ? (char)')' : ']') || string.charAt(1) != '{' || string.indexOf(125) != n - 2) {
            return null;
        }
        int n2 = n -= 2;
        while (--n2 >= 2) {
            c = string.charAt(n2);
            if (Character.isDigit(c) || c == ' ' || c == '\t' || c == ':') continue;
            return null;
        }
        n2 = n;
        while (Character.isDigit(string.charAt(--n2))) {
        }
        if (++n2 == n) {
            n2 = 0;
        } else {
            try {
                n2 = Integer.parseInt(string.substring(n2, n));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        BitSet bitSet = new BitSet(n2);
        n2 = -1;
        int n3 = -1;
        int n4 = -2;
        block8: for (int i = 2; i <= n; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': 
                case '}': {
                    if (n4 < 0) continue block8;
                    if (n4 < n2) {
                        return null;
                    }
                    n2 = n4;
                    if (n3 < 0) {
                        n3 = n4;
                    }
                    bitSet.set(n3, n4 + 1);
                    n3 = -1;
                    n4 = -2;
                    continue block8;
                }
                case ':': {
                    n3 = n2 = n4;
                    n4 = -2;
                    continue block8;
                }
                default: {
                    if (!Character.isDigit(c)) continue block8;
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    n4 = (n4 << 3) + (n4 << 1) + (c - 48);
                }
            }
        }
        return n3 >= 0 ? null : bitSet;
    }

    public static Object unescapeMatrix(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.replace('\n', ' ').trim();
        if (string2.lastIndexOf("[[") != 0 || string2.indexOf("]]") != string2.length() - 2) {
            return string;
        }
        float[] fArray = new float[16];
        string2 = string2.substring(2, string2.length() - 2).replace('[', ' ').replace(']', ' ').replace(',', ' ');
        int[] nArray = new int[1];
        for (n = 0; n < 16; ++n) {
            fArray[n] = Parser.parseFloat(string2, nArray);
            if (Float.isNaN(fArray[n])) break;
        }
        if (!Float.isNaN(Parser.parseFloat(string2, nArray))) {
            return string;
        }
        if (n == 9) {
            return new Matrix3f(fArray);
        }
        if (n == 16) {
            return new Matrix4f(fArray);
        }
        return string;
    }

    public static String escape(BitSet bitSet, boolean bl) {
        char c;
        char c2 = bl ? (char)'(' : '[';
        char c3 = c = bl ? (char)')' : ']';
        if (bitSet == null) {
            return c2 + "{}" + c;
        }
        StringBuilder stringBuilder = new StringBuilder(c2 + "{");
        int n = bitSet.length();
        int n2 = -1;
        int n3 = -2;
        int n4 = -1;
        while (++n4 <= n) {
            boolean bl2 = bitSet.get(n4);
            if (n4 == n || n2 >= 0 && !bl2) {
                if (n2 >= 0 && n3 != n2) {
                    stringBuilder.append((n3 == n2 - 1 ? " " : ":") + n2);
                }
                if (n4 == n) break;
                n2 = -1;
            }
            if (!bitSet.get(n4)) continue;
            if (n2 < 0) {
                stringBuilder.append((n3 == -2 ? "" : " ") + n4);
                n3 = n4;
            }
            n2 = n4;
        }
        stringBuilder.append("}").append(c);
        return stringBuilder.toString();
    }

    private static String packageJSON(String string, StringBuilder stringBuilder) {
        return Escape.packageJSON(string, stringBuilder.toString());
    }

    private static String packageJSON(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return "\"" + string + "\": " + string2;
    }

    private static String fixString(String string) {
        if (string == null || string.indexOf("{\"") == 0) {
            return string;
        }
        string = TextFormat.simpleReplace(string, "\"", "''");
        string = TextFormat.simpleReplace(string, "\n", " | ");
        return "\"" + string + "\"";
    }

    public static String toJSON(String string, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        if (object == null) {
            return Escape.packageJSON(string, (String)null);
        }
        if (object instanceof Integer || object instanceof Float || object instanceof Double) {
            return Escape.packageJSON(string, object.toString());
        }
        if (object instanceof String) {
            return Escape.packageJSON(string, Escape.fixString((String)object));
        }
        if (object instanceof String[]) {
            stringBuilder.append("[");
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(Escape.fixString(((String[])object)[i]));
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof int[]) {
            stringBuilder.append("[");
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(((int[])object)[i]);
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof float[]) {
            stringBuilder.append("[");
            int n = ((float[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(((float[])object)[i]);
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof double[]) {
            stringBuilder.append("[");
            int n = ((double[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(((double[])object)[i]);
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof Point3f[]) {
            stringBuilder.append("[");
            int n = ((Point3f[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2);
                Escape.addJsonTuple(stringBuilder, ((Point3f[])object)[i]);
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof String[][]) {
            stringBuilder.append("[");
            int n = ((String[][])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(Escape.toJSON(null, ((String[][])object)[i]));
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof int[][]) {
            stringBuilder.append("[");
            int n = ((int[][])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(Escape.toJSON(null, ((int[][])object)[i]));
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof float[][]) {
            stringBuilder.append("[");
            int n = ((float[][])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(Escape.toJSON(null, ((float[][])object)[i]));
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof float[][][]) {
            stringBuilder.append("[");
            int n = ((float[][][])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(Escape.toJSON(null, ((float[][][])object)[i]));
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof List) {
            stringBuilder.append("[ ");
            int n = ((List)object).size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(Escape.toJSON(null, ((List)object).get(i)));
                string2 = ",";
            }
            stringBuilder.append(" ]");
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof Matrix4f) {
            float[] fArray = new float[4];
            Matrix4f matrix4f = (Matrix4f)object;
            stringBuilder.append('[');
            for (int i = 0; i < 4; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                matrix4f.getRow(i, fArray);
                stringBuilder.append(Escape.toJSON(null, fArray));
            }
            stringBuilder.append(']');
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof Matrix3f) {
            float[] fArray = new float[3];
            Matrix3f matrix3f = (Matrix3f)object;
            stringBuilder.append('[');
            for (int i = 0; i < 3; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                matrix3f.getRow(i, fArray);
                stringBuilder.append(Escape.toJSON(null, fArray));
            }
            stringBuilder.append(']');
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof Tuple3f) {
            Escape.addJsonTuple(stringBuilder, (Tuple3f)object);
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof AxisAngle4f) {
            stringBuilder.append("[").append(((AxisAngle4f)object).x).append(",").append(((AxisAngle4f)object).y).append(",").append(((AxisAngle4f)object).z).append(",").append((float)((double)((AxisAngle4f)object).angle * 180.0 / Math.PI)).append("]");
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof Point4f) {
            stringBuilder.append("[").append(((Point4f)object).x).append(",").append(((Point4f)object).y).append(",").append(((Point4f)object).z).append(",").append(((Point4f)object).w).append("]");
            return Escape.packageJSON(string, stringBuilder);
        }
        if (object instanceof Map) {
            stringBuilder.append("{ ");
            for (String string3 : ((Map)object).keySet()) {
                stringBuilder.append(string2).append(Escape.packageJSON(string3, Escape.toJSON(null, ((Map)object).get(string3))));
                string2 = ",";
            }
            stringBuilder.append(" }");
            return Escape.packageJSON(string, stringBuilder);
        }
        return Escape.packageJSON(string, Escape.fixString(object.toString()));
    }

    private static void addJsonTuple(StringBuilder stringBuilder, Tuple3f tuple3f) {
        stringBuilder.append("[").append(tuple3f.x).append(",").append(tuple3f.y).append(",").append(tuple3f.z).append("]");
    }

    public static String toReadable(Object object) {
        return Escape.toReadable(null, object);
    }

    public static String toReadable(String string, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return Escape.packageReadable(string, null, Escape.escape((String)object));
        }
        if (object instanceof String[]) {
            stringBuilder.append("[");
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(Escape.escape(((String[])object)[i]));
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageReadable(string, "String[" + n + "]", stringBuilder);
        }
        if (object instanceof int[]) {
            stringBuilder.append("[");
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(((int[])object)[i]);
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageReadable(string, "int[" + n + "]", stringBuilder);
        }
        if (object instanceof float[]) {
            stringBuilder.append("[");
            int n = ((float[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(((float[])object)[i]);
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageReadable(string, "float[" + n + "]", stringBuilder);
        }
        if (object instanceof Point3f[]) {
            stringBuilder.append("[");
            int n = ((Point3f[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(Escape.escape(((Point3f[])object)[i]));
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageReadable(string, "point3f[" + n + "]", stringBuilder);
        }
        if (object instanceof String[][]) {
            stringBuilder.append("[");
            int n = ((String[][])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(Escape.toReadable(null, ((String[][])object)[i]));
                string2 = ",\n";
            }
            stringBuilder.append("]");
            return Escape.packageReadable(string, "String[" + n + "][]", stringBuilder);
        }
        if (object instanceof int[][]) {
            stringBuilder.append("[");
            int n = ((int[][])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(Escape.toReadable(null, ((int[][])object)[i]));
                string2 = ",";
            }
            stringBuilder.append("]");
            return Escape.packageReadable(string, "int[" + n + "][]", stringBuilder);
        }
        if (object instanceof float[][]) {
            stringBuilder.append("[\n");
            int n = ((float[][])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string2).append(Escape.toReadable(null, ((float[][])object)[i]));
                string2 = ",\n";
            }
            stringBuilder.append("]");
            return Escape.packageReadable(string, "float[][]", stringBuilder);
        }
        if (object instanceof List) {
            int n = ((List)object).size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(Escape.toReadable(string + "[" + (i + 1) + "]", ((List)object).get(i)));
            }
            return Escape.packageReadable(string, "List[" + n + "]", stringBuilder);
        }
        if (object instanceof Matrix3f || object instanceof Tuple3f || object instanceof Point4f || object instanceof AxisAngle4f) {
            stringBuilder.append(Escape.escape(object));
            return Escape.packageReadable(string, null, stringBuilder);
        }
        if (object instanceof Map) {
            for (String string3 : ((Map)object).keySet()) {
                stringBuilder.append(Escape.toReadable((string == null ? "" : string + ".") + string3, ((Map)object).get(string3)));
            }
            return stringBuilder.toString();
        }
        return Escape.packageReadable(string, null, object.toString());
    }

    private static String packageReadable(String string, String string2, StringBuilder stringBuilder) {
        return Escape.packageReadable(string, string2, stringBuilder.toString());
    }

    private static String packageReadable(String string, String string2, String string3) {
        String string4;
        String string5 = string4 = string2 == null ? "" : string2 + "\t";
        if (string == null) {
            return string4 + string3;
        }
        return "\n" + string + "\t" + (string2 == null ? "" : "*" + string2 + "\t") + string3;
    }

    public static String escapeModelFileNumber(int n) {
        return "" + n / 1000000 + "." + n % 1000000;
    }

    public static Object encapsulateData(String string, Object object) {
        return "  DATA \"" + string + "\"\n" + (object instanceof float[][] ? Escape.escape((float[][])object, true) + ";\n" : (object instanceof float[][][] ? Escape.escape((float[][][])object, true) + ";\n" : object)) + "    END \"" + string + "\";\n";
    }

    public static String escapeXml(Object object) {
        if (object instanceof String) {
            return XmlUtil.wrapCdata(object.toString());
        }
        String string = "" + object;
        if (string.length() == 0 || string.charAt(0) != '[') {
            return string;
        }
        return XmlUtil.wrapCdata(Escape.toReadable(null, object));
    }

    public static String unescapeUnicode(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\\' && n2 < n) {
                c = string.charAt(n2++);
                switch (c) {
                    case 'u': {
                        char c2;
                        int n3;
                        if (n2 >= n) break;
                        int n4 = 0;
                        int n5 = 4;
                        while (--n5 >= 0 && n2 < n && (n3 = Escape.getHexitValue(c2 = string.charAt(n2))) >= 0) {
                            n4 <<= 4;
                            n4 += n3;
                            ++n2;
                        }
                        c = (char)n4;
                    }
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static int getHexitValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }

    public static String[] unescapeStringArray(String string) {
        if (string == null || !string.startsWith("[") || !string.endsWith("]")) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = new int[]{1};
        while (nArray[0] < string.length()) {
            String string2 = Parser.getNextQuotedString(string, nArray);
            if (string2 == null) {
                return null;
            }
            arrayList.add(string2);
            while (nArray[0] < string.length() && string.charAt(nArray[0]) != '\"') {
                nArray[0] = nArray[0] + 1;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String escapeUrl(String string) {
        string = TextFormat.simpleReplace(string, "\n", "");
        string = TextFormat.simpleReplace(string, "%", "%25");
        string = TextFormat.simpleReplace(string, "[", "%5B");
        string = TextFormat.simpleReplace(string, "]", "%5D");
        string = TextFormat.simpleReplace(string, " ", "%20");
        return string;
    }
}

