/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.util.Logger;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

class TransformManager10
extends TransformManager {
    TransformManager10(Viewer viewer) {
        super(viewer);
        this.perspectiveModel = 10;
    }

    TransformManager10(Viewer viewer, int n, int n2) {
        super(viewer, n, n2);
        this.perspectiveModel = 10;
    }

    protected void calcCameraFactors() {
        if (Float.isNaN(this.cameraDepth)) {
            this.cameraDepth = this.cameraDepthSetting;
        }
        this.cameraDistance = this.cameraDepth * (float)this.screenPixelCount;
        this.cameraScaleFactor = 1.02f + 0.5f / this.cameraDepth;
        this.scalePixelsPerAngstrom = this.scale3D && !this.perspectiveDepth ? 72.0f / this.scale3DAngstromsPerInch * (float)(this.antialias ? 2 : 1) : this.scaleDefaultPixelsPerAngstrom * this.zoomPercent / 100.0f * this.cameraScaleFactor;
        this.modelRadiusPixels = this.modelRadius * this.scalePixelsPerAngstrom;
        this.modelCenterOffset = this.cameraDistance + this.modelRadiusPixels;
        this.referencePlaneOffset = this.cameraDistance;
    }

    protected float getPerspectiveFactor(float f) {
        float f2;
        float f3 = f2 = f <= 0.0f ? this.referencePlaneOffset : this.referencePlaneOffset / f;
        if (this.zoomPercent >= 10000.0f) {
            f2 += (this.zoomPercent - 10000.0f) / 190000.0f * (1.0f - f2);
        }
        return f2;
    }

    protected void adjustTemporaryScreenPoint() {
        float f = this.point3fScreenTemp.z;
        if (Float.isNaN(f)) {
            if (!this.haveNotifiedNaN) {
                Logger.debug("NaN seen in TransformPoint");
            }
            this.haveNotifiedNaN = true;
            f = 1.0f;
        } else if (f <= 0.0f) {
            f = 1.0f;
        }
        this.point3fScreenTemp.z = f;
        if (this.perspectiveDepth) {
            float f2 = this.getPerspectiveFactor(f);
            this.point3fScreenTemp.x *= f2;
            this.point3fScreenTemp.y *= f2;
        }
        this.point3fScreenTemp.x += this.fixedRotationOffset.x;
        this.point3fScreenTemp.y += this.fixedRotationOffset.y;
        if (Float.isNaN(this.point3fScreenTemp.x) && !this.haveNotifiedNaN) {
            Logger.debug("NaN found in transformPoint ");
            this.haveNotifiedNaN = true;
        }
        this.point3iScreenTemp.set((int)this.point3fScreenTemp.x, (int)this.point3fScreenTemp.y, (int)this.point3fScreenTemp.z);
    }
}

