/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.Hashtable;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.VolumeDataInterface;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.XmlUtil;

public class VolumeData
implements VolumeDataInterface {
    public SurfaceReader sr;
    public boolean doIterate = true;
    public final Point3f volumetricOrigin = new Point3f();
    public final float[] origin = new float[3];
    public final Vector3f[] volumetricVectors = new Vector3f[3];
    public final int[] voxelCounts = new int[3];
    public int nPoints;
    private float[][][] voxelData;
    private Map<Integer, Float> voxelMap;
    public final float[] volumetricVectorLengths = new float[3];
    private float maxVectorLength;
    private float minToPlaneDistance;
    private int yzCount;
    public final Vector3f[] unitVolumetricVectors = new Vector3f[3];
    private final Matrix3f volumetricMatrix = new Matrix3f();
    private final Matrix3f inverseMatrix = new Matrix3f();
    private Point4f thePlane;
    private float thePlaneNormalMag;
    private final Point3f ptXyzTemp = new Point3f();
    public String xmlData;
    public Point4f mappingPlane;
    float mappingPlaneNormalMag;
    public float minGrid;
    public float maxGrid;
    public float voxelVolume;
    public boolean isPeriodic;
    private boolean isSquared;
    private final Vector3f edgeVector = new Vector3f();
    private Point3f ptTemp = new Point3f();

    public float[][][] getVoxelData() {
        return this.voxelData;
    }

    public void setVoxelData(float[][][] fArray) {
        this.voxelData = fArray;
    }

    public boolean hasPlane() {
        return this.thePlane != null;
    }

    public VolumeData() {
        this.volumetricVectors[0] = new Vector3f();
        this.volumetricVectors[1] = new Vector3f();
        this.volumetricVectors[2] = new Vector3f();
        this.unitVolumetricVectors[0] = new Vector3f();
        this.unitVolumetricVectors[1] = new Vector3f();
        this.unitVolumetricVectors[2] = new Vector3f();
    }

    public void setMappingPlane(Point4f point4f) {
        this.mappingPlane = point4f;
        if (point4f == null) {
            return;
        }
        this.mappingPlaneNormalMag = (float)Math.sqrt(point4f.x * point4f.x + point4f.y * point4f.y + point4f.z * point4f.z);
    }

    public float distanceToMappingPlane(Point3f point3f) {
        return (this.mappingPlane.x * point3f.x + this.mappingPlane.y * point3f.y + this.mappingPlane.z * point3f.z + this.mappingPlane.w) / this.mappingPlaneNormalMag;
    }

    public void setVolumetricOrigin(float f, float f2, float f3) {
        this.volumetricOrigin.set(f, f2, f3);
    }

    public float[] getOriginFloat() {
        return this.origin;
    }

    public int getYzCount() {
        this.minGrid = this.volumetricVectors[0].length();
        this.minGrid = Math.min(this.minGrid, this.volumetricVectors[1].length());
        this.minGrid = Math.min(this.minGrid, this.volumetricVectors[2].length());
        this.maxGrid = this.volumetricVectors[0].length();
        this.maxGrid = Math.max(this.maxGrid, this.volumetricVectors[1].length());
        this.maxGrid = Math.max(this.maxGrid, this.volumetricVectors[2].length());
        this.nPoints = this.voxelCounts[0] * this.voxelCounts[1] * this.voxelCounts[2];
        this.yzCount = this.voxelCounts[1] * this.voxelCounts[2];
        return this.yzCount;
    }

    public float[] getVolumetricVectorLengths() {
        return this.volumetricVectorLengths;
    }

    public void setVolumetricVector(int n, float f, float f2, float f3) {
        this.volumetricVectors[n].x = f;
        this.volumetricVectors[n].y = f2;
        this.volumetricVectors[n].z = f3;
        this.setUnitVectors();
    }

    public int[] getVoxelCounts() {
        return this.voxelCounts;
    }

    public int setVoxelCounts(int n, int n2, int n3) {
        this.voxelCounts[0] = n;
        this.voxelCounts[1] = n2;
        this.voxelCounts[2] = n3;
        return n * n2 * n3;
    }

    public float getVoxelData(int n) {
        int n2 = n / this.yzCount;
        int n3 = (n -= n2 * this.yzCount) / this.voxelCounts[2];
        int n4 = n - n3 * this.voxelCounts[2];
        return this.voxelData[n2][n3][n4];
    }

    public int getPointIndex(int n, int n2, int n3) {
        return n * this.yzCount + n2 * this.voxelCounts[2] + n3;
    }

    public void getPoint(int n, Point3f point3f) {
        int n2 = n / this.yzCount;
        int n3 = (n -= n2 * this.yzCount) / this.voxelCounts[2];
        int n4 = n - n3 * this.voxelCounts[2];
        this.voxelPtToXYZ(n2, n3, n4, point3f);
    }

    public void setVoxelData(int n, float f) {
        int n2 = n / this.yzCount;
        int n3 = (n -= n2 * this.yzCount) / this.voxelCounts[2];
        int n4 = n - n3 * this.voxelCounts[2];
        this.voxelData[n2][n3][n4] = f;
    }

    public void setVoxelMap() {
        this.voxelMap = new Hashtable<Integer, Float>();
        this.getYzCount();
    }

    private boolean setMatrix() {
        for (int i = 0; i < 3; ++i) {
            this.volumetricMatrix.setColumn(i, this.volumetricVectors[i]);
        }
        try {
            this.inverseMatrix.invert(this.volumetricMatrix);
        }
        catch (Exception exception) {
            Logger.error("VolumeData error setting matrix -- bad unit vectors? ");
            return false;
        }
        return true;
    }

    public void transform(Vector3f vector3f, Vector3f vector3f2) {
        this.volumetricMatrix.transform(vector3f, vector3f2);
    }

    public void setPlaneParameters(Point4f point4f) {
        this.thePlane = point4f;
        this.thePlaneNormalMag = (float)Math.sqrt(point4f.x * point4f.x + point4f.y * point4f.y + point4f.z * point4f.z);
    }

    public float calcVoxelPlaneDistance(int n, int n2, int n3) {
        this.voxelPtToXYZ(n, n2, n3, this.ptXyzTemp);
        return this.distancePointToPlane(this.ptXyzTemp);
    }

    public float getToPlaneParameter() {
        return (float)(Math.sqrt(this.thePlane.x * this.thePlane.x + this.thePlane.y * this.thePlane.y + this.thePlane.z * this.thePlane.z) * (double)this.minToPlaneDistance);
    }

    public boolean isNearPlane(int n, int n2, int n3, float f) {
        this.voxelPtToXYZ(n, n2, n3, this.ptXyzTemp);
        return this.thePlane.x * this.ptXyzTemp.x + this.thePlane.y * this.ptXyzTemp.y + this.thePlane.z * this.ptXyzTemp.z + this.thePlane.w < f;
    }

    public float distancePointToPlane(Point3f point3f) {
        return (this.thePlane.x * point3f.x + this.thePlane.y * point3f.y + this.thePlane.z * point3f.z + this.thePlane.w) / this.thePlaneNormalMag;
    }

    public void voxelPtToXYZ(int n, int n2, int n3, Point3f point3f) {
        point3f.scaleAdd(n, this.volumetricVectors[0], this.volumetricOrigin);
        point3f.scaleAdd(n2, this.volumetricVectors[1], point3f);
        point3f.scaleAdd(n3, this.volumetricVectors[2], point3f);
    }

    public boolean setUnitVectors() {
        this.maxVectorLength = 0.0f;
        this.voxelVolume = 1.0f;
        for (int i = 0; i < 3; ++i) {
            this.volumetricVectorLengths[i] = this.volumetricVectors[i].length();
            float f = this.volumetricVectorLengths[i];
            if (f == 0.0f) {
                return false;
            }
            if (f > this.maxVectorLength) {
                this.maxVectorLength = f;
            }
            this.voxelVolume *= f;
            this.unitVolumetricVectors[i].normalize(this.volumetricVectors[i]);
        }
        this.minToPlaneDistance = this.maxVectorLength * 2.0f;
        this.origin[0] = this.volumetricOrigin.x;
        this.origin[1] = this.volumetricOrigin.y;
        this.origin[2] = this.volumetricOrigin.z;
        return this.setMatrix();
    }

    public void xyzToVoxelPt(float f, float f2, float f3, Point3i point3i) {
        this.ptXyzTemp.set(f, f2, f3);
        this.ptXyzTemp.sub(this.volumetricOrigin);
        this.inverseMatrix.transform(this.ptXyzTemp);
        point3i.set((int)this.ptXyzTemp.x, (int)this.ptXyzTemp.y, (int)this.ptXyzTemp.z);
    }

    public float lookupInterpolatedVoxelValue(Point3f point3f) {
        if (this.mappingPlane != null) {
            return this.distanceToMappingPlane(point3f);
        }
        if (this.sr != null) {
            float f = this.sr.getValueAtPoint(point3f);
            return this.isSquared ? f * f : f;
        }
        this.ptXyzTemp.sub(point3f, this.volumetricOrigin);
        this.inverseMatrix.transform(this.ptXyzTemp);
        int n = this.voxelCounts[0] - 1;
        int n2 = VolumeData.indexDown(this.ptXyzTemp.x, n);
        int n3 = n2 + (this.ptXyzTemp.x < 0.0f || n2 == n ? 0 : 1);
        n = this.voxelCounts[1] - 1;
        int n4 = VolumeData.indexDown(this.ptXyzTemp.y, n);
        int n5 = n4 + (this.ptXyzTemp.y < 0.0f || n4 == n ? 0 : 1);
        n = this.voxelCounts[2] - 1;
        int n6 = VolumeData.indexDown(this.ptXyzTemp.z, n);
        int n7 = n6 + (this.ptXyzTemp.z < 0.0f || n6 == n ? 0 : 1);
        float f = VolumeData.getFractional2DValue(this.ptXyzTemp.x - (float)n2, this.ptXyzTemp.y - (float)n4, this.getVoxelValue(n2, n4, n6), this.getVoxelValue(n3, n4, n6), this.getVoxelValue(n2, n5, n6), this.getVoxelValue(n3, n5, n6));
        float f2 = VolumeData.getFractional2DValue(this.ptXyzTemp.x - (float)n2, this.ptXyzTemp.y - (float)n4, this.getVoxelValue(n2, n4, n7), this.getVoxelValue(n3, n4, n7), this.getVoxelValue(n2, n5, n7), this.getVoxelValue(n3, n5, n7));
        return f + (this.ptXyzTemp.z - (float)n6) * (f2 - f);
    }

    public float getVoxelValue(int n, int n2, int n3) {
        if (this.voxelMap == null) {
            return this.voxelData[n][n2][n3];
        }
        Float f = this.voxelMap.get(new Integer(this.getPointIndex(n, n2, n3)));
        return f == null ? Float.NaN : f.floatValue();
    }

    public static float getFractional2DValue(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f3 + f * (f4 - f3);
        float f8 = f5 + f * (f6 - f5);
        return f7 + f2 * (f8 - f7);
    }

    private static int indexDown(float f, int n) {
        if (f < 0.0f) {
            return 0;
        }
        int n2 = (int)f;
        return n2 > n ? n : n2;
    }

    void offsetCenter(Point3f point3f) {
        Point3f point3f2 = new Point3f();
        point3f2.scaleAdd((float)(this.voxelCounts[0] - 1) / 2.0f, this.volumetricVectors[0], point3f2);
        point3f2.scaleAdd((float)(this.voxelCounts[1] - 1) / 2.0f, this.volumetricVectors[1], point3f2);
        point3f2.scaleAdd((float)(this.voxelCounts[2] - 1) / 2.0f, this.volumetricVectors[2], point3f2);
        this.volumetricOrigin.sub(point3f, point3f2);
    }

    public void setDataDistanceToPlane(Point4f point4f) {
        this.setPlaneParameters(point4f);
        int n = this.voxelCounts[0];
        int n2 = this.voxelCounts[1];
        int n3 = this.voxelCounts[2];
        this.voxelData = new float[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    this.voxelData[i][j][k] = this.calcVoxelPlaneDistance(i, j, k);
                }
            }
        }
    }

    public void filterData(boolean bl, float f) {
        int n;
        int n2;
        int n3;
        boolean bl2;
        boolean bl3 = bl2 = !Float.isNaN(f);
        if (this.sr != null) {
            this.isSquared = bl;
            return;
        }
        int n4 = this.voxelCounts[0];
        int n5 = this.voxelCounts[1];
        int n6 = this.voxelCounts[2];
        if (bl) {
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        float[] fArray = this.voxelData[n3][n2];
                        int n7 = n;
                        fArray[n7] = fArray[n7] * this.voxelData[n3][n2][n];
                    }
                }
            }
        }
        if (bl2) {
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        this.voxelData[n3][n2][n] = f - this.voxelData[n3][n2][n];
                    }
                }
            }
        }
    }

    public void capData(Point4f point4f, float f) {
        if (this.voxelData == null) {
            return;
        }
        int n = this.voxelCounts[0];
        int n2 = this.voxelCounts[1];
        int n3 = this.voxelCounts[2];
        Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
        vector3f.normalize();
        float f2 = 1.0f;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    float f3 = this.voxelData[i][j][k] - f;
                    this.voxelPtToXYZ(i, j, k, this.ptXyzTemp);
                    float f4 = (this.ptXyzTemp.x * vector3f.x + this.ptXyzTemp.y * vector3f.y + this.ptXyzTemp.z * vector3f.z + point4f.w - f) / f2;
                    if (!(f4 >= 0.0f) && !(f4 > f3)) continue;
                    this.voxelData[i][j][k] = f4;
                }
            }
        }
    }

    public String setVolumetricXml() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.voxelCounts[0] == 0) {
            XmlUtil.appendTag(stringBuffer, "jvxlVolumeData", null);
        } else {
            XmlUtil.openTag(stringBuffer, "jvxlVolumeData", new String[]{"origin", Escape.escape(this.volumetricOrigin)});
            for (int i = 0; i < 3; ++i) {
                XmlUtil.appendTag(stringBuffer, "jvxlVolumeVector", new String[]{"type", "" + i, "count", "" + this.voxelCounts[i], "vector", Escape.escape(this.volumetricVectors[i])});
            }
            XmlUtil.closeTag(stringBuffer, "jvxlVolumeData");
        }
        this.xmlData = stringBuffer.toString();
        return this.xmlData;
    }

    public void setVoxelMapValue(int n, int n2, int n3, float f) {
        if (this.voxelMap == null) {
            return;
        }
        this.voxelMap.put(new Integer(this.getPointIndex(n, n2, n3)), Float.valueOf(f));
    }

    public float calculateFractionalPoint(float f, Point3f point3f, Point3f point3f2, float f2, float f3, Point3f point3f3) {
        float f4;
        float f5;
        float f6 = f3 - f2;
        float f7 = (f - f2) / f6;
        this.edgeVector.sub(point3f2, point3f);
        point3f3.scaleAdd(f7, this.edgeVector, point3f);
        if (this.sr == null || !this.doIterate || f3 == f2 || f7 < 0.01f || f7 > 0.99f || this.edgeVector.length() < 0.01f) {
            return f;
        }
        int n = 0;
        this.ptTemp.set(point3f3);
        float f8 = this.lookupInterpolatedVoxelValue(this.ptTemp);
        float f9 = Float.NaN;
        while (!(++n >= 10 || (f5 = (f8 - f2) / f6) < 0.0f || f5 > 1.0f || (f7 += (f4 = (f - f8) / f6 / 2.0f)) < 0.0f || f7 > 1.0f)) {
            point3f3.set(this.ptTemp);
            f9 = f8;
            if (Math.abs(f4) < 0.005f) break;
            this.ptTemp.scaleAdd(f4, this.edgeVector, point3f3);
            f8 = this.lookupInterpolatedVoxelValue(this.ptTemp);
        }
        return f9;
    }
}

