/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.util.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlReader
extends AtomSetCollectionReader {
    protected Atom atom;
    protected String[] implementedAttributes = new String[]{"id"};
    protected XmlReader parent;
    protected boolean keepChars;
    protected String chars;

    @Override
    public void initializeReader() throws Exception {
        XMLReader xMLReader = this.getXMLReader();
        if (xMLReader == null) {
            this.atomSetCollection = new AtomSetCollection("xml", this);
            this.atomSetCollection.errorMessage = "No XML reader found";
            return;
        }
        this.processXml(xMLReader);
        this.continuing = false;
    }

    private XMLReader getXMLReader() {
        XMLReader xMLReader = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            xMLReader = sAXParser.getXMLReader();
            Logger.debug("Using JAXP/SAX XML parser.");
        }
        catch (Exception exception) {
            Logger.debug("Could not instantiate JAXP/SAX XML reader: " + exception.getMessage());
        }
        return xMLReader;
    }

    private Object processXml(XMLReader xMLReader) throws Exception {
        this.atomSetCollection = new AtomSetCollection(this.readerName, this);
        Object object = this.getXmlReader();
        if (object instanceof String) {
            return object;
        }
        XmlReader xmlReader = (XmlReader)object;
        xmlReader.processXml(this, this.atomSetCollection, this.reader, xMLReader, xmlReader.getHandler(xMLReader));
        return xmlReader;
    }

    private Object getXmlReader() {
        String string = null;
        String string2 = null;
        XmlReader xmlReader = null;
        try {
            int n = this.readerName.indexOf("(");
            String string3 = n < 0 ? this.readerName : this.readerName.substring(0, n);
            string = Resolver.getReaderClassBase(string3);
            Class<?> clazz = Class.forName(string);
            xmlReader = (XmlReader)clazz.newInstance();
        }
        catch (Exception exception) {
            string2 = "File reader was not found:" + string;
            Logger.error(string2);
            return string2;
        }
        return xmlReader;
    }

    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, Object object, JmolXmlHandler jmolXmlHandler) {
        this.parent = xmlReader;
        this.atomSetCollection = atomSetCollection;
        this.reader = bufferedReader;
        if (object instanceof XMLReader) {
            this.parseReaderXML((XMLReader)object);
        } else {
            this.getImplementedAttributes();
            jmolXmlHandler.walkDOMTree(object);
        }
    }

    protected void parseReaderXML(XMLReader xMLReader) {
        xMLReader.setEntityResolver(new DummyResolver());
        InputSource inputSource = new InputSource(this.reader);
        inputSource.setSystemId("foo");
        try {
            xMLReader.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.atomSetCollection.errorMessage = "XML parsing error: " + exception.getMessage();
        }
    }

    @Override
    protected void processXml(Object object) {
        this.atomSetCollection = new AtomSetCollection(this.readerName, this);
        String string = null;
        XmlReader xmlReader = null;
        String string2 = this.readerName.substring(0, this.readerName.indexOf("("));
        try {
            string = Resolver.getReaderClassBase(string2);
            Class<?> clazz = Class.forName(string);
            xmlReader = (XmlReader)clazz.newInstance();
            xmlReader.processXml(this, this.atomSetCollection, this.reader, object, xmlReader.getHandler(null));
        }
        catch (Exception exception) {
            this.atomSetCollection.errorMessage = "File reader was not found:" + string;
        }
    }

    protected String[] getImplementedAttributes() {
        return this.implementedAttributes;
    }

    protected void processStartElement(String string, String string2, String string3, Map<String, String> map) {
    }

    protected void setKeepChars(boolean bl) {
        this.keepChars = bl;
        this.chars = null;
    }

    protected void processEndElement(String string, String string2, String string3) {
    }

    @Override
    public void applySymmetryAndSetTrajectory() {
        try {
            if (this.parent == null) {
                super.applySymmetryAndSetTrajectory();
            } else {
                this.parent.applySymmetryAndSetTrajectory();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.error("applySymmetry failed: " + exception);
        }
    }

    protected JmolXmlHandler getHandler(Object object) {
        return new JmolXmlHandler(object);
    }

    public class JmolXmlHandler
    extends DefaultHandler {
        public Map<String, String> atts;
        private String context = "";

        public JmolXmlHandler(Object object) {
            if (object instanceof XMLReader) {
                this.setHandler((XMLReader)object, this);
            }
        }

        private void setHandler(XMLReader xMLReader, JmolXmlHandler jmolXmlHandler) {
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", false);
                xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xMLReader.setEntityResolver(jmolXmlHandler);
                xMLReader.setContentHandler(jmolXmlHandler);
                xMLReader.setErrorHandler(jmolXmlHandler);
            }
            catch (Exception exception) {
                Logger.error("ERROR IN XmlReader.JmolXmlHandler.setHandler", exception);
            }
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.getAttributes(attributes);
            if (Logger.debugging) {
                this.context = this.context + " " + string2;
                Logger.debug(this.context);
            }
            this.startElement(string, string2, string3);
        }

        private void startElement(String string, String string2, String string3) {
            XmlReader.this.processStartElement(string, string2, string3, this.atts);
        }

        public void endElement(String string, String string2, String string3) {
            if (Logger.debugging) {
                Logger.debug("");
                this.context = this.context.substring(0, this.context.lastIndexOf(" "));
            }
            XmlReader.this.processEndElement(string, string2, string3);
        }

        public void characters(char[] cArray, int n, int n2) {
            if (XmlReader.this.keepChars) {
                XmlReader.this.chars = XmlReader.this.chars == null ? new String(cArray, n, n2) : XmlReader.this.chars + new String(cArray, n, n2);
            }
        }

        public InputSource resolveEntity(String string, String string2, String string3, String string4) {
            if (Logger.debugging) {
                Logger.debug("Not resolving this:\n      name: " + string + "\n  systemID: " + string4 + "\n  publicID: " + string2 + "\n   baseURI: " + string3);
            }
            return null;
        }

        public InputSource resolveEntity(String string, String string2) {
            if (Logger.debugging) {
                Logger.debug("Not resolving this:\n  publicID: " + string + "\n  systemID: " + string2);
            }
            return null;
        }

        public void error(SAXParseException sAXParseException) {
            Logger.error("SAX ERROR:" + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) {
            Logger.error("SAX FATAL:" + sAXParseException.getMessage());
        }

        public void warning(SAXParseException sAXParseException) {
            Logger.warn("SAX WARNING:" + sAXParseException.getMessage());
        }

        protected void walkDOMTree(Object object) {
            String string = (String)this.jsObjectGetMember(object, "localName");
            if (string == null) {
                return;
            }
            String string2 = (String)this.jsObjectGetMember(object, "namespaceURI");
            String string3 = (String)this.jsObjectGetMember(object, "nodeName");
            this.getAttributes(this.jsObjectGetMember(object, "attributes"));
            this.startElement(string2, string, string3);
            if (((Boolean)this.jsObjectCall(object, "hasChildNodes", null)).booleanValue()) {
                Object object2 = this.jsObjectGetMember(object, "firstChild");
                while (object2 != null) {
                    this.walkDOMTree(object2);
                    object2 = this.jsObjectGetMember(object2, "nextSibling");
                }
            }
            this.endElement(string2, string, string3);
        }

        private void getAttributes(Attributes attributes) {
            int n = attributes.getLength();
            this.atts = new Hashtable<String, String>(n);
            int n2 = n;
            while (--n2 >= 0) {
                this.atts.put(attributes.getLocalName(n2), attributes.getValue(n2));
            }
        }

        private void getAttributes(Object object) {
            if (object == null) {
                this.atts = new Hashtable<String, String>(0);
                return;
            }
            Number number = (Number)this.jsObjectGetMember(object, "length");
            if (number == null) {
                return;
            }
            int n = number.intValue();
            this.atts = new Hashtable<String, String>(n);
            int n2 = XmlReader.this.implementedAttributes.length;
            while (--n2 >= 0) {
                Object[] objectArray = new Object[]{XmlReader.this.implementedAttributes[n2]};
                Object object2 = this.jsObjectCall(object, "getNamedItem", objectArray);
                if (object2 == null) continue;
                String string = (String)this.jsObjectGetMember(object2, "name");
                String string2 = (String)this.jsObjectGetMember(object2, "value");
                if (string == null || string2 == null) continue;
                this.atts.put(string, string2);
            }
        }

        private Object jsObjectCall(Object object, String string, Object[] objectArray) {
            return XmlReader.this.parent.viewer.getJsObjectInfo(object, string, objectArray);
        }

        private Object jsObjectGetMember(Object object, String string) {
            return XmlReader.this.parent.viewer.getJsObjectInfo(object, string, null);
        }
    }

    public static class DummyResolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (Logger.debugging) {
                Logger.debug("Jmol SAX EntityResolver not resolving:\n  publicID: " + string + "\n  systemID: " + string2);
            }
            return new InputSource(new BufferedReader(new StringReader("")));
        }
    }
}

