/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cifpdb;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.SymmetryInterface;
import org.jmol.constant.EnumStructure;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Quadric;
import org.jmol.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdbReader
extends AtomSetCollectionReader {
    private int lineLength;
    private StringBuffer pdbHeader;
    private boolean applySymmetry;
    private boolean getTlsGroups;
    private boolean isMultiModel;
    private boolean haveMappedSerials;
    private boolean isConnectStateBug;
    private boolean isLegacyModelType;
    private final Map<String, Map<String, Boolean>> htFormul = new Hashtable<String, Map<String, Boolean>>();
    private Map<String, String> htHetero;
    private Map<String, Map<String, Object>> htSites;
    private Map<String, Boolean> htElementsInCurrentGroup;
    private Map<String, Map<String, String>> htMolIds;
    private List<Map<String, String>> vCompnds;
    private List<Matrix4f> vBiomts;
    private List<Map<String, Object>> vBiomolecules;
    private List<Map<String, Object>> vTlsModels;
    private StringBuffer sbTlsErrors;
    private int[] chainAtomCounts;
    private StringBuffer sbIgnored;
    private StringBuffer sbSelected;
    private StringBuffer sbConect;
    private StringBuffer sb;
    private int atomCount;
    private int maxSerial;
    private int nUNK;
    private int nRes;
    private Map<String, String> currentCompnd;
    private String currentGroup3;
    private String currentKey;
    private int currentResno = Integer.MIN_VALUE;
    private int configurationPtr = Integer.MIN_VALUE;
    private boolean resetKey = true;
    private String compnd = null;
    private int conformationIndex;
    private int fileAtomIndex;
    private char lastAltLoc;
    private String lastAtomData;
    private int lastAtomIndex;
    private int lastGroup = Integer.MIN_VALUE;
    private char lastInsertion;
    private int lastSourceSerial = Integer.MIN_VALUE;
    private int lastTargetSerial = Integer.MIN_VALUE;
    private int tlsGroupID;
    private static final String lineOptions = "ATOM    HETATM  MODEL   CONECT  HELIX   SHEET   TURN    HET     HETNAM  ANISOU  SITE    CRYST1  SCALE1  SCALE2  SCALE3  EXPDTA  FORMUL  REMARK  HEADER  COMPND  SOURCE  TITLE   ";
    private boolean haveDoubleBonds;
    private final float[] dataT = new float[8];
    private static final float RAD_PER_DEG = (float)Math.PI / 180;
    private static final float _8PI2_ = 78.95683f;
    private Map<Atom, float[]> tlsU;

    protected void initializeReader() throws Exception {
        this.setIsPDB();
        this.pdbHeader = this.getHeader ? new StringBuffer() : null;
        this.applySymmetry = !this.checkFilter("NOSYMMETRY");
        this.getTlsGroups = this.checkFilter("TLS");
        if (this.htParams.containsKey("vTlsModels")) {
            this.vTlsModels = (List)this.htParams.remove("vTlsModels");
        }
        if (this.checkFilter("CONF ")) {
            this.configurationPtr = this.parseInt(this.filter, this.filter.indexOf("CONF ") + 5);
            this.sbIgnored = new StringBuffer();
            this.sbSelected = new StringBuffer();
        }
        this.isLegacyModelType = this.stateScriptVersionInt < 120000;
        this.isConnectStateBug = this.stateScriptVersionInt >= 120151 && this.stateScriptVersionInt <= 120220 || this.stateScriptVersionInt >= 120300 && this.stateScriptVersionInt <= 120320;
    }

    protected boolean checkLine() throws Exception {
        boolean bl;
        this.lineLength = this.line.length();
        int n = (this.lineLength < 6 ? -1 : lineOptions.indexOf(this.line.substring(0, 6))) >> 3;
        boolean bl2 = n == 0 || n == 1;
        boolean bl3 = n == 2;
        int n2 = bl2 ? this.parseInt(this.line, 6, 11) : 0;
        boolean bl4 = bl = (this.isTrajectory || this.isSequential) && !this.isMultiModel && bl2 && n2 == 1;
        if (this.getHeader) {
            if (bl2 || bl3) {
                this.getHeader = false;
            } else {
                this.pdbHeader.append(this.line).append('\n');
            }
        }
        if (bl3 || bl) {
            this.isMultiModel = bl3;
            this.getHeader = false;
            int n3 = bl ? this.modelNumber + 1 : this.getModelNumber();
            int n4 = this.modelNumber = this.bsModels == null ? n3 : this.modelNumber + 1;
            if (!this.doGetModel(this.modelNumber, null)) {
                this.handleTlsMissingModels();
                return this.checkLastModel();
            }
            this.atomSetCollection.connectAll(this.maxSerial, this.isConnectStateBug);
            if (this.atomCount > 0) {
                this.applySymmetryAndSetTrajectory();
            }
            this.model(n3);
            if (this.isLegacyModelType || !bl2) {
                return true;
            }
        }
        if (this.isMultiModel && !this.doProcessLines) {
            return true;
        }
        if (bl2) {
            this.getHeader = false;
            this.atom(n2);
            return true;
        }
        switch (n) {
            case 3: {
                this.conect();
                return true;
            }
            case 4: 
            case 5: 
            case 6: {
                this.structure();
                return true;
            }
            case 7: {
                this.het();
                return true;
            }
            case 8: {
                this.hetnam();
                return true;
            }
            case 9: {
                this.anisou();
                return true;
            }
            case 10: {
                this.site();
                return true;
            }
            case 11: {
                this.cryst1();
                return true;
            }
            case 12: 
            case 13: 
            case 14: {
                this.scale(n - 11);
                return true;
            }
            case 15: {
                this.expdta();
                return true;
            }
            case 16: {
                this.formul();
                return true;
            }
            case 17: {
                if (this.line.startsWith("REMARK 350")) {
                    this.remark350();
                    return false;
                }
                if (this.line.startsWith("REMARK 290")) {
                    this.remark290();
                    return false;
                }
                if (this.getTlsGroups && this.line.indexOf("TLS DETAILS") > 0) {
                    return this.remarkTls();
                }
                this.checkLineForScript();
                return true;
            }
            case 18: {
                this.header();
                return true;
            }
            case 19: 
            case 20: {
                this.compnd(n == 20);
                return true;
            }
            case 21: {
                this.title();
                return true;
            }
        }
        return true;
    }

    protected void finalizeReader() throws Exception {
        this.checkNotPDB();
        this.atomSetCollection.connectAll(this.maxSerial, this.isConnectStateBug);
        if (this.vBiomolecules != null && this.vBiomolecules.size() > 0 && this.atomSetCollection.getAtomCount() > 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("biomolecules", this.vBiomolecules);
            this.setBiomoleculeAtomCounts();
            if (this.vBiomts != null && this.applySymmetry) {
                this.atomSetCollection.applySymmetry(this.vBiomts, this.notionalUnitCell, this.applySymmetryToBonds, this.filter);
                this.vTlsModels = null;
            }
        }
        if (this.vTlsModels != null) {
            SymmetryInterface symmetryInterface = (SymmetryInterface)Interface.getOptionInterface((String)"symmetry.Symmetry");
            int n = this.atomSetCollection.getAtomSetCount();
            if (n == this.vTlsModels.size()) {
                int n2 = n;
                while (--n2 >= 0) {
                    this.setTlsGroups(n2, n2, symmetryInterface);
                }
            } else {
                Logger.info((String)(n + " models but " + this.vTlsModels.size() + " TLS descriptions"));
                if (this.vTlsModels.size() == 1) {
                    Logger.info((String)" -- assuming all models have the same TLS description -- check REMARK 3 for details.");
                    int n3 = n;
                    while (--n3 >= 0) {
                        this.setTlsGroups(0, n3, symmetryInterface);
                    }
                }
            }
            this.checkForResidualBFactors(symmetryInterface);
        }
        if (this.sbTlsErrors != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("tlsErrors", (Object)this.sbTlsErrors.toString());
            this.appendLoadNote(this.sbTlsErrors.toString());
        }
        super.finalizeReader();
        if (this.vCompnds != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("compoundSource", this.vCompnds);
        }
        if (this.htSites != null) {
            this.addSites(this.htSites);
        }
        if (this.pdbHeader != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", (Object)this.pdbHeader.toString());
        }
        if (this.configurationPtr > 0) {
            Logger.info((String)this.sbSelected.toString());
            Logger.info((String)this.sbIgnored.toString());
        }
    }

    private void checkForResidualBFactors(SymmetryInterface symmetryInterface) {
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        boolean bl = false;
        int n = this.atomSetCollection.getAtomCount();
        while (--n >= 0) {
            float f;
            float[] object = this.tlsU.get(atomArray[n]);
            if (object == null || !((f = object[7] - (object[0] + object[1] + object[2]) / 3.0f) < 0.0f) && !Float.isNaN(f)) continue;
            bl = true;
            break;
        }
        Logger.info((String)("TLS analysis suggests Bfactors are " + (bl ? "" : "NOT") + " residuals"));
        for (Map.Entry<Atom, float[]> entry : this.tlsU.entrySet()) {
            float[] fArray = entry.getValue();
            float f = fArray[7];
            if (f == 0.0f) continue;
            if (!bl) {
                f -= (fArray[0] + fArray[1] + fArray[2]) / 3.0f;
            }
            fArray[0] = fArray[0] + f;
            fArray[1] = fArray[1] + f;
            fArray[2] = fArray[2] + f;
            entry.getKey().ellipsoid[1] = symmetryInterface.getEllipsoid(fArray);
            System.out.println("TLS-U:  " + Escape.escape((Object)fArray));
            fArray = entry.getKey().anisoBorU;
            if (fArray == null) continue;
            System.out.println("ANISOU: " + Escape.escape((Object)fArray));
        }
        this.tlsU = null;
    }

    private void header() {
        if (this.lineLength < 8) {
            return;
        }
        this.appendLoadNote(this.line.substring(7).trim());
        if (this.lineLength >= 66) {
            this.atomSetCollection.setCollectionName(this.line.substring(62, 66));
        }
        if (this.lineLength > 50) {
            this.line = this.line.substring(0, 50);
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("CLASSIFICATION", (Object)this.line.substring(7).trim());
    }

    private void title() {
        if (this.lineLength < 10) {
            return;
        }
        this.appendLoadNote(this.line.substring(10).trim());
    }

    private void compnd(boolean bl) {
        String string;
        if (!bl) {
            this.compnd = this.compnd == null ? "" : this.compnd + " ";
            String string2 = this.line;
            if (this.lineLength > 62) {
                string2 = string2.substring(0, 62);
            }
            this.compnd = this.compnd + string2.substring(10).trim();
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("COMPND", (Object)this.compnd);
        }
        if (this.vCompnds == null) {
            if (bl) {
                return;
            }
            this.vCompnds = new ArrayList<Map<String, String>>();
            this.htMolIds = new Hashtable<String, Map<String, String>>();
            this.currentCompnd = new Hashtable<String, String>();
            this.currentCompnd.put("select", "(*)");
            this.currentKey = "MOLECULE";
            this.htMolIds.put("", this.currentCompnd);
        }
        if (bl && this.resetKey) {
            this.resetKey = false;
            this.currentKey = "SOURCE";
            this.currentCompnd = this.htMolIds.get("");
        }
        this.line = this.line.substring(10, Math.min(this.lineLength, 72)).trim();
        int n = this.line.indexOf(":");
        if (n < 0 || n > 0 && this.line.charAt(n - 1) == '\\') {
            n = this.line.length();
        }
        String string3 = this.line.substring(0, n).trim();
        String string4 = string = n < this.line.length() ? this.line.substring(n + 1) : null;
        if (string3.equals("MOL_ID")) {
            if (string == null) {
                return;
            }
            if (bl) {
                this.currentCompnd = this.htMolIds.remove(string);
                return;
            }
            this.currentCompnd = new Hashtable<String, String>();
            this.vCompnds.add(this.currentCompnd);
            this.htMolIds.put(string, this.currentCompnd);
        }
        if (this.currentCompnd == null) {
            return;
        }
        if (string == null) {
            string = this.currentCompnd.get(this.currentKey);
            if (string == null) {
                string = "";
            }
            string = string + string3;
            if (this.vCompnds.size() == 0) {
                this.vCompnds.add(this.currentCompnd);
            }
        } else {
            this.currentKey = string3;
        }
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        this.currentCompnd.put(this.currentKey, string);
        if (this.currentKey.equals("CHAIN")) {
            this.currentCompnd.put("select", "(:" + TextFormat.simpleReplace((String)TextFormat.simpleReplace((String)string, (String)", ", (String)",:"), (String)" ", (String)"") + ")");
        }
    }

    private void setBiomoleculeAtomCounts() {
        int n = this.vBiomolecules.size();
        while (--n >= 0) {
            Map<String, Object> map = this.vBiomolecules.get(n);
            String string = (String)map.get("chains");
            int n2 = ((List)map.get("biomts")).size();
            int n3 = 0;
            int n4 = string.length() - 1;
            while (--n4 >= 0) {
                if (string.charAt(n4) != ':') continue;
                n3 += this.chainAtomCounts[string.charAt(n4 + 1)];
            }
            map.put("atomCount", n3 * n2);
        }
    }

    private void remark350() throws Exception {
        ArrayList<Matrix4f> arrayList = null;
        this.vBiomolecules = new ArrayList<Map<String, Object>>();
        this.chainAtomCounts = new int[255];
        String string = "";
        String string2 = "";
        int n = 0;
        boolean bl = true;
        Hashtable<String, Object> hashtable = null;
        int n2 = 0;
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        while (true) {
            if (bl) {
                this.readLine();
            } else {
                bl = true;
            }
            if (this.line == null || !this.line.startsWith("REMARK 350")) break;
            try {
                if (this.line.startsWith("REMARK 350 BIOMOLECULE:")) {
                    if (n2 > 0) {
                        Logger.info((String)("biomolecule " + n + ": number of transforms: " + n2));
                    }
                    hashtable = new Hashtable<String, Object>();
                    arrayList = new ArrayList<Matrix4f>();
                    n = this.parseInt(this.line.substring(this.line.indexOf(":") + 1));
                    string = this.line.trim();
                    hashtable.put("molecule", n);
                    hashtable.put("title", string);
                    hashtable.put("chains", "");
                    hashtable.put("biomts", arrayList);
                    this.vBiomolecules.add(hashtable);
                    n2 = 0;
                }
                if (this.line.indexOf("APPLY THE FOLLOWING TO CHAINS:") >= 0) {
                    if (hashtable == null) {
                        bl = false;
                        this.line = "REMARK 350 BIOMOLECULE: 1  APPLY THE FOLLOWING TO CHAINS:";
                        continue;
                    }
                    string2 = ":" + this.line.substring(41).trim().replace(' ', ':');
                    bl = false;
                    while (this.readLine() != null && this.line.indexOf("BIOMT") < 0) {
                        string2 = string2 + ":" + this.line.substring(11).trim().replace(' ', ':');
                    }
                    if (this.checkFilter("BIOMOLECULE " + n + ";")) {
                        this.setFilter(this.filter.replace(':', '_') + string2);
                        Logger.info((String)("filter set to \"" + this.filter + "\""));
                        this.vBiomts = arrayList;
                    }
                    hashtable.put("chains", string2);
                    continue;
                }
                if (!this.line.startsWith("REMARK 350   BIOMT1 ")) continue;
                ++n2;
                float[] fArray = new float[16];
                int n3 = 0;
                while (n3 < 12) {
                    String[] stringArray = this.getTokens();
                    fArray[n3++] = this.parseFloat(stringArray[4]);
                    fArray[n3++] = this.parseFloat(stringArray[5]);
                    fArray[n3++] = this.parseFloat(stringArray[6]);
                    fArray[n3++] = this.parseFloat(stringArray[7]);
                    if (n3 != 4 && n3 != 8) continue;
                    this.readLine();
                }
                fArray[15] = 1.0f;
                Matrix4f matrix4f2 = new Matrix4f();
                matrix4f2.set(fArray);
                if (matrix4f2.equals(matrix4f)) {
                    arrayList.add(0, matrix4f2);
                    continue;
                }
                arrayList.add(matrix4f2);
            }
            catch (Exception exception) {
                this.vBiomts = null;
                this.vBiomolecules = null;
                return;
            }
        }
        if (n2 > 0) {
            Logger.info((String)("biomolecule " + n + ": number of transforms: " + n2));
        }
    }

    private void remark290() throws Exception {
        while (this.readLine() != null && this.line.startsWith("REMARK 290")) {
            String[] stringArray;
            if (this.line.indexOf("NNNMMM   OPERATOR") < 0) continue;
            while (this.readLine() != null && (stringArray = this.getTokens()).length >= 4) {
                this.setSymmetryOperator(stringArray[3]);
            }
        }
    }

    private void atom(int n) {
        Atom atom = new Atom();
        atom.atomName = this.line.substring(12, 16).trim();
        char c = this.line.charAt(16);
        if (c != ' ') {
            atom.alternateLocationID = c;
        }
        atom.group3 = this.parseToken(this.line, 17, 20);
        c = this.line.charAt(21);
        if (this.chainAtomCounts != null) {
            char c2 = c;
            this.chainAtomCounts[c2] = this.chainAtomCounts[c2] + 1;
        }
        atom.chainID = c;
        atom.sequenceNumber = this.parseInt(this.line, 22, 26);
        atom.insertionCode = JmolAdapter.canonizeInsertionCode((char)this.line.charAt(26));
        atom.isHetero = this.line.startsWith("HETATM");
        atom.elementSymbol = this.deduceElementSymbol(atom.isHetero);
        if (!this.filterAtom(atom, this.fileAtomIndex++)) {
            return;
        }
        atom.atomSerial = n;
        if (n > this.maxSerial) {
            this.maxSerial = n;
        }
        if (atom.group3 == null) {
            if (this.currentGroup3 != null) {
                this.currentGroup3 = null;
                this.currentResno = Integer.MIN_VALUE;
                this.htElementsInCurrentGroup = null;
            }
        } else if (!atom.group3.equals(this.currentGroup3) || atom.sequenceNumber != this.currentResno) {
            this.currentGroup3 = atom.group3;
            this.currentResno = atom.sequenceNumber;
            this.htElementsInCurrentGroup = this.htFormul.get(atom.group3);
            ++this.nRes;
            if (atom.group3.equals("UNK")) {
                ++this.nUNK;
            }
        }
        int n2 = 0;
        if (this.lineLength >= 80) {
            char c3 = this.line.charAt(78);
            char c4 = this.line.charAt(79);
            if (c4 >= '0' && c4 <= '7') {
                char c5 = c4;
                c4 = c3;
                c3 = c5;
            }
            if ((c4 == '+' || c4 == '-' || c4 == ' ') && c3 >= '0' && c3 <= '7') {
                n2 = c3 - 48;
                if (c4 == '-') {
                    n2 = -n2;
                }
            }
        }
        atom.formalCharge = n2;
        this.setAtomCoord(atom, this.parseFloat(this.line, 30, 38), this.parseFloat(this.line, 38, 46), this.parseFloat(this.line, 46, 54));
        this.setAdditionalAtomParameters(atom);
        this.lastAtomData = this.line.substring(6, 26);
        this.lastAtomIndex = this.atomSetCollection.getAtomCount();
        if (this.haveMappedSerials) {
            this.atomSetCollection.addAtomWithMappedSerialNumber(atom);
        } else {
            this.atomSetCollection.addAtom(atom);
        }
        if (this.atomCount++ == 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", (Object)Boolean.TRUE);
        }
        if (atom.isHetero && this.htHetero != null) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
    }

    protected boolean filterAtom(Atom atom, int n) {
        if (!super.filterAtom(atom, n)) {
            return false;
        }
        if (this.configurationPtr > 0) {
            if (atom.sequenceNumber != this.lastGroup || atom.insertionCode != this.lastInsertion) {
                this.conformationIndex = this.configurationPtr - 1;
                this.lastGroup = atom.sequenceNumber;
                this.lastInsertion = atom.insertionCode;
                this.lastAltLoc = '\u0000';
            }
            if (atom.alternateLocationID != '\u0000') {
                String string = " atom [" + atom.group3 + "]" + atom.sequenceNumber + (atom.insertionCode == '\u0000' ? "" : "^" + atom.insertionCode) + (atom.chainID == '\u0000' ? "" : ":" + atom.chainID) + "." + atom.atomName + "%" + atom.alternateLocationID + "\n";
                if (this.conformationIndex >= 0 && atom.alternateLocationID != this.lastAltLoc) {
                    this.lastAltLoc = atom.alternateLocationID;
                    --this.conformationIndex;
                }
                if (this.conformationIndex < 0 && atom.alternateLocationID != this.lastAltLoc) {
                    this.sbIgnored.append("ignoring").append(string);
                    return false;
                }
                this.sbSelected.append("loading").append(string);
            }
        }
        return true;
    }

    protected void setAdditionalAtomParameters(Atom atom) {
        float f = this.parseFloat(this.line, 54, 60);
        atom.occupancy = Float.isNaN(f) ? 100 : (int)(f * 100.0f);
        atom.bfactor = this.parseFloat(this.line, 60, 66);
    }

    private String deduceElementSymbol(boolean bl) {
        char c;
        char c2;
        if (this.lineLength >= 78) {
            c2 = this.line.charAt(76);
            c = this.line.charAt(77);
            if (c2 == ' ' && Atom.isValidElementSymbol((char)c)) {
                return "" + c;
            }
            if (Atom.isValidElementSymbolNoCaseSecondChar((char)c2, (char)c)) {
                return "" + c2 + c;
            }
        }
        c2 = this.line.charAt(12);
        c = this.line.charAt(13);
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get(this.line.substring(12, 14)) != null) && Atom.isValidElementSymbolNoCaseSecondChar((char)c2, (char)c)) {
            return bl || c2 != 'H' ? "" + c2 + c : "H";
        }
        if (c2 == 'H') {
            return "H";
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + c) != null) && Atom.isValidElementSymbol((char)c)) {
            return "" + c;
        }
        if (c2 != ' ' && (this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + c2) != null) && Atom.isValidElementSymbol((char)c2)) {
            return "" + c2;
        }
        char c3 = this.line.charAt(14);
        if (c2 == ' ' && c != 'X' && (this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get(this.line.substring(13, 15)) != null) && Atom.isValidElementSymbolNoCaseSecondChar((char)c, (char)c3)) {
            return "" + c + c3;
        }
        return "Xx";
    }

    private void conect() {
        if (this.sbConect == null) {
            this.sbConect = new StringBuffer();
            this.sb = new StringBuffer();
        } else {
            this.sb.setLength(0);
        }
        int n = -1;
        n = this.parseInt(this.line, 6, 11);
        if (n < 0) {
            return;
        }
        for (int i = 0; i < 9; i += i == 5 ? 2 : 1) {
            int n2;
            boolean bl;
            boolean bl2;
            int n3;
            int n4 = i * 5 + 11;
            int n5 = n4 + 5;
            int n6 = n3 = n5 <= this.lineLength ? this.parseInt(this.line, n4, n5) : -1;
            if (n3 < 0) continue;
            boolean bl3 = bl2 = n == this.lastSourceSerial && n3 == this.lastTargetSerial;
            if (bl2) {
                this.haveDoubleBonds = true;
            }
            this.lastSourceSerial = n;
            this.lastTargetSerial = n3;
            boolean bl4 = bl = n3 < n;
            if (bl) {
                n2 = n3;
                n3 = n;
            } else {
                n2 = n;
            }
            String string = ";" + n2 + " " + n3 + ";";
            if (this.sbConect.indexOf(string) >= 0 && !bl2) continue;
            if (this.haveDoubleBonds) {
                String string2 = "--" + string;
                if (this.sbConect.indexOf(string2) >= 0) continue;
                this.sbConect.append(string);
                this.sb.append(string2);
            } else {
                this.sbConect.append(string);
            }
            this.atomSetCollection.addConnection(new int[]{n2, n3, i < 4 ? 1 : 2048});
        }
        this.sbConect.append(this.sb);
    }

    private void structure() {
        int n;
        int n2;
        int n3;
        int n4;
        EnumStructure enumStructure = EnumStructure.NONE;
        EnumStructure enumStructure2 = EnumStructure.NONE;
        int n5 = 0;
        if (this.line.startsWith("HELIX ")) {
            enumStructure = EnumStructure.HELIX;
            n4 = 19;
            n3 = 21;
            n2 = 31;
            n = 33;
            if (this.line.length() >= 40) {
                enumStructure2 = Structure.getHelixType((int)this.parseInt(this.line.substring(38, 40)));
            }
        } else if (this.line.startsWith("SHEET ")) {
            enumStructure = EnumStructure.SHEET;
            n4 = 21;
            n3 = 22;
            n2 = 32;
            n = 33;
            n5 = this.parseInt(this.line.substring(14, 16));
        } else if (this.line.startsWith("TURN  ")) {
            enumStructure = EnumStructure.TURN;
            n4 = 19;
            n3 = 20;
            n2 = 30;
            n = 31;
        } else {
            return;
        }
        if (this.lineLength < n + 4) {
            return;
        }
        String string = this.line.substring(11, 15).trim();
        int n6 = this.parseInt(this.line.substring(7, 10));
        char c = this.line.charAt(n4);
        int n7 = this.parseInt(this.line, n3, n3 + 4);
        char c2 = this.line.charAt(n3 + 4);
        char c3 = this.line.charAt(n2);
        int n8 = this.parseInt(this.line, n, n + 4);
        char c4 = ' ';
        if (this.lineLength > n + 4) {
            c4 = this.line.charAt(n + 4);
        }
        if (enumStructure2 == EnumStructure.NONE) {
            enumStructure2 = enumStructure;
        }
        Structure structure = new Structure(-1, enumStructure, enumStructure2, string, n6, n5, c, n7, c2, c3, n8, c4);
        this.atomSetCollection.addStructure(structure);
    }

    private int getModelNumber() {
        try {
            int n = 6;
            int n2 = 14;
            if (n2 > this.lineLength) {
                n2 = this.lineLength;
            }
            return this.parseInt(this.line, n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void model(int n) {
        this.checkNotPDB();
        this.haveMappedSerials = false;
        this.sbConect = null;
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", (Object)Boolean.TRUE);
        this.atomSetCollection.setAtomSetNumber(n);
    }

    private void checkNotPDB() {
        boolean bl = this.nRes == 0 || this.nUNK != this.nRes;
        this.atomSetCollection.setCheckSpecial(!bl);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        this.nRes = 0;
        this.nUNK = 0;
        this.currentGroup3 = null;
    }

    private void cryst1() throws Exception {
        float f = this.getFloat(6, 9);
        if (f == 1.0f) {
            f = Float.NaN;
        }
        this.setUnitCell(f, this.getFloat(15, 9), this.getFloat(24, 9), this.getFloat(33, 7), this.getFloat(40, 7), this.getFloat(47, 7));
        this.setSpaceGroupName(PdbReader.parseTrimmed((String)this.line, (int)55, (int)66));
    }

    private float getFloat(int n, int n2) throws Exception {
        return this.parseFloat(this.line, n, n + n2);
    }

    private void scale(int n) throws Exception {
        int n2 = n * 4 + 2;
        this.setUnitCellItem(n2++, this.getFloat(10, 10));
        this.setUnitCellItem(n2++, this.getFloat(20, 10));
        this.setUnitCellItem(n2++, this.getFloat(30, 10));
        this.setUnitCellItem(n2++, this.getFloat(45, 10));
    }

    private void expdta() {
        if (this.line.toUpperCase().indexOf("NMR") >= 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isNMRdata", (Object)"true");
        }
    }

    private void formul() {
        String string;
        Map<String, Boolean> map;
        String string2 = this.parseToken(this.line, 12, 15);
        String string3 = PdbReader.parseTrimmed((String)this.line, (int)19, (int)70);
        int n = string3.indexOf(40);
        if (n >= 0) {
            int n2 = string3.indexOf(41);
            if (n2 < 0 || n >= n2 || n + 1 == n2) {
                return;
            }
            string3 = PdbReader.parseTrimmed((String)string3, (int)(n + 1), (int)n2);
        }
        if ((map = this.htFormul.get(string2)) == null) {
            map = new Hashtable<String, Boolean>();
            this.htFormul.put(string2, map);
        }
        this.next[0] = 0;
        while ((string = this.parseTokenNext(string3)) != null) {
            char c;
            if (string.length() < 2) continue;
            char c2 = string.charAt(0);
            if (Atom.isValidElementSymbolNoCaseSecondChar((char)c2, (char)(c = string.charAt(1)))) {
                map.put("" + c2 + c, Boolean.TRUE);
                continue;
            }
            if (!Atom.isValidElementSymbol((char)c2)) continue;
            map.put("" + c2, Boolean.TRUE);
        }
    }

    private void het() {
        String string;
        if (this.line.length() < 30) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        if (this.htHetero.containsKey(string = this.parseToken(this.line, 7, 10))) {
            return;
        }
        String string2 = PdbReader.parseTrimmed((String)this.line, (int)30, (int)70);
        this.htHetero.put(string, string2);
    }

    private void hetnam() {
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        String string = this.parseToken(this.line, 11, 14);
        String string2 = PdbReader.parseTrimmed((String)this.line, (int)15, (int)70);
        if (string == null) {
            Logger.error((String)("ERROR: HETNAM record does not contain a group name: " + this.line));
            return;
        }
        String string3 = this.htHetero.get(string);
        if (string3 != null) {
            string2 = string3 + string2;
        }
        this.htHetero.put(string, string2);
    }

    private void anisou() {
        int n;
        float[] fArray = new float[8];
        fArray[6] = 1.0f;
        int n2 = this.parseInt(this.line, 6, 11);
        if (this.line.substring(6, 26).equals(this.lastAtomData)) {
            n = this.lastAtomIndex;
        } else {
            if (!this.haveMappedSerials) {
                this.atomSetCollection.createAtomSerialMap();
            }
            n = this.atomSetCollection.getAtomIndexFromSerial(n2);
            this.haveMappedSerials = true;
        }
        if (n < 0) {
            return;
        }
        Atom atom = this.atomSetCollection.getAtom(n);
        int n3 = 28;
        int n4 = 0;
        while (n3 < 70) {
            fArray[n4] = this.parseFloat(this.line, n3, n3 + 7);
            n3 += 7;
            ++n4;
        }
        n3 = 0;
        while (n3 < 6) {
            if (Float.isNaN(fArray[n3])) {
                Logger.error((String)("Bad ANISOU record: " + this.line));
                return;
            }
            int n5 = n3++;
            fArray[n5] = fArray[n5] / 10000.0f;
        }
        this.atomSetCollection.setAnisoBorU(atom, fArray, 12);
    }

    private void site() {
        int n;
        String string;
        if (this.htSites == null) {
            this.htSites = new Hashtable<String, Map<String, Object>>();
        }
        int n2 = this.parseInt(this.line, 15, 17);
        String string2 = PdbReader.parseTrimmed((String)this.line, (int)11, (int)14);
        Map<String, Object> map = this.htSites.get(string2);
        if (map == null) {
            map = new Hashtable<String, Object>();
            map.put("nResidues", n2);
            map.put("groups", "");
            this.htSites.put(string2, map);
        }
        String string3 = (String)map.get("groups");
        for (int i = 0; i < 4 && (string = PdbReader.parseTrimmed((String)this.line, (int)(n = 18 + i * 11), (int)(n + 3))).length() != 0; ++i) {
            String string4 = PdbReader.parseTrimmed((String)this.line, (int)(n + 4), (int)(n + 5));
            String string5 = PdbReader.parseTrimmed((String)this.line, (int)(n + 5), (int)(n + 9));
            String string6 = PdbReader.parseTrimmed((String)this.line, (int)(n + 9), (int)(n + 10));
            string3 = string3 + (string3.length() == 0 ? "" : ",") + "[" + string + "]" + string5;
            if (string6.length() > 0) {
                string3 = string3 + "^" + string6;
            }
            if (string4.length() > 0) {
                string3 = string3 + ":" + string4;
            }
            map.put("groups", string3);
        }
    }

    private boolean remarkTls() throws Exception {
        String[] stringArray;
        int n = 0;
        int n2 = 0;
        String string = null;
        ArrayList<Hashtable<String, Object>> arrayList = null;
        Hashtable<String, Object> hashtable = null;
        ArrayList arrayList2 = null;
        Hashtable<String, Object> hashtable2 = null;
        String string2 = this.line.substring(0, 11);
        while (this.readLine() != null && this.line.startsWith(string2)) {
            try {
                int n3;
                int n4;
                int n5;
                stringArray = PdbReader.getTokens((String)this.line.substring(10).replace(':', ' '));
                if (stringArray.length < 2) continue;
                Logger.info((String)this.line);
                if (stringArray[1].equalsIgnoreCase("GROUP")) {
                    hashtable = new Hashtable<String, Object>();
                    arrayList2 = new ArrayList();
                    hashtable.put("ranges", arrayList2);
                    arrayList.add(hashtable);
                    this.tlsGroupID = this.parseInt(stringArray[stringArray.length - 1]);
                    hashtable.put("id", this.tlsGroupID);
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("NUMBER")) {
                    if (stringArray[2].equalsIgnoreCase("COMPONENTS")) continue;
                    n = this.parseInt(stringArray[stringArray.length - 1]);
                    if (n < 1) break;
                    if (this.vTlsModels == null) {
                        this.vTlsModels = new ArrayList<Map<String, Object>>();
                    }
                    arrayList = new ArrayList<Hashtable<String, Object>>();
                    this.appendLoadNote(this.line.substring(11).trim());
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("COMPONENTS")) {
                    string = this.line;
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("RESIDUE")) {
                    int n6;
                    char c;
                    char c2;
                    hashtable2 = new Hashtable<String, Object>();
                    if (stringArray.length == 6) {
                        c2 = stringArray[2].charAt(0);
                        c = stringArray[4].charAt(0);
                        n6 = this.parseInt(stringArray[3]);
                        n5 = this.parseInt(stringArray[5]);
                    } else {
                        n4 = string.indexOf(" C ");
                        n3 = string.indexOf(" C ", n4 + 4);
                        c2 = this.line.charAt(n3);
                        c = this.line.charAt(n4);
                        n6 = this.parseInt(this.line.substring(n3 + 1, n4));
                        n5 = this.parseInt(this.line.substring(n4 + 1));
                    }
                    if (c2 == c) {
                        hashtable2.put("chains", "" + c2 + c);
                        if (n6 <= n5) {
                            hashtable2.put("residues", new int[]{n6, n5});
                            arrayList2.add(hashtable2);
                            continue;
                        }
                        this.tlsAddError(" TLS group residues are not in order (range ignored)");
                        continue;
                    }
                    this.tlsAddError(" TLS group chains are different (range ignored)");
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("SELECTION")) {
                    char c = '\u0000';
                    for (int i = 1; i < stringArray.length; ++i) {
                        if (stringArray[i].toUpperCase().indexOf("CHAIN") >= 0) {
                            c = stringArray[++i].charAt(0);
                            continue;
                        }
                        int n7 = this.parseInt(stringArray[i]);
                        if (n7 == Integer.MIN_VALUE) continue;
                        hashtable2 = new Hashtable();
                        hashtable2.put("residues", new int[]{n7, this.parseInt(stringArray[++i])});
                        if (c != '\u0000') {
                            hashtable2.put("chains", "" + c + c);
                        }
                        arrayList2.add(hashtable2);
                    }
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("ORIGIN")) {
                    Point3f point3f = new Point3f();
                    hashtable.put("origin", point3f);
                    if (stringArray.length == 8) {
                        point3f.set(this.parseFloat(stringArray[5]), this.parseFloat(stringArray[6]), this.parseFloat(stringArray[7]));
                    } else {
                        int n8 = this.line.length();
                        point3f.set(this.parseFloat(this.line.substring(n8 - 27, n8 - 18)), this.parseFloat(this.line.substring(n8 - 18, n8 - 9)), this.parseFloat(this.line.substring(n8 - 9, n8)));
                    }
                    if (!Float.isNaN(point3f.x) && !Float.isNaN(point3f.y) && !Float.isNaN(point3f.z)) continue;
                    point3f.set(Float.NaN, Float.NaN, Float.NaN);
                    this.tlsAddError("invalid origin: " + this.line);
                    continue;
                }
                if (!stringArray[1].equalsIgnoreCase("TENSOR")) continue;
                char c = stringArray[0].charAt(0);
                String string3 = (this.readLine().substring(10) + this.readLine().substring(10) + this.readLine().substring(10)).replace(c, ' ').replace(':', ' ');
                stringArray = PdbReader.getTokens((String)string3);
                float[][] fArray = new float[3][3];
                hashtable.put("t" + c, fArray);
                for (n5 = 0; n5 < stringArray.length; ++n5) {
                    n4 = stringArray[n5].charAt(0) - 49;
                    n3 = stringArray[n5].charAt(1) - 49;
                    fArray[n4][n3] = this.parseFloat(stringArray[++n5]);
                    if (n4 >= n3) continue;
                    fArray[n3][n4] = fArray[n4][n3];
                }
                for (n5 = 0; n5 < 3; ++n5) {
                    for (n4 = 0; n4 < 3; ++n4) {
                        if (!Float.isNaN(fArray[n5][n4])) continue;
                        this.tlsAddError("invalid tensor: " + Escape.escapeArray((Object)fArray));
                    }
                }
                if (c != 'S' || ++n2 != n) continue;
                Logger.info((String)(n + " TLS groups read"));
                this.readLine();
                break;
            }
            catch (Exception exception) {
                Logger.error((String)(this.line + "\nError in TLS parser: "));
                exception.printStackTrace();
                arrayList = null;
                break;
            }
        }
        if (arrayList != null) {
            stringArray = new Hashtable();
            stringArray.put("groupCount", n);
            stringArray.put("groups", arrayList);
            this.vTlsModels.add((Map<String, Object>)stringArray);
        }
        return n < 1;
    }

    private void handleTlsMissingModels() {
        this.vTlsModels = null;
    }

    private void setTlsGroups(int n, int n2, SymmetryInterface symmetryInterface) {
        Logger.info((String)("TLS model " + (n2 + 1) + " set " + (n + 1)));
        Map<String, Object> map = this.vTlsModels.get(n);
        List list = (List)map.get("groups");
        int n3 = this.atomSetCollection.getAtomSetAtomIndex(n2);
        int[] nArray = new int[this.atomSetCollection.getAtomSetAtomCount(n2)];
        int n4 = n3 + nArray.length;
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n5 = list.size();
        for (int i = 0; i < n5; ++i) {
            Map map2 = (Map)list.get(i);
            List list2 = (List)map2.get("ranges");
            this.tlsGroupID = (Integer)map2.get("id");
            int n6 = list2.size();
            while (--n6 >= 0) {
                int n7;
                String string = (String)((Map)list2.get(n6)).get("chains");
                int[] nArray2 = (int[])((Map)list2.get(n6)).get("residues");
                char c = string.charAt(0);
                char c2 = string.charAt(1);
                int n8 = nArray2[0];
                int n9 = nArray2[1];
                int n10 = this.findAtomForRange(n3, n4, c, n8, false);
                int n11 = n7 = n10 >= 0 ? this.findAtomForRange(n10, n4, c2, n9, false) : -1;
                if (n7 < 0) {
                    Logger.info((String)"TLS processing terminated");
                    return;
                }
                Logger.info((String)("TLS ID=" + this.tlsGroupID + " model atom index range " + n10 + "-" + n7));
                boolean bl = c == c2;
                for (int j = n3; j < n4; ++j) {
                    Atom atom = atomArray[j];
                    if (!(bl ? atom.sequenceNumber >= n8 && atom.sequenceNumber <= n9 : atom.chainID > c && atom.chainID < c2 || atom.chainID == c && atom.sequenceNumber >= n8 || atom.chainID == c2 && atom.sequenceNumber <= n9)) continue;
                    nArray[j - n3] = this.tlsGroupID;
                    this.setTlsEllipsoid(atom, map2, symmetryInterface);
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]).append('\n');
        }
        this.atomSetCollection.setAtomSetAtomProperty("tlsGroup", stringBuffer.toString(), n2);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("TLS", map, n2);
        this.atomSetCollection.setEllipsoids();
    }

    private int findAtomForRange(int n, int n2, char c, int n3, boolean bl) {
        int n4 = this.findAtom(n, n2, c, n3, true);
        return bl && n4 >= 0 ? this.findAtom(n4, n2, c, n3, false) : n4;
    }

    private int findAtom(int n, int n2, char c, int n3, boolean bl) {
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = n; i < n2; ++i) {
            Atom atom = atomArray[i];
            if ((atom.chainID == c && atom.sequenceNumber == n3) != bl) continue;
            return i;
        }
        if (bl) {
            Logger.warn((String)("PdbReader findAtom chain=" + c + " resno=" + n3 + " not found"));
            this.tlsAddError("atom not found: chain=" + c + " resno=" + n3);
        }
        return bl ? -1 : n2;
    }

    private void setTlsEllipsoid(Atom atom, Map<String, Object> map, SymmetryInterface symmetryInterface) {
        Point3f point3f = (Point3f)map.get("origin");
        if (Float.isNaN(point3f.x)) {
            return;
        }
        float[][] fArray = (float[][])map.get("tT");
        float[][] fArray2 = (float[][])map.get("tL");
        float[][] fArray3 = (float[][])map.get("tS");
        if (fArray == null || fArray2 == null || fArray3 == null) {
            return;
        }
        float f = (atom.x - point3f.x) * ((float)Math.PI / 180);
        float f2 = (atom.y - point3f.y) * ((float)Math.PI / 180);
        float f3 = (atom.z - point3f.z) * ((float)Math.PI / 180);
        float f4 = f * f;
        float f5 = f2 * f2;
        float f6 = f3 * f3;
        float f7 = f * f2;
        float f8 = f * f3;
        float f9 = f2 * f3;
        this.dataT[0] = fArray[0][0];
        this.dataT[1] = fArray[1][1];
        this.dataT[2] = fArray[2][2];
        this.dataT[3] = fArray[0][1];
        this.dataT[4] = fArray[0][2];
        this.dataT[5] = fArray[1][2];
        this.dataT[6] = 12.0f;
        float[] fArray4 = new float[8];
        float f10 = Float.isNaN(atom.bfactor) ? 0.0f : atom.bfactor / 78.95683f;
        fArray4[0] = this.dataT[0] + fArray2[1][1] * f6 + fArray2[2][2] * f5 - 2.0f * fArray2[1][2] * f9 + 2.0f * fArray3[1][0] * f3 - 2.0f * fArray3[2][0] * f2;
        fArray4[1] = this.dataT[1] + fArray2[0][0] * f6 + fArray2[2][2] * f4 - 2.0f * fArray2[2][0] * f8 - 2.0f * fArray3[0][1] * f3 + 2.0f * fArray3[2][1] * f;
        fArray4[2] = this.dataT[2] + fArray2[0][0] * f5 + fArray2[1][1] * f4 - 2.0f * fArray2[0][1] * f7 - 2.0f * fArray3[1][2] * f + 2.0f * fArray3[0][2] * f2;
        fArray4[3] = this.dataT[3] - fArray2[2][2] * f7 + fArray2[1][2] * f8 + fArray2[2][0] * f9 - fArray2[0][1] * f6 - fArray3[0][0] * f3 + fArray3[1][1] * f3 + fArray3[2][0] * f - fArray3[2][1] * f2;
        fArray4[4] = this.dataT[4] - fArray2[1][1] * f8 + fArray2[1][2] * f7 - fArray2[2][0] * f5 + fArray2[0][1] * f9 + fArray3[0][0] * f2 - fArray3[2][2] * f2 + fArray3[1][2] * f3 - fArray3[1][0] * f;
        fArray4[5] = this.dataT[5] - fArray2[0][0] * f9 - fArray2[1][2] * f4 + fArray2[2][0] * f7 + fArray2[0][1] * f8 - fArray3[1][1] * f + fArray3[2][2] * f + fArray3[0][1] * f2 - fArray3[0][2] * f3;
        fArray4[6] = 12.0f;
        fArray4[7] = f10;
        if (Float.isNaN(f10)) {
            System.out.println("hmm");
        }
        if (this.tlsU == null) {
            this.tlsU = new Hashtable<Atom, float[]>();
        }
        this.tlsU.put(atom, fArray4);
        atom.ellipsoid = new Quadric[]{null, null, symmetryInterface.getEllipsoid(this.dataT)};
    }

    private void tlsAddError(String string) {
        if (this.sbTlsErrors == null) {
            this.sbTlsErrors = new StringBuffer();
        }
        this.sbTlsErrors.append(this.fileName).append('\t').append("TLS group ").append(this.tlsGroupID).append('\t').append(string).append('\n');
    }
}

