/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.script.Token;
import org.jmol.shape.Mesh;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.StateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MeshCollection
extends Shape {
    public int meshCount;
    public Mesh[] meshes = new Mesh[4];
    public Mesh currentMesh;
    public boolean isFixed;
    public int nUnnamed;
    public short colix;
    public String myType;
    public boolean explicitID;
    protected String previousMeshID;
    protected Mesh linkedMesh;
    protected int modelIndex;
    protected float displayWithinDistance2;
    protected boolean isDisplayWithinNot;
    protected List<Point3f> displayWithinPoints;
    protected BitSet bsDisplay;
    public String[] title;
    protected Mesh pickedMesh;
    protected int pickedModel;
    protected int pickedVertex;
    protected int[] connections;
    protected Map<String, Mesh> htObjects;
    protected int color;
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";

    private Mesh setMesh(String string) {
        this.linkedMesh = null;
        if (string == null || TextFormat.isWild(string)) {
            if (string != null) {
                this.previousMeshID = string;
            }
            this.currentMesh = null;
            return null;
        }
        this.currentMesh = this.getMesh(string);
        if (this.currentMesh == null) {
            this.allocMesh(string, null);
        } else if (string.equals(PREVIOUS_MESH_ID)) {
            this.linkedMesh = this.currentMesh.linkedMesh;
        }
        if (this.currentMesh.thisID == null) {
            if (this.nUnnamed == 0 || this.getMesh(this.myType + this.nUnnamed) != null) {
                ++this.nUnnamed;
            }
            this.currentMesh.thisID = this.myType + this.nUnnamed;
            if (this.htObjects != null) {
                this.htObjects.put(this.currentMesh.thisID.toUpperCase(), this.currentMesh);
            }
        }
        this.previousMeshID = this.currentMesh.thisID;
        return this.currentMesh;
    }

    public void allocMesh(String string, Mesh mesh) {
        int n = this.meshCount++;
        this.meshes = (Mesh[])ArrayUtil.ensureLength(this.meshes, this.meshCount * 2);
        this.meshes[n] = mesh == null ? new Mesh(string, this.g3d, this.colix, n) : mesh;
        this.currentMesh = this.meshes[n];
        this.currentMesh.color = this.color;
        this.currentMesh.index = n;
        if (string != null && this.htObjects != null) {
            this.htObjects.put(string.toUpperCase(), this.currentMesh);
        }
        this.previousMeshID = null;
    }

    @Override
    public void merge(Shape shape) {
        MeshCollection meshCollection = (MeshCollection)shape;
        for (int i = 0; i < meshCollection.meshCount; ++i) {
            if (meshCollection.meshes[i] == null) continue;
            Mesh mesh = meshCollection.meshes[i];
            Mesh mesh2 = this.getMesh(mesh.thisID);
            if (mesh2 == null) {
                this.allocMesh(mesh.thisID, mesh);
                continue;
            }
            this.meshes[mesh2.index] = mesh;
            mesh.index = mesh2.index;
        }
        this.previousMeshID = null;
        this.currentMesh = null;
    }

    @Override
    public void initShape() {
        super.initShape();
        this.colix = (short)5;
        this.color = -1;
    }

    @Override
    public void setProperty(String string, Object object, BitSet bitSet) {
        if (string == "setXml" && this.currentMesh != null) {
            this.currentMesh.xmlProperties = this.xmlProperties;
        }
        if ("init" == string) {
            this.title = null;
            return;
        }
        if ("link" == string) {
            if (this.meshCount >= 2 && this.currentMesh != null) {
                this.currentMesh.linkedMesh = this.meshes[this.meshCount - 2];
            }
            return;
        }
        if ("lattice" == string) {
            if (this.currentMesh != null) {
                this.currentMesh.lattice = (Point3f)object;
            }
            return;
        }
        if ("variables" == string) {
            if (this.currentMesh != null && this.currentMesh.scriptCommand != null && !this.currentMesh.scriptCommand.startsWith("{")) {
                this.currentMesh.scriptCommand = "{\n" + StateManager.getVariableList((Map)object, 0, false, false) + "\n" + this.currentMesh.scriptCommand;
            }
            return;
        }
        if ("thisID" == string) {
            String string2 = (String)object;
            this.setMesh(string2);
            this.checkExplicit(string2);
            return;
        }
        if ("title" == string) {
            if (object == null) {
                this.title = null;
            } else if (object instanceof String[]) {
                this.title = (String[])object;
            } else {
                int n = 1;
                String string3 = (String)object;
                int n2 = string3.length();
                while (--n2 >= 0) {
                    if (string3.charAt(n2) != '|') continue;
                    ++n;
                }
                this.title = new String[n];
                n = 0;
                n2 = -1;
                for (int i = 0; i < string3.length(); ++i) {
                    if (string3.charAt(i) != '|') continue;
                    this.title[n++] = string3.substring(n2 + 1, i);
                    n2 = i;
                }
                this.title[n] = string3.substring(n2 + 1);
            }
            return;
        }
        if ("delete" == string) {
            this.deleteMesh();
            return;
        }
        if ("reset" == string) {
            String string4 = (String)object;
            if (this.setMesh(string4) == null) {
                return;
            }
            this.setMesh(string4);
            return;
        }
        if ("color" == string) {
            if (object == null) {
                return;
            }
            this.colix = Graphics3D.getColix(object);
            this.color = (Integer)object;
            if (this.currentMesh != null) {
                this.currentMesh.color = this.color;
            }
            this.setTokenProperty(1766856708, false, false);
            return;
        }
        if ("translucency" == string) {
            this.setTokenProperty(1073742180, ((String)object).equals("translucent"), false);
            return;
        }
        if ("hidden" == string) {
            object = (Boolean)object != false ? 0x10000C : 0x10000D;
            string = "token";
        }
        if ("token" == string) {
            int n = (Integer)object;
            int n3 = 0;
            boolean bl = true;
            switch (n) {
                case 0x10000D: 
                case 1073741862: 
                case 1073741938: 
                case 1073741958: 
                case 0x40000088: 
                case 1073741964: 
                case 1073742182: 
                case 1113198595: 
                case 1610625028: {
                    break;
                }
                case 0x10000C: {
                    bl = false;
                    n = 0x10000D;
                    break;
                }
                case 0x4000004A: {
                    n3 = 1073742018;
                    break;
                }
                case 1073742039: {
                    bl = false;
                    n = 0x4000004A;
                    n3 = 1073742018;
                    break;
                }
                case 1073742018: {
                    n3 = 0x4000004A;
                    break;
                }
                case 0x400000E4: {
                    bl = false;
                    n = 1073742018;
                    n3 = 0x4000004A;
                    break;
                }
                case 1073742042: {
                    bl = false;
                    n = 1113198595;
                    break;
                }
                case 1073742046: {
                    bl = false;
                    n = 1073741938;
                    break;
                }
                case 1073742060: {
                    bl = false;
                    n = 1073742182;
                    break;
                }
                case 1073742058: {
                    bl = false;
                    n = 0x40000088;
                    break;
                }
                default: {
                    Logger.error("PROBLEM IN MESHCOLLECTION: token? " + Token.nameOf(n));
                }
            }
            this.setTokenProperty(n, bl, false);
            if (n3 != 0) {
                this.setTokenProperty(n3, bl, true);
            }
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    protected void checkExplicit(String string) {
        if (this.explicitID) {
            return;
        }
        boolean bl = this.explicitID = string != null && !string.equals(PREVIOUS_MESH_ID);
        if (this.explicitID) {
            this.previousMeshID = string;
        }
    }

    private void setTokenProperty(int n, boolean bl, boolean bl2) {
        if (this.currentMesh == null) {
            String string;
            String string2 = string = this.explicitID && this.previousMeshID != null && TextFormat.isWild(this.previousMeshID) ? this.previousMeshID.toUpperCase() : null;
            if (string != null && string.length() == 0) {
                string = null;
            }
            for (int i = 0; i < this.meshCount; ++i) {
                if (string != null && !TextFormat.isMatch(this.meshes[i].thisID.toUpperCase(), string, true, true)) continue;
                this.setMeshTokenProperty(this.meshes[i], n, bl, bl2);
            }
        } else {
            this.setMeshTokenProperty(this.currentMesh, n, bl, bl2);
            if (this.linkedMesh != null) {
                this.setMeshTokenProperty(this.linkedMesh, n, bl, bl2);
            }
        }
    }

    private void setMeshTokenProperty(Mesh mesh, int n, boolean bl, boolean bl2) {
        if (bl2 && (!mesh.havePlanarContours || mesh.drawTriangles == mesh.showContourLines)) {
            return;
        }
        switch (n) {
            case 1610625028: {
                mesh.bsDisplay = this.bsDisplay;
                if (this.bsDisplay == null && this.displayWithinPoints != null) {
                    mesh.setShowWithin(this.displayWithinPoints, this.displayWithinDistance2, this.isDisplayWithinNot);
                }
                return;
            }
            case 0x10000D: {
                mesh.visible = bl;
                return;
            }
            case 1766856708: {
                mesh.colix = this.colix;
                return;
            }
            case 1073742180: {
                mesh.setTranslucent(bl, this.translucentLevel);
                if (mesh.bsSlabGhost != null) {
                    mesh.resetSlab();
                }
                return;
            }
        }
        mesh.setTokenProperty(n, bl);
    }

    @Override
    public boolean getProperty(String string, Object[] objectArray) {
        if (string == "getNames") {
            Map map = (Map)objectArray[0];
            boolean bl = (Boolean)objectArray[1];
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.meshes[n] == null || this.meshes[n].vertexCount == 0) continue;
                map.put((bl ? "$" : "") + this.meshes[n].thisID, Token.tokenOr);
            }
            return true;
        }
        if (string == "getVertices") {
            Mesh mesh = this.getMesh((String)objectArray[0]);
            if (mesh == null) {
                return false;
            }
            objectArray[1] = mesh.vertices;
            objectArray[2] = mesh.getVisibleVertexBitSet();
            return true;
        }
        if (string == "checkID") {
            String string2 = ((String)objectArray[0]).toUpperCase();
            boolean bl = TextFormat.isWild(string2);
            int n = this.meshCount;
            while (--n >= 0) {
                String string3 = this.meshes[n].thisID;
                if (!string3.equalsIgnoreCase(string2) && (!bl || !TextFormat.isMatch(string3.toUpperCase(), string2, true, true))) continue;
                objectArray[1] = string3;
                return true;
            }
            return false;
        }
        if (string == "getCenter") {
            String string4 = (String)objectArray[0];
            int n = (Integer)objectArray[1];
            Mesh mesh = this.getMesh(string4);
            if (mesh == null || mesh.vertices == null) {
                return false;
            }
            objectArray[2] = n == Integer.MAX_VALUE ? new Point3f(mesh.index + 1, this.meshCount, mesh.vertexCount) : mesh.vertices[mesh.getVertexIndexFromNumber(n)];
            return true;
        }
        return false;
    }

    @Override
    public Object getProperty(String string, int n) {
        if (string == "count") {
            int n2 = 0;
            for (int i = 0; i < this.meshCount; ++i) {
                Mesh mesh = this.meshes[i];
                if (mesh == null || mesh.vertexCount <= 0) continue;
                ++n2;
            }
            return n2;
        }
        if (string == "ID") {
            return this.currentMesh == null ? null : this.currentMesh.thisID;
        }
        if (string.startsWith("list")) {
            this.clean();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            String string2 = string.equals("list") ? null : string.substring(5);
            for (int i = 0; i < this.meshCount; ++i) {
                Object object;
                Mesh mesh = this.meshes[i];
                if (string2 != null && !string2.equalsIgnoreCase(mesh.thisID)) continue;
                stringBuffer.append(++n3).append(" id:" + mesh.thisID).append("; model:" + this.viewer.getModelNumberDotted(mesh.modelIndex)).append("; vertices:" + mesh.vertexCount).append("; polygons:" + mesh.polygonCount).append("; visible:" + mesh.visible);
                Object object2 = this.getProperty("dataRange", 0);
                if (object2 != null) {
                    stringBuffer.append("; dataRange:").append(Escape.escape(object2));
                }
                if (mesh.title != null) {
                    object = "";
                    for (int j = 0; j < mesh.title.length; ++j) {
                        object = (String)object + (j == 0 ? "; title:" : " | ") + mesh.title[j];
                    }
                    if (((String)object).length() > 10000) {
                        object = ((String)object).substring(0, 10000) + "...";
                    }
                    stringBuffer.append((String)object);
                }
                stringBuffer.append('\n');
                if (string2 == null || (object = this.getProperty("jvxlFileInfo", 0)) == null) continue;
                stringBuffer.append(object).append('\n');
            }
            return stringBuffer.toString();
        }
        if (string == "vertices") {
            return this.getVertices(this.currentMesh);
        }
        if (string == "getInfo") {
            return this.currentMesh == null ? null : this.currentMesh.getInfo();
        }
        return null;
    }

    private Object getVertices(Mesh mesh) {
        if (mesh == null) {
            return null;
        }
        return mesh.vertices;
    }

    protected void clean() {
        int n = this.meshCount;
        while (--n >= 0) {
            if (this.meshes[n] != null && this.meshes[n].vertexCount != 0) continue;
            this.deleteMesh(n);
        }
    }

    private void deleteMesh() {
        if (this.explicitID && this.currentMesh != null) {
            this.deleteMesh(this.currentMesh.index);
        } else {
            this.deleteMesh(this.explicitID && this.previousMeshID != null && TextFormat.isWild(this.previousMeshID) ? this.previousMeshID : null);
        }
        this.currentMesh = null;
    }

    protected void deleteMesh(String string) {
        if (string == null || string.length() == 0) {
            int n = this.meshCount;
            while (--n >= 0) {
                this.meshes[n] = null;
            }
            this.meshCount = 0;
            this.nUnnamed = 0;
            if (this.htObjects != null) {
                this.htObjects.clear();
            }
        } else {
            string = string.toLowerCase();
            int n = this.meshCount;
            while (--n >= 0) {
                if (!TextFormat.isMatch(this.meshes[n].thisID.toLowerCase(), string, true, true)) continue;
                this.deleteMesh(n);
            }
        }
    }

    public void deleteMesh(int n) {
        if (this.htObjects != null) {
            this.htObjects.remove(this.meshes[n].thisID.toUpperCase());
        }
        for (int i = n + 1; i < this.meshCount; ++i) {
            this.meshes[--this.meshes[i].index] = this.meshes[i];
        }
        this.meshes[--this.meshCount] = null;
    }

    public Mesh getMesh(String string) {
        int n = this.getIndexFromName(string);
        return n < 0 ? null : this.meshes[n];
    }

    @Override
    public int getIndexFromName(String string) {
        if (PREVIOUS_MESH_ID.equals(string)) {
            return this.previousMeshID == null ? this.meshCount - 1 : this.getIndexFromName(this.previousMeshID);
        }
        if (TextFormat.isWild(string)) {
            string = string.toLowerCase();
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.meshes[n] == null || !TextFormat.isMatch(this.meshes[n].thisID, string, true, true)) continue;
                return n;
            }
        } else {
            if (this.htObjects != null) {
                Mesh mesh = this.htObjects.get(string.toUpperCase());
                return mesh == null ? -1 : mesh.index;
            }
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.meshes[n] == null || this.meshes[n].vertexCount == 0 || !string.equalsIgnoreCase(this.meshes[n].thisID)) continue;
                return n;
            }
        }
        return -1;
    }

    @Override
    public void setVisibilityFlags(BitSet bitSet) {
        BitSet bitSet2 = this.viewer.getDeletedAtoms();
        int n = this.meshCount;
        while (--n >= 0) {
            Mesh mesh = this.meshes[n];
            mesh.visibilityFlags = mesh.visible && mesh.isValid && (mesh.modelIndex < 0 || bitSet.get(mesh.modelIndex) && (mesh.atomIndex < 0 || !this.modelSet.isAtomHidden(mesh.atomIndex) && (bitSet2 == null || !bitSet2.get(mesh.atomIndex)))) ? this.myVisibilityFlag : 0;
        }
    }

    protected void setStatusPicked(int n, Point3f point3f) {
        this.viewer.setStatusAtomPicked(n, "[\"" + this.myType + "\"," + Escape.escape(this.pickedMesh.thisID) + "," + this.pickedModel + "," + this.pickedVertex + "," + point3f.x + "," + point3f.y + "," + point3f.z + "," + (this.pickedMesh.title == null ? "\"\"" : Escape.escape(this.pickedMesh.title[0])) + "]");
    }

    protected Map<String, Object> getPickedPoint(Point3f point3f, int n) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (point3f != null) {
            hashtable.put("pt", point3f);
            hashtable.put("modelIndex", n);
            hashtable.put("model", this.viewer.getModelNumberDotted(n));
            hashtable.put("id", this.pickedMesh.thisID);
            hashtable.put("vertex", this.pickedVertex + 1);
            hashtable.put("type", this.myType);
        }
        return hashtable;
    }
}

