/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.constant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EnumStructure {
    NOT(-1, -8355712),
    NONE(0, -1),
    TURN(1, -10452737),
    SHEET(2, -14336),
    HELIX(3, -65408),
    DNA(4, -5373698),
    RNA(5, -196254),
    CARBOHYDRATE(6, -5855494),
    HELIX310(7, -6291328),
    HELIXALPHA(8, -65408),
    HELIXPI(9, -10485632);

    private int id;
    private int color;

    private EnumStructure(int n2, int n3) {
        this.id = n2;
        this.color = n3;
    }

    public int getId() {
        return this.id;
    }

    public int getColor() {
        return this.color;
    }

    public static final EnumStructure getProteinStructureType(String string) {
        for (EnumStructure enumStructure : EnumStructure.values()) {
            if (!string.equalsIgnoreCase(enumStructure.name())) continue;
            return enumStructure.isProtein() ? enumStructure : NOT;
        }
        return NOT;
    }

    public String getBioStructureTypeName(boolean bl) {
        return this.id < 0 ? "" : (bl && this.isProtein() ? "protein" : this.name());
    }

    private boolean isProtein() {
        return this.id >= 0 && this.id <= 3 || this.id >= 7;
    }
}

