/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.util.Quadric;

public class Atom
extends Point3f
implements Cloneable {
    public int atomSetIndex;
    public int atomIndex;
    public BitSet bsSymmetry;
    public int atomSite;
    public String elementSymbol;
    public short elementNumber = (short)-1;
    public String atomName;
    public int formalCharge = Integer.MIN_VALUE;
    public float partialCharge;
    float vectorX;
    float vectorY;
    float vectorZ;
    public float bfactor;
    public int occupancy;
    public float radius;
    public boolean isHetero;
    public int atomSerial;
    public char chainID;
    public char alternateLocationID;
    public String group3;
    public int sequenceNumber;
    public char insertionCode;
    public float[] anisoBorU;
    public Quadric[] ellipsoid;
    public boolean ignoreSymmetry;
    static final int[] elementCharMasks = new int[]{1972292, -2147351151, -2146019271, -2130706430, 0x160000, -2147348464, 25, -2147205008, -2147344384, 0, -2147352576, 0x120101, 548936, -2147434213, -2147221504, -2145759221, 0, 1056947, -2147339946, -2147477097, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x800010, -2147483646, 139264};

    public void setEllipsoid(Quadric quadric) {
        if (quadric == null) {
            return;
        }
        if (this.ellipsoid != null && this.ellipsoid.length == 3) {
            this.ellipsoid[0] = quadric;
        } else {
            this.ellipsoid = new Quadric[]{quadric};
        }
    }

    public Atom() {
        this.set(Float.NaN, Float.NaN, Float.NaN);
        this.partialCharge = Float.NaN;
        this.vectorX = Float.NaN;
        this.vectorY = Float.NaN;
        this.vectorZ = Float.NaN;
        this.bfactor = Float.NaN;
        this.occupancy = 100;
        this.radius = Float.NaN;
        this.atomSerial = Integer.MIN_VALUE;
        this.chainID = '\u0000';
        this.alternateLocationID = '\u0000';
        this.sequenceNumber = Integer.MIN_VALUE;
        this.insertionCode = '\u0000';
    }

    public Atom cloneAtom() throws Exception {
        try {
            return (Atom)super.clone();
        }
        catch (Exception exception) {
            throw new Exception("cloneAtom error: " + exception.getMessage(), exception);
        }
    }

    public String getElementSymbol() {
        if (this.elementSymbol == null && this.atomName != null) {
            int n;
            int n2 = this.atomName.length();
            char c = '\u0000';
            for (n = 0; n < n2 && !Atom.isValidFirstSymbolChar(c = this.atomName.charAt(n)); ++n) {
            }
            switch (n2 - n) {
                case 0: {
                    break;
                }
                default: {
                    char c2 = this.atomName.charAt(n + 1);
                    if (Atom.isValidElementSymbolNoCaseSecondChar(c, c2)) {
                        this.elementSymbol = "" + c + c2;
                        break;
                    }
                }
                case 1: {
                    if (!Atom.isValidElementSymbol(c)) break;
                    this.elementSymbol = "" + c;
                }
            }
        }
        return this.elementSymbol;
    }

    public static boolean isValidElementSymbol(char c) {
        return c >= 'A' && c <= 'Z' && elementCharMasks[c - 65] < 0;
    }

    public static boolean isValidElementSymbol(char c, char c2) {
        if (c < 'A' || c > 'Z' || c2 < 'a' || c2 > 'z') {
            return false;
        }
        return (elementCharMasks[c - 65] >> c2 - 97 & 1) != 0;
    }

    public static boolean isValidElementSymbolNoCaseSecondChar(char c, char c2) {
        if (c2 >= 'A' && c2 <= 'Z') {
            c2 = (char)(c2 + 32);
        }
        if (c < 'A' || c > 'Z' || c2 < 'a' || c2 > 'z') {
            return false;
        }
        return (elementCharMasks[c - 65] >> c2 - 97 & 1) != 0;
    }

    public static boolean isValidFirstSymbolChar(char c) {
        return c >= 'A' && c <= 'Z' && elementCharMasks[c - 65] != 0;
    }

    public static boolean isValidElementSymbolNoCaseSecondChar(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (n == 1) {
            return Atom.isValidElementSymbol(c);
        }
        if (n > 2) {
            return false;
        }
        char c2 = string.charAt(1);
        return Atom.isValidElementSymbolNoCaseSecondChar(c, c2);
    }

    public void scaleVector(float f) {
        if (Float.isNaN(this.vectorX)) {
            return;
        }
        this.vectorX *= f;
        this.vectorY *= f;
        this.vectorZ *= f;
    }
}

