/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.ArrayList;
import java.util.Hashtable;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class WebMOReader
extends MopacSlaterReader {
    private static String DS_LIST = "NOT IMPLEMENTED IN THIS READER";
    private static String DC_LIST = "xx    yy    zz    xy    xz    yz";
    private static String FS_LIST = "NOT IMPLEMENTED IN THIS READER";
    private static String FC_LIST = "xxx   yyy   zzz   yyx   xxy   xxz   zzx   zzy   yyz   xyz";

    protected boolean checkLine() throws Exception {
        if (this.line.equals("[HEADER]")) {
            this.readHeader();
            return true;
        }
        if (this.line.equals("[ATOMS]")) {
            this.readAtoms();
            return false;
        }
        if (this.line.equals("[BONDS]")) {
            this.readBonds();
            return false;
        }
        if (!this.readMolecularOrbitals) {
            return true;
        }
        if (this.line.equals("[AO_ORDER]")) {
            this.readAtomicOrbitalOrder();
            return false;
        }
        if (this.line.equals("[GTO]")) {
            this.readGaussianBasis();
            return false;
        }
        if (this.line.equals("[STO]")) {
            this.readSlaterBasis();
            return false;
        }
        if (this.line.indexOf("[MO") == 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.readMolecularOrbital();
            return false;
        }
        return true;
    }

    protected void finalizeReader() throws Exception {
        super.finalizeReader();
        if (this.nOrbitals > 0) {
            this.setMOs("eV");
        }
        if (Logger.debugging) {
            Logger.debug((String)(this.orbitals.size() + " molecular orbitals read"));
        }
    }

    void readHeader() throws Exception {
        this.moData.put("isNormalized", Boolean.TRUE);
        while (this.readLine() != null && this.line.length() > 0) {
            this.moData.put("calculationType", "?");
            String[] stringArray = this.getTokens();
            stringArray[0] = stringArray[0].substring(0, 1).toLowerCase() + stringArray[0].substring(1, stringArray[0].length());
            String string = "";
            for (int i = 1; i < stringArray.length; ++i) {
                string = string + (i == 1 ? "" : " ") + stringArray[i].toLowerCase();
            }
            this.moData.put(stringArray[0], string);
        }
    }

    void readAtoms() throws Exception {
        while (this.getLine()) {
            String[] stringArray = this.getTokens();
            if (stringArray.length == 0) continue;
            int n = this.parseInt(this.line);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = n == Integer.MIN_VALUE ? stringArray[0] : WebMOReader.getElementSymbol((int)n);
            this.setAtomCoord(atom, this.parseFloat(stringArray[1]) * 0.5291772f, this.parseFloat(stringArray[2]) * 0.5291772f, this.parseFloat(stringArray[3]) * 0.5291772f);
        }
    }

    void readBonds() throws Exception {
        while (this.getLine()) {
            String[] stringArray = this.getTokens();
            if (stringArray.length == 0) continue;
            int n = this.parseInt(stringArray[0]);
            int n2 = this.parseInt(stringArray[1]);
            int n3 = this.parseInt(stringArray[2]);
            this.atomSetCollection.addBond(new Bond(n - 1, n2 - 1, n3));
        }
    }

    void readAtomicOrbitalOrder() throws Exception {
        while (this.getLine()) {
            String[] stringArray = this.getTokens();
            if (stringArray.length == 0) continue;
            String string = this.line.substring(9).trim().toLowerCase();
            boolean bl = false;
            switch (stringArray.length - 1) {
                case 3: 
                case 4: {
                    bl = true;
                    break;
                }
                case 5: {
                    bl = stringArray[0].equals("DOrbitals") && this.getDFMap(string, JmolAdapter.SHELL_D_SPHERICAL, DS_LIST, 99);
                    break;
                }
                case 6: {
                    bl = stringArray[0].equals("DOrbitals") && this.getDFMap(string, JmolAdapter.SHELL_D_CARTESIAN, DC_LIST, 2);
                    break;
                }
                case 7: {
                    bl = stringArray[0].equals("FOrbitals") && this.getDFMap(string, JmolAdapter.SHELL_F_SPHERICAL, FS_LIST, 99);
                    break;
                }
                case 10: {
                    boolean bl2 = bl = stringArray[0].equals("FOrbitals") && this.getDFMap(string, JmolAdapter.SHELL_F_CARTESIAN, FC_LIST, 3);
                }
            }
            if (bl) continue;
            Logger.error((String)("atomic orbital order is unrecognized -- skipping reading of MOs due to line: " + this.line));
            this.orbitals = null;
        }
    }

    private boolean getLine() throws Exception {
        return this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[');
    }

    void readGaussianBasis() throws Exception {
        Object object;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        ArrayList<float[]> arrayList2 = new ArrayList<float[]>();
        int n = 0;
        int n2 = 0;
        while (this.getLine()) {
            object = this.getTokens();
            if (((String[])object).length == 0) continue;
            if (((String[])object).length != 1) {
                throw new Exception("Error reading GTOs: missing atom index");
            }
            int[] nArray = new int[4];
            n = this.parseInt(object[0]) - 1;
            object = WebMOReader.getTokens((String)this.readLine());
            int n3 = this.parseInt(object[1]);
            nArray[0] = n;
            nArray[1] = JmolAdapter.getQuantumShellTagID((String)object[0]);
            nArray[2] = n2;
            nArray[3] = n3;
            for (int i = 0; i < n3; ++i) {
                String[] stringArray = WebMOReader.getTokens((String)this.readLine());
                int n4 = stringArray.length;
                float[] fArray = new float[n4];
                for (int j = 0; j < n4; ++j) {
                    fArray[j] = this.parseFloat(stringArray[j]);
                }
                arrayList2.add(fArray);
                ++n2;
            }
            arrayList.add(nArray);
        }
        object = new float[n2][];
        for (int i = 0; i < n2; ++i) {
            object[i] = (float[])arrayList2.get(i);
        }
        this.moData.put("shells", arrayList);
        this.moData.put("gaussians", object);
        if (Logger.debugging) {
            Logger.debug((String)(arrayList.size() + " slater shells read"));
            Logger.debug((String)(((String[])object).length + " gaussian primitives read"));
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", (Object)this.moData);
    }

    void readSlaterBasis() throws Exception {
        while (this.getLine()) {
            String[] stringArray = this.getTokens();
            if (stringArray.length < 7) continue;
            this.addSlater(this.parseInt(stringArray[0]) - 1, this.parseInt(stringArray[1]), this.parseInt(stringArray[2]), this.parseInt(stringArray[3]), this.parseInt(stringArray[4]), this.parseFloat(stringArray[5]), this.parseFloat(stringArray[6]));
        }
        this.setSlaters(false, false);
    }

    void readMolecularOrbital() throws Exception {
        Object[] objectArray;
        if (this.orbitals == null) {
            Logger.error((String)"MOLECULAR ORBITALS SKIPPED");
            while (this.getLine()) {
            }
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ArrayList<String> arrayList = new ArrayList<String>();
        float f = this.parseFloat(this.readLine());
        float f2 = this.parseFloat(this.readLine());
        while (this.getLine()) {
            objectArray = this.getTokens();
            if (objectArray.length == 0) continue;
            arrayList.add(objectArray[1]);
        }
        objectArray = new float[arrayList.size()];
        int n = arrayList.size();
        while (--n >= 0) {
            objectArray[n] = (String)this.parseFloat((String)arrayList.get(n));
        }
        hashtable.put("energy", Float.valueOf(f));
        hashtable.put("occupancy", Float.valueOf(f2));
        hashtable.put("coefficients", objectArray);
        this.orbitals.add(hashtable);
        ++this.nOrbitals;
        if (f2 > 0.0f) {
            this.moData.put("HOMO", this.nOrbitals);
        }
    }
}

