/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.adapter.readers.quantum.SlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.quantum.SlaterData;
import org.jmol.util.Logger;

public class DgridReader
extends SlaterReader {
    private String title;
    Map<String, Float> htExponents = new Hashtable<String, Float>();
    private Map<String, Integer> htFuncMap;

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf(":title") == 0) {
            this.title = this.readLine().substring(2);
            return true;
        }
        if (this.line.indexOf("basis:  CARTESIAN  STO") >= 0) {
            this.readSlaterBasis();
            return true;
        }
        if (this.line.indexOf(":atom") == 0) {
            this.readCoordinates();
            return true;
        }
        if (this.line.indexOf(" MO  DATA ") >= 0) {
            if (this.readMolecularOrbitals) {
                this.readMolecularOrbitals();
            }
            return true;
        }
        return true;
    }

    private void readCoordinates() throws Exception {
        String[] stringArray;
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName(this.title);
        this.discardLinesUntilContains("----");
        while (this.readLine() != null && !this.line.startsWith(":-----") && (stringArray = this.getTokens()).length >= 5) {
            String string = stringArray[0];
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            this.setAtomCoord(atom, this.parseFloat(stringArray[2]) * 0.5291772f, this.parseFloat(stringArray[3]) * 0.5291772f, this.parseFloat(stringArray[4]) * 0.5291772f);
        }
    }

    private void readSlaterBasis() throws Exception {
        this.discardLinesUntilContains(":-");
        char c = 'a';
        while (this.readLine() != null && this.line.indexOf(":-") < 0) {
            String string = this.line.substring(3, 6).trim();
            String string2 = this.line.substring(19, 21);
            String string3 = string + string2;
            if (this.htExponents.get(string3) == null) {
                c = 'a';
            } else {
                char c2 = c;
                c = (char)(c + 1);
                string3 = string3 + "_" + c2;
            }
            String string4 = this.line.substring(34);
            this.htExponents.put(string3, Float.valueOf(this.parseFloat(string4)));
        }
    }

    private void readMolecularOrbitals() throws Exception {
        this.htFuncMap = new Hashtable<String, Integer>();
        this.readLines(3);
        while (this.line != null && this.line.indexOf(":") != 0) {
            int n;
            Object object;
            Object object2;
            this.discardLinesUntilContains("sym: ");
            String string = this.line.substring(4, 10).trim();
            if (string.indexOf("_FC") >= 0) break;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.line.substring(15));
            while (this.readLine() != null && this.line.length() >= 15) {
                stringBuffer.append(this.line);
            }
            String[] stringArray = DgridReader.getTokens(stringBuffer.toString());
            int n2 = stringArray.length / 2;
            int[] nArray = new int[n2];
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            int n3 = 0;
            int n4 = 0;
            while (n3 < stringArray.length) {
                int n5 = this.parseInt(stringArray[n3++]) - 1;
                object2 = stringArray[n3++];
                object = n5 + "_" + (String)object2;
                if (this.htFuncMap.containsKey(object)) {
                    nArray[n4++] = this.htFuncMap.get(object);
                    continue;
                }
                n = this.slaters.size();
                nArray[n4++] = n;
                this.htFuncMap.put((String)object, n);
                this.addSlater(this.createSlaterData(n5, atomArray[n5].elementSymbol, (String)object2), n);
            }
            this.discardLinesUntilContains(":-");
            this.readLine();
            while (this.line != null && this.line.length() >= 20) {
                n3 = this.parseInt(this.line.substring(0, 10));
                float f = this.parseFloat(this.line.substring(10, 20));
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(this.line.substring(20));
                while (this.readLine() != null && this.line.length() >= 10 && this.line.charAt(3) == ' ') {
                    stringBuffer2.append(this.line);
                }
                object2 = new float[this.slaters.size()];
                stringArray = DgridReader.getTokens(stringBuffer2.toString());
                if (stringArray.length != n2) {
                    Logger.error("DgridReader: number of coefficients (" + stringArray.length + ") does not equal number of functions (" + n2 + ")");
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    n = nArray[i];
                    object2[n] = this.parseFloat(stringArray[i]);
                }
                object = new Hashtable();
                object.put("energy", new Float(f));
                object.put("coefficients", object2);
                object.put("symmetry", string + "_" + n3);
                this.setMO((Map<String, Object>)object);
            }
        }
        this.discardLinesUntilContains(":  #  symmetry");
        this.readLine();
        for (int i = 0; i < this.orbitals.size(); ++i) {
            this.readLine();
            float f = this.parseFloat(this.line.substring(31, 45)) + this.parseFloat(this.line.substring(47, 61));
            ((Map)this.orbitals.get(i)).put("occupancy", Float.valueOf(f));
        }
        this.sortOrbitals();
        this.setSlaters(true, true);
        this.setMOs("eV");
    }

    private SlaterData createSlaterData(int n, String string, String string2) {
        char c = ' ';
        char c2 = ' ';
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = string2.length();
        block7: while (--n7 >= 0) {
            char c3 = string2.charAt(n7);
            switch (c3) {
                case '_': {
                    c2 = c;
                    continue block7;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': {
                    n2 = c3 - 48;
                    continue block7;
                }
                case 'x': {
                    n4 = n2;
                    n3 += n2;
                    n2 = 1;
                    continue block7;
                }
                case 'y': {
                    n5 = n2;
                    n3 += n2;
                    n2 = 1;
                    continue block7;
                }
                case 'z': {
                    n6 = n2;
                    n3 += n2;
                    n2 = 1;
                    continue block7;
                }
            }
            c = c3;
        }
        n7 = n2 - n3 - 1;
        String string3 = string + string2.substring(0, 2);
        if (c2 != ' ') {
            string3 = string3 + "_" + c2;
        }
        Float f = this.htExponents.get(string3);
        float f2 = 0.0f;
        if (f == null) {
            Logger.error("Exponent for " + string3 + " not found");
        } else {
            f2 = f.floatValue();
        }
        return new SlaterData(n, n4, n5, n6, n7, f2, 1.0);
    }
}

