/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.GestureType;
import com.sparshui.common.Event;
import com.sparshui.gestures.Gesture;
import com.sparshui.server.GestureFactory;
import com.sparshui.server.ServerToClientProtocol;
import com.sparshui.server.TouchPoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    private int _id;
    private List<GestureType> _gestureTypes;
    private List<Gesture> _gestures;
    private List<TouchPoint> _touchPoints;
    private ServerToClientProtocol _clientProtocol;

    public Group(int n, List<GestureType> list, ServerToClientProtocol serverToClientProtocol) {
        this._id = n;
        this._gestureTypes = list;
        this._gestures = new ArrayList<Gesture>();
        this._touchPoints = new ArrayList<TouchPoint>();
        this._clientProtocol = serverToClientProtocol;
        for (int i = 0; i < this._gestureTypes.size(); ++i) {
            Gesture gesture = GestureFactory.createGesture(this._gestureTypes.get(i));
            if (gesture == null) continue;
            this._gestures.add(gesture);
        }
    }

    public int getID() {
        return this._id;
    }

    public synchronized void update(TouchPoint touchPoint) {
        ArrayList<Event> arrayList = new ArrayList<Event>();
        int n = touchPoint.getState();
        if (n == 0) {
            this._touchPoints.add(touchPoint);
        }
        List<TouchPoint> list = null;
        for (int i = 0; i < this._gestures.size(); ++i) {
            Gesture gesture = this._gestures.get(i);
            arrayList.addAll(gesture.processChange(list == null ? this._touchPoints : list, touchPoint));
        }
        if (n == 1) {
            this._touchPoints.remove(touchPoint);
        }
        try {
            this._clientProtocol.processEvents(this._id, arrayList);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

