/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.messages.events;

import com.sparshui.common.Event;
import com.sparshui.common.utils.Converter;

public class FlickEvent
implements Event {
    private static final long serialVersionUID = -2305607021385835330L;
    private float xDirection;
    private float yDirection;
    private float speedLevel;

    public FlickEvent() {
        this.xDirection = 0.0f;
        this.yDirection = 0.0f;
        this.speedLevel = 0.0f;
    }

    public FlickEvent(float f, float f2) {
    }

    public FlickEvent(int n, int n2, int n3) {
        this.speedLevel = n;
        this.xDirection = n2;
        this.yDirection = n3;
    }

    public FlickEvent(byte[] byArray) {
        if (byArray.length < 12) {
            System.err.println("Error constructing Flick Event.");
        } else {
            this.speedLevel = Converter.byteArrayToFloat(byArray, 0);
            this.xDirection = Converter.byteArrayToFloat(byArray, 4);
            this.yDirection = Converter.byteArrayToFloat(byArray, 8);
        }
    }

    public float getSpeedLevel() {
        return this.speedLevel;
    }

    public float getXdirection() {
        return this.xDirection;
    }

    public float getYdirection() {
        return this.yDirection;
    }

    public int getEventType() {
        return 6;
    }

    public String toString() {
        String string = "Flick Event";
        return string;
    }

    public byte[] serialize() {
        byte[] byArray = new byte[16];
        Converter.intToByteArray(byArray, 0, this.getEventType());
        Converter.floatToByteArray(byArray, 4, this.speedLevel);
        Converter.floatToByteArray(byArray, 8, this.xDirection);
        Converter.floatToByteArray(byArray, 12, this.yDirection);
        return byArray;
    }
}

