#############################################################################
##
#A  tbl/weyle7.g          CHEVIE library            Meinolf Geck, Jean Michel
##
#Y  Copyright (C) 1994 - 2010  The CHEVIE Team
##
##  This file contains various data for type E7.
##
CHEVIE.AddData("ReflectionDegrees","E7",[2,6,8,10,12,14,18]);

CHEVIE.AddData("Size", "E7", function(arg) return 2903040; end);

CHEVIE.AddData("GeneratingRoots", "E7", function(arg) return
[ [1,-1,-1,-1,-1,-1,-1,1]/2,
  [1,1,0,0,0,0,0,0],
  [-1,1,0,0,0,0,0,0],
  [0,-1,1,0,0,0,0,0],
  [0,0,-1,1,0,0,0,0],
  [0,0,0,-1,1,0,0,0],
  [0,0,0,0,-1,1,0,0] ];
end);

CHEVIE.AddData("FundamentalGroup","E7",[(1,6)(3,5)(7,126)]);
CHEVIE.AddData("CenterSimplyConnected","E7",[[0,1,0,0,1,0,1]/2]);

CHEVIE.AddData("NrConjugacyClasses", "E7", 60);

CHEVIE.AddData("WordsClassRepresentatives","E7",
List([[],[7,6,7,5,6,7,4,5,6,7,2,4,5,6,7,3,4,5,6,7,2,4,5,6,3,4,5,2,4,3],[5,4,5,2,4,
5,3,4,5,2,4,3],[7,5],[7,5,2,3],[7,6],[6,5,6,4,5,6,2,4,3,4,5,6,2,4,5,3,1,3,4,5,
2,4,3,1],[7,6,4,2],[5,4,5,2,4,3],[7,5,6,2],[7,5,4,5,2,4,5,3,4,5,2,4,3,1],[7,6,
7,5,6,4,5,2,4,5,3,4,5,2,4,3],[7,5,6,3],[7,6,5,4],[7,6,5,4,5,2,4,5,3,4,5,2,4,
3],[5,4,2,3],[1,2,3,1,5,4,6,5,4,2,3,4],[7,6,4,1],[7,6,7,5,6,4,5,2,4,3],[1,2,3,
4,2,3,4,6,5,4,2,3,4,5],[7,5,2,6,4,1],[7,6,5,4,3,1],[7,5,2,3,4,1],[3,4,2,3,4,7,
6,5],[6,5,4,5,2,4,3,1],[7,6,5,4,2,3],[7,5,6,2,3,1],[7,5,4,5,2,4,3,1],[6,4,1,5,
3,2],[7,6,4,2,3,1],[0,0,0,0,0,0,0,0,0],[7],[7,5,2],[7,5,4,5,2,4,5,3,4,5,2,4,3],
[7,5,3],[4,2,3,5,4,2,3,4,6,5,4,2,3,4,5,7,6,5,4,2,3,4,5,6,0],[0,0,0],[3,4,2,3,5,
4,2,3,4,6,5,4,2,3,4,5,0],[5,4,2,6,5,4,2,3,4,7,6,5,4,2,3,1,4,3,5,0,0],
[6,5,4,5,2,4,5,3,4,5,2,4,3],[7,5,6],[7,5,4,5,2,4,3],[7,5,6,2,3],
[7,6,5,4,5,2,4,5,3,4,5,2,4,3,1],[7,6,4],[7,5,2,3,1],[7,6,5,6,4,
5,6,2,4,3,4,5,6,2,4,5,3,1,3,4,5,2,4,3,1],[7,5,4,2,3],[7,6,4,2,1],[7,5,2,6,4],
[7,5,3,6,4],[4,2,0],[6,5,4,2,3],[4,2,5,4,2,3,6,5,4,2,0],[0],[7,5,6,4,1],[3,4,2,
3,4,6,5],[7,5,6,3,1],[6,5,4,2,0],[2,4,2,3,5,4,2,7,6,5,4,3,1]],
x->Replace(x,[0],[7,6,5,4,3,2,1])));

CHEVIE.AddData("ClassNames","E7",
  ["A_0", "6A_1", "4A_1''", "2A_1", "4A_1'", "A_2", "3A_2", "2A_2", "D_4(a_1)",
  "A_3+A_1'", "A_3+3A_1", "D_4(a_1)+2A_1", "A_3+A_1''", "A_4",
  "D_4+2A_1", "D_4", "E_6(a_2)", "A_2+2A_1", "D_6(a_2)", "A_5+A_1''",
  "A_5+A_1'", "A_6", "D_5+A_1", "D_6(a_1)", "E_6(a_1)", "D_6",
  "A_3+A_2+A_1", "D_5(a_1)+A_1", "E_6", "A_4+A_2", "7A_1", "A_1",
  "3A_1'", "5A_1", "3A_1''", "D_4+3A_1", "E_7(a_4)", "D_6(a_2)+A_1",
  "2A_3+A_1", "A_3+2A_1''", "A_3", "D_4(a_1)+A_1", "A_3+2A_1'",
  "D_6+A_1", "A_2+A_1", "A_2+3A_1", "A_5+A_2", "D_4+A_1",
  "2A_2+A_1", "A_5'", "A_5''", "E_7(a_1)", "D_5", "A_7", "E_7",
  "A_4+A_1", "D_5(a_1)", "A_3+A_2", "E_7(a_2)", "E_7(a_3)" ]);

CHEVIE.AddData("ClassInfo","E7",
  rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","E7"),
    classnames:=CHEVIE.RawData("ClassNames","E7"),
    classparams:=CHEVIE.RawData("ClassNames","E7"),
    orders:=[1,2,2,2,2,3,3,3,4,4,4,4,4,5,6,6,6,6,6,6,6,7,8,8,9,10,12,12,12,15,
     2,2,2,2,2,6,6,6,4,4,4,4,4,10,6,6,6,6,6,6,6,14,8,8,18,10,12,12,12,30],
    classes:=[1,63,315,945,3780,672,2240,13440,3780,7560,7560,
    11340,45360,48384,10080,10080,20160,30240,40320,40320,120960,
    207360,90720,90720,161280,145152,60480,60480,120960,96768,1,63,
    315,945,3780,672,2240,13440,3780,7560,7560,11340,45360,48384,
    10080,10080,20160,30240,40320,40320,120960,207360,90720,90720,
    161280,145152,60480,60480,120960,96768]));

CHEVIE.AddData("ParabolicRepresentatives", "E7", 
[[],[1],[1,2],[1..3],[1..4],[1..5],[1..6],[1..7],[1,2,3,4,5,7],[1,2,3,4,6],
[1,2,3,4,6,7],[1,2,3,5],[1,2,3,5,6],[1,2,3,5,6,7],[1,2,3,5,7],[1,2,4,5],
[1,2,4,5,6,7],[1,2,4,5,7],[1,2,5],[1,2,5,7],[1,3],[1,3,4],[1,3,4,5,6],
[1,3,4,5,6,7],[1,3,4,6,7],[1,3,5,6],[2..5],[2..7],[2,3,4,5,7],[2,4,5,6,7],
[2,4,5,7],[2,5,7]]);

CHEVIE.AddData("CharInfo","E7",function()local res;
  res:=rec(charparams:=[ [ 1, 0], [ 1, 63], [ 7, 46], [ 7, 1],  [ 15, 28],
  [ 15, 7],  [ 21, 6], [ 21, 33], [ 21, 36], [ 21, 3],  [ 27, 2],
  [ 27, 37], [ 35, 22], [ 35, 13], [ 35, 4], [ 35, 31], [ 56, 30],
  [ 56, 3],  [ 70, 18], [ 70, 9],  [ 84, 12], [ 84, 15],  [ 105, 26],
  [ 105, 5],  [ 105, 6], [ 105, 21], [ 105, 12], [ 105, 15], [ 120, 4],
  [ 120, 25], [ 168, 6], [ 168, 21], [ 189, 10], [ 189, 17], [ 189, 22],
  [ 189, 5],  [ 189, 20], [ 189, 7],  [ 210, 6], [ 210, 21], [ 210, 10],
  [ 210, 13], [ 216, 16], [ 216, 9],  [ 280, 18], [ 280, 9],  [ 280, 8],
  [ 280, 17], [ 315, 16], [ 315, 7],  [ 336, 14], [ 336, 11], [ 378, 14],
  [ 378, 9],  [ 405, 8], [ 405, 15],  [ 420, 10], [ 420, 13],  [ 512, 12],
  [ 512, 11] ],
  frame:=["1_a","1_a'", "7_a", "7_a'", "15_a", "15_a'", "21_a", "21_a'", "21_b",
  "21_b'", "27_a", "27_a'", "35_a", "35_a'", "35_b", "35_b'", "56_a",
  "56_a'", "70_a", "70_a'", "84_a", "84_a'", "105_a", "105_a'", "105_b",
  "105_b'", "105_c", "105_c'", "120_a", "120_a'", "168_a", "168_a'", "189_a",
  "189_a'", "189_b", "189_b'", "189_c", "189_c'", "210_a", "210_a'", "210_b",
  "210_b'", "216_a", "216_a'", "280_a", "280_a'", "280_b", "280_b'", "315_a",
  "315_a'", "336_a", "336_a'", "378_a", "378_a'", "405_a", "405_a'", "420_a",
  "420_a'", "512_a", "512_a'" ],
  extRefl:=[1,4,7,14,13,8,3,2]);
  res.b:=List(res.charparams,x->x[2]);
  return res;
end);

CHEVIE.AddData("cyclestructure","E7",
  [[],[62],[[60],[51]],[50],[[60],[59]],[,32],
    [,42],[,40],[,,30],[7,,25],[13,,25],[2,,30],
    [11,,25],[,,,24],[14,,,,16],[12,,,,16],[,2,,,20],
    [14,8,,,12],[2,,,,20],[[3,2,,,19],[,6,,,17]],
    [[3,2,,,19],[2,2,,,19]],[,,,,,18],[3,,,,,,15],
    [,,1,,,,15],[,,,,,,,14],[2,,,,,,,,12],[1,4,7,,2,,,,,,6],
    [1,,7,,4,,,,,,6],[,2,,,,,,,,,10],[,2,,6,,,,,,,,,,6],
    [63],[33],[51],[61],[59],[15,,,,16],[,,,,21],
    [3,,,,20],[3,,30],[[12,,25],[7,,25]],[6,,25],
    [1,,30],[[12,,25],[11,,25]],[3,,,,,,,,12],[9,16,,,8],
    [15,8,,,12],[,8,,,17],[13,,,,16],[3,20,,,10],
    [,6,,,17],[2,2,,,19],[,,,,,,,,,,,,9],[2,,,,,,15],
    [1,,1,,,,15],[,,,,,,,,,,,,,,,,7],[3,,,12,,,,,6],
    [,,7,,4,,,,,,6],[,4,7,,2,,,,,,6],[,,,,1,,,,,,10],
           [,,,,1,,,,3,,,,,,,,,,,,,,,,,,,,3]]);

CHEVIE.AddData("generators","E7",
  [(1,64)(3,8)(10,14)(15,20)(17,21)(22,26)(24,27)(28,32)
    (29,33)(31,34)(35,38)(36,39)(40,43)(41,44)(45,48)(49,52)
    (62,63)(66,71)(73,77)(78,83)(80,84)(85,89)(87,90)(91,95)
    (92,96)(94,97)(98,101)(99,102)(103,106)(104,107)(108,111)(112,115)
    (125,126),(2,65)(4,9)(10,15)(11,16)(14,20)(17,22)(18,23)
    (21,26)(24,29)(25,30)(27,33)(31,36)(34,39)(50,53)(54,56)
    (57,58)(59,60)(67,72)(73,78)(74,79)(77,83)(80,85)(81,86)
    (84,89)(87,92)(88,93)(90,96)(94,99)(97,102)(113,116)(117,119)
    (120,121)(122,123),(1,8)(3,66)(4,10)(9,15)(11,17)(16,22)
    (18,24)(23,29)(25,31)(30,36)(32,37)(38,42)(43,46)(44,47)
    (48,51)(52,55)(61,62)(64,71)(67,73)(72,78)(74,80)(79,85)
    (81,87)(86,92)(88,94)(93,99)(95,100)(101,105)(106,109)(107,110)
    (111,114)(115,118)(124,125),(2,9)(3,10)(4,67)(5,11)(8,14)
    (12,18)(19,25)(22,28)(26,32)(29,35)(33,38)(36,41)(39,44)
    (46,50)(51,54)(55,57)(60,61)(65,72)(66,73)(68,74)(71,77)
    (75,81)(82,88)(85,91)(89,95)(92,98)(96,101)(99,104)(102,107)
    (109,113)(114,117)(118,120)(123,124),(4,11)(5,68)(6,12)(9,16)
    (10,17)(13,19)(14,21)(15,22)(20,26)(35,40)(38,43)(41,45)
    (42,46)(44,48)(47,51)(57,59)(58,60)(67,74)(69,75)(72,79)
    (73,80)(76,82)(77,84)(78,85)(83,89)(98,103)(101,106)(104,108)
    (105,109)(107,111)(110,114)(120,122)(121,123),
    (5,12)(6,69)(7,13)(11,18)(16,23)(17,24)(21,27)(22,29)
    (26,33)(28,35)(32,38)(37,42)(45,49)(48,52)(51,55)(54,57)
    (56,58)(68,75)(70,76)(74,81)(79,86)(80,87)(84,90)(85,92)
    (89,96)(91,98)(95,101)(100,105)(108,112)(111,115)(114,118)(117,120)
    (119,121),(6,13)(7,70)(12,19)(18,25)(23,30)(24,31)(27,34)
    (29,36)(33,39)(35,41)(38,44)(40,45)(42,47)(43,48)(46,51)
    (50,54)(53,56)(69,76)(75,82)(81,88)(86,93)(87,94)(90,97)
    (92,99)(96,102)(98,104)(101,107)(103,108)(105,110)(106,111)(109,114)
    (113,117)(116,119)]);

CHEVIE.AddData("CartanMat","E7",
  [ [ 2, 0, -1, 0, 0, 0, 0 ], [ 0, 2, 0, -1, 0, 0, 0 ],
      [ -1, 0, 2, -1, 0, 0, 0 ], [ 0, -1, -1, 2, -1, 0, 0 ],
      [ 0, 0, 0, -1, 2, -1, 0 ], [ 0, 0, 0, 0, -1, 2, -1 ],
      [ 0, 0, 0, 0, 0, -1, 2 ] ]);

CHEVIE.AddData("PowerMaps","E7",
  [ , [ 1, 1, 1, 1, 1, 6, 7, 8, 3, 4, 4, 3, 4, 14, 6, 6, 7, 6, 8, 8, 8, 22, 9,
      12, 25, 14, 18, 18, 17, 30, 1, 1, 1, 1, 1, 6, 7, 8, 3, 4, 4, 3, 4, 14,
      6, 6, 7, 6, 8, 8, 8, 22, 9, 12, 25, 14, 18, 18, 17, 30 ],
  [ 1, 2, 3, 4, 5, 1, 1, 1, 9, 10, 11, 12, 13, 14, 2, 3, 3, 4, 2, 3, 5, 22,
      23, 24, 7, 26, 10, 11, 9, 14, 31, 32, 33, 34, 35, 31, 31, 31, 39, 40,
      41, 42, 43, 44, 32, 33, 33, 34, 32, 33, 35, 52, 53, 54, 37, 56, 40, 41,
      39, 44 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 1, 15, 16, 17, 18, 19, 20, 21,
      22, 23, 24, 25, 2, 27, 28, 29, 6, 31, 32, 33, 34, 35, 36, 37, 38, 39,
      40, 41, 42, 43, 31, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 32, 57,
      58, 59, 36 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 1, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 31, 53, 54, 55, 56,
      57, 58, 59, 60 ] ]);

CHEVIE.AddData("vpolheckeirreducibles","E7",
[[[[1],0],[[1],30],[[1],12],[[1],2],[[1],4],[[1],2],[[1],24],[[1],4],[[1],6],
[[1],4],[[1],14],[[1],16],[[1],4],[[1],4],[[1],14],[[1],4],[[1],12],[[1],4],
[[1],10],[[1],14],[[1],6],[[1],6],[[1],6],[[1],8],[[1],8],[[1],6],[[1],6],
[[1],8],[[1],6],[[1],6],[[1],63],[[1],1],[[1],3],[[1],13],[[1],3],[[1],31],
[[1],21],[[1],23],[[1],33],[[1],13],[[1],3],[[1],7],[[1],5],[[1],15],[[1],3],
[[1],5],[[1],25],[[1],5],[[1],5],[[1],5],[[1],5],[[1],9],[[1],5],[[1],17],
[[1],7],[[1],5],[[1],7],[[1],5],[[1],11],[[1],13]],[[[1],0],[[1],0],[[1],0],
[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],
0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[-1],0],
[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],
0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],
[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],0],[[-1],
0],[[-1],0],[[-1],0],[[-1],0]],[[[7],0],[[1,0,0,0,0,-6],0],[[3,0,0,-4],0],[[5,
-2],0],[[3,-4],0],[[5,-1],0],[[1,0,0,0,-3],0],[[3,-2],0],[[3],0],[[3,-2],0],
[[1,-1,0,-3],0],[[1,0,0,-2],0],[[3,-2],0],[[3,-1],0],[[1,0,0,-3],0],[[3,-1],
0],[[1,0,1],0],[[3,-3],0],[[1],0],[[1,0,0,-2],0],[[1,-2],0],[[1,-1],0],[[1,
-2],0],[[1],0],[[1],0],[[1,-1],0],[[1,-3],0],[[1,-1],0],[[1,-1],0],[[1,-2],0],
[[7],9],[[-6,1],0],[[-4,3],0],[[-2,1,0,4],0],[[-4,3],0],[[-1,0,5],3],[[-2],3],
[[-1,2],3],[[3],5],[[-2,0,0,3],0],[[-4,1],0],[[-2,1],0],[[-2,3],0],[[2],3],
[[-4,2],0],[[-2,4],0],[[2],4],[[-2,2],0],[[-2,3],0],[[-2,1],0],[[-2,1],0],[[],
0],[[-2,1],0],[[1],3],[[1],1],[[-2,2],0],[[-2],0],[[-2,2],0],[[],0],[[-1],2]],
[[[7],0],[[-6,0,0,0,0,1],25],[[-4,0,0,3],9],[[-2,5],1],[[-4,3],3],[[-1,5],1],
[[-3,0,0,0,1],20],[[-2,3],3],[[3],6],[[-2,3],3],[[-3,0,-1,1],11],[[-2,0,0,1],
13],[[-2,3],3],[[-1,3],3],[[-3,0,0,1],11],[[-1,3],3],[[1,0,1],10],[[-3,3],3],
[[1],10],[[-2,0,0,1],11],[[-2,1],5],[[-1,1],5],[[-2,1],5],[[1],8],[[1],8],
[[-1,1],5],[[-3,1],5],[[-1,1],7],[[-1,1],5],[[-2,1],5],[[-7],54],[[-1,6],0],
[[-3,4],2],[[-4,0,-1,2],10],[[-3,4],2],[[-5,0,1],26],[[2],18],[[-2,1],19],
[[-3],28],[[-3,0,0,2],10],[[-1,4],2],[[-1,2],6],[[-3,2],4],[[-2],12],[[-2,4],
2],[[-4,2],4],[[-2],21],[[-2,2],4],[[-3,2],4],[[-1,2],4],[[-1,2],4],[[],0],
[[-1,2],4],[[-1],14],[[-1],6],[[-2,2],4],[[2],7],[[-2,2],4],[[],0],[[1],11]],
[[[15],0],[[-10,0,0,5],9],[[-4,9,0,2],3],[[7,-6,2],0],[[3,-7,3,-1,1],0],[[5,
-5],0],[[-3],8],[[3,-2,2],0],[[-3,2],2],[[1,-4],0],[[-1,3,-1],3],[[2,-1,2],5],
[[2,-2,1],0],[[1,-1],0],[[-1,1,0,-2],3],[[-1,-1],1],[[1],4],[[3,-4,2,-1],0],
[[-1,2],3],[[1],4],[[-1],1],[[1],0],[[1],3],[[-1],3],[[],0],[[],0],[[1,-2,1],
0],[[-1,0,-1],2],[[-1],2],[[1,-1],0],[[15],21],[[-10,5],0],[[-4,9,0,2],0],[[4,
-6,3,0,2],3],[[-5,6,-3,1],0],[[5,0,-5],9],[[-3],7],[[-1,4],7],[[-3,2],11],[[1,
-4],3],[[-2,3],0],[[2,-1,2],2],[[-1,3,-1],0],[[],0],[[-4,4,-2],0],[[-2,4,-3,0,
-1],0],[[2,-1],8],[[1,0,-1],1],[[-2,3,-1,1],0],[[1],1],[[-1],0],[[1],3],[[1],
2],[[-1],6],[[],0],[[-1,1],0],[[1,-1],2],[[-2,1,-1],0],[[-1],4],[[],0]],
[[[15],0],[[5,0,0,-10],18],[[2,0,9,-4],6],[[2,-6,7],0],[[1,-1,3,-7,3],0],[[-5,
5],1],[[-3],16],[[2,-2,3],2],[[2,-3],3],[[-4,1],3],[[-1,3,-1],9],[[2,-1,2],9],
[[1,-2,2],2],[[-1,1],3],[[-2,0,1,-1],8],[[-1,-1],2],[[1],8],[[-1,2,-4,3],1],
[[2,-1],6],[[1],10],[[-1],5],[[1],6],[[1],3],[[-1],5],[[],0],[[],0],[[1,-2,1],
4],[[-1,0,-1],4],[[-1],4],[[-1,1],5],[[-15],42],[[-5,10],0],[[-2,0,-9,4],0],
[[-2,0,-3,6,-4],6],[[-1,3,-6,5],0],[[5,0,-5],20],[[3],14],[[-4,1],15],[[-2,3],
21],[[4,-1],9],[[-3,2],2],[[-2,1,-2],3],[[1,-3,1],3],[[],0],[[2,-4,4],1],[[1,
0,3,-4,2],1],[[1,-2],16],[[1,0,-1],2],[[-1,1,-3,2],2],[[-1],4],[[1],5],[[-1],
6],[[-1],3],[[1],11],[[],0],[[-1,1],4],[[1,-1],4],[[1,-1,2],3],[[1],7],[[],
0]],[[[21],0],[[15,0,0,0,0,-6],20],[[6,0,0,-12,0,0,3],6],[[1,-10,10],0],[[6,
-12,3],2],[[1,-5,10],0],[[6,0,0,0,-3],16],[[3,-6,3],2],[[2,0,0,3],3],[[2,-6,
3],2],[[3,0,4,-3,0,-1],8],[[1,2,0,-2],10],[[2,-6,3],2],[[1,-3,3],2],[[3,0,0,
-3],8],[[-3,3],3],[[2,0,1],8],[[4,-9,3],2],[[],0],[[1,0,1,-2],8],[[2,-2],4],
[[1,-1],4],[[1,-2],4],[[1],5],[[],0],[[-1],5],[[5,-3],4],[[1,0,-1],5],[[-1],
5],[[3,-2],4],[[21],45],[[-6,15],0],[[3,-12,6],1],[[6,0,4,-8,0,-2,1],7],[[3,
-12,6],1],[[10,0,-5,0,1],21],[[3],15],[[1,-2,1],15],[[3,2],23],[[3,0,1,-6,0,0,
1],7],[[1,-4,6],1],[[2,0,-2,1],4],[[4,-6,1],3],[[1],9],[[2,-8,6],1],[[7,-8,1],
3],[[3],17],[[1,-4,1],3],[[5,-6,1],3],[[1,-2,1],3],[[1,-2,1],3],[[],0],[[-2,
1],4],[[1],12],[[],0],[[2,-4,1],3],[[1,0,0,1],4],[[3,-4,1],3],[[-1],8],[[1],
9]],[[[21],0],[[-6,0,0,0,0,15],5],[[3,0,0,-12,0,0,6],0],[[10,-10,1],0],[[3,
-12,6],0],[[10,-5,1],0],[[-3,0,0,0,6],4],[[3,-6,3],0],[[3,0,0,2],0],[[3,-6,2],
0],[[-1,0,-3,4,0,3],1],[[-2,0,2,1],3],[[3,-6,2],0],[[3,-3,1],0],[[-3,0,0,3],
3],[[3,-3],0],[[1,0,2],2],[[3,-9,4],0],[[],0],[[-2,1,0,1],3],[[-2,2],1],[[-1,
1],1],[[-2,1],1],[[1],3],[[],0],[[-1],1],[[-3,5],1],[[-1,0,1],1],[[-1],1],
[[-2,3],1],[[-21],18],[[-15,6],0],[[-6,12,-3],0],[[-1,2,0,8,-4,0,-6],0],[[-6,
12,-3],0],[[-1,0,5,0,-10],6],[[-3],6],[[-1,2,-1],6],[[-2,-3],9],[[-1,0,0,6,-1,
0,-3],0],[[-6,4,-1],0],[[-1,2,0,-2],0],[[-1,6,-4],0],[[-1],6],[[-6,8,-2],0],
[[-1,8,-7],0],[[-3],8],[[-1,4,-1],0],[[-1,6,-5],0],[[-1,2,-1],0],[[-1,2,-1],
0],[[],0],[[-1,2],0],[[-1],5],[[],0],[[-1,4,-2],0],[[-1,0,0,-1],0],[[-1,4,-3],
0],[[1],3],[[-1],4]],[[[21],0],[[-6,5,0,0,-10],5],[[4,0,0,-8,9],0],[[12,-8,1],
0],[[6,-11,3,-1],0],[[11,-5],0],[[1,0,0,0,0,0,2],0],[[5,-6,1],0],[[4,0,-3],0],
[[4,-7],0],[[1,-1,0,-4,3,-2],0],[[-2,1,2],3],[[5,-5,1],0],[[4,-3],0],[[-4,2],
3],[[4,-2],0],[[1,0,0,-2],0],[[6,-7,3],0],[[-1,-1],2],[[1,0,0,-1,2],0],[[1,-2,
1],0],[[1,-1],0],[[1,-2],0],[[-1],2],[[1,0,-1],0],[[-1],1],[[2,-4,2],0],[[1,
-1,-1,1],0],[[1],0],[[2,-2,1],0],[[21],15],[[-16,5],0],[[-8,12,0,1],0],[[-2,2,
0,8,-6,3],0],[[-9,9,-3],0],[[1,0,0,0,5],5],[[3],5],[[2,-2],5],[[1],9],[[-2,0,
0,4,-5],0],[[-7,4],0],[[-2,2,2,-1],0],[[-3,6,-2],0],[[1],3],[[-8,7,-1],0],
[[-4,8,-3,1],0],[[1,-2],5],[[-2,4],0],[[-4,5,-3],0],[[-1,3],0],[[-2,2],0],[[],
0],[[-2,1],0],[[-1],5],[[],0],[[-3,3,-1],0],[[-2,0,2],0],[[-3,4,-1],0],[[1],
3],[[1],3]],[[[21],0],[[-10,0,0,5,-6],21],[[9,-8,0,0,4],8],[[1,-8,12],0],[[-1,
3,-11,6],1],[[-5,11],1],[[2,0,0,0,0,0,1],18],[[1,-6,5],2],[[-3,0,4],4],[[-7,
4],3],[[-2,3,-4,0,-1,1],9],[[2,1,-2],11],[[1,-5,5],2],[[-3,4],3],[[2,-4],10],
[[-2,4],3],[[-2,0,0,1],9],[[3,-7,6],2],[[-1,-1],7],[[2,-1,0,0,1],10],[[1,-2,
1],4],[[-1,1],5],[[-2,1],5],[[-1],6],[[-1,0,1],6],[[-1],5],[[2,-4,2],4],[[1,
-1,-1,1],5],[[1],6],[[1,-2,2],4],[[-21],48],[[-5,16],0],[[-1,0,-12,8],0],[[-3,
6,-8,0,-2,2],8],[[3,-9,9],1],[[-5,0,0,0,-1],22],[[-3],16],[[2,-2],17],[[-1],
24],[[5,-4,0,0,2],9],[[-4,7],2],[[1,-2,-2,2],4],[[2,-6,3],3],[[-1],12],[[1,-7,
8],1],[[-1,3,-8,4],2],[[2,-1],19],[[-4,2],4],[[3,-5,4],3],[[-3,1],4],[[-2,2],
4],[[],0],[[-1,2],4],[[1],12],[[],0],[[1,-3,3],3],[[-2,0,2],5],[[1,-4,3],3],
[[-1],8],[[-1],10]],[[[27],0],[[15,0,5,-6,0,0,0,0,1],22],[[9,-12,0,0,6],8],
[[1,-10,16],0],[[6,-12,9],2],[[-6,15],1],[[2,0,-3,0,0,0,1],18],[[1,-8,7],2],
[[-3,0,6],4],[[1,-7,7],2],[[8,-4,0,-1,2],10],[[-2,0,0,1],13],[[1,-7,7],2],
[[-4,6],3],[[5,-3,0,0,1],10],[[-3,6],3],[[-2,1,0,1],9],[[3,-10,8],2],[[-1,0,
1],8],[[2,-3,0,0,1],10],[[1,-3,2],4],[[-2,1],5],[[1,-2,2],4],[[-2,0,1],6],
[[-1,0,1],6],[[-1,1],5],[[3,-5,3],4],[[-2,-1,2],6],[[-1,1],5],[[1,-4,2],4],
[[27],49],[[-6,21],0],[[3,-12,12],1],[[13,-8,0,-2,4],9],[[3,-12,12],1],[[9],
23],[[],0],[[],0],[[3],25],[[5,-7,0,0,3],9],[[-5,10],2],[[-3,-2,4],5],[[3,-7,
5],3],[[2],11],[[1,-9,11],1],[[6,-9,6],3],[[],0],[[1,-4,4],3],[[3,-8,5],3],
[[-3,3],4],[[-3,3],4],[[-1],7],[[-2,3],4],[[-1],13],[[],0],[[1,-5,4],3],[[-2,
0,3],5],[[1,-6,4],3],[[],0],[[-1],10]],[[[27],0],[[1,0,0,0,0,-6,5,0,15],0],
[[6,0,0,-12,9],0],[[16,-10,1],0],[[9,-12,6],0],[[15,-6],0],[[1,0,0,0,-3,0,2],
0],[[7,-8,1],0],[[6,0,-3],0],[[7,-7,1],0],[[2,-1,0,-4,8],0],[[1,0,0,-2],0],
[[7,-7,1],0],[[6,-4],0],[[1,0,0,-3,5],0],[[6,-3],0],[[1,0,1,-2],0],[[8,-10,3],
0],[[1,0,-1],0],[[1,0,0,-3,2],0],[[2,-3,1],0],[[1,-2],0],[[2,-2,1],0],[[1,0,
-2],0],[[1,0,-1],0],[[1,-1],0],[[3,-5,3],0],[[2,-1,-2],0],[[1,-1],0],[[2,-4,
1],0],[[-27],14],[[-21,6],0],[[-12,12,-3],0],[[-4,2,0,8,-13],0],[[-12,12,-3],
0],[[-9],8],[[],0],[[],0],[[-3],8],[[-3,0,0,7,-5],0],[[-10,5],0],[[-4,2,3],0],
[[-5,7,-3],0],[[-2],4],[[-11,9,-1],0],[[-6,9,-6],0],[[],0],[[-4,4,-1],0],[[-5,
8,-3],0],[[-3,3],0],[[-3,3],0],[[1],2],[[-3,2],0],[[1],4],[[],0],[[-4,5,-1],
0],[[-3,0,2],0],[[-4,6,-1],0],[[],0],[[1],3]],[[[35],0],[[15,0,0,0,0,-20],10],
[[1,0,0,-12,0,0,18,0,0,-4],0],[[10,-20,5],0],[[1,-12,18,-4],0],[[10,-10,5],0],
[[6,0,0,0,-7],8],[[1,-6,9,-2],0],[[1,0,0,6],0],[[1,-6,6,-2],0],[[4,-1,3,-6,0,
-1],4],[[2,1,0,-4],5],[[1,-6,6,-2],0],[[1,-3,3,-1],0],[[-1,3,0,0,-1],5],[[1,
-3,0,-1],0],[[2,0,1],4],[[1,-9,12,-3],0],[[-2],5],[[1,0,1,-2],4],[[2,-2],2],
[[1,-1],2],[[1],2],[[1],3],[[-1],4],[[],0],[[5,-6],2],[[1,-2],3],[[1],3],[[3,
-3],2],[[35],27],[[-20,15],0],[[-4,18,-12,1],0],[[1,0,4,-8,0,-12,6,0,4],1],
[[-4,18,-12,1],0],[[5,0,-10,0,10],11],[[-1],9],[[1,2,-1],9],[[6,1],14],[[3,-2,
0,-6,3,0,1],3],[[-4,6,-4,1],0],[[1,0,-4,2],1],[[3,-8,4],1],[[],0],[[-4,12,-8,
1],0],[[4,-14,7],1],[[1,0,0,2],9],[[2,-2,1],1],[[3,-10,5],1],[[1,-2,1],1],[[1,
-2,1],1],[[],0],[[1],1],[[1],8],[[-1],3],[[2,-4,2],1],[[-2,1],3],[[2,-6,3],1],
[[1],5],[[],0]],[[[35],0],[[-20,0,0,0,0,15],15],[[-4,0,0,18,0,0,-12,0,0,1],3],
[[5,-20,10],0],[[-4,18,-12,1],1],[[5,-10,10],0],[[-7,0,0,0,6],12],[[-2,9,-6,
1],1],[[6,0,0,1],3],[[-2,6,-6,1],1],[[-1,0,-6,3,-1,4],5],[[-4,0,1,2],8],[[-2,
6,-6,1],1],[[-1,3,-3,1],1],[[-1,0,0,3,-1],5],[[-1,0,-3,1],1],[[1,0,2],6],[[-3,
12,-9,1],1],[[-2],5],[[-2,1,0,1],7],[[-2,2],3],[[-1,1],3],[[1],4],[[1],5],
[[-1],4],[[],0],[[-6,5],3],[[-2,1],4],[[1],3],[[-3,3],3],[[-35],36],[[-15,20],
0],[[-1,12,-18,4],0],[[-4,0,-6,12,0,8,-4,0,-1],4],[[-1,12,-18,4],0],[[-10,0,
10,0,-5],16],[[1],12],[[1,-2,-1],12],[[-1,-6],18],[[-1,0,-3,6,0,2,-3],4],[[-1,
4,-6,4],0],[[-2,4,0,-1],3],[[-4,8,-3],2],[[],0],[[-1,8,-12,4],0],[[-7,14,-4],
2],[[-2,0,0,-1],13],[[-1,2,-2],2],[[-5,10,-3],2],[[-1,2,-1],2],[[-1,2,-1],2],
[[],0],[[-1],4],[[-1],9],[[1],4],[[-2,4,-2],2],[[-1,2],3],[[-3,6,-2],2],[[-1],
6],[[],0]],[[[35],0],[[9,-10,15,0,0,0,0,0,0,0,1],20],[[2,0,18,-12,0,0,3],6],
[[3,-14,18],0],[[-3,9,-13,10],1],[[-10,15],1],[[-3,0,2],16],[[3,-8,7],2],[[2,
-6,0,3],3],[[3,-5,7],2],[[-3,7,-4,0,0,1],9],[[-1,4,-1,0,0,0,1],10],[[2,-7,6],
2],[[-4,4],3],[[3,-1,0,0,1],10],[[-1,-3,3],2],[[1,-2],8],[[-1,5,-11,8],1],
[[-1,0,0,1],7],[[3,-1],10],[[-2,2],5],[[-1,1],5],[[-1,-1,1],4],[[1,-1,0,1],5],
[[-1],6],[[-1,0,1],4],[[-1,2,-5,3],3],[[2,-2,0,1],5],[[-1],4],[[1,-3,2],4],
[[35],45],[[-10,25],0],[[9,-12,14],1],[[2,-6,16,-8,0,0,3],7],[[-1,6,-15,13],
0],[[5],23],[[-1],15],[[2],16],[[-3,2],23],[[9,-5,0,0,1],9],[[-7,8],2],[[4,-4,
0,3],4],[[-1,3,-6,5],2],[[],0],[[3,-11,11],1],[[-3,6,-10,6],2],[[-1],17],[[-2,
3],4],[[-1,4,-8,5],2],[[-1,3],4],[[-2,2],4],[[],0],[[-1,-1,1],3],[[1],12],
[[-1],5],[[1,-4,3],3],[[1,-3,0,1],4],[[2,-5,4],3],[[-1],8],[[],0]],[[[35],0],
[[1,0,0,0,0,0,0,0,15,-10,9],0],[[3,0,0,-12,18,0,2],0],[[18,-14,3],0],[[10,-13,
9,-3],0],[[15,-10],0],[[2,0,-3],6],[[7,-8,3],0],[[3,0,-6,2],0],[[7,-5,3],0],
[[1,0,0,-4,7,-3],0],[[1,0,0,0,-1,4,-1],0],[[6,-7,2],0],[[4,-4],0],[[1,0,0,-1,
3],0],[[3,-3,-1],0],[[-2,1],3],[[8,-11,5,-1],0],[[1,0,0,-1],0],[[-1,3],3],[[2,
-2],0],[[1,-1],0],[[1,-1,-1],0],[[1,0,-1,1],0],[[-1],2],[[1,0,-1],0],[[3,-5,2,
-1],0],[[1,0,-2,2],0],[[-1],2],[[2,-3,1],0],[[-35],18],[[-25,10],0],[[-14,12,
-9],0],[[-3,0,0,8,-16,6,-2],0],[[-13,15,-6,1],0],[[-5],8],[[1],6],[[-2],7],
[[-2,3],9],[[-1,0,0,5,-9],0],[[-8,7],0],[[-3,0,4,-4],0],[[-5,6,-3,1],0],[[],
0],[[-11,11,-3],0],[[-6,10,-6,3],0],[[1],8],[[-3,2],0],[[-5,8,-4,1],0],[[-3,
1],0],[[-2,2],0],[[],0],[[-1,1,1],0],[[-1],5],[[1],2],[[-3,4,-1],0],[[-1,0,3,
-1],0],[[-4,5,-2],0],[[1],3],[[],0]],[[[56],0],[[1,0,0,0,0,-6,0,0,15,-10,-24],
0],[[6,0,0,-24,18,0,-8],0],[[28,-24,4],0],[[13,-25,15,-3],0],[[25,-15,1],0],
[[-3,0,2,0,3],4],[[10,-14,6],0],[[6,0,-6],0],[[10,-11,5],0],[[1,-1,0,-7,9,-3,
-3],0],[[1,0,0,-2,-1,2],0],[[9,-13,4],0],[[7,-7,1],0],[[1,0,0,-4,3,0,-3],0],
[[6,-6,1],0],[[1,-2,-1],2],[[11,-20,9,-1],0],[[1,0,0,-1],0],[[-3,2,0,-1],3],
[[2,-4,2],0],[[1,-2,1],0],[[1,-3,2],0],[[1,0,-1],0],[[-1],2],[[1,-1,1],0],[[3,
-8,7,-1],0],[[1,-1,-2,1],0],[[-1,1],1],[[2,-5,4],0],[[56],18],[[-40,16],0],
[[-20,24,-12],0],[[-4,2,0,16,-20,6,8],0],[[-19,27,-9,1],0],[[1,0,0,0,10],6],
[[2],6],[[1,0,1],6],[[],0],[[-2,0,0,11,-8,0,3],0],[[-14,11,-1],0],[[-4,2,4,
-2],0],[[-6,12,-7,1],0],[[1],6],[[-17,19,-5],0],[[-7,18,-13,3],0],[[-2],8],
[[-4,6,-3],0],[[-6,14,-9,1],0],[[-4,3,-1],0],[[-3,4,-1],0],[[],0],[[-2,3,-1],
0],[[],0],[[-1],2],[[-4,8,-3],0],[[-2,0,3],0],[[-5,9,-5],0],[[],0],[[1],4]],
[[[56],0],[[-24,-10,15,0,0,-6,0,0,0,0,1],20],[[-8,0,18,-24,0,0,6],6],[[4,-24,
28],0],[[-3,15,-25,13],1],[[1,-15,25],0],[[3,0,2,0,-3],16],[[6,-14,10],2],
[[-6,0,6],4],[[5,-11,10],2],[[-3,-3,9,-7,0,-1,1],8],[[2,-1,-2,0,0,1],11],[[4,
-13,9],2],[[1,-7,7],2],[[-3,0,3,-4,0,0,1],8],[[1,-6,6],2],[[-1,-2,1],8],[[-1,
9,-20,11],1],[[-1,0,0,1],7],[[-1,0,2,-3],8],[[2,-4,2],4],[[1,-2,1],4],[[2,-3,
1],4],[[-1,0,1],6],[[-1],6],[[1,-1,1],4],[[-1,7,-8,3],3],[[1,-2,-1,1],5],[[1,
-1],4],[[4,-5,2],4],[[-56],45],[[-16,40],0],[[12,-24,20],1],[[-8,-6,20,-16,0,
-2,4],7],[[-1,9,-27,19],0],[[-10,0,0,0,-1],21],[[-2],15],[[-1,0,-1],15],[[],
0],[[-3,0,8,-11,0,0,2],7],[[1,-11,14],1],[[2,-4,-2,4],4],[[-1,7,-12,6],2],
[[-1],9],[[5,-19,17],1],[[-3,13,-18,7],2],[[2],17],[[3,-6,4],3],[[-1,9,-14,6],
2],[[1,-3,4],3],[[1,-4,3],3],[[],0],[[1,-3,2],3],[[],0],[[1],5],[[3,-8,4],3],
[[-3,0,2],5],[[5,-9,5],3],[[],0],[[-1],9]],[[[70],0],[[-10,0,0,0,-30,30],9],
[[-8,18,0,-20],3],[[24,-32,14],0],[[10,-21,21,-15,3],0],[[15,-25,5],0],[[6,0,
1],10],[[5,-10,9,-4,1],0],[[-6,8],2],[[4,-6,7,-3],0],[[-1,4,0,-6,8,-3],3],[[2,
0,-2,2],5],[[3,-8,6,-3],0],[[1,-3,2],0],[[-1,0,0,-3,3],3],[[-2,1],1],[[2,-3],
5],[[7,-14,15,-7,2],0],[[-1],3],[[-3,3,-1],6],[[1],0],[[],0],[[],0],[[],0],
[[1],4],[[],0],[[2,-3,3,-3,1,-1],0],[[-1,1,-1],2],[[-1],3],[[1,-1,1,-1],0],
[[70],27],[[-40,30],0],[[-16,24,-24,6],0],[[8,-12,6,12,-8],3],[[-15,27,-21,7],
0],[[1,0,0,0,5,-16,5],9],[[7],9],[[3,-4,2],9],[[2],15],[[1,-4,0,11,-6],3],
[[-4,11,-5],0],[[4,-6,4],2],[[-3,5,-6,4,-2],0],[[],0],[[-10,19,-13,3],0],[[-5,
11,-13,10,-5,1],0],[[-2,1],10],[[2,0,1],1],[[-4,7,-9,6,-2,1],0],[[-1],0],[[1],
1],[[],0],[[],0],[[],0],[[1],3],[[-1,2,-2,1],0],[[1,-2],2],[[-2,4,-4,2,-1],0],
[[-1],5],[[],0]],[[[70],0],[[30,-30,0,0,0,-10],16],[[-20,0,18,-8],6],[[14,-32,
24],0],[[3,-15,21,-21,10],0],[[5,-25,15],0],[[1,0,6],12],[[1,-4,9,-10,5],0],
[[8,-6],3],[[-3,7,-6,4],1],[[-3,8,-6,0,4,-1],6],[[2,-2,0,2],8],[[-3,6,-8,3],
1],[[2,-3,1],2],[[3,-3,0,0,-1],7],[[1,-2],2],[[-3,2],6],[[2,-7,15,-14,7],0],
[[-1],7],[[-1,3,-3],6],[[1],6],[[],0],[[],0],[[],0],[[1],4],[[],0],[[-1,1,-3,
3,-3,2],1],[[-1,1,-1],4],[[-1],3],[[-1,1,-1,1],3],[[-70],36],[[-30,40],0],
[[-6,24,-24,16],0],[[8,-12,-6,12,-8],6],[[-7,21,-27,15],0],[[-5,16,-5,0,0,0,
-1],16],[[-7],12],[[-2,4,-3],12],[[-2],18],[[6,-11,0,4,-1],6],[[5,-11,4],1],
[[-4,6,-4],3],[[2,-4,6,-5,3],1],[[],0],[[-3,13,-19,10],0],[[-1,5,-10,13,-11,
5],0],[[-1,2],14],[[-1,0,-2],2],[[-1,2,-6,9,-7,4],0],[[1],5],[[-1],4],[[],0],
[[],0],[[],0],[[-1],4],[[-1,2,-2,1],2],[[2,-1],4],[[1,-2,4,-4,2],1],[[1],6],
[[],0]],[[[84],0],[[5,0,0,-40,30,0,0,0,9],12],[[9,0,-8,0,18,0,0,0,1],4],[[20,
-40,24],0],[[4,-22,30,-18,10],0],[[10,-30,14],0],[[-3,0,6],12],[[3,-6,13,-10,
3],0],[[-3,12,-6,0,1],2],[[-7,9,-5,3],1],[[-1,-2,5,-5,0,3],5],[[-1,2,2,0,-1,
2],6],[[1,-5,9,-7,2],0],[[-1,3,-3],1],[[1,0,-2,2,-3],4],[[1,0,1],2],[[-3,2],
6],[[3,-13,18,-15,5],0],[[2,-1],4],[[-1,2,-3,1],6],[[1],2],[[],0],[[1,-1],3],
[[-1,0,1],3],[[],0],[[-1],4],[[-2,4,-4,3,-2,1],1],[[1,-2,2,-1],3],[[1],3],
[[-1,1,-1,1,-1],1],[[84],33],[[-40,44],0],[[-8,36,-24,16],0],[[-6,3,4,-4,-6,
12,0,0,0,1],4],[[-10,30,-30,14],0],[[10,-16],15],[[3],11],[[1,0,2],11],[[4],
18],[[-1,0,5,-7,0,3],4],[[-1,9,-11,3],0],[[2,-5,10,-4,0,1],2],[[4,-8,6,-4,2],
1],[[-1],9],[[-6,18,-22,8],0],[[-1,9,-16,15,-9,4],0],[[-2,0,1],13],[[-2,-1,0,
1],2],[[-1,6,-9,10,-7,2],0],[[-1],2],[[1],3],[[],0],[[1,-1],2],[[],0],[[],0],
[[1,-2,2,-2],1],[[-2,3,-1],3],[[-1,2,-4,5,-3,1],0],[[1],6],[[-1],7]],[[[84],
0],[[9,0,0,0,30,-40,0,0,5],10],[[1,0,0,0,18,0,-8,0,9],0],[[24,-40,20],0],[[10,
-18,30,-22,4],0],[[14,-30,10],0],[[6,0,-3],10],[[3,-10,13,-6,3],0],[[1,0,-6,
12,-3],0],[[3,-5,9,-7],0],[[3,0,-5,5,-2,-1],4],[[2,-1,0,2,2,-1],5],[[2,-7,9,
-5,1],0],[[-3,3,-1],1],[[-3,2,-2,0,1],6],[[1,0,1],0],[[2,-3],5],[[5,-15,18,
-13,3],0],[[-1,2],5],[[1,-3,2,-1],5],[[1],4],[[],0],[[-1,1],2],[[1,0,-1],3],
[[],0],[[-1],2],[[1,-2,3,-4,4,-2],0],[[-1,2,-2,1],2],[[1],3],[[-1,1,-1,1,-1],
1],[[-84],30],[[-44,40],0],[[-16,24,-36,8],0],[[-1,0,0,0,-12,6,4,-4,-3,6],0],
[[-14,30,-30,10],0],[[16,-10],15],[[-3],10],[[-2,0,-1],10],[[-4],15],[[-3,0,7,
-5,0,1],4],[[-3,11,-9,1],0],[[-1,0,4,-10,5,-2],0],[[-2,4,-6,8,-4],0],[[1],6],
[[-8,22,-18,6],0],[[-4,9,-15,16,-9,1],0],[[-1,0,2],10],[[-1,0,1,2],0],[[-2,7,
-10,9,-6,1],0],[[1],3],[[-1],2],[[],0],[[1,-1],2],[[],0],[[],0],[[2,-2,2,-1],
1],[[1,-3,2],2],[[-1,3,-5,4,-2,1],0],[[-1],5],[[1],6]],[[[105],0],[[-6,5,0,15,
0,-9,0,-40],5],[[8,0,0,-36,27,0,2],0],[[45,-50,10],0],[[17,-44,36,-8],0],[[40,
-30,5],0],[[-3,0,2,0,6,-8],4],[[11,-26,14,-2],0],[[8,0,-9,6],0],[[11,-22,11,
-1],0],[[1,-1,0,-7,13,-6,-2,-3],0],[[-2,0,2,1],3],[[11,-22,11,-1],0],[[8,-12,
4],0],[[-3,6,0,-2],3],[[8,-9,2],0],[[1,-2,2],2],[[14,-34,23,-4],0],[[-1,0,2],
2],[[-3,3,0,1],3],[[1,-4,5,-1],0],[[-2,2],1],[[1,-3,3],0],[[-2,1],2],[[-1,1],
2],[[-1,1],1],[[2,-10,13,-6],0],[[1,-1,-2,4,-1],0],[[-1],1],[[1,-6,7,-2],0],
[[105],21],[[-70,35],0],[[-28,51,-24,2],0],[[-4,4,0,20,-34,9,4,6],0],[[-28,51,
-24,2],0],[[-1,0,0,0,0,16],7],[[-3],7],[[-2,0,-1],7],[[3,2],11],[[-2,0,0,14,
-12,0,-1],0],[[-20,20,-5],0],[[-4,4,6,-7,2],0],[[-6,18,-17,4],0],[[],0],[[-24,
37,-13,1],0],[[-8,27,-29,11],0],[[-1,0,2],7],[[-4,9,-6],0],[[-6,21,-20,6],0],
[[-2,6,-3],0],[[-2,6,-3],0],[[],0],[[-2,4,-1],0],[[-1],6],[[],0],[[-4,11,-8,
1],0],[[-2,0,4,-3],0],[[-4,14,-11,2],0],[[-1],4],[[],0]],[[[105],0],[[-40,0,
-9,0,15,0,5,-6],18],[[2,0,27,-36,0,0,8],6],[[10,-50,45],0],[[-8,36,-44,17],1],
[[5,-30,40],0],[[-8,6,0,2,0,-3],15],[[-2,14,-26,11],1],[[6,-9,0,8],3],[[-1,11,
-22,11],1],[[-3,-2,-6,13,-7,0,-1,1],7],[[1,2,0,-2],10],[[-1,11,-22,11],1],[[4,
-12,8],2],[[-2,0,6,-3],8],[[2,-9,8],2],[[2,-2,1],8],[[-4,23,-34,14],1],[[2,0,
-1],6],[[1,0,3,-3],8],[[-1,5,-4,1],3],[[2,-2],4],[[3,-3,1],4],[[1,-2],5],[[1,
-1],5],[[1,-1],4],[[-6,13,-10,2],3],[[-1,4,-2,-1,1],4],[[-1],5],[[-2,7,-6,1],
3],[[-105],42],[[-35,70],0],[[-2,24,-51,28],0],[[-6,-4,-9,34,-20,0,-4,4],6],
[[-2,24,-51,28],0],[[-16,0,0,0,0,1],19],[[3],14],[[1,0,2],14],[[-2,-3],21],
[[1,0,12,-14,0,0,2],7],[[5,-20,20],1],[[-2,7,-6,-4,4],3],[[-4,17,-18,6],2],
[[],0],[[-1,13,-37,24],0],[[-11,29,-27,8],2],[[-2,0,1],16],[[6,-9,4],3],[[-6,
20,-21,6],2],[[3,-6,2],3],[[3,-6,2],3],[[],0],[[1,-4,2],3],[[1],11],[[],0],
[[-1,8,-11,4],2],[[3,-4,0,2],4],[[-2,11,-14,4],2],[[1],7],[[],0]],[[[105],0],
[[-30,50,0,0,-10,15],17],[[-20,0,36,-24,0,0,1],6],[[16,-48,41],0],[[4,-13,33,
-39,16],0],[[5,-35,30],0],[[6],14],[[-4,14,-18,11],1],[[8,-12,0,1],3],[[-2,9,
-17,7],1],[[-3,6,-5,-4,8,-5],6],[[-2,-2,2,-1],9],[[-2,10,-15,8],1],[[3,-7,4],
2],[[3,-2,0,4,-1],7],[[1,-6,1],2],[[2],7],[[1,-8,21,-27,13],0],[[2,-1],6],[[1,
-3,0,1],7],[[2,-2,1],4],[[-1,1],5],[[-1],5],[[-1],6],[[],0],[[],0],[[1,-4,8,
-8,3],2],[[-1,3,-2],4],[[],0],[[-1,3,-4,2],3],[[105],39],[[-40,65],0],[[-8,24,
-48,25],0],[[12,-8,-12,32,-16,0,0,1],6],[[-7,27,-45,26],0],[[-16,15,0,0,0,1],
18],[[6],13],[[2,-2,3],13],[[-3],21],[[3,-11,0,11,-6],6],[[5,-19,11],1],[[-4,
8,-8,0,1],3],[[1,-4,12,-13,5],1],[[],0],[[-2,17,-31,20],0],[[-1,3,-13,22,-23,
8],0],[[1,0,1],15],[[3,-4,1],3],[[2,-7,15,-16,7],1],[[1,-3,1],3],[[1,-2,2],3],
[[],0],[[-1],4],[[-1],11],[[],0],[[-1,4,-6,3],2],[[3,-3],4],[[-3,7,-9,5],2],
[[],0],[[],0]],[[[105],0],[[15,-10,0,0,50,-30],8],[[1,0,0,-24,36,0,-20],0],
[[41,-48,16],0],[[16,-39,33,-13,4],0],[[30,-35,5],0],[[6],10],[[11,-18,14,-4],
0],[[1,0,-12,8],0],[[7,-17,9,-2],0],[[-5,8,-4,-5,6,-3],3],[[-1,2,-2,-2],4],
[[8,-15,10,-2],0],[[4,-7,3],0],[[-1,4,0,-2,3],3],[[1,-6,1],0],[[2],5],[[13,
-27,21,-8,1],0],[[-1,2],3],[[1,0,-3,1],4],[[1,-2,2],0],[[1,-1],0],[[-1],1],
[[-1],2],[[],0],[[],0],[[3,-8,8,-4,1],0],[[-2,3,-1],2],[[],0],[[2,-4,3,-1],0],
[[-105],24],[[-65,40],0],[[-25,48,-24,8],0],[[-1,0,0,16,-32,12,8,-12],0],
[[-26,45,-27,7],0],[[-1,0,0,0,-15,16],8],[[-6],8],[[-3,2,-2],8],[[3],12],[[6,
-11,0,11,-3],3],[[-11,19,-5],0],[[-1,0,8,-8,4],0],[[-5,13,-12,4,-1],0],[[],0],
[[-20,31,-17,2],0],[[-8,23,-22,13,-3,1],0],[[-1,0,-1],8],[[-1,4,-3],0],[[-7,
16,-15,7,-2],0],[[-1,3,-1],0],[[-2,2,-1],0],[[],0],[[1],1],[[1],6],[[],0],
[[-3,6,-4,1],0],[[3,-3],2],[[-5,9,-7,3],0],[[],0],[[],0]],[[[105],0],[[10,0,0,
-40,45,0,0,0,0,-10],12],[[1,0,0,0,18,0,-8,0,18,-12],0],[[23,-54,28],0],[[4,
-25,39,-31,6],0],[[15,-35,20],0],[[6],10],[[1,-10,20,-12,4],0],[[1,0,-6,8,-6],
0],[[-9,15,-7,4],1],[[-2,-1,4,0,-4,2],5],[[-2,0,1,0,0,2],6],[[1,-7,14,-11,2],
0],[[-3,6,-4,1],1],[[2,1,0,0,-1],7],[[1,0,4,-3],0],[[2],5],[[3,-14,28,-21,4],
0],[[1,-1,0,-1],4],[[1,-2],5],[[1,-2,1,-1],2],[[-1,1],3],[[1],4],[[-1],4],[[],
0],[[],0],[[-1,4,-8,8,-3],1],[[2,-2,2],3],[[],0],[[1,-4,4,-1],2],[[105],33],
[[-50,55],0],[[-8,45,-36,16],0],[[1,0,0,-6,12,4,-4,-12,10,-8],1],[[-11,36,-45,
13],0],[[5,-16,10,0,0,0,1],15],[[6],11],[[3,-2,2],11],[[-3],17],[[-2,1,4,-2,
-1,4,-1],4],[[-3,12,-15,5],0],[[1,2,-8,8,-2],1],[[4,-11,12,-7,1],1],[[],0],
[[-6,26,-28,10],0],[[-1,9,-19,26,-14,1],0],[[1,0,1],11],[[1,-2,3,-2],1],[[-1,
4,-14,18,-9,1],0],[[-3,1,0,1],2],[[-2,2,-1],2],[[],0],[[1],3],[[-1],9],[[],0],
[[1,-4,6,-3],1],[[1,-2,2,-1],2],[[2,-7,10,-4,1],1],[[],0],[[],0]],[[[105],0],
[[-10,0,0,0,0,45,-40,0,0,10],9],[[-12,18,0,-8,0,18,0,0,0,1],3],[[28,-54,23],
0],[[6,-31,39,-25,4],0],[[20,-35,15],0],[[6],14],[[4,-12,20,-10,1],0],[[-6,8,
-6,0,1],2],[[4,-7,15,-9],0],[[2,-4,0,4,-1,-2],4],[[2,0,0,1,0,-2],5],[[2,-11,
14,-7,1],0],[[1,-4,6,-3],0],[[-1,0,0,1,2],3],[[-3,4,0,1],1],[[2],7],[[4,-21,
28,-14,3],0],[[-1,0,-1,1],3],[[-2,1],8],[[-1,1,-2,1],1],[[1,-1],2],[[1],2],
[[-1],4],[[],0],[[],0],[[-3,8,-8,4,-1],1],[[2,-2,2],3],[[],0],[[-1,4,-4,1],1],
[[-105],30],[[-55,50],0],[[-16,36,-45,8],0],[[8,-10,12,4,-4,-12,6,0,0,-1],3],
[[-13,45,-36,11],0],[[-1,0,0,0,-10,16,-5],10],[[-6],10],[[-2,2,-3],10],[[3],
16],[[1,-4,1,2,-4,-1,2],3],[[-5,15,-12,3],0],[[2,-8,8,-2,-1],2],[[-1,7,-12,11,
-4],0],[[],0],[[-10,28,-26,6],0],[[-1,14,-26,19,-9,1],0],[[-1,0,-1],12],[[2,
-3,2,-1],1],[[-1,9,-18,14,-4,1],0],[[-1,0,-1,3],0],[[1,-2,2],1],[[],0],[[-1],
2],[[1],8],[[],0],[[3,-6,4,-1],1],[[1,-2,2,-1],2],[[-1,4,-10,7,-2],0],[[],0],
[[],0]],[[[120],0],[[45,0,-9,-10,15,0,5,-6],18],[[-12,0,36,-40,0,0,8],6],[[12,
-56,52],0],[[1,-9,39,-51,20],0],[[5,-35,45],0],[[-8,3,0,2,0,-3],15],[[-2,16,
-28,14],1],[[4,-12,0,8],3],[[-1,11,-26,12],1],[[3,-2,-5,16,-8,0,-1,1],7],[[-2,
0,4,0,-2],9],[[-1,12,-24,13],1],[[4,-13,9],2],[[5,-4],10],[[3,-10,8],2],[[-1,
-2,1],8],[[-5,25,-38,17],1],[[-1,-1],7],[[-1,0,2,-3],8],[[-1,5,-5,1],3],[[2,
-2,1],4],[[-1,3,-3,1],3],[[2,-2],5],[[1,-1],5],[[1,-1],4],[[-6,14,-12,3],3],
[[4,-3,-1,1],5],[[1,-1],4],[[-2,7,-7,2],3],[[120],42],[[-40,80],0],[[-4,24,
-60,32],0],[[8,-4,-12,40,-24,0,-4,4],6],[[-3,27,-57,33],0],[[16,-5,0,5,0,-1],
19],[[-6],14],[[-1,4,-3],14],[[],0],[[-5,0,14,-15,0,0,2],7],[[5,-23,22],1],
[[8,-8,-4,4],4],[[-4,18,-21,7],2],[[],0],[[-1,15,-41,28],0],[[1,-11,32,-31,
10],1],[[-3,2,-1],16],[[-1,6,-10,4],2],[[-7,21,-24,8],2],[[3,-7,2],3],[[3,-6,
3],3],[[1],6],[[2,-4,2],3],[[],0],[[],0],[[-1,8,-12,5],2],[[2,-5,0,2],4],[[-2,
12,-15,6],2],[[],0],[[],0]],[[[120],0],[[-6,5,0,15,-10,-9,0,45],5],[[8,0,0,
-40,36,0,-12],0],[[52,-56,12],0],[[20,-51,39,-9,1],0],[[45,-35,5],0],[[-3,0,2,
0,3,-8],4],[[14,-28,16,-2],0],[[8,0,-12,4],0],[[12,-26,11,-1],0],[[1,-1,0,-8,
16,-5,-2,3],0],[[-2,0,4,0,-2],3],[[13,-24,12,-1],0],[[9,-13,4],0],[[-4,5],3],
[[8,-10,3],0],[[1,-2,-1],2],[[17,-38,25,-5],0],[[-1,-1],2],[[-3,2,0,-1],3],
[[1,-5,5,-1],0],[[1,-2,2],0],[[1,-3,3,-1],0],[[-2,2],2],[[-1,1],2],[[-1,1],1],
[[3,-12,14,-6],0],[[1,-1,-3,4],0],[[-1,1],1],[[2,-7,7,-2],0],[[-120],21],
[[-80,40],0],[[-32,60,-24,4],0],[[-4,4,0,24,-40,12,4,-8],0],[[-33,57,-27,3],
0],[[1,0,-5,0,5,-16],7],[[6],7],[[3,-4,1],7],[[],0],[[-2,0,0,15,-14,0,5],0],
[[-22,23,-5],0],[[-4,4,8,-8],0],[[-7,21,-18,4],0],[[],0],[[-28,41,-15,1],0],
[[-10,31,-32,11,-1],0],[[1,-2,3],7],[[-4,10,-6,1],0],[[-8,24,-21,7],0],[[-2,7,
-3],0],[[-3,6,-3],0],[[-1],3],[[-2,4,-2],0],[[],0],[[],0],[[-5,12,-8,1],0],
[[-2,0,5,-2],0],[[-6,15,-12,2],0],[[],0],[[],0]],[[[168],0],[[30,0,5,0,-15,0,
15,0,5],16],[[-20,0,54,-32,0,0,6],6],[[24,-80,64],0],[[2,-24,60,-56,26],0],
[[10,-54,50],0],[[12,-8,0,0,2],14],[[1,-6,23,-34,13],0],[[12,-18,0,6],3],[[-4,
18,-26,12],1],[[5,-10,-6,15,-5,0,0,1],7],[[2,-2,-2,2],8],[[-4,18,-26,12],1],
[[6,-14,6],2],[[-8,0,6],8],[[4,-8,6],2],[[4,0,-2],7],[[1,-13,38,-43,19],0],
[[2,0,-1],6],[[1,-4,1,2,-1],7],[[-2,3,-3,1],3],[[1,-1],4],[[-1,1,-1,1],3],[[2,
-2],5],[[1,-1],5],[[],0],[[3,-10,13,-10,4],2],[[-2,5,-4,0,1],4],[[],0],[[1,-3,
6,-5,2],2],[[168],39],[[-64,104],0],[[-8,48,-72,40],0],[[4,-16,-18,52,-16,0,
-2,4],6],[[-8,48,-72,40],0],[[5,0,5,0,-5,0,1],17],[[6],13],[[1,-6,2],13],[[],
0],[[3,-12,0,17,-9,0,0,1],6],[[10,-30,20],1],[[-4,14,-12,-2,4],3],[[1,-11,21,
-19,8],1],[[-2],9],[[-4,26,-54,30],0],[[5,-25,40,-31,13],1],[[4,-2],15],[[-2,
6,-6,4],2],[[3,-14,27,-24,9],1],[[3,-5,1],3],[[3,-5,1],3],[[],0],[[1,-2,1],3],
[[],0],[[],0],[[-3,9,-10,4],2],[[5,-6,0,1],4],[[1,-5,14,-15,5],1],[[],0],[[1],
8]],[[[168],0],[[5,0,15,0,-15,0,5,0,30],6],[[6,0,0,-32,54,0,-20],0],[[64,-80,
24],0],[[26,-56,60,-24,2],0],[[50,-54,10],0],[[2,0,0,-8,12],6],[[13,-34,23,-6,
1],0],[[6,0,-18,12],0],[[12,-26,18,-4],0],[[1,0,0,-5,15,-6,-10,5],0],[[2,-2,
-2,2],5],[[12,-26,18,-4],0],[[6,-14,6],0],[[6,0,-8],4],[[6,-8,4],0],[[-2,0,4],
3],[[19,-43,38,-13,1],0],[[-1,0,2],2],[[-1,2,1,-4,1],3],[[1,-3,3,-2],0],[[-1,
1],1],[[1,-1,1,-1],0],[[-2,2],2],[[-1,1],2],[[],0],[[4,-10,13,-10,3],0],[[1,0,
-4,5,-2],0],[[],0],[[2,-5,6,-3,1],0],[[-168],24],[[-104,64],0],[[-40,72,-48,
8],0],[[-4,2,0,16,-52,18,16,-4],0],[[-40,72,-48,8],0],[[-1,0,5,0,-5,0,-5],8],
[[-6],8],[[-2,6,-1],8],[[],0],[[-1,0,0,9,-17,0,12,-3],0],[[-20,30,-10],0],
[[-4,2,12,-14,4],0],[[-8,19,-21,11,-1],0],[[2],6],[[-30,54,-26,4],0],[[-13,31,
-40,25,-5],0],[[2,-4],9],[[-4,6,-6,2],0],[[-9,24,-27,14,-3],0],[[-1,5,-3],0],
[[-1,5,-3],0],[[],0],[[-1,2,-1],0],[[],0],[[],0],[[-4,10,-9,3],0],[[-1,0,6,
-5],0],[[-5,15,-14,5,-1],0],[[],0],[[-1],5]],[[[189],0],[[45,-20,45,0,-40,0,
-9],14],[[-12,9,0,6,0,27,-36,0,0,3],3],[[34,-100,55],0],[[3,-36,78,-60,12],0],
[[24,-60,45],0],[[2,0,0,-8,6],12],[[1,-14,37,-30,6],0],[[-3,18,-9,0,3],2],[[1,
-10,28,-24,6],0],[[1,-1,3,1,1,-7,6,-3],4],[[-2,0,1,2],8],[[1,-10,28,-24,6],0],
[[-4,12,-12,3],1],[[-1,0,0,-2,-1,1],5],[[-3,6,-9,3],1],[[-2,0,2],6],[[2,-22,
54,-42,9],0],[[-2,2],5],[[-1,0,0,0,1],6],[[1,-5,5,-1],2],[[-2,2],3],[[-2,2,
-1],3],[[-2,1],4],[[-1,1],4],[[1],4],[[7,-18,17,-5],2],[[1,-5,5],3],[[],0],
[[2,-9,8,-2],2],[[189],35],[[-84,105],0],[[-12,66,-84,27],0],[[4,-8,9,-8,-2,
-18,29,-16,0,-2,1],3],[[-12,66,-84,27],0],[[9],15],[[],0],[[],0],[[6,3],18],
[[-2,0,-1,2,0,9,-7],4],[[-4,20,-30,15],0],[[-11,16,-3,-2,1],3],[[4,-19,29,-15,
2],1],[[-1],7],[[-8,42,-58,21],0],[[9,-39,51,-27,3],1],[[],0],[[1,-4,9,-6,1],
1],[[5,-26,37,-18,2],1],[[-3,6,-3],2],[[-3,6,-3],2],[[],0],[[-1,2,-2],2],
[[-1],10],[[],0],[[1,-8,14,-7,1],1],[[-3,6,-2],3],[[2,-13,21,-10,1],1],[[],0],
[[-1],7]],[[[189],0],[[-9,0,-40,0,45,-20,45],10],[[3,0,0,-36,27,0,6,0,9,-12],
0],[[55,-100,34],0],[[12,-60,78,-36,3],0],[[45,-60,24],0],[[6,-8,0,0,2],8],
[[6,-30,37,-14,1],0],[[3,0,-9,18,-3],0],[[6,-24,28,-10,1],0],[[-3,6,-7,1,1,3,
-1,1],3],[[2,1,0,-2],5],[[6,-24,28,-10,1],0],[[3,-12,12,-4],0],[[1,-1,-2,0,0,
-1],4],[[3,-9,6,-3],0],[[2,0,-2],4],[[9,-42,54,-22,2],0],[[2,-2],4],[[1,0,0,0,
-1],4],[[-1,5,-5,1],1],[[2,-2],2],[[-1,2,-2],1],[[1,-2],3],[[1,-1],3],[[1],2],
[[-5,17,-18,7],1],[[5,-5,1],3],[[],0],[[-2,8,-9,2],1],[[-189],28],[[-105,84],
0],[[-27,84,-66,12],0],[[-1,2,0,16,-29,18,2,8,-9,8,-4],0],[[-27,84,-66,12],0],
[[-9],16],[[],0],[[],0],[[-3,-6],14],[[7,-9,0,-2,1,0,2],3],[[-15,30,-20,4],0],
[[-1,2,3,-16,11],0],[[-2,15,-29,19,-4],0],[[1],8],[[-21,58,-42,8],0],[[-3,27,
-51,39,-9],0],[[],0],[[-1,6,-9,4,-1],0],[[-2,18,-37,26,-5],0],[[3,-6,3],1],
[[3,-6,3],1],[[],0],[[2,-2,1],1],[[1],7],[[],0],[[-1,7,-14,8,-1],0],[[2,-6,3],
2],[[-1,10,-21,13,-2],0],[[],0],[[1],6]],[[[189],0],[[-6,0,0,15,-20,-15,0,5,
-30],5],[[6,0,0,-48,63,0,-24],0],[[76,-88,25],0],[[30,-72,60,-24,3],0],[[60,
-60,9],0],[[2,0,0,-8,6],6],[[19,-38,25,-6],0],[[6,0,-21,12],0],[[16,-31,19,
-3],0],[[1,0,0,-9,18,-9,-8,8],0],[[-2,-1,6,-2,-4],3],[[16,-31,19,-3],0],[[9,
-16,6],0],[[-5,4,0,-5,3],3],[[6,-12,3],0],[[-2,0,2],3],[[24,-52,40,-12,1],0],
[[-2,2],3],[[-1,3,0,-3,1],3],[[2,-5,4,-1],0],[[1,-2,1],0],[[1,-2,2],0],[[-1,
2],2],[[-1,1],2],[[-1],1],[[5,-15,17,-8,2],0],[[1,0,-4,6,-2],0],[[],0],[[3,-8,
7,-3],0],[[189],23],[[-120,69],0],[[-48,84,-48,9],0],[[-4,2,0,32,-52,27,16,
-8],0],[[-48,84,-48,9],0],[[9],11],[[],0],[[],0],[[-3],13],[[-1,0,0,14,-22,0,
13,-3],0],[[-25,35,-9],0],[[-4,2,12,-17,4],0],[[-10,26,-23,9,-1],0],[[-1],7],
[[-38,60,-28,3],0],[[-15,42,-45,21,-6],0],[[],0],[[-4,10,-6,1],0],[[-12,31,
-30,13,-2],0],[[-3,6,-3],0],[[-3,6,-3],0],[[],0],[[-1,3,-1],0],[[1],7],[[],0],
[[-6,13,-10,2],0],[[-1,0,7,-5],0],[[-8,19,-15,5],0],[[],0],[[-1],5]],[[[189],
0],[[-30,5,0,-15,-20,15,0,0,-6],17],[[-24,0,63,-48,0,0,6],6],[[25,-88,76],0],
[[3,-24,60,-72,30],0],[[9,-60,60],0],[[6,-8,0,0,2],14],[[-6,25,-38,19],1],
[[12,-21,0,6],3],[[-3,19,-31,16],1],[[8,-8,-9,18,-9,0,0,1],7],[[-4,-2,6,-1,
-2],9],[[-3,19,-31,16],1],[[6,-16,9],2],[[3,-5,0,4,-5],7],[[3,-12,6],2],[[2,0,
-2],7],[[1,-12,40,-52,24],0],[[2,-2],6],[[1,-3,0,3,-1],7],[[-1,4,-5,2],3],[[1,
-2,1],4],[[2,-2,1],4],[[2,-1],5],[[1,-1],5],[[-1],5],[[2,-8,17,-15,5],2],[[-2,
6,-4,0,1],4],[[],0],[[-3,7,-8,3],3],[[-189],40],[[-69,120],0],[[-9,48,-84,48],
0],[[8,-16,-27,52,-32,0,-2,4],6],[[-9,48,-84,48],0],[[-9],20],[[],0],[[],0],
[[3],20],[[3,-13,0,22,-14,0,0,1],6],[[9,-35,25],1],[[-4,17,-12,-2,4],3],[[1,
-9,23,-26,10],1],[[1],8],[[-3,28,-60,38],0],[[6,-21,45,-42,15],1],[[],0],[[-1,
6,-10,4],2],[[2,-13,30,-31,12],1],[[3,-6,3],3],[[3,-6,3],3],[[],0],[[1,-3,1],
3],[[-1],10],[[],0],[[-2,10,-13,6],2],[[5,-7,0,1],4],[[-5,15,-19,8],2],[[],0],
[[1],8]],[[[189],0],[[5,0,0,-10,-9,0,15,0,0,-40],6],[[6,0,0,-36,54,0,-12,0,9],
0],[[67,-94,28],0],[[21,-69,69,-27,3],0],[[54,-60,15],0],[[2,0,0,-8,6],6],
[[12,-36,31,-8,1],0],[[6,0,-18,12,-3],0],[[9,-33,22,-4,1],0],[[-1,0,-5,13,-8,
-3,4,0,-1],1],[[1,4,-2,-2],4],[[11,-29,23,-6],0],[[6,-15,9,-1],0],[[-1,3,0,-2,
2,1],3],[[6,-9,6],0],[[-2,0,2],3],[[17,-48,47,-16,1],0],[[-1,-1,3,-1],2],[[-1,
2,1,-2],3],[[-3,6,-3],1],[[-1,2,-1],1],[[-2,2,-1],1],[[-1,2],2],[[-1,1],2],
[[1],2],[[2,-10,18,-13,4],0],[[-1,-3,6,-3],1],[[],0],[[1,-5,8,-6,1],0],[[189],
25],[[-114,75],0],[[-36,93,-48,12],0],[[-2,4,0,20,-46,24,8,-4,-6,3],0],[[-39,
84,-57,9],0],[[9],15],[[],0],[[],0],[[-3],13],[[-1,0,0,9,-17,1,6,-2,-1],0],
[[-21,33,-14,1],0],[[-2,4,10,-16,6,-1],0],[[-5,22,-28,12,-2],0],[[-1],5],
[[-30,61,-33,5],0],[[-9,36,-48,30,-6],0],[[],0],[[-2,9,-8,2],0],[[-7,25,-34,
19,-3],0],[[6,-6],1],[[-1,5,-5,1],0],[[],0],[[-1,2,-2],0],[[1],7],[[],0],[[-3,
11,-12,5],0],[[-1,0,6,-5,1],0],[[-4,15,-19,8,-1],0],[[],0],[[-1],5]],[[[189],
0],[[-40,0,0,15,0,-9,-10,0,0,5],15],[[9,0,-12,0,54,-36,0,0,6],4],[[28,-94,67],
0],[[3,-27,69,-69,21],0],[[15,-60,54],0],[[6,-8,0,0,2],14],[[1,-8,31,-36,12],
0],[[-3,12,-18,0,6],2],[[1,-4,22,-33,9],0],[[-1,0,4,-3,-8,13,-5,0,-1],5],[[-2,
-2,4,1],9],[[-6,23,-29,11],1],[[-1,9,-15,6],1],[[1,2,-2,0,3,-1],6],[[6,-9,6],
2],[[2,0,-2],7],[[1,-16,47,-48,17],0],[[-1,3,-1,-1],5],[[-2,1,2,-1],8],[[-3,6,
-3],3],[[-1,2,-1],3],[[-1,2,-2],3],[[2,-1],5],[[1,-1],5],[[1],4],[[4,-13,18,
-10,2],2],[[-3,6,-3,-1],4],[[],0],[[1,-6,8,-5,1],2],[[-189],38],[[-75,114],0],
[[-12,48,-93,36],0],[[-3,6,4,-8,-24,46,-20,0,-4,2],4],[[-9,57,-84,39],0],
[[-9],16],[[],0],[[],0],[[3],20],[[1,2,-6,-1,17,-9,0,0,1],5],[[-1,14,-33,21],
0],[[1,-6,16,-10,-4,2],2],[[2,-12,28,-22,5],1],[[1],10],[[-5,33,-61,30],0],
[[6,-30,48,-36,9],1],[[],0],[[-2,8,-9,2],2],[[3,-19,34,-25,7],1],[[6,-6],3],
[[-1,5,-5,1],2],[[],0],[[2,-2,1],3],[[-1],10],[[],0],[[-5,12,-11,3],2],[[-1,5,
-6,0,1],3],[[1,-8,19,-15,4],1],[[],0],[[1],8]],[[[210],0],[[45,0,15,0,-9,-10,
15,0,0,-6],16],[[9,0,-12,0,54,-56,0,0,7],4],[[28,-104,78],0],[[2,-27,75,-81,
25],0],[[15,-65,65],0],[[-8,9,0,2],15],[[-8,34,-42,16],1],[[-3,12,-18,0,7],2],
[[-5,26,-34,15],1],[[1,4,-2,-10,18,-8,0,-1],6],[[1,-2,-2,4,-1,-2],8],[[-5,25,
-36,14],1],[[-1,10,-18,9],1],[[1,0,-2,0,4,-4],6],[[6,-14,7],2],[[1,-2],8],[[1,
-14,51,-59,20],0],[[3,-1],6],[[3,-1],10],[[-3,7,-5,1],3],[[-1,3,-2],3],[[-1,4,
-3],3],[[-1,2,-1],4],[[1,-1],5],[[1,-1],4],[[2,-14,23,-14,2],2],[[-3,6,-3,-1],
4],[[1],4],[[-6,12,-7,1],3],[[210],39],[[-80,130],0],[[-8,60,-96,46],0],[[9,4,
-8,-24,54,-32,0,-4,3],5],[[-9,57,-99,45],0],[[10,0,5],17],[[3],13],[[-2,2],
14],[[-2],21],[[1,2,-4,-1,19,-16,0,0,1],5],[[-1,14,-38,27],0],[[-7,16,-10,-4,
3],3],[[1,-13,31,-28,7],1],[[],0],[[-4,35,-69,37],0],[[5,-28,57,-45,10],1],
[[-2,1],16],[[-2,10,-12,3],2],[[2,-17,41,-32,8],1],[[-1,6,-6,3],2],[[-1,6,-7,
2],2],[[],0],[[3,-4,1],3],[[],0],[[],0],[[-4,15,-15,4],2],[[-1,5,-6,0,1],3],
[[-8,22,-20,5],2],[[1],7],[[],0]],[[[210],0],[[-6,0,0,15,-10,-9,0,15,0,45],5],
[[7,0,0,-56,54,0,-12,0,9],0],[[78,-104,28],0],[[25,-81,75,-27,2],0],[[65,-65,
15],0],[[2,0,9,-8],6],[[16,-42,34,-8],0],[[7,0,-18,12,-3],0],[[15,-34,26,-5],
0],[[-1,0,-8,18,-10,-2,4,1],1],[[-2,-1,4,-2,-2,1],3],[[14,-36,25,-5],0],[[9,
-18,10,-1],0],[[-4,4,0,-2,0,1],3],[[7,-14,6],0],[[-2,1],3],[[20,-59,51,-14,1],
0],[[-1,3],3],[[-1,3],3],[[1,-5,7,-3],0],[[-2,3,-1],1],[[-3,4,-1],1],[[-1,2,
-1],2],[[-1,1],2],[[-1,1],1],[[2,-14,23,-14,2],0],[[-1,-3,6,-3],1],[[1],2],
[[1,-7,12,-6],0],[[-210],24],[[-130,80],0],[[-46,96,-60,8],0],[[-3,4,0,32,-54,
24,8,-4,-9],0],[[-45,99,-57,9],0],[[-5,0,-10],12],[[-3],8],[[-2,2],8],[[2],
12],[[-1,0,0,16,-19,1,4,-2,-1],0],[[-27,38,-14,1],0],[[-3,4,10,-16,7],0],[[-7,
28,-31,13,-1],0],[[],0],[[-37,69,-35,4],0],[[-10,45,-57,28,-5],0],[[-1,2],8],
[[-3,12,-10,2],0],[[-8,32,-41,17,-2],0],[[-3,6,-6,1],0],[[-2,7,-6,1],0],[[],
0],[[-1,4,-3],0],[[],0],[[],0],[[-4,15,-15,4],0],[[-1,0,6,-5,1],0],[[-5,20,
-22,8],0],[[-1],4],[[],0]],[[[210],0],[[-30,30,-40,30,-30,50],13],[[-4,18,0,
-52,0,36,-12],3],[[50,-100,60],0],[[15,-46,72,-58,19],0],[[25,-75,35],0],
[[-12,0,6],12],[[5,-18,31,-24,9],0],[[-6,24,-12],2],[[3,-11,22,-20,4],0],[[1,
0,-11,19,-13,-1,4,-1],4],[[-2,4,-2,-2],7],[[2,-13,22,-18,5],0],[[-3,8,-6,1],
1],[[-3,8,-5,0,1],6],[[-1,5,-3],1],[[-4,2],6],[[8,-30,47,-37,13],0],[[-1,2],
5],[[-1,5,-3],6],[[-1,1,-1],3],[[],0],[[],0],[[],0],[[],0],[[],0],[[1,-3,7,
-10,10,-6,2],0],[[2,-3,3,-1],3],[[],0],[[-1,2,-3,3,-2,1],1],[[210],33],[[-100,
110],0],[[-28,66,-84,32],0],[[4,-12,6,28,-24,-12,28,-8],3],[[-26,72,-78,34],
0],[[-5,0,-15,0,5],15],[[-6],11],[[-2,6,-1],11],[[6],17],[[-1,0,19,-24,0,5,
-1],4],[[-3,22,-28,7],0],[[4,-14,16,-8],2],[[-2,7,-16,19,-13,3],0],[[],0],
[[-14,47,-53,21],0],[[-5,19,-36,41,-26,8],0],[[2,-4],12],[[1,-2,4,-2],1],[[-3,
12,-23,26,-17,6],0],[[2,-1],3],[[-1,1,-1],2],[[],0],[[],0],[[],0],[[],0],[[2,
-5,6,-4,1],1],[[-3,5,-1],3],[[-1,5,-10,12,-8,3],0],[[],0],[[],0]],[[[210],0],
[[50,-30,30,-40,30,-30],12],[[-12,36,0,-52,0,18,-4],3],[[60,-100,50],0],[[19,
-58,72,-46,15],0],[[35,-75,25],0],[[6,0,-12],10],[[9,-24,31,-18,5],0],[[-12,
24,-6],2],[[4,-20,22,-11,3],0],[[-1,4,-1,-13,19,-11,0,1],3],[[-2,-2,4,-2],6],
[[5,-18,22,-13,2],0],[[1,-6,8,-3],0],[[1,0,-5,8,-3],4],[[-3,5,-1],1],[[2,-4],
5],[[13,-37,47,-30,8],0],[[2,-1],4],[[-3,5,-1],6],[[-1,1,-1],1],[[],0],[[],0],
[[],0],[[],0],[[],0],[[2,-6,10,-10,7,-3,1],0],[[-1,3,-3,2],2],[[],0],[[1,-2,3,
-3,2,-1],0],[[-210],30],[[-110,100],0],[[-32,84,-66,28],0],[[8,-28,12,24,-28,
-6,12,-4],3],[[-34,78,-72,26],0],[[-5,0,15,0,5],12],[[6],10],[[1,-6,2],10],
[[-6],16],[[1,-5,0,24,-19,0,1],3],[[-7,28,-22,3],0],[[8,-16,14,-4],2],[[-3,13,
-19,16,-7,2],0],[[],0],[[-21,53,-47,14],0],[[-8,26,-41,36,-19,5],0],[[4,-2],
12],[[2,-4,2,-1],1],[[-6,17,-26,23,-12,3],0],[[1,-2],1],[[1,-1,1],1],[[],0],
[[],0],[[],0],[[],0],[[-1,4,-6,5,-2],0],[[1,-5,3],2],[[-3,8,-12,10,-5,1],0],
[[],0],[[],0]],[[[216],0],[[-10,0,0,10,-30,0,-24,30],9],[[-24,54,0,-24,0,18],
3],[[68,-104,44],0],[[21,-69,75,-39,12],0],[[45,-75,21],0],[[-3,0,6,0,-3],8],
[[12,-30,32,-16,2],0],[[-18,24,-6],2],[[6,-27,23,-8,2],0],[[-2,9,-5,-6,13,-5,
-1,1],3],[[2,-2,-2,2],5],[[8,-23,24,-10,1],0],[[3,-9,9,-2],0],[[-1,2,-1,-4,5,
-3,-1],3],[[-6,3],1],[[1,2,-3],4],[[16,-45,49,-26,5],0],[[-1,4,-3],3],[[1,0,
-3,3,-1],4],[[-2,3,-1],1],[[-1],1],[[1,-1],3],[[],0],[[],0],[[1],3],[[2,-9,14,
-11,5,-2],0],[[-2,5,-4,2],2],[[-1,1],2],[[1,-4,5,-3,2],0],[[216],28],[[-120,
96],0],[[-36,96,-60,24],0],[[16,-38,24,12,-12,-6,12],3],[[-39,87,-69,21],0],
[[-9],16],[[],0],[[],0],[[],0],[[3,-13,1,15,-10,-1,1],3],[[-12,33,-19,2],0],
[[10,-20,14,-4],2],[[-4,18,-24,14,-5,1],0],[[1],8],[[-27,59,-45,10],0],[[-9,
33,-48,33,-15,3],0],[[],0],[[4,-5],1],[[-7,23,-30,22,-9,1],0],[[3,-3],1],[[-1,
2,-2,1],0],[[-1],4],[[1,-1],2],[[],0],[[],0],[[-2,7,-8,5,-1],0],[[3,-7,3],2],
[[-4,12,-14,10,-3],0],[[],0],[[1],6]],[[[216],0],[[30,-24,0,-30,10,0,0,-10],
14],[[18,0,-24,0,54,-24],4],[[44,-104,68],0],[[12,-39,75,-69,21],0],[[21,-75,
45],0],[[-3,0,6,0,-3],12],[[2,-16,32,-30,12],0],[[-6,24,-18],2],[[2,-8,23,-27,
6],0],[[1,-1,-5,13,-6,-5,9,-2],4],[[2,-2,-2,2],8],[[1,-10,24,-23,8],0],[[-2,9,
-9,3],1],[[-1,-3,5,-4,-1,2,-1],5],[[3,-6],2],[[-3,2,1],6],[[5,-26,49,-45,16],
0],[[-3,4,-1],5],[[-1,3,-3,0,1],6],[[-1,3,-2],3],[[-1],5],[[-1,1],2],[[],0],
[[],0],[[1],3],[[-2,5,-11,14,-9,2],1],[[2,-4,5,-2],3],[[1,-1],3],[[2,-3,5,-4,
1],2],[[-216],35],[[-96,120],0],[[-24,60,-96,36],0],[[-12,6,12,-12,-24,38,
-16],4],[[-21,69,-87,39],0],[[9],15],[[],0],[[],0],[[],0],[[-1,1,10,-15,-1,13,
-3],4],[[-2,19,-33,12],0],[[4,-14,20,-10],2],[[-1,5,-14,24,-18,4],0],[[-1],7],
[[-10,45,-59,27],0],[[-3,15,-33,48,-33,9],0],[[],0],[[5,-4],3],[[-1,9,-22,30,
-23,7],0],[[3,-3],3],[[-1,2,-2,1],2],[[1],5],[[1,-1],2],[[],0],[[],0],[[1,-5,
8,-7,2],1],[[-3,7,-3],3],[[3,-10,14,-12,4],1],[[],0],[[-1],7]],[[[280],0],
[[15,0,-9,0,5,0,45,-96],8],[[4,0,0,-56,54,0,-20,0,18,-8],0],[[88,-144,48],0],
[[24,-90,114,-46,6],0],[[70,-90,30],0],[[9,-8,0,0,9],8],[[13,-46,51,-18,1],0],
[[4,0,-18,20,-6],0],[[12,-36,38,-14],0],[[-4,15,-9,-4,4,-1,-1],3],[[-1,2,0,-2,
1],4],[[11,-38,38,-12,1],0],[[6,-18,16,-4],0],[[4,-1,-2,2,0,-1],4],[[4,-14,10,
-2],0],[[1,0,-3],4],[[17,-67,74,-29,3],0],[[2,-3],4],[[1,0,-1,2,-1],4],[[-3,7,
-6,1],1],[[-1,3,-2],1],[[-1,4,-3],1],[[-1,2,-1],2],[[1],3],[[1,-1],2],[[1,-10,
26,-24,7],0],[[-2,6,-5,1],2],[[1,-1],2],[[-5,13,-10,2],1],[[280],27],[[-160,
120],0],[[-48,120,-96,16],0],[[-2,2,0,24,-62,24,12,-8,-12,14],0],[[-46,126,
-90,18],0],[[1,0,-5,0,15,-16,15],9],[[10],9],[[4,-6,3],9],[[],0],[[12,-15,1,6,
-4,-1,1],3],[[-24,46,-26,4],0],[[-2,2,10,-20,12,-2],0],[[-5,25,-41,25,-4],0],
[[],0],[[-36,86,-58,10],0],[[-8,43,-77,50,-11,1],0],[[1,-2,1,-2],9],[[-2,8,
-14,6],0],[[-5,32,-53,32,-7],0],[[-1,5,-7,4],0],[[-1,5,-8,3],0],[[],0],[[3,-4,
1],1],[[],0],[[1],3],[[-2,13,-19,9,-1],0],[[4,-7,3],2],[[-3,18,-29,16,-2],0],
[[],0],[[],0]],[[[280],0],[[-96,45,0,5,0,-9,0,15],15],[[-8,18,0,-20,0,54,-56,
0,0,4],3],[[48,-144,88],0],[[6,-46,114,-90,24],0],[[30,-90,70],0],[[9,0,0,-8,
9],12],[[1,-18,51,-46,13],0],[[-6,20,-18,0,4],2],[[-14,38,-36,12],1],[[-1,-1,
4,-4,-9,15,-4],5],[[1,-2,0,2,-1],8],[[1,-12,38,-38,11],0],[[-4,16,-18,6],1],
[[-1,0,2,-2,-1,4],5],[[-2,10,-14,4],1],[[-3,0,1],6],[[3,-29,74,-67,17],0],
[[-3,2],5],[[-1,2,-1,0,1],6],[[1,-6,7,-3],2],[[-2,3,-1],3],[[-3,4,-1],3],[[-1,
2,-1],4],[[1],5],[[-1,1],3],[[7,-24,26,-10,1],2],[[1,-5,6,-2],3],[[-1,1],3],
[[2,-10,13,-5],2],[[-280],36],[[-120,160],0],[[-16,96,-120,48],0],[[-14,12,8,
-12,-24,62,-24,0,-2,2],4],[[-18,90,-126,46],0],[[-15,16,-15,0,5,0,-1],16],
[[-10],12],[[-3,6,-4],12],[[],0],[[-1,1,4,-6,-1,15,-12],4],[[-4,26,-46,24],0],
[[2,-12,20,-10,-2,2],2],[[4,-25,41,-25,5],1],[[],0],[[-10,58,-86,36],0],[[-1,
11,-50,77,-43,8],0],[[2,-1,2,-1],13],[[-6,14,-8,2],2],[[7,-32,53,-32,5],1],
[[-4,7,-5,1],2],[[-3,8,-5,1],2],[[],0],[[-1,4,-3],2],[[],0],[[-1],4],[[1,-9,
19,-13,2],1],[[-3,7,-4],3],[[2,-16,29,-18,3],1],[[],0],[[],0]],[[[280],0],
[[-24,75,-30,5,0,9,-10,15],15],[[18,0,-28,0,72,-40,0,0,2],4],[[52,-136,92],0],
[[9,-53,99,-87,32],0],[[25,-95,65],0],[[-3,0,6,-8,-3],12],[[2,-18,42,-44,16],
0],[[-6,28,-24,0,2],2],[[-13,33,-30,14],1],[[-1,-4,12,-10,-9,13,-5],5],[[3,-4,
-2,4,-1],8],[[1,-11,32,-34,12],0],[[-2,12,-15,5],1],[[-1,0,5,-5,-1,4,-1],5],
[[5,-10,2],2],[[-3,2,1],6],[[5,-30,65,-63,22],0],[[-3,2,-1],5],[[-1,3,-3,0,1],
6],[[1,-2,3,-3,1],2],[[1,-1],4],[[1,0,-1],3],[[-1,2,-1],4],[[1],5],[[1,-1],3],
[[-1,8,-15,19,-13,3],1],[[1,-6,7,-3],3],[[1,-1],3],[[2,-5,8,-6,1],2],[[280],
36],[[-120,160],0],[[-20,96,-108,56],0],[[-6,12,12,-16,-30,58,-24,0,0,2],4],
[[-23,87,-117,53],0],[[-15,16,-5,0,0,0,-1],16],[[-8],12],[[-2,4,-4],12],[[],
0],[[-1,1,10,-17,-1,19,-7],4],[[-2,23,-45,20],0],[[2,-16,26,-14,0,2],2],[[6,
-21,31,-24,8],1],[[],0],[[-11,55,-81,38],0],[[-2,16,-46,62,-46,13],0],[[-1,2,
-1],14],[[-3,6,-6,2],2],[[-1,9,-28,42,-33,9],0],[[-2,3,-3,2],2],[[-1,4,-4,1],
2],[[],0],[[1,0,-1],2],[[],0],[[1],4],[[1,-6,13,-11,3],1],[[-3,9,-5],3],[[3,
-12,21,-18,5],1],[[],0],[[],0]],[[[280],0],[[15,-10,9,0,5,-30,75,-24],8],[[2,
0,0,-40,72,0,-28,0,18],0],[[92,-136,52],0],[[32,-87,99,-53,9],0],[[65,-95,25],
0],[[-3,-8,6,0,-3],8],[[16,-44,42,-18,2],0],[[2,0,-24,28,-6],0],[[14,-30,33,
-13],0],[[-5,13,-9,-10,12,-4,-1],3],[[-1,4,-2,-4,3],4],[[12,-34,32,-11,1],0],
[[5,-15,12,-2],0],[[-1,4,-1,-5,5,0,-1],3],[[2,-10,5],0],[[1,2,-3],4],[[22,-63,
65,-30,5],0],[[-1,2,-3],3],[[1,0,-3,3,-1],4],[[1,-3,3,-2,1],0],[[-1,1],1],
[[-1,0,1],1],[[-1,2,-1],2],[[1],3],[[-1,1],2],[[3,-13,19,-15,8,-1],0],[[-3,7,
-6,1],2],[[-1,1],2],[[1,-6,8,-5,2],0],[[-280],27],[[-160,120],0],[[-56,108,
-96,20],0],[[-2,0,0,24,-58,30,16,-12,-12,6],0],[[-53,117,-87,23],0],[[1,0,0,0,
5,-16,15],9],[[8],9],[[4,-4,2],9],[[],0],[[7,-19,1,17,-10,-1,1],3],[[-20,45,
-23,2],0],[[-2,0,14,-26,16,-2],0],[[-8,24,-31,21,-6],0],[[],0],[[-38,81,-55,
11],0],[[-13,46,-62,46,-16,2],0],[[1,-2,1],9],[[-2,6,-6,3],0],[[-9,33,-42,28,
-9,1],0],[[-2,3,-3,2],0],[[-1,4,-4,1],0],[[],0],[[1,0,-1],1],[[],0],[[-1],3],
[[-3,11,-13,6,-1],0],[[5,-9,3],2],[[-5,18,-21,12,-3],0],[[],0],[[],0]],
[[[315],0],[[15,-10,-24,0,5,-30,75,-76],8],[[3,0,0,-52,72,0,-58,0,18,-4],0],
[[102,-156,57],0],[[33,-99,117,-57,9],0],[[75,-105,30],0],[[3,-8,6,0,-10],8],
[[17,-50,51,-20,2],0],[[3,0,-24,22,-6],0],[[15,-36,39,-15],0],[[-5,15,-8,-13,
18,-4],3],[[-1,2,-1,-4,7],4],[[13,-40,38,-13,1],0],[[6,-18,15,-3],0],[[-1,4,0,
-8,5],3],[[3,-13,11,-1],0],[[-1,2,2],4],[[23,-72,77,-33,5],0],[[-1,2,-1],3],
[[-2,1,1],6],[[1,-3,5,-4,1],0],[[-1,2,-1],1],[[-1,3,-3],1],[[-1,1,-1],2],[[1,
-1],3],[[1,-1],2],[[3,-13,24,-21,8,-1],0],[[-3,6,-4,1],2],[[1],2],[[1,-6,11,
-8,2],0],[[315],27],[[-180,135],0],[[-60,126,-108,21],0],[[-2,1,0,28,-66,30,
36,-22,-12,10],0],[[-57,135,-99,24],0],[[-1,0,5,0,-15,16,-5],9],[[-9],9],[[-3,
6,-3],9],[[-6,1],14],[[10,-17,1,23,-13,-1],3],[[-24,51,-27,3],0],[[-2,1,14,
-22,14,-2],0],[[-8,27,-39,25,-6],0],[[],0],[[-42,93,-63,12],0],[[-13,50,-76,
53,-16,2],0],[[2,-1,2],10],[[-2,8,-12,6],0],[[-9,36,-52,33,-9,1],0],[[-2,4,-5,
3],0],[[-1,5,-6,2],0],[[],0],[[2,-4,1],1],[[-1],8],[[],0],[[-3,13,-17,8,-1],
0],[[5,-7,2],2],[[-5,20,-27,15,-3],0],[[1],5],[[],0]],[[[315],0],[[-76,75,-30,
5,0,-24,-10,15],15],[[-4,18,0,-58,0,72,-52,0,0,3],3],[[57,-156,102],0],[[9,
-57,117,-99,33],0],[[30,-105,75],0],[[-10,0,6,-8,3],12],[[2,-20,51,-50,17],0],
[[-6,22,-24,0,3],2],[[-15,39,-36,15],1],[[-4,18,-13,-8,15,-5],6],[[7,-4,-1,2,
-1],8],[[1,-13,38,-40,13],0],[[-3,15,-18,6],1],[[5,-8,0,4,-1],7],[[-1,11,-13,
3],1],[[2,2,-1],6],[[5,-33,77,-72,23],0],[[-1,2,-1],5],[[1,1,-2],6],[[1,-4,5,
-3,1],2],[[-1,2,-1],3],[[-3,3,-1],3],[[-1,1,-1],4],[[-1,1],4],[[-1,1],3],[[-1,
8,-21,24,-13,3],1],[[1,-4,6,-3],3],[[1],4],[[2,-8,11,-6,1],2],[[-315],36],
[[-135,180],0],[[-21,108,-126,60],0],[[-10,12,22,-36,-30,66,-28,0,-1,2],4],
[[-24,99,-135,57],0],[[5,-16,15,0,-5,0,1],16],[[9],12],[[3,-6,3],12],[[-1,6],
18],[[1,13,-23,-1,17,-10],5],[[-3,27,-51,24],0],[[2,-14,22,-14,-1,2],2],[[6,
-25,39,-27,8],1],[[],0],[[-12,63,-93,42],0],[[-2,16,-53,76,-50,13],0],[[-2,1,
-2],13],[[-6,12,-8,2],2],[[-1,9,-33,52,-36,9],0],[[-3,5,-4,2],2],[[-2,6,-5,1],
2],[[],0],[[-1,4,-2],2],[[1],9],[[],0],[[1,-8,17,-13,3],1],[[-2,7,-5],3],[[3,
-15,27,-20,5],1],[[-1],6],[[],0]],[[[336],0],[[15,0,15,0,45,-96,45,0,-40],10],
[[2,0,0,-40,54,0,-12,0,36,-24],0],[[88,-176,72],0],[[18,-94,138,-74,12],0],
[[66,-110,50],0],[[-8,0,0,2],9],[[8,-44,64,-32,4],0],[[2,0,-18,28,-12],0],[[6,
-36,48,-22,4],0],[[-1,9,-8,0,5,-1,-6,2],3],[[2,-2,-2,2],5],[[7,-34,48,-24,3],
0],[[3,-15,21,-9,1],0],[[1,-1,1,2,-1,-1,1],4],[[2,-10,12,-6],0],[[-2],6],[[13,
-63,94,-49,7],0],[[3,-3,2],4],[[-1,0,-1],6],[[-1,6,-8,3],1],[[2,-3,1],2],[[2,
-3,1],2],[[2,-2],3],[[1,-1],3],[[-1],3],[[-6,23,-31,16,-2],1],[[-1,6,-8,3],2],
[[],0],[[-2,10,-14,7],1],[[336],30],[[-176,160],0],[[-40,144,-120,32],0],[[2,
0,16,-48,30,0,-12,-24,28,-8],1],[[-42,138,-126,30],0],[[-5,16,-10,0,5],14],
[[-6],10],[[-3,4,-1],10],[[],0],[[5,-12,2,5,-3,-2,6,-1],3],[[-18,48,-40,10],
0],[[2,8,-26,20,-4],1],[[-2,20,-45,37,-11,1],0],[[1],6],[[-30,94,-82,20],0],
[[-5,37,-84,73,-25,2],0],[[-1,2,-3],10],[[6,-12,10,-2],1],[[-3,25,-57,51,-15,
1],0],[[3,-9,5,-1],1],[[3,-8,6,-1],1],[[],0],[[1,-3,2],1],[[],0],[[],0],[[-1,
8,-20,16,-4],0],[[3,-8,6,-1],2],[[-1,13,-31,26,-7],0],[[],0],[[1],6]],[[[336],
0],[[-40,0,45,-96,45,0,15,0,15],12],[[-24,36,0,-12,0,54,-40,0,0,2],3],[[72,
-176,88],0],[[12,-74,138,-94,18],0],[[50,-110,66],0],[[2,0,0,-8],12],[[4,-32,
64,-44,8],0],[[-12,28,-18,0,2],2],[[4,-22,48,-36,6],0],[[2,-6,-1,5,0,-8,9,-1],
4],[[2,-2,-2,2],8],[[3,-24,48,-34,7],0],[[1,-9,21,-15,3],0],[[1,-1,-1,2,1,-1,
1],4],[[-6,12,-10,2],1],[[-2],6],[[7,-49,94,-63,13],0],[[2,-3,3],4],[[-1,0,
-1],6],[[3,-8,6,-1],2],[[1,-3,2],2],[[1,-3,2],2],[[-2,2],4],[[-1,1],4],[[-1],
3],[[-2,16,-31,23,-6],1],[[3,-8,6,-1],3],[[],0],[[7,-14,10,-2],2],[[-336],33],
[[-160,176],0],[[-32,120,-144,40],0],[[8,-28,24,12,0,-30,48,-16,0,-2],3],
[[-30,126,-138,42],0],[[-5,0,10,-16,5],13],[[6],11],[[1,-4,3],11],[[],0],[[1,
-6,2,3,-5,-2,12,-5],3],[[-10,40,-48,18],0],[[4,-20,26,-8,-2],2],[[-1,11,-37,
45,-20,2],0],[[-1],9],[[-20,82,-94,30],0],[[-2,25,-73,84,-37,5],0],[[3,-2,1],
13],[[2,-10,12,-6],1],[[-1,15,-51,57,-25,3],0],[[1,-5,9,-3],1],[[1,-6,8,-3],
1],[[],0],[[-2,3,-1],2],[[],0],[[],0],[[4,-16,20,-8,1],1],[[1,-6,8,-3],2],[[7,
-26,31,-13,1],1],[[],0],[[-1],7]],[[[378],0],[[-15,0,5,-30,75,-80,45,-30],10],
[[3,0,0,-36,72,0,-60,0,27,-12],0],[[110,-188,80],0],[[33,-108,138,-84,15],0],
[[75,-129,45],0],[[-8,12,0,-4],9],[[14,-52,62,-30,6],0],[[3,0,-24,36,-9],0],
[[11,-38,47,-21,3],0],[[-4,8,-7,-15,25,-5,-1,1],3],[[2,-2,-4,4,-2],5],[[11,
-38,47,-21,3],0],[[3,-17,18,-6],0],[[1,0,-8,10],4],[[3,-9,12,-3],0],[[4,-4],
5],[[22,-74,93,-51,9],0],[[2,-2],4],[[1,-5,5,-1],5],[[-2,4,-4,2],1],[[1,-1],
2],[[-1,1,-1,1],1],[[2,-2],3],[[1,-1],3],[[],0],[[2,-12,22,-24,15,-4],0],[[-2,
7,-8,2],2],[[],0],[[1,-4,9,-9,5,-1],0],[[378],29],[[-204,174],0],[[-60,150,
-132,36],0],[[-2,1,0,20,-52,36,36,-24,-18,13,-8],0],[[-60,150,-132,36],0],
[[-9],13],[[],0],[[],0],[[6],15],[[5,-14,0,27,-18,0,2],3],[[-20,55,-39,6],0],
[[-2,1,12,-32,22,-3],0],[[-6,26,-41,34,-12,1],0],[[-2],7],[[-40,105,-83,21],
0],[[-12,51,-81,72,-30,3],0],[[],0],[[-2,6,-10,7,-2],0],[[-8,34,-56,46,-18,2],
0],[[3,-6,3],1],[[3,-6,3],1],[[],0],[[1,-2,1],1],[[],0],[[],0],[[-2,10,-17,12,
-3],0],[[4,-10,5],2],[[-4,17,-29,21,-7,1],0],[[],0],[[1],6]],[[[378],0],[[-30,
45,-80,75,-30,5,0,-15],13],[[-12,27,0,-60,0,72,-36,0,0,3],3],[[80,-188,110],
0],[[15,-84,138,-108,33],0],[[45,-129,75],0],[[-4,0,12,-8],12],[[6,-30,62,-52,
14],0],[[-9,36,-24,0,3],2],[[3,-21,47,-38,11],0],[[1,-1,-5,25,-15,-7,8,-4],4],
[[-2,4,-4,-2,2],7],[[3,-21,47,-38,11],0],[[-6,18,-17,3],1],[[10,-8,0,1],7],
[[-3,12,-9,3],1],[[-4,4],6],[[9,-51,93,-74,22],0],[[-2,2],5],[[-1,5,-5,1],6],
[[2,-4,4,-2],2],[[-1,1],3],[[1,-1,1,-1],2],[[-2,2],4],[[-1,1],4],[[],0],[[-4,
15,-24,22,-12,2],1],[[2,-8,7,-2],3],[[],0],[[-1,5,-9,9,-4,1],1],[[-378],34],
[[-174,204],0],[[-36,132,-150,60],0],[[8,-13,18,24,-36,-36,52,-20,0,-1,2],3],
[[-36,132,-150,60],0],[[9],18],[[],0],[[],0],[[-6],18],[[-2,0,18,-27,0,14,-5],
4],[[-6,39,-55,20],0],[[3,-22,32,-12,-1,2],2],[[-1,12,-34,41,-26,6],0],[[2],
8],[[-21,83,-105,40],0],[[-3,30,-72,81,-51,12],0],[[],0],[[2,-7,10,-6,2],1],
[[-2,18,-46,56,-34,8],0],[[-3,6,-3],2],[[-3,6,-3],2],[[],0],[[-1,2,-1],2],[[],
0],[[],0],[[3,-12,17,-10,2],1],[[-5,10,-4],3],[[-1,7,-21,29,-17,4],0],[[],0],
[[-1],7]],[[[405],0],[[75,-76,45,-30,50,0,-9,-10],14],[[-12,27,0,-66,0,81,-60,
0,0,3],3],[[78,-204,123],0],[[15,-75,153,-129,33],0],[[45,-135,90],0],[[-1,0,
6,-8,3],12],[[3,-30,69,-60,18],0],[[-9,30,-27,0,3],2],[[3,-18,51,-51,12],0],
[[-2,-8,20,-11,-10,13,-5],5],[[8,-6,-1,4],8],[[2,-20,52,-47,14],0],[[-6,21,
-21,6],1],[[-3,5,-2,0,1,-1],6],[[-3,15,-15,3],1],[[-1,2,-1],6],[[7,-48,103,
-87,25],0],[[-1,2,-1],5],[[3,-3],7],[[1,-6,8,-3],2],[[-2,2,-1],3],[[1,-3,4,
-1],2],[[-2,3],4],[[-1,1],4],[[-1,1],3],[[-2,12,-29,31,-14,2],1],[[1,-7,8,-2],
3],[[-1,1],3],[[4,-12,13,-6,1],2],[[405],35],[[-180,225],0],[[-36,126,-180,
63],0],[[4,-20,15,36,-30,-42,67,-32,0,-2,1],3],[[-33,135,-171,66],0],[[],0],
[[],0],[[],0],[[-6,3],18],[[-1,1,15,-25,-1,18,-10],4],[[-6,39,-63,27],0],[[4,
-17,32,-13,-2,1],2],[[-1,9,-33,53,-33,6],0],[[],0],[[-18,87,-117,48],0],[[-3,
24,-72,99,-60,12],0],[[],0],[[1,-8,16,-10,1],1],[[-1,14,-48,67,-41,9],0],[[-3,
9,-6],2],[[-4,8,-5,1],2],[[-1],5],[[-2,5,-2],2],[[1],10],[[],0],[[2,-13,22,
-14,3],1],[[-4,9,-5],3],[[5,-23,35,-22,5],1],[[],0],[[],0]],[[[405],0],[[-10,
-9,0,50,-30,45,-76,75],9],[[3,0,0,-60,81,0,-66,0,27,-12],0],[[123,-204,78],0],
[[33,-129,153,-75,15],0],[[90,-135,45],0],[[3,-8,6,0,-1],8],[[18,-60,69,-30,
3],0],[[3,0,-27,30,-9],0],[[12,-51,51,-18,3],0],[[-5,13,-10,-11,20,-8,-2],3],
[[4,-1,-6,8],5],[[14,-47,52,-20,2],0],[[6,-21,21,-6],0],[[-1,1,0,-2,5,-3],3],
[[3,-15,15,-3],0],[[-1,2,-1],4],[[25,-87,103,-48,7],0],[[-1,2,-1],3],[[-3,3],
6],[[-3,8,-6,1],1],[[-1,2,-2],1],[[-1,4,-3,1],1],[[3,-2],3],[[1,-1],3],[[1,
-1],2],[[2,-14,31,-29,12,-2],0],[[-2,8,-7,1],2],[[1,-1],2],[[1,-6,13,-12,4],
0],[[-405],28],[[-225,180],0],[[-63,180,-126,36],0],[[-1,2,0,32,-67,42,30,-36,
-15,20,-4],0],[[-66,171,-135,33],0],[[],0],[[],0],[[],0],[[-3,6],14],[[10,-18,
1,25,-15,-1,1],3],[[-27,63,-39,6],0],[[-1,2,13,-32,17,-4],0],[[-6,33,-53,33,
-9,1],0],[[],0],[[-48,117,-87,18],0],[[-12,60,-99,72,-24,3],0],[[],0],[[-1,10,
-16,8,-1],0],[[-9,41,-67,48,-14,1],0],[[6,-9,3],1],[[-1,5,-8,4],0],[[1],4],
[[2,-5,2],1],[[-1],7],[[],0],[[-3,14,-22,13,-2],0],[[5,-9,4],2],[[-5,22,-35,
23,-5],0],[[],0],[[],0]],[[[420],0],[[45,0,45,-136,75,0,15,0,-24],12],[[-24,
45,0,-52,0,72,-40,0,0,3],3],[[92,-216,112],0],[[16,-96,168,-112,28],0],[[60,
-140,80],0],[[-1,0,6,-8],12],[[7,-38,77,-54,11],0],[[-15,32,-24,0,3],2],[[4,
-29,57,-41,9],0],[[2,-5,-3,16,-11,-8,10,-1],4],[[-1,-2,4,-2,-3],6],[[4,-29,57,
-41,9],0],[[1,-10,24,-18,3],0],[[-1,1,4,-8,-1,1],5],[[-6,17,-10,3],1],[[-1,2],
6],[[10,-62,112,-78,18],0],[[-4,3],5],[[2,-2,1],7],[[4,-8,6,-1],2],[[1,-3,2],
2],[[1,-4,3],2],[[1,-2,1],3],[[-1,1],4],[[-1,1],3],[[-4,20,-35,26,-8,1],1],
[[4,-8,6,-2],3],[[-1],3],[[-1,8,-15,11,-3],1],[[420],33],[[-200,220],0],[[-40,
156,-168,56],0],[[8,-34,27,16,-36,-36,60,-16,0,-2,1],3],[[-40,156,-168,56],0],
[[5,0,0,0,-5],13],[[-3],11],[[4,-1],12],[[-4],18],[[1,-5,2,14,-18,-2,13,-5],
3],[[-11,49,-59,21],0],[[6,-25,28,-12,-2,1],2],[[-1,15,-45,51,-24,4],0],[[],
0],[[-26,100,-116,38],0],[[-3,34,-89,99,-46,9],0],[[-1,2],13],[[2,-12,15,-6,
1],1],[[-2,21,-60,67,-32,5],0],[[1,-6,9,-3],1],[[1,-6,9,-3],1],[[],0],[[-3,4,
-1],2],[[],0],[[],0],[[5,-18,22,-10,1],1],[[1,-6,9,-4],2],[[-1,9,-30,36,-16,
2],0],[[-1],6],[[],0]],[[[420],0],[[-24,0,15,0,75,-136,45,0,45],10],[[3,0,0,
-40,72,0,-52,0,45,-24],0],[[112,-216,92],0],[[28,-112,168,-96,16],0],[[80,
-140,60],0],[[-8,6,0,-1],9],[[11,-54,77,-38,7],0],[[3,0,-24,32,-15],0],[[9,
-41,57,-29,4],0],[[-1,10,-8,-11,16,-3,-5,2],3],[[-3,-2,4,-2,-1],6],[[9,-41,57,
-29,4],0],[[3,-18,24,-10,1],0],[[1,-1,-8,4,1,-1],4],[[3,-10,17,-6],0],[[2,-1],
5],[[18,-78,112,-62,10],0],[[3,-4],4],[[1,-2,2],5],[[-1,6,-8,4],1],[[2,-3,1],
2],[[3,-4,1],2],[[1,-2,1],3],[[1,-1],3],[[1,-1],2],[[1,-8,26,-35,20,-4],0],
[[-2,6,-8,4],2],[[-1],3],[[-3,11,-15,8,-1],1],[[-420],30],[[-220,200],0],
[[-56,168,-156,40],0],[[-1,2,0,16,-60,36,36,-16,-27,34,-8],0],[[-56,168,-156,
40],0],[[5,0,0,0,-5],14],[[3],10],[[1,-4],10],[[4],15],[[5,-13,2,18,-14,-2,5,
-1],3],[[-21,59,-49,11],0],[[-1,2,12,-28,25,-6],0],[[-4,24,-51,45,-15,1],0],
[[],0],[[-38,116,-100,26],0],[[-9,46,-99,89,-34,3],0],[[-2,1],11],[[-1,6,-15,
12,-2],0],[[-5,32,-67,60,-21,2],0],[[3,-9,6,-1],1],[[3,-9,6,-1],1],[[],0],[[1,
-4,3],1],[[],0],[[],0],[[-1,10,-22,18,-5],0],[[4,-9,6,-1],2],[[-2,16,-36,30,
-9,1],0],[[1],5],[[],0]],[[[512],0],[[5,-30,75,-100,75,-30,5],12],[[-32,72,0,
-80,0,72,-32],3],[[128,-256,128],0],[[32,-128,192,-128,32],0],[[80,-176,80],
0],[[6,0,-4,0,6],10],[[12,-56,84,-56,12],0],[[-24,48,-24],2],[[8,-40,64,-40,
8],0],[[-1,6,-6,-14,30,-14,-6,6,-1],3],[[-1,-4,10,-4,-1],6],[[8,-40,64,-40,8],
0],[[2,-14,26,-14,2],0],[[1,-1,-5,10,-5,-1,1],4],[[-8,16,-8],1],[[2,-4,2],5],
[[20,-84,128,-84,20],0],[[2,-4,2],4],[[-3,6,-3],6],[[-1,4,-6,4,-1],1],[[1,-1,
1],2],[[1,-2,1],2],[[1,-2,1],3],[[-1],4],[[],0],[[1,-9,25,-34,25,-9,1],0],
[[-1,6,-10,6,-1],2],[[],0],[[-3,9,-13,9,-3],1],[[512],63/2],[[-256,256],0],
[[-64,192,-192,64],0],[[16,-52,36,40,-40,-36,52,-16],3],[[-64,192,-192,64],0],
[[-5,0,5,-16,5,0,-5],25/2],[[8],21/2],[[2,-8,2],21/2],[[],0],
[[2,-10,2,30,-30,-2,10,-2],3],[[-16,64,-64,16],0],[[12,-36,36,-12],2],
[[-4,24,-52,52,-24,4],0],[[2],15/2],[[-40,128,-128,40],0],
[[-10,52,-106,106,-52,10],0],[[-2,4,-2],23/2],[[4,-12,12,-4],1],
[[-6,34,-70,70,-34,6],0],[[2,-6,6,-2],1],[[2,-6,6,-2],1],[[1],9/2],
[[-2,2],2],[[],0],[[-1],7/2],[[-1,8,-20,20,-8,1],0],[[2,-10,10,-2],2],
[[-2,16,-34,34,-16,2],0],[[],0],[[-1],13/2]],[[[512],0],[[5,-30,75,-100,75,
-30,5],12],[[-32,72,0,-80,0,72,-32],3],[[128,-256,128],0],[[32,-128,192,-128,
32],0],[[80,-176,80],0],[[6,0,-4,0,6],10],[[12,-56,84,-56,12],0],[[-24,48,
-24],2],[[8,-40,64,-40,8],0],[[-1,6,-6,-14,30,-14,-6,6,-1],3],[[-1,-4,10,-4,
-1],6],[[8,-40,64,-40,8],0],[[2,-14,26,-14,2],0],[[1,-1,-5,10,-5,-1,1],4],
[[-8,16,-8],1],[[2,-4,2],5],[[20,-84,128,-84,20],0],[[2,-4,2],4],[[-3,6,-3],
6],[[-1,4,-6,4,-1],1],[[1,-1,1],2],[[1,-2,1],2],[[1,-2,1],3],[[-1],4],[[],0],
[[1,-9,25,-34,25,-9,1],0],[[-1,6,-10,6,-1],2],[[],0],[[-3,9,-13,9,-3],1],
[[-512],63/2],[[-256,256],0],[[-64,192,-192,64],0],
[[16,-52,36,40,-40,-36,52,-16],3],[[-64,192,-192,64],0],
[[5,0,-5,16,-5,0,5],25/2],[[-8],21/2],[[-2,8,-2],21/2],[[],0],
[[2,-10,2,30,-30,-2,10,-2],3],[[-16,64,-64,16],0],[[12,-36,36,-12],2],
[[-4,24,-52,52,-24,4],0],[[-2],15/2],[[-40,128,-128,40],0],
[[-10,52,-106,106,-52,10],0],[[2,-4,2],23/2],[[4,-12,12,-4],1],
[[-6,34,-70,70,-34,6],0],[[2,-6,6,-2],1],[[2,-6,6,-2],1],[[-1],9/2],
[[-2,2],2],[[],0],[[1],7/2],[[-1,8,-20,20,-8,1],0],[[2,-10,10,-2],2],
[[-2,16,-34,34,-16,2],0],[[],0],[[1],13/2]]]);

CHEVIE.AddData("longestperm","E7",
  (  1, 64)(  2, 65)(  3, 66)(  4, 67)(  5, 68)(  6, 69)(  7, 70)(  8, 71)
  (  9, 72)( 10, 73)( 11, 74)( 12, 75)( 13, 76)( 14, 77)( 15, 78)( 16, 79)
  ( 17, 80)( 18, 81)( 19, 82)( 20, 83)( 21, 84)( 22, 85)( 23, 86)( 24, 87)
  ( 25, 88)( 26, 89)( 27, 90)( 28, 91)( 29, 92)( 30, 93)( 31, 94)( 32, 95)
  ( 33, 96)( 34, 97)( 35, 98)( 36, 99)( 37,100)( 38,101)( 39,102)( 40,103)
  ( 41,104)( 42,105)( 43,106)( 44,107)( 45,108)( 46,109)( 47,110)( 48,111)
  ( 49,112)( 50,113)( 51,114)( 52,115)( 53,116)( 54,117)( 55,118)( 56,119)
  ( 57,120)( 58,121)( 59,122)( 60,123)( 61,124)( 62,125)( 63,126));

CHEVIE.AddData("CycPolSchurElements","E7",
  [ [1,0,2,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,7,8,9,10,12,14,18],
  [1,-63,2,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,7,8,9,10,12,14,18],
  [1,-46,2,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,8,9,10,18],
  [1,-1,2,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,8,9,10,18],
  [2,-25,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6,7],
  [2,-4,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6,7],
  [2,-3,2,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,18],
  [2,-30,2,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,18],
  [1,-36,2,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,8,10,12],
  [1,-3,2,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,8,10,12],
  [1,-2,2,2,2,2,2,2,2,3,4,4,5,6,7,8,10,14],
  [1,-37,2,2,2,2,2,2,2,3,4,4,5,6,7,8,10,14],
  [6,-16,2,2,2,2,2,2,2,3,3,3,4,4,18], [6,-7,2,2,2,2,2,2,2,3,3,3,4,4,18],
  [2,-3,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6,9,10],
  [2,-30,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6,9,10],
  [2,-30,2,2,2,3,3,3,4,4,5,6,8,9,12], [2,-3,2,2,2,3,3,3,4,4,5,6,8,9,12],
  [3,-16,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6],
  [3,-7,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6],
  [2,-10,2,2,2,2,2,2,2,3,3,3,5,6,6,6], [2,-13,2,2,2,2,2,2,2,3,3,3,5,6,6,6]
    , [2,-25,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6,14],
  [2,-4,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6,14],
  [1,-6,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6,8],
  [1,-21,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6,8],
  [1,-12,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6,8],
  [1,-15,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6,8], [2,-4,2,2,2,3,3,3,4,4,6,7,8,12]
    , [2,-25,2,2,2,3,3,3,4,4,6,7,8,12],
  [1,-6,2,2,2,2,2,2,2,3,3,3,5,6,6,6,10],
  [1,-21,2,2,2,2,2,2,2,3,3,3,5,6,6,6,10], [2,-8,2,2,2,2,2,2,2,3,4,4,5,14],
  [2,-15,2,2,2,2,2,2,2,3,4,4,5,14], [1,-22,2,2,2,2,2,2,2,3,4,4,5,6,8,10],
  [1,-5,2,2,2,2,2,2,2,3,4,4,5,6,8,10],
  [1,-20,2,2,2,2,2,2,2,3,4,4,5,6,8,10],
  [1,-7,2,2,2,2,2,2,2,3,4,4,5,6,8,10],
  [1,-6,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6,12],
  [1,-21,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6,12],
  [1,-10,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6],
  [1,-13,2,2,2,2,2,2,2,3,3,3,4,4,6,6,6], [2,-15,2,2,2,3,4,4,5,7,8],
  [2,-8,2,2,2,3,4,4,5,7,8], [3,-16,2,2,2,2,2,2,2,3,3,3,6,6,6,12],
  [3,-7,2,2,2,2,2,2,2,3,3,3,6,6,6,12], [2,-7,2,2,2,3,3,3,4,4,8,9],
  [2,-16,2,2,2,3,3,3,4,4,8,9], [6,-16,2,2,2,2,2,2,2,4,4,6,6,6,9],
  [6,-7,2,2,2,2,2,2,2,4,4,6,6,6,9], [2,-13,2,2,2,3,3,3,4,4,5,6,12],
  [2,-10,2,2,2,3,3,3,4,4,5,6,12], [1,-14,2,2,2,2,2,2,2,3,4,4,5,6,10],
  [1,-9,2,2,2,2,2,2,2,3,4,4,5,6,10], [2,-8,2,2,2,2,2,2,2,4,4,6,7,10],
  [2,-15,2,2,2,2,2,2,2,4,4,6,7,10], [2,-10,2,2,2,2,2,2,2,3,3,3,6,6,6,10],
  [2,-13,2,2,2,2,2,2,2,3,3,3,6,6,6,10], [2,-11,3,3,3,5,7,9],
  [2,-11,3,3,3,5,7,9] ]);

CHEVIE.AddData("cycpolfakedegrees","E7",
[[1,0],[1,63],[1,46,7,12,14],[1,1,7,12,14],[1,28,5,9,10,18,20],[1,7,5,9,10,18,
20],[1,6,7,9,14,18],[1,33,7,9,14,18],[1,36,7,9,14,18],[1,3,7,9,14,18],[1,2,3,
3,6,6,9,12,18],[1,37,3,3,6,6,9,12,18],[1,22,5,7,10,14,20],[1,13,5,7,10,14,20],
[1,4,5,7,10,14,20],[1,31,5,7,10,14,20],[1,30,4,7,8,12,14,16],[1,3,4,7,8,12,14,
16],[[1,-1,-1,3,-1,-1,1],18,5,7,8,10,14],[[1,-1,-1,3,-1,-1,1],9,5,7,8,10,14],
[1,12,7,8,9,14,16,18],[1,15,7,8,9,14,16,18],[1,26,5,7,9,10,14,18],[1,5,5,7,9,
10,14,18],[1,6,5,7,9,10,12,14,18],[1,21,5,7,9,10,12,14,18],[1,12,5,7,9,10,12,
14,18],[1,15,5,7,9,10,12,14,18],[1,4,4,5,8,8,9,10,12,18],[1,25,4,5,8,8,9,10,
12,18],[1,6,4,4,7,8,9,12,14,18],[1,21,4,4,7,8,9,12,14,18],[1,10,3,3,6,6,7,9,
12,14,18],[1,17,3,3,6,6,7,9,12,14,18],[1,22,3,3,6,6,7,9,12,14,18],[1,5,3,3,6,
6,7,9,12,14,18],[1,20,3,3,6,6,7,9,12,14,18],[1,7,3,3,6,6,7,9,12,14,18],[1,6,5,
7,8,9,10,14,18],[1,21,5,7,8,9,10,14,18],[1,10,5,7,8,9,10,12,14,18],[1,13,5,7,
8,9,10,12,14,18],[1,16,3,3,4,6,6,8,9,12,16,18],[1,9,3,3,4,6,6,8,9,12,16,18],
[[2,-3,2],18,4,4,5,7,8,10,12,14],[[2,-3,2],9,4,4,5,7,8,10,12,14],[[1,1,-2,1,
1],8,4,5,7,8,10,12,14],[[1,1,-2,1,1],17,4,5,7,8,10,12,14],[[1,-1,3,-1,1],16,5,
7,9,10,14,18],[[1,-1,3,-1,1],7,5,7,9,10,14,18],[1,14,4,4,4,7,8,9,12,14,18],[1,
11,4,4,4,7,8,9,12,14,18],[1,14,3,3,6,6,7,8,9,12,14,18],[1,9,3,3,6,6,7,8,9,12,
14,18],[1,8,3,3,3,5,6,6,6,9,10,12,12,18],[1,15,3,3,3,5,6,6,6,9,10,12,12,18],
[1,10,5,7,8,8,9,10,14,18],[1,13,5,7,8,8,9,10,14,18],[[2,2,3,4,6,6,8,6,7,6,5,3,
4,1,1],12,4,4,8,12],[[1,1,4,3,5,6,7,6,8,6,6,4,3,2,2],11,4,4,8,12]]);

#############################################################################
##
#F  CHEVIE.RawData("ClassParameter","E7")( <w> )   . . . . class parameter of w
##
##  given an element w  of a Coxeter group W of type E_7  as word in  standard
##  generators, returns the classparam of its conjugacy class.
##
CHEVIE.AddData("ClassParameter","E7",function(w)
  local x, exc, str;
  if w=[] then return " ";fi;
  exc:=[ [ 3, 2,,, 19 ], [ 12,, 25 ], [ 60 ] ];
  x:=Product(CHEVIE.RawData("generators","E7"){w});
  str:=CycleStructurePerm(x);
  if str in exc then
    str:=[str,CycleStructurePerm(x*CHEVIE.RawData("longestperm","E7"))];
  fi;
  return CHEVIE.RawData("ClassNames","E7")[Position(CHEVIE.RawData("cyclestructure","E7"),str)];
end);

###########################################################################
##
#F CHEVIE.RawData("HeckeCharTable","E7")( <v> ) character table of the
##                                              Hecke algebra of type E7
##
## Note: the parameter for the Hecke algebra is <v>^2.
##       the character table is obtained by v->1 .
##
CHEVIE.AddData("HeckeCharTable","E7",function(param,sqrtparam)local q,v,tbl;
  q:=-param[1][1]/param[1][2];
  if IsBound(sqrtparam[1]) then v:=sqrtparam[1];
  else v:=GetRoot(q,2,"CharTable(Hecke(E7))");
  fi;
  tbl:=rec(identifier:="H(E7)",
    text := "origin: Meinolf Geck, July 1992",
    cartan:=CHEVIE.RawData("CartanMat","E7"),
    parameter := param, rootparameter:=sqrtparam, size := 2903040,
    powermap:=CHEVIE.RawData("PowerMaps","E7"),
    irreducibles:=List(CHEVIE.RawData("vpolheckeirreducibles","E7"),
      i->List(i,function(j)local res;res:=ValuePol(j[1],q);
        if IsInt(j[2]) then res:=res*q^j[2];else res:=res*v^(2*j[2]);fi;
	return res;end)),
    irredinfo:=List(CHEVIE.RawData("CharInfo","E7")().charparams,x->
      rec(charparam:=x,charname:=CHEVIE.RawData("CharName","E7")(x,rec()))));
  Inherit(tbl,CHEVIE.RawData("ClassInfo","E7"));
  tbl.centralizers := List(tbl.classes,x->tbl.size/x);
  tbl := CHEVIE.compat.MakeCharacterTable(tbl);
  CHEVIE.compat.AdjustHeckeCharTable(tbl,param);
  return tbl;
end);

##  The W-graphs  for E7  were sent in  december 2003  by Bob
##  Howlett (joint work of him with Yunchuan Yin).
#
# see  the comments  before  WGraphToRepresentation for  the format.
#
CHEVIE.AddData("WGraphs","E7",
[[[[]],[]], 1, 4,
[[[1],[2],[3],[4],[5],[6],[7]],[[1,[[1,3],[2,4],[3,4],[4,5],[5,6],[6,7]]]]], 6,
[[[2],[4],[5],[1,5],[3,5],[3,6],[3,7],[4,6],[4,7],[1,2,6],[1,4,6],[1,4,7],[2,
3,6],[1,2,5,7],[2,3,5,7]],[[1,[[1,2,10,15],[2,5,9,11],[3,4,8,15],[4,5,11,14],
[5,6,15],[6,7,11,13],[7,12,15],[8,9,11,13],[9,12,15],[10,11,13,14],[11,12],
[12,14],[13,15],[14,15]]]]],
[[[1,2],[1,3],[1,4],[1,5],[1,6],[1,7],[2,3],[2,4],[2,5],[2,6],[2,7],[3,4],[3,
5],[3,6],[3,7],[4,5],[4,6],[4,7],[5,6],[5,7],[6,7]],[[-1,[[4,5],[13,14,16]]],
[1,[[1,3,7],[2,3],[3,4,12],[4,13],[5,6,14],[6,15],[7,8,12],[8,9],[9,10,16],
[10,11,17],[11,18],[12,13],[14,15,17],[15,18],[16,17],[17,18,19],[18,20],[19,
20],[20,21]]]]], 7, 10,
[[[2],[3],[4],1,[5],1,[6],[7],[1,2],[1,4],[1,5],[1,6],[1,7],[2,3],[2,6],[3,5],
[3,6],[3,7],[4,6],[4,7],[2,5,7]],[[1,[[1,3,9,15],[2,10,14,16],[3,10,16,19],[4,
5,10,14],[5,7,11],[6,16,19,21],[7,8,12],[8,13],[9,10,14],[10,11],[11,12,16],
[12,13,17],[13,18],[15,19,21],[16,17],[17,18,19],[18,20],[19,20],[20,21]]]]],
[[[1],[2],[3],1,[4],2,[5],1,[6],1,[7],[1,2],[1,4],[1,5],[1,6],[1,7],[2,3],[2,
5],[2,6],[2,7],[3,5],[3,6],[3,7],[4,6],[4,7],[5,7]],[[1,[[1,4,16],[2,6,13,20],
[3,14,18,22],[4,7,23],[5,9,14,18],[6,14,22,25],[7,19,25],[8,19,22,25,27],[9,
11,15],[10,25,27],[11,12,16],[12,17],[13,14,18],[14,15],[15,16,22],[16,17,23],
[17,24],[19,20],[20,21,25],[21,26],[22,23],[23,24,25],[24,26],[25,26],[26,
27]]]]], 11, 14,
[[[1,2,3],[1,2,4],[1,2,5],[1,2,6],[1,2,7],[1,3,4],[1,3,5],[1,3,6],[1,3,7],[1,
4,5],[1,4,6],[1,4,7],[1,5,6],[1,5,7],[1,6,7],[2,3,4],[2,3,5],[2,3,6],[2,3,7],
[2,4,5],[2,4,6],[2,4,7],[2,5,6],[2,5,7],[2,6,7],[3,4,5],[3,4,6],[3,4,7],[3,5,
6],[3,5,7],[3,6,7],[4,5,6],[4,5,7],[4,6,7],[5,6,7]],[[-1,[[2,3],[3,17],[4,18],
[5,19],[10,26],[11,13,27],[12,14,28],[21,23],[22,24]]],[1,[[1,2,6],[2,16],[3,
4,10],[4,5,11],[5,12],[6,7],[7,8,10],[8,9,11],[9,12],[10,11],[11,12],[13,14,
29],[14,15,30],[15,31],[16,17],[17,18,20,26],[18,19,21,27],[19,22,28],[20,21],
[21,22],[23,24,32],[24,25,33],[25,34],[26,27],[27,28,29],[28,30],[29,30,32],
[30,31,33],[31,34],[32,33],[33,34],[34,35]]]]],
[[[1],[2],[3],1,[4],2,[5],1,[6],[1,4],[1,5],[1,6],[2,5],[2,6],[2,7],[3,5],[3,
6],1,[3,7],[4,6],1,[4,7],1,[5,7],[1,2,5],[1,2,6],[1,2,7],[1,4,6],[1,4,7],[1,5,
7],[2,3,5],[2,3,6],[2,3,7],[3,5,7]],[[1,[[1,4,11,13],[2,7,16,27,32],[3,11,19,
32],[4,6,18],[5,11,21,32],[6,11,14,22],[7,17,23,29],[8,12,14,22,35],[9,12,21,
25,32],[10,13,21,25],[11,26,29],[12,17,26,29,31],[13,18,29,31],[14,15,26],[15,
16,22,27],[16,23,28],[17,19,32,35],[18,22,35],[19,20,29,33],[20,30,34,35],[21,
24,29,33],[22,23,29],[23,30,35],[24,25,30,34],[25,31],[26,27,32],[27,28,29,
33],[28,30,34],[29,30],[30,31],[31,35],[32,33],[33,34]]]]], 15, 18,
[[[1],[2],[3],1,[4],2,[5],1,[6],[1,2],[1,3],[1,4],1,[1,5],1,[1,6],1,[1,7],[2,
3],[2,4],[2,5],1,[2,6],1,[2,7],1,[3,4],[3,5],1,[3,6],2,[3,7],1,[4,5],[4,6],2,
[4,7],2,[5,6],[5,7],1,[6,7],[1,2,5],[1,2,6],[1,2,7],[1,4,6],[1,4,7],[1,5,7],
[2,3,5],[2,3,6],[2,3,7],[3,5,7]],[[1,[[1,3,12,13,18],[2,7,21,27,48,53],[3,6,
33],[4,12,13,28,32,53],[5,13,21,28,36,38,53],[6,13,23,37],[7,29,42,50],[8,16,
36,38,43,44,53],[9,16,23,37,56],[10,18,38,43,44,46],[11,14,20],[12,14],[13,47,
50],[14,15,28],[15,17,30],[16,29,47,50,52],[17,19,31],[18,33,50,52],[19,35],
[20,21,28],[21,22],[22,25,36],[23,24,47],[24,27,37,48],[25,26,39],[26,40],[27,
42,49],[28,30],[29,32,53,56],[30,31,36],[31,35,39],[32,34,50,54],[33,37,56],
[34,51,55,56],[35,40],[36,39],[37,42,50],[38,41,50,54],[39,40,43],[40,45],[41,
44,51,55],[42,51,56],[43,45],[44,52],[45,46],[47,48,53],[48,49,50,54],[49,51,
55],[50,51],[51,52],[52,56],[53,54],[54,55]]],[2,[[11,47],[15,47],[17,48],[19,
49],[20,53],[22,53],[25,54],[26,55],[30,53],[31,54],[35,55]]]]], 20,
[[[3],[4],1,[5],[1,4],[1,5],[2,5],[2,6],[3,5],1,[3,6],1,[4,5],[4,6],2,[4,7],1,
[1,2,5],1,[1,2,6],1,[1,2,7],[1,3,6],[1,4,5],[1,4,6],3,[1,4,7],1,[1,5,6],[1,5,
7],[2,3,5],1,[2,3,6],2,[2,3,7],1,[2,4,6],[2,4,7],[2,5,7],[3,4,6],1,[3,4,7],1,
[3,5,6],[3,5,7],2,[4,5,7],[1,2,4,6],[1,2,4,7],[1,2,5,6],[1,2,5,7],1,[1,3,5,7],
[1,4,5,7],1,[1,4,6,7],[2,3,5,6],[2,3,5,7],1,[2,3,6,7],[3,4,6,7],[1,2,3,5,6],
[1,2,3,5,7],[1,2,3,6,7],[1,2,4,6,7]],[[1,[[1,5,9,24,34,36,45,46,49,65,68],[2,
17,25,35,44,53],[3,5,13,18,34,41,45],[4,9,13,14,20,32,51,56,59,62,63],[5,19,
25,29,30,53,60,70],[6,10,19,25,29,33,55,58,60,67],[7,13,20,34,41,43,56,62],[8,
15,22,41,43,62,65],[9,25,35,44,50,67],[10,13,34,45,49,51,62],[11,28,38,44,48,
50,66,67,69],[12,24,27,45,49,62,65],[13,16,25,52,60],[14,17,28,38,44,53,66,
70],[15,28,48,52,66],[16,18,26,27,41,45,62],[17,46,54,59,63],[18,30,42,47,52,
60,64,66,70],[19,21,34,56,68],[20,25,35,53,57,67],[21,23,29,37,53,55,67,69,
70],[22,28,38,53,55,57,67,69,70],[23,31,39,54,56,68],[24,29,58,67,69],[25,26,
59],[26,30,44,53,67],[27,55,60,70],[28,32,59,61],[29,31,45,61],[30,46,54,59,
61,68],[31,47,58,60],[32,33,48,55,67],[33,51,56,59,61,68],[34,37,64],[35,36,
63],[36,40,44,53,67],[37,39,41,45,62,65],[38,62,63,65],[39,42,47,64],[40,46,
54,63,65,68],[41,42,53,70],[42,43,54],[43,52,57,64],[44,46],[45,47,66],[46,50,
66],[47,49],[48,51,62],[49,58,60,64],[50,59,63,68],[51,52,64,66],[52,59],[53,
54],[54,57,70],[55,56,62],[56,60,64,70],[57,59,63,68],[58,68],[61,66,69,70],
[62,64,67],[64,65,68],[65,66,69,70],[67,68],[68,69]]]]],
[[[4],[1,4],[1,5],[1,6],[2,5],[3,4],[3,5],1,[3,6],1,[4,5],[4,6],2,[4,7],[1,2,
5],[1,2,6],[1,4,5],[1,4,6],3,[1,4,7],1,[1,5,7],[2,3,5],1,[2,3,6],2,[2,3,7],1,
[2,4,6],[2,4,7],[2,5,6],[2,5,7],[3,4,6],2,[3,4,7],1,[3,5,6],[3,5,7],2,[4,5,7],
1,[1,2,3,5],[1,2,3,6],[1,2,3,7],[1,2,4,5],[1,2,4,6],1,[1,2,4,7],1,[1,2,5,6],1,
[1,2,5,7],2,[1,2,6,7],[1,3,5,6],[1,3,5,7],[1,4,5,6],[1,4,5,7],2,[1,4,6,7],[2,
3,5,6],1,[2,3,5,7],2,[2,3,6,7],[2,4,6,7],[3,4,5,7],[3,4,6,7],[1,2,3,5,6],[1,2,
3,5,7],[1,2,3,6,7],[1,2,4,6,7],[1,3,4,6,7],[1,3,5,6,7],[2,3,4,6,7]],[[1,[[1,6,
13,18,23,26,34,37,46,51,53,76,84],[2,6,19,48,51],[3,7,18,19,25,48,51,56,78],
[4,10,19,21,22,25,56,61,78,80],[5,11,16,33,36,69,73],[6,27,38],[7,11,27,38,44,
69],[8,18,26,37,42,43,63,76,78],[9,22,37,43,70,78,80,84],[10,14,38,39,44,69,
74],[11,13,18,47,51,76],[12,22,46,70,84],[13,15,20,33,38,39,52,64,69],[14,22,
35,47,75],[15,23,34,41,47,54,66,72,75,76,77],[16,18,26,51,53,56,58,60,78],[17,
21,29,53,56,60,61,78,80],[18,20,64,65,67],[19,24,38,49,52],[20,23,37,53,78],
[21,39,62,64,65,68,82],[22,57,67,81],[23,40,55,65,67,79,81,82],[24,25,41,50,
54],[25,44,59,65,67,79],[26,30,69,71,73,79],[27,28,48,51],[28,32,38,49,52,69],
[29,33,39,69,73,74],[30,31,37,53,78,80,84],[31,40,55,73,79],[32,41,50,54,72],
[33,34,53,75],[34,55,73],[35,36,57,69],[36,47,58,72,75],[37,40,82],[38,41],
[39,42,76,77],[40,43,76,84],[41,44],[42,45,62,64,69],[43,67,71,79],[44,47,72,
76],[45,63,66,72,76,77,83],[46,67,71],[47,67],[48,49],[49,50,78],[50,79],[51,
52],[52,54,56],[53,55,81],[54,59],[55,60],[56,59,64,69],[57,58,70,78],[58,67,
71,79,81],[59,61,66,72],[60,65,73,79],[61,68,74],[62,63,78,83],[63,65,79,82],
[64,66],[65,76],[66,68],[68,77,83],[69,72,78],[70,71],[71,84],[72,74,79],[73,
76],[74,75,77,80],[75,81],[77,82],[78,79],[79,80],[80,81,82],[81,84]]]]],21,24,
[[[3],[4],1,[5],[6],[1,2],1,[1,3],[1,4],3,[1,5],2,[1,6],2,[1,7],1,[2,3],2,[2,
4],1,[2,5],2,[2,6],2,[2,7],1,[3,4],2,[3,5],3,[3,6],3,[3,7],2,[4,5],2,[4,6],4,
[4,7],3,[5,6],1,[5,7],2,[6,7],[1,2,3],[1,2,4],[1,2,5],1,[1,2,6],1,[1,2,7],1,
[1,3,5],[1,3,6],[1,3,7],[1,4,5],[1,4,6],1,[1,4,7],1,[1,5,6],[1,5,7],1,[1,6,7],
[2,3,5],1,[2,3,6],1,[2,3,7],1,[2,4,6],[2,4,7],[2,5,6],[2,5,7],1,[2,6,7],[3,4,
6],[3,4,7],[3,5,6],[3,5,7],1,[3,6,7],[4,5,7],[4,6,7]],[[-1,[[1,8,21],[2,34,
67],[6,68],[7,23,69],[11,35],[12,67],[13,37,69],[17,43,70],[18,20,42,71],[19,
72],[21,87],[23,90],[25,67,93],[28,68,95],[30,55,97],[32,95],[33,96],[35,99],
[37,102],[39,42,49,87],[43,45],[45,90],[50,104],[54,59],[59,93],[60,94],[63,
96],[65,97],[68,71,77,87],[94,96],[95,104]]],[1,[[1,12,35,40,75,86,98],[2,24,
36,49,51,77,87],[3,12,25,35,48,50,86,92,98],[4,26,38,49,51,61,62,77,82,87],[5,
30,41,51,61,62,65,82,85],[6,10,22,70],[7,11,66,67,72],[8,11,66,76],[9,15,34,
66,67],[10,36,74,77,79],[11,13,80],[12,69,77,79],[13,17,84],[14,38,69,74,77,
79,82,84],[15,18,39,68],[16,41,79,82,84,85],[17,19],[19,45,84,85],[20,47,73],
[21,34,66,67],[22,24,36,87,88],[23,25,35,86],[24,27,92],[25,28],[26,50,86,92,
94,95],[27,31,49,87],[28,29,48,86],[29,32,53,71,88],[30,92,94,95],[31,33,52,
89,92,94],[32,57,73,90,97],[33,58,91,93],[34,39],[35,37],[36,40,98],[37,43,50,
86],[38,48,86,98,100,102],[40,44,74,77,87],[41,55,98,100,102,103],[42,47,52,
89],[43,54,88],[44,46,75,78,89,98,100],[45,59,102,103],[46,76,81,91,99,101],
[47,58,91],[48,53,77,104],[49,52],[50,54],[51,56,78,89,92,98],[52,58,61],[53,
57,78,98,100],[54,92,94],[55,60,104,105],[56,62,81,91,93,99],[57,81,99,101,
104,105],[58,63],[59,96,104,105],[60,64,100],[61,63,94],[62,83,95,102],[63,
65],[64,96,101,104,105],[67,68],[69,70,86],[70,72,79,88],[71,73,78,89],[72,80,
90],[73,81,91],[74,75],[75,76,79],[76,80],[77,78],[78,81,82],[79,80,98],[80,
84,99],[81,83],[82,83,100],[83,85,101],[84,102],[85,103],[86,88],[87,89],[88,
90,92,98],[89,91],[90,93,99],[92,93],[93,95],[96,97],[97,105],[98,99],[99,
102],[100,101],[101,103],[102,104],[103,105]]]]],
[[[2],[3],[4],2,[5],1,[1,2],[1,4],1,[1,5],2,[1,6],[2,3],[2,4],[2,5],1,[2,6],1,
[2,7],[3,4],[3,5],3,[3,6],3,[3,7],1,[4,5],1,[4,6],4,[4,7],3,[5,6],[5,7],[1,2,
5],1,[1,2,6],2,[1,2,7],[1,3,5],[1,3,6],[1,3,7],[1,4,5],[1,4,6],4,[1,4,7],3,[1,
5,6],[1,5,7],1,[2,3,5],1,[2,3,6],3,[2,3,7],1,[2,4,6],[2,4,7],[2,5,7],[3,4,6],
1,[3,4,7],1,[3,5,6],[3,5,7],2,[3,6,7],[4,5,7],[4,6,7],[1,2,3,6],[1,2,4,6],[1,
2,4,7],[1,2,5,6],[1,2,5,7],2,[1,2,6,7],[1,4,5,7],[1,4,6,7],[2,3,5,6],[2,3,5,
7],2,[2,3,6,7],[1,2,3,5,7]],[[1,[[1,5,8,18,48,72,77,103],[2,9,23,32,53,69,71,
80,81,105],[3,16,22,34,35,41,55,61,68,79,91],[4,9,33,40,69,76,80],[5,10,26,33,
40,58,80],[6,11,13,18,25,36,44,88,103],[7,24,33,37,45,46,65,98,100,102],[8,10,
15,46,50,92,105],[9,47,55,60,61,63,91],[10,22,52,55,60,61],[11,24,46,59,65,98,
105],[12,25,47,52,55,60,66,93],[13,26,58,96],[14,29,48,56,60,66,90,93,97],[15,
16,22,68,72,75],[16,17,76,92],[17,19,34,68,95],[18,33,46,69,76,78,100],[19,21,
38,49,71,76,100],[20,39,49,73,76,78,100,104],[21,42,75,77,95,97,101],[22,23,
80,81],[23,28,52,55,68,84],[24,34,68,79,83,84],[25,33,69,80,86,100],[26,27,52,
103],[27,32,53,58,73,80],[28,31,53,57,71,80,100],[29,39,73,80,86,100,104],[30,
56,70,79,83,84,87,90],[31,54,62,75,82,84,87,101],[32,54,63,82,103],[33,35,55,
88],[34,38,98],[35,43,57,76,80,100],[36,40,58,59,73,76,80],[37,41,56,70,79,89,
91],[38,42,56,79,83],[39,44,56,88,89],[40,61,63,77,82,88,103],[41,81,92,98,
102],[42,81,85,98,99],[43,62,77,82,88,89,101],[44,45,65,100],[45,67,88,89,
101],[46,55,68,91,93,95],[47,50,69,96,105],[48,58,73,96],[49,56,70,90,91,93,
95,97],[50,51,60,72,90,91,93],[51,64,74,92,94,96,105],[52,53,105],[53,54,60,
90],[54,64,105],[55,57,98],[56,65,98,99],[57,62,91,93],[58,63],[59,61,79,90,
91],[60,64,80],[61,81,92,98,105],[62,92,94,98,99],[63,96],[64,66,82],[65,67,
83,93],[66,86,94,96,98,105],[67,85,94,98,99],[68,71,100,102,105],[69,72,103],
[70,100,102,104],[71,75,79,90,91],[72,74,76,80,100],[73,90,103],[74,77,82,101,
103],[75,81,92,102,105],[76,77,91],[77,78,92],[78,88,95,101,103],[79,81],[80,
82],[81,84],[82,86],[83,85,100],[84,98,102,105],[85,87,101],[86,88,101,103],
[87,99,104],[88,98],[89,99,104],[90,105],[91,92],[92,95],[93,94,100],[94,97,
101],[95,98,102,105],[96,103],[97,99,104],[100,101],[101,104],[103,105]]]]],25,
[[[1,3],[1,4],[1,5],[2,4],[2,5],[3,4],[3,5],[3,6],[4,5],[4,6],[4,7],[1,2,5],1,
[1,2,6],1,[1,2,7],[1,3,4],[1,3,5],[1,3,6],1,[1,4,5],[1,4,6],3,[1,4,7],1,[1,5,
6],[1,5,7],[2,3,5],1,[2,3,6],2,[2,3,7],1,[2,4,5],[2,4,6],1,[2,4,7],1,[2,5,6],
[2,5,7],[2,6,7],[3,4,5],[3,4,6],2,[3,4,7],1,[3,5,6],1,[3,5,7],2,[3,6,7],[4,5,
6],1,[4,5,7],1,[4,6,7],1,[5,6,7],[1,2,3,5],[1,2,3,6],[1,2,3,7],[1,2,4,5],[1,2,
4,6],1,[1,2,4,7],1,[1,2,5,6],1,[1,2,5,7],2,[1,2,6,7],[1,3,4,6],[1,3,4,7],[1,3,
5,7],1,[1,4,5,6],[1,4,5,7],2,[1,4,6,7],1,[1,5,6,7],[2,3,4,5],[2,3,4,6],[2,3,4,
7],[2,3,5,6],1,[2,3,5,7],2,[2,3,6,7],1,[3,4,5,7],[3,4,6,7],[3,5,6,7],[1,2,3,5,
6],[1,2,3,5,7],[1,2,3,6,7],[1,2,4,6,7]],[[1,[[1,2,20],[2,6,12,23],[3,7,12,23,
72,81,85],[4,30,41,68],[5,9,13,39,76,92,95],[6,17,31,46],[7,9,18,31,46,53,92],
[8,19,20,25,46,48,53,92,97],[9,10,21,37,85,99],[10,11,22,25,38,39,46,48,58,
92],[11,27,40,41,50,60,85,96,99,100,105],[12,14,31],[13,21,30,68,74,102],[14,
16,23,32,72],[15,24,34,68,72,74,102,104,105],[16,26,35,76],[17,64,78],[18,21,
64,78,80,102],[19,24,78,80,102,104],[20,23,81],[21,22,45,67,83],[22,27,47,68,
69,78,82,102],[23,26,46],[24,28,48,83,87],[25,72,85,105],[26,50,81,85],[27,49,
70,71,79,83,84,87,103],[28,29,51,72,82,102],[29,55,76,83,84,87,88,103],[30,33,
45,95],[31,32,37,64],[32,35,38,46,65,92],[33,36,47,68,102],[34,39,48,92,95,
97],[35,40,50,66,96],[36,49,70,95,97,103],[37,38,67],[38,40,42,69],[39,41,68,
105],[40,43,71],[41,70,95],[42,43,58,73,92],[43,44,60,75,96],[44,61,77,97],
[45,47,89,99],[46,50,78],[47,49,52,90],[48,51,99,100],[49,54,91,99,100],[50,
53,79],[51,55,58,92],[52,54,82,93,102],[53,80,81,85,96,99],[54,56,84,94,103],
[55,60,96,99,100,101],[56,86,98,100,101,104],[57,59,82,93],[58,60,82],[59,62,
84,94],[60,61,84],[61,86,100,101],[62,63,86,98],[63,88],[64,65,67],[65,66,69,
78,102],[66,71,79,103],[67,69,89],[68,70],[69,71,73,90],[70,74,105],[71,75,
91],[72,76,92],[73,75,82,93,102],[74,83,95,103],[75,77,84,94,103],[76,85,96,
105],[77,86,98,104],[78,79],[79,80],[80,83,103],[82,84],[83,99],[84,86],[86,
88],[87,100,104,105],[88,101],[89,90],[90,91,93],[91,94],[92,96,102],[93,94],
[94,98],[95,99],[96,97,103],[97,100,104,105],[102,103],[103,104]]]]],27,
[[[2],[3],[4],2,[5],1,[6],[1,2],1,[1,3],[1,4],3,[1,5],3,[1,6],2,[1,7],1,[2,3],
2,[2,4],1,[2,5],2,[2,6],2,[2,7],1,[3,4],2,[3,5],4,[3,6],4,[3,7],3,[4,5],2,[4,
6],5,[4,7],4,[5,6],1,[5,7],2,[6,7],[1,2,3],[1,2,4],[1,2,5],1,[1,2,6],2,[1,2,
7],1,[1,3,5],[1,3,6],[1,3,7],[1,4,5],[1,4,6],2,[1,4,7],2,[1,5,6],[1,5,7],1,[1,
6,7],[2,3,5],1,[2,3,6],2,[2,3,7],1,[2,4,6],[2,4,7],[2,5,6],[2,5,7],1,[2,6,7],
[3,4,6],[3,4,7],[3,5,6],[3,5,7],1,[3,6,7],[4,5,7],[4,6,7],[1,2,5,7],[2,3,5,
7]],[[1,[[1,5,9,30,80,100,106,120],[2,11,15,27,40,41,85,98,111],[3,28,38,39,
56,62,76,87,99],[4,15,29,40,55,57,98,105,111],[5,13,44,55,67,89,111],[6,31,42,
56,62,69,71,87,94,99],[7,17,31,42,59,70,117,120],[8,33,46,62,69,71,74,94,97],
[9,13,26,78,79],[10,12,25,75,76,77,82],[11,12,75,86],[12,19,40,93],[13,39,84,
87,88],[14,18,38,75,76],[15,76,77,87,88],[16,42,77,84,87,88,94,96],[17,44,89,
119],[18,20,45,78],[19,21,43,77,96],[20,24,49,81],[21,23,47,79],[22,46,88,94,
96,97],[23,52,82,96,97],[24,51,83],[25,29,40,98,104],[26,28,39,99,100],[27,38,
75,76,99],[28,32,105],[29,30,76,106],[30,35,55,78,98,108],[31,57,98,105,107,
108],[32,34,56,99],[33,58,105,107,108,110],[34,36,61,101,105,107],[35,37,63,
81,100],[36,66,103,106,109],[37,64,83,104,108,110],[38,45],[39,41,111],[40,43,
112],[41,48,84,87,99],[42,55,98,111,113,114],[43,47,57,98,114],[44,50,84,120],
[45,49,56,99],[46,58,111,113,114,116],[47,52,60,100],[48,53,85,90,101,111,
113],[49,51,61,101],[50,54,85,89,102,111],[51,66,103],[52,68,104,114,116],[53,
86,92,103,112,115],[54,86,91,112,120],[55,63,87,117],[56,61],[57,60,117],[58,
70,117,118],[59,67,89,102,105,111],[60,68,105,107],[61,66,69],[62,65,90,101,
105,111],[63,64,90,111,113],[64,92,112,115,117,118],[65,71,92,103,106,112],
[66,73],[67,91,106,112,117,120],[68,106,109,117,118],[69,73,107],[70,72,107,
113],[71,95,108,114],[72,109,115,117,118],[73,74,109],[74,110],[76,78],[77,79,
98],[78,81,87,99],[79,82,88,100],[80,89,102,119],[81,83,90,101],[82,93,104],
[83,92,103],[84,85],[85,86,88],[86,93],[87,90],[88,93,111],[89,91],[90,92,94],
[91,119],[92,95],[93,96,112],[94,95,113],[95,97,115],[96,114],[97,116],[98,
100],[99,101],[100,104,105,111],[101,103],[102,120],[104,106,112],[105,106],
[106,108],[107,109],[108,117],[109,110],[110,118],[111,112],[112,114],[113,
115],[114,117],[115,116],[116,118],[119,120]]],[2,[[2,54],[4,67],[15,91],[22,
80],[33,102],[46,102],[77,119],[82,119],[96,119],[98,120],[104,120],[108,120],
[114,120]]]]],29,
[[[3],[4],3,[5],1,[6],[1,2],[1,4],3,[1,5],2,[1,6],2,[1,7],[2,3],2,[2,4],[2,5],
2,[2,6],2,[2,7],[3,4],2,[3,5],5,[3,6],5,[3,7],2,[4,5],2,[4,6],7,[4,7],4,[5,6],
[5,7],1,[1,2,3],[1,2,4],1,[1,2,5],3,[1,2,6],3,[1,2,7],2,[1,3,5],[1,3,6],[1,3,
7],[1,4,5],2,[1,4,6],5,[1,4,7],4,[1,5,6],1,[1,5,7],3,[1,6,7],[2,3,5],3,[2,3,
6],4,[2,3,7],3,[2,4,6],1,[2,4,7],1,[2,5,6],1,[2,5,7],3,[2,6,7],[3,4,6],2,[3,4,
7],2,[3,5,6],1,[3,5,7],4,[3,6,7],[4,5,7],2,[4,6,7],[1,2,3,5],[1,2,3,6],[1,2,3,
7],[1,2,4,6],[1,2,4,7],[1,2,5,6],[1,2,5,7],1,[1,2,6,7],[1,3,5,6],[1,3,5,7],[1,
3,6,7],[1,4,5,7],[1,4,6,7],[2,3,5,6],[2,3,5,7],1,[2,3,6,7],[2,4,6,7],[3,4,6,
7]],[[1,[[1,12,33,37,49,84,109,115,133,149],[2,32,51,64,70,86,110,121,131],[3,
11,24,34,52,57,64,88,108,132,152],[4,33,53,71,87,107],[5,12,50,65,109,120,
133],[6,40,50,53,68,73,87,101,107,163],[7,27,36,40,50,55,66,73,100,126,143,
146,161,163,165],[8,41,53,54,60,68,76,101,106,163,166],[9,13,23,71,73,78,80,
149],[10,14,32,69,70,95],[11,33,71,87,92,149],[12,75,88,93,97,152],[13,34,83,
88,93,98],[14,19,35,72,103],[15,38,75,83,88,93,104,105,154],[16,40,73,87,92,
101,103,149],[17,45,93,105,154,157],[18,41,76,92,101,103,106],[19,20,43,77],
[20,48,80,103,106],[21,32,69,70,110,116],[22,33,71,107,115,149],[23,24,34,108,
111,119],[24,26,71,120,123],[25,50,73,109,120,126,128,163],[26,28,52,74,108,
127],[27,51,110,121,124,127],[28,31,56,79,115,120,163],[29,54,76,120,128,163,
166],[30,58,112,121,124,125,127,130,167],[31,62,81,116,122,127,130,164,167],
[32,35,134],[33,39,132],[34,37,133,135],[35,43,51,110,142],[36,86,110,131,141,
158],[37,42,83,88,108,141],[38,50,109,133,140,143,163],[39,46,87,107,149],[40,
52,108,132,138,142],[41,58,112,132,138,142,144],[42,49,84,89,115,133,163],[43,
48,59,114],[44,90,112,131,137,141,158,160,168],[45,60,133,140,163,166],[46,47,
94,113,132,138,150],[47,99,118,134,139,151],[48,63,119,142,144],[49,85,97,116,
136,141,160,164,168],[50,57,88,145,147],[51,59,146],[52,56,87,146],[53,61,94,
113,132,152],[54,90,137,147,168],[55,64,90,112,121,131,132,152,167,168],[56,
62,94,132,138],[57,65,89,120,133,163],[58,66,146,148],[59,63,121,124],[60,125,
145,167],[61,68,99,118,134,153],[62,99,134,139,146,148],[63,123,129,146,148],
[64,123,134,135,146,153,161,165],[65,97,122,136,145,147,164,167,168],[66,67,
124,125,138],[67,126,129,139,146,148],[68,102,142,145,147,155,164],[69,151],
[70,72,153],[71,74,152],[72,77,86,110,155],[73,88,108,152,154,155],[74,79,87,
107,149],[75,78,109,149,156],[76,90,112,152,154,155,157],[77,80,91,114],[78,
82,93,111,150,152,154,157],[79,81,94,113,150,152,154],[80,98,119,155,157],[81,
99,118,151,153,156],[82,96,117,151,153,156],[83,84,149,159],[84,85,93,150,
160],[85,96,151],[86,91,161],[87,94],[88,89,161],[89,97,152,154],[90,100,161,
162],[91,98,131,158],[92,95,132,150,152],[93,96,133,162],[94,99,101],[95,103,
134,151,153],[96,105,136],[97,153,156,161,162],[98,135,159,161,162],[99,102],
[100,104,137,154,158],[101,102,138,154],[102,106,139,156],[103,142,155],[104,
143,156,159,161,162],[105,140,156],[106,144,157],[107,113],[108,115,149,163,
165],[109,111,164],[110,114,165],[111,117,120,133,163,166],[112,163,165,166],
[113,118,163],[114,119,121,131],[115,116,132,150,152],[116,134,151,153,165],
[117,122,136,164],[118,164],[119,123,135,165,166],[120,122,152,167],[121,123],
[122,128,153],[123,127,167],[124,129],[125,126,163],[126,145,164,167],[127,
146,165],[128,147,155,164],[129,130],[130,148],[131,135],[132,134],[133,136,
168],[134,142],[135,141,168],[136,140],[137,143,163],[138,139,163],[139,144,
164],[140,145,164],[141,159,161,165],[142,146,165],[143,147,164,168],[144,148,
166],[147,161],[148,167],[149,150],[150,151],[152,153],[153,155],[154,156,
163],[155,161,165],[156,157,164],[157,162,166],[158,159],[159,160],[160,162],
[162,168],[163,164],[164,166],[166,167,168]]]]],31,
[[[1,4],1,[1,5],[1,6],[2,3],[2,4],[2,5],[2,6],[3,4],1,[3,5],1,[3,6],1,[3,7],
[4,5],1,[4,6],2,[4,7],1,[5,6],[5,7],[1,2,3],1,[1,2,4],2,[1,2,5],3,[1,2,6],3,
[1,2,7],2,[1,3,4],1,[1,3,5],2,[1,3,6],2,[1,3,7],1,[1,4,5],3,[1,4,6],5,[1,4,7],
4,[1,5,6],2,[1,5,7],3,[1,6,7],1,[2,3,4],1,[2,3,5],4,[2,3,6],4,[2,3,7],3,[2,4,
5],1,[2,4,6],3,[2,4,7],2,[2,5,6],2,[2,5,7],3,[2,6,7],1,[3,4,5],2,[3,4,6],4,[3,
4,7],3,[3,5,6],3,[3,5,7],4,[3,6,7],2,[4,5,6],2,[4,5,7],3,[4,6,7],3,[5,6,7],[1,
2,3,5],1,[1,2,3,6],1,[1,2,3,7],1,[1,2,4,5],[1,2,4,6],1,[1,2,4,7],1,[1,2,5,6],
1,[1,2,5,7],2,[1,2,6,7],1,[1,3,4,6],[1,3,4,7],[1,3,5,6],[1,3,5,7],1,[1,3,6,7],
[1,4,5,6],[1,4,5,7],1,[1,4,6,7],1,[1,5,6,7],[2,3,4,6],[2,3,4,7],[2,3,5,6],1,
[2,3,5,7],2,[2,3,6,7],1,[2,4,5,7],[2,4,6,7],[2,5,6,7],[3,4,5,7],[3,4,6,7],[3,
5,6,7]],[[-1,[[1,59],[3,30,45,52,54,66,145,151],[4,48,66,162],[5,149,176],[6,
176,184],[7,81,102,184],[8,82,102,183,185],[9,164],[10,116],[11,14,167],[12,
80,81,109,111,122],[13,82,122,183],[14,112,115,147,175,177],[15,118,149,176,
181,187,188],[16,134,151],[19,55],[20,23,94,115,134,140],[21,140],[22,61],[23,
169,178,186],[24,137,171,179],[27,155],[30,156,159],[34,148,153],[36,82,152],
[37,148,153,156],[38,150,154],[40,150,154,158],[43,47],[46,148],[47,56],[49,
150],[50,63],[51,55,170],[55,152],[57,67],[59,152,163],[60,115],[61,155],[62,
155,164],[64,71],[66,156],[67,165,169],[68,123],[69,74,158],[70,167],[71,166,
171],[72,128,174],[73,168],[77,180],[80,86],[87,180,182],[93,153],[95,175],
[96,153],[97,154],[98,154],[99,176,184,185],[100,157],[101,157],[103,160],
[104,186],[105,160],[106,180],[110,187],[114,121],[116,175],[117,187,188],
[119,176],[120,127],[125,130],[126,180],[129,131],[130,168],[131,182],[133,
169],[135,169],[136,171],[137,184,187],[138,142],[139,171],[142,185],[143,
144],[144,174],[145,148],[151,153],[155,159],[156,177],[158,181],[159,180],
[160,162],[161,182],[170,187],[171,173],[172,188],[179,183]]],[1,[[1,10,28,29,
41,42,52,54,145,151],[2,9,27,51,53,146,152,163],[3,12,59,67,70,157],[4,13,36,
59,67,70,73,74,157],[5,9,25,27,76,77,80,146],[6,27,76,77,91,95],[7,16,77,91,
95,100,106,178],[8,20,95,100,106,108,178,186],[9,11,42,110,175],[10,75,76,80,
109,111],[11,43,51,80,81,111,146,187],[12,16,116,121,126,178],[13,20,116,121,
126,131,132,178],[14,15,47,48,55,86,124],[15,50,61,90,125,167,168],[16,18,110,
135,137],[17,19,51,81,92,111,184,187],[18,21,95,113,116,153,169,178],[19,22,
94,96,112,115,133,134,175,177],[20,135,137,142,143],[21,99,117,119,137,154,
171,179],[22,97,118,138,139,176,181,184,185,187,188],[23,24,102,123,144],[24,
104,128,140,174],[25,29,42,145],[26,28,41,145,147],[27,31,151],[28,33,75,152],
[29,32,76],[30,51,81,146,152],[31,35,53,77,146,159],[32,34,54,79,145,151],[33,
37,52,78,145,151],[34,38,57,84],[35,39,58,83,147,157],[36,60,156,159,161],[37,
40,56,85,152],[38,64,88],[39,65,87,149,159,160,161],[40,63,89,155],[41,44,
163],[42,43],[43,52,145],[44,46,54,145],[45,53,146,163,165,167],[46,49,57,163,
165],[47,50,148],[48,60,163,165,167,168],[49,64,164,166],[50,150],[51,151],
[52,56,111],[53,58,110,170],[54,57,109],[55,61,153,156,169],[56,63,66,112],
[57,64,114],[58,65,113,163,165,169],[59,62,116,148,153],[60,68,170,172],[61,
154,158,170,171,172],[62,70,119,150,154],[63,69,118],[64,120],[65,117,164,166,
170,171,172],[66,69,122],[67,71,121],[68,72,156,165,169],[69,129],[70,126,159,
160],[71,73,127],[72,158,166,170,171,172],[73,132,173],[74,131,161],[75,78,
175],[76,79],[77,83,110],[78,85,92,111],[79,84,91,109],[80,145,151],[81,175,
177,180],[82,94,115,175,177,180,182],[83,87,95,113,178],[84,88,93,114],[85,89,
96,112,175,177],[86,90,116,148,153,178],[87,99,117,179],[88,98,120],[89,97,
118,176,181],[90,119,150,154,179],[91,93,151],[92,96,151],[93,98,100],[94,102,
184,185],[95,99],[96,97,101],[97,105],[98,103],[99,106],[100,103,135],[101,
105,133,177],[102,104,134,177],[103,108,136],[104,138,181,184,185],[105,107,
139,181],[106,137,179],[107,141,162,182],[108,143,162],[109,114],[110,113],
[111,112],[112,118,122],[113,117,124],[114,120],[115,123,187,188],[116,119],
[117,125],[118,129],[119,126],[121,127,135],[122,129,134,177],[123,128,133,
177],[124,125,165,169,178],[125,166,171,179],[126,137,179],[127,132,136],[128,
139,181,187,188,189],[129,138,181],[130,173,183,188,189],[131,142],[132,143],
[133,139],[134,138],[135,136],[136,143],[139,141],[140,173,183,185,188],[141,
173,188,189],[142,186],[143,173],[146,147],[147,149,152,163],[148,150],[149,
155,164],[152,155,175],[153,154,157],[154,160],[155,176],[156,158],[157,160,
169,178],[158,161],[159,170],[160,171,179],[161,172],[162,173,183],[163,164],
[164,167],[165,166],[166,168],[167,170],[168,172],[169,171],[173,174],[174,
189],[175,176],[176,180],[177,181],[178,179],[180,184,187],[181,182],[182,185,
188]]]]], 33, 36,
[[[2],[3],1,[4],4,[5],2,[6],[1,2],1,[1,3],[1,4],4,[1,5],4,[1,6],2,[1,7],[2,3],
2,[2,4],1,[2,5],3,[2,6],3,[2,7],1,[3,4],2,[3,5],6,[3,6],6,[3,7],3,[4,5],3,[4,
6],8,[4,7],6,[5,6],1,[5,7],2,[1,2,4],[1,2,5],3,[1,2,6],4,[1,2,7],2,[1,3,5],[1,
3,6],1,[1,3,7],[1,4,5],1,[1,4,6],6,[1,4,7],5,[1,5,6],1,[1,5,7],3,[1,6,7],[2,3,
5],3,[2,3,6],5,[2,3,7],3,[2,4,6],1,[2,4,7],1,[2,5,6],[2,5,7],2,[2,6,7],[3,4,
6],2,[3,4,7],2,[3,5,6],1,[3,5,7],4,[3,6,7],1,[4,5,7],1,[4,6,7],1,[1,2,3,5],[1,
2,3,6],[1,2,3,7],[1,2,4,6],[1,2,4,7],[1,2,5,6],[1,2,5,7],2,[1,2,6,7],[1,3,5,
7],[1,4,5,7],[1,4,6,7],[2,3,5,6],[2,3,5,7],2,[2,3,6,7]],[[1,[[1,8,14,33,37,40,
97,132,139,142,147,175,179,187],[2,17,47,52,62,106,133,135,153,172],[3,15,18,
45,56,105,130,140,155,164],[4,18,34,45,66,68,75,79,130,145,155],[5,19,33,46,
67,75,79,109,132,154,175],[6,47,78,91,108,131],[7,17,69,80,133,144,153],[8,20,
53,69,71,80,115,153,156,183],[9,24,37,50,73,86,169,187],[10,54,69,78,90,95,
108,123,131,185],[11,38,49,54,69,74,87,89,95,124,168,183,185,186],[12,55,72,
78,90,98,123,129,185,189],[13,16,30,94,99,174,176],[14,20,32,91,95,99,103,
172],[15,16,106,174],[16,22,45,114,118],[17,93,109,114,119,175],[18,94,113,
116,176,183],[19,47,91,108,112,172],[20,46,104,109,114,120],[21,54,95,108,112,
123,127,172],[22,27,48,94,127],[23,49,94,116,124,182,183],[24,53,95,115,124,
180,183],[25,50,93,104,109,114,128,177],[26,55,98,112,123,127,129],[27,29,60,
96,114,177],[28,59,97,105,111,114,128,177,181],[29,65,103,121,127,129,178],
[30,34,45,130,139,140],[31,47,91,131,135,172],[32,33,46,132,139,142],[33,36,
91,144,146],[34,35,144,176],[35,40,66,130,179],[36,42,67,92,132,149],[37,69,
95,133,144,150,185],[38,68,130,145,148,149],[39,70,138,145,148,149,152],[40,
43,71,98,137,144,185],[41,72,98,134,144,150,185,189],[42,44,77,100,135,144,
185],[43,84,142,147,179,181,188],[44,81,102,140,147,149,152,188],[45,48,153,
158],[46,52,153,156],[47,51,154],[48,60,68,130,161],[49,66,130,155,160,164],
[50,69,133,153,162,185],[51,58,108,131,172],[52,56,104,109,132,164],[53,61,
104,132,160,164,187],[54,67,132,154,159,161],[55,70,138,154,159,161,166],[56,
64,106,113,135,153,185],[57,105,111,138,155,160,164,167],[58,63,110,136,154,
159,173],[59,72,134,153,162,185,189],[60,65,76,137,153,185],[61,62,106,115,
134,135,153],[62,107,119,140,157,164,187],[63,117,143,158,163,174],[64,107,
122,140,157,164,167,188],[65,85,142,157,161,166,188],[66,71,183],[67,77,108,
168],[68,76,168],[69,75,109,169],[70,87,168,171],[71,84,111,155,160],[72,86,
111,169,170],[73,80,115,134,144,153],[74,79,111,138,145,154,155,170,175],[75,
82,113,144,153,185],[76,85,145,148],[77,81,110,154,159],[78,83,110,136,154,
175],[79,146,156,158,168,176,183,186],[80,119,147,157,169,187],[81,117,158,
163,168,171],[82,122,147,157,169,170,188],[83,90,117,143,158,176],[84,156,165,
183,184],[85,146,151,168,171],[86,89,124,185],[87,88,148,159],[88,151,163,168,
171],[89,126,169,170,188],[90,125,161,169,179,188],[91,92,175],[92,100,108,
131,172],[93,99,133,172,180],[94,96,130,177,179],[95,109,132,175,177,179],[96,
103,116,137],[97,115,134,180],[98,111,138,175,177,179,181],[99,101,114,139,
173,175,177],[100,102,110,136,173,175,177],[101,121,141,174,176,178,180],[102,
117,143,174,176,178],[103,120,142,179],[104,106,172,182],[105,116,182],[106,
107,114,173],[107,121,174,182],[108,110],[109,113,183],[110,117,123],[111,124,
183,184],[112,118,154,173,175],[113,122,175,177],[114,121,153],[115,119,175],
[116,120,155],[117,125],[118,127,158,174,176],[119,176,180,183],[120,156,182,
183],[121,128,157],[122,176,178,183,184],[123,125,159,177],[124,126,160,177],
[125,129,163,178],[126,165,178,183,184],[127,161,179],[128,162,178,180,182,
183],[129,166,181],[130,137,185,186],[131,136],[132,135,172,185,186],[133,139,
187],[134,187],[135,140,154,173,175],[136,143,185],[137,142,145,155],[138,185,
186,189],[139,141,144,153,185],[140,158,174,176,186],[141,147,157,187,188],
[142,146,156,186],[143,188],[144,147,175],[145,146],[146,149],[147,150,176],
[148,151,185],[149,168,186],[150,169,179,187,188],[151,152,188],[152,171,189],
[153,157],[154,158],[155,156],[156,164],[157,162],[158,161],[159,163,185],
[160,165,185],[161,168,186],[162,169,187,188],[163,166,188],[164,182,183,186],
[165,167,188],[166,171,189],[167,184,189],[169,183],[170,184,189],[172,173],
[173,174],[175,176],[176,179],[177,178,185],[178,181,188],[179,183,186],[180,
187],[181,184,189],[185,188],[188,189]]]]], 38,
[[[4],1,[5],[1,2],[1,4],2,[1,5],2,[1,6],1,[1,7],[2,3],2,[2,4],1,[2,5],2,[2,6],
2,[2,7],[3,4],2,[3,5],5,[3,6],4,[3,7],2,[4,5],3,[4,6],6,[4,7],4,[5,6],1,[5,7],
1,[6,7],[1,2,3],1,[1,2,4],2,[1,2,5],3,[1,2,6],4,[1,2,7],2,[1,3,4],[1,3,5],1,
[1,3,6],1,[1,3,7],1,[1,4,5],3,[1,4,6],6,[1,4,7],5,[1,5,6],2,[1,5,7],3,[1,6,7],
1,[2,3,4],[2,3,5],3,[2,3,6],5,[2,3,7],3,[2,4,6],2,[2,4,7],1,[2,5,6],1,[2,5,7],
3,[2,6,7],[3,4,5],[3,4,6],3,[3,4,7],3,[3,5,6],2,[3,5,7],4,[3,6,7],1,[4,5,6],
[4,5,7],2,[4,6,7],1,[1,2,3,5],[1,2,3,6],[1,2,3,7],[1,2,4,6],[1,2,4,7],[1,2,5,
6],[1,2,5,7],2,[1,2,6,7],[1,3,5,6],[1,3,5,7],[1,3,6,7],[1,4,5,7],[1,4,6,7],[2,
3,5,6],[2,3,5,7],2,[2,3,6,7],[2,4,5,7],[2,4,6,7],[2,5,6,7],[3,4,6,7]],[[1,[[1,
6,17,18,27,43,51,58,91,118,141,142,169],[2,28,44,58,66,90,115,130,144],[3,21,
30,33,46,52,59,71,106,136,157,160,161,179,181,182],[4,5,14,71,73,80],[5,27,83,
91,94,102],[6,26,67,68,81,88,89,95,166],[7,9,28,65,66,100],[8,30,71,88,89,95,
105,107,109,166],[9,12,29,70,109],[10,34,83,91,94,110,171,173],[11,37,77,95,
105,107,109,112,113],[12,13,39,76],[13,41,80,109,112,113],[14,18,27,64,118,
122,128],[15,26,68,116,119,166],[16,28,65,66,115,126],[17,68,116,129],[18,19,
67,131,133],[19,24,43,69,118,135,138],[20,46,71,116,129,137,181],[21,44,115,
130,134,138],[22,50,124,130,134,135,138,140,187,188],[23,48,77,129,131,137,
181,185],[24,25,49,75,119],[25,57,78,126,138,140],[26,31,114,141,142],[27,32,
81,145,148],[28,29,147],[29,39,44,115,156],[30,43,118,141,142,150,151,156],
[31,35,89,117,166],[32,36,82,83,91,118,141,154],[33,90,115,144,154,176],[34,
46,145,157,181,183],[35,42,96,120,142,150,167],[36,40,84,85,92,119,143,145,
181],[37,50,124,142,150,151,156,158,159],[38,93,124,144,152,154,176,178,189],
[39,41,47,123],[40,86,87,103,126,146,149,154,178,184,189],[41,56,128,156,158,
159],[42,104,125,147,153,168],[43,49,89,160,161],[44,47,161],[45,53,89,117],
[46,51,91,141,163,186],[47,56,130,134],[48,93,152,163,189],[49,57,96,142,150],
[50,59,160,161,164,165],[51,54,92,129,131,143,145,160,181],[52,58,93,124,130,
142,144,169,187,189],[53,55,60,96,120],[54,103,132,146,149,162,163,184,186,
187,189],[55,62,104,125],[56,133,139,161,164,165],[57,104,147,153,161,164],
[58,133,147,148,161,170,179,182],[59,61,134,150,188],[60,62,107],[61,139,153,
161,164],[62,63,111],[63,113],[64,67,81,166],[65,168],[66,70,170],[67,69,114],
[68,72,169],[69,75,89,117,166],[70,76,90,115,172],[71,91,118,169,171,172],[72,
74,88,116,166],[73,94,122,171,173,175],[74,79,97,121,167,169,171],[75,78,96,
120,167],[76,80,98,123],[77,93,124,169,171,172,175],[78,104,125,168],[79,99,
127,168,170,174],[80,102,128,172,175],[81,82],[82,85,88,166],[83,84,177],[84,
86,94,178],[85,87,97,167],[86,101],[87,99,168],[88,97,141],[89,96],[90,98,
179],[91,92,179],[92,103,169,171],[93,106,179,180],[94,101,145,180],[95,100,
142,167,169],[96,104,107],[97,99,105,143],[98,102,144,176],[99,108,146],[100,
109,147,168,170],[101,149,173],[102,148,177,179,180],[103,170,174,179,180],
[104,111],[105,108,151,171],[106,110,152,171,176],[107,111,150],[108,112,155,
174],[109,156,172],[110,157,174,177,179,180],[111,113,153],[112,159,175],[113,
158],[114,117],[115,123,182],[116,121,141],[117,120],[118,119,166,181,182],
[119,126,142,167,169],[120,125],[121,127,129,143,181],[122,131,145,181,183,
185],[123,128,130,144],[124,181,182,185],[126,147,168,170,182],[127,132,146,
184],[128,133,148,182,185],[129,132,169],[130,133],[131,135,186,187],[132,137,
170],[133,138,187],[134,139],[135,136,160,181],[136,162,184,186,187,188],[137,
163,172,184,186],[138,161,182],[139,140,188],[140,164],[141,143],[142,147],
[143,146,151],[144,148],[145,149,189],[146,155],[147,156],[148,154,189],[149,
183],[150,153],[151,155,160,181],[152,157,181],[153,158],[154,177,179,182],
[155,159,162,184],[156,161,182],[157,163,184,189],[158,164],[159,165,185],
[160,162],[162,165],[163,179],[165,187,188],[166,167],[167,168],[169,170],
[170,172],[171,174,181],[172,179,182],[173,183],[174,175,184],[175,180,185],
[176,177],[177,178],[178,180],[180,189],[181,184],[183,186],[184,185],[185,
187,189]]]]],
[[[3],[4],1,[5],[1,2],1,[1,3],1,[1,4],4,[1,5],3,[1,6],2,[1,7],[2,3],2,[2,4],2,
[2,5],3,[2,6],3,[2,7],1,[3,4],3,[3,5],5,[3,6],5,[3,7],2,[4,5],4,[4,6],7,[4,7],
5,[5,6],2,[5,7],2,[6,7],[1,2,3],[1,2,4],1,[1,2,5],4,[1,2,6],4,[1,2,7],3,[1,3,
4],[1,3,5],1,[1,3,6],2,[1,3,7],1,[1,4,5],2,[1,4,6],6,[1,4,7],5,[1,5,6],2,[1,5,
7],4,[1,6,7],1,[2,3,4],[2,3,5],4,[2,3,6],5,[2,3,7],4,[2,4,5],[2,4,6],2,[2,4,
7],2,[2,5,6],1,[2,5,7],3,[2,6,7],1,[3,4,5],[3,4,6],3,[3,4,7],3,[3,5,6],2,[3,5,
7],5,[3,6,7],2,[4,5,6],[4,5,7],2,[4,6,7],2,[5,6,7],[1,2,3,5],[1,2,3,6],[1,2,3,
7],[1,2,4,6],[1,2,4,7],[1,2,5,6],[1,2,5,7],1,[1,2,6,7],[1,3,5,7],[1,4,5,7],[1,
4,6,7],[2,3,5,6],[2,3,5,7],1,[2,3,6,7]],[[1,[[1,7,8,13,38,41,49,104,138,147,
170,182],[2,13,25,38,41,57,61,63,75,138,151,154,170],[3,9,26,27,40,59,63,75,
110,136,166,169,198],[4,31,45,46,60,64,76,79,88,126,187,189,205,207,208],[5,
11,24,88,95,96],[6,12,22,89,94,197,199],[7,12,105,197],[8,10,103],[9,39,84,85,
100,108,109,117,195],[10,41,86,113],[11,40,102,110,113,119],[12,17,38,116,
120],[13,89,112,114,199,205],[14,46,89,114,126,204,205],[15,45,88,108,109,117,
124,125,131,195],[16,43,86,102,110,113,127,200],[17,19,44,89,125,131],[18,53,
104,113,115,127,200,203],[19,21,52,92],[20,51,93,117,124,125,131,132,133],[21,
56,96,131,132],[22,25,38,138,142,147],[23,39,85,135,144,195],[24,27,40,83,136,
140,148],[25,30,153,199],[26,85,135,153],[27,29,84,152,156],[28,60,88,135,153,
161,207],[29,33,59,87,136,158,163],[30,32,61,138,151,201],[31,57,138,151,154,
158,159,163],[32,37,65,93,141,152,153,207],[33,36,67,91,144],[34,62,143,154,
158,159,163,164,165],[35,69,93,153,161,207,210],[36,74,97,147,163,164],[37,72,
148,155,157,201,203,209],[38,44,167,173],[39,47,134,166,169],[40,42,100,168,
171],[41,139,168],[42,49,101,102,110,136,166,182],[43,60,139,168,183,207],[44,
52,57,138,177,181],[45,59,136,166,169,175,177,181],[46,61,138,170,176,182],
[47,48,108,137,195],[48,54,111,145,169,175,196],[49,55,103,105,112,144,167,
168,207],[50,104,115,143,170,176,182,184],[51,62,143,169,175,177,181,185,186],
[52,56,66,141],[53,69,168,183,207,210],[54,121,150,173,180,197],[55,106,107,
123,147,172,174,182,184,209],[56,71,148,181,186],[57,66,187,189],[58,68,108,
137],[59,67,108,187,189],[60,63,110,151,166,190],[61,65,205],[62,76,187,189,
191,192],[63,70,112,152,153,167,168,187,207],[64,75,115,143,154,169,170,193,
198],[65,72,115,170,176],[66,71,154,159],[67,74,111,169,175],[68,73,77,111,
145],[69,78,115,190,193],[70,123,155,157,172,174,188,190,193,209],[71,156,162,
189,191],[72,171,179,205,206],[73,80,121,150],[74,121,173,180,189,191],[75,
156,171,173,189,199,205,208],[76,81,159,175,194],[77,80,124],[78,79,126,187,
207],[79,129,188,190,193,194,209],[80,82,128],[81,162,180,189,191],[82,132],
[83,84,100,195],[84,87,134],[85,90,198],[86,95,139],[87,91,108,137,195],[88,
110,136,198,200,201],[89,92,138,200,201],[90,94,109,135,195],[91,97,111,145,
196],[92,96,114,141],[93,115,143,198,200,201,203],[94,99,116,142,196,198,200],
[95,98,113,140,200],[96,119,148,201],[97,121,150,197],[98,122,149,202],[99,
118,146,197,199,202],[100,101],[101,105,109,195],[102,103,204],[103,107,113],
[104,114,204],[105,106,116,196],[106,118,197],[107,122,204],[108,111],[109,
116,166],[110,112,205],[111,121,124],[112,123,198,200],[113,122,168],[114,119,
170],[115,126,205,206],[116,118,125,167],[117,120,169,196,198],[118,130,172],
[119,171,204,205],[120,131,173,197,199],[121,128],[122,127,174],[123,199,202,
205,206],[124,128,175],[125,130,177,200],[126,129,176,200],[127,183,202,204,
205],[128,132,180],[129,179,202,205,206],[130,133,178,202],[131,181,201],[132,
186],[133,185,203],[134,137],[135,142,166],[136,144,195,207,208],[137,145],
[138,141,207,208],[139,140,151],[140,149,152,168,207],[141,148,154,170],[142,
146,153,167,207],[143,207,208,210],[144,147,169,196,198],[145,150],[146,155,
172,209],[147,173,197,199,208],[148,156,171,208],[149,157,174,209],[151,152],
[152,157,158],[153,155,198],[154,156],[155,161,199],[156,163],[157,160],[158,
160,187,207],[159,162],[160,165,188,209],[161,190,201,209],[162,164],[163,189,
208],[164,191],[165,192,210],[166,167],[167,172,177],[168,174],[169,173],[170,
171],[171,182],[172,178],[173,181],[174,183],[175,180],[176,179,207],[177,178,
187,207],[178,185,188,209],[179,184,209],[180,186],[181,189,208],[182,204,205,
208],[183,190,209],[184,206,210],[185,192,210],[186,191],[187,188],[188,192],
[190,205],[192,194],[193,206,210],[195,196],[196,197],[198,199],[199,201],
[200,202,207],[201,205,208],[202,203,209],[203,206,210],[207,209],[209,210]]]]\
], 39,
[[[4],1,[5],[1,4],[1,5],1,[2,3],[2,4],[2,5],1,[2,6],[3,4],[3,5],4,[3,6],2,[3,
7],[4,5],2,[4,6],5,[4,7],3,[1,2,4],[1,2,5],3,[1,2,6],3,[1,2,7],[1,3,5],[1,3,
6],[1,4,5],3,[1,4,6],9,[1,4,7],5,[1,5,6],1,[1,5,7],1,[2,3,5],3,[2,3,6],7,[2,3,
7],2,[2,4,6],2,[2,4,7],1,[2,5,6],[2,5,7],1,[3,4,5],[3,4,6],6,[3,4,7],4,[3,5,
6],3,[3,5,7],5,[3,6,7],[4,5,6],[4,5,7],2,[4,6,7],[1,2,3,5],[1,2,3,6],2,[1,2,3,
7],[1,2,4,6],4,[1,2,4,7],2,[1,2,5,6],3,[1,2,5,7],6,[1,2,6,7],[1,3,4,6],[1,3,4,
7],[1,3,5,6],1,[1,3,5,7],2,[1,3,6,7],[1,4,5,6],1,[1,4,5,7],5,[1,4,6,7],3,[2,3,
4,6],[2,3,4,7],[2,3,5,6],3,[2,3,5,7],8,[2,3,6,7],2,[2,4,5,7],[2,4,6,7],[3,4,5,
7],1,[3,4,6,7],2,[1,2,3,5,6],1,[1,2,3,5,7],3,[1,2,3,6,7],1,[1,2,4,5,7],1,[1,2,
4,6,7],2,[1,2,5,6,7],[1,3,4,6,7],[2,3,4,6,7],[2,3,5,6,7],[1,2,3,5,6,7]],[[1,
[[1,4,8,24,27,31,47,73,94,100,106,129,168,202],[2,4,8,24,27,30,48,64,74,90,94,
98,105,106,121,128,168,188,201,202,208],[3,5,14,23,28,36,67,71,91,109,116,119,
140,156,160,171,178,181,186,189,209],[4,12,35,49,50,55,59,65,66,123,132,148],
[5,17,37,45,48,51,68,136,143,152,161,163,193,195,201,210],[6,13,37,45,47,48,
60,68,70,138,143,152,163,193,194,197,202],[7,12,35,72,81,82,123,127,169,174,
182],[8,35,72,86,169,186],[9,23,36,39,71,72,86,91,92,171,181,186],[10,22,39,
71,87,91,144,173,176,181,186],[11,26,40,43,75,86,91,92,130,171,185,187,209],
[12,16,94,98,100,105,106,149,168],[13,23,71,99,109,116,171,174,181,189],[14,
45,47,73,94,100,107,114,194],[15,45,48,74,94,98,107,108,113,152,188,193],[16,
20,49,71,123,153,174,182,189],[17,22,71,101,109,112,173,181,182,189],[18,46,
58,76,80,97,100,107,110,114,117,190,194,200],[19,46,54,77,80,97,98,107,108,
113,117,170,192,193,199,208,210],[20,21,46,57,77,80,97,98,100,107,108,126,168,
172,193,194],[21,61,103,104,111,112,127,153,155,169,174,179,182,184,185,189,
191,196,198,207],[22,30,48,118,121,161,188,201],[23,27,47,48,94,118,120,121,
202],[24,25,49,71,186,189],[25,33,57,88,97,118,168,172],[26,56,58,97,110,118,
120,122,190],[27,34,55,59,86,96,99,130,156,171],[28,31,51,58,76,88,97,100,122,
129,168,190,205,208],[29,54,88,97,118,121,122,170,208],[30,32,59,87,95,101,
131,157,166,173],[31,66,103,134,160,169,178,186,189],[32,64,90,105,121,161,
175,188,192,201,204,208],[33,61,119,169,179,186,187,189,191],[34,63,64,89,102,
106,120,121,122,158,180,190,202,205,208],[35,38,128,129,133,201,202],[36,47,
73,129,138,141,194,202],[37,49,71,123,132,139,145],[38,41,50,72,123,145],[39,
48,74,128,136,138,143,146,193,201,202],[40,56,78,128,136,146,193,199,204,210],
[41,44,53,79,126,128,129,138,193,194],[42,52,75,124,125,130,131,132,137,139,
145,147,203],[43,58,76,129,138,141,194,200,205,206],[44,62,85,127,134,135,140,
145,147,196,198,203],[45,50,123,148,150,153],[46,52,124,125,148,150,151,153,
155,207],[47,55,156,160],[48,59,156,157,159,162],[49,57,163,201,202],[50,53,
94,163],[51,66,101,124,131,132,148,166,203,207],[52,68,97,163,167],[53,62,96,
148,150,156],[54,130,131,137,156,157,159,165,166,203],[55,63,100,129,194],[56,
95,151,157,162,166,207],[57,61,130,131,132,139,156,157],[58,67,130,156,160,
164,165],[59,64,98,128,193],[60,65,99,125,130,132,148,164,203,207],[61,133,
142,158,161,163,167,201,202,204,205],[62,102,149,154,158,163,167],[63,103,134,
160,164,196],[64,104,135,159,162,166,198,203,207],[65,106,133,149,163,197,
202],[66,105,133,149,163,195,201],[67,70,110,138,194,206],[68,69,109,137,139,
150,151,156,157],[69,115,142,143,152,154,158,161,163,167,206,210],[70,116,140,
160,164,196],[71,168,172,177],[72,79,94,177],[73,81,123,171,174,178],[74,82,
123,171,173,174,176,181,182,198],[75,88,97,168,170,172,177,183,208],[76,124,
171,178,185,209],[77,101,124,131,173,182,184],[78,87,95,173,176,184],[79,85,
86,96,171],[80,99,125,130,171,174,185],[81,83,100,126,129,168,194],[82,84,98,
126,128,168,193,199,208],[83,103,127,134,169,174,178,185,196],[84,104,127,135,
169,174,176,182,184,198],[85,89,102,177,180,183,208],[86,89,128,129,168,208],
[87,90,128,168,204,208],[88,91,130,131,186,187],[89,92,134,135,169,186,187],
[90,135,169,176,186],[91,93,118,136,138,170,172],[92,120,141,146,177,180,202],
[93,119,140,144,179,181,186,187,209],[94,96,189],[95,108,188,192],[96,102,
107],[97,109,189,191],[98,104,148,207],[99,106,168,190,208],[100,103,148],
[101,105,168,192,208],[102,111,189,191],[103,114,149,190],[104,113,149,188,
192,208],[105,169,182,189],[106,169,174,189],[107,111,150,156,171],[108,112,
151,157,173],[109,115,118,170,172],[110,116,151,171,209],[111,117,154,158,
180],[112,152,161,175,188,192,210],[113,153,159,174,181,182,189,198],[114,153,
160,174,178,189,196],[115,119,179,181,189,191,209],[116,120,152,180,190],[117,
155,165,185,191,209],[118,119,156,157],[119,122,158,161],[120,160,162,189],
[121,159,181,186,189],[122,165,166,187,191,209],[123,126,193,194,195,197],
[124,193,195,199,210],[125,193,194,197,199,200],[126,127,132,148],[127,133,
149,195,197,199],[128,135,203],[129,134],[130,138,202,205],[131,136,201,204],
[132,133,168],[133,145,169,203],[134,141,202,205],[135,146,201,202,204],[136,
144,157,173],[137,143,170,193,206,210],[138,140,156,171],[139,142,172,193,
194],[140,158,180,202,205,206],[141,160,178,196],[142,147,179,196,198],[143,
159,181,198,203],[144,161,175,201,204,210],[145,163,177,195,197,201,202],[146,
162,176,198],[147,167,183,199,200,204,205,206,210],[148,149],[149,153,207],
[150,154,193,194],[151,152,193,210],[152,162,198,207],[153,163,195,197],[154,
155,196,198],[155,167,199,200,210],[156,158],[157,161],[158,165],[159,201,
202],[160,202],[161,166],[162,188],[163,189],[164,190,200,205],[165,205,206],
[166,192,204,210],[167,191,203,207],[168,169],[169,177,208],[170,181,209],
[171,180,193,194],[172,179],[173,175,193,210],[174,197,202],[175,184,198],
[176,188],[177,186,189],[178,195],[179,183],[180,185,196,198,209],[181,208],
[182,195,201],[183,187,191,209],[184,192,199,204,208,210],[185,190,199,200,
205,208],[186,201,202],[187,204,205,208],[190,207],[191,208],[192,207],[193,
198],[194,196],[196,200],[198,199,210],[199,203,207],[203,208],[206,209],[209,
210]]]]], 41, 44,
[[[4],1,[5],[1,2],[1,4],1,[1,5],2,[2,3],1,[2,4],1,[2,5],2,[2,6],1,[2,7],[3,4],
1,[3,5],5,[3,6],3,[3,7],1,[4,5],3,[4,6],6,[4,7],4,[5,6],[5,7],[1,2,4],[1,2,5],
3,[1,2,6],4,[1,2,7],[1,3,5],1,[1,3,6],1,[1,3,7],[1,4,5],3,[1,4,6],9,[1,4,7],6,
[1,5,6],2,[1,5,7],2,[2,3,5],3,[2,3,6],7,[2,3,7],2,[2,4,6],2,[2,4,7],1,[2,5,6],
[2,5,7],1,[3,4,5],[3,4,6],5,[3,4,7],4,[3,5,6],3,[3,5,7],5,[3,6,7],1,[4,5,6],
[4,5,7],2,[4,6,7],1,[1,2,3,5],[1,2,3,6],2,[1,2,3,7],[1,2,4,6],3,[1,2,4,7],2,
[1,2,5,6],2,[1,2,5,7],6,[1,2,6,7],1,[1,3,4,6],[1,3,4,7],[1,3,5,6],[1,3,5,7],1,
[1,3,6,7],[1,4,5,6],[1,4,5,7],3,[1,4,6,7],3,[2,3,4,6],[2,3,4,7],[2,3,5,6],2,
[2,3,5,7],7,[2,3,6,7],2,[2,4,5,7],[2,4,6,7],[3,4,5,7],[3,4,6,7],1,[1,2,3,5,6],
[1,2,3,5,7],2,[1,2,3,6,7],[1,2,4,5,7],[1,2,4,6,7],[1,2,5,6,7],[2,3,5,6,7]],
[[-1,[[3,9],[38,77],[46,86],[105,150],[193,211]]],[1,[[1,12,20,34,40,48,70,80,
84,95,113,119,154,205],[2,6,13,36,41,46,71,97,118,121,128,155,187,213],[3,8,
14,22,35,38,50,53,91,96,133,134,143,144,169,178,182,191,193,205,216],[4,5,10,
55,60,62,155,208,211,213],[5,20,64,70,76,80,86,87],[6,21,52,68,69,80,84,148,
156,172],[7,27,64,70,76,93,161,164],[8,23,54,55,63,71,72,89,90,94,179,180,208,
210],[9,26,71,77,94,160,208,211,213],[10,12,20,95,99,101,109,152,196],[11,21,
52,98,101,107,148],[12,16,111,114,155,159,187,213],[13,52,98,110,113],[14,37,
55,112,116,190,197],[15,35,53,98,110,117,191],[16,17,34,53,95,96,115,117,167],
[17,19,39,59,100,155,187,189,208],[18,42,61,103,110,115,117,153,191,200,204,
216],[19,47,107,117,157,167,170,188,195,200,209],[20,25,121,123,127,128,173],
[21,24,118,121,126,187],[22,63,71,97,118,121,131,136,208],[23,34,95,96,119,
130,133,134,135,205],[24,28,69,96,135,148],[25,29,64,70,95,139,176,196,205],
[26,35,122,134,191,196],[27,37,123,138,190,199],[28,32,81,121,149,187,189,
208],[29,33,65,66,79,100,104,120,121,123,131,140,190,208],[30,75,106,119,130,
135,141,151],[31,66,74,104,105,120,121,131,132,136,140,207,208,212],[32,83,
125,135,141,152,188,195,209],[33,67,85,107,125,129,139,176,177,194,196,200,
205,206,209],[34,39,71,142,145,180],[35,41,71,118,145,213],[36,44,69,96,143],
[37,40,70,144,203,205],[38,46,72,74,105,112,120,121,147,155,187,207,214],[39,
47,75,80,119,130],[40,49,79,111,112,120,123,142,147,190],[41,48,80,110,122,
124,153,178,191],[42,74,120,132,142,145,147,207],[43,50,75,106,143,146],[44,
45,81,187,189],[45,83,143,146,188,195],[46,84,113,125,143,157,182,188,193,
205],[47,82,126,137,145,180,184,207],[48,82,114,127,128,145,147,181,192,207,
213,214],[49,85,113,129,144,194,203,204,205,206],[50,51,90,189],[51,92,143,
146,195],[52,56,155,158],[53,71,97,155,160,163,208,213],[54,69,96,148,156,162,
167],[55,70,95,154,161,165,169],[56,57,68,98,148,165],[57,62,78,102,149,155,
160,208],[58,73,103,151,154,161,165,171],[59,75,106,151,156,162,167,170],[60,
76,99,150,153,161,164,171],[61,74,105,155,160,163,208,212,214,215],[62,87,109,
152,157,165,169,171,209],[63,68,148,172,174,176],[64,65,175,208,211],[65,67,
76,150,177],[66,73,151,172,174,176,177],[67,88,211],[68,78,118,179],[69,81,
180],[70,79,179,181,213],[71,80,178,182],[72,84,119,151,154,156,172,185],[73,
89,120,179,183],[74,91,153,178,182,185,186],[75,90,180,184],[76,88,123,183],
[77,86,122,150,153,185],[78,87,124,172,174,178],[79,85,153,154,161,178,186],
[80,82,121,155,208],[81,83,156,162],[82,125,157,182,185,209],[83,159,166,180,
184],[84,126,158,159,173,179,180,210],[85,158,168,179,181,183,213,214],[86,
128,211,213],[87,127,173,175,179,181,183],[88,129,164],[89,93,133,161,174,
178],[90,92,130,162],[91,94,132,160,208,215],[92,137,166,180,184],[93,138,168,
175,179,181,183,215],[94,134,169,182,185,209],[95,100,190,192,197,208,210],
[96,187,189,198],[97,101,148,191,193,196],[98,102,118,197],[99,111,123,190,
199,201],[100,107,119,151,154,200],[101,108,121,149,155,187,208],[102,109,110,
124,191],[103,112,120,190,197,201],[104,122,150,153,191,196,200],[105,151,191,
193,200,216],[106,187,189,198,202],[107,126,158,197,210],[108,125,152,157,188,
193,196,200,209],[109,114,127,192,197,201],[110,114,155],[111,115,153,203,
204],[112,113,154,204],[113,158,197],[114,117,157,204],[115,116,142,160,190],
[116,144,169,194,203,204,216],[117,145,163,192,197,213],[118,124,205],[119,
126,187,207],[120,133,205,206],[121,125,172],[122,128,207],[123,129,206],[124,
127,131],[125,136,173,207],[126,135,188,205],[127,139,205,206],[128,196],[129,
199],[130,137,189,208],[131,139,174,178,191],[132,134,191,216],[133,138,142,
190],[134,145,192,207],[135,180,198,210],[136,176,182,193,196,205,209],[137,
141,195,209],[138,144,194,205,206,216],[139,140,175,181,192],[140,177,186,200,
206,216],[141,184,202,207,212],[142,144,178],[143,180,198],[144,147,181],[145,
182,205],[146,184,202],[147,186,204,206,216],[148,149,208,210],[149,152,156,
172],[150,208,211,212],[151,208,210,212],[152,159,173,210],[153,160,213,214],
[154,158,214],[155,157],[156,159,187],[157,163,213,214],[158,165],[159,167,
188],[160,169,178,191],[161,168,190,208,215],[162,166,189,208],[163,182,193,
209],[164,199,211,213],[165,179,197,210],[166,170,195,209],[167,180,198,210],
[168,171,194,209],[169,181,192,213,214,215],[170,184,202,212],[171,183,201,
212,214,215],[172,173],[173,176],[174,175,208],[175,177,209],[176,179,210],
[177,183,212],[178,181],[179,205],[181,186],[182,213],[183,206],[185,207,212,
214],[186,214,215],[187,188],[188,198],[189,195],[190,194,216],[191,192,208],
[192,200,209,216],[193,210],[194,201],[195,202],[196,211,213],[197,205],[199,
203],[200,207,212,214],[201,204,206,216],[203,213],[204,214],[208,209],[209,
212],[215,216]]]]], 46,
[[[4],[1,2],[1,3],[1,4],3,[1,5],2,[1,6],1,[2,3],1,[2,4],1,[2,5],2,[2,6],1,[2,
7],[3,4],3,[3,5],4,[3,6],4,[3,7],1,[4,5],3,[4,6],6,[4,7],3,[5,6],1,[5,7],1,[1,
2,3],1,[1,2,4],2,[1,2,5],5,[1,2,6],5,[1,2,7],3,[1,3,4],1,[1,3,5],3,[1,3,6],3,
[1,3,7],2,[1,4,5],4,[1,4,6],9,[1,4,7],7,[1,5,6],3,[1,5,7],5,[1,6,7],1,[2,3,4],
1,[2,3,5],6,[2,3,6],7,[2,3,7],5,[2,4,5],2,[2,4,6],4,[2,4,7],4,[2,5,6],3,[2,5,
7],4,[2,6,7],2,[3,4,5],2,[3,4,6],6,[3,4,7],5,[3,5,6],4,[3,5,7],7,[3,6,7],3,[4,
5,6],2,[4,5,7],5,[4,6,7],4,[5,6,7],1,[1,2,3,5],1,[1,2,3,6],2,[1,2,3,7],1,[1,2,
4,5],[1,2,4,6],2,[1,2,4,7],2,[1,2,5,6],2,[1,2,5,7],4,[1,2,6,7],2,[1,3,4,6],[1,
3,4,7],[1,3,5,6],[1,3,5,7],1,[1,3,6,7],[1,4,5,6],[1,4,5,7],2,[1,4,6,7],2,[1,5,
6,7],[2,3,4,6],[2,3,4,7],[2,3,5,6],2,[2,3,5,7],4,[2,3,6,7],2,[2,4,6,7],[3,4,5,
7],[3,4,6,7],[3,5,6,7],[1,2,3,5,7]],[[-2,[[144,268],[168,268],[200,268],[208,
255],[214,258]]],[-1,[[2,60,224,226,231],[3,80,224],[5,96,249],[6,62],[12,
247],[13,59,62,127],[14,128,132,133],[15,62,127,150,156],[16,231],[18,133,151,
165],[19,133],[20,136,143,164,165,274,276],[22,172,268],[23,79],[25,176],[30,
132],[32,138],[33,195],[34,143,274],[36,143],[37,147],[38,203,268],[40,176],
[42,176,208],[43,255],[47,54,183,208,217],[48,143],[49,255],[50,217,258],[51,
268],[53,218,258],[54,265],[56,223,268],[57,211,269],[62,231,236],[64,71,96,
133,225,242],[68,224,231],[70,143],[71,137,239],[72,227,234],[75,230,237],[77,
149,244],[79,82],[81,224],[86,227,249],[88,249,251],[89,250,252],[90,230,250],
[95,231],[98,255],[102,179],[104,234],[110,187],[111,258],[113,237],[116,251,
255],[118,255],[121,252,258],[124,258,262],[126,254,260],[133,137],[143,263,
267,272,273],[145,268],[149,270,275],[152,231],[157,234],[159,237],[161,276],
[166,239],[169,270],[170,244],[171,174,268],[173,247],[176,179],[179,195],
[187,203,277,278],[191,208],[195,265],[196,214,268],[202,268,279],[203,269],
[209,255],[211,277],[213,258],[214,219],[219,222],[220,223,260],[222,262],
[239,255],[243,268],[244,247,258],[267,268],[268,273],[269,274]]],[[1,0],[[80,
82],[84,79],[168,174],[173,171],[192,208],[200,214],[209,191],[213,196,219],
[220,214]]],[1,[[1,16,25,40,45,95,112,135,160,180,233,277],[2,5,14,63,64,72],
[3,4,86],[4,24,68,99],[5,25,81,95,99],[6,23,94,96,112,225,232,249],[7,26,60,
80,93,103,224,231],[8,27,63,67,83,97,115,118,256,257,280],[9,28,68,81,95,99,
120,240],[10,29,67,83,93,103,117,122,224,231,239],[11,35,99,100,120,240,248],
[12,34,70,85,103,117,122,125,239],[13,23,58,128,132,133,148,225],[14,16,25,
135,139,229],[15,128,133,151,160],[16,19,157,235,263],[17,41,63,154,167,266,
270],[18,42,131,150,156,163,169,265],[19,21,40,131,135,150,166,245],[20,47,
156,163,169,174,265],[21,22,43,70,137,141,155,239,263,267],[22,53,148,149,158,
244,245,246,264],[23,31,80,176,190,263],[24,134,181],[25,30,181,250],[26,128,
132,175,184],[27,40,131,135,180,193,194,201,277],[28,41,134,181,198,266],[29,
42,131,132,175,184,191,197,265],[30,32,81,95,135,253,277],[31,33,82,94,131,
132,177,201,225],[32,37,85,86,104,141,181,183,195,266],[33,38,88,98,138,182,
226,263,267],[34,47,184,191,197,204,265],[35,44,181,183,198,266,275],[36,105,
180,194,201,206,228],[37,90,113,148,188,203,253,254,271,277,278],[38,89,111,
147,186,201,206,229,264],[39,46,94,131,150,177,212],[40,43,210,257],[41,45,95,
152,215,277],[42,49,209,211,231],[43,53,105,179,180,194],[44,164,215,276],[45,
52,104,154,157,181,183,210,266],[46,51,98,155,182,209,263,267],[47,209,211,
219],[48,55,105,212,221],[49,50,156,179,184,234,265],[50,161,185,187,211,237,
269],[51,111,158,186,212,213,221,264],[52,113,159,160,188,215,216,271,276,277,
278],[53,187,190,202,257,259],[54,57,164,193,222,255],[55,56,118,209,267],[56,
124,212,213,221],[57,167,199,217,258,262],[58,60,80,226],[59,61,79,224],[60,
65,128,232],[61,66,127],[62,64],[63,95,135,233,240,242],[65,74,93,129],[66,69,
92,130,224,231],[67,94,131,225,232,238,245],[68,72,134],[69,76,101,140,227,
234],[70,105,228,232,238,245,246],[71,77,102,226],[72,75,99,139,240],[73,100,
136,228,233,240,242,248],[74,78,106,142,232,238],[75,108,146,241],[76,114,144,
230,237],[77,110,229,242,248],[78,107,145,235,243],[80,84,249],[81,86],[82,88,
92,224],[83,96,225,249,251,253],[84,87,93],[85,100,228,249,251,253,254],[86,
90,99],[87,91,106,249,251],[88,89,101,227],[89,114,230],[90,108],[91,107,250,
252],[92,101,177],[93,106,175],[94,98,231,257],[95,104,256],[96,102,176,256],
[97,112,180,228,232,233,249],[98,111,232,234,238],[99,108,181],[100,115,183,
256,261],[101,114,116,182],[102,110,249,251,255],[103,109,184,227,232,234,
249],[104,113,233,240,255],[105,118,257,259],[106,107,117,178],[107,123,189],
[108,120,188],[109,122,185,230,235,237,250],[110,250,252,256,258,261],[111,
235,237,243,257,259],[112,190,235,236,250,256,257,280],[113,236,241,256,258,
261],[114,121,186],[115,119,193,240,251,255],[116,121,192],[117,123,191,238,
251,255],[118,124,194,238],[119,199,241,252,256,258,261,262],[120,198,241,
256],[121,126,200],[122,197,244,245,253],[123,125,196,243,252,258],[124,202,
243,257,259],[125,204,246,254,260],[126,205],[127,130],[128,129,263],[129,142,
151,175],[130,140,150,177],[131,263,267,272],[132,138,224,231],[133,176,270],
[134,139,152],[135,141,266,270,280],[136,154,183,266,270,275],[137,149,156,
179,265],[138,147,184,227,234,265],[139,146,157,181,266],[140,144,155,182],
[141,148,180,228,233],[142,145,153,178,263,267],[144,158,186],[145,162,189,
264],[146,159,188,271],[147,185,230,237,269],[148,190,236,270,280],[149,161,
187,269],[150,155,231],[151,153],[152,157],[153,162,165],[154,160,233,276],
[155,158,163,234],[156,161,263],[157,159,166],[158,168,237],[159,170],[160,
236,270],[161,169,264],[162,171],[163,168,209,239],[164,167,266],[165,171,208,
267],[166,170,210,266],[167,215,271,276],[168,173,213,244],[169,211,269,272],
[170,172,216,271],[171,214],[172,218,247,275],[173,220],[174,219,247,273],
[175,178],[176,277],[177,182],[178,189,191],[179,187],[180,190,263],[181,188],
[182,186,192],[183,193,277,278],[184,185,263],[185,197,264],[186,200],[188,
198],[189,196],[190,201,264,277],[191,196,267],[192,200,209],[193,199,210,
266],[194,202,267],[195,203,251,255],[196,204],[197,211,269,272],[198,215,271,
277],[199,216,271,277,278,279],[200,205,213],[201,257,272,280],[202,206],[203,
207,252,258],[204,219,273],[205,220],[206,259,273],[207,254,260,274,278,279],
[208,214],[209,213],[210,216,255],[212,257,272],[213,220],[216,218,258],[217,
260,274,276,278],[218,260,278,279],[219,260],[221,259,273],[223,262],[224,
227],[225,226,280],[226,229,232,249],[227,230],[228,280],[229,235,250,280],
[231,234],[232,235,263],[233,236],[234,237,239],[235,245,264],[236,242],[237,
244],[238,243,267],[239,244,265],[240,241,266],[241,248,271],[242,256,270,
280],[243,246],[244,269],[245,257,272,280],[246,259,273],[247,260,274],[248,
261,275],[249,250],[250,253],[251,252],[252,254],[253,256,280],[254,261],[255,
258],[256,277],[258,260],[260,262],[261,278],[262,279],[263,264],[264,272],
[265,269],[266,271],[270,277],[271,275],[275,276,278]]],[2,[[58,224],[59,226],
[61,232],[65,224,231],[69,232,238],[74,227,234],[76,235,243],[78,230,237],[79,
249],[84,224],[87,227],[91,230],[116,238],[121,243],[126,246],[127,263],[140,
263,267],[144,264],[151,231],[153,234],[162,237],[163,267],[165,239],[171,
244],[173,273],[192,267],[205,273]]]]],
[[[3],[4],2,[5],[1,2],[1,3],[1,4],4,[1,5],3,[1,6],1,[2,3],1,[2,4],1,[2,5],3,
[2,6],2,[2,7],[3,4],3,[3,5],6,[3,6],6,[3,7],1,[4,5],4,[4,6],9,[4,7],5,[5,6],1,
[5,7],1,[1,2,4],[1,2,5],5,[1,2,6],5,[1,2,7],2,[1,3,5],1,[1,3,6],2,[1,3,7],[1,
4,5],3,[1,4,6],11,[1,4,7],7,[1,5,6],2,[1,5,7],4,[2,3,5],6,[2,3,6],8,[2,3,7],5,
[2,4,5],[2,4,6],3,[2,4,7],3,[2,5,6],1,[2,5,7],3,[2,6,7],[3,4,5],[3,4,6],6,[3,
4,7],5,[3,5,6],3,[3,5,7],8,[3,6,7],1,[4,5,6],[4,5,7],4,[4,6,7],2,[1,2,3,5],1,
[1,2,3,6],2,[1,2,3,7],1,[1,2,4,5],[1,2,4,6],3,[1,2,4,7],3,[1,2,5,6],3,[1,2,5,
7],6,[1,2,6,7],2,[1,3,4,6],[1,3,4,7],[1,3,5,6],[1,3,5,7],2,[1,3,6,7],[1,4,5,
6],[1,4,5,7],4,[1,4,6,7],3,[1,5,6,7],[2,3,4,6],[2,3,4,7],[2,3,5,6],3,[2,3,5,
7],6,[2,3,6,7],3,[2,4,6,7],[3,4,5,7],[3,4,6,7],1,[3,5,6,7],[1,2,3,5,6],[1,2,3,
5,7],1,[1,2,3,6,7],[1,2,4,6,7]],[[1,[[1,7,11,33,34,39,46,94,132,136,141,147,
171,181,190,206,236,241,268,272,278],[2,8,22,31,55,60,68,100,134,168,170,213,
217,254],[3,11,33,51,58,66,132,152,155,160,171,272],[4,21,32,54,58,66,101,105,
116,135,160,169,216,272],[5,13,26,39,51,53,62,73,75,82,124,131,184,187,198,
226,243,246,258,259,261,272],[6,10,19,78,86,90,207,213,217,276],[7,12,95,207],
[8,34,76,98,99,105,116,206,215,236],[9,31,109,207,213],[10,32,92,101,103,105,
120],[11,81,100,108,112,118,213,217,219,244,248,280],[12,33,77,103],[13,38,78,
80,93,100,113,122,123,129,244,245,276,277],[14,35,100,109,128,207,213,225,
276],[15,36,77,92,101,103,127,222],[16,37,81,93,100,112,123,129,224,240,244,
248,276],[17,45,94,103,110,111,127,222,233],[18,44,106,109,128,225,235,276,
279],[19,21,32,135,136,141,144,148,212],[20,34,76,130,141,147,206],[21,24,153,
158,213,217,220,254],[22,76,130,154,160],[23,51,82,132,152,155,162,163,226,
259],[24,29,54,82,131,135,162,163,229],[25,53,82,130,154,166,258],[26,52,78,
156,164,256,260],[27,64,83,142,154,161,166,258,267,271],[28,61,83,142,155,162,
163,167,259,268],[29,30,65,85,138,217,254,257,276],[30,71,147,163,221,229,234,
255,262,268,278],[31,136,174],[32,40,170,172,179,237],[33,133,172],[34,41,168,
170,178,254],[35,53,136,174,191,258],[36,52,133,172,186,256],[37,51,132,171,
184,187,190,259,272],[38,54,131,135,169,184,185,187,189,272],[39,93,100,134,
168,170,182,192,276],[40,46,92,101,135,136,190,241,272],[41,42,99,131,189,
206],[42,50,104,170,209,254,257,276],[43,96,106,140,170,173,182,183,192,195,
273,276,279],[44,64,174,191,258,267],[45,59,172,173,186,256,270],[46,49,95,96,
108,138,139,170,172,173,182,256,276],[47,102,137,169,185,189,196,210],[48,94,
110,171,190,259,268],[49,97,114,146,147,177,181,190,194,241,242,266,268,272,
274,278],[50,119,181,189,196,212,255,262,278],[51,57,100,197,201,248],[52,58,
101,152,199,272],[53,60,100,168,202,213],[54,65,100,197,201,245],[55,56,99,
131,198],[56,70,104,254,257],[57,66,105,110,155,171,259],[58,69,108,153,156,
172,173,197,256],[59,110,161,199,271],[60,67,105,154,174,175,214,243,258],[61,
106,173,183,197,201,205,273],[62,68,106,113,140,156,170,173,203,217,254,273,
280],[63,73,102,137,198,204],[64,72,106,173,202,203],[65,71,102,105,169,185],
[66,118,158,179,201,248,264,273,280],[67,118,159,176,180,202,203,218,247,263],
[68,116,160,181,198,221,246,255,261,272],[69,114,157,160,177,199,200,266,271,
272,274],[70,119,198,204,255,262],[71,118,178,188,201,245,252,273],[72,75,124,
161,184,243,258],[73,74,122,257],[74,126,198,204,262],[75,129,164,193,202,203,
247,253,263],[76,79,217,219],[77,86,133,207,213],[78,101,135,216,222,226,232],
[79,84,98,130,206,232],[80,99,131,206,215,223,229],[81,88,132,206,222,226,232,
278],[82,100,134,213,217,225,227,276],[83,106,140,217,224,225,227,235,276,279,
280],[84,89,107,143,209,217,225,276],[85,102,137,210,215,223,229,234],[86,91,
103,144,208,214,222],[87,111,142,210,216,222,232,233],[88,90,112,145,209,217,
224,276,279,280],[89,117,150,212,221,228,232,233,278],[90,120,148,212,221,226,
232,278],[91,115,151,211,218,230],[92,95,207,240,276],[93,98,206,236,238,241],
[94,112,240,276,279],[95,97,103,208],[96,111,210,236,238,241,242],[97,115,211,
240],[98,107,168,244],[99,104,245],[100,105,243,246],[101,108,213,244,248],
[102,122,245,252],[103,115,172],[104,119,215,223],[105,118,170,217,276],[106,
124,243,246,250,251],[107,117,175,236,238,243],[108,114,214,216,222,243],[109,
121,174,208,214],[110,224,248,280],[111,123,173,244,249],[112,120,171,236,
250],[113,116,169,210,215,216,236,250],[114,218,219,230,244,247,248,249,280],
[115,127,177],[116,178,219,220,237,244,245,277],[117,176,237,239,244,247,249],
[118,181,221,246,250,278],[119,220,231,245,252],[120,179,237,240,244,248],
[121,128,180,211,218],[122,126,185,223],[123,125,184,222,238,243],[124,129,
183,224,253,276],[125,193,230,239,244,247,249,253],[126,188,231,245,252],[127,
186,230,240,244,248],[128,191,228,246,278],[129,187,226,246,250,278],[130,143,
168,260],[131,254,257,265],[132,145,256,260,264],[133,144,152],[134,141,206,
258,261],[135,138,256,260,264,276,277],[136,139,207,213],[137,254,257,265,
269],[138,147,169,210,216,268],[139,146,174,208,214,258],[140,210,258,259,261,
267,268],[141,149,170,209,217,254,276],[142,156,173,256,260,270],[143,150,154,
175,258],[144,151,153,172,256],[145,148,155,171,259,268],[146,180,211,218,
263],[147,178,219,260,277],[148,158,179,260,264],[149,181,212,221,255,261,268,
278],[150,159,176,260,263,270],[151,157,177,266],[152,153,213],[153,157,162,
214],[154,159,217],[155,158,217,280],[156,160,216,271],[157,165,218],[158,163,
221],[159,166,221,271],[160,219,260],[161,164,224,256],[162,165,197,225,256],
[163,201,227,260,264],[164,199,226,266,271],[165,167,200,228,266],[166,202,
227,260,263],[167,205,235,270],[168,175,272],[169,178,254,273],[170,181,236],
[171,179,273],[172,177],[173,184,272,274],[174,180],[175,176,182],[176,194,
272,274],[177,186],[178,189,255,272],[179,190,272],[180,191],[181,192,237,
273],[182,194,238,243,258],[183,187,259,275],[184,193,197,256],[185,188,257,
276],[186,199,266,272],[187,201,264,273],[188,196,262,278],[189,245,265,277],
[190,240,248,264],[191,202,263],[192,241,246,261,272,278],[193,200,266,272,
274,275],[194,195,239,247,263],[195,242,251,267,274,275],[196,252,269,273,
279],[197,200,243],[198,245,265],[199,248],[200,205,247],[201,246,272],[202,
246,272],[203,250,251,267,271,274],[204,252,269],[205,251,274,275],[206,209,
276,277],[207,208],[208,211,276],[209,212,215,236],[210,276,277,279],[211,
278],[212,220,237,277],[213,214],[214,218,225],[215,220,254],[216,219,280],
[217,221],[218,228],[219,232],[220,229,255],[221,227,280],[222,230,256,276],
[223,231,257,276],[224,226,259],[225,228,243,258],[226,248,264,280],[227,246,
261,278],[228,235,247,263],[229,245,265,277],[230,233,266,278],[231,234,262,
278],[232,244,260,277],[233,249,270,279,280],[234,252,269,279],[235,251,267],
[236,237],[237,241],[238,239,276],[239,242,278],[240,278],[241,244,277],[242,
249,279],[243,247],[244,272],[247,251],[249,274],[250,273,279,280],[251,253],
[253,275],[254,255],[255,265],[256,266],[257,262],[258,263,276],[259,264,276],
[260,272],[261,277],[262,269],[263,267,278],[264,268,278],[266,270],[267,279],
[268,273,279,280],[270,271,274],[271,280],[276,278],[278,279]]]]], 47, 50,
[[[3],[4],2,[5],[1,2],[1,3],[1,4],4,[1,5],3,[1,6],1,[2,3],1,[2,4],1,[2,5],3,
[2,6],2,[2,7],[3,4],3,[3,5],6,[3,6],6,[3,7],1,[4,5],4,[4,6],9,[4,7],5,[5,6],1,
[5,7],1,[1,2,3],[1,2,4],1,[1,2,5],6,[1,2,6],6,[1,2,7],3,[1,3,4],[1,3,5],2,[1,
3,6],3,[1,3,7],1,[1,4,5],4,[1,4,6],12,[1,4,7],8,[1,5,6],3,[1,5,7],5,[1,6,7],
[2,3,4],[2,3,5],7,[2,3,6],9,[2,3,7],6,[2,4,5],1,[2,4,6],4,[2,4,7],4,[2,5,6],2,
[2,5,7],4,[2,6,7],1,[3,4,5],1,[3,4,6],7,[3,4,7],6,[3,5,6],4,[3,5,7],9,[3,6,7],
2,[4,5,6],1,[4,5,7],5,[4,6,7],3,[5,6,7],[1,2,3,5],1,[1,2,3,6],2,[1,2,3,7],1,
[1,2,4,5],[1,2,4,6],3,[1,2,4,7],3,[1,2,5,6],3,[1,2,5,7],6,[1,2,6,7],2,[1,3,4,
6],[1,3,4,7],[1,3,5,6],[1,3,5,7],2,[1,3,6,7],[1,4,5,6],[1,4,5,7],4,[1,4,6,7],
3,[1,5,6,7],[2,3,4,6],[2,3,4,7],[2,3,5,6],3,[2,3,5,7],6,[2,3,6,7],3,[2,4,6,7],
[3,4,5,7],[3,4,6,7],1,[3,5,6,7],[1,2,3,5,6],[1,2,3,5,7],1,[1,2,3,6,7],[1,2,4,
6,7]],[[1,[[1,9,40,102,151,162,201,203,222,302,313],[2,67,108,148,202,249],[3,
21,31,54,56,69,110,123,126,152,182,197,250,307],[4,9,52,69,151,174,201],[5,40,
52,58,79,135,223,267,283,292,297],[6,8,20,80,87,93,242,248,249,311],[7,11,104,
242],[8,31,100,110,115,123,132],[9,83,108,120,128,249,280,315],[10,33,77,107,
111,123,126,241,252,271],[11,34,85,115],[12,32,112,242,248],[13,35,83,108,120,
139,260,274,280,311],[14,36,85,100,110,115,143,259],[15,41,108,112,140,242,
248,258,311],[16,38,80,84,99,108,116,134,137,139,279,281,311,312],[17,44,102,
115,119,124,143,259,270],[18,48,112,117,140,258,269,311,314],[19,33,77,146,
162,164,241],[20,21,31,152,153,157,162,167,247],[21,24,177,179,248,249,254,
289],[22,77,146,176,182],[23,51,79,146,176,187,294],[24,27,54,79,147,152,183,
188,264],[25,53,80,175,186,291,301],[26,52,79,151,174,188,267,292],[27,30,64,
91,156,249,289,293,311],[28,63,92,174,188,292,302],[29,62,92,163,176,184,187,
294,303,306],[30,68,164,188,256,264,268,290,296,302,313],[31,39,196,202,209,
272],[32,153,200],[33,37,193,202,206,289],[34,149,196],[35,52,151,201,222,223,
292],[36,53,149,196,224,291],[37,47,111,147,219,241],[38,54,147,152,197,213,
214,219,223,307],[39,42,100,110,152,153,222,275,307],[40,108,148,202,217,311],
[41,51,153,200,215,294],[42,49,101,104,114,156,160,195,196,202,211,291,311],
[43,117,159,202,212,217,308,311,314],[44,61,195,196,224,291,305],[45,102,119,
201,222,292,302],[46,113,155,197,214,219,227,244],[47,50,122,202,245,289,293,
311],[48,62,200,215,294,303],[49,106,129,164,166,203,205,216,222,275,277,299,
302,307,309,313],[50,131,203,219,227,247,290,296,313],[51,65,108,193,234,248],
[52,60,108,232,280],[53,56,110,171,233,307],[54,64,108,228,232,281],[55,59,
111,147,231],[56,70,114,175,177,195,196,228,291],[57,72,113,155,231,236],[58,
67,117,159,202,249,308,315],[59,66,122,289,293],[60,69,119,123,174,201,292],
[61,119,184,233,306],[62,73,117,195,234,239],[63,117,212,232,308],[64,68,113,
123,197,214],[65,71,123,176,198,200,251,278,294],[66,131,231,236,290,296],[67,
203,256,283,297],[68,128,206,221,232,281,285,308],[69,128,179,209,232,280,300,
308,315],[70,129,178,182,205,230,233,299,306,307,309],[71,128,181,207,208,234,
239,253,282,298],[72,75,137,293],[73,74,135,184,213,278,294],[74,139,186,220,
234,239,282,288,298],[75,142,231,236,296],[76,78,97,242,245],[77,81,249,255],
[78,82,145,252],[79,108,148,249,262,311],[80,110,152,250,259,266,267],[81,90,
107,146,241,266],[82,89,109,150,242,248],[83,88,151,267,313],[84,111,147,241,
252,257,264],[85,87,149,242,248],[86,124,163,244,250,259,266,270],[87,95,115,
157,243,251,259],[88,93,120,158,249,260,311,314,315],[89,96,121,154,243,251,
252,257],[90,94,118,161,245,249,258,311],[91,113,155,244,252,257,264,268],[92,
117,159,249,260,262,311,314,315],[93,132,167,256,267,313],[94,127,170,247,256,
265,266,270,313],[95,133,169,246,253,261],[96,125,165,246,253,254,263],[97,98,
271],[98,103,109,242],[99,107,241,271,273,275],[100,104,242,274,311],[101,124,
244,271,273,275,277],[102,120,274,311,314],[103,105,121,243,271,273],[104,106,
115,243],[105,125,246,272,276],[106,133,246,274],[107,118,193,279],[108,123,
283],[109,121,194],[110,114,248,279,280],[111,122,281],[112,130,200,243,251],
[113,137,281,285],[114,129,250,251,259,278],[115,133,196],[116,126,197,244,
250,252,271,287],[117,135,283,287],[118,127,198,271,273,278],[119,260,280,
315],[120,132,201,287],[121,125,136,199],[122,131,252,257],[123,128,202,249,
311],[124,134,195,279,284],[125,141,204],[126,206,254,255,272,279,281,312],
[127,207,272,276,279,282,284],[128,203,256,283,287,313],[129,253,255,261,279,
280,282,284,315],[130,140,208,246,253],[131,254,263,281,285],[132,209,274,
280],[133,143,205],[134,138,213,259,273,278],[135,139,212,260,311],[136,141,
210,257,273,278],[137,142,214,257],[138,220,261,276,279,282,284,288],[139,223,
267,283,287,313],[140,215,265,283,313],[141,144,218,263,276,282],[142,221,263,
281,285],[143,224,261,274,279,280],[144,226,268,277,286],[145,150,289],[146,
161,193,301],[147,289,293,295],[148,162,297],[149,157,171],[150,154,172,194],
[151,158,300],[152,156,291,300,301,311,312],[153,160,242,248],[154,165,173,
199,289,293],[155,289,293,295,304],[156,164,197,244,250,302],[157,169,177,196,
291],[158,167,174,201,292,302],[159,292,297,302],[160,166,200,243,251,294],
[161,170,176,198,294],[162,168,202,249,311],[163,175,195,291,301,305],[164,
206,255,301,312],[165,180,204,290,296],[166,208,246,253,298],[167,179,209,
300],[168,203,256,297,302,313],[169,178,205,299],[170,181,207,298,301,305],
[171,177,248],[172,173,248],[173,180,185,251],[174,179,249,315],[175,182,250,
306],[176,181,249],[177,178,183,251],[178,189,253],[179,188,256],[180,190,
253],[181,187,256,306],[182,255,301],[183,189,228,258,291],[184,186,260,291],
[185,190,229,258,293],[186,233,267,299,306],[187,234,262,298,301],[188,232,
262,300],[189,192,230,265,299],[190,191,235,265,296],[191,237,269,304],[192,
238,269,305],[193,198,307],[194,199],[195,213,307,309],[196,205],[197,206,289,
308],[198,207,211],[199,204,210],[200,208],[201,209,308],[202,203],[203,217,
308],[204,218],[205,224],[206,219,290,307],[207,216,307,309],[208,215],[209,
222],[210,218,229,293],[211,216,273,278,294],[212,223,292],[213,220,228,291],
[214,221,293,311],[215,234,298],[216,225,276,282,298],[217,283,297,313],[218,
226,235,296],[219,281,295,312],[220,230,299,307,309,310],[221,227,296,313],
[222,274,280,300],[223,232,300,308],[224,233,299,307],[225,277,286,303,309,
310],[226,237,304],[227,285,304,308,314],[228,230,278],[229,235,278],[230,238,
282],[231,281,295],[232,283],[233,280],[234,283,307],[235,237,282],[236,285,
304],[237,240,286],[238,286,309,310],[239,286,287,303,306,309],[240,288],[241,
245,311,312],[242,243],[243,246,311],[244,311,312,314],[245,247,252,271],[246,
313],[247,254,272,312],[248,251],[249,256],[250,255,315],[251,253,258],[252,
254,289],[253,265],[254,264,290],[255,266],[256,262,315],[257,263,293,311],
[258,265,278,294],[259,261,291,311],[260,267,292],[261,270,299,313],[262,283,
297,313],[263,268,296,313],[264,281,295,312],[265,269,282,298],[266,279,301,
312],[267,280,300,315],[268,285,304,314],[269,286,303],[270,284,305,314,315],
[271,272],[272,275],[273,276,311],[274,313],[275,279,312],[276,277,313],[277,
284,314],[278,282],[279,307],[282,286],[284,309],[286,288],[287,308,314,315],
[288,310],[289,290],[290,295],[291,299],[292,300,311],[293,296],[294,298,311],
[296,304],[298,303,313],[299,305],[300,302,313],[301,307],[302,308,314,315],
[303,314],[305,306,309],[306,315],[311,313],[313,314]]],[2,[[6,78,81,245],[7,
97],[8,107,271],[12,78,97,109],[15,84,99,109,136],[18,91,101,136,144],[19,76,
145,153],[20,145,146],[22,145,172],[23,147,172,185],[24,146,172],[27,161,173,
258],[29,155,185,191],[30,170,180,192,265],[31,193],[32,145,194],[33,97],[37,
98,153,194],[41,147,194,210],[47,103,160,199,211],[48,155,210,226],[50,105,
166,204,216],[51,229],[54,193],[55,172,194],[59,173,199,229],[62,229,237],[64,
198,278],[66,180,204,235],[68,207,238,282],[72,229],[73,240],[75,235,240],[77,
248],[104,271],[106,272],[111,248],[112,252,271],[122,251,278],[130,254,272],
[131,253,282],[137,278],[140,264,275],[142,282,288],[176,289],[181,290],[187,
295],[200,289],[208,290],[215,295],[221,310]]],[3,[[1,7,33,34,42,153,164,241,
271,275,307],[2,10,22,32,55,65,193,248,289],[4,34,56,171,182,307],[5,16,25,51,
72,74,147,213,231,278,294,307],[9,114,248,255,279],[13,99,134,279],[26,171,
183],[28,163,183,192],[35,213,307],[40,99,193,211],[43,101,195,211,225],[52,
228],[58,116,175,195,239,289],[63,195,228,238],[67,126,182,231,290,307],[79,
248,258],[83,241,259,266],[88,245],[92,258,269],[93,247,266],[108,278],[117,
278,286],[120,271],[132,272,279],[135,288],[148,241,294],[151,291,301],[159,
244,294,303],[162,245,289],[167,301],[168,247,290],[188,301],[202,271],[203,
272],[209,307],[212,310],[217,275,307],[232,307],[297,312]]]]], 52,
[[[1,4],1,[1,5],[2,3],[2,4],[2,5],[2,6],[3,4],1,[3,5],2,[3,6],1,[3,7],[4,5],2,
[4,6],4,[4,7],2,[5,6],[5,7],[1,2,3],1,[1,2,4],3,[1,2,5],5,[1,2,6],5,[1,2,7],2,
[1,3,4],1,[1,3,5],3,[1,3,6],3,[1,3,7],1,[1,4,5],6,[1,4,6],10,[1,4,7],7,[1,5,
6],4,[1,5,7],4,[1,6,7],1,[2,3,4],2,[2,3,5],7,[2,3,6],8,[2,3,7],4,[2,4,5],2,[2,
4,6],5,[2,4,7],3,[2,5,6],3,[2,5,7],4,[2,6,7],1,[3,4,5],4,[3,4,6],8,[3,4,7],6,
[3,5,6],6,[3,5,7],7,[3,6,7],3,[4,5,6],3,[4,5,7],5,[4,6,7],4,[5,6,7],[1,2,3,4],
[1,2,3,5],3,[1,2,3,6],4,[1,2,3,7],3,[1,2,4,5],1,[1,2,4,6],5,[1,2,4,7],4,[1,2,
5,6],4,[1,2,5,7],7,[1,2,6,7],3,[1,3,4,5],[1,3,4,6],2,[1,3,4,7],2,[1,3,5,6],2,
[1,3,5,7],4,[1,3,6,7],2,[1,4,5,6],2,[1,4,5,7],5,[1,4,6,7],5,[1,5,6,7],1,[2,3,
4,6],2,[2,3,4,7],2,[2,3,5,6],4,[2,3,5,7],8,[2,3,6,7],4,[2,4,5,6],[2,4,5,7],2,
[2,4,6,7],2,[2,5,6,7],1,[3,4,5,6],[3,4,5,7],2,[3,4,6,7],3,[3,5,6,7],1,[4,5,6,
7],[1,2,3,5,6],[1,2,3,5,7],1,[1,2,3,6,7],[1,2,4,5,7],[1,2,4,6,7],[1,2,5,6,7],
[2,3,5,6,7]],[[-1,[[1,71],[2,50,66,81],[3,39,55,62,267,329],[4,118],[5,33,127,
128,131],[6,110,141,310],[8,161],[9,151,166],[10,104,178],[11,109,318],[13,
161,171,329],[14,161,170,171,329],[15,177,184],[16,62,126,152],[18,62,150],
[22,71,162,269],[23,71,128,160,268,318],[24,168,271],[26,165,199,273],[27,
269],[28,271],[29,208,214],[30,32,209],[31,36,205,224],[32,223,229],[34,222],
[35,242],[37,235],[39,66,232,238],[40,62,329],[42,329],[44,223,233],[45,234],
[46,221,235],[47,243],[49,217,228,230,239,242,247,331],[51,249,250],[53,256],
[54,209,256],[55,259],[56,256],[57,213],[58,250,257],[59,251,258],[60,253,
260],[62,249,275],[63,267],[66,267],[68,272],[71,86,223,252],[72,268,269],[73,
221,251],[74,267],[76,221],[77,269],[82,271,273],[83,255,272,281],[88,283],
[89,267,329],[90,256,257,268],[91,258,269],[93,260,273],[94,283],[95,261,271],
[99,264,279],[100,284,289],[102,103,286],[105,125,303],[108,299],[109,151,293,
301],[110,208,294],[111,132,284,292],[116,131,211,291],[118,123],[119,285,
294],[120,137,288,302,303,306],[124,134,215,297],[125,220],[126,309,310],[128,
135],[132,222],[134,310,315],[139,235],[141,189,294],[142,195,336],[145,317],
[150,319],[151,318],[152,249,318],[157,285],[158,318],[159,285],[160,252],
[161,169,284],[165,254],[168,319,322],[170,291],[171,292],[172,327],[175,318],
[176,256],[177,185,302],[179,327],[184,262,297,320],[188,266,308,324],[189,
328],[190,267],[191,268],[192,269],[193,271],[194,328],[195,320],[196,273],
[199,313,324],[200,279],[204,283],[206,329],[209,330],[211,329],[212,329],
[213,217],[220,333],[221,231],[222,228],[233,269],[234,268],[235,244],[236,
329],[239,271],[243,273,335],[248,335],[251,255],[252,256],[256,262],[261,265,
331],[267,274],[271,280],[276,283],[279,334],[285,287],[291,329],[292,329],
[294,296],[297,336],[304,336],[316,335],[318,320],[324,327],[329,331]]],[1,
[[1,8,33,34,63,67,81,206,224,249,250],[2,9,32,68,71,209,220,221,251],[3,11,38,
53,73,88,91,94,234,270,272,330,333],[4,8,29,34,102,110,206,217,287,299],[5,34,
102,110,287,310],[6,16,40,107,127,131,140,145,291],[7,20,42,114,131,140,145,
147,225,291,308],[8,12,51,101,152,166,255,286],[9,100,108,150,161,285],[10,55,
62,108,150,161,171,329],[11,16,107,157,172,174,179,291,299,319,321],[12,14,52,
67,106,107,149,206,249,259,299,319],[13,59,77,112,113,156,175,178,185,325,
332],[14,15,58,59,72,112,117,155,156,214,252,286,290],[15,60,82,121,163,169,
216,254,259,265,289,298,299,308,319,322,331],[16,23,189,192,194,333],[17,21,
67,107,127,149,311,319],[18,22,104,125,153,198,219],[19,27,77,113,130,156,198,
202],[20,77,156,175,192,194,201,325],[21,25,72,130,133,155,156,191,192,286,
290],[22,24,132,154,190,226,284,292],[23,26,131,157,225,291],[24,86,137,164,
197,198,202,227,288,302],[25,82,136,163,193,196,289,298,311,314,319,322],[26,
86,134,135,166,194,297,320,325,333,334],[27,28,89,138,174,190,292],[28,94,144,
182,197,198,202,204,282,302],[29,31,51],[30,50,211,216],[31,102],[32,35,100],
[33,101,208,219,223],[34,37,231,333],[35,44,68,105,209,220],[36,43,65,103,207,
208,219],[37,45,63,110,206,238],[38,67,107,206,224,236,242],[39,109,209,220,
221,235],[40,104,208,219,223,233,241],[41,69,114,212,224,225,236,242,247],[42,
77,113,223,233,241,246,332],[43,48,78,115,210,211,224,226,236],[44,49,70,111,
213,222,329],[45,47,75,116,214],[46,74,119,212,225,232,238,245,248],[47,84,
124,216,238,245],[48,87,122,215,218,227,229,237],[49,83,120],[50,54,252,253],
[51,52,205],[52,58,65,207],[53,63,206,249,250,257,263],[54,57,66,263],[55,68,
209,251,258],[56,74,212,250,257,263,264,266],[57,61,76],[58,60,78,210],[59,69,
212,259,265],[60,87,218],[61,80,217,263,264],[62,71,220,269],[63,75,152,270],
[64,79,153,207,219],[65,78,149,249],[66,76,151,270],[67,72,219,272,333],[68,
70,150],[69,91,156,272,281],[70,83,162,251,258,269],[71,161,222,267,329],[72,
82,224,225,226,236],[73,81,157,212,224,225,250,277],[74,88,158,270,276,278],
[75,84,160,250,257,268],[76,80,159,232],[77,89,225,275,277,280],[78,87,90,155,
252],[79,85,92,154,210,226],[80,167,231,240,270,278],[81,166,229,231,253,255,
270,272,330,333],[82,227,229,237,272,281,333,334],[83,168,261,271],[84,165,
253,260,270,273,278],[85,97,164,218,227],[86,169,228,230,254,274,275,277,331],
[87,93,163,254],[88,96,172,232,257,268],[89,94,175,234,282],[90,93,173,236],
[91,95,174,236],[92,97,176,233],[93,99,180,237,262],[94,179,243,274,275,277,
331],[95,182,237,272,281,282],[96,183,240,260,270,273,278,335],[97,98,181,
239],[98,186,246],[99,187,247,266],[100,105],[101,106,205,284],[103,115,127,
149],[104,284,292,295],[105,111,150],[106,117,153,207,208,219],[107,286,290,
303],[108,118,209,220],[109,126,285,294],[110,116,152,301],[111,120,162],[112,
157,212,225,291,299,308],[113,284,292,295,307],[114,130,156,286,290,303,306],
[115,122,133,155,286,290],[116,124,160],[117,121,154,210,211,226,284,292],
[118,161,213,222,285,294,329],[119,129,158,293,301,304,305],[120,168],[121,
164,215,218,227,288,302],[122,136,163,289,298],[123,169,217,228,287,296,299,
308,331],[124,165,301,305],[125,132,311],[126,128,220],[127,133,219],[128,222,
285,294],[129,141,225,309,310,313,315],[130,138,225,311,314],[131,134,223,
286],[132,137,139],[133,136,140,226],[134,145,230,289],[135,228,287,296,310,
313],[136,143,227],[137,146,228,311,314],[138,144,191,234,290],[139,146,190,
292],[140,143,192,233,290],[141,142,234,317],[142,243,296,310,313],[143,147,
193,239,298],[144,196,243,298,311,314,316],[145,194,241,297,303,333],[146,148,
197,244,302],[147,201,246,306],[148,203,248,307,314,316],[149,155],[150,162],
[151,159,321],[152,160,321],[153,154,249],[154,164,176,252],[155,163,173],
[156,174,319,322],[157,166,286,325],[158,172,321,323,324],[159,167,293],[160,
165,170],[161,251,318],[162,168,171],[163,180],[164,181,254],[165,184,321,
323],[166,287,289,299,319,321],[167,287,300,321,323],[168,177],[169,178,255,
288,320,325],[170,184,256,257,268,318],[171,177,258,269],[172,183,189,293],
[173,180,191,290],[174,182,192,290],[175,179,291,326],[176,181,190,292],[177,
261,271],[178,259,275,295,299,319,331],[179,194,297,320,325],[180,187,196,
298],[181,186,197,262,302],[182,193,298,319,322,326],[183,195,300,321,323,
336],[184,188,260,273],[185,265,280,307,322,326],[186,203,266,307],[187,200,
306],[188,264,279,323,336],[189,195,268,309,318],[190,197],[191,196],[192,
193],[193,201],[194,275,319],[195,199,273,312],[196,200],[197,203,274],[198,
275,295,311,319],[199,279,315,323,328,336],[200,314,316],[201,280,322,326],
[202,277,280,307,314,322],[203,204,276],[204,316],[205,207],[206,214,330],
[207,210],[208,211,249],[209,213,329],[210,218],[211,215,223,252],[212,330,
332],[213,221,251],[214,216,224,250],[215,230,254,331],[216,229,253,330],[217,
231,255,330],[219,226],[220,222],[221,285],[222,235],[223,230,284],[224,229,
286],[225,234,333,334],[226,227,233],[227,239],[228,244,333,334],[229,242,
289],[230,241,288],[231,238,287],[232,240,293],[233,239,292],[234,243,291],
[235,267,294,329],[236,237,290],[237,247,298,331],[238,270,301,330,333],[239,
246,302],[240,245,300],[241,275,295,331],[242,272,303,330,333],[243,297,333,
334],[244,248,274,296,331],[245,278,305,335],[246,280,307],[247,281,306,332,
334],[248,276,304,332,334],[249,252],[250,253],[252,254],[253,263],[254,262],
[255,259],[256,267,329],[257,260],[258,261,329],[259,272,330],[260,264],[262,
266,274,331],[263,270,330],[264,278],[265,281,332],[266,276,332],[267,318],
[268,273],[269,271],[270,321],[272,319],[273,279],[274,276,320],[275,333],
[276,324],[277,325,332,334],[278,323],[279,335],[280,282],[281,322],[282,326],
[283,327,335],[284,288],[286,289],[287,301],[288,295],[289,303],[290,298],
[291,297],[292,302],[293,300,309],[294,318],[296,304,320],[297,308,331],[298,
306],[299,330,333],[300,305,312],[301,310,321],[302,307,331],[303,311,319],
[304,313,324],[305,315,323,336],[306,314,322],[307,332],[308,325,332,334],
[309,312],[310,333],[311,333],[312,315],[313,334],[314,334],[315,317],[317,
328,336],[320,324],[327,328,336],[331,332],[335,336]]]]], 54,
[[[4],1,[5],[1,4],3,[1,5],2,[1,6],1,[2,3],1,[2,4],1,[2,5],2,[2,6],1,[3,4],3,
[3,5],6,[3,6],5,[3,7],1,[4,5],4,[4,6],9,[4,7],5,[5,6],[5,7],[1,2,3],[1,2,4],2,
[1,2,5],6,[1,2,6],6,[1,2,7],2,[1,3,4],[1,3,5],2,[1,3,6],2,[1,3,7],[1,4,5],6,
[1,4,6],14,[1,4,7],9,[1,5,6],3,[1,5,7],5,[1,6,7],[2,3,4],[2,3,5],8,[2,3,6],11,
[2,3,7],6,[2,4,5],[2,4,6],5,[2,4,7],3,[2,5,6],3,[2,5,7],5,[2,6,7],[3,4,5],2,
[3,4,6],10,[3,4,7],7,[3,5,6],6,[3,5,7],10,[3,6,7],2,[4,5,6],2,[4,5,7],6,[4,6,
7],3,[1,2,3,5],3,[1,2,3,6],4,[1,2,3,7],3,[1,2,4,5],1,[1,2,4,6],6,[1,2,4,7],5,
[1,2,5,6],5,[1,2,5,7],9,[1,2,6,7],3,[1,3,4,6],1,[1,3,4,7],1,[1,3,5,6],2,[1,3,
5,7],4,[1,3,6,7],1,[1,4,5,6],2,[1,4,5,7],7,[1,4,6,7],5,[1,5,6,7],[2,3,4,6],1,
[2,3,4,7],1,[2,3,5,6],5,[2,3,5,7],10,[2,3,6,7],4,[2,4,5,7],1,[2,4,6,7],2,[2,5,
6,7],[3,4,5,7],2,[3,4,6,7],3,[3,5,6,7],[1,2,3,5,6],1,[1,2,3,5,7],2,[1,2,3,6,
7],1,[1,2,4,5,7],[1,2,4,6,7],1,[1,2,5,6,7],[1,3,4,6,7],[1,3,5,6,7],[2,3,4,6,
7],[2,3,5,6,7]],[[1,[[1,4,6,15,16,23,44,45,48,51,58,99,140,187,189,200,202,
257,265,324,325,371],[2,6,16,22,44,46,48,93,118,144,173,187,195,202,237,258,
260,324,358,371,377],[3,9,32,41,42,52,63,68,127,139,143,177,179,209,215,222,
238,281,306,308,309,329,331,335,338,350,351,356,357,378],[4,24,66,96,98,107,
123,247,259,292],[5,23,67,85,94,114,246,257],[6,25,65,95,97,107,109,123,245,
262,293],[7,22,67,85,94,113,244,258],[8,29,74,88,93,94,113,126,132,244,258,
275,364],[9,28,71,74,86,88,93,99,106,125,128,129,274,284,302,311,313,364,365,
366,371],[10,27,74,88,94,99,114,126,133,246,257,273,365],[11,35,76,89,103,112,
113,126,132,135,275,290,364,369],[12,34,76,89,105,114,126,133,135,273,288,365,
370],[13,24,66,137,150,247,254,327,342],[14,25,64,65,136,138,141,145,150,155,
245,253,326,342],[15,66,137,166,327,350],[16,65,136,141,165,168,326,351],[17,
42,68,70,139,141,143,165,168,176,177,182,329,335,351],[18,41,68,137,139,166,
179,184,331,350],[19,43,70,139,169,179,181,330,339,350],[20,49,81,157,166,179,
184,331,349,352,355],[21,50,80,81,148,157,168,176,177,182,186,264,329,346,354,
378],[22,136,145,188,191],[23,136,138,188,196],[24,31,189,200,202,295,325],
[25,26,85,187,195,200,202,294,324],[26,36,87,95,138,139,145,188,245,303,342,
357],[27,41,138,139,188,196,211,226,331],[28,42,139,143,199,209,215,222,329,
335,342,356,357],[29,43,139,145,188,191,211,217,330],[30,88,93,144,187,195,
210,212,216,302,358,364],[31,38,98,143,247,300,342,356],[32,86,88,99,140,187,
189,200,212,213,224,365],[33,89,112,151,195,198,212,216,227,328,364,369,377],
[34,49,157,196,211,226,229,331,349],[35,54,157,190,191,211,217,229,330,348],
[36,40,90,91,101,146,147,151,192,194,195,200,210,212,213,250,324,332,364,365],
[37,89,91,105,151,156,192,198,200,212,213,214,224,227,228,359,365,370],[38,39,
89,104,151,198,200,212,249,325,333,365],[39,121,208,225,253,300,305,326,340,
342,346,356,362,368],[40,92,115,158,161,204,206,208,219,220,225,254,303,304,
327,334,342,346,357,361,367,368,375],[41,51,99,189,231,235,257],[42,48,93,99,
187,230,232,237,239,371],[43,46,93,231,233,258,358],[44,55,95,139,165,188,350,
357],[45,53,98,143,351,356],[46,60,109,169,190,191,263,307,330],[47,112,171,
198,230,237,240,328,377],[48,59,107,109,168,197,199,264,308,329],[49,62,105,
170,192,231,235,241,242],[50,103,105,192,198,214,230,232,239,240,243,359],[51,
57,107,166,193,196,261,306,331],[52,58,105,106,156,170,171,192,198,200,240,
241,265,324,325,359,372,377],[53,56,104,171,198,230,325,333],[54,112,170,178,
231,233,242,353],[55,61,101,167,170,192,194,231,232,324,332],[56,121,238,326,
340,351,354,356,362],[57,124,172,203,205,235,241,268,314,336],[58,123,208,270,
309,326,327,338,350,351,356,357],[59,118,124,175,201,202,237,239,240,316,341,
359,371,372,377],[60,118,173,207,233,266,312,343,353,358,360],[61,115,174,206,
234,236,327,334,350,352,357,361],[62,63,127,179,209,306,331,355],[63,129,185,
218,235,241,314,323,336],[64,67,85,244,246,250],[65,73,257,258,260,265,269,
371],[66,72,265,267,371],[67,69,136,262],[68,99,140,257,265,273,274,280,365,
371],[69,79,94,142,244,246,257,258],[70,93,144,258,260,274,275,282,284,364,
371],[71,98,143,247,259,277,285],[72,77,96,137,247,283],[73,75,97,141,245,
285],[74,95,139,245,262,276,283],[75,84,111,153,250,260,265,274,364,365],[76,
108,157,248,262,264,276,283,291],[77,83,110,152,249,265,273,365],[78,102,148,
248,259,264,272,277,285,289,373],[79,82,100,149,251,252,261,262,263,276],[80,
103,154,260,275,282,290,364,369],[81,105,156,265,273,274,280,288,365,370,372,
374],[82,116,162,255,256,266,267,268,279],[83,122,164,253,270,283,286,291,
368],[84,120,160,254,270,271,281,285,289,367,368,373],[85,87,293],[86,96,247,
292,298,303],[87,90,94,244,246],[88,97,245,293,297,300],[89,102,248,293,297,
300,305],[90,92,100,251,252,293,297],[91,108,248,292,296,298,303,304,375],[92,
116,255,256,295,299],[93,109,307,308,310,315],[94,100,188],[95,101,257,258,
313,371],[96,110,189,313],[97,111,187,311],[98,104,311,371],[99,107,306,308,
309],[100,116,126,194],[101,115,261,262,263,264,276,306,307,308],[102,125,198,
311,322],[103,190,296,307,310,321,375],[104,121,259,264,277,308],[105,127,264,
306,308,309,317,318,319],[106,123,199,248,259,262,264,292,293,319,373,375],
[107,124,200,265,365],[108,128,192,313,320],[109,118,195,260,364],[110,122,
193,292,298,306],[111,120,197,293,297,308],[112,264,272,308,315,317,373],[113,
119,191,252,262,263,293],[114,117,196,251,261,262,293],[115,266,267,268,279,
312,313,314,316,320,371,372],[116,134,206],[117,133,205,256,267,268,295],[118,
204,271,310,315,367,373,375],[119,132,207,255,266,267,295],[120,201,295,299,
311,316,322],[121,269,287,311,316,322,371,372],[122,203,294,301,313,314,320],
[123,202,267,269,294,295,311,313,366,371],[124,208,270,309,319,368],[125,131,
215,272,277,297,308],[126,134,211,276,297,308],[127,129,214,274,323,365,374],
[128,130,209,276,296,298,306,307],[129,222,281,309,319,368],[130,218,279,301,
302,312,313,314,320,323,376],[131,223,284,287,299,311,316,322,374],[132,217,
278,283,300,310,315,367],[133,226,283,286,300,309,368],[134,135,221,279,299,
316],[135,229,291,305,317],[136,142,324],[137,152,189,337],[138,146,246,257],
[139,324,332,337],[140,150,245,247,329,331,338,342],[141,153,187,344],[142,
149,165,188],[143,325,333,344],[144,155,245,329,330,335,339,342,367],[145,147,
244,258],[146,161,196,251,261,331],[147,158,191,252,263,330],[148,171,198,325,
328,333,344,345,377],[149,162,167,194,324,332],[150,163,200,249,250,265,324,
325,365],[151,199,248,264,329,342,346],[152,164,166,193,331],[153,160,168,197,
329],[154,169,190,330,339,348],[155,159,195,250,260,324,364,369,377],[156,248,
329,331,338,346,349,378],[157,170,192,324,332,337,347],[158,207,255,266,343],
[159,204,254,271,327,339,342,367],[160,175,201,341,344,345,377],[161,205,256,
268,336],[162,174,206,327,334],[163,208,253,254,270,326,327,338,342,346,368],
[164,172,203,336,337,347],[165,167,257,258],[166,172,265,324],[167,174,176,
261,263],[168,175,260,265,324,325,377],[169,173,260,324,353],[170,179,264,350,
352],[171,177,264,351,354],[172,184,270,327,350,352],[173,271,327,339,350],
[174,180,266,268],[175,182,270,271,326,327,351,354],[176,180,232,273,275,332],
[177,183,230,274,328,333],[178,181,272,330,355],[179,185,231,274,332],[180,
186,236,278,286,334],[181,233,284,343,353],[182,239,280,282,337,341,344,371],
[183,238,281,335,340,351,354,378],[184,235,280,336,337],[185,234,281,334,350,
352,355],[186,243,288,290,347],[187,197,356],[188,194],[189,193,357],[190,210,
358,360],[191,207,324],[192,209,357,361],[193,203,213],[194,206,211],[195,204,
293,375],[196,205,324],[197,201,212],[198,215,356,362],[199,202,324,325,359,
377],[200,208,292,293],[201,225,356,362],[202,326,327,342,356,357],[203,220,
357,361],[204,216,295,358,377],[205,226,327],[206,221],[207,217,327],[208,224,
294,295,359],[209,218,232,332],[210,219,296,307,330],[211,221,231,332],[212,
225,297,308,329],[213,220,298,306,331],[214,222,296,329,363,378],[215,223,230,
328,333],[216,300,315,335,342,356,367],[217,233,337,343,358],[218,236,334,357,
361,363],[219,302,312,343,358,360,376],[220,228,301,314,336],[221,229,234,
334],[222,239,302,341,359],[223,238,335,340,356,362,378],[224,300,303,309,338,
342,356,357,368],[225,227,299,316,341],[226,235,336,337],[227,305,317,346,362,
378],[228,304,318,349,361,363],[229,242,347],[230,238,308],[231,234,308],[232,
236,306,307],[233,315,350],[234,242,316],[235,309,350,357],[236,243,312,314],
[237,315,335,351,356],[238,240,316],[239,309,310,356,357],[240,317,354,362,
378],[241,318,319,349,352,361],[242,317,352,355],[243,318,321,361,363],[244,
252],[245,250,364,365,366],[246,251],[247,249,365,366],[248,364,365,366,369,
370],[249,253,259,292],[250,254,262,293],[251,256,365],[252,255,364],[253,269,
294,366,369],[254,267,295,366],[255,367],[256,368],[257,261],[258,263],[259,
269,325],[260,271,373],[261,268,273],[262,267,324],[263,266,275],[264,274,371,
372],[265,270],[266,278],[267,283,327],[268,286],[269,285,326,373],[270,280,
371,372],[271,282,371],[272,284,328,364,374],[273,286,306,331],[274,281,308,
329],[275,278,307,330],[276,279,332,364,365],[277,287,333,365],[278,290,312,
343],[279,291,334,367,368],[280,309,338,368],[281,316,341,371,372,374],[282,
310,339,367],[283,313,337,366,371],[284,315,335,367,373],[285,311,344,366,
371],[286,288,314,336],[287,289,340,368],[288,318,349],[289,322,345,370,372,
374],[290,321,348],[291,320,347,369,370,372],[292,294],[293,295],[294,303,
375],[295,300],[296,302,364,376],[297,299,364,365],[298,301,365],[299,305,367,
368],[300,311,366],[301,304,368],[302,310,367,375],[303,313,366],[304,320,370,
376],[305,322,369,370],[306,314],[307,312],[308,316],[309,371],[310,358],[311,
356],[312,321],[313,357],[314,318],[315,371],[316,317],[317,372,374],[318,
323],[319,359,370,372],[320,361,375],[321,360,376],[322,362,373],[323,363],
[324,327],[325,326],[326,344,377],[327,337],[328,335,378],[329,341,364,365],
[330,343,364],[331,336,365],[332,334],[333,340],[334,347],[335,377],[336,349,
368],[337,350,357],[338,366],[339,358],[340,345],[341,346,367,368,378],[342,
366,371],[343,348,367],[344,351,356],[345,354,362,378],[346,359,369,370,372,
377],[347,352,361],[348,353,360,369],[349,370],[350,371],[351,371],[352,372],
[353,373],[354,372,377],[355,374],[359,375],[360,375],[362,377],[363,376],
[364,367],[365,368],[367,369],[368,370],[369,373,375],[373,377],[374,378]]]]],
[[[4],1,[5],[1,2],[1,4],3,[1,5],3,[1,6],[2,3],2,[2,4],2,[2,5],3,[2,6],2,[2,7],
[3,4],3,[3,5],7,[3,6],5,[3,7],2,[4,5],5,[4,6],9,[4,7],6,[5,6],1,[5,7],1,[1,2,
3],1,[1,2,4],3,[1,2,5],7,[1,2,6],8,[1,2,7],3,[1,3,4],1,[1,3,5],4,[1,3,6],4,[1,
3,7],2,[1,4,5],7,[1,4,6],15,[1,4,7],11,[1,5,6],5,[1,5,7],6,[1,6,7],1,[2,3,4],
1,[2,3,5],8,[2,3,6],12,[2,3,7],6,[2,4,5],1,[2,4,6],6,[2,4,7],4,[2,5,6],3,[2,5,
7],5,[2,6,7],1,[3,4,5],3,[3,4,6],10,[3,4,7],8,[3,5,6],7,[3,5,7],10,[3,6,7],4,
[4,5,6],3,[4,5,7],6,[4,6,7],5,[5,6,7],[1,2,3,5],2,[1,2,3,6],4,[1,2,3,7],2,[1,
2,4,5],[1,2,4,6],5,[1,2,4,7],4,[1,2,5,6],4,[1,2,5,7],9,[1,2,6,7],3,[1,3,4,6],
1,[1,3,4,7],1,[1,3,5,6],1,[1,3,5,7],3,[1,3,6,7],1,[1,4,5,6],1,[1,4,5,7],5,[1,
4,6,7],5,[1,5,6,7],[2,3,4,6],1,[2,3,4,7],1,[2,3,5,6],4,[2,3,5,7],10,[2,3,6,7],
4,[2,4,5,7],1,[2,4,6,7],1,[2,5,6,7],[3,4,5,7],1,[3,4,6,7],2,[3,5,6,7],[1,2,3,
5,6],[1,2,3,5,7],2,[1,2,3,6,7],[1,2,4,5,7],[1,2,4,6,7],[1,2,5,6,7],[2,3,5,6,
7]],[[1,[[1,7,8,17,19,30,51,53,61,62,65,120,173,226,227,239,245,303,309,361,
362,402],[2,18,28,49,58,69,122,135,144,177,210,236,305,391],[3,10,11,23,39,50,
54,63,73,75,89,154,175,178,217,253,254,262,278,283,321,346,347,351,365,367,
379,387,391,392,405],[4,5,14,85,86,90,99,297,309,312,397,400,402],[5,28,107,
119,122,134,135,143,148,335],[6,30,78,79,103,104,121,124,126,292,303],[7,31,
81,119,125,294,308,335],[8,29,80,118,123,135,144,293,306,334],[9,38,88,105,
121,124,126,155,157,160,292,303,316],[10,37,85,87,108,120,138,156,159,164,348,
349,397,399],[11,35,88,105,120,127,158,164,317,353,397,400,402],[12,34,107,
122,134,161,315,323],[13,40,95,114,126,155,157,160,167,168,316,332],[14,18,28,
174,177,183,190,197,302,363,375],[15,29,76,80,170,171,176,190,198,293],[16,31,
77,81,169,171,174,294,301,363],[17,81,169,174,200,206,363,387],[18,21,207,212,
309,313,362,402],[19,80,170,176,201,204,210],[20,54,174,178,200,206,216,217,
219,365,387],[21,26,49,89,174,175,177,200,215,218,320],[22,50,89,176,178,201,
204,214,218,367],[23,52,85,203,221,366,370],[24,55,180,206,216,217,219,225,
365,383,389,390],[25,59,92,180,186,204,214,215,218,224,304,367,385,388,405],
[26,27,57,97,184,191,208,309,316,362,368,397],[27,66,196,198,213,218,224,311,
320,329,331,364,377,385,398],[28,36,227,231,239,244,245,337],[29,32,104,226,
239,246,362],[30,169,170,171,228,229,232],[31,33,103,227,336,361],[32,44,109,
118,171,175,229,261,293],[33,41,106,125,171,178,228,294,343,392],[34,52,231,
259,366,374],[35,50,178,237,253,262,367,375,392],[36,45,107,122,177,260,340,
375,391],[37,49,175,177,236,252,254,261,262,391],[38,54,171,178,228,229,232,
251,256,265,365],[39,105,108,120,173,226,227,239,250,255,268,397],[40,55,180,
232,251,256,265,269,273,365,383],[41,46,111,114,140,182,235,238,250,297,361,
369],[42,113,114,130,185,188,234,235,239,250,255,257,268,270,271,394,397,401],
[43,141,192,236,252,261,272,299],[44,48,110,137,182,233,239,250,296,362,368,
397],[45,47,112,113,131,188,191,231,234,239,255,270,366,397],[46,117,151,195,
241,266,301,343,345,363,378,392,395],[47,116,150,198,242,248,260,340,344,373,
375,385,391,393,398],[48,115,145,195,242,243,261,266,272,302,364,377,398],[49,
57,120,227,274,284,349],[50,61,120,226,276,284,402],[51,60,118,175,200,229,
278],[52,58,122,283,386,391],[53,56,125,178,201,228,387,392],[54,62,227,275,
277,282,303],[55,72,205,235,275,277,282,286,287,289],[56,70,140,202,205,235,
238,276,277,361,369],[57,66,135,141,230,236,252,347],[58,68,131,203,207,231,
234,274,288,366],[59,130,234,235,257,274,276,284,285,288,394],[60,71,137,208,
233,275,362,368],[61,69,135,204,237,240,304,346,367],[62,67,206,230,232,307,
347,365],[63,65,127,130,138,185,203,205,234,235,239,286,288,309,361,362,394,
403],[64,73,141,192,278,290],[65,143,144,210,242,278,311,351,363,364,379,387,
391,392],[66,146,246,247,258,284,285,349,352,358,394],[67,211,247,249,282,286,
310,352,371],[68,150,210,248,283,373,386,388,391,393],[69,146,212,244,245,284,
288,350,376,394,402,403],[70,151,209,241,279,280,363,378,387,389,392,395],[71,
145,213,243,278,281,290,364,377],[72,75,217,253,291,347,365,390],[73,74,159,
275,368],[74,162,278,281,290,291,377],[75,222,264,282,286,352,360,371],[76,79,
104,292,297],[77,78,103,292],[78,84,169],[79,82,170,308],[80,83,303,309,314],
[81,86,303,312],[82,96,124,172,292,303],[83,91,123,176,293,325],[84,94,121,
179,292,303],[85,122,177,305,315,321,325],[86,98,119,174,294,327],[87,118,175,
293,306,318,320],[88,125,178,294,308,319,327],[89,120,173,303,309,316,317,324,
397,402],[90,134,183,298,304,315,323,333],[91,99,133,187,296,309,317,397],[92,
130,185,309,316,317,324,332,397,401,403,404],[93,139,186,299,305,315,325,333],
[94,102,128,181,295,307],[95,136,180,308,319,327,330],[96,101,129,189,295,307,
308,319],[97,141,192,299,306,318,320,331],[98,100,132,184,297,316],[99,148,
197,302,311,321,325,333,398],[100,142,196,301,327,329,330],[101,153,199,300,
310,312,326],[102,147,193,300,310],[103,106],[104,109,335],[105,119,294,335,
338,343],[106,111,124,292],[107,112,341,397,400],[108,123,293,334,339,340],
[109,110,121,292],[110,115,128,295,335,338],[111,117,129,295],[112,116,134,
298,335,344],[113,139,299,334,339,340,344],[114,136,335,338,343,345],[115,147,
300,336,342],[116,152,336,400],[117,153,300],[118,137,303,349],[119,132,227,
353],[120,135,346,347,351],[121,128,229],[122,131,348,350,402],[123,133,226,
348],[124,129,228],[125,140,303,353],[126,149,232,295,307,308,335],[127,143,
237,298,304,308,335,357],[128,147,157,233],[129,153,155,238],[130,154,304,346,
347,351,354,357,359],[131,150,304,305,315,346,354],[132,142,230,335,338,347],
[133,148,240,334,339,346],[134,152,231,355],[135,146,239,309,397],[136,158,
235,353,356],[137,145,306,307,318,347],[138,144,236,299,305,306,334,357],[139,
156,234,348,355],[140,151,307,308,319,347],[141,159,349,358],[142,247,336,342,
352,353,356],[143,245,312,336,353,400,402],[144,246,313,314,337,348,349,399],
[145,310,313,322,349,352,358],[146,242,311,351,357,398],[147,165,243],[148,
244,337,341,348,350,355],[149,160,249,300,310,312,336],[150,314,328,348,350,
355,402,403],[151,310,312,326,352,353,356],[152,248,323],[153,166,241],[154,
164,257,317,360,397,404],[155,166,256,319],[156,161,254,315,339,346],[157,165,
251,338,347],[158,163,253,319,338,347],[159,162,252,318,347],[160,265,327,329,
343],[161,259,328,341,348,350,355,404],[162,258,322,349,352,358,360],[163,264,
326,342,352,353,356,360],[164,262,321,351,357,398],[165,167,263,342,352],[166,
168,267,326],[167,269,345,359],[168,273,330],[169,179],[170,172,361],[171,182,
292,303],[172,189,201,228],[173,190,293,294,365,367,375,379],[174,184,227,
380],[175,362,368,372],[176,187,226,370],[177,191,366,370,376,397,399],[178,
361,369,380],[179,181,200,229],[180,205,235,361,369,380,384],[181,193,208,
233],[182,195,232,295,307,365],[183,207,231,366,374,382],[184,196,206,230,
365],[185,298,299,365,367,379,383,385,405],[186,203,234,366,370,382],[187,197,
204,240,367],[188,237,298,304,367,375,385],[189,199,202,238,361,369],[190,194,
239,296,297,309,361,362,397],[191,198,236,299,305,385],[192,362,368,372,381],
[193,213,243],[194,242,301,302,311,363,364,375,379,385,398],[195,249,300,310,
371],[196,211,247,371,380,384],[197,212,244,370,376,382],[198,246,314,370,
399],[199,209,241,363,378],[200,208,303],[201,202,303],[202,209,214,307],[203,
210,305,388],[204,212,309,361],[205,217,387,389],[206,211,361],[207,215,304,
386,388],[208,213,216,307],[209,223,310],[210,314,370],[211,219,363,387,389],
[212,218,311,363,388],[213,220,310],[214,223,276,316,369],[215,221,274,317,
366],[216,220,275,316],[217,222,277,369],[218,284,324,370,376,380,402],[219,
282,371,380],[220,225,281,329],[221,283,321,373,386,388,405],[222,279,378,387,
389,390],[223,224,280,329,378],[224,285,332,384],[225,287,332],[226,240,391],
[227,230,392],[228,238],[229,233],[230,247,250],[231,248,393],[232,249,361],
[233,243,251],[234,254,391,393],[235,253,392,395],[236,246,362,394],[237,245,
361,394],[238,241,256],[239,242,334,335],[240,244,255],[241,267],[242,268,336,
337,394],[243,263],[244,260,391,393],[245,363,375,392],[246,261,364,391],[247,
266,392,395],[248,374],[249,265,363],[250,266,338,347,365],[251,263,275],[252,
258,368,397],[253,264,276,369],[254,259,274,366],[255,260,339,346,367],[256,
267,277,369],[257,262,367,396,405],[258,272,377,396,398],[259,283,373,391,393,
405],[260,270,341,350,376],[261,349,372,399],[262,284,376,394],[263,269,281],
[264,280,378,392,395,396],[265,282,371,380],[266,271,342,352,371],[267,273,
279,378],[268,340,343,351,375,379,391,392,398],[269,287],[270,344,354,385,393,
405],[271,345,359,383,395,396],[272,358,381,394,401],[273,289,384],[274,283,
346],[275,281,347],[276,280,347],[277,279],[278,349,372],[279,289],[280,285,
352],[281,287,352],[282,387,392],[283,288,350],[284,351,391,392],[285,359,395,
396],[286,359,383,389,395],[287,291,359],[288,354,388,393,405],[289,389,390],
[290,358,381],[291,360],[292,295],[293,296,397,399],[294,297],[295,300],[296,
302,306,334],[297,301,308,335],[298,397,400,401],[299,397,399,401],[301,312,
336],[302,313,337,399],[303,307],[304,317,402,403],[305,314,403],[306,313,
362],[307,310,316],[308,312,361],[309,311],[310,329],[311,324,402,403],[312,
327,363],[313,320,364],[314,325],[315,328,366,397,404],[316,329,347,365],[317,
321,346,367],[318,322,368,397],[319,326,369],[320,349,372,399],[321,350,376,
402,403,404],[322,331,377,398],[323,374,400,402],[324,351,379,398],[325,348,
370,399],[326,330,378],[327,353,380],[328,333,373,398],[329,332,352,371],[330,
356,384],[331,358,381,401],[332,359,383],[333,355,382,401,403,404],[334,337],
[335,336],[336,343],[337,340],[338,342],[339,341,397],[340,348,399],[341,344,
398],[342,345],[343,353],[344,355,401],[345,356],[346,350],[347,352],[348,
391],[350,354],[351,402],[352,359],[353,392],[354,403,404],[355,393],[356,
395],[357,394,401,403],[359,360],[360,396],[361,363],[362,364],[363,380],[364,
372],[365,371],[366,373,405],[367,376,397],[368,377],[369,378],[370,391],[371,
383],[373,382],[374,386],[375,400,402],[376,385,398,405],[377,381],[378,384],
[379,399,400],[380,387,392],[382,388,393,405],[384,389,395],[385,394,401,403],
[386,402],[388,403],[397,398],[398,401],[404,405]]],[2,[[7,135,143],[9,87,108,
120,397],[13,97,113,130,397,401],[16,190,375],[20,89,175],[24,92,192],[31,239,
245],[33,375],[38,175],[40,192],[41,188,239,255,397],[46,242,260,375,385,398],
[54,120],[55,130],[62,135],[67,146],[72,154],[75,164],[77,296],[78,306],[81,
309,402],[94,306,318],[95,298,304],[98,309,397],[100,311,398],[102,313,322],
[103,334],[111,334,339],[114,298],[117,337,341],[125,402],[126,306,334],[140,
304,346],[149,313,337],[151,350,402,403],[155,339,346],[157,318],[160,320,340,
351,398],[165,322],[166,341,350],[167,331],[168,344,354],[169,362],[181,362,
368],[193,364,377],[205,304],[206,309,362],[211,311,364],[216,368],[217,317],
[219,324,372],[220,377],[222,321],[225,381],[232,362],[249,364],[251,368],
[263,377],[265,372],[269,381],[277,346],[279,350],[282,351],[286,357],[289,
354],[294,397,400],[295,397],[300,398],[301,400],[319,397],[326,398],[327,400,
402],[330,401,403],[338,397],[342,398],[343,400],[345,401],[365,397],[371,
398],[383,401],[387,402],[389,403],[390,404]]]]], 55,
[[[4],[1,4],2,[1,5],1,[1,6],[2,3],[2,4],[2,5],1,[2,6],[3,4],2,[3,5],4,[3,6],3,
[3,7],[4,5],3,[4,6],7,[4,7],3,[5,6],[5,7],[1,2,3],1,[1,2,4],3,[1,2,5],6,[1,2,
6],6,[1,2,7],2,[1,3,4],1,[1,3,5],3,[1,3,6],3,[1,3,7],1,[1,4,5],7,[1,4,6],14,
[1,4,7],9,[1,5,6],4,[1,5,7],5,[1,6,7],1,[2,3,4],2,[2,3,5],9,[2,3,6],11,[2,3,
7],6,[2,4,5],2,[2,4,6],6,[2,4,7],4,[2,5,6],4,[2,5,7],5,[2,6,7],1,[3,4,5],4,[3,
4,6],11,[3,4,7],8,[3,5,6],7,[3,5,7],10,[3,6,7],3,[4,5,6],3,[4,5,7],7,[4,6,7],
4,[5,6,7],[1,2,3,4],[1,2,3,5],4,[1,2,3,6],5,[1,2,3,7],4,[1,2,4,5],2,[1,2,4,6],
7,[1,2,4,7],6,[1,2,5,6],6,[1,2,5,7],10,[1,2,6,7],4,[1,3,4,5],[1,3,4,6],2,[1,3,
4,7],2,[1,3,5,6],3,[1,3,5,7],5,[1,3,6,7],2,[1,4,5,6],3,[1,4,5,7],8,[1,4,6,7],
6,[1,5,6,7],1,[2,3,4,6],2,[2,3,4,7],2,[2,3,5,6],6,[2,3,5,7],11,[2,3,6,7],5,[2,
4,5,6],[2,4,5,7],2,[2,4,6,7],3,[2,5,6,7],1,[3,4,5,6],[3,4,5,7],3,[3,4,6,7],4,
[3,5,6,7],1,[4,5,6,7],[1,2,3,5,6],1,[1,2,3,5,7],2,[1,2,3,6,7],1,[1,2,4,5,7],
[1,2,4,6,7],1,[1,2,5,6,7],[1,3,4,6,7],[1,3,5,6,7],[2,3,4,6,7],[2,3,5,6,7]],
[[1,[[1,4,9,13,28,33,34,79,110,128,169,186,195,204,245,269,272,352,394,413,
419],[2,14,47,67,80,83,95,102,256,270,273,313],[3,13,48,68,84,98,255,269],[4,
15,46,49,82,85,95,102,254,278,310,311],[5,18,50,53,69,71,86,88,112,113,121,
288,330,340,341,407,410,413],[6,19,50,69,79,84,98,115,122,255,269,292,406],[7,
21,63,74,92,93,98,115,122,124,292,307,406,411],[8,15,44,46,126,135,143,254,
267,355,369],[9,46,49,126,135,157,163,166,355,386],[10,29,52,130,160,176,181,
360,376,384],[11,26,54,130,135,157,163,174,175,182,363,386],[12,35,59,149,163,
175,182,183,274,363,378],[13,126,134,187,190],[14,125,136,188,189,200,204,
354],[15,20,68,127,186,200,204,315,352],[16,71,86,132,136,188,200,217,226,
407],[17,69,79,128,186,195,212,218,220,324,394,406],[18,26,130,133,191,211,
214,222,363,369,393,395,396],[19,29,130,134,187,190,213,225,360],[20,24,72,85,
129,130,187,254,310,321,369,396],[21,31,149,190,199,213,225,231,360,382],[22,
74,93,139,195,198,212,220,233,364,406,411,419],[23,76,97,139,140,194,200,215,
217,226,230,400,407,412],[24,25,75,76,87,139,148,194,197,200,212,217,259,312,
352,358,407],[25,77,108,156,206,209,219,227,265,316,321,329,356,369,372,378,
396,402,409],[26,33,86,159,186,236,237,239,413],[27,32,86,132,158,185,188,240,
271],[28,37,85,130,157,187,384,396],[29,34,79,235,238,269,394],[30,42,97,140,
161,194,240,249],[31,93,161,173,235,238,247,390],[32,41,95,162,193,196,234,
279,333,353,362],[33,40,95,163,166,191,201,274,332,363,393],[34,38,94,160,190,
199,275,331,360],[35,97,194,215,237,239,248,400],[36,93,165,198,236,245,250,
364,419],[37,39,87,161,164,194,197,235,237,352,358],[38,110,169,207,238,286,
342,365,390,394,398],[39,108,167,206,242,243,356,372,384,387,396,402],[40,111,
170,171,202,204,239,250,335,370,397,400,413,415],[41,111,168,205,208,240,241,
249,282,338,357,375],[42,43,116,176,211,234,333,362],[43,121,177,229,240,241,
249,251,338,350,375],[44,48,68,253,259],[45,47,67,256,263,265],[46,56,277,283,
413],[47,51,125,276,280],[48,55,126,252,278],[49,127,253,271,276],[50,85,130,
254,278,293,295],[51,60,83,137,256,270,295],[52,79,128,269,272,288,292,300,
304,406,413],[53,80,133,256,270,273,287,291,296],[54,86,132,253,271,276,289,
303,407],[55,57,84,131,253,257,271],[56,61,82,135,254,291,296],[57,66,89,141,
262,263,278,279,293],[58,99,142,261,273,274,287,291,296,305,308],[59,97,140,
276,289,303,306,407,412],[60,65,96,146,260,276,277,289,407],[61,64,101,144,
259,288],[62,92,138,272,292,300,307,406,411],[63,91,149,261,274,278,293,295,
309],[64,106,150,265,296,298,305],[65,103,151,267,284,285,295,299,309,409],
[66,109,154,264,266,280,282,302],[67,70,312,314],[68,72,252,310,311],[69,82,
254,310,311,319,320,322],[70,73,80,256,319,322],[71,83,256,313,318,321],[72,
75,84,257],[73,78,90,260],[74,99,261,311,319,320,322,327,328],[75,77,89,262,
311,320],[76,91,261,313,318,321,329],[77,109,266,314,326],[78,104,267,322,
327],[79,94,331,332,336,339],[80,90,189,330,340],[81,100,185,257,271],[82,101,
186,330,340],[83,96,188,341],[84,89,187,310],[85,87,271,341,413],[86,95,270,
310,333,337],[87,108,274,278,279,293,332,333],[88,102,191,261,273,274,278,311,
313,343],[89,109,115,197,312],[90,104,192,273,287],[91,113,194,341,349],[92,
199,317,331,339,344,417],[93,274,290,332,336,348,414],[94,110,195,272,406],
[95,111,200,276,277,312,330,407],[96,103,193,313,318,333],[97,116,274,333,337,
343,345],[98,107,190,258,275,278,311],[99,112,198,330,340,346,347],[100,105,
114,196,262,279],[101,106,201,311,320,332],[102,204,280,283,314,315,340,341,
410,413],[103,208,315,323,338,341,349],[104,210,283,297,340,346],[105,118,205,
266,282],[106,202,314,326,335,340,346],[107,122,207,268,280,286,314],[108,280,
282,302,335,338,341,349,413,415],[109,120,206,316],[110,203,281,336,339,408,
414,417],[111,209,284,285,316,334,337,343,409],[112,117,214,287,320,332,351],
[113,119,211,293,318,333],[114,118,216,289],[115,120,213,293,319,320,332],
[116,121,215,288,330,350,407],[117,221,297,326,335,340,346,416],[118,123,224,
299],[119,229,302,323,338,341,349,350],[120,124,228,302,325,326,335],[121,222,
298,334,337,343,351,409],[122,225,294,295,322,336,339,408],[123,232,306],[124,
231,309,327,328,348],[125,137,353,356],[126,131,352],[127,129,252,353],[128,
145,254,360,363,368,369,376,408],[129,148,185,253,257,271],[130,352,358,374],
[131,141,157,187],[132,353,362,371],[133,159,189,354,359,361,367],[134,147,
255,269],[135,144,186,253,361,367],[136,143,256,270,369],[137,146,158,188,
374],[138,160,199,360,376,382],[139,191,261,274,363,369,378],[140,353,362,371,
381],[141,154,164,197,352,358],[142,165,198,354,359,361,367,377,380],[143,155,
200,260,277,354,361,407],[144,150,163,201,263,363],[145,152,195,259,272,352,
406,411,419],[146,151,162,193,353,362],[147,153,190,258,275,360],[148,156,196,
262,263,279,353,362],[149,161,194,352,358,374,379],[150,170,202,264,367,370,
377],[151,168,208,357,374,375,379],[152,203,265,281,356,369,376,408],[153,207,
268,286,365],[154,167,206,356,372],[155,209,267,285,355,366,369,378,409],[156,
205,264,266,282,357,375],[157,164,271],[158,162,270,384],[159,166,270,383,
386],[160,169,272,352,390],[161,176,274,384,387],[162,168,172,277],[163,170,
276,352],[164,167,175,279],[165,174,274,383,386,388,389],[166,171,277,354,
361],[167,180,282],[168,179,285,384,387],[169,281,356,376,384],[170,182,284,
356,386,389],[171,285,355,366,386,388],[172,179,234,291,362],[173,181,290,360,
391],[174,178,236,288,361,392],[175,180,237,289,358],[176,177,235,288,358],
[177,242,298,372,384,387,391],[178,244,298,366,386,388,420],[179,184,241,301,
375],[180,183,243,299,372],[181,238,304,365,390],[182,239,303,370,374,392,
413],[183,248,306,379],[184,246,308,381,387,391],[185,196,310],[186,201,310,
393,395],[187,197],[188,193,396],[189,192,393,395],[190,207,352],[191,204,352,
354,400],[192,210,354,359],[193,208,217],[194,211,396,402],[195,203,311,417],
[196,205,216,312],[197,206,213],[198,214,393,395,399,401],[199,218,394,398],
[200,209,313,353,393],[201,202,212,312],[202,227,316,395,401],[203,220,314,
394,419],[204,355,356,369,395,396],[205,224,316],[206,228],[207,225,356],[208,
219,396,402],[209,226,315,357,397,400],[210,355,373,395,401],[211,229,237,
358],[212,227,319,320,332,363,393],[213,228,235,358],[214,221,236,359,403],
[215,222,363,393,404],[216,224,234,319,362],[217,219,318,333,362],[218,223,
317,331,360],[219,230,323,338,375],[220,322,336,368,369,395,408],[221,244,373,
395,401,420],[222,239,370,397,400,403],[223,324,342,365,394,398,418],[224,232,
241,325,375],[225,238,365,374,394],[226,321,337,369,371,396,409],[227,233,325,
326,335,370,397],[228,231,242,372],[229,243,372,396,402,404],[230,329,345,381,
402,404],[231,247,379],[232,246,328,381],[233,327,328,348,378,399,401,420],
[234,241,330],[235,242,332],[236,244,332,383,393,405],[237,243,333],[238,336,
384],[239,337,396,405],[240,337,371,384,396],[241,246,334],[242,247,335],[243,
248,338],[244,250,335,385,397],[245,336,368,386,395],[246,251,347],[247,348,
387,391],[248,345,402,404],[249,343,345,381,387,402],[250,348,388,389,399,401,
405,420],[251,351,391],[252,257],[253,263,310],[254,259,407,410],[255,258],
[256,260,407,410],[257,262],[258,268,406],[259,265,278,311],[260,267,273,313],
[261,407,410,412],[262,266],[263,264,276,312,407],[264,284,316,409],[265,280,
314,410],[267,283,315,410],[268,408],[269,275],[270,277,413],[271,279],[272,
281,414],[273,283,354],[274,288,413,415],[275,286,292],[276,284,353],[277,285,
291],[278,280,352],[279,282,289],[280,295,356],[281,300,413],[282,299],[283,
296,355],[284,303,357],[285,301,413,415],[286,294],[287,297,359],[288,298,332,
363],[289,299,333,362],[290,304,364,406,416],[291,301,330,361,407],[292,294,
331,360],[293,302,358,407],[294,307,342,365],[295,341,374,410,413],[296,340,
367,410,413],[297,305,373],[298,335,370,413,415,416],[299,306,338,375],[300,
339,376,408],[301,308,334,366,409],[302,309,372,409],[303,337,371,409],[304,
336,368,408,414],[305,346,377,416],[306,345,381],[307,344,382],[308,347,380,
412,415,416],[309,349,379,412,415],[310,312],[311,314],[312,316,319],[313,
315],[314,322],[315,321],[316,325],[317,324,406,418],[318,323,407],[319,325,
330,407],[320,326],[321,341,410],[322,340,410],[323,329,409],[324,339,408,
417],[325,328,334,409],[326,327],[327,346],[328,347,412],[329,349,412],[330,
334,393],[331,342],[332,335],[333,338],[334,347,397],[335,348],[336,413],[337,
413],[338,345],[339,394],[340,395],[341,396],[342,344],[343,400,412,415],[344,
398,418],[345,350],[346,401],[347,351,399],[348,415,416],[349,402],[350,404],
[351,403,416],[352,356],[353,357],[354,355],[355,367],[356,374],[357,371],
[358,372],[359,373,383],[360,365,406],[361,366,393],[362,375,407],[363,370,
407],[364,368,420],[365,382,408],[366,380,397],[367,386,395],[368,419],[369,
410,413],[370,378,409,420],[372,379],[373,377,385],[374,384,396],[375,381,
409],[376,394],[377,389,401,420],[378,400,412,415],[379,387,402],[380,388,399,
420],[381,412],[382,390,398,411],[383,385],[384,413],[385,389],[386,413],[387,
415],[388,415],[389,392],[390,414],[391,416],[392,405,420],[393,397],[397,
399],[398,417],[399,403],[403,405,420],[406,408],[407,409],[408,411],[409,
412],[411,414,417],[414,419],[416,420]]],[2,[[4,94],[5,79,304,324,406],[8,134,
145],[11,52,368],[12,62],[15,195],[18,368],[20,134],[24,147,195,218,406],[25,
153,203,223,408,417],[26,79,245],[33,94],[35,92],[40,110,245,419],[44,255],
[46,269,272],[55,255,269],[57,258,275],[58,290,414],[61,272,406],[64,281,408,
414],[66,268,286],[72,255],[75,258],[76,317,417],[77,268],[85,269],[87,275,
331],[88,414,417],[108,286,342],[112,290],[113,317,331],[117,304],[119,324,
342,418],[142,364,419],[150,419],[157,269],[163,272,419],[164,275],[167,286],
[170,281],[174,364],[175,292],[178,368],[180,294],[182,300],[183,307],[191,
419],[214,364],[215,317],[221,368],[222,324],[237,331],[239,339],[243,342],
[248,344],[254,406],[261,406,411],[267,411],[283,414],[293,406],[302,408],
[309,411],[315,417],[320,406],[326,408],[327,411],[329,418],[346,414],[349,
417],[355,419],[363,406],[370,408],[378,411,419],[388,419],[400,417],[401,
419],[404,418]]]]], 57, 60,
[[[4],[1,4],2,[1,5],1,[2,3],[2,4],[2,5],1,[2,6],[3,4],2,[3,5],5,[3,6],3,[3,7],
[4,5],4,[4,6],8,[4,7],4,[5,6],[5,7],[1,2,3],[1,2,4],2,[1,2,5],7,[1,2,6],6,[1,
2,7],1,[1,3,4],[1,3,5],3,[1,3,6],3,[1,3,7],[1,4,5],8,[1,4,6],18,[1,4,7],10,[1,
5,6],4,[1,5,7],4,[2,3,4],1,[2,3,5],10,[2,3,6],13,[2,3,7],5,[2,4,5],2,[2,4,6],
7,[2,4,7],4,[2,5,6],3,[2,5,7],4,[2,6,7],[3,4,5],4,[3,4,6],14,[3,4,7],9,[3,5,
6],8,[3,5,7],11,[3,6,7],2,[4,5,6],3,[4,5,7],7,[4,6,7],4,[1,2,3,5],4,[1,2,3,6],
7,[1,2,3,7],3,[1,2,4,5],2,[1,2,4,6],11,[1,2,4,7],8,[1,2,5,6],9,[1,2,5,7],14,
[1,2,6,7],4,[1,3,4,5],[1,3,4,6],4,[1,3,4,7],3,[1,3,5,6],4,[1,3,5,7],7,[1,3,6,
7],2,[1,4,5,6],5,[1,4,5,7],13,[1,4,6,7],10,[1,5,6,7],1,[2,3,4,6],4,[2,3,4,7],
4,[2,3,5,6],10,[2,3,5,7],18,[2,3,6,7],8,[2,4,5,6],[2,4,5,7],3,[2,4,6,7],3,[2,
5,6,7],[3,4,5,6],1,[3,4,5,7],6,[3,4,6,7],7,[3,5,6,7],2,[4,5,6,7],[1,2,3,4,6],
[1,2,3,4,7],[1,2,3,5,6],4,[1,2,3,5,7],8,[1,2,3,6,7],4,[1,2,4,5,6],[1,2,4,5,7],
3,[1,2,4,6,7],5,[1,2,5,6,7],2,[1,3,4,5,7],[1,3,4,6,7],1,[1,3,5,6,7],[1,4,5,6,
7],[2,3,4,6,7],1,[2,3,5,6,7],2,[1,2,3,5,6,7]],[[1,[[1,2,3,8,14,28,29,31,37,42,
83,90,111,137,162,167,171,186,187,192,196,208,215,246,275,288,296,387,390,391,
447,450,488,490,492,502,508],[2,13,50,80,81,89,90,99,107,111,258,281,296,332,
502],[3,12,48,84,85,95,113,257,276,277,328,331,467],[4,14,49,68,78,82,89,90,
107,259,275,280,333],[5,20,52,57,69,83,86,87,118,120,122,260,304,313,339,347,
358,362,370,471,472,481,492,502],[6,15,54,55,70,71,79,83,85,102,117,121,125,
300,313,318,344,347,359,361,364,367,469,471,473,477,488,490,512],[7,13,47,50,
127,132,133,135,146,148,158,258,264,271,390,396,400,420],[8,48,50,127,132,161,
162,164,167,171,390,396,438],[9,30,56,58,129,132,139,161,164,176,179,184,399,
409,438,488],[10,26,56,57,129,134,160,166,177,178,181,321,397,406,409,414,418,
437,440,488],[11,32,62,63,141,143,145,164,170,176,179,184,185,287,300,399,407,
433,441,488,494,497,507,509,512],[12,128,133,187,190,202,208,390],[13,17,68,
186,192,193,196,211,215,331,336,387,393,467],[14,127,135,188,189,193,196,215,
389],[15,26,131,134,187,205,216,217,230,231,400,406,409,418,420,447,448,449],
[16,70,79,135,139,188,193,219,227,473],[17,24,69,72,80,133,134,135,187,189,
190,225,258,260,343,400,420,422,448,502],[18,69,71,83,137,186,187,192,218,224,
225,230,339,347,400,447,450,471,502],[19,69,86,133,138,187,190,202,220,233,
260,400,472],[20,30,129,139,200,222,223,236,399,409,410,446,451,452],[21,75,
76,93,142,150,192,198,201,218,224,225,237,398,400,428,455,463,471,485,508,
512],[22,75,105,142,149,201,202,204,220,221,233,239,266,400,428,462,472,483],
[23,73,100,145,150,193,199,219,224,227,238,330,407,455,473,486,507,512],[24,
25,73,74,92,145,146,147,150,192,193,194,196,197,199,219,224,263,330,331,339,
341,387,400,403,446,447,467,469,470,471,473],[25,77,112,154,156,206,207,209,
210,211,225,230,232,237,270,335,343,344,345,353,392,408,412,420,422,427,428,
435,448,453,454,455,457,463,468,474,475,478,480,485,502,503,504,508,512],[26,
31,79,83,160,187,241,242,244,246,251,364,447,450,488,490],[27,39,86,138,162,
187,190,250,274],[28,33,79,84,139,161,188,244,452,489],[29,35,80,134,160,162,
187,189,246,437,448],[30,37,83,86,162,186,187,240,243,245,246,492],[31,42,90,
99,166,167,195,196,205,254,286,354,376,406,447,488],[32,88,105,195,201,204,
221,240,243,245,252,254,354,376,462],[33,43,90,91,163,203,204,240,279,357,391,
405],[34,100,170,199,241,244,253,407,507],[35,41,92,167,168,170,196,197,199,
241,387,403,436,446,447,488],[36,93,165,169,198,201,242,243,246,254,255,398,
508],[37,40,95,99,164,168,191,196,200,287,355,399,446,488],[38,45,105,149,165,
201,204,250,256,279],[39,44,95,168,194,196,278,356,388,402,446,488],[40,106,
111,173,175,208,209,212,245,246,254,255,371,376,426,454,462,491,492,493,508],
[41,112,172,173,209,210,246,247,254,255,392,412,437,439,443,448,453,454,457,
491,508],[42,111,115,171,172,209,215,244,246,254,364,417,450,453,455,490,491,
494,507,508],[43,108,115,174,213,244,248,253,368,393,411,452,460,489,498,507],
[44,106,173,206,209,250,256,295,373,394,415,454,491],[45,46,119,177,222,223,
241,302,356,402,407,446,488],[46,122,183,231,234,247,250,256,322,373,385,415,
418,454,464,491,499,510],[47,49,68,259,261,262,264,270],[48,128,261,274,282,
296],[49,51,127,277,283,293,467],[50,53,275,276,277,284,288,290,292,488,490],
[51,64,78,130,259,260,261,274,275,316],[52,85,129,257,276,277,301,312,469,
488],[53,60,81,132,258,306,319,320],[54,80,134,258,260,281,307,313,316],[55,
82,131,259,275,280,299,306,320],[56,83,137,275,288,300,304,306,313,319,321,
471,488,490,492],[57,79,139,283,302,318,473,476,489],[58,86,138,260,261,274,
282,298,315,472],[59,101,143,269,277,287,301,303,312,327,469,487,488,495,497],
[60,66,94,140,263,277,288,304,469,471,488],[61,103,152,268,280,286,299,303,
306,320,323,326,495],[62,88,141,262,288,300,306,319,323,471,485,494,512],[63,
105,149,262,266,279,282,298,305,315,324,472,483,496],[64,67,96,144,265,267,
277,278,283,284,301,302,467,469,470,473,488],[65,97,151,262,266,268,279,281,
286,305,307,316,325,496],[66,116,155,270,292,294,308,319,320,323,326,474,480,
485,491,494,495,512],[67,109,159,271,273,289,294,295,296,310,316,322,325,468,
475,478,480,491,496],[68,72,328,330,331,334],[69,85,257,328,331,341,349,469],
[70,78,259,260,333,342,343],[71,81,258,332,339,340,347,350,502],[72,74,82,259,
339,350],[73,97,266,268,333,338,342,343,353,504],[74,77,104,265,331,469],[75,
101,269,330,331,338,341,349,352,469,487,504],[76,103,268,332,339,340,350,351,
503,505],[77,114,271,335,350,351,480],[78,96,188,328,361],[79,90,275,357,363,
502],[80,92,275,276,361,372,488,489,490],[81,94,186,359,366,367],[82,104,189,
359,367],[83,99,354,355,359,364,366,372,488],[84,91,190,260,274,370],[85,89,
187,358,362],[86,95,276,328,356,360,488],[87,113,200,269,277,283,287,330,331,
374,467,495,504],[88,195,330,338,354,359,366,376,381,504],[89,110,196,277,331,
469,488],[90,115,193,283,284,330,359,473],[91,108,194,278,356,467,470],[92,
112,279,281,284,285,286,307,354,357,358,359,488],[93,286,287,303,354,355,372,
376,382,488,495,497,506],[94,116,191,332,340,355],[95,106,202,282,285,329,358,
472],[96,109,203,329,333,342,357,358],[97,121,199,330,361,379],[98,120,204,
266,279,370,380],[99,111,192,288,376,471],[100,279,286,305,354,357,363,376,
383,496],[101,118,201,358,362,375,378],[102,107,205,268,280,281,286,332,333,
376,378,495,496,503,504],[103,117,198,359,367,381,384],[104,114,197,280,299],
[105,119,287,330,356,360,374,377,488,497],[106,214,291,297,337,360,365,374,
482],[107,215,290,293,334,336,361,367,477,490],[108,206,295,370,373,380,468,
478],[109,213,336,337,348,361,365,368,379],[110,209,294,335,362,378,480,491],
[111,211,292,366,372,376,474,495,504],[112,289,291,293,314,361,364,365,368,
369,372,376,379,382,489,490,491,494,495,497,498,506],[113,208,294,296,335,362,
370,468,481,492,502],[114,210,290,317,367,384],[115,207,289,296,363,369,376,
475,496,502,503],[116,212,334,346,366,367,371,376,381,384,504],[117,126,216,
299,303,340,355,505,506],[118,125,222,303,338,354,386,469,488],[119,122,221,
304,305,339,354,358,385,472,499],[120,124,223,302,356,470],[121,123,217,305,
307,338,339,342,354,357,358,359],[122,236,308,318,344,360,364,365,374,386,482,
512],[123,235,314,318,344,347,348,361,364,365,368,369,379,386,500,505,506,
512],[124,234,322,370,373,380,385,478],[125,231,313,347,362,364,378,480,491,
499,512],[126,228,313,317,346,367,371,384,501],[127,130,390,391,392],[128,136,
388,393,467],[129,162,187,390,400,404,416],[130,144,161,188,419],[131,160,189,
389,397,401,423],[132,140,186,261,397,414,423],[133,147,257,276,410],[134,387,
403,409,419],[135,146,259,275,400,420],[136,153,190,260,261,274,422],[137,148,
257,258,397,399,400,406,409,410,414,417,420,473,474,476],[138,388,402,425],
[139,260,391,405,418,422],[140,155,164,191,267,390,399,400],[141,166,195,262,
397,406,414,434,435],[142,200,269,287,399,410,433],[143,165,201,390,398,400,
404,416,428,432,508],[144,159,163,203,390,391,400,404,405],[145,204,262,266,
279,391,405,422,427],[146,154,193,265,284,389,397,473],[147,156,202,264,285,
390,400,404,472],[148,158,192,262,263,264,288,387,390,391,400,435,471,485,
508],[149,388,402,407,425,430,507],[150,205,268,286,400,406,420,428,435],[151,
170,199,387,403,407,419,429,507],[152,169,198,389,397,398,401,423,431,434,
508],[153,157,194,267,278,388,402,467,470],[154,207,271,289,396,420,424,435,
475],[155,175,212,273,395,408,414,423,426,431,434,435,508],[156,214,272,291,
395,408,410,413,433,482],[157,206,273,295,394,415,422,427,468,478],[158,211,
270,272,292,392,393,395,408,410,414,420,435,474,476],[159,174,213,393,395,408,
411,413,419,429,507],[160,167,275,436,438],[161,163,274,275,437],[162,168,276,
440,488],[163,174,179,278,284,488],[164,175,282,288,390,391,488,508],[165,177,
287,440,442,488,497],[166,171,283,288,387,390,441,494,507,508],[167,172,284,
389,397],[168,173,285,390,404],[169,176,286,436,438,441,444],[170,178,279,286,
437,443],[171,292,296,392,395,414,437,440],[172,289,396,424,438,441],[173,291,
395,413,440,442],[174,182,289,295,437,443,491],[175,184,292,297,393,395,438,
441,444,491,494,507],[176,181,243,300,397,398,445],[177,183,242,304,398,404,
499],[178,180,241,300,302,403,407,436,488],[179,182,240,298,306,404,405],[180,
247,321,322,412,418,437,439,443,445,491,499,510],[181,251,321,409,424,438,441,
509],[182,185,248,309,311,411,413],[183,249,308,409,413,440,442,511],[184,245,
315,319,321,414,416,418,422,426,437,445,491,492],[185,252,323,324,427,432,443,
445,510],[186,191,328,447,449,450],[187,196,446,451],[188,203,448],[189,197,
447,449],[190,194,328,452],[191,212,218,329],[192,211,330,331,332,455,504],
[193,207,333,391,447],[194,206,220,329],[195,224,330,447,450,455,458],[196,
209,390,400],[197,210,389,401],[198,216,447,449,458,461],[199,217,448,457],
[200,208,390,391,462,508],[201,222,446,451,456,459],[202,214,331,388,446,467],
[203,213,219,446],[204,223,330,452,460],[205,215,387,389,455,459,507,508],
[206,226,337,452,460],[207,227,336,393,453,455,507],[208,393,395,410,451,452],
[209,395,408,451,459],[210,396,421,449,461],[211,225,334,335,450,455,502,508],
[212,229,337,449,450,455,458,461],[213,232,448,454,457],[214,233,335,394,454,
462,468],[215,392,396,420,448,449],[216,228,242,398,401,463],[217,235,241,403,
407,446,447],[218,229,340,341,355,399,400,446],[219,232,342,357,400,405],[220,
226,341,356,402,446,470],[221,236,338,399,407,446,465,509,512],[222,231,243,
398,400,464],[223,234,240,339,405],[224,230,338,339,354,406,447,463],[225,349,
350,372,408,409,410,420,449,451,474],[226,239,345,373,415,454,478],[227,343,
363,418,420,422,448,475,502],[228,249,409,421,449,461,511],[229,237,345,346,
371,408,426,454,463],[230,344,347,364,417,450,453,455,463,512],[231,251,408,
409,451,459,509],[232,238,348,368,408,411],[233,349,360,408,410,425,451,452,
479,482],[234,248,344,411,452,460,465],[235,247,412,418,448,453,454,457,463,
464,510],[236,245,347,418,426,454,462,464],[237,351,352,382,428,433,455,456,
461,463,511,512],[238,353,383,427,428,457,463,510],[239,352,377,430,456,460,
465,484],[240,248,356,359,446],[241,247,354,357],[242,249,355,436,446,506],
[243,251,354,447,466,488],[244,363,418,437,448],[245,360,364,366,450,451,452,
466],[246,372,409,438,440,449,451],[247,253,364,368,466,506],[248,252,369,373,
454],[249,255,371,439,454],[250,360,425,440,451,452,489],[251,254,364,453,
491],[252,377,381,456,460,465,466],[253,376,383,443,457,510],[254,376,441,458,
459,497,506,509],[255,382,442,444,456,461,466,511],[256,374,377,430,442,456,
459,460,497,498,507],[257,264,472,481],[258,263,469,471,473,474,476,477],[259,
265,469,473,477],[260,467,470,479],[261,267,328,476],[262,283,330,473,476,
486],[263,270,281,332,485],[264,272,277,331,467,469],[265,271,280,333],[266,
467,470,479,484],[267,273,282,329,472],[268,469,471,473,477,485,486,487,512],
[269,471,472,481,483,485],[270,293,334,476,477,486],[271,290,336,477,485],
[272,294,335,468,480,481,485],[273,297,337,476,482,486],[274,278,489],[275,
284,488,490],[276,285,492],[277,294,390],[278,295,298],[279,302,489,498],[280,
290,389],[281,293,387,467,495],[282,297,388,467],[283,296,391,496],[284,289,
306],[285,291,301,488],[286,300,488,490,494,497],[287,304,492,493],[288,292,
488,494,495],[289,309,490,494],[290,320,396,495],[291,310,491,492,493],[292,
319,490,491,492,494],[293,316,392,468,496],[294,312,395,495],[295,311,489,
498],[296,393,476,489],[297,315,394,468,496],[298,311,356,402,470,488],[299,
317,401,469,488],[300,321,354,406,488,499],[301,310,358,404,472],[302,322,357,
405],[303,313,398,471,499,501,512],[304,308,355,399,488],[305,318,407,473,500,
512],[306,309,359,397,473],[307,314,403,469,470,471,473,488],[308,371,426,491,
492,493,499,501],[309,323,369,424,475],[310,327,365,413,482],[311,324,373,415,
478,491],[312,362,416,480,481,491,492],[313,372,409,474,495],[314,325,412,474,
475,478,480,491,499,501,512],[315,360,425,476,479,482,489],[316,361,419,476,
477,479,489,490],[317,326,421,480,491],[318,363,418,475,496],[319,366,414,474,
476],[320,367,423,477,490],[321,364,417,490,491,494,499,512],[322,368,411,489,
498,500],[323,381,434,486,494,499,512],[324,377,430,484,497,498,500],[325,379,
429,484,485,486,487,494,495,497,498,500,512],[326,384,431,487,497,501],[327,
375,432,483,493,501],[328,329,502],[329,337,341],[330,339,502,503],[331,335],
[332,334,504],[333,336,467],[334,350,502,503],[335,349,504],[336,343,468,504],
[337,345,502,503],[338,347,471,505,512],[339,344,359,473],[340,346,469,471],
[341,345,358,472],[342,348,469,470,473],[343,361,477,479],[344,369,475,502,
503,505],[345,352,365,482],[346,351,474,480,505,512],[347,366,474,504],[348,
353,475,478,480],[349,362,480,481,502],[350,367,477],[351,384,485,487,504],
[352,375,483,503,505],[353,379,484,486,487,505,512],[354,364,506],[355,371,
488],[356,373],[357,368,488],[358,365,446],[359,369,447],[360,491,492,502],
[361,448,502],[362,451],[363,489,490],[364,376,506],[365,375,454],[366,450,
502],[367,449],[368,383,491],[369,381,453],[370,452,479,489],[371,382,491,
506],[372,490,491,492],[373,377],[374,462,483,493,496,503],[375,386,456],[376,
455,494,512],[377,385],[378,459,487,495,497,504],[379,457,496,503,504],[380,
460,484,498],[381,458,503,505,506],[382,493,497,501,506],[383,497,498,500,
506],[384,461,495],[385,465,500],[386,464,501,505,506],[387,392,508],[388,
394],[389,396],[390,395],[391,393,467,507],[392,419,507],[393,422,468],[394,
425,507],[395,416,508],[396,423,508],[397,424,447],[398,409,509,511],[399,426,
471,472],[400,408,469,488],[401,421,436],[402,415,472],[403,412],[404,413,
446],[405,411,470,473],[406,417,471,473,509,512],[407,418,510],[408,428,480,
491],[409,508],[410,481,492],[411,427,475,478,510],[412,429,509,511],[413,432,
454],[414,450,476],[415,430,482],[416,440,451],[417,435,474,475,509],[418,
507],[419,437,448],[420,477,490],[421,431,439],[422,452,476,479,489],[423,438,
449],[424,434,453],[426,433,474,482,509,511,512],[427,460,484,486,498,507],
[428,459,487,497,509],[429,443,457,508,510],[430,483,510],[431,444,461,511],
[432,442,456,511],[433,462,483,485,493,508],[434,441,458,509],[435,455,485,
486,494,507,508,512],[436,439,488],[437,489,490],[438,490],[439,444,491],[440,
491,492],[441,494,508],[442,493,508],[443,494,497,498,507],[444,445,497],[445,
466,499,511],[446,454],[447,453],[450,502],[452,502],[453,458],[454,456],[455,
503,504],[456,464],[457,507],[458,463],[459,508],[460,503],[461,508],[462,504,
507],[463,505,506,509],[464,466,511],[465,505,510],[466,506],[467,468],[468,
479],[469,480],[470,478],[471,474,512],[472,482],[473,475],[474,485,512],[475,
486,512],[476,502],[478,484],[480,487],[482,483],[483,512],[485,495,504],[486,
496,503],[487,512],[488,491],[491,497],[495,508],[496,507],[497,499],[499,506,
509],[500,510],[501,511,512],[505,512],[509,512],[510,512]]]]]]);

CHEVIE.AddData("WGraph","E7",function(i)local gr;
 gr:=CHEVIE.RawData("WGraphs","E7");
 if IsInt(gr[i]) then return DualWGraph(7,gr[gr[i]]); else return gr[i]; fi;
end);

CHEVIE.AddData("HeckeRepresentation","E7",function(param,sqrtparam,i)local v;
 if not IsBound(sqrtparam[1]) then 
     v:=GetRoot(-param[1][1]/param[1][2],2,"Representation(Hecke(E7),[",i,"])");
 else v:=sqrtparam[1];
 fi;
 return -param[1][2]*WGraphToRepresentation(7,CHEVIE.RawData("WGraph","E7")(i),v); 
end);

CHEVIE.AddData("Representation","E7",i->
  CHEVIE.RawData("HeckeRepresentation","E7")
                         (List([1..7],i->[1,-1]),[1..7]*0+1,i));

CHEVIE.AddData("DecompositionMatrix","E7",function(p)
  if p=2 then return [
   [[1..58],
   [[1,0,0,0,0,0,0],[1,0,0,0,0,0,0], [1,1,0,0,0,0,0],[1,1,0,0,0,0,0],
[1,1,1,0,0,0,0],[1,1,1,0,0,0,0], [1,1,0,1,0,0,0],[1,1,0,1,0,0,0],
[1,1,0,1,0,0,0],[1,1,0,1,0,0,0], [1,2,0,1,0,0,0],[1,2,0,1,0,0,0],
[1,2,1,1,0,0,0],[1,2,1,1,0,0,0], [1,2,1,1,0,0,0],[1,2,1,1,0,0,0],
[2,3,1,2,0,0,0],[2,3,1,2,0,0,0], [2,1,0,1,1,0,0],[2,1,0,1,1,0,0],
[2,2,1,1,1,0,0],[2,2,1,1,1,0,0], [1,2,0,2,0,1,0],[1,2,0,2,0,1,0],
[3,3,1,2,1,0,0],[3,3,1,2,1,0,0], [3,3,1,2,1,0,0],[3,3,1,2,1,0,0],
[2,3,1,2,0,1,0],[2,3,1,2,0,1,0], [2,2,0,3,1,1,0],[2,2,0,3,1,1,0],
[3,4,1,3,1,1,0],[3,4,1,3,1,1,0], [3,4,1,3,1,1,0],[3,4,1,3,1,1,0],
[3,4,1,3,1,1,0],[3,4,1,3,1,1,0], [4,5,1,4,1,1,0],[4,5,1,4,1,1,0],
[2,3,2,1,1,0,1],[2,3,2,1,1,0,1], [2,3,1,2,1,0,1],[2,3,1,2,1,0,1],
[6,6,1,5,2,1,0],[6,6,1,5,2,1,0], [2,3,1,2,1,1,1],[2,3,1,2,1,1,1],
[3,5,2,3,1,1,1],[3,5,2,3,1,1,1], [4,6,2,4,1,1,1],[4,6,2,4,1,1,1],
[4,5,2,4,2,1,1],[4,5,2,4,2,1,1], [5,7,2,5,2,1,1],[5,7,2,5,2,1,1],
[6,8,3,5,2,1,1],[6,8,3,5,2,1,1]]],
[[59,60],[[1],[1]]]];
  elif p=3 then return [
[[1,3,5,7,9,13,15,17,19,21,23,25,27,29,31,39,41,45,47,49,51,57,59],
[[1,0,0,0,0,0,0,0,0,0],[0,1,0,0,0,0,0,0,0,0],[1,0,1,0,0,0,0,0,0,0],
[0,0,0,1,0,0,0,0,0,0], [0,1,1,0,0,0,0,0,0,0], [0,0,0,0,0,1,0,0,0,0],
[1,0,0,0,1,0,0,0,0,0], [0,1,0,0,0,0,1,0,0,0], [0,0,0,1,0,0,1,0,0,0],
[1,0,1,0,1,1,0,0,0,0], [0,1,1,0,0,1,1,0,0,0], [0,1,0,0,0,0,0,0,1,0],
[0,0,1,0,0,0,0,1,0,0], [1,0,0,1,0,0,0,0,1,0], [1,0,0,0,1,1,0,0,1,0],
[0,0,0,1,0,0,0,1,1,0], [0,1,0,1,0,1,1,0,1,0], [0,0,0,0,0,1,1,0,0,1],
[1,1,1,0,1,1,0,1,1,0], [0,0,0,1,0,0,2,0,0,1], [0,0,1,0,0,1,0,1,0,1],
[0,0,0,0,0,1,0,1,1,1], [1,1,1,1,0,1,1,1,1,1]]],
[[2,4,6,8,10,14,16,18,20,22,24,26,28,30,32,40,42,46,48,50,52,58,60],
[[1,0,0,0,0,0,0,0,0,0],[0,1,0,0,0,0,0,0,0,0],[1,0,1,0,0,0,0,0,0,0],
[0,0,0,1,0,0,0,0,0,0], [0,1,1,0,0,0,0,0,0,0], [0,0,0,0,0,1,0,0,0,0],
[1,0,0,0,1,0,0,0,0,0], [0,1,0,0,0,0,1,0,0,0], [0,0,0,1,0,0,1,0,0,0],
[1,0,1,0,1,1,0,0,0,0], [0,1,1,0,0,1,1,0,0,0], [0,1,0,0,0,0,0,0,1,0],
[0,0,1,0,0,0,0,1,0,0], [1,0,0,1,0,0,0,0,1,0], [1,0,0,0,1,1,0,0,1,0],
[0,0,0,1,0,0,0,1,1,0], [0,1,0,1,0,1,1,0,1,0], [0,0,0,0,0,1,1,0,0,1],
[1,1,1,0,1,1,0,1,1,0], [0,0,0,1,0,0,2,0,0,1], [0,0,1,0,0,1,0,1,0,1],
[0,0,0,0,0,1,0,1,1,1], [1,1,1,1,0,1,1,1,1,1]]],
[[11,43,37],[[1,0],[1,1],[0,1]]],
[[12,44,38],[[1,0],[1,1],[0,1]]],
[[33,53,35],[[1,0],[1,1],[0,1]]],
[[36,54,34],[[1,0],[1,1],[0,1]]]];
  elif p=5 then return [
[[1,21,43,35,17],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]],
[[3,53,59,31,11],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]],
[[7,33,51,37,9],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]],
[[2,22,44,36,18],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]],
[[4,54,60,32,12],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]],
[[8,34,52,38,10],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]]];
  elif p=7 then return [
[[1,11,29,55,59,43,5],[[1,0,0,0,0,0],[1,1,0,0,0,0],[0,1,1,0,0,0],[0,0,1,1,0,0],
 [0,0,0,1,1,0],[0,0,0,0,1,1],[0,0,0,0,0,1]]],
[[2,12,30,56,60,44,6],[[1,0,0,0,0,0],[1,1,0,0,0,0],[0,1,1,0,0,0],[0,0,1,1,0,0],
 [0,0,0,1,1,0],[0,0,0,0,1,1],[0,0,0,0,0,1]]]];
  else return [];
  fi;
end);

CHEVIE.AddData("UnipotentCharacters","E7",function()
  return rec(
  harishChandra:=[
    rec(relativeType:=rec(series:="E",indices:=[ 1 .. 7 ],rank:=7),
 levi:=[  ], eigenvalue:=1,
      parameterExponents:=[ 1, 1, 1, 1, 1, 1, 1 ], 
      cuspidalName:="", charNumbers:=[ 1 .. 60 ]),
    rec(relativeType:=rec(series:="B",indices:=[ 7, 6, 1 ],
      cartanType:=1,rank:=3),
 levi:=[ 2 .. 5 ], eigenvalue:=-1,
      parameterExponents:=[ 1, 4, 4 ], cuspidalName:="D_4",
      charNumbers:=[ 67, 66, 64, 61, 69, 65, 68, 62, 70, 63 ]),
    rec(relativeType:=rec(series:="A",indices:=[ 7 ],rank:=1),
 levi:=[ 1 .. 6 ], eigenvalue:=E(3),
      parameterExponents:=[ 9 ], cuspidalName:="E_6[\\zeta_3]",
      charNumbers:=[ 71, 72 ]),
    rec(relativeType:=rec(series:="A",indices:=[ 7 ],rank:=1),
 levi:=[ 1 .. 6 ], eigenvalue:=E(3)^2,
      parameterExponents:=[ 9 ], cuspidalName:="E_6[\\zeta_3^2]",
      charNumbers:=[ 73, 74 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 7 ], eigenvalue:=-E(4),
      parameterExponents:=[  ], cuspidalName:="E_7[-i]",
      charNumbers:=[ 75 ],qEigen:=1/2),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 7 ], eigenvalue:=E(4),
      parameterExponents:=[  ], cuspidalName:="E_7[i]",
      charNumbers:=[ 76 ],qEigen:=1/2)],
  families:=[
    Family("C1",[1]), Family("C1",[2]), Family("C1",[3]), Family("C1",[4]),
    Family("C1",[9]), Family("C1",[10]), Family("C1",[11]), Family("C1",[12]),
    Family("C1",[25]), Family("C1",[26]), Family("C1",[27]), Family("C1",[28]),
    Family("C1",[31]), Family("C1",[32]), Family("C1",[35]), Family("C1",[36]),
    Family("C1",[37]), Family("C1",[38]), Family("C1",[39]), Family("C1",[40]),
    Family("C1",[41]), Family("C1",[42]), Family("C1",[53]), Family("C1",[54]),
    Family("C2",[18, 15, 7, 70]), Family("C2",[29, 6, 24, 63]),
    Family("C2",[55, 44, 33, 65]), Family("C2",[57, 21, 52, 69]),
    Family("C2",[58, 22, 51, 62]), Family("C2",[56, 43, 34, 66]),
    Family("C2",[30, 5, 23, 67]), Family("C2",[17, 16, 8, 61]),
    Family("C'2",[60, 59, 76, 75 ]),
    Family("S3", [50, 47, 20, 46, 14, 68, 72, 74 ]),
    Family("S3", [49, 48, 19, 45, 13, 64, 71, 73 ])],
  a:=[ 0, 63, 46, 1, 25, 4, 3, 30, 36, 3, 2, 37, 16, 7, 3, 30, 30, 3, 16, 7,
  10, 13, 25, 4, 6, 21, 12, 15, 4, 25, 6, 21, 8, 15, 22, 5, 20, 7, 6, 21, 10,
  13, 15, 8, 16, 7, 7, 16, 16, 7, 13, 10, 14, 9, 8, 15, 10, 13, 11, 11, 30,
  13, 4, 16, 8, 15, 25, 7, 10, 3, 16, 7, 16, 7, 11, 11 ],
  A:=[ 0, 63, 62, 17, 59, 38, 33, 60, 60, 27, 26, 61, 56, 47, 33, 60, 60, 33,
  56, 47, 50, 53, 59, 38, 42, 57, 48, 51, 38, 59, 42, 57, 48, 55, 58, 41, 56,
  43, 42, 57, 50, 53, 55, 48, 56, 47, 47, 56, 56, 47, 53, 50, 54, 49, 48, 55,
  50, 53, 52, 52, 60, 53, 38, 56, 48, 55, 59, 47, 50, 33, 56, 47, 56, 47,
  52, 52 ]);
end);

CHEVIE.AddData("Invariants","E7",function()local r;
 r:=CoxeterGroup("E",7).roots{[1..63]}*CartanMat("E",7); 
 return List(CHEVIE.RawData("ReflectionDegrees","E7"),
   d-> function(arg) return Sum(r,a->(arg*a)^d);end);
end);

CHEVIE.AddData("UnipotentClasses","E7",function(p)local uc,Z,c;
  if p=0 then p:=1;fi;Z:=n->ComplexReflectionGroup(n,1,1);
# Partial ordering on unipotent classes --- courtesy of Hyohe Miyachi
uc:=rec(orderPicture:=Join([
"		  E_7",
"		   |",
"		E_7(a_1)",
"		   |",
"		E_7(a_2)",
"		 /    \\",
"	       E_6     E_7(a_3)",
"		 \\    /     \\",
"		E_6(a_1)   D_6",
"		   |       /",
"		   |      /",
"		  E_7(a_4)",
"	       /   |       \\",
"	      /    |        \\",
"       A_6        D_5+A_1   D_6(a_1)",
"	|      /          \\   |",
"     E_7(a_5)                D_5",
"	|\\__________________  |",
"	|                   \\ |",
"    D_6(a_2)               E_6(a_3)",
"	|\\__________________/ |",
"	|         |           |",
"	|        A_5     D_5(a_1)+A_1",
"	|         _ \\ _____/  |",
"	|         |  \\________|",
"     A_5+A_1      |           |",
"	|     \\______________ |",
"	|                   A_4+A_2",
"       A_5''      |           |",
"	|      D_5(a_1)       |",
"	|         |  \\_______ |",
"	|         |          \\|",
"	|     D_4+A_1      A_4+A_1",
"      _ | ____/    \\______ /_ |",
"     /   \\___ _      ____ /  \\|",
"   D_4         \\    /    A_3+A_2+A_1",
"    |           A_4           |",
"    |             \\_________  |",
"    |                       \\ |",
"    |                      A_3+A_2",
"    |                         |",
"    |                    D_4(a_1)+A_1",
"    |  ______________________/|",
"    | /                       |",
"  D_4(a_1)                 A_3+2A_1",
"	\\_______    _________/|",
"		\\  /          |",
"	      (A_3+A_1)'      |",
"		/   _\\_____(A_3+A_1)''",
"	2A_2+A_1 ] |  \\_____  |",
"    ___/     |     |        \\ |",
"   /          2A_2          A_3",
"A_2+3A_1         |            |",
"   |             |            |",
"    \\___________ | __________/",
"		\\|/",
"	      A_2+2A_1",
"		 |",
"	      A_2+A_1",
"	      /      \\",
"	 4A_1____    A_2",
"	 /        \\     |",
"      (3A_1)''     (3A_1)'",
"	 \\            /",
"	      2A_1",
"	       |",
"	      A_1",
"	       |",
"	      A_0"],"\n"),
classes:=[
rec(name:="E_7",succ:=[],dynkin:=[2,2,2,2,2,2,2],Au:=Z(2*Gcd(6,p))),
rec(name:="E_7(a_1)",succ:=["E7"],dynkin:=[2,2,2,0,2,2,2],Au:=Z(2)),
rec(name:="E_7(a_2)",succ:=["E7(a1)"],dynkin:=[2,2,2,0,2,0,2],Au:=Z(2)),
rec(name:="E_6",succ:=["E7(a2)"],dynkin:=[2,0,2,2,0,2,0],Au:=Z(Gcd(6,p))),
rec(name:="E_7(a_3)",mizuno:="D_6{+}A_1",succ:=["E7(a2)"],
  dynkin:=[2,0,0,2,0,2,2],Au:=Z(2)*Z(Gcd(2,p-1))),
rec(name:="E_6(a_1)",succ:=["E6","E7(a3)"],dynkin:=[2,0,0,2,0,2,0],Au:=Z(2)),
rec(name:="D_6",succ:=["E7(a3)"],dynkin:=[2,1,1,0,1,2,2],Au:=Z(2)),
rec(name:="E_7(a_4)",mizuno:="D_6(a_1){+}A_1",succ:=["E6(a1)","D6"],
  dynkin:=[2,0,0,2,0,0,2],Au:=Z(Gcd(2,p-1))*Z(Gcd(2,p-1))),
rec(name:="A_6",succ:=["E7(a4)"],dynkin:=[0,0,0,2,0,2,0],Au:=Z(Gcd(2,p))),
rec(name:="D_5{+}A_1",succ:=["E7(a4)"],dynkin:=[2,1,1,0,1,1,0],Au:=Z(2)),
rec(name:="D_6(a_1)",succ:=["E7(a4)"],dynkin:=[2,1,1,0,1,0,2],Au:=Z(2)),
rec(name:="E_7(a_5)",mizuno:="D_6(a_2){+}A_1",succ:=["A6","D5+A1","D6(a1)"],
  dynkin:=[0,0,0,2,0,0,2],Au:=CoxeterGroup("A",2)*Z(Gcd(2,p-1))),
rec(name:="D_5",succ:=["D5+A1","D6(a1)"],
  dynkin:=[2,2,0,0,0,2,0],Au:=Z(Gcd(2,p))),
rec(name:="D_6(a_2)",succ:=["E7(a5)"],dynkin:=[0,1,1,0,1,0,2],
  Au:=Z(Gcd(2,p-1))),
rec(name:="E_6(a_3)",mizuno:="(A_5{+}A_1)'",
  succ:=["E7(a5)","D5"],dynkin:=[0,0,2,0,0,2,0],Au:=Z(2)),
rec(name:="A_5'",succ:=["D6(a2)","E6(a3)"],dynkin:=[1,0,0,1,0,2,0],Au:=Z(1)),
rec(name:="D_5(a_1){+}A_1",succ:=["E6(a3)","D6(a2)"],
  dynkin:=[2,0,0,0,2,0,0],Au:=Z(Gcd(2,p-1))),
rec(name:="A_5{+}A_1",mizuno:="(A_5{+}A_1)''",succ:=["D6(a2)"],
  dynkin:=[1,0,0,1,0,1,2],Au:=Z(Gcd(2,p-1))),
rec(name:="A_4{+}A_2",succ:=["A5'","D5(a1)+A1","A5+A1"],
  dynkin:=[0,0,0,2,0,0,0],Au:=Z(1)),
rec(name:="A_5''",succ:=["A5+A1"],dynkin:=[2,0,0,0,0,2,2],Au:=Z(Gcd(2,p-1))),
rec(name:="D_5(a_1)",succ:=["D5(a1)+A1"],dynkin:=[2,0,0,1,0,1,0],Au:=Z(2)),
rec(name:="D_4{+}A_1",succ:=["D5(a1)"],dynkin:=[2,1,1,0,0,0,1],Au:=Z(2)),
rec(name:="A_4{+}A_1",succ:=["A4+A2","D5(a1)"],dynkin:=[1,0,0,1,0,1,0],Au:=Z(2)),
rec(name:="D_4",succ:=["D4+A1"],dynkin:=[2,0,2,0,0,0,0],Au:=Z(Gcd(2,p))),
rec(name:="A_3{+}A_2{+}A_1",succ:=["D4+A1","A4+A1"],
  dynkin:=[0,0,0,0,2,0,0],Au:=Z(Gcd(2,p-1))),
rec(name:="A_4",succ:=["A5''","A4+A1"],dynkin:=[2,0,0,0,0,2,0],Au:=Z(2)),
rec(name:="A_3{+}A_2",succ:=["A3+A2+A1","A4"],
  dynkin:=[0,0,0,1,0,1,0],Au:=Z(Gcd(2,p-1))),
rec(name:="D_4(a_1){+}A_1",succ:=["A3+A2"],
  dynkin:=[0,1,1,0,0,0,1],Au:=Z(2)*Z(Gcd(2,p-1))),
rec(name:="D_4(a_1)",succ:=["D4","D4(a1)+A1"],
  dynkin:=[0,0,2,0,0,0,0],Au:=CoxeterGroup("A",2)),
rec(name:="A_3{+}2A_1",succ:=["D4(a1)+A1"],
  dynkin:=[1,0,0,0,1,0,1],Au:=Z(Gcd(2,p-1))),
rec(name:="(A_3{+}A_1)'",succ:=["D4(a1)","A3+2A1"],
  dynkin:=[1,0,0,1,0,0,0],Au:=Z(1)),
rec(name:="(A_3{+}A_1)''",succ:=["A3+2A1"],
  dynkin:=[2,0,0,0,0,0,2],Au:=Z(Gcd(2,p-1))),
rec(name:="2A_2{+}A_1",succ:=["(A3+A1)'"],dynkin:=[0,0,1,0,0,1,0],Au:=Z(1)),
rec(name:="2A_2",succ:=["(A3+A1)''","2A2+A1"],dynkin:=[0,2,0,0,0,0,0],Au:=Z(1)),
rec(name:="A_3",succ:=["(A3+A1)'","(A3+A1)''"],
  dynkin:=[2,0,0,0,0,1,0],Au:=Z(1)),
rec(name:="A_2{+}3A_1",succ:=["2A2+A1"],
  dynkin:=[0,2,0,0,0,0,0],Au:=Z(Gcd(2,p-1))),
rec(name:="A_2{+}2A_1",succ:=["2A2","A3","A2+3A1"],
  dynkin:=[0,0,0,1,0,0,0],Au:=Z(1)),
rec(name:="A_2{+}A_1",succ:=["A2+2A1"],dynkin:=[1,0,0,0,0,1,0],Au:=Z(2)),
rec(name:="4A_1",succ:=["A2+A1"],dynkin:=[0,1,0,0,0,0,1],Au:=Z(Gcd(2,p-1))),
rec(name:="A_2",succ:=["A2+A1"],dynkin:=[2,0,0,0,0,0,0],Au:=Z(2)),
rec(name:="3A_1''",succ:=["4A1"],dynkin:=[0,0,0,0,0,0,2],Au:=Z(Gcd(2,p-1))),
rec(name:="3A_1'",succ:=["4A1","A2"],dynkin:=[0,0,1,0,0,0,0],Au:=Z(1)),
rec(name:="2A_1",succ:=["3A1''","3A1'"],dynkin:=[0,0,0,0,0,1,0],Au:=Z(1)),
rec(name:="A_1",succ:=["2A1"],dynkin:=[1,0,0,0,0,0,0],Au:=Z(1)),
rec(name:="1",succ:=["A1"],dynkin:=[0,0,0,0,0,0,0],Au:=Z(1))],
springerSeries:=[rec(relgroup:=CoxeterGroup("E",7),levi:=[],Z:=[1],
  locsys:=[[1,2],[45,1],[44,1],[2,2],[39,2],[8,2],[5,2],[40,1],[41,2],[4,1],
   [3,2],[43,1],[29,1],[12,2],[7,2],[42,1],[40,2],[5,4],[33,1],[18,2],[22,2],
   [27,1],[38,1],[6,1],[9,1],[36,2],[20,2],[24,1],[6,2],[38,2],[10,2],[34,1],
   [15,1],[28,2],[37,1],[8,4],[32,2],[13,1],[11,2],[35,1],[19,1],[25,2],[30,2],
   [16,1],[29,2],[12,4],[14,2],[31,1],[29,3],[12,6],[26,1],[21,1],[27,2],[17,2],
   [15,2],[28,4],[21,2],[26,2],[23,1],[23,2]]),
rec(levi:=[2,5,7],relgroup:=CoxeterGroup("F",4),Z:=[-1],locsys:=[[1,1],[5,3],
 [36,1],
 [41,1],[2,1],[39,1],[10,1],[28,3],[17,1],[7,1],[11,1],[22,1],[28,1],[18,1],
 [12,3],[12,5],[3,1],[8,1],[25,1],[32,1],[5,1],[30,1],[8,3],[20,1],[14,1]]),
rec(relgroup:=Z(1),levi:=[1,2,3,4,5,6,7],Z:=[-1],locsys:=[[12,1]])]);
  if p=2 then Add(uc.classes,rec(name:="(A_3{+}A_2)_2",
    succ:=["A3+A2"],dimBu:=15,Au:=Z(1)));
    Add(uc.classes[31].succ,"(A3+A2)2");
    uc.springerSeries[1].locsys:=
    [[1,1],[45,1],[44,1],[2,2],[39,1],[9,1],[5,1],[40,1],[41,1],[4,2],#10
  [3,2],[43,1],[29,1],[12,1],[7,2],[42,1],[40,2],[5,2],[33,1],[18,1],[22,2],#21
  [46,1],[38,1],[6,1],[9,2],[36,1],[20,1],[24,2],[6,2],[38,2],[10,2],[34,1],#32
 [15,1],[28,1],[37,1],[8,1],[32,1],[13,2],[11,2],[35,1],[19,1],[25,1],[30,1],#43
   [16,1],[29,2],[12,2],[14,1],[31,1],[29,3],[12,3],[26,1],[21,1],[27,1],[17,1],
   [15,2],[28,2],[21,2],[26,2],[23,1],[23,2]];
    uc.springerSeries{[2..4]}:=[
    rec(relgroup:=CoxeterGroup("C",3),levi:=[2,3,4,5],Z:=[1],
    locsys:=[[22,1],[11,1],[13,1],[24,1],[7,1],[4,1],[3,1],[10,1],[2,1],[1,3]]),
    rec(relgroup:=CoxeterGroup(),levi:=[1..7],Z:=[1],locsys:=[[1,2]]),
    rec(relgroup:=CoxeterGroup(),levi:=[1..7],Z:=[1],locsys:=[[1,4]])];
  elif p=3 then uc.springerSeries[1].locsys[1]:=[1,1];
                uc.springerSeries[2].locsys[1]:=[1,4];
    Append(uc.springerSeries,[
     rec(relgroup:=CoxeterGroup("A",1),Z:=[1],levi:=[1..6],locsys:=[[4,2],[1,3]]),
     rec(relgroup:=CoxeterGroup("A",1),Z:=[1],levi:=[1..6],locsys:=[[4,3],[1,5]])]);
    for c in [2,6] do Add(uc.springerSeries,
      rec(relgroup:=CoxeterGroup(),Z:=[-1],levi:=[1..7],locsys:=[[1,c]]));od;
  fi;
  uc.operations:=UnipotentClassesOps;
  uc.orderClasses:=List(uc.classes,c->List(c.succ,
    n->PositionProperty([1..Length(uc.classes)],c->ClassName(uc,c)=n)));
  for c in uc.classes do Unbind(c.succ);od;
  return uc;end);

CHEVIE.AddData("KLeftCellRepresentatives","E7",
[rec(character:=[1], reps:=[], duflo:=[1,2,3,4,5,6,7]),
 rec(character:=[2], reps:=[], duflo:=[64,65,66,67,68,69,70]),
 rec(character:=[4], reps:=[], duflo:=[64,2,8,4,5,6,7]),
 rec(character:=[3], reps:=[], duflo:=[1,65,71,67,68,69,70]),
 rec(character:=[10], reps:=[], duflo:=[6,2,5,4,3,1,126]),
 rec(character:=[9], reps:=[], duflo:=[69,65,68,67,66,64,63]),
 rec(character:=[11], reps:=[], duflo:=[100,5,3,4,2,27,7]),
 rec(character:=[12], reps:=[], duflo:=[37,68,66,67,65,90,70]),
 rec(character:=[18,7], reps:=[[31,102,88,44,77,21,6]],
duflo:=[94,39,3,4,5,6,90]),rec(character:=[17,8],
reps:=[[63,69,83,68,67,66,93]],
duflo:=[47,67,94,65,84,69,52]),rec(character:=[18,15],
reps:=[[115,7,100,42,5,4,2],[52,110,111,51,109,50,2]],
duflo:=[126,7,37,6,5,4,2]),rec(character:=[17,16],
reps:=[[52,110,69,68,67,65,53],[63,70,100,69,68,67,65]],
duflo:=[62,65,66,67,68,69,70]),rec(character:=[28],
reps:=[],
duflo:=[100,2,3,4,5,103,70]),rec(character:=[27],
reps:=[],
duflo:=[37,65,66,67,68,40,7]),rec(character:=[25],
reps:=[[97,93,91,56,89,43,101]],
duflo:=[116,10,58,120,18,51,108]),rec(character:=[26],
reps:=[[76,73,58,65,81,71,108]],
duflo:=[53,73,121,57,81,114,45]),rec(character:=[25],
reps:=[[50,111,109,51,110,58,112]],
duflo:=[113,48,4,3,23,121,20]),rec(character:=[26],
reps:=[[70,62,86,66,67,68,83]],
duflo:=[50,111,67,66,86,58,83]),rec(character:=[29,6],
reps:=[[91,5,64,14,2,25,70],[28,84,79,26,83,44,70]],
duflo:=[64,5,32,79,2,25,70]),rec(character:=[30,5],
reps:=[[76,73,84,65,81,38,45],[91,48,76,68,77,65,81]],
duflo:=[28,65,100,26,68,107,7]),rec(character:=[31],
reps:=[],
duflo:=[108,2,5,4,3,52,126]),rec(character:=[32],
reps:=[],
duflo:=[45,65,68,67,66,115,63]),rec(character:=[38],
reps:=[],
duflo:=[116,3,2,4,5,6,112]),rec(character:=[37],
reps:=[],
duflo:=[53,66,65,67,68,69,49]),rec(character:=[36],
reps:=[[43,118,101,57,117,56,93]],
duflo:=[122,33,5,4,3,30,119]),rec(character:=[35],
reps:=[[94,61,65,67,68,69,100]],
duflo:=[59,96,68,67,66,93,56]),rec(character:=[36],
reps:=[[28,84,79,48,88,83,38]],
duflo:=[117,8,56,102,13,43,101]),rec(character:=[35],
reps:=[[63,81,97,65,73,68,45]],
duflo:=[54,71,119,39,76,106,38]),rec(character:=[39],
reps:=[],
duflo:=[125,2,3,4,5,13,70]),rec(character:=[40],
reps:=[],
duflo:=[62,65,66,67,68,76,7]),rec(character:=[42],
reps:=[[110,115,74,61,72,87,89]],
duflo:=[121,28,47,117,48,89,46]),rec(character:=[41],
reps:=[[80,79,102,60,75,78,88]],
duflo:=[58,91,110,54,111,26,109]),rec(character:=[41],
reps:=[[30,98,27,64,94,54,74]],
duflo:=[73,34,41,107,38,69,74]),rec(character:=[42],
reps:=[[91,87,82,83,63,84,86]],
duflo:=[10,97,104,44,101,6,11]),rec(character:=[29,24],
reps:=[[20,104,77,54,114,55,115]],
duflo:=[94,8,36,4,5,6,115]),rec(character:=[30,23],
reps:=[[108,63,69,84,65,67,66]],
duflo:=[27,83,69,68,67,66,62]),rec(character:=[53],
reps:=[[58,91,86,71,88,59,87]],
duflo:=[123,24,23,98,28,74,25]),rec(character:=[54],
reps:=[[51,79,80,76,49,75,78]],
duflo:=[60,87,86,35,91,11,88]),rec(character:=[53],
reps:=[[91,93,69,84,43,47,83]],
duflo:=[102,45,55,125,53,86,84]),rec(character:=[54],
reps:=[[55,45,102,80,86,53,78]],
duflo:=[39,108,118,62,116,23,21]),rec(character:=[58,22],
reps:=[[61,84,91,69,70,31,20],[61,84,91,69,70,47,83]],
duflo:=[64,59,32,124,58,105,70]),rec(character:=[57,21],
reps:=[[55,56,82,83,80,86,43],[55,80,71,93,56,78,106]],
duflo:=[1,122,95,61,121,42,7]),rec(character:=[55,33],
reps:=[[102,77,58,92,88,59,106]],
duflo:=[84,39,5,4,3,125,53]),rec(character:=[56,34],
reps:=[[93,54,66,67,68,83,53]],
duflo:=[21,102,68,67,66,62,116]),rec(character:=[55,44],
reps:=[[52,50,96,74,110,56,72],[96,113,88,57,110,56,72]],
duflo:=[126,18,54,88,13,16,72]),rec(character:=[56,43],
reps:=[[53,93,96,73,68,59,81],[65,76,73,106,61,108,51]],
duflo:=[62,68,91,16,65,88,7]),rec(character:=[50,47,20],
reps:=[[27,10,84,48,88,83,103],[115,84,57,104,56,83,103],[30,96,37,91,97,57,
5],[93,96,56,91,97,57,5],[100,96,93,58,98,97,59]],
duflo:=[115,2,63,119,7,35,5]),rec(character:=[49,48,19],
reps:=[[49,46,69,68,73,65,97],[112,68,62,73,65,90,70],[73,58,89,69,70,103,59],
[56,96,93,73,68,40,34],[93,69,73,89,63,97,103]],
duflo:=[49,70,118,51,68,73,65]),rec(character:=[57,52],
reps:=[[110,4,86,60,108,64,87]],
duflo:=[86,36,33,4,5,111,87]),rec(character:=[58,51],
reps:=[[43,105,103,62,114,67,65]],
duflo:=[1,68,71,67,65,53,7]),rec(character:=[50,47,46],
reps:=[[118,83,57,88,48,84,86],[48,46,95,75,110,57,2],[48,109,95,76,57,81,23],
[95,109,82,51,110,57,2],[95,109,82,59,81,110,58]],
duflo:=[126,5,55,4,2,93,7]),rec(character:=[49,48,45],
reps:=[[100,70,62,87,65,67,68],[49,53,87,65,67,68,110],[50,111,67,66,86,49,
20],[112,65,61,67,68,105,70],[67,70,66,106,59,112,58]],
duflo:=[62,65,66,81,70,19,68]),rec(character:=[50,46,46,14],
reps:=[[94,81,55,71,93,44,5],[55,81,96,70,44,77,21],[33,99,71,81,57,107,48],
[96,81,94,57,77,93,48]],
duflo:=[118,2,49,14,5,106,70]),rec(character:=[49,45,45,13],
reps:=[[23,99,54,67,68,83,87],[86,99,61,67,68,83,87],[7,66,50,67,68,83,112],
[104,60,84,65,81,66,42]],
duflo:=[55,65,112,77,68,43,7]),rec(character:=[60,59],
reps:=[[106,69,73,57,88,71,72],[74,100,96,63,97,72,87]],
duflo:=[106,37,33,105,35,72,44]),rec(character:=[60,59],
reps:=[[73,34,41,70,69,74,83],[90,98,93,61,74,83,94]],
duflo:=[93,35,52,120,54,74,83])]);
