#############################################################################
##
#A  tbl/cmp4_7.g             CHEVIE library                       Jean MICHEL
##
#Y  Copyright (C) 1998 - 2001  The CHEVIE Team
##
##  This file contains  data about the complex reflection  group of type
##  G4 to G7 in the Shephard-Todd classification.
##
## The  data comes  from  the  paper of  G.Malle  ``Degres relatifs  des
## algebres de  Hecke cyclotomiques associees aux  groupes de reflexions
## complexes de dimension 2'',  in ``Finite reductive groups'', Progress
## in mathematics n0 141, Birkhauser 1997,  to which should be added the
## following info:
## -- the subalgebra H' is generated by:
##  G4: T3, T1 T3 T1^{-1}
##  G5: T2, T3
##  G6: T1, T3
##  G7: T1, T2, T3
## -- there is a misprint in the numerator of the relative degrees of
##    2-dimensional characters: it should read
##        -x1^3 x_2^3 y_1 y_2^3 y_3^4 z_1^2 z_2^2 z_3^4
##    instead of
##        -x1^2 x_2^2 y_1 y_2^3 y_4   z_1^2 z_2^2 z_3^4
##

CHEVIE.AddData("PrintDiagram","G4_7",function(arg)local ST,indices,title,s;
  ST:=arg[1];indices:=arg[2];title:=arg[3];
  Print(title," ");s:=String("",Length(title)-1);
  if   ST=4  then Print(indices[1],"(3)--",indices[2],"(3)\n");
  elif ST=5  then Print(indices[1],"(3)==",indices[2],"(3)\n");
  elif ST=6  then Print(indices[1],"--6--",indices[2],"(3)\n");
  elif ST=7 then Print(indices[2],"(3)\n",
    s," /3\\\n",
    s,indices[1],"---",indices[3],"(3) ",
    IntListToString(indices{[1,2,3]}),"=",
    IntListToString(indices{[2,3,1]}),"=",
    IntListToString(indices{[3,1,2]}),"\n");
  fi;
end);

CHEVIE.AddData("BraidRelations","G4_7",function(ST)
  if ST=4 then return [[[1,2,1],[2,1,2]]];
  elif ST=5 then return [[[1,2,1,2],[2,1,2,1]]];
  elif ST=6 then return [[[1,2,1,2,1,2],[2,1,2,1,2,1]]];
  elif ST=7 then return [[[1,2,3],[2,3,1]],[[1,2,3],[3,1,2]]];
  fi;
end);

CHEVIE.AddData("ReflectionName","G4_7",function(arg)local n,option;
  option:=arg[Length(arg)];n:=arg[1];
  if IsBound(option.TeX) then n:=SPrint("G_{",n,"}");else n:=SPrint("G",n);fi;
  if Length(arg)=3 then PrintToString(n,"(",Format(arg[2],option),")");fi;
  return n;end);

CHEVIE.AddData("Size","G4_7",
  function(n)local s;s:=24*[1,3,2,6];return s[n-3];end);

CHEVIE.AddData("NrConjugacyClasses","G4_7", 
  function(n)local l;l:=7*[1,3,2,6];return l[n-3];end);

CHEVIE.AddData("paramclasses","G4_7",
               Concatenation(List([[1,12],[2,6],[3,12],[4,12]],
				i->List([1..i[2]]-1,j->[i[1],j]))));

CHEVIE.AddData("GeneratingRoots","G4_7",function(n)local l;
  l:=[[[0,-2*E(3)-E(3)^2], [2*E(3)^2,E(3)^2]],
      [[0,(3-ER(-3))/2],[-1,1]],
      [[-1+ER(3),-1],[0,(3-ER(-3))/2]],
      [[0,1],[(-E(12)^11-E(12)^8-2*E(12)^4)/2,(-1-ER(-3))*(-E(4)+1)/4],
       [(-E(12)^11-E(12)^8-2*E(12)^4)/2,(1+ER(-3))*(E(4)+1)/4]]];
  return l[n-3];
end);

CHEVIE.AddData("GeneratingCoRoots","G4_7",function(n)local l;
  l:=[[[0,1], [ER(-3)/3,ER(-3)/3]],
      [[0,1],[(-3+ER(-3))/6,(3-ER(-3))/3]],
      [[ER(3)/3,(-3-ER(3))/3],[0,1]],
      [[0,2],[1,(-1-ER(3))*(-E(4)+1)/2],[1,(-1-ER(3))*(E(4)+1)/2]]];
  return l[n-3];
end);

CHEVIE.AddData("CartanMat", "G4_7",function(n)
  return CHEVIE.RawData("GeneratingCoRoots","G4_7")(n)*
  TransposedMat(CHEVIE.RawData("GeneratingRoots","G4_7")(n));
  end);

CHEVIE.AddData("EigenvaluesGeneratingReflections","G4_7",function(n)local l;
  l:=[[1/3,1/3],[1/3,1/3],[1/2,1/3],[1/2,1/3,1/3]];
  return l[n-3];
end);

CHEVIE.AddData("ReflectionCoDegrees","G4_7",function(n)local l;
  l:=[[0,2],[0,6],[0,8],[0,12]];
  return l[n-3];
end);

CHEVIE.AddData("ReflectionDegrees","G4_7",function(n)local l;
  l:=[[4,6],[6,12],[4,12],[12,12]];
  return l[n-3];
end);

CHEVIE.AddData("PowerMaps","G4_7",function(n)local l,res,i;
  l:=CHEVIE.RawData("ClassInfo","G4_7")(n).indexclasses;
  res:=[,[1,3,5,7,9,11,1,3,5,7,9,11,1,3,5,7,9,11,39,41,31,33,35,37,39,41,31,
	  33,35,37,27,29,19,21,23,25,27,29,19,21,23,25],
	 [1,4,7,10,1,4,7,10,1,4,7,10,13,16,13,16,13,16,1,4,7,10,1,4,7,10,1,
	  4,7,10,1,4,7,10,1,4,7,10,1,4,7,10],,
	 [1,6,11,4,9,2,7,12,5,10,3,8,13,18,17,16,15,14,39,32,37,42,35,40,
	  33,38,31,36,41,34,27,20,25,30,23,28,21,26,19,24,29,22],,
	 [1,8,3,10,5,12,7,2,9,4,11,6,13,14,15,16,17,18,19,26,21,28,23,30,
	  25,20,27,22,29,24,31,38,33,40,35,42,37,32,39,34,41,36],,,,
	 [1,12,11,10,9,8,7,6,5,4,3,2,13,18,17,16,15,14,39,38,37,36,35,34,33,
	  32,31,42,41,40,27,26,25,24,23,22,21,20,19,30,29,28]];
  for i in [1..Length(res)] do
    if IsBound(res[i]) then
      res[i]:=List(res[i]{l},x->Position(l,x));
      if res[i]=[1..Length(l)] or res[i] in SublistUnbnd(res,[1..i-1]) then
         Unbind(res[i]);fi;
    fi;
  od;
  return res;
end);

CHEVIE.AddData("ClassInfo","G4_7",function(n)local res,p,g,m,f,digits;
  p:=CHEVIE.RawData("paramclasses","G4_7");
  res:=rec();
  g:=function(c,a,b)return c[2] mod a=b[c[1]];end;
  f:=function(class,z)local res,i;
    res:=[[],[1],[2],[3]];res:=res[class[1]];
    for i in [1..class[2]] do Append(res,z);od;
    return res;
  end;
  if n=4 then 
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],6,[0,3,2,0]));
    res.classtext:=List(p{res.indexclasses},
                  x->Replace(f(x,[3,1]),[2],[],[1,3,1],[2],[3],[1]));
    m:="121212";
  elif n=5 then 
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],2,[0,1,0,0]));
    res.classtext:=List(p{res.indexclasses},
                  x->Replace(f(x,[2,3]),[1],[],[2],[1],[3],[2]));
    m:="1212";
  elif n=6 then 
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],3,[0,0,2,0]));
    res.classtext:=List(p{res.indexclasses},
                  x->Replace(f(x,[3,1]),[2],[],[3],[2]));
    m:="212121";
  elif n=7 then 
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],1,[0,0,0,0]));
    res.classtext:=List(p{res.indexclasses},x->f(x,[1,2,3]));
    m:="123";
  fi;
  digits:="123"; 
  res.classnames:=List(res.classtext,function(x)local res;
    res := String(Replace(digits{x},m,"z"));
    if Length(res) = 0 then res := "."; fi;
    return res;
  end);
  m:=[1,6,4,4];res.classes:=List(p{res.indexclasses},x->m[x[1]]);
  m:=[1,12,6,4,3,12,2,12,3,4,6,12,2,12,6,4,6,12,3,12,6,12,3,12,6,12,3,12,6,
      12,3,12,6,12,3,12,6,12,3,12,6,12];
  res.orders:=m{res.indexclasses};
  res.classparams:=res.classnames;
  return res;
end);

CHEVIE.AddData("ParabolicRepresentatives","G4_7",# repr. of conj. classes
  function(n) local l;l:=[[]];
    Append(l,Filtered(CHEVIE.RawData("ClassInfo","G4_7")(n).classtext,
      x->Length(x)=1));
    Add(l,[1..Length(CHEVIE.RawData("GeneratingRoots","G4_7")(n))]);
    return l;
end);

CHEVIE.AddData("CharInfo","G4_7",function(n)local res;
  res:=rec();
  if n=4 then
    res.charparams:=[[1,0],[1,4],[1,8],[2,5],[2,3],[2,1],[3,2]];
    res.extRefl:=[1,6,2];
    res.indexchars:=Concatenation([1..3],[34..37]);
    res.spetsRationality:=[1,1,1,1,1,1,1];
    res.a:=[0,4,4,4,1,1,2];
    res.A:=[0,8,8,8,5,5,6];
  elif n=5 then
    res.charparams:=[[1,0],[1,4,1],[1,8,1],[1,4,2],[1,8,2],[1,12,1],
      [1,8,3],[1,12,2],[1,16],[2,9],[2,7,1],[2,5,1],[2,7,2],
      [2,5,2],[2,3,1],[2,5,3],[2,3,2],[2,1],[3,4],[3,2],[3,6]];
# The labelling above is as follows:
#  The following pairs are conjugate:
# (phi{1,8}'',phi{1,16}) (phi{1,4}',phi{1,8}') (phi{1,4}'',phi{1,8}''')
# (phi{1,12}',phi{1,12}'') (phi{2,5}',phi{2,7}')
# (phi{2,7}'',phi{2,5}''') (phi{2,5}'',phi{2,1}') (phi{2,3}',phi{2,3''})
# The following characters take the following values on the first reflection:
# phi{1,4}'->1, phi{1,12}'->E(3), phi{2,5}'->-1, phi{2,3}'->-E(3)
      res.extRefl:=[1,18,5];
      res.indexchars:=Concatenation([10..27],[37,39,41]);
  elif n=6 then
    res.charparams:=[[1,0],[1,4],[1,8],[1,6],[1,10],[1,14],[2,5,2],
      [2,3,2],[2,3,1],[2,7],[2,1],[2,5,1],[3,2],[3,4]];
# The labelling above is such that the character in a pair with the smallest
# degree of the fakedegree gets a ', the other a ''
      res.extRefl:=[1,11,5];
      res.indexchars:=Concatenation([1..3],[10..12],[19,35,33,28,24,26,37,38]);
      res.spetsRationality:=[1,1,1,1,1,1,2,1,1,2,1,1,1,1];
      res.a:=[0,1,1,1,10,10,5,1,1,5,1,1,1,4];
      res.A:=[0,11,11,11,14,14,13,11,11,13,11,11,11,12];
  elif n=7 then
    res.charparams:=[[1,0],[1,4,1],[1,8,1],[1,4,2],[1,8,2],[1,12,1],[1,8,3],
      [1,12,2],[1,16],[1,6],[1,10,1],[1,14,1],[1,10,2],[1,14,2],[1,18,1],
      [1,14,3],[1,18,2],[1,22],[2,9,1],[2,7,1],[2,11,1],[2,7,2],[2,11,2],
      [2,9,2],[2,11,3],[2,9,3],[2,7,3],[2,15],[2,13,1],[2,5,1],[2,13,2],[2,5,2],
      [2,3,1],[2,5,3],[2,3,2],[2,1],[3,10],[3,4],[3,2],[3,8],[3,6],[3,12]];
      res.extRefl:=[1,36,14];
      res.indexchars:=[1..42];
  fi;
  res.b:=List(res.charparams,x->x[2]);
  return res;
end);
  
CHEVIE.AddData("factors","G4_7",function(n)local f;f:=
[[[1,0],[1,4],[1,8],[1,5,1,7],[1,3,1,5],[1,1,1,3],[1,2,1,4,1,6]],[[1,0],[1,4],
[1,8],[1,4],[1,8],[1,12],[1,8],[1,12],[1,16],[1,9,1,15],[1,7,1,13],[1,5,1,11],
[1,7,1,13],[1,5,1,11],[1,3,1,9],[1,5,1,11],[1,3,1,9],[1,1,1,7],[1,4,2,10],[1,
2,1,8,1,14],[2,6,1,12]],[[1,0],[1,4],[1,8],[1,6],[1,10],[1,14],[1,5,1,13],[1,
3,1,11],[1,3,1,7],[1,7,1,11],[1,1,1,9],[1,5,1,9],[1,2,1,6,1,10],[1,4,1,8,1,
12]],[[1,0],[1,4],[1,8],[1,4],[1,8],[1,12],[1,8],[1,12],[1,16],[1,6],[1,10],
[1,14],[1,10],[1,14],[1,18],[1,14],[1,18],[1,22],[1,9,1,21],[1,7,1,19],[2,11],
[1,7,1,19],[2,11],[2,9],[2,11],[2,9],[2,7],[2,15],[2,13],[1,5,1,17],[2,13],[1,
5,1,17],[1,3,1,15],[1,5,1,17],[1,3,1,15],[1,1,1,13],[3,10],[1,4,2,16],[1,2,2,
14],[2,8,1,20],[2,6,1,18],[3,12]]];
  return f[n-3];
  end);

# The data below was computed by Maria Chlouveraki
CHEVIE.AddData("SchurModels","G4_7",rec(
f1:=rec(coeff:=1,
 vcyc:=[[[1,-1,0,0,0,0,0,0],1],[[1,-1,2,-1,-1,2,-1,-1],1],
  [[0,0,1,-1,0,0,0,0],1],[[0,0,1,0,-1,0,0,0],1],[[0,0,0,0,0,1,-1,0],1],
  [[0,0,0,0,0,1,0,-1],1],[[1,-1,1,-1,0,1,-1,0],1],[[1,-1,1,-1,0,1,0,-1],1],
  [[1,-1,1,0,-1,1,-1,0],1],[[1,-1,1,0,-1,1,0,-1],1]]),
f2:=rec(coeff:=2,factor:=[0,0,-1,0,1,0,0,0],root:=[1,1,0,1,1,0,1,1]/2,
 vcyc:=[[[0,0,1,-1,0,0,0,0],1],[[0,0,-1,0,1,0,0,0],1],[[0,0,0,0,0,-1,1,0],1],
  [[0,0,0,0,0,-1,0,1],1],[[-1,0,-1,0,0,-1,0,0,1],1],[[-1,0,0,0,-1,0,-1,0,1],1],
  [[-1,0,0,0,-1,0,0,-1,1],1],[[0,-1,-1,0,0,-1,0,0,1],1],
  [[0,-1,0,0,-1,0,-1,0,1],1],[[0,-1,0,0,-1,0,0,-1,1],1]]),
f3:=rec(coeff:=3,root:=[2,1,1,1,1,1,1,1]/3,
 vcyc:=[[[-1,1,0,0,0,0,0,0],1],
  [[1,0,1,0,0,1,0,0,-1],1],[[1,0,1,0,0,0,1,0,-1],1],[[1,0,1,0,0,0,0,1,-1],1],
  [[1,0,0,1,0,1,0,0,-1],1],[[1,0,0,1,0,0,1,0,-1],1],[[1,0,0,1,0,0,0,1,-1],1],
  [[1,0,0,0,1,1,0,0,-1],1],[[1,0,0,0,1,0,1,0,-1],1],[[1,0,0,0,1,0,0,1,-1],1]])));

CHEVIE.AddData("paramchars","G4_7",
               Concatenation(Cartesian([1],[1..2],[1..3],[1..3]),
			     Cartesian([2],[1..2],[1..3],[1..3]),
			     Cartesian([3],[1..3],[1..2])));

CHEVIE.AddData("SchurData","G4_7",function(arg)
  return List(CHEVIE.RawData("paramchars","G4_7"),function(char)
  if char[1]=1 then return rec(name:="f1",
    order:=Concatenation([char[2],3-char[2],2+char[3]],
    2+Difference([1..3],[char[3]]),[5+char[4]],5+Difference([1..3],[char[4]])));
  elif char[1]=2 then return rec(name:="f2",
    order:=Concatenation([1,2,2+char[3]],2+Difference([1..3],[char[3]]),
       [5+char[4]],5+Difference([1..3],[char[4]])),
       rootPower:=(-1)^char[2]);
  elif char[1]=3 then return rec(name:="f3",
    order:=Concatenation([char[3]],Difference([1..2],[char[3]]),[3..8]),
    rootPower:=E(3)^char[2]);
  fi;
  end);
end);

CHEVIE.AddData("GetParams","G4_7",function(n,para)
  if   n=4 then return [[1,-1],[1,E(3),E(3)^2],para[1]];
  elif n=5 then return [[1,-1],para[1],para[2]];
  elif n=6 then return [para[1],[1,E(3),E(3)^2],para[2]];
  elif n=7 then return para;
  fi;
end);

CHEVIE.AddData("Generic","G4_7",7);

CHEVIE.AddData("HeckeCharTable","G4_7",function(n,para,root)
  local X,Y,Z,classes,GenericRow,res,ci;
  X:=CHEVIE.RawData("GetParams","G4_7")(n,para);Z:=X[3];Y:=X[2];X:=X[1];
  GenericRow:=function(char)local l;
    if char[1]=1 then l:=[1,X[char[2]],Y[char[3]],Z[char[4]]];
      return List(classes,class->l[class[1]]*Product(l)^class[2]);
    fi;
    if char[1]=2 then
     l:=[[2],X,Y{Difference([1..3],[char[3]])},Z{Difference([1..3],[char[4]])}];
    elif char[1]=3 then l:=[[3],X{[1,2,char[3]]},Y,Z];
    fi;
    return G4_22Helper(List(classes,class->Sum(l[class[1]])),
      List(classes,c->c[2]),Product(l{[2..4]},Product),char[1],char[2]);
  end;
  res:=rec(name:=SPrint("H(G",n,")"),ST:=n,
    parameter:=para,
    degrees:=CHEVIE.RawData("ReflectionDegrees","G4_7")(n),
    dim:=2,
    reflclasses:=[3],
    powermap:=CHEVIE.RawData("PowerMaps","G4_7")(n));
  Inherit(res,CHEVIE.RawData("ClassInfo","G4_7")(n));
  classes:=CHEVIE.RawData("paramclasses","G4_7"){res.indexclasses};
  res.size:=Product(res.degrees); res.order:=res.size;
  res.identifier:=res.name;
  res.centralizers:=List(res.classes,x->res.size/x);
  ci:=CHEVIE.RawData("CharInfo","G4_7")(n);
  res.irredinfo:=List(ci.charparams,x->rec(charparam:=x,
    charname:=CHEVIE.RawData("CharName","G4_7")(n,x,rec())));
  ci:=G4_22Test(res,List(CHEVIE.RawData("paramchars","G4_7"),GenericRow)*
    Product(para,Product)^0,ci.indexchars);
  if ci<>true then res.indexchars:=ci;fi;
  return CHEVIE.compat.MakeCharacterTable(res);
end);

CHEVIE.AddData("CharTable","G4_7",function(n)local para;
  para:=CHEVIE.RawData("EigenvaluesGeneratingReflections","G4_7")(n);
  para:=List(para,x->List([0..1/x-1],j->E(1/x)^j));
  return CHEVIE.RawData("HeckeCharTable","G4_7")(n,para,[]);
end);

CHEVIE.AddData("Rep2","G4_7",function(X,Y,Z,root)local r;
  r:=(-1)^root*GetRoot(Product(X)*Product(Y)*Product(Z),2);
# Print("r=",r,"\n");
  return [[[X[1],Sum(Y,x->1/x)-Sum(Z)*X[2]/r],[0,X[2]]],[[Sum(Y),1/X[1]],
    [-Product(Y)*X[1],0]],[[0,-r/Product(Y)/Product(X)],[r,Sum(Z)]]];
end);

CHEVIE.AddData("Rep3","G4_7",function(X,Y,Z,root)local r,x1,x2,a,z1;
  x1:=X[1];x2:=X[2];z1:=Z[1];
  r:=E(3)^root*GetRoot(x1^2*x2*Product(Y)*Product(Z),3);
  a:=Sum(Y)*r/x1-Product(Y)*Sum(Y,y->1/y)*z1
    +Product(Y)*(x1*z1^2-x2*Product(Z)/z1)/r;
  return [[[x1,0,-Product(Z)*Sum(Z,z->1/z)*x2*x1/z1+Sum(Y)*r^2/Product(Y)/z1],
    [0, x1, a/Product(Y)/z1*r^2], [0, 0, x2]],
    [[Sum(Y)-r/x1/z1, 1/z1, r], [a,r/x1/z1, 0],[-Product(Y)*x1*z1/r^2, 0, 0]],
    [[0, 0, -x1*Product(Z)/z1], [0, z1, 0], [1/x1, -1/r, Sum(Z)-z1]]];
end);

CHEVIE.AddData("HeckeRepresentation","G4_7",function(n,para,root,i)
  local X,Y,Z,v,rep,m,ci;
  X:=CHEVIE.RawData("GetParams","G4_7")(n,para);Z:=X[3];Y:=X[2];X:=X[1];
  rep:=function(char)
    if char[1]=1 then return [[[X[char[2]]]],[[Y[char[3]]]],[[Z[char[4]]]]];
    elif char[1]=2 then
      Z:=Z{Difference([1..3],[char[4]])};
      if n=4 then return [[[0,-Z[2]],[Z[1],0]],[[0,0],[0,0]],[[Z[2],Z[2]],
                          [0,Z[1]]]];
      else return CHEVIE.RawData("Rep2","G4_7")(X,
         Y{Difference([1..3],[char[3]])},Z,char[2]);
      fi;
    else X:=X{[char[3],3-char[3]]};
      if n=4 then return [[[0,0,1],[0,-1,0],[1,0,0]],[[0,0,0],[0,0,0],[0,0,0]],
        [[Z[1],-1,Z[2]],[0,Z[2],-(Z[3]*Z[1]+Z[2]^2)],[0,0,Z[3]]]];
      elif n=6 then return [[[X[2],0,0],[-X[2]*Z[3]-X[1]*Z[1]-X[1]*Z[2],X[1],0],
        [X[2]*Z[3]*Z[1]-X[1]*Z[2]^2,0,X[1]]], [[0,0,0],[0,0,0],[0,0,0]],
	[[Z[3],1,0],[0,Z[1],1],[0,0,Z[2]]]];
      elif n in [5,7] then return CHEVIE.RawData("Rep3","G4_7")(X,Y,Z,char[2]);
      fi;
    fi;
  end;
  ci:=G4_22FetchIndexChars(n,para)[i];
  m:=rep(CHEVIE.RawData("paramchars","G4_7")[ci])+0*Product(para,Product);
  if n=4 then return [m[1]*m[3]*m[1]^-1,m[3]];
  elif n=5 then return m{[2,3]};
  elif n=6 then return m{[1,3]};
  elif n=7 then return m;
  fi;
end);

CHEVIE.AddData("Representation","G4_7",function(ST,i)local para;
  para:=CHEVIE.RawData("EigenvaluesGeneratingReflections","G4_7")(ST);
  para:=List(para,x->List([0..1/x-1],j->E(1/x)^j));
  return CHEVIE.RawData("HeckeRepresentation","G4_7")(ST,para,i);
end);

CHEVIE.AddData("UnipotentCharacters","G4_7",function(n)local r3,I;
  if n=4 then
  return rec(
  harishChandra:=[
    rec(relativeType:=rec(series:="ST",indices:=[1..2],rank:=2,ST:=4),
        levi:=[],parameterExponents:=[1,1],
        charNumbers:=[1..7], eigenvalue:=1, cuspidalName:=""),
    rec(relativeType:=rec(series:="A",indices:=[2],rank:=1),
        levi:=[1], parameterExponents:=[3],
	charNumbers:=[9,8], eigenvalue:=E(3)^2,
	cuspidalName:=ImprimitiveCuspidalName([[],[0,1],[0,1]])),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[10], eigenvalue:=-1,
        cuspidalName:="G_4")],
  families:=[
    Family("C1",[1]),
    Family(CHEVIE.families.X(3),[6,5,8],rec(delta1:=[1,1,-1])),
    Family("C1",[7]),
    Family("X5",[2,4,10,9,3],rec(delta1:=[1,1,-1,-1,1]))],
    a:=[ 0, 4, 4, 4, 1, 1, 2, 1, 4, 4 ],
    A:=[ 0, 8, 8, 8, 5, 5, 6, 5, 8, 8 ]);
 elif n=6 then
  I:=E(4);r3:=-I*ER(-3);
  return rec(
  harishChandra:=[
    rec(relativeType:=rec(series:="ST",indices:=[1..2],rank:=2,ST:=6),
        levi:=[],parameterExponents:=[1,1],
        charNumbers:=[ 1, 2, 3, 4, 5, 6, 12, 10, 8, 11, 7, 9, 13, 14 ],
	eigenvalue:=1, cuspidalName:=""),
    rec(relativeType:=rec(series:="ST",indices:=[1],rank:=1,p:=4,q:=1),
        levi:=[2], parameterExponents:=[[3,3,0,3]],
	charNumbers:=[15,17,31,16], eigenvalue:=E(3)^2,
	cuspidalName:=ImprimitiveCuspidalName([[],[0,1],[0,1]])),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
      charNumbers:=[18], eigenvalue:=-E(3)^2, cuspidalName:="G_6[-\\zeta_3^2]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[19], eigenvalue:=-E(3)^2, 
	cuspidalName:="G_6^2[-\\zeta_3^2]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[20], eigenvalue:=-1, cuspidalName:="G_6[-1]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[21], eigenvalue:=-1, cuspidalName:="G_6^2[-1]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[22], eigenvalue:=-1,
        cuspidalName:="G_6^3[-1]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[23], eigenvalue:=-1,
        cuspidalName:="G_6^4[-1]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[24], eigenvalue:=I,
	cuspidalName:="G_6[i]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[25], eigenvalue:=I,  cuspidalName:="G_6^2[i]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[26], eigenvalue:=-I, cuspidalName:="G_6[-i]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[27], eigenvalue:=-I,
        cuspidalName:="G_6^2[-i]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[28], eigenvalue:=E(12)^5, 
        cuspidalName:="G_6[\\zeta_{12}^5]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[29], eigenvalue:=E(8)^3, qEigen:=1/2,  
        cuspidalName:="G_6[\\zeta_8^3]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..2], parameterExponents:=[],
	charNumbers:=[30], eigenvalue:=E(8)^7, qEigen:=1/2, 
        cuspidalName:="G_6[\\zeta_8^7]"),
	],
    families:=[ Family("C1",[1]),Family(ComplexConjugate(
      SubFamilyij(CHEVIE.families.X(12),1,3,(3+ER(-3))/2)),
	 [7,13,8,2,27,21,24,18,15,19,10,25,22,3,9,17,28,20,4,26,16,23],
	 rec(delta1:=[1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,-1,1,-1,-1,-1,1],
	 cospecial:=11)),
      Family("C1",[14]),
      Family("Z4",[29,12,30,11],rec(delta1:=[-1,1,1,-1])),
      Family(CHEVIE.families.X(3),[5,6,31],rec(delta1:=[1,1,-1]))],
      a:=[0,1,1,1,10,10,1,1,1,1,5,5,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,10],
      A:=[0,11,11,11,14,14,11,11,11,11,13,13,11,12,11,11,11,11,11,11,11,11,
          11,11,11,11,11,11,13,13,14]);
  else
   return false;
  fi;
end);

CHEVIE.AddData("Invariants","G4_7",function(n)local i;
  i:=[[function(x1,x2) return x1^4-8*x1*x2^3;end,
   function(x1,x2) return x1^6+20*x1^3*x2^3-8*x2^6;end],
  [function(x1,x2) return x1^6+20*x1^3*x2^3-8*x2^6;end,
   function(x1,x2) return 3*x1^3*x2^9+3*x1^6*x2^6+x1^9*x2^3+x2^12;end],
  [function(x1,x2) return 8*x1*x2^3+x1^4;end,
   function(x1,x2) return -3*x1^3*x2^9+3*x1^6*x2^6-x1^9*x2^3+x2^12;end],
  [function(x1,x2) return x1^10*x2^2-2*x1^6*x2^6+x1^2*x2^10;end,
   function(x1,x2) return  x1^12-33*x1^8*x2^4-33*x1^4*x2^8+x2^12;end]];
  return i[n-3];
 end);

# the discriminant as a polynomial in the invariants
CHEVIE.AddData("Discriminant","G4_7",function(n)local d;
   d:=[ function(t1,t2) return -t2^2+t1^3;end,
	function(t1,t2) return 64*t2^2-t1^2*t2;end,
	function(t1,t2) return 64*t2^2+t1^3*t2;end,
	function(t1,t2) return t2^2*t1+108*t1^3;end];
  return d[n-3];
end);

CHEVIE.AddData("phi","2G5",
( 1, 2)( 3, 6)( 4, 5)( 7,12)( 8,11)( 9,16)(10,15)(13,22)(14,21)(17,26)(18,25)
(19,30)(20,29)(23,24)(27,37)(28,36)(31,40)(32,42)(33,39)(34,38)(35,41)(43,46)
(44,48)(45,47));

CHEVIE.AddData("PhiFactors","2G5",[1,-1]);

CHEVIE.AddData("NrConjugacyClasses","2G5",9);

CHEVIE.AddData("ClassInfo","2G5",function()local res;
  res:=rec(classtext:=[[],[1,2,2,1,2,2,1],[1,2,2,1,2,2,1,1],[1],[1,1,2,1,1],
   [1,1,2,2,1,1],[1,2],[1,2,1],[2,1,2,1]],
    classes:=[12,6,6,6,12,6,6,6,12],
    orders:=[2,24,24,24,6,8,24,8,6]);
  res.classnames:=List(res.classtext,IntListToString);
  return res;
end);

CHEVIE.AddData("CharInfo","2G5",function()local res;
  res:=rec(charparams:=[[1,0],[1,8,2],[1,16],[2,9],[2,5,2],[2,1],
    [3,2],[3,4],[3,6]],
    extRefl:=[1,6,2],
    b:=[0,8,16,9,5,1,2,4,12],
    B:=[0,8,16,15,11,7,14,4,12]
    );
  return res;
end);

CHEVIE.AddData("CharTable","2G5",function()local res;
  res:=rec(identifier:="2G5",
   size:=72,
   centralizers:=[6,12,12,12,6,12,12,12,6],
   irreducibles:=[[1,1,1,1,1,1,1,1,1],
   -[1,E(3),E(3)^2,E(3),E(3)^2,1,E(3)^2,1,E(3)],
   [1,E(3)^2,E(3),E(3)^2,E(3),1,E(3),1,E(3)^2],
   [0,ER(-2),-ER(-2),-ER(-2),0,ER(-2),ER(-2),-ER(-2),0],
   [0,-ER(-2)*E(3),ER(-2)*E(3)^2,ER(-2)*E(3),0,-ER(-2),-ER(-2)*E(3)^2,ER(-2),0],
   -[0,ER(-2)*E(3)^2,-ER(-2)*E(3),-ER(-2)*E(3)^2,0,ER(-2),ER(-2)*E(3),-ER(-2),0],
   [1,-E(3),-E(3)^2,-E(3),E(3)^2,-1,-E(3)^2,-1,E(3)],
   [1,-E(3)^2,-E(3),-E(3)^2,E(3),-1,-E(3),-1,E(3)^2],
   [1,-1,-1,-1,1,-1,-1,-1,1]]);
  return CHEVIE.compat.MakeCharacterTable(res);
end);
